# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import JsonSchemaDocument

class ActionOutput(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ActionOutput - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'success_schema': 'JsonSchemaDocument',
            'success_schema_uri': 'str',
            'error_schema': 'JsonSchemaDocument',
            'error_schema_uri': 'str',
            'success_schema_flattened': 'JsonSchemaDocument',
            'error_schema_flattened': 'object'
        }

        self.attribute_map = {
            'success_schema': 'successSchema',
            'success_schema_uri': 'successSchemaUri',
            'error_schema': 'errorSchema',
            'error_schema_uri': 'errorSchemaUri',
            'success_schema_flattened': 'successSchemaFlattened',
            'error_schema_flattened': 'errorSchemaFlattened'
        }

        self._success_schema = None
        self._success_schema_uri = None
        self._error_schema = None
        self._error_schema_uri = None
        self._success_schema_flattened = None
        self._error_schema_flattened = None

    @property
    def success_schema(self) -> 'JsonSchemaDocument':
        """
        Gets the success_schema of this ActionOutput.
        JSON schema that defines the transformed, successful result that will be sent back to the caller. If the 'flatten' query parameter is omitted or false, this field will be returned. Either successSchema or successSchemaFlattened will be returned, not both.

        :return: The success_schema of this ActionOutput.
        :rtype: JsonSchemaDocument
        """
        return self._success_schema

    @success_schema.setter
    def success_schema(self, success_schema: 'JsonSchemaDocument') -> None:
        """
        Sets the success_schema of this ActionOutput.
        JSON schema that defines the transformed, successful result that will be sent back to the caller. If the 'flatten' query parameter is omitted or false, this field will be returned. Either successSchema or successSchemaFlattened will be returned, not both.

        :param success_schema: The success_schema of this ActionOutput.
        :type: JsonSchemaDocument
        """
        

        self._success_schema = success_schema

    @property
    def success_schema_uri(self) -> str:
        """
        Gets the success_schema_uri of this ActionOutput.
        URI to retrieve success schema

        :return: The success_schema_uri of this ActionOutput.
        :rtype: str
        """
        return self._success_schema_uri

    @success_schema_uri.setter
    def success_schema_uri(self, success_schema_uri: str) -> None:
        """
        Sets the success_schema_uri of this ActionOutput.
        URI to retrieve success schema

        :param success_schema_uri: The success_schema_uri of this ActionOutput.
        :type: str
        """
        

        self._success_schema_uri = success_schema_uri

    @property
    def error_schema(self) -> 'JsonSchemaDocument':
        """
        Gets the error_schema of this ActionOutput.
        JSON schema that defines the body of response when request is not successful. If the 'flatten' query parameter is omitted or false, this field will be returned. Either errorSchema or errorSchemaFlattened will be returned, not both.

        :return: The error_schema of this ActionOutput.
        :rtype: JsonSchemaDocument
        """
        return self._error_schema

    @error_schema.setter
    def error_schema(self, error_schema: 'JsonSchemaDocument') -> None:
        """
        Sets the error_schema of this ActionOutput.
        JSON schema that defines the body of response when request is not successful. If the 'flatten' query parameter is omitted or false, this field will be returned. Either errorSchema or errorSchemaFlattened will be returned, not both.

        :param error_schema: The error_schema of this ActionOutput.
        :type: JsonSchemaDocument
        """
        

        self._error_schema = error_schema

    @property
    def error_schema_uri(self) -> str:
        """
        Gets the error_schema_uri of this ActionOutput.
        URI to retrieve error schema

        :return: The error_schema_uri of this ActionOutput.
        :rtype: str
        """
        return self._error_schema_uri

    @error_schema_uri.setter
    def error_schema_uri(self, error_schema_uri: str) -> None:
        """
        Sets the error_schema_uri of this ActionOutput.
        URI to retrieve error schema

        :param error_schema_uri: The error_schema_uri of this ActionOutput.
        :type: str
        """
        

        self._error_schema_uri = error_schema_uri

    @property
    def success_schema_flattened(self) -> 'JsonSchemaDocument':
        """
        Gets the success_schema_flattened of this ActionOutput.
        JSON schema that defines the transformed, successful result that will be sent back to the caller. The schema is transformed based on Architect's flattened format. If the 'flatten' query parameter is supplied as true, this field will be returned. Either successSchema or successSchemaFlattened will be returned, not both.

        :return: The success_schema_flattened of this ActionOutput.
        :rtype: JsonSchemaDocument
        """
        return self._success_schema_flattened

    @success_schema_flattened.setter
    def success_schema_flattened(self, success_schema_flattened: 'JsonSchemaDocument') -> None:
        """
        Sets the success_schema_flattened of this ActionOutput.
        JSON schema that defines the transformed, successful result that will be sent back to the caller. The schema is transformed based on Architect's flattened format. If the 'flatten' query parameter is supplied as true, this field will be returned. Either successSchema or successSchemaFlattened will be returned, not both.

        :param success_schema_flattened: The success_schema_flattened of this ActionOutput.
        :type: JsonSchemaDocument
        """
        

        self._success_schema_flattened = success_schema_flattened

    @property
    def error_schema_flattened(self) -> object:
        """
        Gets the error_schema_flattened of this ActionOutput.
        JSON schema that defines the body of response when request is not successful. The schema is transformed based on Architect's flattened format. If the 'flatten' query parameter is supplied as true, this field will be returned. Either errorSchema or errorSchemaFlattened will be returned, not both.

        :return: The error_schema_flattened of this ActionOutput.
        :rtype: object
        """
        return self._error_schema_flattened

    @error_schema_flattened.setter
    def error_schema_flattened(self, error_schema_flattened: object) -> None:
        """
        Sets the error_schema_flattened of this ActionOutput.
        JSON schema that defines the body of response when request is not successful. The schema is transformed based on Architect's flattened format. If the 'flatten' query parameter is supplied as true, this field will be returned. Either errorSchema or errorSchemaFlattened will be returned, not both.

        :param error_schema_flattened: The error_schema_flattened of this ActionOutput.
        :type: object
        """
        

        self._error_schema_flattened = error_schema_flattened

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

