# coding: utf-8

"""
IntegrationsApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import Action
from ..models import ActionEntityListing
from ..models import BotConnectorBot
from ..models import BotConnectorBotSummaryEntityListing
from ..models import BotConnectorBotVersionSummaryEntityListing
from ..models import BotList
from ..models import CategoryEntityListing
from ..models import ClientAppEntityListing
from ..models import CreateIntegrationRequest
from ..models import Credential
from ..models import CredentialInfo
from ..models import CredentialInfoListing
from ..models import CredentialTypeListing
from ..models import DialogflowAgent
from ..models import DialogflowAgentSummaryEntityListing
from ..models import DraftValidationResult
from ..models import ErrorBody
from ..models import Integration
from ..models import IntegrationConfiguration
from ..models import IntegrationEntityListing
from ..models import IntegrationType
from ..models import IntegrationTypeEntityListing
from ..models import JsonSchemaDocument
from ..models import LexBotAlias
from ..models import LexBotAliasEntityListing
from ..models import LexBotEntityListing
from ..models import PostActionInput
from ..models import PublishDraftInput
from ..models import TestExecutionResult
from ..models import TtsEngineEntity
from ..models import TtsEngineEntityListing
from ..models import TtsSettings
from ..models import TtsVoiceEntity
from ..models import TtsVoiceEntityListing
from ..models import UCIntegrationListing
from ..models import UpdateActionInput
from ..models import UpdateDraftInput
from ..models import UserAppEntityListing

class IntegrationsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_integration(self, integration_id: str, **kwargs) -> 'Integration':
        """
        Delete integration.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_integration(integration_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str integration_id: Integration Id (required)
        :return: Integration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['integration_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_integration" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'integration_id' is set
        if ('integration_id' not in params) or (params['integration_id'] is None):
            raise ValueError("Missing the required parameter `integration_id` when calling `delete_integration`")


        resource_path = '/api/v2/integrations/{integrationId}'.replace('{format}', 'json')
        path_params = {}
        if 'integration_id' in params:
            path_params['integrationId'] = params['integration_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Integration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_integrations_action(self, action_id: str, **kwargs) -> None:
        """
        Delete an Action
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_integrations_action(action_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_id: actionId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_integrations_action" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_id' is set
        if ('action_id' not in params) or (params['action_id'] is None):
            raise ValueError("Missing the required parameter `action_id` when calling `delete_integrations_action`")


        resource_path = '/api/v2/integrations/actions/{actionId}'.replace('{format}', 'json')
        path_params = {}
        if 'action_id' in params:
            path_params['actionId'] = params['action_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_integrations_action_draft(self, action_id: str, **kwargs) -> None:
        """
        Delete a Draft
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_integrations_action_draft(action_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_id: actionId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_integrations_action_draft" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_id' is set
        if ('action_id' not in params) or (params['action_id'] is None):
            raise ValueError("Missing the required parameter `action_id` when calling `delete_integrations_action_draft`")


        resource_path = '/api/v2/integrations/actions/{actionId}/draft'.replace('{format}', 'json')
        path_params = {}
        if 'action_id' in params:
            path_params['actionId'] = params['action_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_integrations_credential(self, credential_id: str, **kwargs) -> None:
        """
        Delete a set of credentials
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_integrations_credential(credential_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str credential_id: Credential ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['credential_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_integrations_credential" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'credential_id' is set
        if ('credential_id' not in params) or (params['credential_id'] is None):
            raise ValueError("Missing the required parameter `credential_id` when calling `delete_integrations_credential`")


        resource_path = '/api/v2/integrations/credentials/{credentialId}'.replace('{format}', 'json')
        path_params = {}
        if 'credential_id' in params:
            path_params['credentialId'] = params['credential_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integration(self, integration_id: str, **kwargs) -> 'Integration':
        """
        Get integration.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integration(integration_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str integration_id: Integration Id (required)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :return: Integration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['integration_id', 'page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integration" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'integration_id' is set
        if ('integration_id' not in params) or (params['integration_id'] is None):
            raise ValueError("Missing the required parameter `integration_id` when calling `get_integration`")


        resource_path = '/api/v2/integrations/{integrationId}'.replace('{format}', 'json')
        path_params = {}
        if 'integration_id' in params:
            path_params['integrationId'] = params['integration_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Integration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integration_config_current(self, integration_id: str, **kwargs) -> 'IntegrationConfiguration':
        """
        Get integration configuration.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integration_config_current(integration_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str integration_id: Integration Id (required)
        :return: IntegrationConfiguration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['integration_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integration_config_current" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'integration_id' is set
        if ('integration_id' not in params) or (params['integration_id'] is None):
            raise ValueError("Missing the required parameter `integration_id` when calling `get_integration_config_current`")


        resource_path = '/api/v2/integrations/{integrationId}/config/current'.replace('{format}', 'json')
        path_params = {}
        if 'integration_id' in params:
            path_params['integrationId'] = params['integration_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='IntegrationConfiguration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations(self, **kwargs) -> 'IntegrationEntityListing':
        """
        List integrations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :return: IntegrationEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/integrations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='IntegrationEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_action(self, action_id: str, **kwargs) -> 'Action':
        """
        Retrieves a single Action matching id.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_action(action_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_id: actionId (required)
        :param str expand: Indicates a field in the response which should be expanded.
        :param bool include_config: Return config in response.
        :return: Action
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_id', 'expand', 'include_config']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_action" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_id' is set
        if ('action_id' not in params) or (params['action_id'] is None):
            raise ValueError("Missing the required parameter `action_id` when calling `get_integrations_action`")


        resource_path = '/api/v2/integrations/actions/{actionId}'.replace('{format}', 'json')
        path_params = {}
        if 'action_id' in params:
            path_params['actionId'] = params['action_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'include_config' in params:
            query_params['includeConfig'] = params['include_config']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Action',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_action_draft(self, action_id: str, **kwargs) -> 'Action':
        """
        Retrieve a Draft
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_action_draft(action_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_id: actionId (required)
        :param str expand: Indicates a field in the response which should be expanded.
        :param bool include_config: Return config in response.
        :return: Action
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_id', 'expand', 'include_config']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_action_draft" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_id' is set
        if ('action_id' not in params) or (params['action_id'] is None):
            raise ValueError("Missing the required parameter `action_id` when calling `get_integrations_action_draft`")


        resource_path = '/api/v2/integrations/actions/{actionId}/draft'.replace('{format}', 'json')
        path_params = {}
        if 'action_id' in params:
            path_params['actionId'] = params['action_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'include_config' in params:
            query_params['includeConfig'] = params['include_config']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Action',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_action_draft_schema(self, action_id: str, file_name: str, **kwargs) -> 'JsonSchemaDocument':
        """
        Retrieve schema for a Draft based on filename.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_action_draft_schema(action_id, file_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_id: actionId (required)
        :param str file_name: Name of schema file to be retrieved for this draft. (required)
        :return: JsonSchemaDocument
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_id', 'file_name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_action_draft_schema" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_id' is set
        if ('action_id' not in params) or (params['action_id'] is None):
            raise ValueError("Missing the required parameter `action_id` when calling `get_integrations_action_draft_schema`")
        # verify the required parameter 'file_name' is set
        if ('file_name' not in params) or (params['file_name'] is None):
            raise ValueError("Missing the required parameter `file_name` when calling `get_integrations_action_draft_schema`")


        resource_path = '/api/v2/integrations/actions/{actionId}/draft/schemas/{fileName}'.replace('{format}', 'json')
        path_params = {}
        if 'action_id' in params:
            path_params['actionId'] = params['action_id']
        if 'file_name' in params:
            path_params['fileName'] = params['file_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JsonSchemaDocument',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_action_draft_template(self, action_id: str, file_name: str, **kwargs) -> str:
        """
        Retrieve templates for a Draft based on filename.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_action_draft_template(action_id, file_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_id: actionId (required)
        :param str file_name: Name of template file to be retrieved for this action draft. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_id', 'file_name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_action_draft_template" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_id' is set
        if ('action_id' not in params) or (params['action_id'] is None):
            raise ValueError("Missing the required parameter `action_id` when calling `get_integrations_action_draft_template`")
        # verify the required parameter 'file_name' is set
        if ('file_name' not in params) or (params['file_name'] is None):
            raise ValueError("Missing the required parameter `file_name` when calling `get_integrations_action_draft_template`")


        resource_path = '/api/v2/integrations/actions/{actionId}/draft/templates/{fileName}'.replace('{format}', 'json')
        path_params = {}
        if 'action_id' in params:
            path_params['actionId'] = params['action_id']
        if 'file_name' in params:
            path_params['fileName'] = params['file_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_action_draft_validation(self, action_id: str, **kwargs) -> 'DraftValidationResult':
        """
        Validate current Draft configuration.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_action_draft_validation(action_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_id: actionId (required)
        :return: DraftValidationResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_action_draft_validation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_id' is set
        if ('action_id' not in params) or (params['action_id'] is None):
            raise ValueError("Missing the required parameter `action_id` when calling `get_integrations_action_draft_validation`")


        resource_path = '/api/v2/integrations/actions/{actionId}/draft/validation'.replace('{format}', 'json')
        path_params = {}
        if 'action_id' in params:
            path_params['actionId'] = params['action_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DraftValidationResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_action_schema(self, action_id: str, file_name: str, **kwargs) -> 'JsonSchemaDocument':
        """
        Retrieve schema for an action based on filename.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_action_schema(action_id, file_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_id: actionId (required)
        :param str file_name: Name of schema file to be retrieved for this action. (required)
        :return: JsonSchemaDocument
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_id', 'file_name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_action_schema" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_id' is set
        if ('action_id' not in params) or (params['action_id'] is None):
            raise ValueError("Missing the required parameter `action_id` when calling `get_integrations_action_schema`")
        # verify the required parameter 'file_name' is set
        if ('file_name' not in params) or (params['file_name'] is None):
            raise ValueError("Missing the required parameter `file_name` when calling `get_integrations_action_schema`")


        resource_path = '/api/v2/integrations/actions/{actionId}/schemas/{fileName}'.replace('{format}', 'json')
        path_params = {}
        if 'action_id' in params:
            path_params['actionId'] = params['action_id']
        if 'file_name' in params:
            path_params['fileName'] = params['file_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JsonSchemaDocument',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_action_template(self, action_id: str, file_name: str, **kwargs) -> str:
        """
        Retrieve text of templates for an action based on filename.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_action_template(action_id, file_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_id: actionId (required)
        :param str file_name: Name of template file to be retrieved for this action. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_id', 'file_name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_action_template" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_id' is set
        if ('action_id' not in params) or (params['action_id'] is None):
            raise ValueError("Missing the required parameter `action_id` when calling `get_integrations_action_template`")
        # verify the required parameter 'file_name' is set
        if ('file_name' not in params) or (params['file_name'] is None):
            raise ValueError("Missing the required parameter `file_name` when calling `get_integrations_action_template`")


        resource_path = '/api/v2/integrations/actions/{actionId}/templates/{fileName}'.replace('{format}', 'json')
        path_params = {}
        if 'action_id' in params:
            path_params['actionId'] = params['action_id']
        if 'file_name' in params:
            path_params['fileName'] = params['file_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_actions(self, **kwargs) -> 'ActionEntityListing':
        """
        Retrieves all actions associated with filters passed in via query param.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_actions(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param str sort_by: Root level field name to sort on.
        :param str sort_order: Direction to sort 'sortBy' field.
        :param str category: Filter by category name.
        :param str name: Filter by partial or complete action name.
        :param str ids: Filter by action Id. Can be a comma separated list to request multiple actions.  Limit of 50 Ids.
        :param str secure: Filter based on 'secure' configuration option. True will only return actions marked as secure. False will return only non-secure actions. Do not use filter if you want all Actions.
        :param str include_auth_actions: Whether or not to include authentication actions in the response. These actions are not directly executable. Some integrations create them and will run them as needed to refresh authentication information for other actions.
        :return: ActionEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'next_page', 'previous_page', 'sort_by', 'sort_order', 'category', 'name', 'ids', 'secure', 'include_auth_actions']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_actions" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/integrations/actions'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'category' in params:
            query_params['category'] = params['category']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'ids' in params:
            query_params['ids'] = params['ids']
        if 'secure' in params:
            query_params['secure'] = params['secure']
        if 'include_auth_actions' in params:
            query_params['includeAuthActions'] = params['include_auth_actions']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_actions_categories(self, **kwargs) -> 'CategoryEntityListing':
        """
        Retrieves all categories of available Actions
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_actions_categories(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param str sort_by: Root level field name to sort on.  Only 'name' is supported on this endpoint.
        :param str sort_order: Direction to sort 'sortBy' field.
        :param str secure: Filter to only include secure actions. True will only include actions marked secured. False will include only unsecure actions. Do not use filter if you want all Actions.
        :return: CategoryEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'next_page', 'previous_page', 'sort_by', 'sort_order', 'secure']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_actions_categories" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/integrations/actions/categories'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'secure' in params:
            query_params['secure'] = params['secure']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CategoryEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_actions_drafts(self, **kwargs) -> 'ActionEntityListing':
        """
        Retrieves all action drafts associated with the filters passed in via query param.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_actions_drafts(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param str sort_by: Root level field name to sort on.
        :param str sort_order: Direction to sort 'sortBy' field.
        :param str category: Filter by category name.
        :param str name: Filter by partial or complete action name.
        :param str ids: Filter by action Id. Can be a comma separated list to request multiple actions.  Limit of 50 Ids.
        :param str secure: Filter based on 'secure' configuration option. True will only return actions marked as secure. False will return only non-secure actions. Do not use filter if you want all Actions.
        :param str include_auth_actions: Whether or not to include authentication actions in the response. These actions are not directly executable. Some integrations create them and will run them as needed to refresh authentication information for other actions.
        :return: ActionEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'next_page', 'previous_page', 'sort_by', 'sort_order', 'category', 'name', 'ids', 'secure', 'include_auth_actions']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_actions_drafts" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/integrations/actions/drafts'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'category' in params:
            query_params['category'] = params['category']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'ids' in params:
            query_params['ids'] = params['ids']
        if 'secure' in params:
            query_params['secure'] = params['secure']
        if 'include_auth_actions' in params:
            query_params['includeAuthActions'] = params['include_auth_actions']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_botconnector_integration_id_bot(self, integration_id: str, bot_id: str, **kwargs) -> 'BotConnectorBot':
        """
        Get a specific botConnector bot, plus versions, for this integration
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_botconnector_integration_id_bot(integration_id, bot_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str integration_id: The integration ID for this group of bots (required)
        :param str bot_id: The botID for this bot (required)
        :param str version: Specific Version
        :return: BotConnectorBot
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['integration_id', 'bot_id', 'version']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_botconnector_integration_id_bot" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'integration_id' is set
        if ('integration_id' not in params) or (params['integration_id'] is None):
            raise ValueError("Missing the required parameter `integration_id` when calling `get_integrations_botconnector_integration_id_bot`")
        # verify the required parameter 'bot_id' is set
        if ('bot_id' not in params) or (params['bot_id'] is None):
            raise ValueError("Missing the required parameter `bot_id` when calling `get_integrations_botconnector_integration_id_bot`")


        resource_path = '/api/v2/integrations/botconnector/{integrationId}/bots/{botId}'.replace('{format}', 'json')
        path_params = {}
        if 'integration_id' in params:
            path_params['integrationId'] = params['integration_id']
        if 'bot_id' in params:
            path_params['botId'] = params['bot_id']

        query_params = {}
        if 'version' in params:
            query_params['version'] = params['version']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BotConnectorBot',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_botconnector_integration_id_bot_versions(self, integration_id: str, bot_id: str, **kwargs) -> 'BotConnectorBotVersionSummaryEntityListing':
        """
        Get a list of bot versions for a bot
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_botconnector_integration_id_bot_versions(integration_id, bot_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str integration_id: The integration ID for this bot group (required)
        :param str bot_id: The botID for this bot (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :return: BotConnectorBotVersionSummaryEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['integration_id', 'bot_id', 'page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_botconnector_integration_id_bot_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'integration_id' is set
        if ('integration_id' not in params) or (params['integration_id'] is None):
            raise ValueError("Missing the required parameter `integration_id` when calling `get_integrations_botconnector_integration_id_bot_versions`")
        # verify the required parameter 'bot_id' is set
        if ('bot_id' not in params) or (params['bot_id'] is None):
            raise ValueError("Missing the required parameter `bot_id` when calling `get_integrations_botconnector_integration_id_bot_versions`")


        resource_path = '/api/v2/integrations/botconnector/{integrationId}/bots/{botId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'integration_id' in params:
            path_params['integrationId'] = params['integration_id']
        if 'bot_id' in params:
            path_params['botId'] = params['bot_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BotConnectorBotVersionSummaryEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_botconnector_integration_id_bots(self, integration_id: str, **kwargs) -> 'BotList':
        """
        Get a list of botConnector bots for this integration
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_botconnector_integration_id_bots(integration_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str integration_id: The integration ID for this group of bots (required)
        :return: BotList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['integration_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_botconnector_integration_id_bots" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'integration_id' is set
        if ('integration_id' not in params) or (params['integration_id'] is None):
            raise ValueError("Missing the required parameter `integration_id` when calling `get_integrations_botconnector_integration_id_bots`")


        resource_path = '/api/v2/integrations/botconnector/{integrationId}/bots'.replace('{format}', 'json')
        path_params = {}
        if 'integration_id' in params:
            path_params['integrationId'] = params['integration_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BotList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_botconnector_integration_id_bots_summaries(self, integration_id: str, **kwargs) -> 'BotConnectorBotSummaryEntityListing':
        """
        Get a summary list of botConnector bots for this integration
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_botconnector_integration_id_bots_summaries(integration_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str integration_id: The integration ID for this group of bots (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :return: BotConnectorBotSummaryEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['integration_id', 'page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_botconnector_integration_id_bots_summaries" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'integration_id' is set
        if ('integration_id' not in params) or (params['integration_id'] is None):
            raise ValueError("Missing the required parameter `integration_id` when calling `get_integrations_botconnector_integration_id_bots_summaries`")


        resource_path = '/api/v2/integrations/botconnector/{integrationId}/bots/summaries'.replace('{format}', 'json')
        path_params = {}
        if 'integration_id' in params:
            path_params['integrationId'] = params['integration_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BotConnectorBotSummaryEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_clientapps(self, **kwargs) -> 'ClientAppEntityListing':
        """
        List permitted client app integrations for the logged in user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_clientapps(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :return: ClientAppEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_clientapps" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/integrations/clientapps'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ClientAppEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_clientapps_unifiedcommunications(self, **kwargs) -> 'UCIntegrationListing':
        """
        UC integration client application configuration.
        This endpoint returns basic UI configuration data for all Unified Communications integrations client applications enabled for the current organization.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_clientapps_unifiedcommunications(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :return: UCIntegrationListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_clientapps_unifiedcommunications" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/integrations/clientapps/unifiedcommunications'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UCIntegrationListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_credential(self, credential_id: str, **kwargs) -> 'Credential':
        """
        Get a single credential with sensitive fields redacted
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_credential(credential_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str credential_id: Credential ID (required)
        :return: Credential
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['credential_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_credential" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'credential_id' is set
        if ('credential_id' not in params) or (params['credential_id'] is None):
            raise ValueError("Missing the required parameter `credential_id` when calling `get_integrations_credential`")


        resource_path = '/api/v2/integrations/credentials/{credentialId}'.replace('{format}', 'json')
        path_params = {}
        if 'credential_id' in params:
            path_params['credentialId'] = params['credential_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Credential',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_credentials(self, **kwargs) -> 'CredentialInfoListing':
        """
        List multiple sets of credentials
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_credentials(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :return: CredentialInfoListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_credentials" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/integrations/credentials'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CredentialInfoListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_credentials_types(self, **kwargs) -> 'CredentialTypeListing':
        """
        List all credential types
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_credentials_types(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: CredentialTypeListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_credentials_types" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/integrations/credentials/types'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CredentialTypeListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_speech_dialogflow_agent(self, agent_id: str, **kwargs) -> 'DialogflowAgent':
        """
        Get details about a Dialogflow agent
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_speech_dialogflow_agent(agent_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_id: The agent ID (required)
        :return: DialogflowAgent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['agent_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_speech_dialogflow_agent" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'agent_id' is set
        if ('agent_id' not in params) or (params['agent_id'] is None):
            raise ValueError("Missing the required parameter `agent_id` when calling `get_integrations_speech_dialogflow_agent`")


        resource_path = '/api/v2/integrations/speech/dialogflow/agents/{agentId}'.replace('{format}', 'json')
        path_params = {}
        if 'agent_id' in params:
            path_params['agentId'] = params['agent_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DialogflowAgent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_speech_dialogflow_agents(self, **kwargs) -> 'DialogflowAgentSummaryEntityListing':
        """
        Get a list of Dialogflow agents in the customers' Google accounts
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_speech_dialogflow_agents(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str name: Filter on agent name
        :return: DialogflowAgentSummaryEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_speech_dialogflow_agents" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/integrations/speech/dialogflow/agents'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'name' in params:
            query_params['name'] = params['name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DialogflowAgentSummaryEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_speech_lex_bot_alias(self, alias_id: str, **kwargs) -> 'LexBotAlias':
        """
        Get details about a Lex bot alias
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_speech_lex_bot_alias(alias_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str alias_id: The alias ID (required)
        :return: LexBotAlias
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['alias_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_speech_lex_bot_alias" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'alias_id' is set
        if ('alias_id' not in params) or (params['alias_id'] is None):
            raise ValueError("Missing the required parameter `alias_id` when calling `get_integrations_speech_lex_bot_alias`")


        resource_path = '/api/v2/integrations/speech/lex/bot/alias/{aliasId}'.replace('{format}', 'json')
        path_params = {}
        if 'alias_id' in params:
            path_params['aliasId'] = params['alias_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LexBotAlias',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_speech_lex_bot_bot_id_aliases(self, bot_id: str, **kwargs) -> 'LexBotAliasEntityListing':
        """
        Get a list of aliases for a bot in the customer's AWS accounts
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_speech_lex_bot_bot_id_aliases(bot_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bot_id: The bot ID (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str status: Filter on alias status
        :param str name: Filter on alias name
        :return: LexBotAliasEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bot_id', 'page_number', 'page_size', 'status', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_speech_lex_bot_bot_id_aliases" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'bot_id' is set
        if ('bot_id' not in params) or (params['bot_id'] is None):
            raise ValueError("Missing the required parameter `bot_id` when calling `get_integrations_speech_lex_bot_bot_id_aliases`")


        resource_path = '/api/v2/integrations/speech/lex/bot/{botId}/aliases'.replace('{format}', 'json')
        path_params = {}
        if 'bot_id' in params:
            path_params['botId'] = params['bot_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'status' in params:
            query_params['status'] = params['status']
        if 'name' in params:
            query_params['name'] = params['name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LexBotAliasEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_speech_lex_bots(self, **kwargs) -> 'LexBotEntityListing':
        """
        Get a list of Lex bots in the customers' AWS accounts
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_speech_lex_bots(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str name: Filter on bot name
        :return: LexBotEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_speech_lex_bots" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/integrations/speech/lex/bots'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'name' in params:
            query_params['name'] = params['name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LexBotEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_speech_tts_engine(self, engine_id: str, **kwargs) -> 'TtsEngineEntity':
        """
        Get details about a TTS engine
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_speech_tts_engine(engine_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str engine_id: The engine ID (required)
        :param bool include_voices: Include voices for the engine
        :return: TtsEngineEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['engine_id', 'include_voices']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_speech_tts_engine" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'engine_id' is set
        if ('engine_id' not in params) or (params['engine_id'] is None):
            raise ValueError("Missing the required parameter `engine_id` when calling `get_integrations_speech_tts_engine`")


        resource_path = '/api/v2/integrations/speech/tts/engines/{engineId}'.replace('{format}', 'json')
        path_params = {}
        if 'engine_id' in params:
            path_params['engineId'] = params['engine_id']

        query_params = {}
        if 'include_voices' in params:
            query_params['includeVoices'] = params['include_voices']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TtsEngineEntity',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_speech_tts_engine_voice(self, engine_id: str, voice_id: str, **kwargs) -> 'TtsVoiceEntity':
        """
        Get details about a specific voice for a TTS engine
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_speech_tts_engine_voice(engine_id, voice_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str engine_id: The engine ID (required)
        :param str voice_id: The voice ID (required)
        :return: TtsVoiceEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['engine_id', 'voice_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_speech_tts_engine_voice" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'engine_id' is set
        if ('engine_id' not in params) or (params['engine_id'] is None):
            raise ValueError("Missing the required parameter `engine_id` when calling `get_integrations_speech_tts_engine_voice`")
        # verify the required parameter 'voice_id' is set
        if ('voice_id' not in params) or (params['voice_id'] is None):
            raise ValueError("Missing the required parameter `voice_id` when calling `get_integrations_speech_tts_engine_voice`")


        resource_path = '/api/v2/integrations/speech/tts/engines/{engineId}/voices/{voiceId}'.replace('{format}', 'json')
        path_params = {}
        if 'engine_id' in params:
            path_params['engineId'] = params['engine_id']
        if 'voice_id' in params:
            path_params['voiceId'] = params['voice_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TtsVoiceEntity',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_speech_tts_engine_voices(self, engine_id: str, **kwargs) -> 'TtsVoiceEntityListing':
        """
        Get a list of voices for a TTS engine
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_speech_tts_engine_voices(engine_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str engine_id: The engine ID (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :return: TtsVoiceEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['engine_id', 'page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_speech_tts_engine_voices" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'engine_id' is set
        if ('engine_id' not in params) or (params['engine_id'] is None):
            raise ValueError("Missing the required parameter `engine_id` when calling `get_integrations_speech_tts_engine_voices`")


        resource_path = '/api/v2/integrations/speech/tts/engines/{engineId}/voices'.replace('{format}', 'json')
        path_params = {}
        if 'engine_id' in params:
            path_params['engineId'] = params['engine_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TtsVoiceEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_speech_tts_engines(self, **kwargs) -> 'TtsEngineEntityListing':
        """
        Get a list of TTS engines enabled for org
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_speech_tts_engines(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param bool include_voices: Include voices for the engine
        :param str name: Filter on engine name
        :param str language: Filter on supported language. If includeVoices=true then the voices are also filtered.
        :return: TtsEngineEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'include_voices', 'name', 'language']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_speech_tts_engines" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/integrations/speech/tts/engines'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'include_voices' in params:
            query_params['includeVoices'] = params['include_voices']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'language' in params:
            query_params['language'] = params['language']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TtsEngineEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_speech_tts_settings(self, **kwargs) -> 'TtsSettings':
        """
        Get TTS settings for an org
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_speech_tts_settings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: TtsSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_speech_tts_settings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/integrations/speech/tts/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TtsSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_type(self, type_id: str, **kwargs) -> 'IntegrationType':
        """
        Get integration type.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_type(type_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str type_id: Integration Type Id (required)
        :return: IntegrationType
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_type" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'type_id' is set
        if ('type_id' not in params) or (params['type_id'] is None):
            raise ValueError("Missing the required parameter `type_id` when calling `get_integrations_type`")


        resource_path = '/api/v2/integrations/types/{typeId}'.replace('{format}', 'json')
        path_params = {}
        if 'type_id' in params:
            path_params['typeId'] = params['type_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='IntegrationType',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_type_configschema(self, type_id: str, config_type: str, **kwargs) -> 'JsonSchemaDocument':
        """
        Get properties config schema for an integration type.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_type_configschema(type_id, config_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str type_id: Integration Type Id (required)
        :param str config_type: Config schema type (required)
        :return: JsonSchemaDocument
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type_id', 'config_type']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_type_configschema" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'type_id' is set
        if ('type_id' not in params) or (params['type_id'] is None):
            raise ValueError("Missing the required parameter `type_id` when calling `get_integrations_type_configschema`")
        # verify the required parameter 'config_type' is set
        if ('config_type' not in params) or (params['config_type'] is None):
            raise ValueError("Missing the required parameter `config_type` when calling `get_integrations_type_configschema`")


        resource_path = '/api/v2/integrations/types/{typeId}/configschemas/{configType}'.replace('{format}', 'json')
        path_params = {}
        if 'type_id' in params:
            path_params['typeId'] = params['type_id']
        if 'config_type' in params:
            path_params['configType'] = params['config_type']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JsonSchemaDocument',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_types(self, **kwargs) -> 'IntegrationTypeEntityListing':
        """
        List integration types
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_types(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :return: IntegrationTypeEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_types" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/integrations/types'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='IntegrationTypeEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_integrations_userapps(self, **kwargs) -> 'UserAppEntityListing':
        """
        List permitted user app integrations for the logged in user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_integrations_userapps(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param str app_host: The type of UserApp to filter by
        :return: UserAppEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page', 'app_host']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integrations_userapps" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/integrations/userapps'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'app_host' in params:
            query_params['appHost'] = params['app_host']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserAppEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_integration(self, integration_id: str, **kwargs) -> 'Integration':
        """
        Update an integration.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_integration(integration_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str integration_id: Integration Id (required)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param Integration body: Integration Update
        :return: Integration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['integration_id', 'page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_integration" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'integration_id' is set
        if ('integration_id' not in params) or (params['integration_id'] is None):
            raise ValueError("Missing the required parameter `integration_id` when calling `patch_integration`")


        resource_path = '/api/v2/integrations/{integrationId}'.replace('{format}', 'json')
        path_params = {}
        if 'integration_id' in params:
            path_params['integrationId'] = params['integration_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Integration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_integrations_action(self, action_id: str, body: 'UpdateActionInput', **kwargs) -> 'Action':
        """
        Patch an Action
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_integrations_action(action_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_id: actionId (required)
        :param UpdateActionInput body: Input used to patch the Action. (required)
        :return: Action
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_integrations_action" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_id' is set
        if ('action_id' not in params) or (params['action_id'] is None):
            raise ValueError("Missing the required parameter `action_id` when calling `patch_integrations_action`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_integrations_action`")


        resource_path = '/api/v2/integrations/actions/{actionId}'.replace('{format}', 'json')
        path_params = {}
        if 'action_id' in params:
            path_params['actionId'] = params['action_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Action',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_integrations_action_draft(self, action_id: str, body: 'UpdateDraftInput', **kwargs) -> 'Action':
        """
        Update an existing Draft
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_integrations_action_draft(action_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_id: actionId (required)
        :param UpdateDraftInput body: Input used to patch the Action Draft. (required)
        :return: Action
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_integrations_action_draft" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_id' is set
        if ('action_id' not in params) or (params['action_id'] is None):
            raise ValueError("Missing the required parameter `action_id` when calling `patch_integrations_action_draft`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_integrations_action_draft`")


        resource_path = '/api/v2/integrations/actions/{actionId}/draft'.replace('{format}', 'json')
        path_params = {}
        if 'action_id' in params:
            path_params['actionId'] = params['action_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Action',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_integrations(self, **kwargs) -> 'Integration':
        """
        Create an integration.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_integrations(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateIntegrationRequest body: Integration
        :return: Integration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_integrations" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/integrations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Integration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_integrations_action_draft(self, action_id: str, **kwargs) -> 'Action':
        """
        Create a new Draft from existing Action
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_integrations_action_draft(action_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_id: actionId (required)
        :return: Action
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_integrations_action_draft" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_id' is set
        if ('action_id' not in params) or (params['action_id'] is None):
            raise ValueError("Missing the required parameter `action_id` when calling `post_integrations_action_draft`")


        resource_path = '/api/v2/integrations/actions/{actionId}/draft'.replace('{format}', 'json')
        path_params = {}
        if 'action_id' in params:
            path_params['actionId'] = params['action_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Action',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_integrations_action_draft_publish(self, action_id: str, body: 'PublishDraftInput', **kwargs) -> 'Action':
        """
        Publish a Draft and make it the active Action configuration
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_integrations_action_draft_publish(action_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_id: actionId (required)
        :param PublishDraftInput body: Input used to patch the Action. (required)
        :return: Action
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_integrations_action_draft_publish" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_id' is set
        if ('action_id' not in params) or (params['action_id'] is None):
            raise ValueError("Missing the required parameter `action_id` when calling `post_integrations_action_draft_publish`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_integrations_action_draft_publish`")


        resource_path = '/api/v2/integrations/actions/{actionId}/draft/publish'.replace('{format}', 'json')
        path_params = {}
        if 'action_id' in params:
            path_params['actionId'] = params['action_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Action',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_integrations_action_draft_test(self, action_id: str, body: object, **kwargs) -> 'TestExecutionResult':
        """
        Test the execution of a draft. Responses will show execution steps broken out with intermediate results to help in debugging.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_integrations_action_draft_test(action_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_id: actionId (required)
        :param object body: Map of parameters used for variable substitution. (required)
        :return: TestExecutionResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_integrations_action_draft_test" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_id' is set
        if ('action_id' not in params) or (params['action_id'] is None):
            raise ValueError("Missing the required parameter `action_id` when calling `post_integrations_action_draft_test`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_integrations_action_draft_test`")


        resource_path = '/api/v2/integrations/actions/{actionId}/draft/test'.replace('{format}', 'json')
        path_params = {}
        if 'action_id' in params:
            path_params['actionId'] = params['action_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TestExecutionResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_integrations_action_execute(self, action_id: str, body: object, **kwargs) -> object:
        """
        Execute Action and return response from 3rd party.  Responses will follow the schemas defined on the Action for success and error.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_integrations_action_execute(action_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_id: actionId (required)
        :param object body: Map of parameters used for variable substitution. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_integrations_action_execute" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_id' is set
        if ('action_id' not in params) or (params['action_id'] is None):
            raise ValueError("Missing the required parameter `action_id` when calling `post_integrations_action_execute`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_integrations_action_execute`")


        resource_path = '/api/v2/integrations/actions/{actionId}/execute'.replace('{format}', 'json')
        path_params = {}
        if 'action_id' in params:
            path_params['actionId'] = params['action_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_integrations_action_test(self, action_id: str, body: object, **kwargs) -> 'TestExecutionResult':
        """
        Test the execution of an action. Responses will show execution steps broken out with intermediate results to help in debugging.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_integrations_action_test(action_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_id: actionId (required)
        :param object body: Map of parameters used for variable substitution. (required)
        :return: TestExecutionResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_integrations_action_test" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_id' is set
        if ('action_id' not in params) or (params['action_id'] is None):
            raise ValueError("Missing the required parameter `action_id` when calling `post_integrations_action_test`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_integrations_action_test`")


        resource_path = '/api/v2/integrations/actions/{actionId}/test'.replace('{format}', 'json')
        path_params = {}
        if 'action_id' in params:
            path_params['actionId'] = params['action_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TestExecutionResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_integrations_actions(self, body: 'PostActionInput', **kwargs) -> 'Action':
        """
        Create a new Action
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_integrations_actions(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PostActionInput body: Input used to create Action. (required)
        :return: Action
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_integrations_actions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_integrations_actions`")


        resource_path = '/api/v2/integrations/actions'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Action',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_integrations_actions_drafts(self, body: 'PostActionInput', **kwargs) -> 'Action':
        """
        Create a new Draft
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_integrations_actions_drafts(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PostActionInput body: Input used to create Action Draft. (required)
        :return: Action
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_integrations_actions_drafts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_integrations_actions_drafts`")


        resource_path = '/api/v2/integrations/actions/drafts'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Action',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_integrations_credentials(self, **kwargs) -> 'CredentialInfo':
        """
        Create a set of credentials
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_integrations_credentials(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Credential body: Credential
        :return: CredentialInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_integrations_credentials" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/integrations/credentials'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CredentialInfo',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_integration_config_current(self, integration_id: str, **kwargs) -> 'IntegrationConfiguration':
        """
        Update integration configuration.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_integration_config_current(integration_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str integration_id: Integration Id (required)
        :param IntegrationConfiguration body: Integration Configuration
        :return: IntegrationConfiguration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['integration_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_integration_config_current" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'integration_id' is set
        if ('integration_id' not in params) or (params['integration_id'] is None):
            raise ValueError("Missing the required parameter `integration_id` when calling `put_integration_config_current`")


        resource_path = '/api/v2/integrations/{integrationId}/config/current'.replace('{format}', 'json')
        path_params = {}
        if 'integration_id' in params:
            path_params['integrationId'] = params['integration_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='IntegrationConfiguration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_integrations_botconnector_integration_id_bots(self, integration_id: str, bot_list: 'BotList', **kwargs) -> None:
        """
        Set a list of botConnector bots plus versions for this integration
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_integrations_botconnector_integration_id_bots(integration_id, bot_list, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str integration_id: The integration ID for this group of bots (required)
        :param BotList bot_list:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['integration_id', 'bot_list']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_integrations_botconnector_integration_id_bots" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'integration_id' is set
        if ('integration_id' not in params) or (params['integration_id'] is None):
            raise ValueError("Missing the required parameter `integration_id` when calling `put_integrations_botconnector_integration_id_bots`")
        # verify the required parameter 'bot_list' is set
        if ('bot_list' not in params) or (params['bot_list'] is None):
            raise ValueError("Missing the required parameter `bot_list` when calling `put_integrations_botconnector_integration_id_bots`")


        resource_path = '/api/v2/integrations/botconnector/{integrationId}/bots'.replace('{format}', 'json')
        path_params = {}
        if 'integration_id' in params:
            path_params['integrationId'] = params['integration_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'bot_list' in params:
            body_params = params['bot_list']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_integrations_credential(self, credential_id: str, **kwargs) -> 'CredentialInfo':
        """
        Update a set of credentials
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_integrations_credential(credential_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str credential_id: Credential ID (required)
        :param Credential body: Credential
        :return: CredentialInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['credential_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_integrations_credential" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'credential_id' is set
        if ('credential_id' not in params) or (params['credential_id'] is None):
            raise ValueError("Missing the required parameter `credential_id` when calling `put_integrations_credential`")


        resource_path = '/api/v2/integrations/credentials/{credentialId}'.replace('{format}', 'json')
        path_params = {}
        if 'credential_id' in params:
            path_params['credentialId'] = params['credential_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CredentialInfo',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_integrations_speech_tts_settings(self, body: 'TtsSettings', **kwargs) -> 'TtsSettings':
        """
        Update TTS settings for an org
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_integrations_speech_tts_settings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TtsSettings body: Updated TtsSettings (required)
        :return: TtsSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_integrations_speech_tts_settings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_integrations_speech_tts_settings`")


        resource_path = '/api/v2/integrations/speech/tts/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TtsSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
