# coding: utf-8

"""
DownloadsApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import ErrorBody
from ..models import UrlResponse

class DownloadsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get_download(self, download_id: str, **kwargs) -> 'UrlResponse':
        """
        Issues a redirect to a signed secure download URL for specified download
        this method will issue a redirect to the url to the content

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_download(download_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str download_id: Download ID (required)
        :param str content_disposition: 
        :param bool issue_redirect: 
        :param bool redirect_to_auth: 
        :return: UrlResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['download_id', 'content_disposition', 'issue_redirect', 'redirect_to_auth']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_download" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'download_id' is set
        if ('download_id' not in params) or (params['download_id'] is None):
            raise ValueError("Missing the required parameter `download_id` when calling `get_download`")


        resource_path = '/api/v2/downloads/{downloadId}'.replace('{format}', 'json')
        path_params = {}
        if 'download_id' in params:
            path_params['downloadId'] = params['download_id']

        query_params = {}
        if 'content_disposition' in params:
            query_params['contentDisposition'] = params['content_disposition']
        if 'issue_redirect' in params:
            query_params['issueRedirect'] = params['issue_redirect']
        if 'redirect_to_auth' in params:
            query_params['redirectToAuth'] = params['redirect_to_auth']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UrlResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
