## Crossposter

> Crosspost your articles to dev.to/medium.com/hashnode.com from the command line

- Crossposter is a shellscript(BASH) to automate crossposting to platforms like dev.to, medium.com and hashnode.com. The script takes in markdown version of your post with a few inputs from you and posts it to those platforms. You would require a token/key for each of those platforms to post it from the command line.

There are two versions of the script:

- [Shellscript](#crossposter-shell-script) (BASH)
- [Python](#crossposter-python-script)

The actual script is still not perfect (has a few bugs). Though it posts on `dev.to` and `medium.com` easily, the `hashnode.com` is buggy as it parses the raw markdown into the post and doesn't render as desired. So, **its a under-development script**, fell free to raise any issues or PRs on the official GitHub repo.   

## Crossposter Shell Script

The crossposter shell script is a file to be used from a linux/unix command line in a shell environment. The procedure to execute the file is as follows:

Run the script on a bash interpreter with the command:

```
bash crosspost.sh
```

OR

```
bash crosspost.sh file_name.md
```

For posting the article you need to provide the following details:

## Front-Matter

### Meta data about the post

- Title of Post
- Subtitle of Post
- Publish status of post(`true` or `false`)
- Tags for the post (comma separated values)
- Canonical Url (original url of the post)
- Cover Image (URL of the post's image/thumbnail)

This information is a must for `dev.to` especially the `title`. This should be provide in the same order as given below:

```
---
title: The title of the post
subtitle: The description of your article
published: true
tags: programming, anythingelse
canonical url: url of your original blog
cover_image: coverimage_url
---
```

There is no need to enclose any of them with quotation marks. `Published` argument will be `true` if you want to publish it and `false` if you want to keep it in your Drafts.

In the demonstrations, we just need to enter the tokens once. The tokens will be stored locally in the `keys.txt` file and retrieved later within the script.

### Posting on **dev.to**:

Posting on dev.to requires their `API key` which can be generated by going on the [Dev Community API Keys](https://dev.to/settings/account/). From there you can generate a new key with any name you like. You just need to enter the key to CLI once or manually enter in the `keys.txt` file with the format `dev.to:key` on the first line. This will be used for the future cross-posting whenever you execute the shell script(`bash crosspost.sh`)

You can provide the [front matter](#front-matter) manually in your markdown file or you will be prompted for the input. So, that is all you will require for posting on dev.to from the Command line.  

Lets see the script in action 

![dev.to](https://gitlab.com/MR_DESTRUCTIVE/tblog-img/-/raw/main/devto.gif)
   
If you want to add in more stuff to the post, you can check out the [DEV.to API docs](https://developers.forem.com/api#operation/createArticle) which is powered by [Forem](https://www.forem.com/), there a ton of options you can hook to the front-matter in the shellscript.

**NOTE: There is a limit of 10 requests per 30 seconds, so keep in mind while testing the script and don't try to spam**

### Posting on **hashnode.com**:

This part is still under development as it only displays the raw markdown in the post, also the `tags` are too heavy to implement from the API as `id` of every tag is required along with the `slug` and `name`. Still it serves some purpose at least. For posting on `hashnode.com`, we need `Personal Access Token`. This can be generated by going to [Developer Settings](https://hashnode.com/settings/developer). You will also require the user-id of your `hashnode` account. You can get your user-id/username from the [settings](https://hashnode.com/settings) tab under profile information. We require Username for posting to the Publication Blog if any. As usual, the `Personal Access Token` for interacting with the [Hashnodes' GraphQL API](https://api.hashnode.com/). The API is quite user friendly and provides everything in one place. There are docs for running each and every `query` and `mutations` present in the API. 

You can paste the token when prompted from the script or manually type in the `keys.txt` text file as `hashnode:token` on the 4th line. Yes, that should be on the `4th` line, thats make retrieving much more easier and safe. Next also input in the `username` when the script asks for the input or again type in on the `5th` line, `hashnode_id:username` in the text file `keys.txt`. Please enter the credentials from the script prompt so as to avoid errors and misconfigurations when doing manually
 
This will create the Post on hashnode with the title, subtitle, cover image correctly but will mess up the content. I tried hard but its just not happening. There needs to be some character for newline as the API rejects the `rn` characters passed in, so I have substited them with `br` and the result is raw markdown. **As the Hashnode API is still under development and they are bringing changes and new features in, the API should improve in its core functionality and make it much easier for creating some common queries**. So, I'll create issue on GitHub for posting the actual content via the script.

So, this is the demonstration of posting on hashnode.

[hashnode](https://gitlab.com/MR_DESTRUCTIVE/tblog-img/-/raw/main/hashnode.gif)

### Posting on **medium.com**:

Medium API is much more versatile and markdown friendly, though it has some limitation on the number of posts you can make in a day. For posting on `Medium.com`, we will require the `Integration Token` which can be generated on the [settings tab](https://medium.com/me/settings). As similar to `hashnode`, you can name the token whatever you like and then get the token. Paste the token when prompted from the script or manually type in the `keys.txt` text file as `medium:token` on the `2nd` line. We also require the Medium_id, but we can get that from the token itself, so inside the script once the token is obtained, the curl command is executed to fetch in the `id` and it is stored on the next(`3rd`) line in the `keys.txt` file for actually posting on `medium.com`. So that is all the configuration you need for posting on `medium.com`.

There is some documentation on [Medium API](https://github.com/Medium/medium-api-docs), we can even post to a Publication, that shall be created in future. Also the cover images can be posted on medium, it is not currently done but that can again be a #TODO. **The tags are not rendered on Medium yet with the script.** The way we can parse  strings is limited in BASH, so this might still be a doable thing later. Most of the checkboxes are ticked like title, subtitle, cover-image, canonical url, and importantly the content.

Let's look at post on medium from the script.

[medium](https://gitlab.com/MR_DESTRUCTIVE/tblog-img/-/raw/main/medium.gif)

### All platforms: 

Now, once you have configured every thing, you can opt for the `4` choice that is post on all platforms(dev.to, hashnode and medium), but as hashnode is not looking a good option right now, so there is the `5` option for only `dev.to` and `medium`. 

[all-platforms](https://gitlab.com/MR_DESTRUCTIVE/tblog-img/-/raw/main/crossposter.gif)

## Contributions

This is not a perfect script and has a lot of bugs due to encoding the markdown in BASH. It is subject to improve over time as I get to understand more string manipulation in BASH and render the post as expected. Please feel free to open up a genuine and smallest of issues. 

## Crossposter Python Script

A python version of the Crossposter script is in development, it currently supports posting on [dev.to](https://github.com/Mr-Destructive/crossposter/blob/main/pyscript/dev.py) and [codenewbie community](https://github.com/Mr-Destructive/crossposter/blob/main/pyscript/codenewbie.py). Support for hashnode and medium is in pipeline and will be updated soon. 

[crossposter.py](https://github.com/Mr-Destructive/crossposter/tree/main/pyscript)

Dependencies for the python script:

- [requests](https://docs.python-requests.org/en/latest/user/install/#install) 

Running the script:

- Make sure to copy the copy the python folder from the [GitHub repo](https://github.com/Mr-Destructive/crossposter/tree/main/pyscript).
- Create the markdown file in that directory and enter the front-matter in the file.
- Run the main `app.py` file along with the name of the markdown file as follows to proceed ahead.

```
python app.py file_name
```   
Currently, the front matter should be manually inserted in the markdown file, though the input prompt for the same will be featured.

