# -*- coding: utf-8 -*-
# Generated by Django 1.11.3 on 2017-07-29 02:18
from __future__ import unicode_literals

import calaccess_raw.annotations
import calaccess_raw.fields
from django.db import migrations


class Migration(migrations.Migration):

    dependencies = [
        ("calaccess_raw", "0014_auto_20170421_1821"),
    ]

    operations = [
        migrations.AlterField(
            model_name="cvr2campaigndisclosurecd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ATR", "Assistant treasurer"),
                    ("BNM", "Ballot measure's name/title"),
                    ("CAO", "Candidate/officeholder"),
                    ("COM", "Committee"),
                    ("CTL", "Controlled committee"),
                    ("OFF", "Officer"),
                    ("POF", "Principal officer"),
                    ("PRO", "Proponent"),
                    ("RCP", "Recipient committee"),
                    ("FIL", "Unknown"),
                    ("PEX", "Unknown"),
                    ("RDP", "Unknown"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=9, id="2712033-Cal-Format-1-05-02", start_page=8
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=11, id="2712034-Cal-Format-201", start_page=9
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=32
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=24, id="2712033-Cal-Format-1-05-02", start_page=23
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=32
                    ),
                ],
                help_text="Entity code used to identify the type of entity being described with in the record.",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2campaigndisclosurecd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F425",
                        "Form 425 (Semi-Annual Statement of No Activity (Recipient Committee)): Part 1, Committee Information",
                    ),
                    (
                        "F450",
                        "Form 450 (Campaign Disclosure Statement, Short Form (Recipient Committee)): Part 3, Committee Information",
                    ),
                    (
                        "F460",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Cover Page, Part 2",
                    ),
                    (
                        "F465",
                        "Form 465 (Supplemental Independent Expenditure Report): Part 5, Filing Officers",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=23
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=31
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="cvr2campaigndisclosurecd",
            name="juris_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ASM", "Assembly District"),
                    ("BOE", "Board of Equalization District"),
                    ("CIT", "City"),
                    ("CTY", "County"),
                    ("LOC", "Local"),
                    ("OTH", "Other"),
                    ("SEN", "Senate District"),
                    ("STW", "Statewide"),
                    ("sen", "Senate District"),
                    ("SD", "Assembly District"),
                    ("se", "Senate District"),
                    ("F", "Assembly District"),
                    ("LBC", "City"),
                    ("CA", "Statewide"),
                ],
                db_column="JURIS_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=24
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=33
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=35
                    ),
                ],
                help_text="Office jurisdiction code",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="cvr2campaigndisclosurecd",
            name="off_s_h_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("S", "SOUGHT"),
                    ("H", "HELD"),
                    ("s", "SOUGHT"),
                    ("F", "SOUGHT"),
                    ("T", "HELD"),
                ],
                db_column="OFF_S_H_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=35
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=24
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=34
                    ),
                ],
                help_text="Office is sought or held code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="cvr2campaigndisclosurecd",
            name="office_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("APP", "State Appellate Court Justice"),
                    ("ASM", "State Assembly Person"),
                    ("ASR", "Assessor"),
                    ("ATT", "Attorney General"),
                    ("BED", "Board of Education"),
                    ("BOE", "Board of Equalization Member"),
                    ("BSU", "Board of Supervisors"),
                    ("CAT", "City Attorney"),
                    ("CCB", "Community College Board"),
                    ("CCM", "City Council Member"),
                    ("CON", "State Controller"),
                    ("COU", "County Counsel"),
                    ("CSU", "County Supervisor"),
                    ("CTR", "Local Controller"),
                    ("DAT", "District Attorney"),
                    ("GOV", "Governor"),
                    ("INS", "Insurance Commissioner"),
                    ("LTG", "Lieutenant Governor"),
                    ("MAY", "Mayor"),
                    ("OTH", "Other"),
                    ("PDR", "Public Defender"),
                    ("PER", "Public Employees Retirement System"),
                    ("PLN", "Planning Commissioner"),
                    ("SCJ", "Superior Court Judge"),
                    ("SEN", "State Senator"),
                    ("SHC", "Sheriff-Coroner"),
                    ("SOS", "Secretary of State"),
                    ("SPM", "Supreme Court Justice"),
                    ("SUP", "Superintendent of Public Instruction"),
                    ("TRE", "State Treasurer"),
                    ("TRS", "Local Treasurer"),
                    ("CIT", "State Assembly Person"),
                    ("CTL", "State Assembly Person"),
                    ("F", "State Assembly Person"),
                    ("ST", "State Assembly Person"),
                    ("PAC", "Unknown"),
                ],
                db_column="OFFICE_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=10
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=12
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712032-Cal-Errata-201", start_page=2
                    ),
                ],
                help_text="Identifies the office being sought",
                max_length=3,
                verbose_name="office code",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2campaigndisclosurecd",
            name="sup_opp_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("S", "SUPPORT"),
                    ("O", "OPPOSITION"),
                    ("s", "SUPPORT"),
                    ("o", "OPPOSITION"),
                ],
                db_column="SUP_OPP_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711614-CalAccessTablesWeb", start_page=41
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=35
                    ),
                ],
                help_text="Support or opposition code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="cvr2lobbydisclosurecd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("EMP", "Employer"),
                    ("OFF", "Officer"),
                    ("OWN", "Owner"),
                    ("PTN", "Partner"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=57
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=71
                    ),
                ],
                help_text="Entity code of the entity described by the record",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2lobbydisclosurecd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("F625", "Form 625: Report of Lobbying Firm"),
                    (
                        "F635",
                        "Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=57
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=71
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="cvr2registrationcd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("AGY", "State Agency"),
                    ("EMP", "Employer"),
                    ("FRM", "Lobbying Firm"),
                    ("LBY", "Lobbyist (an individual)"),
                    ("MBR", "Member of Associaton"),
                    ("SCL", "Subcontracted Client"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=72
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=87
                    ),
                ],
                help_text="Entity code of the entity described by the record",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2registrationcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("F601", "Form 601: Lobbying Firm Registration Statement"),
                    ("F602", "Form 602: Lobbying Firm Activity Authorization"),
                    (
                        "F603",
                        "Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=72
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=87
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=10,
            ),
        ),
        migrations.AlterField(
            model_name="cvr2socd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ATH", "Authorizing individual"),
                    ("ATR", "Assistant treasurer"),
                    ("BNM", "Ballot measure's name/title"),
                    ("CAO", "Candidate/officeholder"),
                    ("COM", "Committee"),
                    ("CTL", "Controlled committee"),
                    ("OFF", "Officer"),
                    ("POF", "Principal officer"),
                    ("PRO", "Proponent"),
                    ("SPO", "Sponsor"),
                    ("BMN", "Unknown"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=9, id="2712033-Cal-Format-1-05-02", start_page=8
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=11, id="2712034-Cal-Format-201", start_page=9
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=38
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=48
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=62
                    ),
                ],
                help_text="Entity code of the entity described by the record.",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2socd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F400",
                        "Form 400 (Statement of Organization (Slate Mailer Organization)): Part 3, Individuals Who Authorize Contents Of Slate Mailers",
                    ),
                    (
                        "F410",
                        "Form 410 (Statement of Organization (Recipient Committee)): Part 4, Type of Committee",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=38
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=46, id="2712033-Cal-Format-1-05-02", start_page=45
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=59, id="2712034-Cal-Format-201", start_page=58
                    ),
                ],
                help_text="Form type of the filing the record is included in. This must equal the form_type of the parent filing's cover (CVR) record.",
                max_length=4,
                verbose_name="form type",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2socd",
            name="item_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ATR", "Assistant Treasurer (F410)"),
                    ("CAO", "Candidate/officeholder"),
                    ("CTL", "Controlled Committee (F410)"),
                    ("P5B", "Unknown"),
                    ("PFC", "Primarily Formed Committee Item (F410)"),
                    ("Pfc", "Primarily Formed Committee Item (F410)"),
                    ("POF", "Principal Officer (F400, F410"),
                    ("PRO", "Proponent"),
                    ("SMA", "Slate Mailer Authorizer (F400)"),
                    ("SPO", "Sponsored Committee Itemization (F410)"),
                    ("n/a", "Not Applicable"),
                    ("CON", "Unknown"),
                    ("CST", "Unknown"),
                ],
                db_column="ITEM_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=8
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=10
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=48
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=62
                    ),
                ],
                help_text="Section of the Statement of Organization this itemization relates to. See CAL document for the definition of legal values for this column.",
                max_length=4,
                verbose_name="item code",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2socd",
            name="juris_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ASM", "Assembly District"),
                    ("BOE", "Board of Equalization District"),
                    ("CIT", "City"),
                    ("CTY", "County"),
                    ("LOC", "Local"),
                    ("OTH", "Other"),
                    ("SEN", "Senate District"),
                    ("STW", "Statewide"),
                    ("FED", "N/A"),
                    ("JR", "N/A"),
                ],
                db_column="JURIS_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=39
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=49
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=63
                    ),
                ],
                help_text="Office jurisdiction code. See CAL document for a list of legal values.",
                max_length=4,
                verbose_name="jurisdiction code",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2socd",
            name="off_s_h_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("H", "HELD"), ("S", "SOUGHT")],
                db_column="OFF_S_H_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711614-CalAccessTablesWeb", start_page=46
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=39
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=49
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=63
                    ),
                ],
                help_text='Office sought/held code. Legal values are "S" for sought and "H" for held',
                max_length=1,
                verbose_name="office is sought or held code",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2socd",
            name="office_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("APP", "State Appellate Court Justice"),
                    ("ASM", "State Assembly Person"),
                    ("ASR", "Assessor"),
                    ("ATT", "Attorney General"),
                    ("BED", "Board of Education"),
                    ("BOE", "Board of Equalization Member"),
                    ("BSU", "Board of Supervisors"),
                    ("CAT", "City Attorney"),
                    ("CCB", "Community College Board"),
                    ("CCM", "City Council Member"),
                    ("CON", "State Controller"),
                    ("COU", "County Counsel"),
                    ("CSU", "County Supervisor"),
                    ("CTR", "Local Controller"),
                    ("DAT", "District Attorney"),
                    ("GOV", "Governor"),
                    ("INS", "Insurance Commissioner"),
                    ("LTG", "Lieutenant Governor"),
                    ("MAY", "Mayor"),
                    ("OTH", "Other"),
                    ("PDR", "Public Defender"),
                    ("PER", "Public Employees Retirement System"),
                    ("PLN", "Planning Commissioner"),
                    ("SCJ", "Superior Court Judge"),
                    ("SEN", "State Senator"),
                    ("SHC", "Sheriff-Coroner"),
                    ("SOS", "Secretary of State"),
                    ("SPM", "Supreme Court Justice"),
                    ("SUP", "Superintendent of Public Instruction"),
                    ("TRE", "State Treasurer"),
                    ("TRS", "Local Treasurer"),
                    ("Asm", "State Assembly Person"),
                    ("LEG", "State Assembly Person"),
                    ("OF", "State Assembly Person"),
                    ("REP", "State Assembly Person"),
                    ("05", "State Assembly Person"),
                    ("H", "N/A"),
                    ("PRO", "N/A"),
                    ("PAC", "Unknown"),
                ],
                db_column="OFFICE_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=10
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=12
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712032-Cal-Errata-201", start_page=2
                    ),
                ],
                help_text="Identifies the office being sought",
                max_length=3,
                verbose_name="office code",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2socd",
            name="sup_opp_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("O", "OPPOSITION"), ("S", "SUPPORT")],
                db_column="SUP_OPP_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711614-CalAccessTablesWeb", start_page=46
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=40
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=49
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=64
                    ),
                ],
                help_text="Support or opposition code",
                max_length=1,
                verbose_name="support or opposition code",
            ),
        ),
        migrations.AlterField(
            model_name="cvr3verificationinfocd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ATR", "Assistant treasurer"),
                    ("CAO", "Candidate/officeholder"),
                    ("TRE", "Treasurer"),
                    ("OFF", "Officer"),
                    ("PRO", "Proponent"),
                    ("SPO", "Sponsor"),
                    ("atr", "Treasurer"),
                    ("tre", "Assistant treasurer"),
                    ("cao", "Candidate/officeholder"),
                    ("MDI", "Major Donor/Ind Expenditure"),
                    ("POF", "Principal officer"),
                    ("RCP", "Recipient committee"),
                    ("COA", "Candidate/officeholder"),
                    ("0", "Unknown"),
                    ("BBB", "Unknown"),
                    ("CON", "Unknown"),
                    ("MAI", "Unknown"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=9
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=25
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=11
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=34
                    ),
                ],
                help_text="Entity Code",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="cvr3verificationinfocd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F400",
                        "Form 400 (Statement of Organization (Slate Mailer Organization)): Part 5, Verification",
                    ),
                    (
                        "F401",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Cover Page",
                    ),
                    (
                        "F402",
                        "Form 402 (Statement of Termination (Slate Mailer Organization)): Verification",
                    ),
                    (
                        "F410",
                        "Form 410 (Statement of Organization (Recipient Committee)): Part 3, Verification",
                    ),
                    (
                        "F425",
                        "Form 425 (Semi-Annual Statement of No Activity (Recipient Committee)): Part 3, Verification",
                    ),
                    (
                        "F450",
                        "Form 450 (Campaign Disclosure Statement, Short Form (Recipient Committee)): Part 4, Verification",
                    ),
                    (
                        "F460",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Cover Page, Part 1",
                    ),
                    (
                        "F461",
                        "Form 461 (Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)): Part 4, Verification",
                    ),
                    (
                        "F465",
                        "Form 465 (Supplemental Independent Expenditure Report): Part 6, Verification",
                    ),
                    ("F511", "Form 511: Paid Spokesperson Report"),
                    (
                        "F900",
                        "Form 900: Campaign Disclosure Statement (Public employee retirement board candidate)",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=50
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=64
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="cvrcampaigndisclosurecd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("BMC", "Ballot measure committee"),
                    ("CAO", "Candidate/officeholder"),
                    ("COM", "Committee"),
                    ("CTL", "Controlled committee"),
                    ("IND", "Individual"),
                    ("MDI", "Major Donor/Ind Expenditure"),
                    ("OTH", "Other"),
                    ("PTY", "Political Party"),
                    ("RCP", "Recipient committee"),
                    ("SCC", "Small Contributor Committee"),
                    ("SMO", "Slate-mailer organization"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=9, id="2712033-Cal-Format-1-05-02", start_page=8
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=11, id="2712034-Cal-Format-201", start_page=9
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=6
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=18
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=22
                    ),
                ],
                help_text="The entity type of the filer. These codes vary by form type.",
                max_length=4,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="cvrcampaigndisclosurecd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F401",
                        "Form 401: Campaign Disclosure Statement (Slate Mailer Organization)",
                    ),
                    (
                        "F425",
                        "Form 425: Semi-Annual Statement of No Activity (Recipient Committee)",
                    ),
                    (
                        "F450",
                        "Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        "F460",
                        "Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        "F461",
                        "Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                    ("F465", "Form 465: Supplemental Independent Expenditure Report"),
                    ("F496", "Form 496: Late Independent Expenditure Report"),
                    ("F497", "Form 497: Late Contribution Report"),
                    (
                        "F498",
                        "Form 498: Late Payment Report (Slate Mailer Organization)",
                    ),
                    ("F511", "Form 511: Paid Spokesperson Report"),
                    (
                        "F900",
                        "Form 900: Campaign Disclosure Statement (Public employee retirement board candidate)",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=18
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=22
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="cvrcampaigndisclosurecd",
            name="juris_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ASM", "Assembly District"),
                    ("BOE", "Board of Equalization District"),
                    ("CIT", "City"),
                    ("CTY", "County"),
                    ("LOC", "Local"),
                    ("OTH", "Other"),
                    ("SEN", "Senate District"),
                    ("STW", "Statewide"),
                    ("sen", "Senate District"),
                    ("Gov", "Statewide"),
                    ("ATT", "Statewide"),
                    ("CON", "Statewide"),
                    ("GOV", "Statewide"),
                    ("SOS", "Statewide"),
                    ("SPM", "Statewide"),
                    ("46", "Assembly District"),
                    ("55", "Assembly District"),
                    ("BSU", "County"),
                    ("CSU", "County"),
                    ("DAT", "County"),
                    ("SHC", "County"),
                    ("MAY", "City"),
                    ("CCM", "City"),
                    ("APP", "Other"),
                    ("BED", "Other"),
                    ("SCJ", "Other"),
                    ("SD", "Other"),
                    ("OC", "County"),
                    ("AD", "Assembly District"),
                    ("CA", "Unknown"),
                    ("F", "Unknown"),
                ],
                db_column="JURIS_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=13
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=22, id="2712033-Cal-Format-1-05-02", start_page=21
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=29, id="2712034-Cal-Format-201", start_page=28
                    ),
                ],
                help_text="Office jurisdiction code",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="cvrcampaigndisclosurecd",
            name="off_s_h_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("S", "SOUGHT"),
                    ("H", "HELD"),
                    ("s", "SOUGHT"),
                    ("h", "HELD"),
                    ("F", "UNKNOWN"),
                    ("O", "UNKNOWN"),
                ],
                db_column="OFF_S_H_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=21
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=28
                    ),
                ],
                help_text="Office is sought or held code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="cvrcampaigndisclosurecd",
            name="office_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("APP", "State Appellate Court Justice"),
                    ("ASM", "State Assembly Person"),
                    ("ASR", "Assessor"),
                    ("ATT", "Attorney General"),
                    ("BED", "Board of Education"),
                    ("BOE", "Board of Equalization Member"),
                    ("BSU", "Board of Supervisors"),
                    ("CAT", "City Attorney"),
                    ("CCB", "Community College Board"),
                    ("CCM", "City Council Member"),
                    ("CON", "State Controller"),
                    ("COU", "County Counsel"),
                    ("CSU", "County Supervisor"),
                    ("CTR", "Local Controller"),
                    ("DAT", "District Attorney"),
                    ("GOV", "Governor"),
                    ("INS", "Insurance Commissioner"),
                    ("LTG", "Lieutenant Governor"),
                    ("MAY", "Mayor"),
                    ("OTH", "Other"),
                    ("PDR", "Public Defender"),
                    ("PER", "Public Employees Retirement System"),
                    ("PLN", "Planning Commissioner"),
                    ("SCJ", "Superior Court Judge"),
                    ("SEN", "State Senator"),
                    ("SHC", "Sheriff-Coroner"),
                    ("SOS", "Secretary of State"),
                    ("SPM", "Supreme Court Justice"),
                    ("SUP", "Superintendent of Public Instruction"),
                    ("TRE", "State Treasurer"),
                    ("TRS", "Local Treasurer"),
                    ("Gov", "Governor"),
                    ("Sen", "State Senator"),
                    ("LOC", "Community College Board"),
                    ("LEG", "State Senator"),
                    ("REP", "State Assembly Person"),
                    ("Mem", "Other"),
                    ("CIT", "State Assembly Person"),
                    ("PAC", "Unknown"),
                    ("F", "Unknown"),
                    ("COM", "Unknown"),
                ],
                db_column="OFFICE_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=10
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=12
                    ),
                ],
                help_text="Identifies the office being sought",
                max_length=3,
                verbose_name="office code",
            ),
        ),
        migrations.AlterField(
            model_name="cvrcampaigndisclosurecd",
            name="reportname",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    (
                        "450",
                        "Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        "460",
                        "Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        "461",
                        "Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                ],
                db_column="REPORTNAME",
                documentcloud_pages=(
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=15
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=20
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=19
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=26
                    ),
                ),
                help_text="Attached campaign disclosure statement type. Legal values are 450, 460, and 461.",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="cvrcampaigndisclosurecd",
            name="stmt_type",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("PE", "Pre-Election (F450, F460)"),
                    ("QT", "Quarterly Stmt (F450,F460)"),
                    ("SA", "Semi-annual (F450, F460)"),
                    ("SE", "Supplemental Pre-elect (F450, F460, F495)"),
                    ("SY", "Special Odd-Yr. Campaign (F450, F460)"),
                    ("S1", "Semi-Annual (Jan1-Jun30) (F425)"),
                    ("S2", "Semi-Annual (Jul1-Dec31) (F425)"),
                    ("TS", "Termination Statement (F450, F460)"),
                    ("pe", "Pre-Election (F450, F460)"),
                    ("qt", "Quarterly Stmt (F450,F460)"),
                    ("sa", "Semi-annual (F450, F460)"),
                    ("se", "Supplemental Pre-elect (F450, F460, F495)"),
                    ("sy", "Special Odd-Yr. Campaign (F450, F460)"),
                    ("ts", "Termination Statement (F450, F460)"),
                    ("**", "Amendment"),
                    ("1", "Unknown"),
                    ("2", "Unknown"),
                    ("CA", "Unknown"),
                    ("MD", "Unknown"),
                    ("NA", "Unknown"),
                    ("PR", "Unknown"),
                    ("QS", "Unknown"),
                    ("S", "Unknown"),
                    ("x", "Unknown"),
                    ("YE", "Unknown"),
                ],
                db_column="STMT_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=7
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=18
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=23
                    ),
                ],
                help_text="Type of statement",
                max_length=2,
            ),
        ),
        migrations.AlterField(
            model_name="cvrcampaigndisclosurecd",
            name="sup_opp_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("S", "SUPPORT"),
                    ("O", "OPPOSITION"),
                    ("s", "SUPPORT"),
                    ("o", "OPPOSITION"),
                ],
                db_column="SUP_OPP_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711614-CalAccessTablesWeb", start_page=28
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=14
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=21
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=28
                    ),
                ],
                help_text="Support or opposition code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="cvre530cd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ATH", "Authorizing individual"),
                    ("ATR", "Assistant treasurer"),
                    ("BMC", "Ballot measure committee"),
                    ("BNM", "Ballot measure's name/title"),
                    ("CAO", "Candidate/officeholder"),
                    ("COM", "Committee"),
                    ("CTL", "Controlled committee"),
                    ("IND", "Individual"),
                    ("MDI", "Major Donor/Ind Expenditure"),
                    ("OFF", "Officer"),
                    ("OTH", "Other"),
                    ("POF", "Principal officer"),
                    ("PRO", "Proponent"),
                    ("PTY", "Political Party"),
                    ("RCP", "Recipient committee"),
                    ("SCC", "Small Contributor Committee"),
                    ("SMO", "Slate-mailer organization"),
                    ("SPO", "Sponsor"),
                    ("TRE", "Treasurer"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=9, id="2712033-Cal-Format-1-05-02", start_page=8
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=11, id="2712034-Cal-Format-201", start_page=9
                    ),
                ],
                help_text="entity code",
                max_length=32,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="cvre530cd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("E530", "Electronic Form 530: Electronic Issue Advocacy Report")
                ],
                db_column="FORM_TYPE",
                db_index=True,
                help_text="Name of the source filing form or schedule",
                max_length=4,
                verbose_name="form type",
            ),
        ),
        migrations.AlterField(
            model_name="cvrf470cd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("CAO", "Candidate/officeholder")],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=22
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=29
                    ),
                ],
                help_text="The filer's entity code. The value of this column will always be Candidate/Office Holder (CAO) for this table.",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="cvrf470cd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F470",
                        "Form 470: Campaign Disclosure Statement, Short Form (Officeholders and Candidates)",
                    )
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=22
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=29
                    ),
                ],
                help_text="Type of Filing or Formset. The value of this column will always be equal to F470.",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="cvrf470cd",
            name="juris_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ASM", "Assembly District"),
                    ("BOE", "Board of Equalization District"),
                    ("CIT", "City"),
                    ("CTY", "County"),
                    ("LOC", "Local"),
                    ("OTH", "Other"),
                    ("SEN", "Senate District"),
                    ("STW", "Statewide"),
                ],
                db_column="JURIS_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=22
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=29
                    ),
                ],
                help_text="Office Jurisdiction Code",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="cvrf470cd",
            name="off_s_h_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("H", "HELD"), ("S", "SOUGHT")],
                db_column="OFF_S_H_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=22
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=30
                    ),
                ],
                help_text='Office Sought/Held code. Legal values are "S" for sought and "H" for held.',
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="cvrf470cd",
            name="office_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("APP", "State Appellate Court Justice"),
                    ("ASM", "State Assembly Person"),
                    ("ASR", "Assessor"),
                    ("ATT", "Attorney General"),
                    ("BED", "Board of Education"),
                    ("BOE", "Board of Equalization Member"),
                    ("BSU", "Board of Supervisors"),
                    ("CAT", "City Attorney"),
                    ("CCB", "Community College Board"),
                    ("CCM", "City Council Member"),
                    ("CON", "State Controller"),
                    ("COU", "County Counsel"),
                    ("CSU", "County Supervisor"),
                    ("CTR", "Local Controller"),
                    ("DAT", "District Attorney"),
                    ("GOV", "Governor"),
                    ("INS", "Insurance Commissioner"),
                    ("LTG", "Lieutenant Governor"),
                    ("MAY", "Mayor"),
                    ("OTH", "Other"),
                    ("PDR", "Public Defender"),
                    ("PER", "Public Employees Retirement System"),
                    ("PLN", "Planning Commissioner"),
                    ("SCJ", "Superior Court Judge"),
                    ("SEN", "State Senator"),
                    ("SHC", "Sheriff-Coroner"),
                    ("SOS", "Secretary of State"),
                    ("SPM", "Supreme Court Justice"),
                    ("SUP", "Superintendent of Public Instruction"),
                    ("TRE", "State Treasurer"),
                    ("TRS", "Local Treasurer"),
                ],
                db_column="OFFICE_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=22
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=29
                    ),
                ],
                help_text="Code that identifies the office being sought. See the CAL document for a list of valid codes.",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="cvrlobbydisclosurecd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("CLI", "Unknown"),
                    ("FRM", "Lobbying Firm"),
                    ("IND", "Person (spending > $5000)"),
                    ("LBY", "Lobbyist (an individual)"),
                    ("LCO", "Lobbying Coalition"),
                    ("LEM", "Lobbying Employer"),
                    ("OTH", "Other"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=53
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=67
                    ),
                ],
                help_text="Entity Code describing the filer",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="cvrlobbydisclosurecd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("F615", "Form 615: Lobbyist Report"),
                    ("F625", "Form 625: Report of Lobbying Firm"),
                    (
                        "F635",
                        "Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                    ("F645", "Form 645: Report of Person Spending $5,000 or More"),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=53
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=66
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="cvrregistrationcd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("BUS", "Unknown"),
                    ("FRM", "Lobbying Firm"),
                    ("LBY", "Lobbyist (an individual)"),
                    ("LCO", "Lobbying Coalition"),
                    ("LEM", "Lobbying Employer"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=82
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=68
                    ),
                ],
                help_text="Entity Code describing the filer",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="cvrregistrationcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("F601", "Form 601: Lobbying Firm Registration Statement"),
                    ("F602", "Form 602: Lobbying Firm Activity Authorization"),
                    (
                        "F603",
                        "Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                    ),
                    ("F604", "Form 604: Lobbyist Certification Statement"),
                    ("F606", "Form 606: Notice of Termination"),
                    ("F607", "Form 607: Notice of Withdrawal"),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=68
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=82
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="cvrsocd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("BMC", "Ballot measure committee"),
                    ("CAO", "Candidate/officeholder"),
                    ("COM", "Committee"),
                    ("CTL", "Controlled committee"),
                    ("RCP", "Recipient committee"),
                    ("SMO", "Slate-mailer organization"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=9, id="2712033-Cal-Format-1-05-02", start_page=8
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=11, id="2712034-Cal-Format-201", start_page=9
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=46
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=59
                    ),
                ],
                help_text="Entity Code of the Filer. Values: SMO - Slate Mailer Organization (F400,402) [COM|RCP] - Recipient Committee (F410)",
                max_length=3,
                verbose_name="Entity code",
            ),
        ),
        migrations.AlterField(
            model_name="cvrsocd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F400",
                        "Form 400: Statement of Organization (Slate Mailer Organization)",
                    ),
                    (
                        "F402",
                        "Form 402: Statement of Termination (Slate Mailer Organization)",
                    ),
                    (
                        "F410",
                        "Form 410: Statement of Organization (Recipient Committee)",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=46
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=59
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
                verbose_name="form type",
            ),
        ),
        migrations.AlterField(
            model_name="debtcd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("BNM", "Ballot measure's name/title"),
                    ("COM", "Committee"),
                    ("IND", "Individual"),
                    ("OTH", "Other"),
                    ("PTY", "Political Party"),
                    ("RCP", "Recipient committee"),
                    ("SCC", "Small Contributor Committee"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=9, id="2712033-Cal-Format-1-05-02", start_page=8
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=11, id="2712034-Cal-Format-201", start_page=9
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=33
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=45
                    ),
                ],
                help_text="Entity code describing the payee",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="debtcd",
            name="expn_code",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("CMP", "campaign paraphernalia/miscellaneous"),
                    ("CNS", "campaign consultants"),
                    ("CTB", "contribution (if nonmonetary, explain)*"),
                    ("CVC", "civic donations"),
                    ("FIL", "candidate filing/ballot feeds"),
                    ("FND", "fundraising events"),
                    ("IKD", "In-kind contribution (nonmonetary)"),
                    (
                        "IND",
                        "independent expenditure supporting/opposing others (explain)*",
                    ),
                    ("LEG", "legal defense"),
                    ("LIT", "campaign literature and mailings"),
                    ("LON", "loan"),
                    ("MBR", "member communications"),
                    ("MON", "monetary contribution"),
                    ("MTG", "meetings and appearances"),
                    ("OFC", "office expenses"),
                    ("PET", "petition circulating"),
                    ("PHO", "phone banks"),
                    ("POL", "polling and survey research"),
                    ("POS", "postage, delivery and messenger services"),
                    ("PRO", "professional services (legal, accounting)"),
                    ("PRT", "print ads"),
                    ("RAD", "radio airtime and production costs"),
                    ("RFD", "returned contributions"),
                    ("SAL", "campaign workers salaries"),
                    ("TEL", "T.V. or cable airtime and production costs"),
                    ("TRC", "candidate travel, lodging and meals (explain)"),
                    ("TRS", "staff/spouse travel, lodging and meals (explain)"),
                    (
                        "TSF",
                        "transfer between committees of the same candidate/sponsor",
                    ),
                    ("VOT", "voter registration"),
                    ("WEB", "information technology costs (internet, e-mail)"),
                    ("Fnd", "fundraising events"),
                    ("ofc", "office expenses"),
                    ("'CN", "campaign consultants"),
                    ("*", "Unknown"),
                    ("AIR", "Unknown"),
                    ("BUS", "Unknown"),
                    ("C", "Unknown"),
                    ("CAM", "Unknown"),
                    ("CC", "Unknown"),
                    ("COM", "Unknown"),
                    ("CON", "Unknown"),
                    ("CSN", "Unknown"),
                    ("DEP", "Unknown"),
                    ("EVE", "Unknown"),
                    ("F", "Unknown"),
                    ("FED", "Unknown"),
                    ("fns", "Unknown"),
                    ("G", "Unknown"),
                    ("GGG", "Unknown"),
                    ("HOT", "Unknown"),
                    ("L", "Unknown"),
                    ("LDF", "Unknown"),
                    ("MEE", "Unknown"),
                    ("N", "Unknown"),
                    ("O", "Unknown"),
                    ("OTH", "Unknown"),
                    ("P", "Unknown"),
                    ("PEN", "Unknown"),
                    ("S", "Unknown"),
                    ("SPE", "Unknown"),
                    ("STA", "Unknown"),
                    ("T", "Unknown"),
                    ("TAX", "Unknown"),
                    ("TRA", "Unknown"),
                    ("V", "Unknown"),
                    ("X", "Unknown"),
                ],
                db_column="EXPN_CODE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=11
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=14, id="2712034-Cal-Format-201", start_page=13
                    ),
                ],
                help_text="Expense Code",
                max_length=3,
                verbose_name="expense code",
            ),
        ),
        migrations.AlterField(
            model_name="debtcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule F, Accrued Expenses (Unpaid Bills)",
                    )
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=33
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=45
                    ),
                ],
                help_text="Schedule Name/ID: (F - Sched F / Accrued Expenses)",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="efsfilinglogcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F400",
                        "Form 400: Statement of Organization (Slate Mailer Organization)",
                    ),
                    (
                        "F401",
                        "Form 401: Campaign Disclosure Statement (Slate Mailer Organization)",
                    ),
                    (
                        "F402",
                        "Form 402: Statement of Termination (Slate Mailer Organization)",
                    ),
                    (
                        "F410",
                        "Form 410: Statement of Organization (Recipient Committee)",
                    ),
                    (
                        "F425",
                        "Form 425: Semi-Annual Statement of No Activity (Recipient Committee)",
                    ),
                    (
                        "F450",
                        "Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        "F460",
                        "Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        "F461",
                        "Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                    ("F465", "Form 465: Supplemental Independent Expenditure Report"),
                    ("F496", "Form 496: Late Independent Expenditure Report"),
                    ("F497", "Form 497: Late Contribution Report"),
                    (
                        "F498",
                        "Form 498: Late Payment Report (Slate Mailer Organization)",
                    ),
                    ("F601", "Form 601: Lobbying Firm Registration Statement"),
                    ("F602", "Form 602: Lobbying Firm Activity Authorization"),
                    (
                        "F603",
                        "Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                    ),
                    ("F604", "Form 604: Lobbyist Certification Statement"),
                    ("F606", "Form 606: Notice of Termination"),
                    ("F607", "Form 607: Notice of Withdrawal"),
                    ("F615", "Form 615: Lobbyist Report"),
                    ("F625", "Form 625: Report of Lobbying Firm"),
                    (
                        "F635",
                        "Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                    ("F645", "Form 645: Report of Person Spending $5,000 or More"),
                    ("BADFORMAT 253", "Unknown"),
                    ("form", "Unknown"),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=8, id="2711624-Overview", start_page=4
                    )
                ],
                help_text="Name of the source filing form or schedule",
                max_length=250,
                verbose_name="form type",
            ),
        ),
        migrations.AlterField(
            model_name="expncd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("COM", "Committee"),
                    ("IND", "Individual"),
                    ("RCP", "Recipient committee"),
                    ("OTH", "Other"),
                    ("PTY", "Political Party"),
                    ("SCC", "Small Contributor Committee"),
                    ("BNM", "Ballot measure's name/title"),
                    ("CAO", "Candidate/officeholder"),
                    ("MBR", "Member of Associaton"),
                    ("OFF", "Officer"),
                    ("0", "Unknown"),
                    ("PTH", "Unknown"),
                    ("RFD", "Unknown"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=9, id="2712033-Cal-Format-1-05-02", start_page=8
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=11, id="2712034-Cal-Format-201", start_page=9
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=31
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=42
                    ),
                ],
                help_text="Entity Code describing payee",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="expncd",
            name="expn_code",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("CMP", "campaign paraphernalia/miscellaneous"),
                    ("CNS", "campaign consultants"),
                    ("CTB", "contribution (if nonmonetary, explain)*"),
                    ("CVC", "civic donations"),
                    ("FIL", "candidate filing/ballot feeds"),
                    ("FND", "fundraising events"),
                    ("IKD", "In-kind contribution (nonmonetary)"),
                    (
                        "IND",
                        "independent expenditure supporting/opposing others (explain)*",
                    ),
                    ("LEG", "legal defense"),
                    ("LIT", "campaign literature and mailings"),
                    ("LON", "loan"),
                    ("MBR", "member communications"),
                    ("MON", "monetary contribution"),
                    ("MTG", "meetings and appearances"),
                    ("OFC", "office expenses"),
                    ("PET", "petition circulating"),
                    ("PHO", "phone banks"),
                    ("POL", "polling and survey research"),
                    ("POS", "postage, delivery and messenger services"),
                    ("PRO", "professional services (legal, accounting)"),
                    ("PRT", "print ads"),
                    ("RAD", "radio airtime and production costs"),
                    ("RFD", "returned contributions"),
                    ("SAL", "campaign workers salaries"),
                    ("TEL", "T.V. or cable airtime and production costs"),
                    ("TRC", "candidate travel, lodging and meals (explain)"),
                    ("TRS", "staff/spouse travel, lodging and meals (explain)"),
                    (
                        "TSF",
                        "transfer between committees of the same candidate/sponsor",
                    ),
                    ("VOT", "voter registration"),
                    ("WEB", "information technology costs (internet, e-mail)"),
                    ("ctb", "contribution (if nonmonetary, explain)*"),
                    ("ikd", "In-kind contribution (nonmonetary)"),
                    ("Mon", "monetary contribution"),
                    ("ofc", "office expenses"),
                    ("OFc", "office expenses"),
                    ("Ofc", "office expenses"),
                    ("", "Unknown"),
                    ("*", "Unknown"),
                    ("0", "Unknown"),
                    ("001", "Unknown"),
                    ("011", "Unknown"),
                    ("200", "Unknown"),
                    ("401", "Unknown"),
                    ("ADV", "Unknown"),
                    ("ANN", "Unknown"),
                    ("APR", "Unknown"),
                    ("AUG", "Unknown"),
                    ("AUT", "Unknown"),
                    ("Ban", "Unknown"),
                    ("BAN", "Unknown"),
                    ("BOO", "Unknown"),
                    ("BOX", "Unknown"),
                    ("C", "Unknown"),
                    ("CAT", "Unknown"),
                    ("CC", "Unknown"),
                    ("CHE", "Unknown"),
                    ("CIV", "Unknown"),
                    ("CNT", "Unknown"),
                    ("CON", "Unknown"),
                    ("COP", "Unknown"),
                    ("CRE", "Unknown"),
                    ("CSN", "Unknown"),
                    ("CT", "Unknown"),
                    (",CT", "Unknown"),
                    (".CT", "Unknown"),
                    ("CTN", "Unknown"),
                    ("CVD", "Unknown"),
                    ("DAT", "Unknown"),
                    ("DEC", "Unknown"),
                    ("Dem", "Unknown"),
                    ("DIN", "Unknown"),
                    ("Don", "Unknown"),
                    ("DON", "Unknown"),
                    ("Ear", "Unknown"),
                    ("EIM", "Unknown"),
                    ("EMP", "Unknown"),
                    ("F", "Unknown"),
                    ("FAX", "Unknown"),
                    ("FDN", "Unknown"),
                    ("FED", "Unknown"),
                    ("FEE", "Unknown"),
                    ("FIN", "Unknown"),
                    ("Fun", "Unknown"),
                    ("FUN", "Unknown"),
                    ("G", "Unknown"),
                    ("GEN", "Unknown"),
                    ("GGG", "Unknown"),
                    ("GOT", "Unknown"),
                    ("IEs", "Unknown"),
                    ("IN-", "Unknown"),
                    ("Ina", "Unknown"),
                    ("INK", "Unknown"),
                    ("INS", "Unknown"),
                    ("ITE", "Unknown"),
                    ("JAN", "Unknown"),
                    ("JUL", "Unknown"),
                    ("JUN", "Unknown"),
                    ("KIC", "Unknown"),
                    ("L", "Unknown"),
                    ("LEV", "Unknown"),
                    ("Lit", "Unknown"),
                    ("LN#", "Unknown"),
                    ("LOG", "Unknown"),
                    ("M", "Unknown"),
                    ("MAI", "Unknown"),
                    ("Mar", "Unknown"),
                    ("MAR", "Unknown"),
                    ("MAY", "Unknown"),
                    ("MED", "Unknown"),
                    ("MEE", "Unknown"),
                    ("MGT", "Unknown"),
                    ("Mis", "Unknown"),
                    ("MRB", "Unknown"),
                    ("NGP", "Unknown"),
                    ("NON", "Unknown"),
                    ("NOT", "Unknown"),
                    ("NOV", "Unknown"),
                    ("O", "Unknown"),
                    ("OCT", "Unknown"),
                    (".OF", "Unknown"),
                    ("OFF", "Unknown"),
                    ("OPE", "Unknown"),
                    ("OTH", "Unknown"),
                    ("P", "Unknown"),
                    ("Pac", "Unknown"),
                    ("PAI", "Unknown"),
                    ("PAR", "Unknown"),
                    ("PAY", "Unknown"),
                    ("PEN", "Unknown"),
                    ("PMT", "Unknown"),
                    (".PO", "Unknown"),
                    ("Pos", "Unknown"),
                    ("PRE", "Unknown"),
                    ("PRI", "Unknown"),
                    ("PRP", "Unknown"),
                    ("R", "Unknown"),
                    (".Re", "Unknown"),
                    (".RE", "Unknown"),
                    ("REF", "Unknown"),
                    ("REI", "Unknown"),
                    ("RFP", "Unknown"),
                    ("S", "Unknown"),
                    ("S-A", "Unknown"),
                    ("SA", "Unknown"),
                    ("Sal", "Unknown"),
                    ("S C", "Unknown"),
                    ("S.C", "Unknown"),
                    ("SCU", "Unknown"),
                    ("SEE", "Unknown"),
                    ("SEN", "Unknown"),
                    ("SEP", "Unknown"),
                    ("S.M.", "Unknown"),
                    ("SOF", "Unknown"),
                    ("SWI", "Unknown"),
                    ("T", "Unknown"),
                    ("TAX", "Unknown"),
                    ("TB", "Unknown"),
                    ("TB,", "Unknown"),
                    ("TIC", "Unknown"),
                    ("Tor", "Unknown"),
                    ("TRA", "Unknown"),
                    ("TRF", "Unknown"),
                    ("TRV", "Unknown"),
                    ("UN", "Unknown"),
                    ("UTI", "Unknown"),
                    ("V", "Unknown"),
                    ("VEN", "Unknown"),
                    ("-VO", "Unknown"),
                    ("VOI", "Unknown"),
                    ("VOY", "Unknown"),
                    ("WI", "Unknown"),
                    ("x", "Unknown"),
                    ("X", "Unknown"),
                    ("S-6", "Unknown"),
                    ("S.M", "Unknown"),
                    ("S-4", "Unknown"),
                    ("SA:", "Unknown"),
                    ("100", "Unknown"),
                    ("RFN", "Unknown"),
                    ("REN", "Unknown"),
                    ("003", "Unknown"),
                    ("S-1", "Unknown"),
                    ("08", "Unknown"),
                ],
                db_column="EXPN_CODE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=11
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=14, id="2712034-Cal-Format-201", start_page=13
                    ),
                ],
                help_text="The type of expenditure",
                max_length=3,
                verbose_name="expense code",
            ),
        ),
        migrations.AlterField(
            model_name="expncd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F450P5",
                        "Form 450 (Campaign Disclosure Statement, Short Form (Recipient Committee)): Part 5, Payments Made",
                    ),
                    (
                        "D",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule D, Summary of Expenditures Supporting / Opposing Other Candidates, Measures and Committees",
                    ),
                    (
                        "E",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule E, Payments Made",
                    ),
                    (
                        "G",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule G, Payments Made by an Agent or Independent Contractor (on Behalf of This Committee)",
                    ),
                    (
                        "F461P5",
                        "Form 461 (Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)): Part 5, Contributions (Including Loans, Forgiveness of Loans, and LoanGuarantees) and Expenditures Made",
                    ),
                    (
                        "F465P3",
                        "Form 465 (Supplemental Independent Expenditure Report): Part 3, Independent Expenditures Made",
                    ),
                    (
                        "F900",
                        "Form 900: Campaign Disclosure Statement (Public employee retirement board candidate)",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=31
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=42
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=6,
            ),
        ),
        migrations.AlterField(
            model_name="expncd",
            name="juris_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ASM", "Assembly District"),
                    ("BOE", "Board of Equalization District"),
                    ("CIT", "City"),
                    ("CTY", "County"),
                    ("LOC", "Local"),
                    ("OTH", "Other"),
                    ("SEN", "Senate District"),
                    ("STW", "Statewide"),
                    ("Cit", "City"),
                    ("sen", "Senate District"),
                    ("Sen", "Senate District"),
                    ("stw", "Statewide"),
                    ("APP", "Statewide"),
                    ("ASR", "County"),
                    ("ATT", "Statewide"),
                    ("GOV", "Statewide"),
                    ("LTG", "Statewide"),
                    ("SOS", "Statewide"),
                    ("SUP", "Statewide"),
                    ("TRE", "Statewide"),
                    ("BSU", "County"),
                    ("CSU", "County"),
                    ("ES", "City"),
                    ("SM", "City"),
                    ("BED", "Other"),
                    ("CCB", "Other"),
                    ("CCM", "Other"),
                    ("PDR", "Other"),
                    ("12", "Senate District"),
                    ("4", "Statewide"),
                    ("8", "Statewide"),
                    ("27", "Statewide"),
                    ("93", "Statewide"),
                    ("98", "Statewide"),
                    ("CLB", "Unknown"),
                    ("PER", "Unknown"),
                    ("Boa", "Board of Equalization District"),
                    ("Sta", "Unknown"),
                    ("STA", "Unknown"),
                    ("CA", "Unknown"),
                    ("SAN", "Unknown"),
                    ("ES ", "Unknown"),
                    ("CON", "Unknown"),
                    ("LA", "Unknown"),
                    ("LBC", "Unknown"),
                    ("OR", "Unknown"),
                    ("SB", "Unknown"),
                    ("WES", "Unknown"),
                    ("BM", "Unknown"),
                    ("(Lo", "Unknown"),
                    ("(Ci", "Unknown"),
                    ("vty", "Unknown"),
                    ("OC", "Unknown"),
                    ("SM ", "Unknown"),
                    ("ASS", "Unknown"),
                    ("JR", "Unknown"),
                    ("O", "Unknown"),
                    ("ADM", "Unknown"),
                    ("SAC", "Unknown"),
                    ("US", "Unknown"),
                    ("J", "Unknown"),
                    ("LOS", "Unknown"),
                    ("IRV", "Unknown"),
                    ("CO", "Unknown"),
                    ("JRS", "Unknown"),
                    ("NEV", "Unknown"),
                    ("IB", "Unknown"),
                    ("A", "Unknown"),
                    ("Ass", "Unknown"),
                    ("SD", "Unknown"),
                    ("D", "Unknown"),
                    ("SEC", "Unknown"),
                    ("SC", "Unknown"),
                    ("RB", "Unknown"),
                    ("GEN", "Unknown"),
                    ("CC", "Unknown"),
                    ("FED", "Unknown"),
                    ("FM", "Unknown"),
                    ("R", "Unknown"),
                ],
                db_column="JURIS_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=32
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=44
                    ),
                ],
                help_text="Office Jurisdiction Code",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="expncd",
            name="off_s_h_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("H", "HELD"),
                    ("S", "SOUGHT"),
                    ("s", "SOUGHT"),
                    ("h", "HELD"),
                    ("A", "UNKNOWN"),
                    ("a", "UNKNOWN"),
                    ("8", "UNKNOWN"),
                    ("O", "UNKNOWN"),
                ],
                db_column="OFF_S_H_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=32
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=44
                    ),
                ],
                help_text="Office is sought or held code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="expncd",
            name="office_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("APP", "State Appellate Court Justice"),
                    ("ASM", "State Assembly Person"),
                    ("ASR", "Assessor"),
                    ("ATT", "Attorney General"),
                    ("BED", "Board of Education"),
                    ("BOE", "Board of Equalization Member"),
                    ("BSU", "Board of Supervisors"),
                    ("CAT", "City Attorney"),
                    ("CCB", "Community College Board"),
                    ("CCM", "City Council Member"),
                    ("CON", "State Controller"),
                    ("COU", "County Counsel"),
                    ("CSU", "County Supervisor"),
                    ("CTR", "Local Controller"),
                    ("DAT", "District Attorney"),
                    ("GOV", "Governor"),
                    ("INS", "Insurance Commissioner"),
                    ("LTG", "Lieutenant Governor"),
                    ("MAY", "Mayor"),
                    ("OTH", "Other"),
                    ("PDR", "Public Defender"),
                    ("PER", "Public Employees Retirement System"),
                    ("PLN", "Planning Commissioner"),
                    ("SCJ", "Superior Court Judge"),
                    ("SEN", "State Senator"),
                    ("SHC", "Sheriff-Coroner"),
                    ("SOS", "Secretary of State"),
                    ("SPM", "Supreme Court Justice"),
                    ("SUP", "Superintendent of Public Instruction"),
                    ("TRE", "State Treasurer"),
                    ("TRS", "Local Treasurer"),
                    ("Cou", "County Counsel"),
                    ("sen", "State Senator"),
                    ("AtT", "Attorney General"),
                    ("May", "Mayor"),
                    ("Sen", "State Senator"),
                    ("asm", "State Assembly Person"),
                    ("gov", "Governor"),
                    ("Gov", "Governor"),
                    ("LA", "Unknown"),
                    ("HOU", "Unknown"),
                    ("LAD", "Unknown"),
                    ("11A", "Unknown"),
                    ("001", "Unknown"),
                    ("BM", "Unknown"),
                    ("AS1", "Unknown"),
                    ("ASS", "Unknown"),
                    ("73", "Unknown"),
                    ("CIT", "Unknown"),
                    ("HSE", "Unknown"),
                    ("LT", "Unknown"),
                    ("CTY", "Unknown"),
                    ("STA", "Unknown"),
                    ("GO", "Unknown"),
                    ("CO", "Unknown"),
                    ("A", "Unknown"),
                    ("PAC", "Unknown"),
                    ("REP", "Unknown"),
                    ("OFF", "Unknown"),
                    ("SE", "Unknown"),
                    ("031", "Unknown"),
                    ("COM", "Unknown"),
                    ("ASB", "Unknown"),
                    ("OT", "Unknown"),
                    ("NAT", "Unknown"),
                    ("CC", "Unknown"),
                    ("SWE", "Unknown"),
                    ("FED", "Unknown"),
                    ("STE", "Unknown"),
                    ("H", "Unknown"),
                    ("DA", "Unknown"),
                    ("S", "Unknown"),
                    ("AS", "Unknown"),
                    ("OF", "Unknown"),
                    ("LEG", "Unknown"),
                    ("STW", "Unknown"),
                    ("ST", "Unknown"),
                    ("PRE", "Unknown"),
                    ("/S", "Unknown"),
                    ("U S", "Unknown"),
                    ("O", "Unknown"),
                    ("8", "Unknown"),
                    ("C:S", "Unknown"),
                ],
                db_column="OFFICE_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=10
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=12
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712032-Cal-Errata-201", start_page=2
                    ),
                ],
                help_text="Identifies the office being sought",
                max_length=3,
                verbose_name="office code",
            ),
        ),
        migrations.AlterField(
            model_name="expncd",
            name="sup_opp_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("O", "OPPOSITION"),
                    ("S", "SUPPORT"),
                    ("s", "SUPPORT"),
                    ("o", "OPPOSITION"),
                    ("H", "UNKNOWN"),
                    ("N", "UNKNOWN"),
                    ("X", "UNKNOWN"),
                    ("Y", "UNKNOWN"),
                ],
                db_column="SUP_OPP_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=32
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=44
                    ),
                ],
                help_text="Support or opposition code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="f495p2cd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F450",
                        "Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        "F460",
                        "Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        "F495",
                        "Form 495: Supplemental Pre-Election Campaign Statement (Recipient Committee)",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=26
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=35
                    ),
                ],
                help_text="Name of the source filing form to which the Form 495 is attached (must equal Form_Type in CVR record)",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="f501502cd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ATH", "Authorizing individual"),
                    ("ATR", "Assistant treasurer"),
                    ("BMC", "Ballot measure committee"),
                    ("BNM", "Ballot measure's name/title"),
                    ("CAO", "Candidate/officeholder"),
                    ("COM", "Committee"),
                    ("CTL", "Controlled committee"),
                    ("IND", "Individual"),
                    ("MDI", "Major Donor/Ind Expenditure"),
                    ("OFF", "Officer"),
                    ("OTH", "Other"),
                    ("POF", "Principal officer"),
                    ("PRO", "Proponent"),
                    ("PTY", "Political Party"),
                    ("RCP", "Recipient committee"),
                    ("SCC", "Small Contributor Committee"),
                    ("SMO", "Slate-mailer organization"),
                    ("SPO", "Sponsor"),
                    ("TRE", "Treasurer"),
                    ("8", "Unknown"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=9, id="2712033-Cal-Format-1-05-02", start_page=8
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=11, id="2712034-Cal-Format-201", start_page=9
                    ),
                ],
                help_text="Entity code",
                max_length=9,
            ),
        ),
        migrations.AlterField(
            model_name="f501502cd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("F501", "Form 501: Candidate Intention Statement"),
                    ("F502", "Form 502: Campaign Bank Account Statement"),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711614-CalAccessTablesWeb", start_page=58
                    )
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="f690p2cd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("F615", "Form 615: Lobbyist Report"),
                    ("F625", "Form 625: Report of Lobbying Firm"),
                    (
                        "F635",
                        "Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                    ("F645", "Form 645: Report of Person Spending $5,000 or More"),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=58
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=72
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="filerfilingscd",
            name="form_id",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F400",
                        "Form 400: Statement of Organization (Slate Mailer Organization)",
                    ),
                    (
                        "F401",
                        "Form 401: Campaign Disclosure Statement (Slate Mailer Organization)",
                    ),
                    (
                        "F402",
                        "Form 402: Statement of Termination (Slate Mailer Organization)",
                    ),
                    ("F405", "Form 405: Amendment to Campaign Disclosure Statement"),
                    (
                        "F410",
                        "Form 410: Statement of Organization (Recipient Committee)",
                    ),
                    ("F415", "Form 415: Title Unknown"),
                    ("F416", "Form 416: Title Unknown"),
                    (
                        "F419",
                        "Form 419: Campaign Disclosure Statement, Long Form (Ballot Measure Committee)",
                    ),
                    (
                        "F420",
                        "Form 420: Campaign Disclosure Statement, Long Form (Recipient Committee)",
                    ),
                    (
                        "F425",
                        "Form 425: Semi-Annual Statement of No Activity (Recipient Committee)",
                    ),
                    ("F430", "Form 430: Title Unknown"),
                    (
                        "F450",
                        "Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        "F460",
                        "Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        "F461",
                        "Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                    ("F465", "Form 465: Supplemental Independent Expenditure Report"),
                    (
                        "F470",
                        "Form 470: Campaign Disclosure Statement, Short Form (Officeholders and Candidates)",
                    ),
                    (
                        "F490",
                        "Form 490: Campaign Disclosure Statement, Long Form (Officeholders and Candidates)",
                    ),
                    (
                        "F495",
                        "Form 495: Supplemental Pre-Election Campaign Statement (Recipient Committee)",
                    ),
                    ("F496", "Form 496: Late Independent Expenditure Report"),
                    ("F497", "Form 497: Late Contribution Report"),
                    (
                        "F498",
                        "Form 498: Late Payment Report (Slate Mailer Organization)",
                    ),
                    ("F501", "Form 501: Candidate Intention Statement"),
                    ("F502", "Form 502: Campaign Bank Account Statement"),
                    ("F511", "Form 511: Paid Spokesperson Report"),
                    ("E530", "Electronic Form 530: Electronic Issue Advocacy Report"),
                    ("F601", "Form 601: Lobbying Firm Registration Statement"),
                    ("F602", "Form 602: Lobbying Firm Activity Authorization"),
                    (
                        "F603",
                        "Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                    ),
                    ("F604", "Form 604: Lobbyist Certification Statement"),
                    (
                        "F605",
                        "Form 605: Amendment to Registration, Lobbying Firm, Lobbyist Employer, Lobbying Coalition",
                    ),
                    ("F606", "Form 606: Notice of Termination"),
                    ("F607", "Form 607: Notice of Withdrawal"),
                    ("F615", "Form 615: Lobbyist Report"),
                    ("F625", "Form 625: Report of Lobbying Firm"),
                    (
                        "S630",
                        "Schedule 630: Payments Made to Lobbying Coalitions (Attachment to Form 625 or 635) ",
                    ),
                    (
                        "F635",
                        "Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                    (
                        "S635-C",
                        "Schedule 635C: Payments Received by Lobbying Coalitions",
                    ),
                    (
                        "S640",
                        "Schedule 640: Governmental Agencies Reporting (Attachment to Form 635 or Form 645)",
                    ),
                    ("F645", "Form 645: Report of Person Spending $5,000 or More"),
                    ("F690", "Form 690: Amendment to Lobbying Disclosure Report"),
                    ("F700", "Form 700: Statement of Economic Interest"),
                    (
                        "F900",
                        "Form 900: Campaign Disclosure Statement (Public employee retirement board candidate)",
                    ),
                    ("F111", "Unknown"),
                    ("F410 AT", "Unknown"),
                    ("F410ATR", "Unknown"),
                    ("F421", "Unknown"),
                    ("F440", "Unknown"),
                    (
                        "F470S",
                        "Form 470: Campaign Disclosure Statement, Short Form (Officeholders and Candidates)",
                    ),
                    ("F480", "Unknown"),
                    ("F500", "Unknown"),
                    (
                        "F501502",
                        "Forms 501 and/or 502 (Candidate Intention and/or Bank Account Statements)",
                    ),
                    ("F555", "Unknown"),
                    ("F666", "Unknown"),
                    ("F777", "Unknown"),
                    ("F888", "Unknown"),
                    ("F999", "Unknown"),
                ],
                db_column="FORM_ID",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711614-CalAccessTablesWeb", start_page=65
                    )
                ],
                help_text="Form identification code",
                max_length=7,
                verbose_name="form type",
            ),
        ),
        migrations.AlterField(
            model_name="headercd",
            name="form_id",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("AF490", "Form 490, Part A"),
                    ("AP1", "Allocation Part 1"),
                    ("AP2", "Allocation Part 2"),
                    ("BF490", "Form 490, Part B"),
                    ("CF490", "Form 490, Part C"),
                    ("DF490", "Form 490, Part D"),
                    ("EF490", "Form 490, Part E"),
                    (
                        "F450",
                        "Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        "F460",
                        "Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        "F461",
                        "Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                    ("FF490", "Form 490, Part F"),
                    ("HF490", "Form 490, Part H"),
                    ("IF490", "Form 490, Part I"),
                ],
                db_column="FORM_ID",
                help_text="Form identification code",
                max_length=5,
                verbose_name="Form ID",
            ),
        ),
        migrations.AlterField(
            model_name="lattcd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("FRM", "Lobbying Firm"),
                    ("IND", "Person (spending > $5000)"),
                    ("LBY", "Lobbyist (an individual)"),
                    ("LCO", "Lobbying Coalition"),
                    ("LEM", "Lobbying Employer"),
                    ("OTH", "Other"),
                    ("RCP", "Recipient Committee"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=65
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=80
                    ),
                ],
                help_text="Entity Code of the Payment Recipient/Payee",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="lattcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "S630",
                        "Schedule 630: Payments Made to Lobbying Coalitions (Attachment to Form 625 or 635) ",
                    ),
                    (
                        "S635-C",
                        "Schedule 635C: Payments Received by Lobbying Coalitions",
                    ),
                    (
                        "S640",
                        "Schedule 640: Governmental Agencies Reporting (Attachment to Form 635 or Form 645)",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=52
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=65
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=79
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=6,
            ),
        ),
        migrations.AlterField(
            model_name="lccmcd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("COM", "Committee"),
                    ("RCP", "Recipient Committee"),
                    ("CTL", "Controlled committee"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=64
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=78
                    ),
                ],
                help_text="Entity Code for Recipient of the Campaign Contribution Value",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="lccmcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F615P2",
                        "Form 615 (Lobbyist Report): Part 2, Campaign Contributions Made or Delivered",
                    ),
                    (
                        "F625P4B",
                        "Form 625 (Report of Lobbying Firm): Part 4, Campaign Contributions Made",
                    ),
                    (
                        "F635P4B",
                        "Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 4, Campaign Contributions Made",
                    ),
                    (
                        "F645P3B",
                        "Form 645 (Report of Person Spending $5,000 or More): Part 3, Campaign Contributions Made",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=64
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=79, id="2712034-Cal-Format-201", start_page=78
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=7,
            ),
        ),
        migrations.AlterField(
            model_name="lempcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F601P2A",
                        "Form 601 (Lobbying Firm Registration Statement): Part 2, Section A, Lobbyist Employers",
                    ),
                    (
                        "F601P2B",
                        "Form 601 (Lobbying Firm Registration Statement): Part 2, Section B, Subcontracted Clients",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=75
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=90
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=7,
                verbose_name="form type",
            ),
        ),
        migrations.AlterField(
            model_name="lexpcd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("IND", "Person (spending > $5000)"), ("OTH", "Other")],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=61
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=75
                    ),
                ],
                help_text="Entity Code of the Payee",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="lexpcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F615P1",
                        "Form 615 (Lobbyist Report): Part 1, Activity Expenses Paid, Incurred, Arranged or Provided by the Lobbyist",
                    ),
                    (
                        "F625P3A",
                        "Form 625 (Report of Lobbying Firm): Part 3, Payments Made In Connection With Lobbying Activities, Section A, Activity Expenses",
                    ),
                    (
                        "F635P3C",
                        "Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section C, Activity Expenses",
                    ),
                    (
                        "F645P2A",
                        "Form 645 (Report of Person Spending $5,000 or More): Part 2, Payments Made this Period, Section A, Activity Expenses",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=61
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=74
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=7,
            ),
        ),
        migrations.AlterField(
            model_name="loancd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("COM", "Committee"),
                    ("IND", "Individual"),
                    ("OTH", "Other"),
                    ("PTY", "Political Party"),
                    ("RCP", "Recipient committee"),
                    ("SCC", "Small Contributor Committee"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=35
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=47
                    ),
                ],
                help_text="Entity code describing the lender",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="loancd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "B1",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 1, Loans Received",
                    ),
                    (
                        "B2",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 2, Loan Guarantors",
                    ),
                    (
                        "B3",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 3, Outstanding Balance",
                    ),
                    (
                        "H",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Loans Made to Others",
                    ),
                    (
                        "H1",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Part 1, Loans Made",
                    ),
                    (
                        "H2",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Part 2, Repayments Rcvd",
                    ),
                    (
                        "H3",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Part 3, Outstanding Loans",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=35
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=47
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=2,
            ),
        ),
        migrations.AlterField(
            model_name="lobbyamendmentscd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("F601", "Form 601: Lobbying Firm Registration Statement"),
                    (
                        "F603",
                        "Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=74
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=88
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=9,
            ),
        ),
        migrations.AlterField(
            model_name="lothcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F625P3B",
                        "Form 625 (Report of Lobbying Firm): Part 3, Payments Made In Connection With Lobbying Activities, Section B, Payments Made",
                    )
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=63
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=77
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=7,
                verbose_name="form type",
            ),
        ),
        migrations.AlterField(
            model_name="lpaycd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("FRM", "Lobbying Firm"),
                    ("LCO", "Lobbying Coalition"),
                    ("LEM", "Lobbying Employer"),
                    ("OTH", "Other"),
                    ("128", "Unknown"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=62
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=76
                    ),
                ],
                help_text="Entity Code of the Employer Values",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="lpaycd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F625P2",
                        "Form 625 (Report of Lobbying Firm): Part 2, Payments Received in Connection with Lobbying Activity",
                    ),
                    (
                        "F635P3B",
                        "Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section B, Payments To Lobbying Firms",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=62
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=76
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=7,
                verbose_name="form type",
            ),
        ),
        migrations.AlterField(
            model_name="rcptcd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("COM", "Committee"),
                    ("IND", "Individual"),
                    ("PTY", "Political Party"),
                    ("OTH", "Other"),
                    ("RCP", "Recipient committee"),
                    ("SCC", "Small Contributor Committee"),
                    ("Com", "Committee"),
                    ("CAO", "Candidate/officeholder"),
                    ("BNM", "Ballot measure's name/title"),
                    ("OFF", "Officer"),
                    ("0", "Unknown"),
                    ("PTH", "Unknown"),
                    ("RFD", "Unknown"),
                    ("MBR", "Unknown"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=71
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=29
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=37
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=9, id="2712033-Cal-Format-1-05-02", start_page=8
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=11, id="2712034-Cal-Format-201", start_page=9
                    ),
                ],
                help_text="Entity Code describing the contributor",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="rcptcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("E530", "Electronic Form 530: Electronic Issue Advocacy Report"),
                    (
                        "F900",
                        "Form 900: Campaign Disclosure Statement (Public employee retirement board candidate)",
                    ),
                    (
                        "F401A",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule A, Payments Received",
                    ),
                    (
                        "A",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule A, Monetary Contributions Received",
                    ),
                    (
                        "A-1",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule A-1, Contributions Transferred to Special Election Commitee",
                    ),
                    (
                        "C",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule C, Non-Monetary Contributions Received",
                    ),
                    (
                        "I",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule I, Miscellanous increases to cash",
                    ),
                    (
                        "F496P3",
                        "Form 496 (Late Independent Expenditure Report): Part 3, Contributions > $100 Received",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=29
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=37
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=9,
            ),
        ),
        migrations.AlterField(
            model_name="rcptcd",
            name="juris_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ASM", "Assembly District"),
                    ("BOE", "Board of Equalization District"),
                    ("CIT", "City"),
                    ("CTY", "County"),
                    ("LOC", "Local"),
                    ("OTH", "Other"),
                    ("SEN", "Senate District"),
                    ("STW", "Statewide"),
                    ("BED", "Other"),
                    ("CLB", "Other"),
                    ("COU", "County"),
                    ("CO", "Other"),
                    ("SAC", "Unknown"),
                    ("PER", "Unknown"),
                    ("SF", "Unknown"),
                    ("OR", "Unknown"),
                    ("AL", "Unknown"),
                    ("4", "Unknown"),
                    ("CA", "Unknown"),
                ],
                db_column="JURIS_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=74
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=30
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=40
                    ),
                ],
                help_text="Office jurisdiction code. See the CAL document for the list of legal values. Used on Form 401 Schedule A",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="rcptcd",
            name="off_s_h_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("S", "SOUGHT"), ("H", "HELD")],
                db_column="OFF_S_H_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=75
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=30
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=40
                    ),
                ],
                help_text="Office is sought or held code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="rcptcd",
            name="office_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("APP", "State Appellate Court Justice"),
                    ("ASM", "State Assembly Person"),
                    ("ASR", "Assessor"),
                    ("ATT", "Attorney General"),
                    ("BED", "Board of Education"),
                    ("BOE", "Board of Equalization Member"),
                    ("BSU", "Board of Supervisors"),
                    ("CAT", "City Attorney"),
                    ("CCB", "Community College Board"),
                    ("CCM", "City Council Member"),
                    ("CON", "State Controller"),
                    ("COU", "County Counsel"),
                    ("CSU", "County Supervisor"),
                    ("CTR", "Local Controller"),
                    ("DAT", "District Attorney"),
                    ("GOV", "Governor"),
                    ("INS", "Insurance Commissioner"),
                    ("LTG", "Lieutenant Governor"),
                    ("MAY", "Mayor"),
                    ("OTH", "Other"),
                    ("PDR", "Public Defender"),
                    ("PER", "Public Employees Retirement System"),
                    ("PLN", "Planning Commissioner"),
                    ("SCJ", "Superior Court Judge"),
                    ("SEN", "State Senator"),
                    ("SHC", "Sheriff-Coroner"),
                    ("SOS", "Secretary of State"),
                    ("SPM", "Supreme Court Justice"),
                    ("SUP", "Superintendent of Public Instruction"),
                    ("TRE", "State Treasurer"),
                    ("TRS", "Local Treasurer"),
                    ("asm", "State Assembly Person"),
                    ("gov", "Governor"),
                    ("OTh", "Other"),
                    ("oth", "Other"),
                    ("csu", "County Supervisor"),
                    ("H", "Unknown"),
                    ("HOU", "Unknown"),
                    ("ASS", "Unknown"),
                ],
                db_column="OFFICE_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=10
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=12
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712032-Cal-Errata-201", start_page=2
                    ),
                ],
                help_text="Identifies the office being sought",
                max_length=3,
                verbose_name="office code",
            ),
        ),
        migrations.AlterField(
            model_name="rcptcd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("E530", "Electronic Form 530: Electronic Issue Advocacy Report"),
                    ("RCPT", "Receipt"),
                ],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=71
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=37
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=29
                    ),
                ],
                help_text="Record Type Value: CVR",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="rcptcd",
            name="sup_opp_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("S", "SUPPORT"), ("O", "OPPOSITION"), ("F", "Unknown")],
                db_column="SUP_OPP_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=74
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=30
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=40
                    ),
                ],
                help_text="Support or opposition code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="receivedfilingscd",
            name="form_id",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    (
                        "F400",
                        "Form 400: Statement of Organization (Slate Mailer Organization)",
                    ),
                    (
                        "F401",
                        "Form 401: Campaign Disclosure Statement (Slate Mailer Organization)",
                    ),
                    (
                        "F402",
                        "Form 402: Statement of Termination (Slate Mailer Organization)",
                    ),
                    (
                        "F410",
                        "Form 410: Statement of Organization (Recipient Committee)",
                    ),
                    (
                        "F425",
                        "Form 425: Semi-Annual Statement of No Activity (Recipient Committee)",
                    ),
                    (
                        "F450",
                        "Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        "F460",
                        "Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        "F461",
                        "Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                    ("F465", "Form 465: Supplemental Independent Expenditure Report"),
                    ("F496", "Form 496: Late Independent Expenditure Report"),
                    ("F497", "Form 497: Late Contribution Report"),
                    (
                        "F498",
                        "Form 498: Late Payment Report (Slate Mailer Organization)",
                    ),
                    ("F601", "Form 601: Lobbying Firm Registration Statement"),
                    ("F602", "Form 602: Lobbying Firm Activity Authorization"),
                    (
                        "F603",
                        "Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                    ),
                    ("F604", "Form 604: Lobbyist Certification Statement"),
                    ("F606", "Form 606: Notice of Termination"),
                    ("F607", "Form 607: Notice of Withdrawal"),
                    ("F615", "Form 615: Lobbyist Report"),
                    ("F625", "Form 625: Report of Lobbying Firm"),
                    (
                        "F635",
                        "Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                    ("F645", "Form 645: Report of Person Spending $5,000 or More"),
                ],
                db_column="FORM_ID",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=8, id="2711624-Overview", start_page=4
                    )
                ],
                help_text="Form identification code",
                max_length=7,
                verbose_name="form identification code",
            ),
        ),
        migrations.AlterField(
            model_name="s401cd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    (
                        "F401B",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule B, Payments Made",
                    ),
                    (
                        "F401B-1",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule B-1, Payments Made by Agent or Independent Contractor",
                    ),
                    (
                        "F401C",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule C, Persons Receiving $1,000 or More",
                    ),
                    (
                        "F401D",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule D, Candidates and Measures Not Listed on Schedule A",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=39
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=51
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=7,
            ),
        ),
        migrations.AlterField(
            model_name="s401cd",
            name="juris_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ASM", "Assembly District"),
                    ("BOE", "Board of Equalization District"),
                    ("CIT", "City"),
                    ("CTY", "County"),
                    ("LOC", "Local"),
                    ("OTH", "Other"),
                    ("SEN", "Senate District"),
                    ("STW", "Statewide"),
                    ("SAC", "Unknown"),
                    ("CT", "Unknown"),
                    ("ca", "Unknown"),
                    ("CAL", "Unknown"),
                    ("OR", "Unknown"),
                    ("AL", "Unknown"),
                    ("CA", "Unknown"),
                    ("10", "Unknown"),
                ],
                db_column="JURIS_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=77
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=39
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=52
                    ),
                ],
                help_text="Office jurisdiction code",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="s401cd",
            name="off_s_h_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("S", "SOUGHT"), ("H", "HELD")],
                db_column="OFF_S_H_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=39
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=52
                    ),
                ],
                help_text="Office is sought or held code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="s401cd",
            name="office_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("APP", "State Appellate Court Justice"),
                    ("ASM", "State Assembly Person"),
                    ("ASR", "Assessor"),
                    ("ATT", "Attorney General"),
                    ("BED", "Board of Education"),
                    ("BOE", "Board of Equalization Member"),
                    ("BSU", "Board of Supervisors"),
                    ("CAT", "City Attorney"),
                    ("CCB", "Community College Board"),
                    ("CCM", "City Council Member"),
                    ("CON", "State Controller"),
                    ("COU", "County Counsel"),
                    ("CSU", "County Supervisor"),
                    ("CTR", "Local Controller"),
                    ("DAT", "District Attorney"),
                    ("GOV", "Governor"),
                    ("INS", "Insurance Commissioner"),
                    ("LTG", "Lieutenant Governor"),
                    ("MAY", "Mayor"),
                    ("OTH", "Other"),
                    ("PDR", "Public Defender"),
                    ("PER", "Public Employees Retirement System"),
                    ("PLN", "Planning Commissioner"),
                    ("SCJ", "Superior Court Judge"),
                    ("SEN", "State Senator"),
                    ("SHC", "Sheriff-Coroner"),
                    ("SOS", "Secretary of State"),
                    ("SPM", "Supreme Court Justice"),
                    ("SUP", "Superintendent of Public Instruction"),
                    ("TRE", "State Treasurer"),
                    ("TRS", "Local Treasurer"),
                    ("asm", "State Assembly Person"),
                    ("ltg", "Lieutenant Governor"),
                    ("OTh", "Other"),
                    ("att", "Attorney General"),
                    ("oth", "Other"),
                    ("tre", "State Treasurer"),
                    ("con", "State Controller"),
                    ("boe", "Board of Equalization Member"),
                    ("sos", "Secretary of State"),
                    ("sup", "Superintendent of Public Instruction"),
                    ("H", "Unknown"),
                ],
                db_column="OFFICE_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=10
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=12
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712032-Cal-Errata-201", start_page=2
                    ),
                ],
                help_text="Identifies the office being sought",
                max_length=3,
                verbose_name="office code",
            ),
        ),
        migrations.AlterField(
            model_name="s401cd",
            name="sup_opp_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("S", "SUPPORT"), ("O", "OPPOSITION")],
                db_column="SUP_OPP_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=39
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=52
                    ),
                ],
                help_text="Support or opposition code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="s496cd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("F496", "Form 496: Late Independent Expenditure Report")],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=40
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=53
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="s497cd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("BNM", "Ballot measure's name/title"),
                    ("CAO", "Candidate/officeholder"),
                    ("CTL", "Controlled committee"),
                    ("COM", "Committee"),
                    ("com", "Committee"),
                    ("IND", "Individual"),
                    ("OFF", "Officer"),
                    ("OTH", "Other"),
                    ("PTY", "Political Party"),
                    ("RCP", "Recipient committee"),
                    ("SCC", "Small Contributor Committee"),
                    ("0", "Unknown"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=9, id="2712033-Cal-Format-1-05-02", start_page=8
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=11, id="2712034-Cal-Format-201", start_page=9
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=41
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=54
                    ),
                ],
                help_text="Entity Code describing the Contributor/Recipient",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="s497cd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F497P1",
                        "Form 497 (Late Contribution Report): Part 1, Contributions Received",
                    ),
                    (
                        "F497P2",
                        "Form 497 (Late Contribution Report): Part 2, Contributions Made",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=41
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=54
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=6,
            ),
        ),
        migrations.AlterField(
            model_name="s497cd",
            name="juris_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ASM", "Assembly District"),
                    ("BOE", "Board of Equalization District"),
                    ("CIT", "City"),
                    ("CTY", "County"),
                    ("LOC", "Local"),
                    ("OTH", "Other"),
                    ("SEN", "Senate District"),
                    ("STW", "Statewide"),
                    ("asm", "Assembly District"),
                    ("sen", "Senate District"),
                    ("cit", "City"),
                    ("GOV", "Statewide"),
                    ("MAY", "City"),
                    ("BSU", "County"),
                    ("CSU", "County"),
                    ("SUP", "Statewide"),
                    ("BED", "Other"),
                    ("CCB", "Other"),
                    ("CCM", "Other"),
                    ("CLB", "Other"),
                    ("IRV", "City"),
                    ("Fon", "City"),
                    ("JRS", "Statewide"),
                    ("CO", "County"),
                    ("Riv", "County"),
                    ("SNE", "Senate District"),
                    ("83", "Statewide"),
                    ("PER", "Unknown"),
                    ("FED", "Unknown"),
                    ("CA", "Unknown"),
                    ("JR", "Unknown"),
                ],
                db_column="JURIS_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=42
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=55
                    ),
                ],
                help_text="Jurisdiction code describing the office being sought",
                max_length=3,
                verbose_name="jurisdiction code",
            ),
        ),
        migrations.AlterField(
            model_name="s497cd",
            name="off_s_h_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("H", "HELD"),
                    ("S", "SOUGHT"),
                    ("s", "SOUGHT"),
                    ("h", "HELD"),
                    ("F", "UNKNOWN"),
                    ("T", "UNKNOWN"),
                ],
                db_column="OFF_S_H_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=42
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=55
                    ),
                ],
                help_text="Office is sought or held code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="s497cd",
            name="office_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("APP", "State Appellate Court Justice"),
                    ("ASM", "State Assembly Person"),
                    ("ASR", "Assessor"),
                    ("ATT", "Attorney General"),
                    ("BED", "Board of Education"),
                    ("BOE", "Board of Equalization Member"),
                    ("BSU", "Board of Supervisors"),
                    ("CAT", "City Attorney"),
                    ("CCB", "Community College Board"),
                    ("CCM", "City Council Member"),
                    ("CON", "State Controller"),
                    ("COU", "County Counsel"),
                    ("CSU", "County Supervisor"),
                    ("CTR", "Local Controller"),
                    ("DAT", "District Attorney"),
                    ("GOV", "Governor"),
                    ("INS", "Insurance Commissioner"),
                    ("LTG", "Lieutenant Governor"),
                    ("MAY", "Mayor"),
                    ("OTH", "Other"),
                    ("PDR", "Public Defender"),
                    ("PER", "Public Employees Retirement System"),
                    ("PLN", "Planning Commissioner"),
                    ("SCJ", "Superior Court Judge"),
                    ("SEN", "State Senator"),
                    ("SHC", "Sheriff-Coroner"),
                    ("SOS", "Secretary of State"),
                    ("SPM", "Supreme Court Justice"),
                    ("SUP", "Superintendent of Public Instruction"),
                    ("TRE", "State Treasurer"),
                    ("TRS", "Local Treasurer"),
                    ("asm", "State Assembly Person"),
                    ("sen", "State Senator"),
                    ("Asm", "State Assembly Person"),
                    ("May", "Mayor"),
                    ("ASm", "State Assembly Person"),
                    ("oth", "Other"),
                    ("csu", "County Supervisor"),
                    ("Oth", "Other"),
                    ("H", "Unknown"),
                    ("S", "Unknown"),
                    ("OF", "Unknown"),
                    ("HOU", "Unknown"),
                    ("LOC", "Unknown"),
                    ("LEG", "Unknown"),
                    ("STW", "Unknown"),
                    ("P", "Unknown"),
                    ("LTV", "Unknown"),
                    ("LT", "Unknown"),
                    ("CTY", "Unknown"),
                    ("OFF", "Unknown"),
                    ("REP", "Unknown"),
                    ("COM", "Unknown"),
                    ("N/A", "Unknown"),
                ],
                db_column="OFFICE_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=10
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=12
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712032-Cal-Errata-201", start_page=2
                    ),
                ],
                help_text="Identifies the office being sought",
                max_length=3,
                verbose_name="office code",
            ),
        ),
        migrations.AlterField(
            model_name="s497cd",
            name="sup_opp_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("O", "OPPOSITION"), ("S", "SUPPORT")],
                db_column="SUP_OPP_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=82
                    )
                ],
                help_text="Support or opposition code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="s498cd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("CAO", "Candidate/officeholder"),
                    ("COM", "Committee"),
                    ("IND", "Individual"),
                    ("OTH", "Other"),
                    ("RCP", "Recipient committee"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=9, id="2712033-Cal-Format-1-05-02", start_page=8
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=11, id="2712034-Cal-Format-201", start_page=9
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=43
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=56
                    ),
                ],
                help_text="Entity code",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="s498cd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    (
                        "F498-A",
                        "Form 498 (Late Payment Report (Slate Mailer Organization)): Part A, Late Payments Attributed To",
                    ),
                    (
                        "F498-R",
                        "Form 498 (Late Payment Report (Slate Mailer Organization)): Part R, Late Payments Received From",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=43
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=56
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=9,
            ),
        ),
        migrations.AlterField(
            model_name="s498cd",
            name="juris_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ASM", "Assembly District"),
                    ("BOE", "Board of Equalization District"),
                    ("CIT", "City"),
                    ("CTY", "County"),
                    ("LOC", "Local"),
                    ("OTH", "Other"),
                    ("SEN", "Senate District"),
                    ("STW", "Statewide"),
                    ("GOV", "Statewide"),
                    ("COU", "County"),
                ],
                db_column="JURIS_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=43
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=57
                    ),
                ],
                help_text="Office jurisdiction code",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="s498cd",
            name="off_s_h_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("H", "HELD"), ("S", "SOUGHT")],
                db_column="OFF_S_H_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=44
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=57
                    ),
                ],
                help_text="Office is sought or held code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="s498cd",
            name="office_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("APP", "State Appellate Court Justice"),
                    ("ASM", "State Assembly Person"),
                    ("ASR", "Assessor"),
                    ("ATT", "Attorney General"),
                    ("BED", "Board of Education"),
                    ("BOE", "Board of Equalization Member"),
                    ("BSU", "Board of Supervisors"),
                    ("CAT", "City Attorney"),
                    ("CCB", "Community College Board"),
                    ("CCM", "City Council Member"),
                    ("CON", "State Controller"),
                    ("COU", "County Counsel"),
                    ("CSU", "County Supervisor"),
                    ("CTR", "Local Controller"),
                    ("DAT", "District Attorney"),
                    ("GOV", "Governor"),
                    ("INS", "Insurance Commissioner"),
                    ("LTG", "Lieutenant Governor"),
                    ("MAY", "Mayor"),
                    ("OTH", "Other"),
                    ("PDR", "Public Defender"),
                    ("PER", "Public Employees Retirement System"),
                    ("PLN", "Planning Commissioner"),
                    ("SCJ", "Superior Court Judge"),
                    ("SEN", "State Senator"),
                    ("SHC", "Sheriff-Coroner"),
                    ("SOS", "Secretary of State"),
                    ("SPM", "Supreme Court Justice"),
                    ("SUP", "Superintendent of Public Instruction"),
                    ("TRE", "State Treasurer"),
                    ("TRS", "Local Treasurer"),
                    ("gov", "Governor"),
                    ("oth", "Other"),
                ],
                db_column="OFFICE_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=10
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=12
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712032-Cal-Errata-201", start_page=2
                    ),
                ],
                help_text="Identifies the office being sought",
                max_length=4,
                verbose_name="office code",
            ),
        ),
        migrations.AlterField(
            model_name="s498cd",
            name="sup_opp_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("O", "OPPOSITION"), ("S", "SUPPORT")],
                db_column="SUP_OPP_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=43
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=57
                    ),
                ],
                help_text="Support or opposition code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="smrycd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F401",
                        "Form 401: Campaign Disclosure Statement (Slate Mailer Organization)",
                    ),
                    (
                        "F401A",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule A, Payments Received",
                    ),
                    (
                        "F401B",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule B, Payments Made",
                    ),
                    (
                        "F401B-1",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule B-1, Payments Made by Agent or Independent Contractor",
                    ),
                    (
                        "F450",
                        "Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        "F460",
                        "Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        "A",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule A, Monetary Contributions Received",
                    ),
                    (
                        "B1",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 1, Loans Received",
                    ),
                    (
                        "B2",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 2, Loan Guarantors",
                    ),
                    (
                        "B3",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 3, Outstanding Balance",
                    ),
                    (
                        "C",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule C, Non-Monetary Contributions Received",
                    ),
                    (
                        "D",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule D, Summary of Expenditures Supporting / Opposing Other Candidates, Measures and Committees",
                    ),
                    (
                        "E",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule E, Payments Made",
                    ),
                    (
                        "F",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule F, Accrued Expenses (Unpaid Bills)",
                    ),
                    (
                        "G",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule G, Payments Made by an Agent or Independent Contractor (on Behalf of This Committee)",
                    ),
                    (
                        "H",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Loans Made to Others",
                    ),
                    (
                        "H1",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Part 1, Loans Made",
                    ),
                    (
                        "H2",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Part 2, Repayments Rcvd",
                    ),
                    (
                        "H3",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Part 3, Outstanding Loans",
                    ),
                    (
                        "I",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule I, Miscellanous increases to cash",
                    ),
                    (
                        "F461",
                        "Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                    ("F465", "Form 465: Supplemental Independent Expenditure Report"),
                    ("F625", "Form 625: Report of Lobbying Firm"),
                    (
                        "F625P2",
                        "Form 625 (Report of Lobbying Firm): Part 2, Payments Received in Connection with Lobbying Activity",
                    ),
                    (
                        "F625P3A",
                        "Form 625 (Report of Lobbying Firm): Part 3, Payments Made In Connection With Lobbying Activities, Section A, Activity Expenses",
                    ),
                    (
                        "F625P3B",
                        "Form 625 (Report of Lobbying Firm): Part 3, Payments Made In Connection With Lobbying Activities, Section B, Payments Made",
                    ),
                    (
                        "F635",
                        "Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                    (
                        "F635P3A",
                        "Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section A, Payments To In-house Employee Lobbyists",
                    ),
                    (
                        "F635P3B",
                        "Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section B, Payments To Lobbying Firms",
                    ),
                    (
                        "F635P3C",
                        "Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section C, Activity Expenses",
                    ),
                    (
                        "F635P3D",
                        "Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section D, Other Payments to Influence Legislative or Administrative Action",
                    ),
                    (
                        "F635P3E",
                        "Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section E, Payments in Connection with Administrative Testimony in Ratemaking Proceedings Before The California Public Utilities Commission",
                    ),
                    (
                        "S640",
                        "Schedule 640: Governmental Agencies Reporting (Attachment to Form 635 or Form 645)",
                    ),
                    ("F645", "Form 645: Report of Person Spending $5,000 or More"),
                    (
                        "F645P2A",
                        "Form 645 (Report of Person Spending $5,000 or More): Part 2, Payments Made this Period, Section A, Activity Expenses",
                    ),
                    (
                        "F645P2B",
                        "Form 645 (Report of Person Spending $5,000 or More): Part 2, Payments Made this Period, Section B, Other Payments to Influence Legislative or Administrative Action",
                    ),
                    (
                        "F645P2C",
                        "Form 645 (Report of Person Spending $5,000 or More): Part 2, Payments Made this Period, Section C, Payments in Connection with Administrative Testimony in Ratemaking Proceedings Before the California Public Utilities Commission",
                    ),
                    (
                        "F900",
                        "Form 900: Campaign Disclosure Statement (Public employee retirement board candidate)",
                    ),
                    (
                        "401A",
                        calaccess_raw.annotations.FilingFormSection(
                            db_value="F401A",
                            documentcloud_id=None,
                            end_page=7,
                            form=calaccess_raw.annotations.FilingForm(
                                "F401",
                                "Campaign Disclosure Statement (Slate Mailer Organization)",
                                description="Form 401 is filed by slate mailer organizations to disclose payments made and received in connection with producing slate mailers.",
                                documentcloud_id="2781366-401-2005-01",
                                group="CAMPAIGN",
                            ),
                            id="A",
                            start_page=5,
                            title="Schedule A, Payments Received",
                        ),
                    ),
                    (
                        "401B",
                        calaccess_raw.annotations.FilingFormSection(
                            db_value="F401B",
                            documentcloud_id=None,
                            end_page=9,
                            form=calaccess_raw.annotations.FilingForm(
                                "F401",
                                "Campaign Disclosure Statement (Slate Mailer Organization)",
                                description="Form 401 is filed by slate mailer organizations to disclose payments made and received in connection with producing slate mailers.",
                                documentcloud_id="2781366-401-2005-01",
                                group="CAMPAIGN",
                            ),
                            id="B",
                            start_page=8,
                            title="Schedule B, Payments Made",
                        ),
                    ),
                    (
                        "401B-1",
                        calaccess_raw.annotations.FilingFormSection(
                            db_value="F401B-1",
                            documentcloud_id=None,
                            end_page=None,
                            form=calaccess_raw.annotations.FilingForm(
                                "F401",
                                "Campaign Disclosure Statement (Slate Mailer Organization)",
                                description="Form 401 is filed by slate mailer organizations to disclose payments made and received in connection with producing slate mailers.",
                                documentcloud_id="2781366-401-2005-01",
                                group="CAMPAIGN",
                            ),
                            id="B-1",
                            start_page=10,
                            title="Schedule B-1, Payments Made by Agent or Independent Contractor",
                        ),
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=86
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=28, id="2712033-Cal-Format-1-05-02", start_page=27
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=60, id="2712033-Cal-Format-1-05-02", start_page=59
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=37, id="2712034-Cal-Format-201", start_page=36
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=74, id="2712034-Cal-Format-201", start_page=73
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=8,
            ),
        ),
        migrations.AlterField(
            model_name="spltcd",
            name="pform_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "A",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule A, Monetary Contributions Received",
                    ),
                    (
                        "B1",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 1, Loans Received",
                    ),
                    (
                        "B2",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 2, Loan Guarantors",
                    ),
                    (
                        "C",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule C, Non-Monetary Contributions Received",
                    ),
                    (
                        "D",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule D, Summary of Expenditures Supporting / Opposing Other Candidates, Measures and Committees",
                    ),
                    (
                        "F450P5",
                        "Form 450 (Campaign Disclosure Statement, Short Form (Recipient Committee)): Part 5, Payments Made",
                    ),
                    (
                        "H",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Loans Made to Others",
                    ),
                ],
                db_column="PFORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=18
                    )
                ],
                help_text="Parent Schedule Type",
                max_length=7,
            ),
        ),
        migrations.AlterField(
            model_name="textmemocd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F401",
                        "Form 401: Campaign Disclosure Statement (Slate Mailer Organization)",
                    ),
                    ("F405", "Form 405: Amendment to Campaign Disclosure Statement"),
                    (
                        "F410",
                        "Form 410: Statement of Organization (Recipient Committee)",
                    ),
                    (
                        "F425",
                        "Form 425: Semi-Annual Statement of No Activity (Recipient Committee)",
                    ),
                    (
                        "F450",
                        "Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        "F460",
                        "Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        "F461",
                        "Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                    ("F465", "Form 465: Supplemental Independent Expenditure Report"),
                    ("F496", "Form 496: Late Independent Expenditure Report"),
                    ("F497", "Form 497: Late Contribution Report"),
                    (
                        "F498",
                        "Form 498: Late Payment Report (Slate Mailer Organization)",
                    ),
                    ("F601", "Form 601: Lobbying Firm Registration Statement"),
                    ("F602", "Form 602: Lobbying Firm Activity Authorization"),
                    (
                        "F603",
                        "Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                    ),
                    ("F604", "Form 604: Lobbyist Certification Statement"),
                    (
                        "F605",
                        "Form 605: Amendment to Registration, Lobbying Firm, Lobbyist Employer, Lobbying Coalition",
                    ),
                    ("F606", "Form 606: Notice of Termination"),
                    ("F607", "Form 607: Notice of Withdrawal"),
                    ("F615", "Form 615: Lobbyist Report"),
                    ("F625", "Form 625: Report of Lobbying Firm"),
                    (
                        "F635",
                        "Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                    ("F645", "Form 645: Report of Person Spending $5,000 or More"),
                    (
                        "S630",
                        "Schedule 630: Payments Made to Lobbying Coalitions (Attachment to Form 625 or 635) ",
                    ),
                    (
                        "S635-C",
                        "Schedule 635C: Payments Received by Lobbying Coalitions",
                    ),
                    (
                        "S640",
                        "Schedule 640: Governmental Agencies Reporting (Attachment to Form 635 or Form 645)",
                    ),
                    (
                        "410",
                        "Form 410: Statement of Organization (Recipient Committee)",
                    ),
                    (
                        "460",
                        "Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        "461",
                        "Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                    ("465", "Form 465: Supplemental Independent Expenditure Report"),
                    ("496", "Form 496: Late Independent Expenditure Report"),
                    ("497", "Form 497: Late Contribution Report"),
                    (
                        "497P1",
                        "Form 497 (Late Contribution Report): Part 1, Contributions Received",
                    ),
                    (
                        "497P2",
                        "Form 497 (Late Contribution Report): Part 2, Contributions Made",
                    ),
                    (
                        "F401A",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule A, Payments Received",
                    ),
                    (
                        "F401B",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule B, Payments Made",
                    ),
                    (
                        "F401B-1",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule B-1, Payments Made by Agent or Independent Contractor",
                    ),
                    (
                        "F450P5",
                        "Form 450 (Campaign Disclosure Statement, Short Form (Recipient Committee)): Part 5, Payments Made",
                    ),
                    (
                        "F461P1",
                        "Form 461 (Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)): Part 1, Name and Address of Filer",
                    ),
                    (
                        "F461P2",
                        "Form 461 (Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)): Part 2, Nature and Interests of Filer",
                    ),
                    (
                        "F461P5",
                        "Form 461 (Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)): Part 5, Contributions (Including Loans, Forgiveness of Loans, and LoanGuarantees) and Expenditures Made",
                    ),
                    (
                        "F465P3",
                        "Form 465 (Supplemental Independent Expenditure Report): Part 3, Independent Expenditures Made",
                    ),
                    (
                        "F496P3",
                        "Form 496 (Late Independent Expenditure Report): Part 3, Contributions > $100 Received",
                    ),
                    (
                        "F497P1",
                        "Form 497 (Late Contribution Report): Part 1, Contributions Received",
                    ),
                    (
                        "F497P2",
                        "Form 497 (Late Contribution Report): Part 2, Contributions Made",
                    ),
                    (
                        "F498-A",
                        "Form 498 (Late Payment Report (Slate Mailer Organization)): Part A, Late Payments Attributed To",
                    ),
                    (
                        "F498-R",
                        "Form 498 (Late Payment Report (Slate Mailer Organization)): Part R, Late Payments Received From",
                    ),
                    (
                        "F601P2A",
                        "Form 601 (Lobbying Firm Registration Statement): Part 2, Section A, Lobbyist Employers",
                    ),
                    (
                        "F601P2B",
                        "Form 601 (Lobbying Firm Registration Statement): Part 2, Section B, Subcontracted Clients",
                    ),
                    (
                        "F615P1",
                        "Form 615 (Lobbyist Report): Part 1, Activity Expenses Paid, Incurred, Arranged or Provided by the Lobbyist",
                    ),
                    (
                        "F615P2",
                        "Form 615 (Lobbyist Report): Part 2, Campaign Contributions Made or Delivered",
                    ),
                    (
                        "F625P2",
                        "Form 625 (Report of Lobbying Firm): Part 2, Payments Received in Connection with Lobbying Activity",
                    ),
                    (
                        "F625P3A",
                        "Form 625 (Report of Lobbying Firm): Part 3, Payments Made In Connection With Lobbying Activities, Section A, Activity Expenses",
                    ),
                    (
                        "F625P3B",
                        "Form 625 (Report of Lobbying Firm): Part 3, Payments Made In Connection With Lobbying Activities, Section B, Payments Made",
                    ),
                    (
                        "F625P4B",
                        "Form 625 (Report of Lobbying Firm): Part 4, Campaign Contributions Made",
                    ),
                    (
                        "S635",
                        "Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                    (
                        "F635P3B",
                        "Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section B, Payments To Lobbying Firms",
                    ),
                    (
                        "F635P3C",
                        "Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section C, Activity Expenses",
                    ),
                    (
                        "F635P4B",
                        "Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 4, Campaign Contributions Made",
                    ),
                    (
                        "F645P2A",
                        "Form 645 (Report of Person Spending $5,000 or More): Part 2, Payments Made this Period, Section A, Activity Expenses",
                    ),
                    (
                        "F645P3B",
                        "Form 645 (Report of Person Spending $5,000 or More): Part 3, Campaign Contributions Made",
                    ),
                    ("S497", "Form 497: Late Contribution Report"),
                    (
                        "S635C",
                        "Schedule 635C: Payments Received by Lobbying Coalitions",
                    ),
                    ("A", "Schedule A of any form (e.g., Forms 401 or 460)"),
                    ("A4", "Schedule A of any form (e.g., Forms 401 or 460)"),
                    ("A6", "Schedule A of any form (e.g., Forms 401 or 460)"),
                    ("B", "Schedule B of any form (e.g., Forms 401 or 460)"),
                    ("B1", "Schedule B, Part 1 of Forms 401 or 460"),
                    ("B2", "Schedule B, Part 2 of Forms 401 or 460"),
                    ("B3", "Schedule B, Part 3 of Forms 401 or 460"),
                    ("C", "Schedule C of any form (e.g., Forms 401 or F460)"),
                    ("COMMENTS", "Possibly comments by FPPC for any form?"),
                    ("CVR", "Cover page for any form (e.g., Forms 460, 461 or 497)"),
                    ("D", "Schedule D of any form (e.g., Forms 401, 460 or 461)"),
                    (
                        "DEBTF",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule F, Accrued Expenses (Unpaid Bills)",
                    ),
                    ("E", "Schedule E of any form (e.g., Forms 460, 461 or 465)"),
                    ("EXPNT", "Expenditures outlined on any form (e.g. Form 460)"),
                    ("F", "Schedule F of any form (e.g., Form 460)"),
                    ("G", "Schedule G of any form (e.g., Form 460)"),
                    ("H", "Schedule H of any form (e.g., Form 460)"),
                    ("H1", "Schedule H, Part 1 of any form (e.g., Form 460)"),
                    ("H2", "Schedule H2, Part 2 of any form (e.g., Form 460)"),
                    ("H3", "Schedule H3, Part 3 of any form (e.g., Form 460)"),
                    ("I", "Schedule I of any form (e.g., Form 460)"),
                    ("PT5", "Part 5 of any form (e.g., Form 461"),
                    ("RCPTB1", "Schedule B, Part 1 of any form (e.g., Form 460"),
                    ("RCPTC", "Schedule C of any form (e.g., Form 460)"),
                    ("RCPTI", "Schedule I of any form (e.g., Form 460)"),
                    ("SCH A", "Schedule A of any form (e.g., Form 460)"),
                    ("SF", "Schedule F of any form (e.g., Form 460)"),
                    ("SPLT", "A memo that applies to multiple items?"),
                    ("SMRY", "Summary section of any form (e.g., Form 460)"),
                    ("SUM", "Summary section of any form (e.g., Form 460)"),
                    ("SUMMARY", "Summary section of any form (e.g., Form 460)"),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=90
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=16
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=13
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=8,
                verbose_name="form type",
            ),
        ),
    ]
