# -*- coding: utf-8 -*-
# Generated by Django 1.9.7 on 2016-08-02 15:54
from __future__ import unicode_literals

import calaccess_raw
import calaccess_raw.annotations
import calaccess_raw.fields
from django.db import migrations, models
import django.db.models.deletion


def archive_directory_path():
    pass


class Migration(migrations.Migration):

    replaces = [
        ("calaccess_raw", "0001_initial"),
        ("calaccess_raw", "0002_auto_20160703_0600"),
        ("calaccess_raw", "0003_auto_20160705_1923"),
        ("calaccess_raw", "0004_auto_20160705_1924"),
        ("calaccess_raw", "0005_auto_20160705_2145"),
        ("calaccess_raw", "0006_rawdatafile_error_log_archive"),
        ("calaccess_raw", "0007_rawdatafile_error_count"),
        ("calaccess_raw", "0008_auto_20160707_0518"),
        ("calaccess_raw", "0009_rawdataversion_clean_zip_archive"),
        ("calaccess_raw", "0010_auto_20160726_1425"),
        ("calaccess_raw", "0011_auto_20160728_1944"),
        ("calaccess_raw", "0012_auto_20160728_1945"),
        ("calaccess_raw", "0013_auto_20160729_0506"),
        ("calaccess_raw", "0014_auto_20160801_2039"),
    ]

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="AcronymsCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "acronym",
                    calaccess_raw.fields.CharField(
                        db_column="ACRONYM",
                        help_text="Acronym text value",
                        max_length=40,
                    ),
                ),
                (
                    "stands_for",
                    calaccess_raw.fields.CharField(
                        db_column="STANDS_FOR",
                        help_text="Definition of the acronym",
                        max_length=4,
                    ),
                ),
                (
                    "effect_dt",
                    calaccess_raw.fields.DateField(
                        db_column="EFFECT_DT",
                        help_text="Effective date for the acronym",
                        null=True,
                    ),
                ),
                (
                    "a_desc",
                    calaccess_raw.fields.CharField(
                        db_column="A_DESC",
                        help_text="Description of the acronym",
                        max_length=50,
                    ),
                ),
            ],
            options={
                "ordering": ("acronym",),
                "db_table": "ACRONYMS_CD",
                "verbose_name": "ACRONYMS_CD",
                "verbose_name_plural": "ACRONYMS_CD",
            },
        ),
        migrations.CreateModel(
            name="AddressCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "adrid",
                    calaccess_raw.fields.IntegerField(
                        db_column="ADRID",
                        help_text="Address indentification number",
                        verbose_name="Address ID",
                    ),
                ),
                (
                    "city",
                    calaccess_raw.fields.CharField(
                        db_column="CITY", help_text="Address city", max_length=500
                    ),
                ),
                (
                    "st",
                    calaccess_raw.fields.CharField(
                        db_column="ST",
                        help_text="Address state",
                        max_length=500,
                        verbose_name="State",
                    ),
                ),
                (
                    "zip4",
                    calaccess_raw.fields.CharField(
                        db_column="ZIP4",
                        help_text="Address ZIP Code",
                        max_length=10,
                        null=True,
                    ),
                ),
                (
                    "phon",
                    calaccess_raw.fields.CharField(
                        db_column="PHON",
                        help_text="Address phone number",
                        max_length=20,
                        null=True,
                        verbose_name="Phone",
                    ),
                ),
                (
                    "fax",
                    calaccess_raw.fields.CharField(
                        db_column="FAX",
                        help_text="Address fax number",
                        max_length=20,
                        null=True,
                    ),
                ),
                (
                    "email",
                    calaccess_raw.fields.CharField(
                        db_column="EMAIL", help_text="Address email", max_length=500
                    ),
                ),
            ],
            options={
                "db_table": "ADDRESS_CD",
                "verbose_name": "ADDRESS_CD",
                "verbose_name_plural": "ADDRESS_CD",
            },
        ),
        migrations.CreateModel(
            name="BallotMeasuresCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "election_date",
                    calaccess_raw.fields.DateField(
                        db_column="ELECTION_DATE",
                        help_text="Ballot measure election date",
                        null=True,
                    ),
                ),
                (
                    "filer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILER_ID",
                        db_index=True,
                        help_text="Filer's unique identification number",
                        null=True,
                        verbose_name="filer ID",
                    ),
                ),
                (
                    "measure_no",
                    calaccess_raw.fields.CharField(
                        db_column="MEASURE_NO",
                        help_text="Ballot measure number",
                        max_length=2,
                    ),
                ),
                (
                    "measure_name",
                    calaccess_raw.fields.CharField(
                        db_column="MEASURE_NAME",
                        help_text="Ballot measure full name",
                        max_length=163,
                    ),
                ),
                (
                    "measure_short_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEASURE_SHORT_NAME",
                        help_text="Ballot measure short name",
                        max_length=50,
                    ),
                ),
                (
                    "jurisdiction",
                    calaccess_raw.fields.CharField(
                        db_column="JURISDICTION",
                        help_text="This field is undocumented",
                        max_length=9,
                    ),
                ),
            ],
            options={
                "ordering": (
                    "-election_date",
                    "measure_no",
                    "measure_short_name",
                    "measure_name",
                ),
                "db_table": "BALLOT_MEASURES_CD",
                "verbose_name": "BALLOT_MEASURES_CD",
                "verbose_name_plural": "BALLOT_MEASURES_CD",
            },
        ),
        migrations.CreateModel(
            name="Cvr2CampaignDisclosureCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "bal_juris",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_JURIS",
                        help_text="Ballot measure jurisdiction",
                        max_length=40,
                    ),
                ),
                (
                    "bal_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_NAME",
                        help_text="Ballot measure name",
                        max_length=200,
                    ),
                ),
                (
                    "bal_num",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_NUM",
                        help_text="Ballot measure number or letter",
                        max_length=7,
                    ),
                ),
                (
                    "cmte_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CMTE_ID",
                        help_text="Commitee identification number, when the entity is a committee",
                        max_length=9,
                    ),
                ),
                (
                    "control_yn",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="CONTROL_YN",
                        help_text='Controlled Committee (yes/no) checkbox. Legal values are "Y" or "N".',
                        null=True,
                    ),
                ),
                (
                    "dist_no",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="DIST_NO",
                        help_text="District number for the office being sought. Populated for Senate, Assembly, or Board of Equalization races.",
                        max_length=3,
                    ),
                ),
                (
                    "entity_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("ATR", b"Assistant treasurer"),
                            ("BNM", b"Ballot measure's name/title"),
                            ("CAO", b"Candidate/officeholder"),
                            ("COM", b"Committee"),
                            ("CTL", b"Controlled committee"),
                            ("OFF", b"Officer"),
                            ("POF", b"Principal officer"),
                            ("PRO", b"Proponent"),
                            ("RCP", b"Recipient committee"),
                            ("FIL", "Unknown"),
                            ("PEX", "Unknown"),
                            ("RDP", "Unknown"),
                        ],
                        db_column="ENTITY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=9,
                                id=b"2712033-Cal-Format-1-05-02",
                                start_page=8,
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=11, id=b"2712034-Cal-Format-201", start_page=9
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=32
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=24,
                                id="2712033-Cal-Format-1-05-02",
                                start_page=23,
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=32
                            ),
                        ],
                        help_text="Entity code used to identify the type of entity being described with in the record.",
                        max_length=3,
                        verbose_name="entity code",
                    ),
                ),
                (
                    "enty_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_CITY",
                        help_text="Entity city",
                        max_length=30,
                    ),
                ),
                (
                    "enty_email",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_EMAIL",
                        help_text="Entity email address",
                        max_length=60,
                    ),
                ),
                (
                    "enty_fax",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_FAX",
                        help_text="Entity fax number",
                        max_length=20,
                    ),
                ),
                (
                    "enty_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_NAMF",
                        help_text="Entity first name, if an individual",
                        max_length=45,
                    ),
                ),
                (
                    "enty_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_NAML",
                        help_text="Entity name, or last name if an individual",
                        max_length=200,
                    ),
                ),
                (
                    "enty_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_NAMS",
                        help_text="Entity suffix, if an individual",
                        max_length=10,
                    ),
                ),
                (
                    "enty_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_NAMT",
                        help_text="Entity prefix or title, if an individual",
                        max_length=10,
                    ),
                ),
                (
                    "enty_phon",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_PHON",
                        help_text="Entity phone number",
                        max_length=20,
                    ),
                ),
                (
                    "enty_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_ST",
                        help_text="Entity state",
                        max_length=2,
                    ),
                ),
                (
                    "enty_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_ZIP4",
                        help_text="Entity ZIP code",
                        max_length=10,
                    ),
                ),
                (
                    "f460_part",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("3", "Part 3: Committee Information"),
                            (
                                "4a",
                                "Part 4a: Officeholder or Candidate Controlled Committee",
                            ),
                            (
                                "4A",
                                "Part 4a: Officeholder or Candidate Controlled Committee",
                            ),
                            (
                                "4b",
                                "Part 4b: Related Committees Not Included in this Statement",
                            ),
                            (
                                "4B",
                                "Part 4b: Related Committees Not Included in this Statement",
                            ),
                            (
                                "5a",
                                "Part 5a: Officeholder or Candidate Controlled Committee",
                            ),
                            (
                                "5A",
                                "Part 5a: Officeholder or Candidate Controlled Committee",
                            ),
                            (
                                "5b",
                                "Part 5b: Related Committees Not Included in this Statement",
                            ),
                            (
                                "5B",
                                "Part 5b: Related Committees Not Included in this Statement",
                            ),
                            ("6", "Part 6: Primarily Formed Committee"),
                            ("6a", "Part 6a: Name of Ballot Measure"),
                            ("6A", "Part 6a: Name of Ballot Measure"),
                            (
                                "6b",
                                "Part 6b: Name of Officeholder, Candidate, or Proponent",
                            ),
                            (
                                "6B",
                                "Part 6b: Name of Officeholder, Candidate, or Proponent",
                            ),
                            ("7", "Part 7: Primarily Formed Committee"),
                        ],
                        db_column="F460_PART",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=32
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=24
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=32
                            ),
                        ],
                        help_text="Part of 460 cover page coded on ths cvr2 record",
                        max_length=2,
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"F425",
                                b"Form 425 (Semi-Annual Statement of no Activity): Part 1, Committee Information",
                            ),
                            (
                                b"F450",
                                b"Form 450 (Recipient Committee Campaign Disclosure Statement - Short Form): Part 3, Committee Information",
                            ),
                            (
                                b"F460",
                                b"Form 460 (Recipient Committee Campaign Statement): Cover Page - Part 2",
                            ),
                            (
                                b"F465",
                                b"Form 465 (Supplemental Independent Expenditure Report): Part 5, Filing Officers",
                            ),
                        ],
                        db_column="FORM_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=23
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=31
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=4,
                    ),
                ),
                (
                    "juris_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"ASM", b"Assembly District"),
                            (b"BOE", b"Board of Equalization District"),
                            (b"CIT", b"City"),
                            (b"CTY", b"County"),
                            (b"LOC", b"Local"),
                            (b"OTH", b"Other"),
                            (b"SEN", b"Senate District"),
                            (b"STW", b"Statewide"),
                            ("sen", b"Senate District"),
                            ("SD", b"Assembly District"),
                            ("se", b"Senate District"),
                            ("F", b"Assembly District"),
                            ("LBC", b"City"),
                            ("CA", b"Statewide"),
                        ],
                        db_column="JURIS_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=24
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=33
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=35
                            ),
                        ],
                        help_text="Office jurisdiction code",
                        max_length=3,
                    ),
                ),
                (
                    "juris_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="JURIS_DSCR",
                        help_text="Office jurisdiction description",
                        max_length=40,
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                    ),
                ),
                (
                    "mail_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAIL_CITY",
                        help_text="Filer's mailing city",
                        max_length=30,
                    ),
                ),
                (
                    "mail_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAIL_ST",
                        help_text="Filer's mailing state",
                        max_length=2,
                    ),
                ),
                (
                    "mail_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAIL_ZIP4",
                        help_text="Filer's mailing ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "off_s_h_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("S", b"SOUGHT"),
                            ("H", b"HELD"),
                            ("s", b"SOUGHT"),
                            ("F", b"SOUGHT"),
                            ("T", b"HELD"),
                        ],
                        db_column="OFF_S_H_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=35
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=24
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=34
                            ),
                        ],
                        help_text="Office is sought or held code",
                        max_length=1,
                    ),
                ),
                (
                    "offic_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="OFFIC_DSCR",
                        help_text="Office sought description",
                        max_length=40,
                    ),
                ),
                (
                    "office_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"APP", b"State Appellate Court Justice"),
                            (b"ASM", b"State Assembly Person"),
                            (b"ASR", b"Assessor"),
                            (b"ATT", b"Attorney General"),
                            (b"BED", b"Board of Education"),
                            (b"BOE", b"Board of Equalization Member"),
                            (b"BSU", b"Board of Supervisors"),
                            (b"CAT", b"City Attorney"),
                            (b"CCB", b"Community College Board"),
                            (b"CCM", b"City Council Member"),
                            (b"CON", b"State Controller"),
                            (b"COU", b"County Counsel"),
                            (b"CSU", b"County Supervisor"),
                            (b"CTR", b"Local Controller"),
                            (b"DAT", b"District Attorney"),
                            (b"GOV", b"Governor"),
                            (b"INS", b"Insurance Commissioner"),
                            (b"LTG", b"Lieutenant Governor"),
                            (b"MAY", b"Mayor"),
                            (b"OTH", b"Other"),
                            (b"PDR", b"Public Defender"),
                            (b"PER", b"Public Employees Retirement System"),
                            (b"PLN", b"Planning Commissioner"),
                            (b"SCJ", b"Superior Court Judge"),
                            (b"SEN", b"State Senator"),
                            (b"SHC", b"Sheriff-Coroner"),
                            (b"SOS", b"Secretary of State"),
                            (b"SPM", b"Supreme Court Justice"),
                            (b"SUP", b"Superintendent of Public Instruction"),
                            (b"TRE", b"State Treasurer"),
                            (b"TRS", b"Local Treasurer"),
                            ("CIT", b"State Assembly Person"),
                            ("CTL", b"State Assembly Person"),
                            ("F", b"State Assembly Person"),
                            ("ST", b"State Assembly Person"),
                            ("PAC", "Unknown"),
                        ],
                        db_column="OFFICE_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id=b"2712033-Cal-Format-1-05-02", start_page=10
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id=b"2712034-Cal-Format-201", start_page=12
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id=b"2712032-Cal-Errata-201", start_page=2
                            ),
                        ],
                        help_text="Identifies the office being sought",
                        max_length=3,
                        verbose_name="office code",
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("CVR2", "Cover, Page 2")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711614-CalAccessTablesWeb", start_page=41
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=32
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=23
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=31
                            ),
                        ],
                        help_text="Record Type Value: CVR2",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "sup_opp_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("S", b"SUPPORT"),
                            ("O", b"OPPOSITION"),
                            ("s", b"SUPPORT"),
                            ("o", b"OPPOSITION"),
                        ],
                        db_column="SUP_OPP_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711614-CalAccessTablesWeb", start_page=41
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=35
                            ),
                        ],
                        help_text="Support or opposition code",
                        max_length=1,
                    ),
                ),
                (
                    "title",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TITLE",
                        help_text="Official title of filing officer. Applies to the form 465.",
                        max_length=90,
                    ),
                ),
                (
                    "tran_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRAN_ID",
                        help_text="Permanent value unique to this item",
                        max_length=20,
                        verbose_name="transaction ID",
                    ),
                ),
                (
                    "tres_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAMF",
                        help_text="Treasurer or responsible officer's first name",
                        max_length=45,
                    ),
                ),
                (
                    "tres_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAML",
                        help_text="Treasurer or responsible officer's last name",
                        max_length=200,
                    ),
                ),
                (
                    "tres_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAMS",
                        help_text="Treasurer or responsible officer's suffix",
                        max_length=10,
                    ),
                ),
                (
                    "tres_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAMT",
                        help_text="Treasurer or responsible officer's prefix or title",
                        max_length=10,
                    ),
                ),
            ],
            options={
                "db_table": "CVR2_CAMPAIGN_DISCLOSURE_CD",
                "verbose_name": "CVR2_CAMPAIGN_DISCLOSURE_CD",
                "verbose_name_plural": "CVR2_CAMPAIGN_DISCLOSURE_CD",
            },
        ),
        migrations.CreateModel(
            name="Cvr2LobbyDisclosureCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "entity_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("EMP", b"Employer"),
                            ("OFF", b"Officer"),
                            ("OWN", b"Owner"),
                            ("PTN", b"Partner"),
                        ],
                        db_column="ENTITY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=57
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=71
                            ),
                        ],
                        help_text="Entity code of the entity described by the record",
                        max_length=3,
                        verbose_name="entity code",
                    ),
                ),
                (
                    "entity_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTITY_ID",
                        help_text="Entity identification number",
                        max_length=9,
                    ),
                ),
                (
                    "enty_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_NAMF",
                        help_text="Entity first name",
                        max_length=45,
                    ),
                ),
                (
                    "enty_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_NAML",
                        help_text="Entity last name or business name",
                        max_length=200,
                    ),
                ),
                (
                    "enty_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_NAMS",
                        help_text="Entity suffix",
                        max_length=10,
                    ),
                ),
                (
                    "enty_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_NAMT",
                        help_text="Entity title or prefix",
                        max_length=10,
                    ),
                ),
                (
                    "enty_title",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_TITLE",
                        help_text="Title of partner, owner, officer, employer if the entity is an individual. Only required by Form 635.",
                        max_length=45,
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (b"F625", b"Form 625: Report of Lobbying Firm"),
                            (
                                b"F635",
                                b"Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                            ),
                        ],
                        db_column="FORM_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=57
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=71
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=4,
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("CVR2", "CVR2")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=57
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=71
                            ),
                        ],
                        help_text="Record Type Value: CVR2",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "tran_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRAN_ID",
                        help_text="Permanent value unique to this item",
                        max_length=20,
                        verbose_name="transaction ID",
                    ),
                ),
            ],
            options={
                "db_table": "CVR2_LOBBY_DISCLOSURE_CD",
                "verbose_name": "CVR2_LOBBY_DISCLOSURE_CD",
                "verbose_name_plural": "CVR2_LOBBY_DISCLOSURE_CD",
            },
        ),
        migrations.CreateModel(
            name="Cvr2RegistrationCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("CVR2", "CVR2")],
                        db_column="REC_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=72
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=87
                            ),
                        ],
                        help_text="Record Type Value: CVR2",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"F601",
                                b"Form 601: Lobbying Firm Registration Statement",
                            ),
                            (
                                b"F602",
                                b"Form 602: Lobbying Firm Activity Authorization",
                            ),
                            (
                                b"F603",
                                b"Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                            ),
                        ],
                        db_column="FORM_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=72
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=87
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=10,
                    ),
                ),
                (
                    "tran_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRAN_ID",
                        help_text="Permanent value unique to this item",
                        max_length=20,
                        verbose_name="transaction ID",
                    ),
                ),
                (
                    "entity_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("AGY", b"State Agency"),
                            ("EMP", b"Employer"),
                            ("FRM", b"Lobbying Firm"),
                            ("LBY", b"Lobbyist (an individual)"),
                            ("MBR", b"Member of Associaton"),
                            ("SCL", b"Subcontracted Client"),
                        ],
                        db_column="ENTITY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=72
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=87
                            ),
                        ],
                        help_text="Entity code of the entity described by the record",
                        max_length=3,
                        verbose_name="entity code",
                    ),
                ),
                (
                    "entity_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTITY_ID",
                        help_text="Identification number of the entity described by the record",
                        max_length=9,
                        verbose_name="Entity ID",
                    ),
                ),
                (
                    "enty_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_NAML",
                        help_text="Entity last name",
                        max_length=200,
                    ),
                ),
                (
                    "enty_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_NAMF",
                        help_text="Entity first name",
                        max_length=45,
                    ),
                ),
                (
                    "enty_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_NAMT",
                        help_text="Entity title or suffix",
                        max_length=10,
                    ),
                ),
                (
                    "enty_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_NAMS",
                        help_text="Entity suffix",
                        max_length=10,
                    ),
                ),
            ],
            options={
                "db_table": "CVR2_REGISTRATION_CD",
                "verbose_name": "CVR2_REGISTRATION_CD",
                "verbose_name_plural": "CVR2_REGISTRATION_CD",
            },
        ),
        migrations.CreateModel(
            name="Cvr2SoCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                        verbose_name="line item",
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("CVR2", "Cover Page; Additional Names & Addresses")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=38
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711614-CalAccessTablesWeb", start_page=46
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=45
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=58
                            ),
                        ],
                        help_text='Type of record. This column will always contain "CVR2".',
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"F400",
                                b"Form 400 (Statement of Organization (Slate Mailer Organization)): Part 3, Individuals Who Authorize Contents Of Slate Mailers",
                            ),
                            (
                                b"F410",
                                b"Form 410 (Statement of Organization Recipient Committee): Part 4, Type of Committee",
                            ),
                        ],
                        db_column="FORM_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=38
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=46,
                                id="2712033-Cal-Format-1-05-02",
                                start_page=45,
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=59, id="2712034-Cal-Format-201", start_page=58
                            ),
                        ],
                        help_text="Form type of the filing the record is included in. This must equal the form_type of the parent filing's cover (CVR) record.",
                        max_length=4,
                        verbose_name="form type",
                    ),
                ),
                (
                    "tran_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRAN_ID",
                        help_text="Permanent value unique to this item",
                        max_length=20,
                        verbose_name="transaction ID",
                    ),
                ),
                (
                    "entity_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("ATH", b"Authorizing individual"),
                            ("ATR", b"Assistant treasurer"),
                            ("BNM", b"Ballot measure's name/title"),
                            ("CAO", b"Candidate/officeholder"),
                            ("COM", b"Committee"),
                            ("CTL", b"Controlled committee"),
                            ("OFF", b"Officer"),
                            ("POF", b"Principal officer"),
                            ("PRO", b"Proponent"),
                            ("SPO", b"Sponsor"),
                            ("BMN", "Unknown"),
                        ],
                        db_column="ENTITY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=9,
                                id=b"2712033-Cal-Format-1-05-02",
                                start_page=8,
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=11, id=b"2712034-Cal-Format-201", start_page=9
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=38
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=48
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=62
                            ),
                        ],
                        help_text="Entity code of the entity described by the record.",
                        max_length=3,
                        verbose_name="entity code",
                    ),
                ),
                (
                    "enty_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_NAML",
                        help_text="Entity's business name or last name if the entity is an individual",
                        max_length=200,
                        verbose_name="entity last name",
                    ),
                ),
                (
                    "enty_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_NAMF",
                        help_text="Entity's first name if the entity is an individual",
                        max_length=45,
                        verbose_name="entity first name",
                    ),
                ),
                (
                    "enty_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_NAMT",
                        help_text="Entity's name prefix or title if the entity is an individual",
                        max_length=10,
                        verbose_name="entity name title",
                    ),
                ),
                (
                    "enty_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_NAMS",
                        help_text="Entity's name suffix if the entity is an individual",
                        max_length=10,
                        verbose_name="entity name suffix",
                    ),
                ),
                (
                    "item_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("ATR", "Assistant Treasurer (F410)"),
                            ("CAO", b"Candidate/officeholder"),
                            ("CTL", "Controlled Committee (F410)"),
                            ("P5B", "Unknown"),
                            ("PFC", "Primarily Formed Committee Item (F410)"),
                            ("Pfc", "Primarily Formed Committee Item (F410)"),
                            ("POF", "Principal Officer (F400, F410"),
                            ("PRO", b"Proponent"),
                            ("SMA", "Slate Mailer Authorizer (F400)"),
                            ("SPO", "Sponsored Committee Itemization (F410)"),
                            ("n/a", "Not Applicable"),
                            ("CON", "Unknown"),
                            ("CST", "Unknown"),
                        ],
                        db_column="ITEM_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=8
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=10
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=48
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=62
                            ),
                        ],
                        help_text="Section of the Statement of Organization this itemization relates to. See CAL document for the definition of legal values for this column.",
                        max_length=4,
                        verbose_name="item code",
                    ),
                ),
                (
                    "mail_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAIL_CITY",
                        help_text="City portion of the entity's mailing address",
                        max_length=30,
                        verbose_name="mail city",
                    ),
                ),
                (
                    "mail_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAIL_ST",
                        help_text="State portion of the entity's mailing address",
                        max_length=4,
                        verbose_name="mail street",
                    ),
                ),
                (
                    "mail_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAIL_ZIP4",
                        help_text="Zipcode portion of the entity's mailing address",
                        max_length=10,
                        verbose_name="mail zip4",
                    ),
                ),
                (
                    "day_phone",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="DAY_PHONE",
                        help_text="Entity's daytime phone number",
                        max_length=20,
                        verbose_name="day phone",
                    ),
                ),
                (
                    "fax_phone",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FAX_PHONE",
                        help_text="Entity's fax number",
                        max_length=20,
                        verbose_name="fax phone number",
                    ),
                ),
                (
                    "email_adr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EMAIL_ADR",
                        help_text="Email address. Not contained in current forms.",
                        max_length=60,
                        verbose_name="email address",
                    ),
                ),
                (
                    "cmte_id",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="CMTE_ID",
                        help_text="Entity's identification number",
                        null=True,
                        verbose_name="Committee ID",
                    ),
                ),
                (
                    "ind_group",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="IND_GROUP",
                        help_text="Industry group/affiliation description",
                        max_length=90,
                        verbose_name="industry group",
                    ),
                ),
                (
                    "office_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"APP", b"State Appellate Court Justice"),
                            (b"ASM", b"State Assembly Person"),
                            (b"ASR", b"Assessor"),
                            (b"ATT", b"Attorney General"),
                            (b"BED", b"Board of Education"),
                            (b"BOE", b"Board of Equalization Member"),
                            (b"BSU", b"Board of Supervisors"),
                            (b"CAT", b"City Attorney"),
                            (b"CCB", b"Community College Board"),
                            (b"CCM", b"City Council Member"),
                            (b"CON", b"State Controller"),
                            (b"COU", b"County Counsel"),
                            (b"CSU", b"County Supervisor"),
                            (b"CTR", b"Local Controller"),
                            (b"DAT", b"District Attorney"),
                            (b"GOV", b"Governor"),
                            (b"INS", b"Insurance Commissioner"),
                            (b"LTG", b"Lieutenant Governor"),
                            (b"MAY", b"Mayor"),
                            (b"OTH", b"Other"),
                            (b"PDR", b"Public Defender"),
                            (b"PER", b"Public Employees Retirement System"),
                            (b"PLN", b"Planning Commissioner"),
                            (b"SCJ", b"Superior Court Judge"),
                            (b"SEN", b"State Senator"),
                            (b"SHC", b"Sheriff-Coroner"),
                            (b"SOS", b"Secretary of State"),
                            (b"SPM", b"Supreme Court Justice"),
                            (b"SUP", b"Superintendent of Public Instruction"),
                            (b"TRE", b"State Treasurer"),
                            (b"TRS", b"Local Treasurer"),
                            ("Asm", b"State Assembly Person"),
                            ("LEG", b"State Assembly Person"),
                            ("OF", b"State Assembly Person"),
                            ("REP", b"State Assembly Person"),
                            ("05", b"State Assembly Person"),
                            ("H", "N/A"),
                            ("PRO", "N/A"),
                            ("PAC", "Unknown"),
                        ],
                        db_column="OFFICE_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id=b"2712033-Cal-Format-1-05-02", start_page=10
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id=b"2712034-Cal-Format-201", start_page=12
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id=b"2712032-Cal-Errata-201", start_page=2
                            ),
                        ],
                        help_text="Identifies the office being sought",
                        max_length=3,
                        verbose_name="office code",
                    ),
                ),
                (
                    "offic_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="OFFIC_DSCR",
                        help_text="Office sought description used if the office sought code (OFFICE_CD) equals other (OTH).",
                        max_length=40,
                        verbose_name="office description",
                    ),
                ),
                (
                    "juris_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"ASM", b"Assembly District"),
                            (b"BOE", b"Board of Equalization District"),
                            (b"CIT", b"City"),
                            (b"CTY", b"County"),
                            (b"LOC", b"Local"),
                            (b"OTH", b"Other"),
                            (b"SEN", b"Senate District"),
                            (b"STW", b"Statewide"),
                            ("FED", "N/A"),
                            ("JR", "N/A"),
                        ],
                        db_column="JURIS_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=39
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=49
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=63
                            ),
                        ],
                        help_text="Office jurisdiction code. See CAL document for a list of legal values.",
                        max_length=4,
                        verbose_name="jurisdiction code",
                    ),
                ),
                (
                    "juris_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="JURIS_DSCR",
                        help_text="Office jurisdiction description provided if the         jurisdiction code (JURIS_CD) equals other (OTH).",
                        max_length=40,
                        verbose_name="jurisdiction description",
                    ),
                ),
                (
                    "dist_no",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="DIST_NO",
                        help_text="Office district number for Senate, Assembly, and Board of Equalization districts.",
                        max_length=4,
                        verbose_name="district name",
                    ),
                ),
                (
                    "off_s_h_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[(b"H", b"HELD"), (b"S", b"SOUGHT")],
                        db_column="OFF_S_H_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711614-CalAccessTablesWeb", start_page=46
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=39
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=49
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=63
                            ),
                        ],
                        help_text='Office sought/held code. Legal values are "S" for sought and "H" for held',
                        max_length=1,
                        verbose_name="office is sought or held code",
                    ),
                ),
                (
                    "non_pty_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="NON_PTY_CB",
                        help_text="Non-partisan check-box. Legal values are 'X' and null.",
                        max_length=4,
                        verbose_name="non-party checkbox",
                    ),
                ),
                (
                    "party_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PARTY_NAME",
                        help_text="Name of party (if partisan)",
                        max_length=200,
                        verbose_name="party name",
                    ),
                ),
                (
                    "bal_num",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_NUM",
                        help_text="Ballot measure number or letter",
                        max_length=7,
                        verbose_name="balance number",
                    ),
                ),
                (
                    "bal_juris",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_JURIS",
                        help_text="Jurisdiction of ballot measure",
                        max_length=40,
                        verbose_name="balance jurisdiction",
                    ),
                ),
                (
                    "sup_opp_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[(b"O", b"OPPOSITION"), (b"S", b"SUPPORT")],
                        db_column="SUP_OPP_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711614-CalAccessTablesWeb", start_page=46
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=40
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=49
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=64
                            ),
                        ],
                        help_text="Support or opposition code",
                        max_length=1,
                        verbose_name="support or opposition code",
                    ),
                ),
                (
                    "year_elect",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="YEAR_ELECT",
                        help_text="Year of election",
                        max_length=4,
                        verbose_name="year of election",
                    ),
                ),
                (
                    "pof_title",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="POF_TITLE",
                        help_text="Position/title of the principal officer",
                        max_length=45,
                        verbose_name="principal officer title",
                    ),
                ),
            ],
            options={
                "db_table": "CVR2_SO_CD",
                "verbose_name": "CVR2_SO_CD",
                "verbose_name_plural": "CVR2_SO_CD",
            },
        ),
        migrations.CreateModel(
            name="Cvr3VerificationInfoCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("CVR3", "Cover Page 3, Verification Information")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=25
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=50
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=34
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=64
                            ),
                        ],
                        help_text="Record Type Value: CVR3",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                "F400",
                                b"Form 400 (Statement of Organization (Slate Mailer Organization)): Part 5, Verification",
                            ),
                            (
                                "F401",
                                b"Form 401 (Slate Mailer Organization Campaign Statement): Cover Page",
                            ),
                            (
                                "F402",
                                b"Form 402 (Statement of Termination (Slate Mailer Organization)): Verification",
                            ),
                            (
                                "F410",
                                b"Form 410 (Statement of Organization Recipient Committee): Part 3, Verification",
                            ),
                            (
                                "F425",
                                b"Form 425 (Semi-Annual Statement of no Activity): Part 3, Verification",
                            ),
                            (
                                "F450",
                                b"Form 450 (Recipient Committee Campaign Disclosure Statement - Short Form): Part 4, Verification",
                            ),
                            (
                                "F460",
                                b"Form 460 (Recipient Committee Campaign Statement): Cover Page",
                            ),
                            (
                                "F461",
                                b"Form 461 (Independent Expenditure Committee & Major Donor Committee Campaign Statement): Part 4, Verification",
                            ),
                            (
                                "F465",
                                b"Form 465 (Supplemental Independent Expenditure Report): Part 6, Verification",
                            ),
                            ("F511", b"Form 511: Paid Spokesperson Report"),
                            (
                                "F900",
                                b"Form 900: Public employee's retirement board, candidate campaign statement",
                            ),
                        ],
                        db_column="FORM_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=50
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=64
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=4,
                    ),
                ),
                (
                    "tran_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRAN_ID",
                        help_text="Permanent value unique to this item",
                        max_length=20,
                        verbose_name="transaction ID",
                    ),
                ),
                (
                    "entity_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("ATR", b"Assistant treasurer"),
                            ("CAO", b"Candidate/officeholder"),
                            ("TRE", b"Treasurer"),
                            ("OFF", b"Officer"),
                            ("PRO", b"Proponent"),
                            ("SPO", b"Sponsor"),
                            ("atr", b"Treasurer"),
                            ("tre", b"Assistant treasurer"),
                            ("cao", b"Candidate/officeholder"),
                            ("MDI", b"Major Donor/Ind Expenditure"),
                            ("POF", b"Principal officer"),
                            ("RCP", b"Recipient committee"),
                            ("COA", b"Candidate/officeholder"),
                            ("0", "Unknown"),
                            ("BBB", "Unknown"),
                            ("CON", "Unknown"),
                            ("MAI", "Unknown"),
                        ],
                        db_column="ENTITY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=9
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=25
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=11
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=34
                            ),
                        ],
                        help_text="Entity Code",
                        max_length=3,
                        verbose_name="entity code",
                    ),
                ),
                (
                    "sig_date",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="SIG_DATE",
                        help_text="date when signed",
                        null=True,
                        verbose_name="signed date",
                    ),
                ),
                (
                    "sig_loc",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SIG_LOC",
                        help_text="city and state where signed",
                        max_length=39,
                        verbose_name="signed location",
                    ),
                ),
                (
                    "sig_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SIG_NAML",
                        help_text="last name of the signer",
                        max_length=56,
                        verbose_name="last name",
                    ),
                ),
                (
                    "sig_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SIG_NAMF",
                        help_text="first name of the signer",
                        max_length=45,
                        verbose_name="first name",
                    ),
                ),
                (
                    "sig_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SIG_NAMT",
                        help_text="title of the signer",
                        max_length=10,
                        verbose_name="title",
                    ),
                ),
                (
                    "sig_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SIG_NAMS",
                        help_text="suffix of the signer",
                        max_length=8,
                        verbose_name="suffix",
                    ),
                ),
            ],
            options={
                "db_table": "CVR3_VERIFICATION_INFO_CD",
                "verbose_name": "CVR3_VERIFICATION_INFO_CD",
                "verbose_name_plural": "CVR3_VERIFICATION_INFO_CD",
            },
        ),
        migrations.CreateModel(
            name="CvrCampaignDisclosureCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "amendexp_1",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="AMENDEXP_1",
                        help_text="Amendment explanation line 1",
                        max_length=100,
                    ),
                ),
                (
                    "amendexp_2",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="AMENDEXP_2",
                        help_text="Amendment explanation line 2",
                        max_length=100,
                    ),
                ),
                (
                    "amendexp_3",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="AMENDEXP_3",
                        help_text="Amendment explanation line 3",
                        max_length=100,
                    ),
                ),
                (
                    "assoc_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ASSOC_CB",
                        help_text="Association Interests info included check-box. Legal values are 'X' and null.",
                        max_length=4,
                    ),
                ),
                (
                    "assoc_int",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ASSOC_INT",
                        help_text="Description of association interests",
                        max_length=90,
                    ),
                ),
                (
                    "bal_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_ID",
                        help_text='.CAL format to db tables doc says: "Not Used-AMS KDE"',
                        max_length=9,
                    ),
                ),
                (
                    "bal_juris",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_JURIS",
                        help_text="Ballot measure jurisdiction",
                        max_length=40,
                    ),
                ),
                (
                    "bal_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_NAME",
                        help_text="Ballot measure name",
                        max_length=200,
                    ),
                ),
                (
                    "bal_num",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_NUM",
                        help_text="Ballot measure number or letter",
                        max_length=4,
                    ),
                ),
                (
                    "brdbase_yn",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BRDBASE_YN",
                        help_text="Broad Base Committee (yes/no) check box. Legal values are 'Y' or 'N'.",
                        max_length=1,
                    ),
                ),
                (
                    "bus_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BUS_CITY",
                        help_text="Employer/business address city",
                        max_length=30,
                    ),
                ),
                (
                    "bus_inter",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BUS_INTER",
                        help_text="Employer/business interest description",
                        max_length=40,
                    ),
                ),
                (
                    "bus_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BUS_NAME",
                        help_text="Name of employer/business. Applies to the form 461.",
                        max_length=200,
                    ),
                ),
                (
                    "bus_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BUS_ST",
                        help_text="Employer/business address state",
                        max_length=2,
                    ),
                ),
                (
                    "bus_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BUS_ZIP4",
                        help_text="Employer/business address ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "busact_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BUSACT_CB",
                        help_text="Business activity info included check-box. Valid values are 'X' and null",
                        max_length=10,
                    ),
                ),
                (
                    "busactvity",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BUSACTVITY",
                        help_text="Business activity description",
                        max_length=90,
                    ),
                ),
                (
                    "cand_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_CITY",
                        help_text="Candidate/officeholder city",
                        max_length=30,
                    ),
                ),
                (
                    "cand_email",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_EMAIL",
                        help_text="Candidate/officeholder email. This field is not contained on the forms.",
                        max_length=60,
                    ),
                ),
                (
                    "cand_fax",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_FAX",
                        help_text="Candidate/officeholder fax. This field is not contained on the forms.",
                        max_length=20,
                    ),
                ),
                (
                    "cand_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_ID",
                        help_text='.CAL format to db tables doc says: "Not Used-AMS KDE"',
                        max_length=9,
                    ),
                ),
                (
                    "cand_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMF",
                        help_text="Candidate/officeholder first name",
                        max_length=45,
                    ),
                ),
                (
                    "cand_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAML",
                        help_text="Candidate/officeholder's last name. Applies to forms 460, 465, and 496.",
                        max_length=200,
                    ),
                ),
                (
                    "cand_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMS",
                        help_text="Candidate/officeholder's name suffix",
                        max_length=10,
                    ),
                ),
                (
                    "cand_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMT",
                        help_text="Candidate/officeholder's prefix or title",
                        max_length=10,
                    ),
                ),
                (
                    "cand_phon",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_PHON",
                        help_text="Candidate/officeholder phone",
                        max_length=20,
                    ),
                ),
                (
                    "cand_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_ST",
                        help_text="Candidate/officeholder's state",
                        max_length=4,
                    ),
                ),
                (
                    "cand_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_ZIP4",
                        help_text="Candidate/officeholder's ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "cmtte_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CMTTE_ID",
                        help_text="Committee ID (Filer_id) of recipient Committee who's campaign statement is attached. This field applies to the form 401.",
                        max_length=9,
                        verbose_name="Committee ID",
                    ),
                ),
                (
                    "cmtte_type",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("C", "Candidate or officeholder controlled committee"),
                            (
                                "P",
                                "Candidate or officeholder primarily formed committee",
                            ),
                            ("B", "Ballot-measure committee"),
                            ("G", "General-purpose committee"),
                        ],
                        db_column="CMTTE_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=10
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=19
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=24
                            ),
                        ],
                        help_text="Type of Recipient Committee. Applies to the 450/460.",
                        max_length=1,
                        verbose_name="Committee type",
                    ),
                ),
                (
                    "control_yn",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="CONTROL_YN",
                        help_text="Controlled Committee (yes/no) check box. Legal values are 'Y' or 'N'.",
                        null=True,
                    ),
                ),
                (
                    "dist_no",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="DIST_NO",
                        help_text="District number for the office being sought. Populated for Senate, Assembly, or Board of Equalization races.",
                        max_length=4,
                    ),
                ),
                (
                    "elect_date",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="ELECT_DATE",
                        help_text="Date of the General Election",
                        null=True,
                    ),
                ),
                (
                    "emplbus_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EMPLBUS_CB",
                        help_text="Employer/Business Info included check-box. Legal values are 'X' or null. Applies to the Form 461.",
                        max_length=4,
                    ),
                ),
                (
                    "employer",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EMPLOYER",
                        help_text="Employer. This field is most likely unused.",
                        max_length=200,
                    ),
                ),
                (
                    "entity_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("BMC", b"Ballot measure committee"),
                            ("CAO", b"Candidate/officeholder"),
                            ("COM", b"Committee"),
                            ("CTL", b"Controlled committee"),
                            ("IND", b"Individual"),
                            ("MDI", b"Major Donor/Ind Expenditure"),
                            ("OTH", b"Other"),
                            ("PTY", b"Political Party"),
                            ("RCP", b"Recipient committee"),
                            ("SCC", b"Small Contributor Committee"),
                            ("SMO", b"Slate-mailer organization"),
                        ],
                        db_column="ENTITY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=9,
                                id=b"2712033-Cal-Format-1-05-02",
                                start_page=8,
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=11, id=b"2712034-Cal-Format-201", start_page=9
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=6
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=18
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=22
                            ),
                        ],
                        help_text="The entity type of the filer. These codes vary by form type.",
                        max_length=4,
                        verbose_name="entity code",
                    ),
                ),
                (
                    "file_email",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILE_EMAIL",
                        help_text="Filer's email address",
                        max_length=60,
                    ),
                ),
                (
                    "filer_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_CITY",
                        help_text="Filer's city",
                        max_length=30,
                    ),
                ),
                (
                    "filer_fax",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_FAX",
                        help_text="Filer's fax",
                        max_length=20,
                    ),
                ),
                (
                    "filer_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_ID",
                        db_index=True,
                        help_text="Filer's unique identification number",
                        max_length=15,
                        verbose_name="filer ID",
                    ),
                ),
                (
                    "filer_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_NAMF",
                        help_text="Filer's first name, if an individual",
                        max_length=45,
                    ),
                ),
                (
                    "filer_naml",
                    calaccess_raw.fields.CharField(
                        db_column="FILER_NAML",
                        help_text="The committee's or organization's name or if an individual the filer's last name.",
                        max_length=200,
                    ),
                ),
                (
                    "filer_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_NAMS",
                        help_text="Filer's suffix, if an individual",
                        max_length=10,
                    ),
                ),
                (
                    "filer_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_NAMT",
                        help_text="Filer's title or prefix, if an individual",
                        max_length=10,
                    ),
                ),
                (
                    "filer_phon",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_PHON",
                        help_text="Filer phone number",
                        max_length=20,
                    ),
                ),
                (
                    "filer_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_ST",
                        help_text="Filer state",
                        max_length=4,
                    ),
                ),
                (
                    "filer_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_ZIP4",
                        help_text="Filer ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                "F401",
                                b"Form 401: Slate Mailer Organization Campaign Statement",
                            ),
                            ("F425", b"Form 425: Semi-Annual Statement of no Activity"),
                            (
                                "F450",
                                b"Form 450: Recipient Committee Campaign Disclosure Statement - Short Form",
                            ),
                            (
                                "F460",
                                b"Form 460: Recipient Committee Campaign Statement",
                            ),
                            (
                                "F461",
                                b"Form 461: Independent Expenditure Committee & Major Donor Committee Campaign Statement",
                            ),
                            (
                                "F465",
                                b"Form 465: Supplemental Independent Expenditure Report",
                            ),
                            ("F496", b"Form 496: Late Independent Expenditure Report"),
                            ("F497", b"Form 497: Late Contribution Report"),
                            ("F498", b"Form 498: Slate Mailer Late Payment Report"),
                            ("F511", b"Form 511: Paid Spokesperson Report"),
                            (
                                "F900",
                                b"Form 900: Public employee's retirement board, candidate campaign statement",
                            ),
                        ],
                        db_column="FORM_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=18
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=22
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=4,
                    ),
                ),
                (
                    "from_date",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="FROM_DATE",
                        help_text="Reporting period from date",
                        null=True,
                    ),
                ),
                (
                    "juris_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"ASM", b"Assembly District"),
                            (b"BOE", b"Board of Equalization District"),
                            (b"CIT", b"City"),
                            (b"CTY", b"County"),
                            (b"LOC", b"Local"),
                            (b"OTH", b"Other"),
                            (b"SEN", b"Senate District"),
                            (b"STW", b"Statewide"),
                            ("sen", b"Senate District"),
                            ("Gov", b"Statewide"),
                            ("ATT", b"Statewide"),
                            ("CON", b"Statewide"),
                            ("GOV", b"Statewide"),
                            ("SOS", b"Statewide"),
                            ("SPM", b"Statewide"),
                            ("46", b"Assembly District"),
                            ("55", b"Assembly District"),
                            ("BSU", b"County"),
                            ("CSU", b"County"),
                            ("DAT", b"County"),
                            ("SHC", b"County"),
                            ("MAY", b"City"),
                            ("CCM", b"City"),
                            ("APP", b"Other"),
                            ("BED", b"Other"),
                            ("SCJ", b"Other"),
                            ("SD", b"Other"),
                            ("OC", b"County"),
                            ("AD", b"Assembly District"),
                            ("CA", "Unknown"),
                            ("F", "Unknown"),
                        ],
                        db_column="JURIS_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=13
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=22,
                                id="2712033-Cal-Format-1-05-02",
                                start_page=21,
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=29, id="2712034-Cal-Format-201", start_page=28
                            ),
                        ],
                        help_text="Office jurisdiction code",
                        max_length=3,
                    ),
                ),
                (
                    "juris_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="JURIS_DSCR",
                        help_text="Office Jurisdiction description if the field JURIS_CD is set to city (CIT), county (CTY), local (LOC), or other (OTH).",
                        max_length=40,
                    ),
                ),
                (
                    "late_rptno",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LATE_RPTNO",
                        help_text="Identifying Report Number used to distinguish multiple reports filed during the same filing period. For example, this field allows for multiple form 497s to be filed on the same day.",
                        max_length=30,
                    ),
                ),
                (
                    "mail_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAIL_CITY",
                        help_text="Filer mailing address city",
                        max_length=30,
                    ),
                ),
                (
                    "mail_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAIL_ST",
                        help_text="Filer mailing address state",
                        max_length=4,
                    ),
                ),
                (
                    "mail_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAIL_ZIP4",
                        help_text="Filer mailing address ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "occupation",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="OCCUPATION",
                        help_text="Occupation. This field is most likely unused.",
                        max_length=60,
                    ),
                ),
                (
                    "off_s_h_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("S", b"SOUGHT"),
                            ("H", b"HELD"),
                            ("s", b"SOUGHT"),
                            ("h", b"HELD"),
                            ("F", "UNKNOWN"),
                            ("O", "UNKNOWN"),
                        ],
                        db_column="OFF_S_H_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=21
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=28
                            ),
                        ],
                        help_text="Office is sought or held code",
                        max_length=1,
                    ),
                ),
                (
                    "offic_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="OFFIC_DSCR",
                        help_text="Office sought description if the field OFFICE_CD is set to other (OTH)",
                        max_length=40,
                    ),
                ),
                (
                    "office_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"APP", b"State Appellate Court Justice"),
                            (b"ASM", b"State Assembly Person"),
                            (b"ASR", b"Assessor"),
                            (b"ATT", b"Attorney General"),
                            (b"BED", b"Board of Education"),
                            (b"BOE", b"Board of Equalization Member"),
                            (b"BSU", b"Board of Supervisors"),
                            (b"CAT", b"City Attorney"),
                            (b"CCB", b"Community College Board"),
                            (b"CCM", b"City Council Member"),
                            (b"CON", b"State Controller"),
                            (b"COU", b"County Counsel"),
                            (b"CSU", b"County Supervisor"),
                            (b"CTR", b"Local Controller"),
                            (b"DAT", b"District Attorney"),
                            (b"GOV", b"Governor"),
                            (b"INS", b"Insurance Commissioner"),
                            (b"LTG", b"Lieutenant Governor"),
                            (b"MAY", b"Mayor"),
                            (b"OTH", b"Other"),
                            (b"PDR", b"Public Defender"),
                            (b"PER", b"Public Employees Retirement System"),
                            (b"PLN", b"Planning Commissioner"),
                            (b"SCJ", b"Superior Court Judge"),
                            (b"SEN", b"State Senator"),
                            (b"SHC", b"Sheriff-Coroner"),
                            (b"SOS", b"Secretary of State"),
                            (b"SPM", b"Supreme Court Justice"),
                            (b"SUP", b"Superintendent of Public Instruction"),
                            (b"TRE", b"State Treasurer"),
                            (b"TRS", b"Local Treasurer"),
                            ("Gov", b"Governor"),
                            ("Sen", b"State Senator"),
                            ("LOC", b"Community College Board"),
                            ("LEG", b"State Senator"),
                            ("REP", b"State Assembly Person"),
                            ("Mem", b"Other"),
                            ("CIT", b"State Assembly Person"),
                            ("PAC", "Unknown"),
                            ("F", "Unknown"),
                            ("COM", "Unknown"),
                        ],
                        db_column="OFFICE_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=10
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=12
                            ),
                        ],
                        help_text="Identifies the office being sought",
                        max_length=3,
                        verbose_name="office code",
                    ),
                ),
                (
                    "other_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="OTHER_CB",
                        help_text="Other entity interests info included check-box. Legal values are 'X' and null.",
                        max_length=1,
                    ),
                ),
                (
                    "other_int",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="OTHER_INT",
                        help_text="Other entity interests description",
                        max_length=90,
                    ),
                ),
                (
                    "primfrm_yn",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PRIMFRM_YN",
                        help_text="Primarily Formed Committee (yes/no) checkbox. Legal values are 'Y' or 'N'.",
                        max_length=1,
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("CVR", "Cover Page")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711614-CalAccessTablesWeb", start_page=25
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=6
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=18
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=22
                            ),
                        ],
                        help_text="Record Type Value: CVR",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "report_num",
                    calaccess_raw.fields.CharField(
                        db_column="REPORT_NUM",
                        help_text="Amendment number, as reported by the filer Report Number 000 represents an original filing. 001-999 are amendments.",
                        max_length=3,
                    ),
                ),
                (
                    "reportname",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (
                                "450",
                                b"Form 450: Recipient Committee Campaign Disclosure Statement - Short Form",
                            ),
                            (
                                "460",
                                b"Form 460: Recipient Committee Campaign Statement",
                            ),
                            (
                                "461",
                                b"Form 461: Independent Expenditure Committee & Major Donor Committee Campaign Statement",
                            ),
                        ],
                        db_column="REPORTNAME",
                        documentcloud_pages=(
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=15
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=20
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=19
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=26
                            ),
                        ),
                        help_text="Attached campaign disclosure statement type. Legal values are 450, 460, and 461.",
                        max_length=3,
                    ),
                ),
                (
                    "rpt_att_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RPT_ATT_CB",
                        help_text="Committee Report Attached check-box. Legal values are 'X' or null. This field applies to the form 401.",
                        max_length=4,
                    ),
                ),
                (
                    "rpt_date",
                    calaccess_raw.fields.DateField(
                        db_column="RPT_DATE",
                        help_text="Date this report was filed, according to the filer",
                        null=True,
                    ),
                ),
                (
                    "rptfromdt",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="RPTFROMDT",
                        help_text="Attached campaign disclosure statement - Period from date.",
                        null=True,
                    ),
                ),
                (
                    "rptthrudt",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="RPTTHRUDT",
                        help_text="Attached campaign disclosure statement - Period through date.",
                        null=True,
                    ),
                ),
                (
                    "selfemp_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SELFEMP_CB",
                        help_text='Self employed check-box. CAL format to db tables doc says: "Not Used-AMS KDE"',
                        max_length=1,
                    ),
                ),
                (
                    "sponsor_yn",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="SPONSOR_YN",
                        help_text="Sponsored Committee (yes/no) checkbox. Legal values are 'Y' or 'N'.",
                        null=True,
                    ),
                ),
                (
                    "stmt_type",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("PE", b"Pre-Election (F450, F460)"),
                            ("QT", b"Quarterly Stmt (F450,F460)"),
                            ("SA", b"Semi-annual (F450, F460)"),
                            ("SE", b"Supplemental Pre-elect (F450, F460, F495)"),
                            ("SY", b"Special Odd-Yr. Campaign (F450, F460)"),
                            ("S1", b"Semi-Annual (Jan1-Jun30) (F425)"),
                            ("S2", b"Semi-Annual (Jul1-Dec31) (F425)"),
                            ("TS", b"Termination Statement (F450, F460)"),
                            ("pe", b"Pre-Election (F450, F460)"),
                            ("qt", b"Quarterly Stmt (F450,F460)"),
                            ("sa", b"Semi-annual (F450, F460)"),
                            ("se", b"Supplemental Pre-elect (F450, F460, F495)"),
                            ("sy", b"Special Odd-Yr. Campaign (F450, F460)"),
                            ("ts", b"Termination Statement (F450, F460)"),
                            ("**", "Amendment"),
                            ("1", "Unknown"),
                            ("2", "Unknown"),
                            ("CA", "Unknown"),
                            ("MD", "Unknown"),
                            ("NA", "Unknown"),
                            ("PR", "Unknown"),
                            ("QS", "Unknown"),
                            ("S", "Unknown"),
                            ("x", "Unknown"),
                            ("YE", "Unknown"),
                        ],
                        db_column="STMT_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=7
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=18
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=23
                            ),
                        ],
                        help_text="Type of statement",
                        max_length=2,
                    ),
                ),
                (
                    "sup_opp_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("S", b"SUPPORT"),
                            ("O", b"OPPOSITION"),
                            ("s", b"SUPPORT"),
                            ("o", b"OPPOSITION"),
                        ],
                        db_column="SUP_OPP_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711614-CalAccessTablesWeb", start_page=28
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=14
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=21
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=28
                            ),
                        ],
                        help_text="Support or opposition code",
                        max_length=1,
                    ),
                ),
                (
                    "thru_date",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="THRU_DATE",
                        help_text="Reporting period through date",
                        null=True,
                    ),
                ),
                (
                    "tres_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_CITY",
                        help_text="City portion of the treasurer or responsible officer's street address.",
                        max_length=30,
                    ),
                ),
                (
                    "tres_email",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_EMAIL",
                        help_text="Treasurer or responsible officer's email",
                        max_length=60,
                    ),
                ),
                (
                    "tres_fax",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_FAX",
                        help_text="Treasurer or responsible officer's fax number",
                        max_length=20,
                    ),
                ),
                (
                    "tres_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAMF",
                        help_text="Treasurer or responsible officer's first name",
                        max_length=45,
                    ),
                ),
                (
                    "tres_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAML",
                        help_text="Treasurer or responsible officer's last name",
                        max_length=200,
                    ),
                ),
                (
                    "tres_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAMS",
                        help_text="Treasurer or responsible officer's suffix",
                        max_length=10,
                    ),
                ),
                (
                    "tres_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAMT",
                        help_text="Treasurer or responsible officer's prefix or title",
                        max_length=10,
                    ),
                ),
                (
                    "tres_phon",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_PHON",
                        help_text="Treasurer or responsible officer's phone number",
                        max_length=20,
                    ),
                ),
                (
                    "tres_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_ST",
                        help_text="Treasurer or responsible officer's state",
                        max_length=2,
                    ),
                ),
                (
                    "tres_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_ZIP4",
                        help_text="Treasurer or responsible officer's ZIP Code",
                        max_length=10,
                    ),
                ),
            ],
            options={
                "db_table": "CVR_CAMPAIGN_DISCLOSURE_CD",
                "verbose_name": "CVR_CAMPAIGN_DISCLOSURE_CD",
                "verbose_name_plural": "CVR_CAMPAIGN_DISCLOSURE_CD",
            },
        ),
        migrations.CreateModel(
            name="CvrE530Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("CVR", "CVR")],
                        db_column="REC_TYPE",
                        db_index=True,
                        help_text="Record Type",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"E530",
                                b"Electronic Form 530: Electronic Issue Advocacy Report",
                            )
                        ],
                        db_column="FORM_TYPE",
                        db_index=True,
                        help_text="Name of the source filing form or schedule",
                        max_length=4,
                        verbose_name="form type",
                    ),
                ),
                (
                    "entity_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"ATH", b"Authorizing individual"),
                            (b"ATR", b"Assistant treasurer"),
                            (b"BMC", b"Ballot measure committee"),
                            (b"BNM", b"Ballot measure's name/title"),
                            (b"CAO", b"Candidate/officeholder"),
                            (b"COM", b"Committee"),
                            (b"CTL", b"Controlled committee"),
                            (b"IND", b"Individual"),
                            (b"MDI", b"Major Donor/Ind Expenditure"),
                            (b"OFF", b"Officer"),
                            (b"OTH", b"Other"),
                            (b"POF", b"Principal officer"),
                            (b"PRO", b"Proponent"),
                            (b"PTY", b"Political Party"),
                            (b"RCP", b"Recipient committee"),
                            (b"SCC", b"Small Contributor Committee"),
                            (b"SMO", b"Slate-mailer organization"),
                            (b"SPO", b"Sponsor"),
                            (b"TRE", b"Treasurer"),
                        ],
                        db_column="ENTITY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=9,
                                id=b"2712033-Cal-Format-1-05-02",
                                start_page=8,
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=11, id=b"2712034-Cal-Format-201", start_page=9
                            ),
                        ],
                        help_text="entity code",
                        max_length=32,
                        verbose_name="entity code",
                    ),
                ),
                (
                    "filer_naml",
                    calaccess_raw.fields.CharField(
                        db_column="FILER_NAML",
                        help_text="Filer last name",
                        max_length=200,
                    ),
                ),
                (
                    "filer_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_NAMF",
                        help_text="Filer first name",
                        max_length=4,
                    ),
                ),
                (
                    "filer_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_NAMT",
                        help_text="Filer title or prefix",
                        max_length=32,
                    ),
                ),
                (
                    "filer_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_NAMS",
                        help_text="Filer suffix",
                        max_length=32,
                    ),
                ),
                (
                    "report_num",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="REPORT_NUM",
                        help_text="This field is undocumented",
                        max_length=32,
                    ),
                ),
                (
                    "rpt_date",
                    calaccess_raw.fields.DateField(
                        db_column="RPT_DATE",
                        help_text="This field is undocumented",
                        null=True,
                    ),
                ),
                (
                    "filer_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_CITY",
                        help_text="Filer city",
                        max_length=16,
                    ),
                ),
                (
                    "filer_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_ST",
                        help_text="Filer state",
                        max_length=4,
                    ),
                ),
                (
                    "filer_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_ZIP4",
                        help_text="Filer ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "occupation",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="OCCUPATION",
                        help_text="This field is undocumented",
                        max_length=15,
                    ),
                ),
                (
                    "employer",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EMPLOYER",
                        help_text="This field is undocumented",
                        max_length=13,
                    ),
                ),
                (
                    "cand_naml",
                    calaccess_raw.fields.CharField(
                        db_column="CAND_NAML",
                        help_text="Candidate last name",
                        max_length=46,
                    ),
                ),
                (
                    "cand_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMF",
                        help_text="Candidate first name",
                        max_length=21,
                    ),
                ),
                (
                    "cand_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMT",
                        help_text="Candidate title or prefix",
                        max_length=32,
                    ),
                ),
                (
                    "cand_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMS",
                        help_text="Candidate suffix",
                        max_length=32,
                    ),
                ),
                (
                    "district_cd",
                    calaccess_raw.fields.IntegerField(
                        choices=[
                            (0, "N/A"),
                            (17001, "01"),
                            (17002, "13"),
                            (17003, "24"),
                            (17004, "35"),
                            (17005, "46"),
                            (17006, "57"),
                            (17007, "68"),
                            (17008, "79"),
                            (17009, "02"),
                            (17010, "05"),
                            (17011, "04"),
                            (17013, "06"),
                            (17014, "07"),
                            (17015, "08"),
                            (17016, "19"),
                            (17017, "10"),
                            (17018, "11"),
                            (17019, "12"),
                            (17020, "14"),
                            (17021, "15"),
                            (17022, "16"),
                            (17023, "17"),
                            (17024, "18"),
                            (17026, "20"),
                            (17027, "21"),
                            (17028, "22"),
                            (17029, "23"),
                            (17030, "25"),
                            (17031, "26"),
                            (17032, "27"),
                            (17033, "28"),
                            (17034, "29"),
                            (17035, "30"),
                            (17036, "31"),
                            (17037, "32"),
                            (17038, "33"),
                            (17039, "34"),
                            (17040, "36"),
                            (17041, "37"),
                            (17042, "38"),
                            (17043, "39"),
                            (17044, "40"),
                            (17045, "41"),
                            (17046, "42"),
                            (17047, "43"),
                            (17048, "44"),
                            (17049, "45"),
                            (17050, "47"),
                            (17051, "48"),
                            (17052, "49"),
                            (17053, "50"),
                            (17054, "51"),
                            (17055, "52"),
                            (17056, "53"),
                            (17057, "54"),
                            (17058, "55"),
                            (17059, "56"),
                            (17060, "03"),
                            (17061, "59"),
                            (17062, "60"),
                            (17063, "61"),
                            (17064, "62"),
                            (17065, "63"),
                            (17066, "64"),
                            (17067, "65"),
                            (17068, "66"),
                            (17069, "67"),
                            (17070, "69"),
                            (17071, "70"),
                            (17072, "71"),
                            (17073, "72"),
                            (17074, "73"),
                            (17075, "74"),
                            (17076, "75"),
                            (17077, "76"),
                            (17078, "77"),
                            (17079, "78"),
                            (17080, "80"),
                            (17081, "09"),
                            (17090, "58"),
                        ],
                        db_column="DISTRICT_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=13, id="2774529-Lookup-Codes-Cd", start_page=11
                            )
                        ],
                        help_text="District Code",
                    ),
                ),
                (
                    "office_cd",
                    calaccess_raw.fields.IntegerField(
                        choices=[
                            (30001, "PRESIDENT"),
                            (30002, "GOVERNOR"),
                            (30003, "LIEUTENANT GOVERNOR"),
                            (30004, "SECRETARY OF STATE"),
                            (30005, "CONTROLLER"),
                            (30006, "TREASURER"),
                            (30007, "ATTORNEY GENERAL"),
                            (30008, "SUPERINTENDENT OF PUBLIC INSTRUCTION"),
                            (30009, "MEMBER BOARD OF EQUALIZATION"),
                            (30010, "OXNARD HARBOR COMMISSIONER"),
                            (30011, "CITY CONTROLLER"),
                            (30012, "STATE SENATE"),
                            (30013, "ASSEMBLY"),
                            (30014, "INSURANCE COMMISSIONER"),
                            (30015, "JUDGE"),
                            (30016, "BOARD MEMBER"),
                            (30017, "TAX COLLECTOR"),
                            (30018, "TRUSTEE"),
                            (30019, "SUPERVISOR"),
                            (30020, "SHERIFF"),
                            (30021, "CORONER"),
                            (30022, "MARSHALL"),
                            (30023, "CITY CLERK"),
                            (30024, "SCHOOL BOARD"),
                            (30025, "HARBOR COMMISSIONER"),
                            (30026, "DISTRICT ATTORNEY"),
                            (30027, "COUNTY CLERK"),
                            (30028, "AUDITOR"),
                            (30029, "MAYOR"),
                            (30030, "CITY ATTORNEY"),
                            (30031, "DEMOCRATIC COUNTY CENTRAL COMMITTEE"),
                            (30032, "TOWN COUNCIL"),
                            (30033, "ASSESSOR"),
                            (30034, "CITY TREASURER"),
                            (30035, "CITY COUNCIL"),
                            (30036, "COMMISSIONER"),
                            (30037, "REPUBLICAN COUNTY CENTRAL COMMITTEE"),
                            (30038, "DIRECTOR"),
                            (30039, "DIRECTOR OF ZONE 7"),
                            (30040, "COMMUNITY COLLEGE BOARD"),
                            (30041, "POLICE CHIEF"),
                            (30042, "CHIEF OF POLICE"),
                            (30043, "CENTRAL COMMITTEE"),
                            (30044, "BOARD OF EDUCATION"),
                            (30045, "BOARD OF DIRECTORS"),
                            (30046, "COLLEGE BOARD"),
                            (30047, "BART BOARD DIRECTOR"),
                            (30048, "BOARD OF TRUSTEES"),
                            (30049, "IRRIGATION"),
                            (30050, "WATER BOARD"),
                            (30051, "COMMUNITY PLANNING GROUP"),
                            (30052, "BOARD OF SUPERVISORS"),
                            (30053, "SUPERIOR COURT JUDGE"),
                            (30054, "DISTRICT ATTORNEY/PUBLIC DEFENDER"),
                            (30055, "MEASURE"),
                            (30056, "CITY PROSECUTOR"),
                            (30057, "SUPREME COURT JUDGE"),
                            (30058, "PUBLIC EMPLOYEES RETIREMENT BOARD"),
                            (30059, "APPELLATE COURT JUDGE"),
                            (50001, "Ag"),
                            (50002, "Assembly"),
                            (50003, "Assessor"),
                            (50004, "Assessor/Clerk/Recorder"),
                            (50005, "Assessor/County Clerk/Recorder"),
                            (50006, "Assessor/Recorder"),
                            (50007, "Associate Justice"),
                            (50008, "Auditor"),
                            (50009, "Auditor/Controller"),
                            (50010, "Auditor/Controller/Clerk/Recorder"),
                            (50011, "Auditor/Controller/Recorder"),
                            (50012, "Auditor/Controller/Treasurer/Tax Collector"),
                            (50013, "Auditor/Recorder"),
                            (50014, "Board Member"),
                            (50015, "Board Of Director"),
                            (50016, "Board Of Supervisor"),
                            (50017, "Boe"),
                            (50018, "Chief Justice"),
                            (50019, "City"),
                            (50020, "City Attorney"),
                            (50021, "City Auditor"),
                            (50022, "City Clerk"),
                            (50023, "City Council"),
                            (50024, "City Of Los Angeles"),
                            (50025, "City Of South El Monte"),
                            (50026, "City Prosecutor"),
                            (50027, "City Treasurer"),
                            (50028, "Clerk/Auditor"),
                            (50029, "Clerk/Record/Public Admin"),
                            (50030, "Clerk/Recorder"),
                            (50031, "Clerk/Recorder/Registar"),
                            (50032, "Clerk/Recorder/Registrar"),
                            (50033, "Commissioner"),
                            (50034, "Controller"),
                            (50035, "Costa Mesa"),
                            (50036, "Council Member"),
                            (50037, "County Clerk"),
                            (50038, "County Clerk/Auditor"),
                            (50039, "County Clerk/Auditor/Controller"),
                            (50040, "County Clerk/Recorder"),
                            (50041, "County Clerk/Recorder/Assessor"),
                            (50042, "County Clerk/Recorder/Public Admin"),
                            (50043, "Democratic County Central Committee"),
                            (50044, "Director"),
                            (50045, "District Attorney"),
                            (50046, "District Attorney/Public Administrator"),
                            (50047, "Gccc"),
                            (50048, "Governor"),
                            (50049, "Harbor Commissioner"),
                            (50050, "Ic"),
                            (50051, "Irrigation Dist"),
                            (50052, "Judge"),
                            (50053, "Justice"),
                            (50054, "Legislature"),
                            (50055, "Lieutenant Governor"),
                            (50056, "Mayor"),
                            (50057, "N/A"),
                            (50058, "Placentia"),
                            (50059, "Public Administrator"),
                            (50060, "Public Administrator/Guardian"),
                            (50061, "Rent Stabilization Board"),
                            (50062, "Republican Central Committee"),
                            (50063, "San Francisco Dccc"),
                            (50064, "Sanger"),
                            (50065, "School Board"),
                            (50066, "Secretary Of State"),
                            (50067, "Senator"),
                            (50068, "Sheriff"),
                            (50069, "Sheriff/Coroner"),
                            (50070, "Sheriff/Coroner/Marshall"),
                            (50071, "Sheriff/Coroner/Public Administrator"),
                            (50072, "Solana Beach"),
                            (50073, "Superintendent"),
                            (50074, "Supervisor"),
                            (50075, "Supt Of Schools"),
                            (50076, "Tax Collector"),
                            (50077, "Town Council"),
                            (50078, "Treasurer"),
                            (50079, "Treasurer/Tax Collector"),
                            (50080, "Treasurer/Tax Collector/Clerk"),
                            (50081, "Treasurer/Tax Collector/Public Administrator"),
                            (
                                50082,
                                "Treasurer/Tax Collector/Public Administrator/County Clerk",
                            ),
                            (50083, "Treasurer/Tax Collector/Recorder"),
                            (50084, "Trustee"),
                            (50085, "Weed Recreation Board Member"),
                        ],
                        db_column="OFFICE_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=18, id="2774529-Lookup-Codes-Cd", start_page=16
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=22, id="2774529-Lookup-Codes-Cd", start_page=20
                            ),
                        ],
                        help_text="Identifies the office being sought",
                        verbose_name="office code",
                    ),
                ),
                (
                    "pmnt_dt",
                    calaccess_raw.fields.DateField(
                        db_column="PMNT_DT",
                        help_text="This field is undocumented",
                        null=True,
                    ),
                ),
                (
                    "pmnt_amount",
                    calaccess_raw.fields.FloatField(
                        db_column="PMNT_AMOUNT", help_text="This field is undocumented"
                    ),
                ),
                (
                    "type_literature",
                    calaccess_raw.fields.IntegerField(
                        db_column="TYPE_LITERATURE",
                        help_text="This field is undocumented",
                    ),
                ),
                (
                    "type_printads",
                    calaccess_raw.fields.IntegerField(
                        db_column="TYPE_PRINTADS",
                        help_text="This field is undocumented",
                    ),
                ),
                (
                    "type_radio",
                    calaccess_raw.fields.IntegerField(
                        db_column="TYPE_RADIO", help_text="This field is undocumented"
                    ),
                ),
                (
                    "type_tv",
                    calaccess_raw.fields.IntegerField(
                        db_column="TYPE_TV", help_text="This field is undocumented"
                    ),
                ),
                (
                    "type_it",
                    calaccess_raw.fields.IntegerField(
                        db_column="TYPE_IT", help_text="This field is undocumented"
                    ),
                ),
                (
                    "type_billboards",
                    calaccess_raw.fields.IntegerField(
                        db_column="TYPE_BILLBOARDS",
                        help_text="This field is undocumented",
                    ),
                ),
                (
                    "type_other",
                    calaccess_raw.fields.IntegerField(
                        db_column="TYPE_OTHER", help_text="This field is undocumented"
                    ),
                ),
                (
                    "other_desc",
                    calaccess_raw.fields.CharField(
                        db_column="OTHER_DESC",
                        help_text="This field is undocumented",
                        max_length=49,
                    ),
                ),
            ],
            options={
                "db_table": "CVR_E530_CD",
                "verbose_name": "CVR_E530_CD",
                "verbose_name_plural": "CVR_E530_CD",
            },
        ),
        migrations.CreateModel(
            name="CvrF470Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment Identification number. A number of 0 is an original filing and 1 to 999 amendments.",
                    ),
                ),
                (
                    "cand_adr1",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_ADR1",
                        help_text="First line of the filer's street address.",
                        max_length=55,
                    ),
                ),
                (
                    "cand_adr2",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_ADR2",
                        help_text="Second line of the filer's street address. ",
                        max_length=55,
                    ),
                ),
                (
                    "cand_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_CITY",
                        help_text="Candidate/Officeholder's City.",
                        max_length=30,
                    ),
                ),
                (
                    "cand_email",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_EMAIL",
                        help_text="Candidate/Officeholder's EMail address. Not required by the form.",
                        max_length=60,
                    ),
                ),
                (
                    "cand_fax",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_FAX",
                        help_text="Candidate/Officeholder's FAX Phone Number. Not required by the form.",
                        max_length=20,
                    ),
                ),
                (
                    "cand_phon",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_PHON",
                        help_text="Candidate/Officeholder's phone number.",
                        max_length=20,
                    ),
                ),
                (
                    "cand_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_ST",
                        help_text="Filer's State",
                        max_length=2,
                    ),
                ),
                (
                    "cand_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_ZIP4",
                        help_text="Filer's zipcode",
                        max_length=10,
                    ),
                ),
                (
                    "date_1000",
                    calaccess_raw.fields.DateField(
                        db_column="DATE_1000",
                        help_text="Date contributions totaling $1,000 or more. (For the 470-S)",
                    ),
                ),
                (
                    "dist_no",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="DIST_NO",
                        help_text="District number for the office being sought. Populated for Senate, Assembly, or Board of Equalization races.",
                        max_length=3,
                    ),
                ),
                (
                    "elect_date",
                    calaccess_raw.fields.DateField(
                        db_column="ELECT_DATE",
                        help_text="Date of the general election. Required for filings in even years.",
                    ),
                ),
                (
                    "entity_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[("CAO", b"Candidate/officeholder")],
                        db_column="ENTITY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=22
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=29
                            ),
                        ],
                        help_text="The filer's entity code. The value of this column will always be Candidate/Office Holder (CAO) for this table.",
                        max_length=3,
                    ),
                ),
                (
                    "filer_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_ID",
                        help_text="Filer's unique identification number.",
                        max_length=9,
                    ),
                ),
                (
                    "filer_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_NAMF",
                        help_text="Filer's First Name(s) - required for individuals",
                        max_length=45,
                    ),
                ),
                (
                    "filer_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_NAML",
                        help_text="Filer's Last Name/Committee name",
                        max_length=200,
                    ),
                ),
                (
                    "filer_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_NAMS",
                        help_text="Filer's Name Suffix",
                        max_length=10,
                    ),
                ),
                (
                    "filer_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_NAMT",
                        help_text="The filer's prefix or title that preceeds their name if they are an individual.",
                        max_length=10,
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identification number.",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"F470",
                                b"Form 470: Officeholder and Candidate Campaign Statement, Short Form",
                            )
                        ],
                        db_column="FORM_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=22
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=29
                            ),
                        ],
                        help_text="Type of Filing or Formset. The value of this column will always be equal to F470.",
                        max_length=4,
                    ),
                ),
                (
                    "juris_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"ASM", b"Assembly District"),
                            (b"BOE", b"Board of Equalization District"),
                            (b"CIT", b"City"),
                            (b"CTY", b"County"),
                            (b"LOC", b"Local"),
                            (b"OTH", b"Other"),
                            (b"SEN", b"Senate District"),
                            (b"STW", b"Statewide"),
                        ],
                        db_column="JURIS_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=22
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=29
                            ),
                        ],
                        help_text="Office Jurisdiction Code",
                        max_length=3,
                    ),
                ),
                (
                    "juris_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="JURIS_DSCR",
                        help_text="Office jurisdiction description text reqired if the jurisdiction code (Juris_cd) is equal to CIT, CTY, LOC, or OTH.",
                        max_length=40,
                    ),
                ),
                (
                    "off_s_h_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[(b"H", b"HELD"), (b"S", b"SOUGHT")],
                        db_column="OFF_S_H_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=22
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=30
                            ),
                        ],
                        help_text='Office Sought/Held code. Legal values are "S" for sought and "H" for held.',
                        max_length=1,
                    ),
                ),
                (
                    "offic_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="OFFIC_DSCR",
                        help_text="Office sought description used if the office code is other (OTH).",
                        max_length=40,
                    ),
                ),
                (
                    "office_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"APP", b"State Appellate Court Justice"),
                            (b"ASM", b"State Assembly Person"),
                            (b"ASR", b"Assessor"),
                            (b"ATT", b"Attorney General"),
                            (b"BED", b"Board of Education"),
                            (b"BOE", b"Board of Equalization Member"),
                            (b"BSU", b"Board of Supervisors"),
                            (b"CAT", b"City Attorney"),
                            (b"CCB", b"Community College Board"),
                            (b"CCM", b"City Council Member"),
                            (b"CON", b"State Controller"),
                            (b"COU", b"County Counsel"),
                            (b"CSU", b"County Supervisor"),
                            (b"CTR", b"Local Controller"),
                            (b"DAT", b"District Attorney"),
                            (b"GOV", b"Governor"),
                            (b"INS", b"Insurance Commissioner"),
                            (b"LTG", b"Lieutenant Governor"),
                            (b"MAY", b"Mayor"),
                            (b"OTH", b"Other"),
                            (b"PDR", b"Public Defender"),
                            (b"PER", b"Public Employees Retirement System"),
                            (b"PLN", b"Planning Commissioner"),
                            (b"SCJ", b"Superior Court Judge"),
                            (b"SEN", b"State Senator"),
                            (b"SHC", b"Sheriff-Coroner"),
                            (b"SOS", b"Secretary of State"),
                            (b"SPM", b"Supreme Court Justice"),
                            (b"SUP", b"Superintendent of Public Instruction"),
                            (b"TRE", b"State Treasurer"),
                            (b"TRS", b"Local Treasurer"),
                        ],
                        db_column="OFFICE_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=22
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=29
                            ),
                        ],
                        help_text="Code that identifies the office being sought. See the CAL document for a list of valid codes.",
                        max_length=3,
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[("CVR", "Cover Page")],
                        db_column="REC_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=22
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=29
                            ),
                        ],
                        help_text="Type of CAL record. This column will always contain CVR.",
                        max_length=3,
                    ),
                ),
                (
                    "report_num",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="REPORT_NUM",
                        help_text="Report Number; 000 Original; 001-999 Amended as reported in the filing.",
                        max_length=3,
                    ),
                ),
                (
                    "rpt_date",
                    calaccess_raw.fields.DateField(
                        db_column="RPT_DATE",
                        db_index=True,
                        help_text="Date this report is filed as reported by the filer.",
                        null=True,
                    ),
                ),
            ],
            options={
                "db_table": "CVR_F470_CD",
                "verbose_name": "CVR_F470_CD",
                "verbose_name_plural": "CVR_F470_CD",
            },
        ),
        migrations.CreateModel(
            name="CvrLobbyDisclosureCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "ctrib_n_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CTRIB_N_CB",
                        help_text="'Campaign contribtions? P4 attached' checkbox. Applies to forms 625, 635, 645.",
                        max_length=1,
                    ),
                ),
                (
                    "ctrib_y_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CTRIB_Y_CB",
                        help_text="'Campaign contribtions? P4 attached' checkbox. Applies to forms 625, 635, 645.",
                        max_length=1,
                    ),
                ),
                (
                    "cum_beg_dt",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="CUM_BEG_DT",
                        help_text="Cumulative period beginning date",
                        null=True,
                    ),
                ),
                (
                    "entity_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("CLI", "Unknown"),
                            ("FRM", b"Lobbying Firm"),
                            ("IND", b"Person (spending > $5000)"),
                            ("LBY", b"Lobbyist (an individual)"),
                            ("LCO", b"Lobbying Coalition"),
                            ("LEM", b"Lobbying Employer"),
                            ("OTH", b"Other"),
                        ],
                        db_column="ENTITY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=53
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=67
                            ),
                        ],
                        help_text="Entity Code describing the filer",
                        max_length=3,
                        verbose_name="entity code",
                    ),
                ),
                (
                    "filer_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_ID",
                        db_index=True,
                        help_text="Filer's unique identification number",
                        max_length=9,
                        verbose_name="filer ID",
                    ),
                ),
                (
                    "filer_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_NAMF",
                        help_text="Filer first name",
                        max_length=45,
                    ),
                ),
                (
                    "filer_naml",
                    calaccess_raw.fields.CharField(
                        db_column="FILER_NAML",
                        help_text="Filer last name or business name",
                        max_length=200,
                    ),
                ),
                (
                    "filer_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_NAMS",
                        help_text="Filer suffix",
                        max_length=10,
                    ),
                ),
                (
                    "filer_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_NAMT",
                        help_text="Filer title or prefix",
                        max_length=10,
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "firm_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FIRM_CITY",
                        help_text="Firm, employer or coalition business city",
                        max_length=30,
                    ),
                ),
                (
                    "firm_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FIRM_ID",
                        help_text="Identification number of firm, employer or coalition",
                        max_length=9,
                    ),
                ),
                (
                    "firm_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FIRM_NAME",
                        help_text="Name of firm, employer or coalition",
                        max_length=200,
                    ),
                ),
                (
                    "firm_phon",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FIRM_PHON",
                        help_text="Firm, employer or coalition business phone number",
                        max_length=20,
                    ),
                ),
                (
                    "firm_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FIRM_ST",
                        help_text="Firm, employer or coalition business state",
                        max_length=2,
                    ),
                ),
                (
                    "firm_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FIRM_ZIP4",
                        help_text="Form, employer or coalition business ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (b"F615", b"Form 615: Lobbyist Report"),
                            (b"F625", b"Form 625: Report of Lobbying Firm"),
                            (
                                b"F635",
                                b"Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                            ),
                            (
                                b"F645",
                                b"Form 645: Report of Person Spending $5,000 or More",
                            ),
                        ],
                        db_column="FORM_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=53
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=66
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=4,
                    ),
                ),
                (
                    "from_date",
                    calaccess_raw.fields.DateField(
                        db_column="FROM_DATE",
                        help_text="Reporting period from date",
                        null=True,
                    ),
                ),
                (
                    "lby_actvty",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LBY_ACTVTY",
                        help_text="Description of lobbying activity. Applies to forms 635 and 645. Additional description may be provided in text records.",
                        max_length=400,
                    ),
                ),
                (
                    "lobby_n_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LOBBY_N_CB",
                        help_text="'Lobbying activity none' checkbox. Applies only to Form 625.",
                        max_length=1,
                    ),
                ),
                (
                    "lobby_y_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LOBBY_Y_CB",
                        help_text="'Lobbying activity Form 630 attached' checkbox. Applies only to Form 625.",
                        max_length=1,
                    ),
                ),
                (
                    "mail_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAIL_CITY",
                        help_text="Filer mailing address city",
                        max_length=30,
                    ),
                ),
                (
                    "mail_phon",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAIL_PHON",
                        help_text="Filer mailing address phone number",
                        max_length=20,
                    ),
                ),
                (
                    "mail_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAIL_ST",
                        help_text="Filer mailing address state",
                        max_length=2,
                    ),
                ),
                (
                    "mail_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAIL_ZIP4",
                        help_text="Filer mailing address ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "major_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAJOR_NAMF",
                        help_text="Major donor first name. Applies only to individuals and forms 625, 635, 645.",
                        max_length=45,
                    ),
                ),
                (
                    "major_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAJOR_NAML",
                        help_text="Major donor last name. Applies only to individuals and forms 625, 635, 645.",
                        max_length=200,
                    ),
                ),
                (
                    "major_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAJOR_NAMS",
                        help_text="Major donor suffix. Applies only to individuals and forms 625, 635, 645.",
                        max_length=10,
                    ),
                ),
                (
                    "major_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAJOR_NAMT",
                        help_text="Major donor title or prefix. Applies only to individuals and forms 625, 635, 645.",
                        max_length=10,
                    ),
                ),
                (
                    "nopart1_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="NOPART1_CB",
                        help_text="'No Part I information' checkbox. Applies only to Form 615.",
                        max_length=1,
                    ),
                ),
                (
                    "nopart2_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="NOPART2_CB",
                        help_text="'No Part II information' checkbox. Applies only to Form 615.",
                        max_length=1,
                    ),
                ),
                (
                    "part1_1_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PART1_1_CB",
                        help_text="'Partners, owners Form 615 attached ...' checkbox. Applies only to form 625.",
                        max_length=1,
                    ),
                ),
                (
                    "part1_2_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PART1_2_CB",
                        help_text="'Partners, owners listed below ...' checkbox. Applies only to Form 625.",
                        max_length=1,
                    ),
                ),
                (
                    "prn_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PRN_NAMF",
                        help_text="Signer first name",
                        max_length=45,
                    ),
                ),
                (
                    "prn_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PRN_NAML",
                        help_text="Signer last name",
                        max_length=200,
                    ),
                ),
                (
                    "prn_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PRN_NAMS",
                        help_text="Signer suffix",
                        max_length=10,
                    ),
                ),
                (
                    "prn_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PRN_NAMT",
                        help_text="Signer title or prefix",
                        max_length=10,
                    ),
                ),
                (
                    "rcpcmte_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RCPCMTE_ID",
                        help_text="Recipient committee or major donor identification number",
                        max_length=9,
                    ),
                ),
                (
                    "rcpcmte_nm",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RCPCMTE_NM",
                        help_text="Recipient committee name",
                        max_length=200,
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("CVR", "CVR")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=53
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=66
                            ),
                        ],
                        help_text="Record Type Value: CVR",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "report_num",
                    calaccess_raw.fields.CharField(
                        db_column="REPORT_NUM",
                        help_text="Amendment number. 000 is the original. 001-999 are amendments.",
                        max_length=3,
                    ),
                ),
                (
                    "rpt_date",
                    calaccess_raw.fields.DateField(
                        db_column="RPT_DATE",
                        help_text="Date this report was filed, as reported by the filer",
                        null=True,
                    ),
                ),
                (
                    "sender_id",
                    calaccess_raw.fields.CharField(
                        db_column="SENDER_ID",
                        help_text="Identification number of lobbyist entity that is submitting this report. The field is used to authenticate the filer and allows the firm to submit forms for its lobbyists.",
                        max_length=9,
                    ),
                ),
                (
                    "sig_date",
                    calaccess_raw.fields.DateField(
                        db_column="SIG_DATE", help_text="Date when signed", null=True
                    ),
                ),
                (
                    "sig_loc",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SIG_LOC",
                        help_text="Signer city and state",
                        max_length=45,
                    ),
                ),
                (
                    "sig_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SIG_NAMF",
                        help_text="Signer first name",
                        max_length=45,
                    ),
                ),
                (
                    "sig_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SIG_NAML",
                        help_text="Signer last name",
                        max_length=200,
                    ),
                ),
                (
                    "sig_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SIG_NAMS",
                        help_text="Signer suffix",
                        max_length=10,
                    ),
                ),
                (
                    "sig_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SIG_NAMT",
                        help_text="Signer title or prefix",
                        max_length=10,
                    ),
                ),
                (
                    "sig_title",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SIG_TITLE",
                        help_text="Title of signer",
                        max_length=45,
                    ),
                ),
                (
                    "thru_date",
                    calaccess_raw.fields.DateField(
                        db_column="THRU_DATE",
                        help_text="Reporting period through date",
                        null=True,
                    ),
                ),
            ],
            options={
                "db_table": "CVR_LOBBY_DISCLOSURE_CD",
                "verbose_name": "CVR_LOBBY_DISCLOSURE_CD",
                "verbose_name_plural": "CVR_LOBBY_DISCLOSURE_CD",
            },
        ),
        migrations.CreateModel(
            name="CvrRegistrationCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "a_b_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="A_B_CITY",
                        help_text="Individual or business entity city",
                        max_length=30,
                    ),
                ),
                (
                    "a_b_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="A_B_NAME",
                        help_text="Name of individual or business entity",
                        max_length=200,
                    ),
                ),
                (
                    "a_b_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="A_B_ST",
                        help_text="Individual or business entity state",
                        max_length=2,
                    ),
                ),
                (
                    "a_b_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="A_B_ZIP4",
                        help_text="Individual or business entity ZIP Code.",
                        max_length=10,
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "auth_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="AUTH_CITY",
                        help_text="Authorized lobbying firm business address city",
                        max_length=30,
                    ),
                ),
                (
                    "auth_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="AUTH_NAME",
                        help_text="Authorized lobbying firm business name. Applies to Form 602.",
                        max_length=200,
                    ),
                ),
                (
                    "auth_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="AUTH_ST",
                        help_text="Authorized lobbying firm business address state",
                        max_length=2,
                    ),
                ),
                (
                    "auth_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="AUTH_ZIP4",
                        help_text="Authorized lobbying firm business address ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "bus_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BUS_CB",
                        help_text="Business included activity checkbox",
                        max_length=1,
                    ),
                ),
                (
                    "bus_city",
                    calaccess_raw.fields.CharField(
                        db_column="BUS_CITY",
                        help_text="Filer business address city",
                        max_length=30,
                    ),
                ),
                (
                    "bus_class",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("ENT", "Entertainment/Recreation"),
                            ("FIN", "Finance/Insurance"),
                            ("LOG", "Lodging/Restaurants"),
                            ("MAN", "Manufacturing/Industrial"),
                            ("MER", "Merchandise/Retail"),
                            ("OIL", "Oil and Gas"),
                            ("OTH", "Other"),
                            ("PRO", "Professional/Trade"),
                            ("REA", "Real Estate"),
                            ("TRN", "Transportation"),
                        ],
                        db_column="BUS_CLASS",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=70
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=82
                            ),
                        ],
                        help_text="Classifiction values of business related entities. This field is exclusive of the business class field. One these must be populated but not both.",
                        max_length=3,
                    ),
                ),
                (
                    "bus_descr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BUS_DESCR",
                        help_text="Description of business classification if coded as other",
                        max_length=100,
                    ),
                ),
                (
                    "bus_email",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BUS_EMAIL",
                        help_text="Filer business address email",
                        max_length=60,
                    ),
                ),
                (
                    "bus_fax",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BUS_FAX",
                        help_text="Filer business address fax number",
                        max_length=20,
                    ),
                ),
                (
                    "bus_phon",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BUS_PHON",
                        help_text="Filer business address phone number",
                        max_length=20,
                    ),
                ),
                (
                    "bus_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BUS_ST",
                        help_text="Filer business address state",
                        max_length=2,
                    ),
                ),
                (
                    "bus_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BUS_ZIP4",
                        help_text="Filer business address ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "c_less50",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="C_LESS50",
                        help_text="Industry associations with fewer than 50 members check this box",
                        max_length=1,
                    ),
                ),
                (
                    "c_more50",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="C_MORE50",
                        help_text="Industry associations with more than 50 check this box.",
                        max_length=1,
                    ),
                ),
                (
                    "complet_dt",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="COMPLET_DT",
                        help_text="Ethics orientation class completion date. Applies to Form 604. As filed by the lobbyist.",
                        null=True,
                    ),
                ),
                (
                    "descrip_1",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="DESCRIP_1",
                        help_text="Description of business activity, industry or other",
                        max_length=300,
                    ),
                ),
                (
                    "descrip_2",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="DESCRIP_2",
                        help_text="Description of specific or other lobbying interest",
                        max_length=300,
                    ),
                ),
                (
                    "eff_date",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="EFF_DATE",
                        help_text="Effective date of authoarization or termination",
                        null=True,
                    ),
                ),
                (
                    "entity_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("BUS", "Unknown"),
                            ("FRM", b"Lobbying Firm"),
                            ("LBY", b"Lobbyist (an individual)"),
                            ("LCO", b"Lobbying Coalition"),
                            ("LEM", b"Lobbying Employer"),
                        ],
                        db_column="ENTITY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=82
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=68
                            ),
                        ],
                        help_text="Entity Code describing the filer",
                        max_length=3,
                        verbose_name="entity code",
                    ),
                ),
                (
                    "filer_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_ID",
                        db_index=True,
                        help_text="Filer's unique identification number",
                        max_length=9,
                        verbose_name="filer ID",
                    ),
                ),
                (
                    "filer_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_NAMF",
                        help_text="Filer first name",
                        max_length=45,
                    ),
                ),
                (
                    "filer_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_NAML",
                        help_text="Filer last name",
                        max_length=200,
                    ),
                ),
                (
                    "filer_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_NAMS",
                        help_text="Filer suffix",
                        max_length=10,
                    ),
                ),
                (
                    "filer_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_NAMT",
                        help_text="Filer title or prefix",
                        max_length=10,
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        null=True,
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "firm_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FIRM_NAME",
                        help_text="Name of the lobbyist employer or firm. Applies to Forms 604, 606, 607.",
                        max_length=200,
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"F601",
                                b"Form 601: Lobbying Firm Registration Statement",
                            ),
                            (
                                b"F602",
                                b"Form 602: Lobbying Firm Activity Authorization",
                            ),
                            (
                                b"F603",
                                b"Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                            ),
                            (b"F604", b"Form 604: Lobbyist Certification Statement"),
                            (b"F606", b"Form 606: Notice of Termination"),
                            (b"F607", b"Form 607: Notice of Withdrawal"),
                        ],
                        db_column="FORM_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=68
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=82
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=4,
                    ),
                ),
                (
                    "ind_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="IND_CB",
                        help_text="Individual checkbox",
                        max_length=1,
                    ),
                ),
                (
                    "ind_class",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("AGR", "Agriculture"),
                            ("EDU", "Education"),
                            ("GOV", "Government"),
                            ("HEA", "Health"),
                            ("LAB", "Labor Unions"),
                            ("LEG", "Legal"),
                            ("OTH", "Other"),
                            ("POL", "Political Organizations"),
                            ("PUB", "Public Employees"),
                            ("UTL", "Utilities"),
                        ],
                        db_column="IND_CLASS",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=85
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=70
                            ),
                        ],
                        help_text="Classification values to category industry related entities. This field is exclusive of the business class field. One these must be populated but not both.",
                        max_length=3,
                    ),
                ),
                (
                    "ind_descr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="IND_DESCR",
                        help_text="Description of industry classification if coded as other",
                        max_length=100,
                    ),
                ),
                (
                    "influen_yn",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("Y", "Yes"),
                            ("y", "Yes"),
                            ("N", "No"),
                            ("n", "No"),
                            ("X", "Yes"),
                        ],
                        db_column="INFLUEN_YN",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=86
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=71
                            ),
                        ],
                        help_text="Attempt to influence state legislation",
                        max_length=1,
                        null=True,
                    ),
                ),
                (
                    "l_firm_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="L_FIRM_CB",
                        help_text="'Lobbying firm within the ... ' checkbox. Applies to Form 607.",
                        max_length=1,
                    ),
                ),
                (
                    "lby_604_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LBY_604_CB",
                        help_text="'Lobbying Agency in this 604 statement' checkbox. Applies to Form 604.",
                        max_length=1,
                    ),
                ),
                (
                    "lby_reg_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LBY_REG_CB",
                        help_text="'Lobbying Agency in form 601/603 registration statement' checkbox. Applies to Form 604.",
                        max_length=1,
                    ),
                ),
                (
                    "lobby_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LOBBY_CB",
                        help_text="'Lobbying within the meaning...' checkbox. Applies to Form 607.",
                        max_length=1,
                    ),
                ),
                (
                    "lobby_int",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LOBBY_INT",
                        help_text="Description of Part III lobbying interests. Applies to Form 603",
                        max_length=300,
                    ),
                ),
                (
                    "ls_beg_yr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LS_BEG_YR",
                        help_text="Year legislative session begins",
                        max_length=5,
                        null=True,
                    ),
                ),
                (
                    "ls_end_yr",
                    calaccess_raw.fields.CharField(
                        db_column="LS_END_YR",
                        help_text="Year legislative sessions ends",
                        max_length=5,
                    ),
                ),
                (
                    "mail_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAIL_CITY",
                        help_text="Filer mailing address city",
                        max_length=30,
                    ),
                ),
                (
                    "mail_phon",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAIL_PHON",
                        help_text="Filer mailing address phone number",
                        max_length=20,
                    ),
                ),
                (
                    "mail_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAIL_ST",
                        help_text="Filer mailing address state",
                        max_length=2,
                    ),
                ),
                (
                    "mail_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAIL_ZIP4",
                        help_text="Filer mailing address ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "newcert_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="NEWCERT_CB",
                        help_text="Will require a new certification checkbox. Applies to Form 604.",
                        max_length=1,
                    ),
                ),
                (
                    "oth_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="OTH_CB",
                        help_text="Other checkbox",
                        max_length=1,
                    ),
                ),
                (
                    "prn_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PRN_NAMF",
                        help_text="Signer first name",
                        max_length=45,
                    ),
                ),
                (
                    "prn_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PRN_NAML",
                        help_text="Signer last name",
                        max_length=200,
                    ),
                ),
                (
                    "prn_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PRN_NAMS",
                        help_text="Signer suffix",
                        max_length=10,
                    ),
                ),
                (
                    "prn_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PRN_NAMT",
                        help_text="Signer title or prefix",
                        max_length=10,
                    ),
                ),
                (
                    "qual_date",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="QUAL_DATE",
                        help_text="Date qualified. Applies to forms 601 and 603. Only occurs once in lobbying filings.",
                        null=True,
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("CVR", "CVR")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=68
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=82
                            ),
                        ],
                        help_text="Record Type Value: CVR",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "rencert_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RENCERT_CB",
                        help_text="Will take a renewel certification checkbox. Applies to Form 604.",
                        max_length=1,
                    ),
                ),
                (
                    "report_num",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="REPORT_NUM",
                        help_text="Amendment number as reported by the filer. 000 is the original. 001-999 are amendments.",
                        max_length=3,
                    ),
                ),
                (
                    "rpt_date",
                    calaccess_raw.fields.DateField(
                        db_column="RPT_DATE",
                        help_text="Date this report or amendment is filed, as reported by the filer",
                        null=True,
                    ),
                ),
                (
                    "sender_id",
                    calaccess_raw.fields.CharField(
                        db_column="SENDER_ID",
                        help_text="Identification number of the lobbyist entity submitting this report. This is equal to the filer ID if the filer is the submitting the report and the firm or employer if they are submitting the report.",
                        max_length=9,
                    ),
                ),
                (
                    "sig_date",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="SIG_DATE",
                        help_text="Date signed",
                        null=True,
                    ),
                ),
                (
                    "sig_loc",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SIG_LOC",
                        help_text="Signer city and state",
                        max_length=45,
                    ),
                ),
                (
                    "sig_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SIG_NAMF",
                        help_text="Signer first name",
                        max_length=45,
                    ),
                ),
                (
                    "sig_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SIG_NAML",
                        help_text="Signer last name",
                        max_length=200,
                    ),
                ),
                (
                    "sig_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SIG_NAMS",
                        help_text="Signer suffix",
                        max_length=10,
                    ),
                ),
                (
                    "sig_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SIG_NAMT",
                        help_text="Signer title or prefix",
                        max_length=10,
                    ),
                ),
                (
                    "sig_title",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SIG_TITLE",
                        help_text="Title of signer",
                        max_length=45,
                    ),
                ),
                (
                    "st_agency",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ST_AGENCY",
                        help_text="List of identified state agencies. Applies to Form 604.",
                        max_length=100,
                    ),
                ),
                (
                    "st_leg_yn",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("Y", "Yes"),
                            ("y", "Yes"),
                            ("N", "No"),
                            ("n", "No"),
                            ("X", "Yes"),
                            ("x", "Yes"),
                        ],
                        db_column="ST_LEG_YN",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=86
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=71
                            ),
                        ],
                        help_text="Will lobby state legislature checkbox. Applies to Form 604.",
                        max_length=1,
                    ),
                ),
                (
                    "stmt_firm",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="STMT_FIRM",
                        help_text="Lobby firm named in 'Statement of Responsible Officer'This field only applies to Form 601.",
                        max_length=90,
                    ),
                ),
                (
                    "trade_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRADE_CB",
                        help_text="Industry, trade or professional checkbox",
                        max_length=1,
                        null=True,
                    ),
                ),
            ],
            options={
                "db_table": "CVR_REGISTRATION_CD",
                "verbose_name": "CVR_REGISTRATION_CD",
                "verbose_name_plural": "CVR_REGISTRATION_CD",
            },
        ),
        migrations.CreateModel(
            name="CvrSoCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "acct_opendt",
                    calaccess_raw.fields.DateField(
                        db_column="ACCT_OPENDT",
                        help_text="Date Account Opened",
                        null=True,
                        verbose_name="account opened datetime",
                    ),
                ),
                (
                    "actvty_lvl",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("CI", "City"),
                            ("CO", "County"),
                            ("ST", "State"),
                            ("St", "State"),
                            ("st", "State"),
                        ],
                        db_column="ACTVTY_LVL",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=30
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=47
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=60
                            ),
                        ],
                        help_text="Organization's level of activity",
                        max_length=2,
                        verbose_name="activity level",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "bank_adr1",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BANK_ADR1",
                        help_text="Street 1 of Financial Institution",
                        max_length=55,
                        verbose_name="bank address 1",
                    ),
                ),
                (
                    "bank_adr2",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BANK_ADR2",
                        help_text="Street 2 of Financial Institution",
                        max_length=55,
                        verbose_name="bank address 2",
                    ),
                ),
                (
                    "bank_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BANK_CITY",
                        help_text="City of Financial Institution",
                        max_length=30,
                        verbose_name="bank city",
                    ),
                ),
                (
                    "bank_nam",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BANK_NAM",
                        help_text="Name of Financial Institution",
                        max_length=200,
                        verbose_name="bank name",
                    ),
                ),
                (
                    "bank_phon",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BANK_PHON",
                        help_text="Phone of Financial Institution",
                        max_length=20,
                        verbose_name="bank phone",
                    ),
                ),
                (
                    "bank_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BANK_ST",
                        help_text="State of Financial Institution",
                        max_length=2,
                        verbose_name="bank street",
                    ),
                ),
                (
                    "bank_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BANK_ZIP4",
                        help_text="ZIP+4 of Financial Institution",
                        max_length=10,
                        verbose_name="bank zip4",
                    ),
                ),
                (
                    "brdbase_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BRDBASE_CB",
                        help_text="Broad Based Committee Check-box",
                        max_length=1,
                        verbose_name="broad based committee check-box",
                    ),
                ),
                (
                    "city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CITY",
                        help_text="City of Org / Committee / Candidate or Office holder",
                        max_length=30,
                        verbose_name="city",
                    ),
                ),
                (
                    "cmte_email",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CMTE_EMAIL",
                        help_text="Optional Committee EMAIL address",
                        max_length=60,
                        verbose_name="committee email",
                    ),
                ),
                (
                    "cmte_fax",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CMTE_FAX",
                        help_text="Optional Committee FAX number",
                        max_length=20,
                        verbose_name="committee fax",
                    ),
                ),
                (
                    "com82013id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="COM82013ID",
                        help_text="ID of 82013 Committee (if Com82013Nm is a RCP cmtte)",
                        max_length=9,
                        verbose_name="committee 82013 id",
                    ),
                ),
                (
                    "com82013nm",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="COM82013NM",
                        help_text="Name of 82013 Committee (F400; when Com82013YN=Y)",
                        max_length=200,
                        verbose_name="committee 82013 name",
                    ),
                ),
                (
                    "com82013yn",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="COM82013YN",
                        help_text='Is this SMO a 82013 "Committee"? (Yes/No) (F400)',
                        max_length=1,
                        verbose_name="committee 82013 yes/no",
                    ),
                ),
                (
                    "control_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CONTROL_CB",
                        help_text="Controlled Committee Check-box",
                        max_length=1,
                        verbose_name="controlled checkbox",
                    ),
                ),
                (
                    "county_act",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="COUNTY_ACT",
                        help_text="County where Active (F410)",
                        max_length=20,
                        verbose_name="county active",
                    ),
                ),
                (
                    "county_res",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="COUNTY_RES",
                        help_text="County of Domicile, Residence, or Location",
                        max_length=20,
                        verbose_name="county residence",
                    ),
                ),
                (
                    "entity_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("BMC", b"Ballot measure committee"),
                            ("CAO", b"Candidate/officeholder"),
                            ("COM", b"Committee"),
                            ("CTL", b"Controlled committee"),
                            ("RCP", b"Recipient committee"),
                            ("SMO", b"Slate-mailer organization"),
                        ],
                        db_column="ENTITY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=9,
                                id=b"2712033-Cal-Format-1-05-02",
                                start_page=8,
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=11, id=b"2712034-Cal-Format-201", start_page=9
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=46
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=59
                            ),
                        ],
                        help_text="Entity Code of the Filer. Values: SMO - Slate Mailer Organization (F400,402) [COM|RCP] - Recipient Committee (F410)",
                        max_length=3,
                        verbose_name="Entity code",
                    ),
                ),
                (
                    "filer_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_ID",
                        db_index=True,
                        help_text="Filer's unique identification number",
                        max_length=9,
                        verbose_name="filer ID",
                    ),
                ),
                (
                    "filer_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_NAMF",
                        help_text="Filer first name",
                        max_length=45,
                        verbose_name="filer first name",
                    ),
                ),
                (
                    "filer_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_NAML",
                        help_text="Filer last name",
                        max_length=200,
                        verbose_name="filer last name",
                    ),
                ),
                (
                    "filer_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_NAMS",
                        help_text="Filer name suffix",
                        max_length=10,
                        verbose_name="filer name suffix",
                    ),
                ),
                (
                    "filer_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_NAMT",
                        help_text="Filer name title",
                        max_length=10,
                        verbose_name="filer name title",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing id",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                "F400",
                                b"Form 400: Statement of Organization (Slate Mailer Organization)",
                            ),
                            (
                                "F402",
                                b"Form 402: Statement of Termination (Slate Mailer Organization)",
                            ),
                            (
                                "F410",
                                b"Form 410: Statement of Organization Recipient Committee",
                            ),
                        ],
                        db_column="FORM_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=46
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=59
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=4,
                        verbose_name="form type",
                    ),
                ),
                (
                    "genpurp_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="GENPURP_CB",
                        help_text="General Purpose Committee Check-box",
                        max_length=1,
                        verbose_name="general purpose checkbox",
                    ),
                ),
                (
                    "gpc_descr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="GPC_DESCR",
                        help_text="Brief description of Activity of GPC",
                        max_length=300,
                        verbose_name="general purpose committee description",
                    ),
                ),
                (
                    "mail_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAIL_CITY",
                        help_text="Mailing Address of Filing Committee - City",
                        max_length=30,
                        verbose_name="mail city",
                    ),
                ),
                (
                    "mail_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAIL_ST",
                        help_text="Mailing Address of Filing Committee - State",
                        max_length=2,
                        verbose_name="mail street",
                    ),
                ),
                (
                    "mail_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MAIL_ZIP4",
                        help_text="Mailing Address of Filing Committee - ZIP+4",
                        max_length=10,
                        verbose_name="mail zip4",
                    ),
                ),
                (
                    "phone",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PHONE",
                        help_text="Phone Number of Org / Committee / Candidate or Office holder",
                        max_length=20,
                        verbose_name="phone",
                    ),
                ),
                (
                    "primfc_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PRIMFC_CB",
                        help_text="Primarily Formed Committee Check-box",
                        max_length=1,
                        verbose_name="primarily formed committee check-box",
                    ),
                ),
                (
                    "qualfy_dt",
                    calaccess_raw.fields.DateField(
                        db_column="QUALFY_DT",
                        help_text="Date qualified as an organization",
                        null=True,
                        verbose_name="qualified datetime",
                    ),
                ),
                (
                    "qual_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="QUAL_CB",
                        help_text="Qualified Committee check-box (Req. if SMO)",
                        max_length=1,
                        verbose_name="qualified checkbox",
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                "CVR",
                                "Cover Page for Stmt of Organization / Slate Mailer Org, Stmt of Termination / Slate Mailer Org or Stmt of Organization / Recipient Committee",
                            )
                        ],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=28
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=46
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=59
                            ),
                        ],
                        help_text="Record Type Value: CVR",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "report_num",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="REPORT_NUM",
                        help_text="Report Number - Values: 000 - Original Report 001 thru 999 - Amended Rpt #1-#999",
                        max_length=3,
                        verbose_name="report number",
                    ),
                ),
                (
                    "rpt_date",
                    calaccess_raw.fields.DateField(
                        db_column="RPT_DATE",
                        help_text="Date this report is filed",
                        null=True,
                        verbose_name="report date",
                    ),
                ),
                (
                    "smcont_qualdt",
                    calaccess_raw.fields.DateField(
                        db_column="SMCONT_QUALDT",
                        help_text="Date Small Contributor Committee Qualified",
                        null=True,
                        verbose_name="small contributor qualified datetime",
                    ),
                ),
                (
                    "sponsor_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SPONSOR_CB",
                        help_text="Sponsored Committee Check-box",
                        max_length=1,
                        verbose_name="sponsored checkbox",
                    ),
                ),
                (
                    "st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ST",
                        help_text="State of Org / Committee / Candidate or Office holder",
                        max_length=2,
                        verbose_name="street",
                    ),
                ),
                (
                    "surplusdsp",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SURPLUSDSP",
                        help_text="Disposition of Surplus Funds",
                        max_length=90,
                        verbose_name="surplus disposition",
                    ),
                ),
                (
                    "term_date",
                    calaccess_raw.fields.DateField(
                        db_column="TERM_DATE",
                        help_text="Termination Effective Date (Req. if F402)",
                        null=True,
                        verbose_name="termination date",
                    ),
                ),
                (
                    "tres_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_CITY",
                        help_text="Treasurer's city",
                        max_length=30,
                        verbose_name="treasurer city",
                    ),
                ),
                (
                    "tres_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAMF",
                        help_text="Treasurer's first name",
                        max_length=45,
                        verbose_name="treasurer first name",
                    ),
                ),
                (
                    "tres_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAML",
                        help_text="Treasurer's last name",
                        max_length=200,
                        verbose_name="treasurer last name",
                    ),
                ),
                (
                    "tres_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAMS",
                        help_text="Treasurer's name suffix",
                        max_length=10,
                        verbose_name="treasurer name suffix",
                    ),
                ),
                (
                    "tres_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAMT",
                        help_text="Treasurer's name title",
                        max_length=10,
                        verbose_name="treasurer name title",
                    ),
                ),
                (
                    "tres_phon",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_PHON",
                        help_text="Treasurer's phone number",
                        max_length=20,
                        verbose_name="treasurer phone number",
                    ),
                ),
                (
                    "tres_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_ST",
                        help_text="Treasurer's street",
                        max_length=2,
                        verbose_name="treasurer street",
                    ),
                ),
                (
                    "tres_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_ZIP4",
                        help_text="Treasurer's ZIP Code",
                        max_length=10,
                        verbose_name="treasurer zip code",
                    ),
                ),
                (
                    "zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ZIP4",
                        help_text="ZIP+4 for Org / Committee / Candidate or Office holder",
                        max_length=10,
                        verbose_name="zip4",
                    ),
                ),
            ],
            options={
                "db_table": "CVR_SO_CD",
                "verbose_name": "CVR_SO_CD",
                "verbose_name_plural": "CVR_SO_CD",
            },
        ),
        migrations.CreateModel(
            name="DebtCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "amt_incur",
                    calaccess_raw.fields.DecimalField(
                        db_column="AMT_INCUR",
                        decimal_places=2,
                        help_text="Amount incurred this period",
                        max_digits=14,
                    ),
                ),
                (
                    "amt_paid",
                    calaccess_raw.fields.DecimalField(
                        db_column="AMT_PAID",
                        decimal_places=2,
                        help_text="Amount paid this period.",
                        max_digits=14,
                    ),
                ),
                (
                    "bakref_tid",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAKREF_TID",
                        help_text="Back reference to a transaction identifier of a parent record.",
                        max_length=20,
                    ),
                ),
                (
                    "beg_bal",
                    calaccess_raw.fields.DecimalField(
                        db_column="BEG_BAL",
                        decimal_places=2,
                        help_text="Outstanding balance at beginning of period",
                        max_digits=14,
                    ),
                ),
                (
                    "cmte_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CMTE_ID",
                        help_text="Committee identification number",
                        max_length=9,
                    ),
                ),
                (
                    "end_bal",
                    calaccess_raw.fields.DecimalField(
                        db_column="END_BAL",
                        decimal_places=2,
                        help_text="Outstanding balance at close of this period",
                        max_digits=14,
                    ),
                ),
                (
                    "entity_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("BNM", b"Ballot measure's name/title"),
                            ("COM", b"Committee"),
                            ("IND", b"Individual"),
                            ("OTH", b"Other"),
                            ("PTY", b"Political Party"),
                            ("RCP", b"Recipient committee"),
                            ("SCC", b"Small Contributor Committee"),
                        ],
                        db_column="ENTITY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=9,
                                id=b"2712033-Cal-Format-1-05-02",
                                start_page=8,
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=11, id=b"2712034-Cal-Format-201", start_page=9
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=33
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=45
                            ),
                        ],
                        help_text="Entity code describing the payee",
                        max_length=3,
                        verbose_name="entity code",
                    ),
                ),
                (
                    "expn_code",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"CMP", b"campaign paraphernalia/miscellaneous"),
                            (b"CNS", b"campaign consultants"),
                            (b"CTB", b"contribution (if nonmonetary, explain)*"),
                            (b"CVC", b"civic donations"),
                            (b"FIL", b"candidate filing/ballot feeds"),
                            (b"FND", b"fundraising events"),
                            (b"IKD", b"In-kind contribution (nonmonetary)"),
                            (
                                b"IND",
                                b"independent expenditure supporting/opposing others (explain)*",
                            ),
                            (b"LEG", b"legal defense"),
                            (b"LIT", b"campaign literature and mailings"),
                            (b"LON", b"loan"),
                            (b"MBR", b"member communications"),
                            (b"MON", b"monetary contribution"),
                            (b"MTG", b"meetings and appearances"),
                            (b"OFC", b"office expenses"),
                            (b"PET", b"petition circulating"),
                            (b"PHO", b"phone banks"),
                            (b"POL", b"polling and survey research"),
                            (b"POS", b"postage, delivery and messenger services"),
                            (b"PRO", b"professional services (legal, accounting)"),
                            (b"PRT", b"print ads"),
                            (b"RAD", b"radio airtime and production costs"),
                            (b"RFD", b"returned contributions"),
                            (b"SAL", b"campaign workers salaries"),
                            (b"TEL", b"T.V. or cable airtime and production costs"),
                            (b"TRC", b"candidate travel, lodging and meals (explain)"),
                            (
                                b"TRS",
                                b"staff/spouse travel, lodging and meals (explain)",
                            ),
                            (
                                b"TSF",
                                b"transfer between committees of the same candidate/sponsor",
                            ),
                            (b"VOT", b"voter registration"),
                            (
                                b"WEB",
                                b"information technology costs (internet, e-mail)",
                            ),
                            ("Fnd", b"fundraising events"),
                            ("ofc", b"office expenses"),
                            ("'CN", b"campaign consultants"),
                            ("*", "Unknown"),
                            ("AIR", "Unknown"),
                            ("BUS", "Unknown"),
                            ("C", "Unknown"),
                            ("CAM", "Unknown"),
                            ("CC", "Unknown"),
                            ("COM", "Unknown"),
                            ("CON", "Unknown"),
                            ("CSN", "Unknown"),
                            ("DEP", "Unknown"),
                            ("EVE", "Unknown"),
                            ("F", "Unknown"),
                            ("FED", "Unknown"),
                            ("fns", "Unknown"),
                            ("G", "Unknown"),
                            ("GGG", "Unknown"),
                            ("HOT", "Unknown"),
                            ("L", "Unknown"),
                            ("LDF", "Unknown"),
                            ("MEE", "Unknown"),
                            ("N", "Unknown"),
                            ("O", "Unknown"),
                            ("OTH", "Unknown"),
                            ("P", "Unknown"),
                            ("PEN", "Unknown"),
                            ("S", "Unknown"),
                            ("SPE", "Unknown"),
                            ("STA", "Unknown"),
                            ("T", "Unknown"),
                            ("TAX", "Unknown"),
                            ("TRA", "Unknown"),
                            ("V", "Unknown"),
                            ("X", "Unknown"),
                        ],
                        db_column="EXPN_CODE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id=b"2712033-Cal-Format-1-05-02", start_page=11
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=14, id=b"2712034-Cal-Format-201", start_page=13
                            ),
                        ],
                        help_text="Expense Code",
                        max_length=3,
                        verbose_name="expense code",
                    ),
                ),
                (
                    "expn_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EXPN_DSCR",
                        help_text="Purpose of expense and/or description/explanation",
                        max_length=400,
                        verbose_name="expense description",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number of the parent filing",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"F",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule F, Accrued Expenses (Unpaid Bills)",
                            )
                        ],
                        db_column="FORM_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=33
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=45
                            ),
                        ],
                        help_text="Schedule Name/ID: (F - Sched F / Accrued Expenses)",
                        max_length=1,
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Record line item number",
                    ),
                ),
                (
                    "memo_code",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_CODE",
                        help_text="Memo amount flag",
                        max_length=1,
                    ),
                ),
                (
                    "memo_refno",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_REFNO",
                        help_text="Reference to text contained in a TEXT record.",
                        max_length=20,
                    ),
                ),
                (
                    "payee_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_CITY",
                        help_text="First line of the payee's street address",
                        max_length=30,
                    ),
                ),
                (
                    "payee_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_NAMF",
                        help_text="Payee's first name if the payee is an individual",
                        max_length=45,
                    ),
                ),
                (
                    "payee_naml",
                    calaccess_raw.fields.CharField(
                        db_column="PAYEE_NAML",
                        help_text="Payee's business name or last name if the payee is an individual.",
                        max_length=200,
                    ),
                ),
                (
                    "payee_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_NAMS",
                        help_text="Payee's name suffix if the payee is an individual",
                        max_length=10,
                    ),
                ),
                (
                    "payee_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_NAMT",
                        help_text="Payee's prefix or title if the payee is an individual",
                        max_length=100,
                    ),
                ),
                (
                    "payee_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_ST",
                        help_text="Payee's state",
                        max_length=2,
                    ),
                ),
                (
                    "payee_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_ZIP4",
                        help_text="Payee's ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("DEBT", "DEBT")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=34,
                                id="2712033-Cal-Format-1-05-02",
                                start_page=33,
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=46, id="2712034-Cal-Format-201", start_page=45
                            ),
                        ],
                        help_text="Record type value: DEBT",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "tran_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRAN_ID",
                        help_text="Transaction identifier - permanent value unique to this item",
                        max_length=20,
                        verbose_name="transaction ID",
                    ),
                ),
                (
                    "tres_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_CITY",
                        help_text="City portion of the treasurer or responsible officer's street address",
                        max_length=30,
                    ),
                ),
                (
                    "tres_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAMF",
                        help_text="Treasurer or responsible officer's first name",
                        max_length=45,
                    ),
                ),
                (
                    "tres_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAML",
                        help_text="Treasurer or responsible officer's last name",
                        max_length=200,
                    ),
                ),
                (
                    "tres_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAMS",
                        help_text="Treasurer or responsible officer's suffix",
                        max_length=10,
                    ),
                ),
                (
                    "tres_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAMT",
                        help_text="Treasurer or responsible officer's prefix or title",
                        max_length=100,
                    ),
                ),
                (
                    "tres_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_ST",
                        help_text="State portion of the treasurer or responsible officer's address",
                        max_length=2,
                    ),
                ),
                (
                    "tres_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_ZIP4",
                        help_text="ZIP Code portion of the treasurer or responsible officer's address",
                        max_length=10,
                    ),
                ),
                (
                    "xref_match",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="XREF_MATCH",
                        help_text='Related item on other schedule has same transaction identifier. /"X/" indicates this condition is true',
                        max_length=1,
                    ),
                ),
                (
                    "xref_schnm",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="XREF_SCHNM",
                        help_text="Related record is included on Schedule C.",
                        max_length=2,
                    ),
                ),
            ],
            options={
                "db_table": "DEBT_CD",
                "verbose_name": "DEBT_CD",
                "verbose_name_plural": "DEBT_CD",
            },
        ),
        migrations.CreateModel(
            name="EfsFilingLogCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filing_date",
                    calaccess_raw.fields.DateField(
                        db_column="FILING_DATE", help_text="Date of filing", null=True
                    ),
                ),
                (
                    "filingstatus",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILINGSTATUS",
                        help_text="Status of filing. This field is described in the docs as beingVARCHAR. However, its distinct values are 0, 1, 2 and 7.",
                    ),
                ),
                (
                    "vendor",
                    calaccess_raw.fields.CharField(
                        db_column="VENDOR",
                        help_text="Software vendor who submitted the electronic filing",
                        max_length=250,
                    ),
                ),
                (
                    "filer_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_ID",
                        db_index=True,
                        help_text="Filer's unique identification number",
                        max_length=250,
                        verbose_name="filer ID",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"F400",
                                b"Form 400: Statement of Organization (Slate Mailer Organization)",
                            ),
                            (
                                b"F401",
                                b"Form 401: Slate Mailer Organization Campaign Statement",
                            ),
                            (
                                b"F402",
                                b"Form 402: Statement of Termination (Slate Mailer Organization)",
                            ),
                            (
                                b"F410",
                                b"Form 410: Statement of Organization Recipient Committee",
                            ),
                            (
                                b"F425",
                                b"Form 425: Semi-Annual Statement of no Activity",
                            ),
                            (
                                b"F450",
                                b"Form 450: Recipient Committee Campaign Disclosure Statement - Short Form",
                            ),
                            (
                                b"F460",
                                b"Form 460: Recipient Committee Campaign Statement",
                            ),
                            (
                                b"F461",
                                b"Form 461: Independent Expenditure Committee & Major Donor Committee Campaign Statement",
                            ),
                            (
                                b"F465",
                                b"Form 465: Supplemental Independent Expenditure Report",
                            ),
                            (b"F496", b"Form 496: Late Independent Expenditure Report"),
                            (b"F497", b"Form 497: Late Contribution Report"),
                            (b"F498", b"Form 498: Slate Mailer Late Payment Report"),
                            (
                                b"F601",
                                b"Form 601: Lobbying Firm Registration Statement",
                            ),
                            (
                                b"F602",
                                b"Form 602: Lobbying Firm Activity Authorization",
                            ),
                            (
                                b"F603",
                                b"Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                            ),
                            (b"F604", b"Form 604: Lobbyist Certification Statement"),
                            (b"F606", b"Form 606: Notice of Termination"),
                            (b"F607", b"Form 607: Notice of Withdrawal"),
                            (b"F615", b"Form 615: Lobbyist Report"),
                            (b"F625", b"Form 625: Report of Lobbying Firm"),
                            (
                                b"F635",
                                b"Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                            ),
                            (
                                b"F645",
                                b"Form 645: Report of Person Spending $5,000 or More",
                            ),
                            ("BADFORMAT 253", "Unknown"),
                            ("form", "Unknown"),
                        ],
                        db_column="FORM_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=8, id="2711624-Overview", start_page=4
                            )
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=250,
                        verbose_name="form type",
                    ),
                ),
                (
                    "error_no",
                    calaccess_raw.fields.CharField(
                        db_column="ERROR_NO",
                        help_text='Most records have a value of "ACCEPTED". Other records include "ERROR"or "BADFORMAT" and a three-digit number.',
                        max_length=250,
                    ),
                ),
            ],
            options={
                "db_table": "EFS_FILING_LOG_CD",
                "verbose_name": "EFS_FILING_LOG_CD",
                "verbose_name_plural": "EFS_FILING_LOG_CD",
            },
        ),
        migrations.CreateModel(
            name="ExpnCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "agent_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="AGENT_NAMF",
                        help_text="Agent of Ind. Contractor's First name",
                        max_length=45,
                    ),
                ),
                (
                    "agent_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="AGENT_NAML",
                        help_text="Agent of Ind. Contractor's Last name (Sched G)",
                        max_length=200,
                    ),
                ),
                (
                    "agent_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="AGENT_NAMS",
                        help_text="Agent of Ind. Contractor's Suffix",
                        max_length=10,
                    ),
                ),
                (
                    "agent_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="AGENT_NAMT",
                        help_text="Agent of Ind. Contractor's Prefix or Title",
                        max_length=10,
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "amount",
                    calaccess_raw.fields.DecimalField(
                        db_column="AMOUNT",
                        decimal_places=2,
                        help_text="Amount of Payment",
                        max_digits=14,
                    ),
                ),
                (
                    "bakref_tid",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAKREF_TID",
                        help_text="Back Reference to a Tran_ID of a 'parent' record",
                        max_length=20,
                    ),
                ),
                (
                    "bal_juris",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_JURIS",
                        help_text="Jurisdiction",
                        max_length=40,
                    ),
                ),
                (
                    "bal_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_NAME",
                        help_text="Ballot Measure Name",
                        max_length=200,
                    ),
                ),
                (
                    "bal_num",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_NUM",
                        help_text="Ballot Number or Letter",
                        max_length=7,
                    ),
                ),
                (
                    "cand_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMF",
                        help_text="Candidate's First name",
                        max_length=45,
                    ),
                ),
                (
                    "cand_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAML",
                        help_text="Candidate's Last name",
                        max_length=200,
                    ),
                ),
                (
                    "cand_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMS",
                        help_text="Candidate's Suffix",
                        max_length=10,
                    ),
                ),
                (
                    "cand_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMT",
                        help_text="Candidate's Prefix or Title",
                        max_length=10,
                    ),
                ),
                (
                    "cmte_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CMTE_ID",
                        help_text="Committee ID (If [COM|RCP] & no ID#, Treas info Req.)",
                        max_length=9,
                    ),
                ),
                (
                    "cum_oth",
                    calaccess_raw.fields.DecimalField(
                        blank=True,
                        db_column="CUM_OTH",
                        decimal_places=2,
                        help_text="Cumulative / 'Other' (No Cumulative on Sched E & G)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "cum_ytd",
                    calaccess_raw.fields.DecimalField(
                        blank=True,
                        db_column="CUM_YTD",
                        decimal_places=2,
                        help_text="Cumulative / Year-to-date amount         (No Cumulative on Sched E & G)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "dist_no",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="DIST_NO",
                        help_text="Office District Number (Req. if Juris_Cd=[SEN|ASM|BOE]",
                        max_length=3,
                    ),
                ),
                (
                    "entity_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("COM", b"Committee"),
                            ("IND", b"Individual"),
                            ("RCP", b"Recipient committee"),
                            ("OTH", b"Other"),
                            ("PTY", b"Political Party"),
                            ("SCC", b"Small Contributor Committee"),
                            ("BNM", b"Ballot measure's name/title"),
                            ("CAO", b"Candidate/officeholder"),
                            ("MBR", b"Member of Associaton"),
                            ("OFF", b"Officer"),
                            ("0", "Unknown"),
                            ("PTH", "Unknown"),
                            ("RFD", "Unknown"),
                        ],
                        db_column="ENTITY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=9,
                                id=b"2712033-Cal-Format-1-05-02",
                                start_page=8,
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=11, id=b"2712034-Cal-Format-201", start_page=9
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=31
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=42
                            ),
                        ],
                        help_text="Entity Code describing payee",
                        max_length=3,
                        verbose_name="entity code",
                    ),
                ),
                (
                    "expn_chkno",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EXPN_CHKNO",
                        help_text="Check Number (Optional)",
                        max_length=20,
                    ),
                ),
                (
                    "expn_code",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"CMP", b"campaign paraphernalia/miscellaneous"),
                            (b"CNS", b"campaign consultants"),
                            (b"CTB", b"contribution (if nonmonetary, explain)*"),
                            (b"CVC", b"civic donations"),
                            (b"FIL", b"candidate filing/ballot feeds"),
                            (b"FND", b"fundraising events"),
                            (b"IKD", b"In-kind contribution (nonmonetary)"),
                            (
                                b"IND",
                                b"independent expenditure supporting/opposing others (explain)*",
                            ),
                            (b"LEG", b"legal defense"),
                            (b"LIT", b"campaign literature and mailings"),
                            (b"LON", b"loan"),
                            (b"MBR", b"member communications"),
                            (b"MON", b"monetary contribution"),
                            (b"MTG", b"meetings and appearances"),
                            (b"OFC", b"office expenses"),
                            (b"PET", b"petition circulating"),
                            (b"PHO", b"phone banks"),
                            (b"POL", b"polling and survey research"),
                            (b"POS", b"postage, delivery and messenger services"),
                            (b"PRO", b"professional services (legal, accounting)"),
                            (b"PRT", b"print ads"),
                            (b"RAD", b"radio airtime and production costs"),
                            (b"RFD", b"returned contributions"),
                            (b"SAL", b"campaign workers salaries"),
                            (b"TEL", b"T.V. or cable airtime and production costs"),
                            (b"TRC", b"candidate travel, lodging and meals (explain)"),
                            (
                                b"TRS",
                                b"staff/spouse travel, lodging and meals (explain)",
                            ),
                            (
                                b"TSF",
                                b"transfer between committees of the same candidate/sponsor",
                            ),
                            (b"VOT", b"voter registration"),
                            (
                                b"WEB",
                                b"information technology costs (internet, e-mail)",
                            ),
                            ("ctb", b"contribution (if nonmonetary, explain)*"),
                            ("ikd", b"In-kind contribution (nonmonetary)"),
                            ("Mon", b"monetary contribution"),
                            ("ofc", b"office expenses"),
                            ("OFc", b"office expenses"),
                            ("Ofc", b"office expenses"),
                            ("", "Unknown"),
                            ("*", "Unknown"),
                            ("0", "Unknown"),
                            ("001", "Unknown"),
                            ("011", "Unknown"),
                            ("200", "Unknown"),
                            ("401", "Unknown"),
                            ("ADV", "Unknown"),
                            ("ANN", "Unknown"),
                            ("APR", "Unknown"),
                            ("AUG", "Unknown"),
                            ("AUT", "Unknown"),
                            ("Ban", "Unknown"),
                            ("BAN", "Unknown"),
                            ("BOO", "Unknown"),
                            ("BOX", "Unknown"),
                            ("C", "Unknown"),
                            ("CAT", "Unknown"),
                            ("CC", "Unknown"),
                            ("CHE", "Unknown"),
                            ("CIV", "Unknown"),
                            ("CNT", "Unknown"),
                            ("CON", "Unknown"),
                            ("COP", "Unknown"),
                            ("CRE", "Unknown"),
                            ("CSN", "Unknown"),
                            ("CT", "Unknown"),
                            (",CT", "Unknown"),
                            (".CT", "Unknown"),
                            ("CTN", "Unknown"),
                            ("CVD", "Unknown"),
                            ("DAT", "Unknown"),
                            ("DEC", "Unknown"),
                            ("Dem", "Unknown"),
                            ("DIN", "Unknown"),
                            ("Don", "Unknown"),
                            ("DON", "Unknown"),
                            ("Ear", "Unknown"),
                            ("EIM", "Unknown"),
                            ("EMP", "Unknown"),
                            ("F", "Unknown"),
                            ("FAX", "Unknown"),
                            ("FDN", "Unknown"),
                            ("FED", "Unknown"),
                            ("FEE", "Unknown"),
                            ("FIN", "Unknown"),
                            ("Fun", "Unknown"),
                            ("FUN", "Unknown"),
                            ("G", "Unknown"),
                            ("GEN", "Unknown"),
                            ("GGG", "Unknown"),
                            ("GOT", "Unknown"),
                            ("IEs", "Unknown"),
                            ("IN-", "Unknown"),
                            ("Ina", "Unknown"),
                            ("INK", "Unknown"),
                            ("INS", "Unknown"),
                            ("ITE", "Unknown"),
                            ("JAN", "Unknown"),
                            ("JUL", "Unknown"),
                            ("JUN", "Unknown"),
                            ("KIC", "Unknown"),
                            ("L", "Unknown"),
                            ("LEV", "Unknown"),
                            ("Lit", "Unknown"),
                            ("LN#", "Unknown"),
                            ("LOG", "Unknown"),
                            ("M", "Unknown"),
                            ("MAI", "Unknown"),
                            ("Mar", "Unknown"),
                            ("MAR", "Unknown"),
                            ("MAY", "Unknown"),
                            ("MED", "Unknown"),
                            ("MEE", "Unknown"),
                            ("MGT", "Unknown"),
                            ("Mis", "Unknown"),
                            ("MRB", "Unknown"),
                            ("NGP", "Unknown"),
                            ("NON", "Unknown"),
                            ("NOT", "Unknown"),
                            ("NOV", "Unknown"),
                            ("O", "Unknown"),
                            ("OCT", "Unknown"),
                            (".OF", "Unknown"),
                            ("OFF", "Unknown"),
                            ("OPE", "Unknown"),
                            ("OTH", "Unknown"),
                            ("P", "Unknown"),
                            ("Pac", "Unknown"),
                            ("PAI", "Unknown"),
                            ("PAR", "Unknown"),
                            ("PAY", "Unknown"),
                            ("PEN", "Unknown"),
                            ("PMT", "Unknown"),
                            (".PO", "Unknown"),
                            ("Pos", "Unknown"),
                            ("PRE", "Unknown"),
                            ("PRI", "Unknown"),
                            ("PRP", "Unknown"),
                            ("R", "Unknown"),
                            (".Re", "Unknown"),
                            (".RE", "Unknown"),
                            ("REF", "Unknown"),
                            ("REI", "Unknown"),
                            ("RFP", "Unknown"),
                            ("S", "Unknown"),
                            ("S-A", "Unknown"),
                            ("SA", "Unknown"),
                            ("Sal", "Unknown"),
                            ("S C", "Unknown"),
                            ("S.C", "Unknown"),
                            ("SCU", "Unknown"),
                            ("SEE", "Unknown"),
                            ("SEN", "Unknown"),
                            ("SEP", "Unknown"),
                            ("S.M.", "Unknown"),
                            ("SOF", "Unknown"),
                            ("SWI", "Unknown"),
                            ("T", "Unknown"),
                            ("TAX", "Unknown"),
                            ("TB", "Unknown"),
                            ("TB,", "Unknown"),
                            ("TIC", "Unknown"),
                            ("Tor", "Unknown"),
                            ("TRA", "Unknown"),
                            ("TRF", "Unknown"),
                            ("TRV", "Unknown"),
                            ("UN", "Unknown"),
                            ("UTI", "Unknown"),
                            ("V", "Unknown"),
                            ("VEN", "Unknown"),
                            ("-VO", "Unknown"),
                            ("VOI", "Unknown"),
                            ("VOY", "Unknown"),
                            ("WI", "Unknown"),
                            ("x", "Unknown"),
                            ("X", "Unknown"),
                            ("S-6", "Unknown"),
                            ("S.M", "Unknown"),
                            ("S-4", "Unknown"),
                            ("SA:", "Unknown"),
                            ("100", "Unknown"),
                            ("RFN", "Unknown"),
                            ("REN", "Unknown"),
                            ("003", "Unknown"),
                            ("S-1", "Unknown"),
                            ("08", "Unknown"),
                        ],
                        db_column="EXPN_CODE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id=b"2712033-Cal-Format-1-05-02", start_page=11
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=14, id=b"2712034-Cal-Format-201", start_page=13
                            ),
                        ],
                        help_text="CTB & IND need explanation & listing on Sched D TRC & TRS require explanation",
                        max_length=3,
                        verbose_name="expense code",
                    ),
                ),
                (
                    "expn_date",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="EXPN_DATE",
                        help_text="Date of Expenditure (Note: Date not on Sched E & G)",
                        null=True,
                        verbose_name="expense date",
                    ),
                ),
                (
                    "expn_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EXPN_DSCR",
                        help_text="Purpose of expense and/or description/explanation",
                        max_length=400,
                        verbose_name="espense description",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"F450P5",
                                b"Form 450 (Recipient Committee Campaign Disclosure Statement - Short Form): Part 5, Payments Made",
                            ),
                            (
                                b"D",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule D, Summary of Expenditures Supporting / Opposing Other Candidates, Measures and Committees",
                            ),
                            (
                                b"E",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule E, Payments Made",
                            ),
                            (
                                b"G",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule G, Payments Made by an Agent or Independent Contractor (on Behalf of This Committee)",
                            ),
                            (
                                b"F461P5",
                                b"Form 461 (Independent Expenditure Committee & Major Donor Committee Campaign Statement): Part 5, Contributions (Including Loans, Forgiveness of Loans, and LoanGuarantees) and Expenditures Made",
                            ),
                            (
                                b"F465P3",
                                b"Form 465 (Supplemental Independent Expenditure Report): Part 3, Independent Expenditures Made",
                            ),
                            (
                                b"F900",
                                b"Form 900: Public employee's retirement board, candidate campaign statement",
                            ),
                        ],
                        db_column="FORM_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=31
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=42
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=6,
                    ),
                ),
                (
                    "g_from_e_f",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="G_FROM_E_F",
                        help_text="Back Reference from Sched G to Sched 'E' or 'F'?",
                        max_length=1,
                    ),
                ),
                (
                    "juris_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"ASM", b"Assembly District"),
                            (b"BOE", b"Board of Equalization District"),
                            (b"CIT", b"City"),
                            (b"CTY", b"County"),
                            (b"LOC", b"Local"),
                            (b"OTH", b"Other"),
                            (b"SEN", b"Senate District"),
                            (b"STW", b"Statewide"),
                            ("Cit", b"City"),
                            ("sen", b"Senate District"),
                            ("Sen", b"Senate District"),
                            ("stw", b"Statewide"),
                            ("APP", b"Statewide"),
                            ("ASR", b"County"),
                            ("ATT", b"Statewide"),
                            ("GOV", b"Statewide"),
                            ("LTG", b"Statewide"),
                            ("SOS", b"Statewide"),
                            ("SUP", b"Statewide"),
                            ("TRE", b"Statewide"),
                            ("BSU", b"County"),
                            ("CSU", b"County"),
                            ("ES", b"City"),
                            ("SM", b"City"),
                            ("BED", b"Other"),
                            ("CCB", b"Other"),
                            ("CCM", b"Other"),
                            ("PDR", b"Other"),
                            ("12", b"Senate District"),
                            ("4", b"Statewide"),
                            ("8", b"Statewide"),
                            ("27", b"Statewide"),
                            ("93", b"Statewide"),
                            ("98", b"Statewide"),
                            ("CLB", "Unknown"),
                            ("PER", "Unknown"),
                            ("Boa", b"Board of Equalization District"),
                            ("Sta", "Unknown"),
                            ("STA", "Unknown"),
                            ("CA", "Unknown"),
                            ("SAN", "Unknown"),
                            ("ES ", "Unknown"),
                            ("CON", "Unknown"),
                            ("LA", "Unknown"),
                            ("LBC", "Unknown"),
                            ("OR", "Unknown"),
                            ("SB", "Unknown"),
                            ("WES", "Unknown"),
                            ("BM", "Unknown"),
                            ("(Lo", "Unknown"),
                            ("(Ci", "Unknown"),
                            ("vty", "Unknown"),
                            ("OC", "Unknown"),
                            ("SM ", "Unknown"),
                            ("ASS", "Unknown"),
                            ("JR", "Unknown"),
                            ("O", "Unknown"),
                            ("ADM", "Unknown"),
                            ("SAC", "Unknown"),
                            ("US", "Unknown"),
                            ("J", "Unknown"),
                            ("LOS", "Unknown"),
                            ("IRV", "Unknown"),
                            ("CO", "Unknown"),
                            ("JRS", "Unknown"),
                            ("NEV", "Unknown"),
                            ("IB", "Unknown"),
                            ("A", "Unknown"),
                            ("Ass", "Unknown"),
                            ("SD", "Unknown"),
                            ("D", "Unknown"),
                            ("SEC", "Unknown"),
                            ("SC", "Unknown"),
                            ("RB", "Unknown"),
                            ("GEN", "Unknown"),
                            ("CC", "Unknown"),
                            ("FED", "Unknown"),
                            ("FM", "Unknown"),
                            ("R", "Unknown"),
                        ],
                        db_column="JURIS_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=32
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=44
                            ),
                        ],
                        help_text="Office Jurisdiction Code",
                        max_length=3,
                    ),
                ),
                (
                    "juris_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="JURIS_DSCR",
                        help_text="Office Jurisdiction Description         (Req. if Juris_Cd=[CIT|CTY|LOC|OTH]",
                        max_length=40,
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                    ),
                ),
                (
                    "memo_code",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_CODE",
                        help_text="Memo Amount? (Date/Amount are informational only)",
                        max_length=1,
                    ),
                ),
                (
                    "memo_refno",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_REFNO",
                        help_text="Reference to text contained in a TEXT record.",
                        max_length=20,
                    ),
                ),
                (
                    "off_s_h_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"H", b"HELD"),
                            (b"S", b"SOUGHT"),
                            ("s", b"SOUGHT"),
                            ("h", b"HELD"),
                            ("A", "UNKNOWN"),
                            ("a", "UNKNOWN"),
                            ("8", "UNKNOWN"),
                            ("O", "UNKNOWN"),
                        ],
                        db_column="OFF_S_H_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=32
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=44
                            ),
                        ],
                        help_text="Office is sought or held code",
                        max_length=1,
                    ),
                ),
                (
                    "offic_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="OFFIC_DSCR",
                        help_text="Office Sought Description (Req. if Office_Cd=OTH)",
                        max_length=40,
                    ),
                ),
                (
                    "office_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"APP", b"State Appellate Court Justice"),
                            (b"ASM", b"State Assembly Person"),
                            (b"ASR", b"Assessor"),
                            (b"ATT", b"Attorney General"),
                            (b"BED", b"Board of Education"),
                            (b"BOE", b"Board of Equalization Member"),
                            (b"BSU", b"Board of Supervisors"),
                            (b"CAT", b"City Attorney"),
                            (b"CCB", b"Community College Board"),
                            (b"CCM", b"City Council Member"),
                            (b"CON", b"State Controller"),
                            (b"COU", b"County Counsel"),
                            (b"CSU", b"County Supervisor"),
                            (b"CTR", b"Local Controller"),
                            (b"DAT", b"District Attorney"),
                            (b"GOV", b"Governor"),
                            (b"INS", b"Insurance Commissioner"),
                            (b"LTG", b"Lieutenant Governor"),
                            (b"MAY", b"Mayor"),
                            (b"OTH", b"Other"),
                            (b"PDR", b"Public Defender"),
                            (b"PER", b"Public Employees Retirement System"),
                            (b"PLN", b"Planning Commissioner"),
                            (b"SCJ", b"Superior Court Judge"),
                            (b"SEN", b"State Senator"),
                            (b"SHC", b"Sheriff-Coroner"),
                            (b"SOS", b"Secretary of State"),
                            (b"SPM", b"Supreme Court Justice"),
                            (b"SUP", b"Superintendent of Public Instruction"),
                            (b"TRE", b"State Treasurer"),
                            (b"TRS", b"Local Treasurer"),
                            ("Cou", b"County Counsel"),
                            ("sen", b"State Senator"),
                            ("AtT", b"Attorney General"),
                            ("May", b"Mayor"),
                            ("Sen", b"State Senator"),
                            ("asm", b"State Assembly Person"),
                            ("gov", b"Governor"),
                            ("Gov", b"Governor"),
                            ("LA", "Unknown"),
                            ("HOU", "Unknown"),
                            ("LAD", "Unknown"),
                            ("11A", "Unknown"),
                            ("001", "Unknown"),
                            ("BM", "Unknown"),
                            ("AS1", "Unknown"),
                            ("ASS", "Unknown"),
                            ("73", "Unknown"),
                            ("CIT", "Unknown"),
                            ("HSE", "Unknown"),
                            ("LT", "Unknown"),
                            ("CTY", "Unknown"),
                            ("STA", "Unknown"),
                            ("GO", "Unknown"),
                            ("CO", "Unknown"),
                            ("A", "Unknown"),
                            ("PAC", "Unknown"),
                            ("REP", "Unknown"),
                            ("OFF", "Unknown"),
                            ("SE", "Unknown"),
                            ("031", "Unknown"),
                            ("COM", "Unknown"),
                            ("ASB", "Unknown"),
                            ("OT", "Unknown"),
                            ("NAT", "Unknown"),
                            ("CC", "Unknown"),
                            ("SWE", "Unknown"),
                            ("FED", "Unknown"),
                            ("STE", "Unknown"),
                            ("H", "Unknown"),
                            ("DA", "Unknown"),
                            ("S", "Unknown"),
                            ("AS", "Unknown"),
                            ("OF", "Unknown"),
                            ("LEG", "Unknown"),
                            ("STW", "Unknown"),
                            ("ST", "Unknown"),
                            ("PRE", "Unknown"),
                            ("/S", "Unknown"),
                            ("U S", "Unknown"),
                            ("O", "Unknown"),
                            ("8", "Unknown"),
                            ("C:S", "Unknown"),
                        ],
                        db_column="OFFICE_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id=b"2712033-Cal-Format-1-05-02", start_page=10
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id=b"2712034-Cal-Format-201", start_page=12
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id=b"2712032-Cal-Errata-201", start_page=2
                            ),
                        ],
                        help_text="Identifies the office being sought",
                        max_length=3,
                        verbose_name="office code",
                    ),
                ),
                (
                    "payee_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_CITY",
                        help_text="Payee City",
                        max_length=30,
                    ),
                ),
                (
                    "payee_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_NAMF",
                        help_text="Payee's First name",
                        max_length=45,
                    ),
                ),
                (
                    "payee_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_NAML",
                        help_text="Payee's Last name",
                        max_length=200,
                    ),
                ),
                (
                    "payee_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_NAMS",
                        help_text="Payee's Suffix",
                        max_length=10,
                    ),
                ),
                (
                    "payee_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_NAMT",
                        help_text="Payee's Prefix or Title",
                        max_length=10,
                    ),
                ),
                (
                    "payee_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_ST",
                        help_text="State code",
                        max_length=2,
                    ),
                ),
                (
                    "payee_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_ZIP4",
                        help_text="Zip+4",
                        max_length=10,
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("EXPN", "Expense")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=31
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=42
                            ),
                        ],
                        help_text="Record Type Value: EXPN",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "sup_opp_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"O", b"OPPOSITION"),
                            (b"S", b"SUPPORT"),
                            ("s", b"SUPPORT"),
                            ("o", b"OPPOSITION"),
                            ("H", "UNKNOWN"),
                            ("N", "UNKNOWN"),
                            ("X", "UNKNOWN"),
                            ("Y", "UNKNOWN"),
                        ],
                        db_column="SUP_OPP_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=32
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=44
                            ),
                        ],
                        help_text="Support or opposition code",
                        max_length=1,
                    ),
                ),
                (
                    "tran_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRAN_ID",
                        help_text="Permanent value unique to this item",
                        max_length=20,
                        verbose_name="transaction ID",
                    ),
                ),
                (
                    "tres_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_CITY",
                        help_text="Treasurer City",
                        max_length=30,
                    ),
                ),
                (
                    "tres_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAMF",
                        help_text="Treasurer's First name (Req if [COM|RCP] & no ID#)",
                        max_length=45,
                    ),
                ),
                (
                    "tres_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAML",
                        help_text="Treasurer's Last name (Req if [COM|RCP] & no ID#)",
                        max_length=200,
                    ),
                ),
                (
                    "tres_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAMS",
                        help_text="Treasurer's Suffix",
                        max_length=10,
                    ),
                ),
                (
                    "tres_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAMT",
                        help_text="Treasurer's Prefix or Title",
                        max_length=10,
                    ),
                ),
                (
                    "tres_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_ST",
                        help_text="Treasurer State",
                        max_length=2,
                    ),
                ),
                (
                    "tres_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_ZIP4",
                        help_text="Treasurer ZIP+4",
                        max_length=10,
                    ),
                ),
                (
                    "xref_match",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="XREF_MATCH",
                        help_text="X = Related item on other Sched has same Tran_ID",
                        max_length=1,
                    ),
                ),
                (
                    "xref_schnm",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="XREF_SCHNM",
                        help_text="Related item is included on Sched 'C' or 'H2'",
                        max_length=2,
                    ),
                ),
            ],
            options={
                "db_table": "EXPN_CD",
                "verbose_name": "EXPN_CD",
                "verbose_name_plural": "EXPN_CD",
            },
        ),
        migrations.CreateModel(
            name="F495P2Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("F495", "F495")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=26
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=35
                            ),
                        ],
                        help_text="Record Type Value: F495",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"F450",
                                b"Form 450: Recipient Committee Campaign Disclosure Statement - Short Form",
                            ),
                            (
                                b"F460",
                                b"Form 460: Recipient Committee Campaign Statement",
                            ),
                        ],
                        db_column="FORM_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=26
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=35
                            ),
                        ],
                        help_text="Name of the source filing form to which the Form 495 is attached (must equal Form_Type in CVR record)",
                        max_length=4,
                    ),
                ),
                (
                    "elect_date",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="ELECT_DATE",
                        help_text="Date of the General Election This date will be the same as on the filing's cover (CVR) record.",
                        null=True,
                    ),
                ),
                (
                    "electjuris",
                    calaccess_raw.fields.CharField(
                        db_column="ELECTJURIS",
                        help_text="Jurisdiction of the election",
                        max_length=40,
                    ),
                ),
                (
                    "contribamt",
                    calaccess_raw.fields.FloatField(
                        db_column="CONTRIBAMT",
                        help_text="Contribution amount (For the period of 6 months prior to 17 days before the election)",
                    ),
                ),
            ],
            options={
                "db_table": "F495P2_CD",
                "verbose_name": "F495P2_CD",
                "verbose_name_plural": "F495P2_CD",
            },
        ),
        migrations.CreateModel(
            name="F501502Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("CVR", "CVR")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711614-CalAccessTablesWeb", start_page=58
                            )
                        ],
                        help_text="Record Type",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (b"F501", b"Form 501: Candidate Intention Statement"),
                            (b"F502", b"Form 502: Campaign Bank Account Statement"),
                        ],
                        db_column="FORM_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711614-CalAccessTablesWeb", start_page=58
                            )
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=4,
                    ),
                ),
                (
                    "filer_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FILER_ID",
                        db_index=True,
                        help_text="Filer's unique identification number",
                        max_length=9,
                        verbose_name="filer ID",
                    ),
                ),
                (
                    "committee_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="COMMITTEE_ID",
                        help_text="Committee identification number",
                        max_length=9,
                        verbose_name="Committee ID",
                    ),
                ),
                (
                    "entity_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"ATH", b"Authorizing individual"),
                            (b"ATR", b"Assistant treasurer"),
                            (b"BMC", b"Ballot measure committee"),
                            (b"BNM", b"Ballot measure's name/title"),
                            (b"CAO", b"Candidate/officeholder"),
                            (b"COM", b"Committee"),
                            (b"CTL", b"Controlled committee"),
                            (b"IND", b"Individual"),
                            (b"MDI", b"Major Donor/Ind Expenditure"),
                            (b"OFF", b"Officer"),
                            (b"OTH", b"Other"),
                            (b"POF", b"Principal officer"),
                            (b"PRO", b"Proponent"),
                            (b"PTY", b"Political Party"),
                            (b"RCP", b"Recipient committee"),
                            (b"SCC", b"Small Contributor Committee"),
                            (b"SMO", b"Slate-mailer organization"),
                            (b"SPO", b"Sponsor"),
                            (b"TRE", b"Treasurer"),
                            ("8", "Unknown"),
                        ],
                        db_column="ENTITY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=9,
                                id=b"2712033-Cal-Format-1-05-02",
                                start_page=8,
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=11, id=b"2712034-Cal-Format-201", start_page=9
                            ),
                        ],
                        help_text="Entity code",
                        max_length=9,
                    ),
                ),
                (
                    "report_num",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="REPORT_NUM",
                        help_text="Report Number; 000 Original; 001-999 Amended",
                        max_length=3,
                        null=True,
                    ),
                ),
                (
                    "rpt_date",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="RPT_DATE",
                        help_text="date this report is filed",
                        null=True,
                    ),
                ),
                (
                    "stmt_type",
                    calaccess_raw.fields.IntegerField(
                        choices=[
                            (10001, "ORIGINAL/INITIAL"),
                            (10002, "AMENDMENT"),
                            (10003, "TERMINATION"),
                            (
                                10004,
                                "REDESIGNATE THE ACCOUNT FOR FUTURE ELECTION TO THE SAME OFFICE",
                            ),
                            (10005, "LOG"),
                            (10006, "LOG/AMENDMENT"),
                            (10007, "AS FILED BY COMMITTEE"),
                        ],
                        db_column="STMT_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2774529-Lookup-Codes-Cd", start_page=6
                            )
                        ],
                        help_text="Type of statement",
                        verbose_name="statement type",
                    ),
                ),
                (
                    "from_date",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FROM_DATE",
                        help_text="Reporting period from date",
                        max_length=32,
                    ),
                ),
                (
                    "thru_date",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="THRU_DATE",
                        help_text="Reporting period through date",
                        max_length=32,
                    ),
                ),
                (
                    "elect_date",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ELECT_DATE",
                        help_text="Date of election",
                        max_length=32,
                    ),
                ),
                (
                    "cand_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAML",
                        help_text="Candidate/officerholder last name",
                        max_length=200,
                    ),
                ),
                (
                    "cand_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMF",
                        help_text="Candidate/officerholder first name",
                        max_length=45,
                    ),
                ),
                (
                    "can_namm",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAN_NAMM",
                        help_text="Candidate/officeholder middle name",
                        max_length=20,
                    ),
                ),
                (
                    "cand_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMT",
                        help_text="Candidate/officerholder title or prefix",
                        max_length=100,
                    ),
                ),
                (
                    "cand_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMS",
                        help_text="Candidate/officeholder suffix",
                        max_length=10,
                    ),
                ),
                (
                    "moniker_pos",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MONIKER_POS",
                        help_text="Location of the candidate/officeholder's moniker",
                        max_length=32,
                    ),
                ),
                (
                    "moniker",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MONIKER",
                        help_text="Candidate/officeholder's moniker",
                        max_length=20,
                    ),
                ),
                (
                    "cand_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_CITY",
                        help_text="Candidate/officerholder city",
                        max_length=30,
                    ),
                ),
                (
                    "cand_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_ST",
                        help_text="Candidate/officeholder state",
                        max_length=4,
                    ),
                ),
                (
                    "cand_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_ZIP4",
                        help_text="Candidate/officeholder zip +4",
                        max_length=10,
                    ),
                ),
                (
                    "cand_phon",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_PHON",
                        help_text="Candidate/officeholder phone number",
                        max_length=20,
                    ),
                ),
                (
                    "cand_fax",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_FAX",
                        help_text="Candidate/officerholder fax",
                        max_length=20,
                    ),
                ),
                (
                    "cand_email",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_EMAIL",
                        help_text="Candidate/officeholder email address",
                        max_length=60,
                    ),
                ),
                (
                    "fin_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FIN_NAML",
                        help_text="Financial institution's business name",
                        max_length=200,
                    ),
                ),
                (
                    "fin_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FIN_NAMF",
                        help_text="Unused. Financial institution's first name.",
                        max_length=45,
                    ),
                ),
                (
                    "fin_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FIN_NAMT",
                        help_text="Unused. Financial institution's title.",
                        max_length=100,
                    ),
                ),
                (
                    "fin_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FIN_NAMS",
                        help_text="Unused. Financial institution's suffix.",
                        max_length=32,
                    ),
                ),
                (
                    "fin_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FIN_CITY",
                        help_text="Financial institution's city.",
                        max_length=30,
                    ),
                ),
                (
                    "fin_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FIN_ST",
                        help_text="Financial institution's state.",
                        max_length=4,
                    ),
                ),
                (
                    "fin_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FIN_ZIP4",
                        help_text="Financial institution's zip code.",
                        max_length=10,
                    ),
                ),
                (
                    "fin_phon",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FIN_PHON",
                        help_text="Financial institution's phone number.",
                        max_length=20,
                    ),
                ),
                (
                    "fin_fax",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FIN_FAX",
                        help_text="Financial institution's FAX Number.",
                        max_length=20,
                    ),
                ),
                (
                    "fin_email",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FIN_EMAIL",
                        help_text="Financial institution's e-mail address.",
                        max_length=60,
                    ),
                ),
                (
                    "office_cd",
                    calaccess_raw.fields.IntegerField(
                        choices=[
                            (0, "N/A"),
                            (30001, "PRESIDENT"),
                            (30002, "GOVERNOR"),
                            (30003, "LIEUTENANT GOVERNOR"),
                            (30004, "SECRETARY OF STATE"),
                            (30005, "CONTROLLER"),
                            (30006, "TREASURER"),
                            (30007, "ATTORNEY GENERAL"),
                            (30008, "SUPERINTENDENT OF PUBLIC INSTRUCTION"),
                            (30009, "MEMBER BOARD OF EQUALIZATION"),
                            (30010, "OXNARD HARBOR COMMISSIONER"),
                            (30011, "CITY CONTROLLER"),
                            (30012, "STATE SENATE"),
                            (30013, "ASSEMBLY"),
                            (30014, "INSURANCE COMMISSIONER"),
                            (30015, "JUDGE"),
                            (30016, "BOARD MEMBER"),
                            (30017, "TAX COLLECTOR"),
                            (30018, "TRUSTEE"),
                            (30019, "SUPERVISOR"),
                            (30020, "SHERIFF"),
                            (30021, "CORONER"),
                            (30022, "MARSHALL"),
                            (30023, "CITY CLERK"),
                            (30024, "SCHOOL BOARD"),
                            (30025, "HARBOR COMMISSIONER"),
                            (30026, "DISTRICT ATTORNEY"),
                            (30027, "COUNTY CLERK"),
                            (30028, "AUDITOR"),
                            (30029, "MAYOR"),
                            (30030, "CITY ATTORNEY"),
                            (30031, "DEMOCRATIC COUNTY CENTRAL COMMITTEE"),
                            (30032, "TOWN COUNCIL"),
                            (30033, "ASSESSOR"),
                            (30034, "CITY TREASURER"),
                            (30035, "CITY COUNCIL"),
                            (30036, "COMMISSIONER"),
                            (30037, "REPUBLICAN COUNTY CENTRAL COMMITTEE"),
                            (30038, "DIRECTOR"),
                            (30039, "DIRECTOR OF ZONE 7"),
                            (30040, "COMMUNITY COLLEGE BOARD"),
                            (30041, "POLICE CHIEF"),
                            (30042, "CHIEF OF POLICE"),
                            (30043, "CENTRAL COMMITTEE"),
                            (30044, "BOARD OF EDUCATION"),
                            (30045, "BOARD OF DIRECTORS"),
                            (30046, "COLLEGE BOARD"),
                            (30047, "BART BOARD DIRECTOR"),
                            (30048, "BOARD OF TRUSTEES"),
                            (30049, "IRRIGATION"),
                            (30050, "WATER BOARD"),
                            (30051, "COMMUNITY PLANNING GROUP"),
                            (30052, "BOARD OF SUPERVISORS"),
                            (30053, "SUPERIOR COURT JUDGE"),
                            (30054, "DISTRICT ATTORNEY/PUBLIC DEFENDER"),
                            (30055, "MEASURE"),
                            (30056, "CITY PROSECUTOR"),
                            (30057, "SUPREME COURT JUDGE"),
                            (30058, "PUBLIC EMPLOYEES RETIREMENT BOARD"),
                            (30059, "APPELLATE COURT JUDGE"),
                            (50001, "Ag"),
                            (50002, "Assembly"),
                            (50003, "Assessor"),
                            (50004, "Assessor/Clerk/Recorder"),
                            (50005, "Assessor/County Clerk/Recorder"),
                            (50006, "Assessor/Recorder"),
                            (50007, "Associate Justice"),
                            (50008, "Auditor"),
                            (50009, "Auditor/Controller"),
                            (50010, "Auditor/Controller/Clerk/Recorder"),
                            (50011, "Auditor/Controller/Recorder"),
                            (50012, "Auditor/Controller/Treasurer/Tax Collector"),
                            (50013, "Auditor/Recorder"),
                            (50014, "Board Member"),
                            (50015, "Board Of Director"),
                            (50016, "Board Of Supervisor"),
                            (50017, "Boe"),
                            (50018, "Chief Justice"),
                            (50019, "City"),
                            (50020, "City Attorney"),
                            (50021, "City Auditor"),
                            (50022, "City Clerk"),
                            (50023, "City Council"),
                            (50024, "City Of Los Angeles"),
                            (50025, "City Of South El Monte"),
                            (50026, "City Prosecutor"),
                            (50027, "City Treasurer"),
                            (50028, "Clerk/Auditor"),
                            (50029, "Clerk/Record/Public Admin"),
                            (50030, "Clerk/Recorder"),
                            (50031, "Clerk/Recorder/Registar"),
                            (50032, "Clerk/Recorder/Registrar"),
                            (50033, "Commissioner"),
                            (50034, "Controller"),
                            (50035, "Costa Mesa"),
                            (50036, "Council Member"),
                            (50037, "County Clerk"),
                            (50038, "County Clerk/Auditor"),
                            (50039, "County Clerk/Auditor/Controller"),
                            (50040, "County Clerk/Recorder"),
                            (50041, "County Clerk/Recorder/Assessor"),
                            (50042, "County Clerk/Recorder/Public Admin"),
                            (50043, "Democratic County Central Committee"),
                            (50044, "Director"),
                            (50045, "District Attorney"),
                            (50046, "District Attorney/Public Administrator"),
                            (50047, "Gccc"),
                            (50048, "Governor"),
                            (50049, "Harbor Commissioner"),
                            (50050, "Ic"),
                            (50051, "Irrigation Dist"),
                            (50052, "Judge"),
                            (50053, "Justice"),
                            (50054, "Legislature"),
                            (50055, "Lieutenant Governor"),
                            (50056, "Mayor"),
                            (50057, "N/A"),
                            (50058, "Placentia"),
                            (50059, "Public Administrator"),
                            (50060, "Public Administrator/Guardian"),
                            (50061, "Rent Stabilization Board"),
                            (50062, "Republican Central Committee"),
                            (50063, "San Francisco Dccc"),
                            (50064, "Sanger"),
                            (50065, "School Board"),
                            (50066, "Secretary Of State"),
                            (50067, "Senator"),
                            (50068, "Sheriff"),
                            (50069, "Sheriff/Coroner"),
                            (50070, "Sheriff/Coroner/Marshall"),
                            (50071, "Sheriff/Coroner/Public Administrator"),
                            (50072, "Solana Beach"),
                            (50073, "Superintendent"),
                            (50074, "Supervisor"),
                            (50075, "Supt Of Schools"),
                            (50076, "Tax Collector"),
                            (50077, "Town Council"),
                            (50078, "Treasurer"),
                            (50079, "Treasurer/Tax Collector"),
                            (50080, "Treasurer/Tax Collector/Clerk"),
                            (50081, "Treasurer/Tax Collector/Public Administrator"),
                            (
                                50082,
                                "Treasurer/Tax Collector/Public Administrator/County Clerk",
                            ),
                            (50083, "Treasurer/Tax Collector/Recorder"),
                            (50084, "Trustee"),
                            (50085, "Weed Recreation Board Member"),
                        ],
                        db_column="OFFICE_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=22, id="2774529-Lookup-Codes-Cd", start_page=20
                            )
                        ],
                        help_text="Identifies the office being sought",
                        verbose_name="office code",
                    ),
                ),
                (
                    "offic_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="OFFIC_DSCR",
                        help_text="Office sought description",
                        max_length=80,
                    ),
                ),
                (
                    "agency_nam",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="AGENCY_NAM",
                        help_text="Agency name",
                        max_length=200,
                    ),
                ),
                (
                    "juris_cd",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        choices=[
                            (0, "N/A"),
                            (40501, "LOCAL"),
                            (40502, "STATE"),
                            (40503, "COUNTY"),
                            (40504, "MULTI-COUNTY"),
                            (40505, "CITY"),
                            (40507, "SUPERIOR COURT JUDGE"),
                        ],
                        db_column="JURIS_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=20, id="2774529-Lookup-Codes-Cd", start_page=19
                            )
                        ],
                        help_text="Office jurisdiction code",
                        null=True,
                    ),
                ),
                (
                    "juris_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="JURIS_DSCR",
                        help_text="office jurisdiction description",
                        max_length=30,
                    ),
                ),
                (
                    "dist_no",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="DIST_NO",
                        help_text="District number for the office being sought. Populated for Senate, Assembly or Board of Equalization races.",
                        max_length=4,
                    ),
                ),
                (
                    "party",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PARTY",
                        help_text="Political party",
                        max_length=200,
                    ),
                ),
                (
                    "yr_of_elec",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="YR_OF_ELEC",
                        help_text="Year of election",
                        null=True,
                    ),
                ),
                (
                    "elec_type",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        choices=[
                            (0, "N/A"),
                            (3001, "GENERAL"),
                            (3002, "PRIMARY"),
                            (3003, "RECALL"),
                            (3004, "SPECIAL ELECTION"),
                            (3005, "OFFICEHOLDER"),
                            (3006, "SPECIAL RUNOFF"),
                            (3007, "UNKNOWN"),
                        ],
                        db_column="ELEC_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=4, id="2774529-Lookup-Codes-Cd", start_page=3
                            )
                        ],
                        help_text="Election type",
                        null=True,
                        verbose_name="Election type",
                    ),
                ),
                (
                    "execute_dt",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="EXECUTE_DT",
                        help_text="Execution date",
                        null=True,
                    ),
                ),
                (
                    "can_sig",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAN_SIG",
                        help_text="Candidate signature",
                        max_length=200,
                    ),
                ),
                (
                    "account_no",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ACCOUNT_NO",
                        help_text="Account number",
                        max_length=32,
                    ),
                ),
                (
                    "acct_op_dt",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="ACCT_OP_DT",
                        help_text="Account open date",
                        null=True,
                    ),
                ),
                (
                    "party_cd",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        choices=[
                            (0, "N/A"),
                            (16001, "DEMOCRATIC"),
                            (16002, "REPUBLICAN"),
                            (16003, "GREEN PARTY"),
                            (16004, "REFORM PARTY"),
                            (16005, "AMERICAN INDEPENDENT PARTY"),
                            (16006, "PEACE AND FREEDOM"),
                            (16007, "INDEPENDENT"),
                            (16008, "LIBERTARIAN"),
                            (16009, "NON PARTISAN"),
                            (16010, "NATURAL LAW"),
                            (16011, "UNKNOWN"),
                            (16012, "NO PARTY PREFERENCE"),
                            (16013, "AMERICANS ELECT"),
                            (16014, "UNKNOWN"),
                            (16020, "PEACE AND FREEDOM"),
                        ],
                        db_column="PARTY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=11, id="2774529-Lookup-Codes-Cd", start_page=10
                            )
                        ],
                        help_text="Party code",
                        null=True,
                    ),
                ),
                (
                    "district_cd",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        choices=[
                            (0, "N/A"),
                            (17001, "01"),
                            (17002, "13"),
                            (17003, "24"),
                            (17004, "35"),
                            (17005, "46"),
                            (17006, "57"),
                            (17007, "68"),
                            (17008, "79"),
                            (17009, "02"),
                            (17010, "05"),
                            (17011, "04"),
                            (17013, "06"),
                            (17014, "07"),
                            (17015, "08"),
                            (17016, "19"),
                            (17017, "10"),
                            (17018, "11"),
                            (17019, "12"),
                            (17020, "14"),
                            (17021, "15"),
                            (17022, "16"),
                            (17023, "17"),
                            (17024, "18"),
                            (17026, "20"),
                            (17027, "21"),
                            (17028, "22"),
                            (17029, "23"),
                            (17030, "25"),
                            (17031, "26"),
                            (17032, "27"),
                            (17033, "28"),
                            (17034, "29"),
                            (17035, "30"),
                            (17036, "31"),
                            (17037, "32"),
                            (17038, "33"),
                            (17039, "34"),
                            (17040, "36"),
                            (17041, "37"),
                            (17042, "38"),
                            (17043, "39"),
                            (17044, "40"),
                            (17045, "41"),
                            (17046, "42"),
                            (17047, "43"),
                            (17048, "44"),
                            (17049, "45"),
                            (17050, "47"),
                            (17051, "48"),
                            (17052, "49"),
                            (17053, "50"),
                            (17054, "51"),
                            (17055, "52"),
                            (17056, "53"),
                            (17057, "54"),
                            (17058, "55"),
                            (17059, "56"),
                            (17060, "03"),
                            (17061, "59"),
                            (17062, "60"),
                            (17063, "61"),
                            (17064, "62"),
                            (17065, "63"),
                            (17066, "64"),
                            (17067, "65"),
                            (17068, "66"),
                            (17069, "67"),
                            (17070, "69"),
                            (17071, "70"),
                            (17072, "71"),
                            (17073, "72"),
                            (17074, "73"),
                            (17075, "74"),
                            (17076, "75"),
                            (17077, "76"),
                            (17078, "77"),
                            (17079, "78"),
                            (17080, "80"),
                            (17081, "09"),
                            (17090, "58"),
                            (17012, "Unknown"),
                            (17082, "Unknown"),
                            (17025, "Unknown"),
                        ],
                        db_column="DISTRICT_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=13, id="2774529-Lookup-Codes-Cd", start_page=11
                            )
                        ],
                        help_text="District number for the office being sought. Populated for Senate, Assembly, or Board of Equalization races.",
                        null=True,
                    ),
                ),
                (
                    "accept_limit_yn",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="ACCEPT_LIMIT_YN",
                        help_text="This field is undocumented",
                        null=True,
                    ),
                ),
                (
                    "did_exceed_dt",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="DID_EXCEED_DT",
                        help_text="This field is undocumented",
                        null=True,
                    ),
                ),
                (
                    "cntrb_prsnl_fnds_dt",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="CNTRB_PRSNL_FNDS_DT",
                        help_text="This field is undocumented",
                        null=True,
                    ),
                ),
            ],
            options={
                "db_table": "F501_502_CD",
                "verbose_name": "F501_502_CD",
                "verbose_name_plural": "F501_502_CD",
            },
        ),
        migrations.CreateModel(
            name="F690P2Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("F690", "F690")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=58
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=72
                            ),
                        ],
                        help_text="Record Type Value: F690",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (b"F615", b"Form 615: Lobbyist Report"),
                            (b"F625", b"Form 625: Report of Lobbying Firm"),
                            (
                                b"F635",
                                b"Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                            ),
                            (
                                b"F645",
                                b"Form 645: Report of Person Spending $5,000 or More",
                            ),
                        ],
                        db_column="FORM_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=58
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=72
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=4,
                    ),
                ),
                (
                    "exec_date",
                    calaccess_raw.fields.DateField(
                        db_column="EXEC_DATE",
                        help_text="date the original report (or prior amendment to the original report) was executed on.",
                        null=True,
                    ),
                ),
                (
                    "from_date",
                    calaccess_raw.fields.DateField(
                        db_column="FROM_DATE",
                        help_text="reporting period from date of original report",
                        null=True,
                    ),
                ),
                (
                    "thru_date",
                    calaccess_raw.fields.DateField(
                        db_column="THRU_DATE",
                        help_text="report period to/through date of original.",
                        null=True,
                    ),
                ),
                (
                    "chg_parts",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CHG_PARTS",
                        help_text="amended into affects items on part(s) text description.",
                        max_length=100,
                    ),
                ),
                (
                    "chg_sects",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CHG_SECTS",
                        help_text="amended into affects items on sections(s) text description.",
                        max_length=100,
                    ),
                ),
                (
                    "amend_txt1",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="AMEND_TXT1",
                        help_text="description of changes to the filing",
                        max_length=330,
                    ),
                ),
            ],
            options={
                "db_table": "F690P2_CD",
                "verbose_name": "F690P2_CD",
                "verbose_name_plural": "F690P2_CD",
            },
        ),
        migrations.CreateModel(
            name="FilerAcronymsCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "acronym",
                    calaccess_raw.fields.CharField(
                        db_column="ACRONYM", help_text="AMS acronym", max_length=32
                    ),
                ),
                (
                    "filer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILER_ID",
                        db_index=True,
                        help_text="Filer's unique identification number",
                        null=True,
                        verbose_name="filer ID",
                    ),
                ),
            ],
            options={
                "ordering": ("id",),
                "db_table": "FILER_ACRONYMS_CD",
                "verbose_name": "FILER_ACRONYMS_CD",
                "verbose_name_plural": "FILER_ACRONYMS_CD",
            },
        ),
        migrations.CreateModel(
            name="FilerAddressCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILER_ID",
                        db_index=True,
                        help_text="Filer's unique identification number",
                        null=True,
                        verbose_name="filer ID",
                    ),
                ),
                (
                    "adrid",
                    calaccess_raw.fields.IntegerField(
                        db_column="ADRID",
                        help_text="Address identification number",
                        verbose_name="Address ID",
                    ),
                ),
                (
                    "effect_dt",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="EFFECT_DT",
                        help_text="Address effective date",
                        null=True,
                        verbose_name="Effective date",
                    ),
                ),
                (
                    "add_type",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        choices=[
                            (51, "PERMANENT"),
                            (7026, "BUSINESS"),
                            (7027, "HOME"),
                            (7050, "NOT IN USE"),
                            (7051, "PERMANENT"),
                            (7082, "MAILING ADDRESS"),
                        ],
                        db_column="ADD_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2774529-Lookup-Codes-Cd", start_page=5
                            )
                        ],
                        help_text="Address type",
                        null=True,
                        verbose_name="Address type",
                    ),
                ),
                (
                    "session_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_ID",
                        help_text="Legislative session identification number",
                        null=True,
                        verbose_name="session ID",
                    ),
                ),
            ],
            options={
                "db_table": "FILER_ADDRESS_CD",
                "verbose_name": "FILER_ADDRESS_CD",
                "verbose_name_plural": "FILER_ADDRESS_CD",
            },
        ),
        migrations.CreateModel(
            name="FilerEthicsClassCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILER_ID",
                        db_index=True,
                        help_text="Filer's unique identification number",
                        null=True,
                        verbose_name="filer ID",
                    ),
                ),
                (
                    "session_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_ID",
                        help_text="Legislative session identification number",
                        null=True,
                        verbose_name="session ID",
                    ),
                ),
                (
                    "ethics_date",
                    calaccess_raw.fields.DateField(
                        db_column="ETHICS_DATE",
                        help_text="Date ethics training was accomplished",
                        null=True,
                    ),
                ),
            ],
            options={
                "db_table": "FILER_ETHICS_CLASS_CD",
                "verbose_name": "FILER_ETHICS_CLASS_CD",
                "verbose_name_plural": "FILER_ETHICS_CLASS_CD",
            },
        ),
        migrations.CreateModel(
            name="FilerFilingsCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILER_ID",
                        db_index=True,
                        help_text="Filer's unique identification number",
                        null=True,
                        verbose_name="filer ID",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "period_id",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="PERIOD_ID",
                        help_text="Identifies the period when the filing was recieved.",
                        null=True,
                    ),
                ),
                (
                    "form_id",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"F400",
                                b"Form 400: Statement of Organization (Slate Mailer Organization)",
                            ),
                            (
                                b"F401",
                                b"Form 401: Slate Mailer Organization Campaign Statement",
                            ),
                            (
                                b"F402",
                                b"Form 402: Statement of Termination (Slate Mailer Organization)",
                            ),
                            (
                                b"F405",
                                b"Form 405: Amendment to Campaign Disclosure Statement",
                            ),
                            (
                                b"F410",
                                b"Form 410: Statement of Organization Recipient Committee",
                            ),
                            (b"F415", b"Form 415: Title Unknown"),
                            (b"F416", b"Form 416: Title Unknown"),
                            (
                                b"F419",
                                b"Form 419: Ballot Measure Committee Campaign Statement-Long Form",
                            ),
                            (
                                b"F420",
                                b"Form 420: Recipient Committee Campaign Statement-Long Form",
                            ),
                            (
                                b"F425",
                                b"Form 425: Semi-Annual Statement of no Activity",
                            ),
                            (b"F430", b"Form 430: Title Unknown"),
                            (
                                b"F450",
                                b"Form 450: Recipient Committee Campaign Disclosure Statement - Short Form",
                            ),
                            (
                                b"F460",
                                b"Form 460: Recipient Committee Campaign Statement",
                            ),
                            (
                                b"F461",
                                b"Form 461: Independent Expenditure Committee & Major Donor Committee Campaign Statement",
                            ),
                            (
                                b"F465",
                                b"Form 465: Supplemental Independent Expenditure Report",
                            ),
                            (
                                b"F470",
                                b"Form 470: Officeholder and Candidate Campaign Statement, Short Form",
                            ),
                            (
                                b"F490",
                                b"Form 490: Officeholder/Candidate Campaign Statement-Long Form",
                            ),
                            (
                                b"F495",
                                b"Form 495: Supplemental Pre-Election Campaign Statement",
                            ),
                            (b"F496", b"Form 496: Late Independent Expenditure Report"),
                            (b"F497", b"Form 497: Late Contribution Report"),
                            (b"F498", b"Form 498: Slate Mailer Late Payment Report"),
                            (b"F501", b"Form 501: Candidate Intention Statement"),
                            (b"F502", b"Form 502: Campaign Bank Account Statement"),
                            (b"F511", b"Form 511: Paid Spokesperson Report"),
                            (
                                b"E530",
                                b"Electronic Form 530: Electronic Issue Advocacy Report",
                            ),
                            (
                                b"F601",
                                b"Form 601: Lobbying Firm Registration Statement",
                            ),
                            (
                                b"F602",
                                b"Form 602: Lobbying Firm Activity Authorization",
                            ),
                            (
                                b"F603",
                                b"Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                            ),
                            (b"F604", b"Form 604: Lobbyist Certification Statement"),
                            (
                                b"F605",
                                b"Form 605: Amendment to Registration, Lobbying Firm, Lobbyist Employer, Lobbying Coalition",
                            ),
                            (b"F606", b"Form 606: Notice of Termination"),
                            (b"F607", b"Form 607: Notice of Withdrawal"),
                            (b"F615", b"Form 615: Lobbyist Report"),
                            (b"F625", b"Form 625: Report of Lobbying Firm"),
                            (
                                b"S630",
                                b"Schedule 630: Payments Made to Lobbying Coalitions (Attachment to Form 625 or 635) ",
                            ),
                            (
                                b"F635",
                                b"Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                            ),
                            (
                                b"S635-C",
                                b"Schedule 635C: Payments Received by Lobbying Coalitions",
                            ),
                            (
                                b"S640",
                                b"Schedule 640: Governmental Agencies Reporting (Attachment to Form 635 or Form 645)",
                            ),
                            (
                                b"F645",
                                b"Form 645: Report of Person Spending $5,000 or More",
                            ),
                            (
                                b"F690",
                                b"Form 690: Amendment to Lobbying Disclosure Report",
                            ),
                            (b"F700", b"Form 700: Statement of Economic Interest"),
                            (
                                b"F900",
                                b"Form 900: Public employee's retirement board, candidate campaign statement",
                            ),
                            ("F111", "Unknown"),
                            ("F410 AT", "Unknown"),
                            ("F410ATR", "Unknown"),
                            ("F421", "Unknown"),
                            ("F440", "Unknown"),
                            (
                                "F470S",
                                b"Form 470: Officeholder and Candidate Campaign Statement, Short Form",
                            ),
                            ("F480", "Unknown"),
                            ("F500", "Unknown"),
                            (
                                "F501502",
                                "Forms 501 and/or 502 (Candidate Intention and/or Bank Account Statements)",
                            ),
                            ("F555", "Unknown"),
                            ("F666", "Unknown"),
                            ("F777", "Unknown"),
                            ("F888", "Unknown"),
                            ("F999", "Unknown"),
                        ],
                        db_column="FORM_ID",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711614-CalAccessTablesWeb", start_page=65
                            )
                        ],
                        help_text="Form identification code",
                        max_length=7,
                        verbose_name="form type",
                    ),
                ),
                (
                    "filing_sequence",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_SEQUENCE",
                        db_index=True,
                        help_text="Amendment number where 0 is an original filing and 1 to 999 are amendments",
                    ),
                ),
                (
                    "filing_date",
                    calaccess_raw.fields.DateField(
                        db_column="FILING_DATE",
                        help_text="Date the filing entered into the system",
                        null=True,
                    ),
                ),
                (
                    "stmnt_type",
                    calaccess_raw.fields.IntegerField(
                        choices=[
                            (0, "N/A"),
                            (10001, "ORIGINAL/INITIAL"),
                            (10002, "AMENDMENT"),
                            (10003, "TERMINATION"),
                            (
                                10004,
                                "REDESIGNATE THE ACCOUNT FOR FUTURE ELECTION TO THE SAME OFFICE",
                            ),
                            (10005, "LOG"),
                            (10006, "LOG/AMENDMENT"),
                            (10007, "AS FILED BY COMMITTEE"),
                        ],
                        db_column="STMNT_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2774529-Lookup-Codes-Cd", start_page=6
                            )
                        ],
                        help_text="Type of statement",
                        verbose_name="statement type",
                    ),
                ),
                (
                    "stmnt_status",
                    calaccess_raw.fields.IntegerField(
                        choices=[
                            (11001, "COMPLETE"),
                            (11002, "INCOMPLETE"),
                            (11003, "NEEDS REVIEW"),
                        ],
                        db_column="STMNT_STATUS",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2774529-Lookup-Codes-Cd", start_page=6
                            )
                        ],
                        help_text="The status of the statement. If the filing has been reviewed or not reviewed.",
                        null=True,
                        verbose_name="statement status",
                    ),
                ),
                (
                    "session_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_ID",
                        help_text="Legislative session identification number",
                        null=True,
                        verbose_name="session ID",
                    ),
                ),
                (
                    "user_id",
                    calaccess_raw.fields.CharField(
                        db_column="USER_ID",
                        help_text="User identifier of the PRD user who logged the filing",
                        max_length=12,
                        verbose_name="user ID",
                    ),
                ),
                (
                    "special_audit",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="SPECIAL_AUDIT",
                        help_text="Denotes whether the filing has been audited for money laundering or other special condition.",
                        null=True,
                    ),
                ),
                (
                    "fine_audit",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="FINE_AUDIT",
                        help_text="Indicates whether a filing has been audited for a fine",
                        null=True,
                    ),
                ),
                (
                    "rpt_start",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="RPT_START",
                        help_text="Starting date for the period the filing represents",
                        null=True,
                    ),
                ),
                (
                    "rpt_end",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="RPT_END",
                        help_text="Ending date for the period the filing represents",
                        null=True,
                    ),
                ),
                (
                    "rpt_date",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="RPT_DATE",
                        help_text="Date filing received",
                        null=True,
                    ),
                ),
                (
                    "filing_type",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        choices=[
                            (0, "N/A"),
                            (22001, "Electronic"),
                            (22006, "Cal Online"),
                        ],
                        db_column="FILING_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711615-FAQ", start_page=2
                            )
                        ],
                        help_text="The type of filing",
                        null=True,
                    ),
                ),
            ],
            options={
                "db_table": "FILER_FILINGS_CD",
                "verbose_name": "FILER_FILINGS_CD",
                "verbose_name_plural": "FILER_FILINGS_CD",
            },
        ),
        migrations.CreateModel(
            name="FilerInterestsCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILER_ID",
                        db_index=True,
                        help_text="Filer's unique identification number",
                        null=True,
                        verbose_name="filer ID",
                    ),
                ),
                (
                    "session_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_ID",
                        help_text="Legislative session identification number",
                        null=True,
                        verbose_name="session ID",
                    ),
                ),
                (
                    "interest_cd",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        choices=[
                            (0, "N/A"),
                            (40301, "AGRICULTURE"),
                            (40302, "EDUCATION"),
                            (40303, "ENTERTAINMENT/RECREATION"),
                            (40304, "FINANCE/INSURANCE"),
                            (40305, "GOVERNMENT"),
                            (40306, "HEALTH"),
                            (40307, "LABOR UNIONS"),
                            (40308, "LEGAL"),
                            (40309, "LODGING/RESTAURANTS"),
                            (40310, "MANUFACTURING/INDUSTRIAL"),
                            (40311, "MERCHANDISE/RETAIL"),
                            (40312, "MISCELLANEOUS"),
                            (40313, "OIL AND GAS"),
                            (40314, "POLITICAL ORGANIZATIONS"),
                            (40315, "PROFESSIONAL/TRADE"),
                            (40316, "PUBLIC EMPLOYEES"),
                            (40317, "REAL ESTATE"),
                            (40318, "TRANSPORTATION"),
                            (40319, "UTILITIES"),
                        ],
                        db_column="INTEREST_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2774529-Lookup-Codes-Cd", start_page=19
                            )
                        ],
                        help_text="Interest code linked to the filer",
                        null=True,
                        verbose_name="interest code",
                    ),
                ),
                (
                    "effect_date",
                    calaccess_raw.fields.DateField(
                        db_column="EFFECT_DATE",
                        help_text="Effective date",
                        null=True,
                        verbose_name="Effective date",
                    ),
                ),
            ],
            options={
                "db_table": "FILER_INTERESTS_CD",
                "verbose_name": "FILER_INTERESTS_CD",
                "verbose_name_plural": "FILER_INTERESTS_CD",
            },
        ),
        migrations.CreateModel(
            name="FilerLinksCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filer_id_a",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILER_ID_A",
                        db_index=True,
                        help_text="Unique identification number for the first filer in the relationship",
                        verbose_name="Filer ID A",
                    ),
                ),
                (
                    "filer_id_b",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILER_ID_B",
                        db_index=True,
                        help_text="Unique identification number for the second filer in the relationship",
                        verbose_name="Filer ID B",
                    ),
                ),
                (
                    "active_flg",
                    calaccess_raw.fields.CharField(
                        db_column="ACTIVE_FLG",
                        help_text="Indicates if the link is active",
                        max_length=1,
                        verbose_name="active flag",
                    ),
                ),
                (
                    "session_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_ID",
                        help_text="Legislative session identification number",
                        null=True,
                        verbose_name="session ID",
                    ),
                ),
                (
                    "link_type",
                    calaccess_raw.fields.IntegerField(
                        choices=[
                            (-12019, "CANDIDATE CONTROLLED CAUCUS COMMITTEE"),
                            (-12018, "PROPONENT"),
                            (-12016, "TREASURER/RESPONSIBLE OFFICER FOR"),
                            (-12015, "ASSOCIATED"),
                            (-12014, "SUPPORT"),
                            (-12013, "OPPOSE"),
                            (-12011, "CONTROLLING CANDIDATE"),
                            (-12008, "FIRM OF A LOBBYIST"),
                            (-12005, "FIRM OF A CLIENT (WHO IS ALSO A FIRM)"),
                            (-12004, "FIRM OF A CLIENT (WHO IS AN EMPLOYER)"),
                            (-12002, "EMPLOYER OF  AN IN-HOUSE LOBBYIST"),
                            (-12001, "CLIENT OF A FIRM"),
                            (0, "N/A"),
                            (12001, "FIRM OF A CLIENT"),
                            (12002, "IN-HOUSE LOBBYIST OF AN EMPLOYER"),
                            (12004, "CLIENT (WHO IS AN EMPLOYER) OF A FIRM"),
                            (12005, "CLIENT (WHO IS ALSO A FIRM) OF ANOTHER FIRM"),
                            (12008, "LOBBYIST OF A FIRM"),
                            (12011, "CANDIDATE CONTROLS THIS COMMITTEE"),
                            (12013, "OPPOSE"),
                            (12014, "SUPPORT"),
                            (12015, "ASSOCIATED"),
                            (12016, "TREASURER/RESPONSIBLE OFFICER"),
                            (12018, "PROPONENT"),
                            (12019, "CANDIDATE CONTROLLED CAUCUS COMMITTEE"),
                        ],
                        db_column="LINK_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=7, id="2774529-Lookup-Codes-Cd", start_page=6
                            )
                        ],
                        help_text="Denotes the type of the link",
                        verbose_name="link type",
                    ),
                ),
                (
                    "link_desc",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LINK_DESC",
                        help_text="Unused",
                        max_length=255,
                        verbose_name="link description",
                    ),
                ),
                (
                    "effect_dt",
                    calaccess_raw.fields.DateField(
                        db_column="EFFECT_DT",
                        help_text="Date the link became active",
                        null=True,
                        verbose_name="effective date",
                    ),
                ),
                (
                    "dominate_filer",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="DOMINATE_FILER",
                        help_text="Unused",
                        max_length=1,
                    ),
                ),
                (
                    "termination_dt",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="TERMINATION_DT",
                        help_text="Termination effective date",
                        null=True,
                        verbose_name="termination date",
                    ),
                ),
            ],
            options={
                "db_table": "FILER_LINKS_CD",
                "verbose_name": "FILER_LINKS_CD",
                "verbose_name_plural": "FILER_LINKS_CD",
            },
        ),
        migrations.CreateModel(
            name="FilernameCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "xref_filer_id",
                    calaccess_raw.fields.CharField(
                        db_column="XREF_FILER_ID",
                        db_index=True,
                        help_text="Alternative filer ID found on many forms",
                        max_length=15,
                        verbose_name="crossreference filer ID",
                    ),
                ),
                (
                    "filer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILER_ID",
                        db_index=True,
                        help_text="Filer's unique identification number",
                        null=True,
                        verbose_name="filer ID",
                    ),
                ),
                (
                    "filer_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            ("NOT DEFINED", "Undefined"),
                            ("ALL FILERS", "All filers"),
                            ("CANDIDATE/OFFICEHOLDER", "Candidate/officeholder"),
                            ("CLIENT", "Client"),
                            ("EMPLOYER", "Employer"),
                            ("FIRM", "Firm"),
                            ("INDIVIDUAL", "Individual"),
                            ("INITIATIVE", "Initiative"),
                            ("LOBBYIST", "Lobbyist"),
                            (
                                "MAJOR DONOR/INDEPENDENT EXPENDITURE COMMITTEE",
                                "Major donor or indenpendent expenditure committee",
                            ),
                            ("PAYMENT TO INFLUENCE", "Payment to influence"),
                            ("PREPAID ACCOUNT", "Prepaid account"),
                            ("PROPONENT", "Proponent"),
                            ("PROPOSITION", "Proposition"),
                            ("RECIPIENT COMMITTEE", "Recipient committee"),
                            ("SLATE MAILER ORGANIZATIONS", "Slate mailer organization"),
                            (
                                "TREASURER/RESPONSIBLE OFFICER",
                                "Treasurer/responsible officer",
                            ),
                        ],
                        db_column="FILER_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2774536-Filer-Types-Cd", start_page=1
                            )
                        ],
                        help_text="The type of filer. These values are found FILER_TYPES_CD.DESCRIPTION",
                        max_length=45,
                    ),
                ),
                (
                    "status",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("", "Undefined"),
                            ("A", "ACTIVE"),
                            ("P", "PENDING"),
                            ("R", "REVOKED"),
                            ("S", "SUSPENDED"),
                            ("W", "WITHDRAWN"),
                            ("Y", "ACTIVE"),
                            ("N", "INACTIVE"),
                            ("T", "TERMINATED"),
                            ("ACTIVE", "ACTIVE"),
                            ("INACTIVE", "INACTIVE"),
                            ("TERMINATED", "TERMINATED"),
                        ],
                        db_column="STATUS",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2774537-Filer-Status-Types-Cd", start_page=1
                            )
                        ],
                        help_text="The status of the filer. Includes a mixture of values found in the STATUS_TYPE and STATUS_DESC columns on FILER_STATUS_TYPES_CD",
                        max_length=10,
                    ),
                ),
                (
                    "effect_dt",
                    calaccess_raw.fields.DateField(
                        db_column="EFFECT_DT",
                        help_text="Effective date for status",
                        null=True,
                    ),
                ),
                (
                    "naml",
                    calaccess_raw.fields.CharField(
                        db_column="NAML",
                        help_text="Last name, sometimes full name",
                        max_length=200,
                    ),
                ),
                (
                    "namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="NAMF",
                        help_text="First name",
                        max_length=55,
                    ),
                ),
                (
                    "namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="NAMT",
                        help_text="Name prefix or title",
                        max_length=70,
                    ),
                ),
                (
                    "nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="NAMS",
                        help_text="Name suffix",
                        max_length=32,
                    ),
                ),
                (
                    "adr1",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ADR1",
                        help_text="First line of street address",
                        max_length=200,
                    ),
                ),
                (
                    "adr2",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ADR2",
                        help_text="Second line of street address",
                        max_length=200,
                    ),
                ),
                (
                    "city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CITY",
                        help_text="City address",
                        max_length=55,
                    ),
                ),
                (
                    "st",
                    calaccess_raw.fields.CharField(
                        blank=True, db_column="ST", help_text="State", max_length=4
                    ),
                ),
                (
                    "zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ZIP4",
                        help_text="ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "phon",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PHON",
                        help_text="Phone number",
                        max_length=60,
                        verbose_name="Phone",
                    ),
                ),
                (
                    "fax",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FAX",
                        help_text="Fax number",
                        max_length=60,
                    ),
                ),
                (
                    "email",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EMAIL",
                        help_text="Email address",
                        max_length=60,
                    ),
                ),
            ],
            options={
                "ordering": ("naml", "namf"),
                "db_table": "FILERNAME_CD",
                "verbose_name": "FILERNAME_CD",
                "verbose_name_plural": "FILERNAME_CD",
            },
        ),
        migrations.CreateModel(
            name="FilersCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILER_ID",
                        db_index=True,
                        help_text="Filer's unique identification number",
                        null=True,
                        verbose_name="filer ID",
                    ),
                ),
            ],
            options={
                "db_table": "FILERS_CD",
                "verbose_name": "FILERS_CD",
                "verbose_name_plural": "FILERS_CD",
            },
        ),
        migrations.CreateModel(
            name="FilerStatusTypesCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status_type",
                    calaccess_raw.fields.CharField(
                        db_column="STATUS_TYPE",
                        help_text="This field is undocumented",
                        max_length=11,
                        verbose_name="status type",
                    ),
                ),
                (
                    "status_desc",
                    calaccess_raw.fields.CharField(
                        db_column="STATUS_DESC",
                        help_text="This field is undocumented",
                        max_length=11,
                        verbose_name="status description",
                    ),
                ),
            ],
            options={
                "ordering": ("status_type",),
                "db_table": "FILER_STATUS_TYPES_CD",
                "verbose_name": "FILER_STATUS_TYPES_CD",
                "verbose_name_plural": "FILER_STATUS_TYPES_CD",
            },
        ),
        migrations.CreateModel(
            name="FilerToFilerTypeCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILER_ID",
                        db_index=True,
                        help_text="Filer's unique identification number",
                        null=True,
                        verbose_name="filer ID",
                    ),
                ),
                (
                    "active",
                    calaccess_raw.fields.CharField(
                        db_column="ACTIVE",
                        help_text="Indicates if the filer is currently active",
                        max_length=1,
                    ),
                ),
                (
                    "race",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        choices=[
                            (0, "N/A"),
                            (30002, "GOVERNOR"),
                            (30003, "LIEUTENANT GOVERNOR"),
                            (30004, "SECRETARY OF STATE"),
                            (30005, "CONTROLLER"),
                            (30006, "TREASURER"),
                            (30007, "ATTORNEY GENERAL"),
                            (30008, "SUPERINTENDENT OF PUBLIC INSTRUCTION"),
                            (30009, "MEMBER BOARD OF EQUALIZATION"),
                            (30010, "OXNARD HARBOR COMMISSIONER"),
                            (30011, "CITY CONTROLLER"),
                            (30012, "STATE SENATE"),
                            (30013, "ASSEMBLY"),
                            (30014, "INSURANCE COMMISSIONER"),
                            (30015, "JUDGE"),
                            (30016, "BOARD MEMBER"),
                            (30017, "TAX COLLECTOR"),
                            (30018, "TRUSTEE"),
                            (30019, "SUPERVISOR"),
                            (30020, "SHERIFF"),
                            (30021, "CORONER"),
                            (30022, "MARSHALL"),
                            (30023, "CITY CLERK"),
                            (30024, "SCHOOL BOARD"),
                            (30025, "HARBOR COMMISSIONER"),
                            (30026, "DISTRICT ATTORNEY"),
                            (30027, "COUNTY CLERK"),
                            (30028, "AUDITOR"),
                            (30029, "MAYOR"),
                            (30030, "CITY ATTORNEY"),
                            (30031, "DEMOCRATIC COUNTY CENTRAL COMMITTEE"),
                            (30032, "TOWN COUNCIL"),
                            (30033, "ASSESSOR"),
                            (30034, "CITY TREASURER"),
                            (30035, "CITY COUNCIL"),
                            (30036, "COMMISSIONER"),
                            (30037, "REPUBLICAN COUNTY CENTRAL COMMITTEE"),
                            (30038, "DIRECTOR"),
                            (30039, "DIRECTOR OF ZONE 7"),
                            (30040, "COMMUNITY COLLEGE BOARD"),
                            (30041, "POLICE CHIEF"),
                            (30042, "CHIEF OF POLICE"),
                            (30043, "CENTRAL COMMITTEE"),
                            (30044, "BOARD OF EDUCATION"),
                            (30045, "BOARD OF DIRECTORS"),
                            (30046, "COLLEGE BOARD"),
                            (30047, "BART BOARD DIRECTOR"),
                            (30048, "BOARD OF TRUSTEES"),
                            (30049, "IRRIGATION"),
                            (30050, "WATER BOARD"),
                            (30051, "COMMUNITY PLANNING GROUP"),
                            (30052, "BOARD OF SUPERVISORS"),
                            (30053, "SUPERIOR COURT JUDGE"),
                            (30054, "DISTRICT ATTORNEY/PUBLIC DEFENDER"),
                            (30055, "MEASURE"),
                            (30056, "CITY PROSECUTOR"),
                            (30057, "SUPREME COURT JUDGE"),
                            (30058, "PUBLIC EMPLOYEES RETIREMENT BOARD"),
                            (30059, "APPELLATE COURT JUDGE"),
                            (50001, "Ag"),
                            (50002, "Assembly"),
                            (50003, "Assessor"),
                            (50004, "Assessor/Clerk/Recorder"),
                            (50005, "Assessor/County Clerk/Recorder"),
                            (50006, "Assessor/Recorder"),
                            (50007, "Associate Justice"),
                            (50008, "Auditor"),
                            (50009, "Auditor/Controller"),
                            (50010, "Auditor/Controller/Clerk/Recorder"),
                            (50011, "Auditor/Controller/Recorder"),
                            (50012, "Auditor/Controller/Treasurer/Tax Collector"),
                            (50013, "Auditor/Recorder"),
                            (50014, "Board Member"),
                            (50015, "Board Of Director"),
                            (50016, "Board Of Supervisor"),
                            (50017, "Boe"),
                            (50018, "Chief Justice"),
                            (50019, "City"),
                            (50020, "City Attorney"),
                            (50021, "City Auditor"),
                            (50022, "City Clerk"),
                            (50023, "City Council"),
                            (50024, "City Of Los Angeles"),
                            (50025, "City Of South El Monte"),
                            (50026, "City Prosecutor"),
                            (50027, "City Treasurer"),
                            (50028, "Clerk/Auditor"),
                            (50029, "Clerk/Record/Public Admin"),
                            (50030, "Clerk/Recorder"),
                            (50031, "Clerk/Recorder/Registar"),
                            (50032, "Clerk/Recorder/Registrar"),
                            (50033, "Commissioner"),
                            (50034, "Controller"),
                            (50035, "Costa Mesa"),
                            (50036, "Council Member"),
                            (50037, "County Clerk"),
                            (50038, "County Clerk/Auditor"),
                            (50039, "County Clerk/Auditor/Controller"),
                            (50040, "County Clerk/Recorder"),
                            (50041, "County Clerk/Recorder/Assessor"),
                            (50042, "County Clerk/Recorder/Public Admin"),
                            (50043, "Democratic County Central Committee"),
                            (50044, "Director"),
                            (50045, "District Attorney"),
                            (50046, "District Attorney/Public Administrator"),
                            (50047, "Gccc"),
                            (50048, "Governor"),
                            (50049, "Harbor Commissioner"),
                            (50050, "Ic"),
                            (50051, "Irrigation Dist"),
                            (50052, "Judge"),
                            (50053, "Justice"),
                            (50054, "Legislature"),
                            (50055, "Lieutenant Governor"),
                            (50056, "Mayor"),
                            (50057, "N/A"),
                            (50058, "Placentia"),
                            (50059, "Public Administrator"),
                            (50060, "Public Administrator/Guardian"),
                            (50061, "Rent Stabilization Board"),
                            (50062, "Republican Central Committee"),
                            (50063, "San Francisco Dccc"),
                            (50064, "Sanger"),
                            (50065, "School Board"),
                            (50066, "Secretary Of State"),
                            (50067, "Senator"),
                            (50068, "Sheriff"),
                            (50069, "Sheriff/Coroner"),
                            (50070, "Sheriff/Coroner/Marshall"),
                            (50071, "Sheriff/Coroner/Public Administrator"),
                            (50072, "Solana Beach"),
                            (50073, "Superintendent"),
                            (50074, "Supervisor"),
                            (50075, "Supt Of Schools"),
                            (50076, "Tax Collector"),
                            (50077, "Town Council"),
                            (50078, "Treasurer"),
                            (50079, "Treasurer/Tax Collector"),
                            (50080, "Treasurer/Tax Collector/Clerk"),
                            (50081, "Treasurer/Tax Collector/Public Administrator"),
                            (
                                50082,
                                "Treasurer/Tax Collector/Public Administrator/County Clerk",
                            ),
                            (50083, "Treasurer/Tax Collector/Recorder"),
                            (50084, "Trustee"),
                            (50085, "Weed Recreation Board Member"),
                        ],
                        db_column="RACE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=18, id="2774529-Lookup-Codes-Cd", start_page=16
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=22, id="2774529-Lookup-Codes-Cd", start_page=20
                            ),
                        ],
                        help_text="If applicable indicates the race in which the filer is running",
                        null=True,
                    ),
                ),
                (
                    "session_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_ID",
                        help_text="Legislative session identification number",
                        null=True,
                        verbose_name="session ID",
                    ),
                ),
                (
                    "category",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        choices=[
                            (0, "N/A"),
                            (40000, "CATEGORY"),
                            (40001, "JOINTLY CONTROLLED"),
                            (40002, "CONTROLLED"),
                            (40003, "CAUCUS COMMITTEE"),
                            (40004, "Unknown"),
                        ],
                        db_column="CATEGORY",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2774529-Lookup-Codes-Cd", start_page=18
                            )
                        ],
                        help_text="Defines the filer's category such as controlled, jointly controlled, etc. (subset of filer's type)",
                        null=True,
                    ),
                ),
                (
                    "category_type",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        choices=[
                            (0, "N/A"),
                            (40501, "LOCAL"),
                            (40502, "STATE"),
                            (40503, "COUNTY"),
                            (40504, "MULTI-COUNTY"),
                            (40505, "CITY"),
                            (40506, "FEDERAL"),
                            (40507, "SUPERIOR COURT JUDGE"),
                        ],
                        db_column="CATEGORY_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=20, id="2774529-Lookup-Codes-Cd", start_page=19
                            )
                        ],
                        help_text="When applicable, the category type specifies additional information about the category. (e.g. state, local, etc.)",
                        null=True,
                    ),
                ),
                (
                    "sub_category",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        choices=[
                            (0, "N/A"),
                            (40101, "PRIMARILY FORMED MEASURE"),
                            (40102, "PRIMARILY FORMED CANDIDATE"),
                            (40103, "GENERAL PURPOSE"),
                            (40104, "GENERAL PURPOSE POLITICAL PARTY"),
                            (40105, "GENERAL PURPOSE MEASURE"),
                            (40112, "Unknown"),
                        ],
                        db_column="SUB_CATEGORY",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2774529-Lookup-Codes-Cd", start_page=18
                            )
                        ],
                        help_text="When applicable specifies general purpose, primarily formed, etc.",
                        null=True,
                    ),
                ),
                (
                    "effect_dt",
                    calaccess_raw.fields.DateField(
                        db_column="EFFECT_DT",
                        help_text="The date the filer assumed the current class or type",
                        null=True,
                    ),
                ),
                (
                    "sub_category_type",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        choices=[
                            (0, "N/A"),
                            (40202, "BROAD-BASED"),
                            (40203, "SMALL CONTRIBUTOR"),
                            (40204, "MPO - NON PROFIT"),
                            (40205, "MPO - NON PROFIT CY"),
                            (40206, "MPO - OTHER"),
                            (40207, "MPO - OTHER CY"),
                            (40208, "FEDERAL PAC"),
                            (40209, "OUT OF STATE PAC"),
                        ],
                        db_column="SUB_CATEGORY_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=19, id="2774529-Lookup-Codes-Cd", start_page=18
                            )
                        ],
                        help_text="When applicable specifies broad based or small contributor",
                        null=True,
                    ),
                ),
                (
                    "election_type",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        choices=[
                            (0, "N/A"),
                            (3001, "GENERAL"),
                            (3002, "PRIMARY"),
                            (3003, "RECALL"),
                            (3004, "SPECIAL ELECTION"),
                            (3005, "OFFICEHOLDER"),
                            (3006, "SPECIAL RUNOFF"),
                            (3010, "Unknown"),
                            (3007, "Unknown"),
                        ],
                        db_column="ELECTION_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=4, id="2774529-Lookup-Codes-Cd", start_page=3
                            )
                        ],
                        help_text="Indicates type of election (general, primary, special)",
                        null=True,
                    ),
                ),
                (
                    "sub_category_a",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SUB_CATEGORY_A",
                        help_text="Indicates if sponsored or not",
                        max_length=1,
                    ),
                ),
                (
                    "nyq_dt",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="NYQ_DT",
                        help_text="Indicates the date when a committee reached its qualifying level of activity",
                        null=True,
                    ),
                ),
                (
                    "party_cd",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        choices=[
                            (16001, "DEMOCRATIC"),
                            (16002, "REPUBLICAN"),
                            (16003, "GREEN PARTY"),
                            (16004, "REFORM PARTY"),
                            (16005, "AMERICAN INDEPENDENT PARTY"),
                            (16006, "PEACE AND FREEDOM"),
                            (16007, "INDEPENDENT"),
                            (16008, "LIBERTARIAN"),
                            (16009, "NON PARTISAN"),
                            (16010, "NATURAL LAW"),
                            (16011, "UNKNOWN"),
                            (16012, "NO PARTY PREFERENCE"),
                            (16013, "AMERICANS ELECT"),
                            (16020, "PEACE AND FREEDOM"),
                            (16014, "UNKNOWN"),
                            (0, "UNKNOWN"),
                            (None, "NONE"),
                        ],
                        db_column="PARTY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=11, id="2774529-Lookup-Codes-Cd", start_page=10
                            )
                        ],
                        help_text="Filer's political party",
                        null=True,
                        verbose_name="party code",
                    ),
                ),
                (
                    "county_cd",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        choices=[
                            (0, "N/A"),
                            (18001, "01"),
                            (18002, "12"),
                            (18003, "23"),
                            (18004, "34"),
                            (18005, "45"),
                            (18006, "55"),
                            (18007, "56"),
                            (18008, "57"),
                            (18009, "58"),
                            (18010, "02"),
                            (18011, "03"),
                            (18012, "04"),
                            (18013, "05"),
                            (18014, "06"),
                            (18015, "07"),
                            (18016, "08"),
                            (18017, "09"),
                            (18018, "10"),
                            (18019, "11"),
                            (18020, "13"),
                            (18021, "14"),
                            (18022, "15"),
                            (18023, "16"),
                            (18024, "17"),
                            (18025, "18"),
                            (18026, "19"),
                            (18027, "20"),
                            (18028, "21"),
                            (18029, "22"),
                            (18030, "24"),
                            (18031, "25"),
                            (18032, "26"),
                            (18033, "27"),
                            (18034, "28"),
                            (18035, "29"),
                            (18036, "30"),
                            (18037, "31"),
                            (18038, "32"),
                            (18039, "33"),
                            (18040, "35"),
                            (18041, "36"),
                            (18042, "37"),
                            (18043, "38"),
                            (18044, "39"),
                            (18045, "40"),
                            (18046, "41"),
                            (18047, "42"),
                            (18048, "43"),
                            (18049, "44"),
                            (18050, "46"),
                            (18051, "47"),
                            (18052, "48"),
                            (18053, "49"),
                            (18054, "50"),
                            (18055, "51"),
                            (18056, "52"),
                            (18057, "53"),
                            (18058, "54"),
                        ],
                        db_column="COUNTY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=15, id="2774529-Lookup-Codes-Cd", start_page=13
                            )
                        ],
                        help_text="Filer's county code",
                        null=True,
                        verbose_name="county code",
                    ),
                ),
                (
                    "district_cd",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        choices=[
                            (0, "N/A"),
                            (17001, "01"),
                            (17002, "13"),
                            (17003, "24"),
                            (17004, "35"),
                            (17005, "46"),
                            (17006, "57"),
                            (17007, "68"),
                            (17008, "79"),
                            (17009, "02"),
                            (17010, "05"),
                            (17011, "04"),
                            (17013, "06"),
                            (17014, "07"),
                            (17015, "08"),
                            (17016, "19"),
                            (17017, "10"),
                            (17018, "11"),
                            (17019, "12"),
                            (17020, "14"),
                            (17021, "15"),
                            (17022, "16"),
                            (17023, "17"),
                            (17024, "18"),
                            (17026, "20"),
                            (17027, "21"),
                            (17028, "22"),
                            (17029, "23"),
                            (17030, "25"),
                            (17031, "26"),
                            (17032, "27"),
                            (17033, "28"),
                            (17034, "29"),
                            (17035, "30"),
                            (17036, "31"),
                            (17037, "32"),
                            (17038, "33"),
                            (17039, "34"),
                            (17040, "36"),
                            (17041, "37"),
                            (17042, "38"),
                            (17043, "39"),
                            (17044, "40"),
                            (17045, "41"),
                            (17046, "42"),
                            (17047, "43"),
                            (17048, "44"),
                            (17049, "45"),
                            (17050, "47"),
                            (17051, "48"),
                            (17052, "49"),
                            (17053, "50"),
                            (17054, "51"),
                            (17055, "52"),
                            (17056, "53"),
                            (17057, "54"),
                            (17058, "55"),
                            (17059, "56"),
                            (17060, "03"),
                            (17061, "59"),
                            (17062, "60"),
                            (17063, "61"),
                            (17064, "62"),
                            (17065, "63"),
                            (17066, "64"),
                            (17067, "65"),
                            (17068, "66"),
                            (17069, "67"),
                            (17070, "69"),
                            (17071, "70"),
                            (17072, "71"),
                            (17073, "72"),
                            (17074, "73"),
                            (17075, "74"),
                            (17076, "75"),
                            (17077, "76"),
                            (17078, "77"),
                            (17079, "78"),
                            (17080, "80"),
                            (17081, "09"),
                            (17090, "58"),
                            (17091, "Unknown"),
                            (17083, "Unknown"),
                            (17093, "Unknown"),
                            (17094, "Unknown"),
                            (17088, "Unknown"),
                            (17096, "Unknown"),
                            (17012, "Unknown"),
                            (17095, "Unknown"),
                            (17092, "Unknown"),
                            (17086, "Unknown"),
                            (17099, "Unknown"),
                            (17082, "Unknown"),
                            (17025, "Unknown"),
                            (17085, "Unknown"),
                            (17084, "Unknown"),
                            (17087, "Unknown"),
                            (17098, "Unknown"),
                            (17089, "Unknown"),
                        ],
                        db_column="DISTRICT_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=13, id="2774529-Lookup-Codes-Cd", start_page=11
                            )
                        ],
                        help_text="Filer's district number for the office being sought. Populated for Senate, Assembly or Board of Equalization races",
                        null=True,
                        verbose_name="county code",
                    ),
                ),
            ],
            options={
                "db_table": "FILER_TO_FILER_TYPE_CD",
                "verbose_name": "FILER_TO_FILER_TYPE_CD",
                "verbose_name_plural": "FILER_TO_FILER_TYPE_CD",
            },
        ),
        migrations.CreateModel(
            name="FilerTypePeriodsCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "election_type",
                    calaccess_raw.fields.IntegerField(
                        choices=[
                            (0, "N/A"),
                            (3001, "GENERAL"),
                            (3002, "PRIMARY"),
                            (3003, "RECALL"),
                            (3004, "SPECIAL ELECTION"),
                            (3005, "OFFICEHOLDER"),
                            (3006, "SPECIAL RUNOFF"),
                        ],
                        db_column="ELECTION_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=4, id="2774529-Lookup-Codes-Cd", start_page=3
                            )
                        ],
                        help_text="Election type",
                    ),
                ),
            ],
            options={
                "db_table": "FILER_TYPE_PERIODS_CD",
                "verbose_name": "FILER_TYPE_PERIODS_CD",
                "verbose_name_plural": "FILER_TYPE_PERIODS_CD",
            },
        ),
        migrations.CreateModel(
            name="FilerTypesCd",
            fields=[
                (
                    "filer_type",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILER_TYPE",
                        help_text="Filer type identification number",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "description",
                    calaccess_raw.fields.CharField(
                        db_column="DESCRIPTION",
                        help_text="Description of the filer type",
                        max_length=255,
                    ),
                ),
                (
                    "grp_type",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        choices=[
                            (58, "LOBBY PERIODS"),
                            (59, "CAMPAIGN PERIODS"),
                            (60, "DEFAULT PERIOD FOR ERRONEOUS DATA"),
                            (61, "Unknown"),
                        ],
                        db_column="GRP_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2774529-Lookup-Codes-Cd", start_page=4
                            )
                        ],
                        help_text="Group type assocated with the filer type",
                        null=True,
                    ),
                ),
                (
                    "calc_use",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CALC_USE",
                        help_text="Use checkbox flag",
                        max_length=1,
                    ),
                ),
                (
                    "grace_period",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="GRACE_PERIOD",
                        help_text="This field is undocumented",
                        max_length=12,
                    ),
                ),
            ],
            options={
                "ordering": ("filer_type",),
                "db_table": "FILER_TYPES_CD",
                "verbose_name": "FILER_TYPES_CD",
                "verbose_name_plural": "FILER_TYPES_CD",
            },
        ),
        migrations.CreateModel(
            name="FilerXrefCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILER_ID",
                        db_index=True,
                        help_text="Filer's unique identification number",
                        null=True,
                        verbose_name="filer ID",
                    ),
                ),
                (
                    "xref_id",
                    calaccess_raw.fields.CharField(
                        db_column="XREF_ID",
                        db_index=True,
                        help_text="Alternative filer ID found on many forms",
                        max_length=32,
                        verbose_name="crossreference filer ID",
                    ),
                ),
                (
                    "effect_dt",
                    calaccess_raw.fields.DateField(
                        db_column="EFFECT_DT",
                        help_text="Effective date",
                        null=True,
                        verbose_name="Effective date",
                    ),
                ),
                (
                    "migration_source",
                    calaccess_raw.fields.CharField(
                        db_column="MIGRATION_SOURCE",
                        help_text="Source of the XREF_ID. Migration or generated by the AMS.",
                        max_length=50,
                    ),
                ),
            ],
            options={
                "db_table": "FILER_XREF_CD",
                "verbose_name": "FILER_XREF_CD",
                "verbose_name_plural": "FILER_XREF_CD",
            },
        ),
        migrations.CreateModel(
            name="FilingPeriodCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "period_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="PERIOD_ID",
                        help_text="Unique period identification number",
                    ),
                ),
                (
                    "start_date",
                    calaccess_raw.fields.DateField(
                        db_column="START_DATE",
                        help_text="Starting date for period",
                        null=True,
                    ),
                ),
                (
                    "end_date",
                    calaccess_raw.fields.DateField(
                        db_column="END_DATE",
                        help_text="Ending date of period",
                        null=True,
                    ),
                ),
                (
                    "period_type",
                    calaccess_raw.fields.IntegerField(
                        choices=[(1500, "Standard period")],
                        db_column="PERIOD_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2774529-Lookup-Codes-Cd", start_page=3
                            )
                        ],
                        help_text="Type of filing period",
                    ),
                ),
                (
                    "per_grp_type",
                    calaccess_raw.fields.IntegerField(
                        choices=[(1500, "STANDARD PERIOD")],
                        db_column="PER_GRP_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2774529-Lookup-Codes-Cd", start_page=3
                            )
                        ],
                        help_text="Period group type",
                    ),
                ),
                (
                    "period_desc",
                    calaccess_raw.fields.CharField(
                        db_column="PERIOD_DESC",
                        help_text="Period description",
                        max_length=255,
                    ),
                ),
                (
                    "deadline",
                    calaccess_raw.fields.DateField(
                        db_column="DEADLINE", help_text="Deadline date", null=True
                    ),
                ),
            ],
            options={
                "ordering": ("-end_date",),
                "db_table": "FILING_PERIOD_CD",
                "verbose_name": "FILING_PERIOD_CD",
                "verbose_name_plural": "FILING_PERIOD_CD",
            },
        ),
        migrations.CreateModel(
            name="FilingsCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "filing_type",
                    calaccess_raw.fields.IntegerField(
                        choices=[
                            (22001, "Electronic"),
                            (22002, "Key data entry"),
                            (22003, "Historical lobby"),
                            (22004, "Historical campaign"),
                            (22005, "AMS"),
                            (22006, "Cal Online"),
                        ],
                        db_column="FILING_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711615-FAQ", start_page=2
                            )
                        ],
                        help_text="The type of filing",
                    ),
                ),
            ],
            options={
                "db_table": "FILINGS_CD",
                "verbose_name": "FILINGS_CD",
                "verbose_name_plural": "FILINGS_CD",
            },
        ),
        migrations.CreateModel(
            name="GroupTypesCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "grp_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="GRP_ID",
                        help_text="Group identification number",
                        verbose_name="Group ID",
                    ),
                ),
                (
                    "grp_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="GRP_NAME",
                        help_text="Group name. Many of the values in this column are empty strings.",
                        max_length=28,
                        verbose_name="Group name",
                    ),
                ),
                (
                    "grp_desc",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="GRP_DESC",
                        help_text="Group Description. This column contains only empty strings.",
                        max_length=32,
                        verbose_name="Group description",
                    ),
                ),
            ],
            options={
                "db_table": "GROUP_TYPES_CD",
                "verbose_name": "GROUP_TYPES_CD",
                "verbose_name_plural": "GROUP_TYPES_CD",
            },
        ),
        migrations.CreateModel(
            name="HdrCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "cal_ver",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAL_VER",
                        help_text="CAL Version number the filing was made using",
                        max_length=4,
                    ),
                ),
                (
                    "ef_type",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[("CAL", ".CAL format")],
                        db_column="EF_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=4
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=5
                            ),
                        ],
                        help_text='Electronic filing type. This will always have the         value of "CAL".',
                        max_length=3,
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "hdr_comment",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="HDRCOMMENT",
                        help_text="Typically used for development and test filings",
                        max_length=200,
                        verbose_name="Header comment",
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("HDR", "HDR")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=4
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=5
                            ),
                        ],
                        help_text="Record Type. Value: HDR",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "soft_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SOFT_NAME",
                        help_text="Filing software name used to electronically file",
                        max_length=90,
                    ),
                ),
                (
                    "soft_ver",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SOFT_VER",
                        help_text="Filing software version number",
                        max_length=16,
                    ),
                ),
                (
                    "state_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[("CA", "California")],
                        db_column="STATE_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=4
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=5
                            ),
                        ],
                        help_text="The state code value entered in the electronic filing",
                        max_length=2,
                        verbose_name="State code",
                    ),
                ),
            ],
            options={
                "db_table": "HDR_CD",
                "verbose_name": "HDR_CD",
                "verbose_name_plural": "HDR_CD",
            },
        ),
        migrations.CreateModel(
            name="HeaderCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_number",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_NUMBER", help_text="This field is undocumented"
                    ),
                ),
                (
                    "form_id",
                    calaccess_raw.fields.CharField(
                        choices=[
                            ("AF490", "Form 490, Part A"),
                            ("AP1", "Allocation Part 1"),
                            ("AP2", "Allocation Part 2"),
                            ("BF490", "Form 490, Part B"),
                            ("CF490", "Form 490, Part C"),
                            ("DF490", "Form 490, Part D"),
                            ("EF490", "Form 490, Part E"),
                            (
                                "F450",
                                b"Form 450: Recipient Committee Campaign Disclosure Statement - Short Form",
                            ),
                            (
                                "F460",
                                b"Form 460: Recipient Committee Campaign Statement",
                            ),
                            (
                                "F461",
                                b"Form 461: Independent Expenditure Committee & Major Donor Committee Campaign Statement",
                            ),
                            ("FF490", "Form 490, Part F"),
                            ("HF490", "Form 490, Part H"),
                            ("IF490", "Form 490, Part I"),
                        ],
                        db_column="FORM_ID",
                        help_text="Form identification code",
                        max_length=5,
                        verbose_name="Form ID",
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            ("AP1", "AP1"),
                            ("AP2", "AP2"),
                            ("SMRY_HEADER", "SMRY_HEADER"),
                        ],
                        db_column="REC_TYPE",
                        db_index=True,
                        help_text="Record Type",
                        max_length=11,
                        verbose_name="record type",
                    ),
                ),
                (
                    "section_label",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SECTION_LABEL",
                        help_text="This field is undocumented",
                        max_length=58,
                    ),
                ),
                (
                    "comments1",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="COMMENTS1",
                        help_text="This field is undocumented",
                        max_length=48,
                    ),
                ),
                (
                    "comments2",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="COMMENTS2",
                        help_text="This field is undocumented",
                        max_length=48,
                    ),
                ),
                (
                    "label",
                    calaccess_raw.fields.CharField(
                        db_column="LABEL",
                        help_text="This field is undocumented",
                        max_length=98,
                    ),
                ),
                (
                    "column_a",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="COLUMN_A",
                        help_text="This field is undocumented",
                        null=True,
                    ),
                ),
                (
                    "column_b",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="COLUMN_B",
                        help_text="This field is undocumented",
                        null=True,
                    ),
                ),
                (
                    "column_c",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="COLUMN_C",
                        help_text="This field is undocumented",
                        null=True,
                    ),
                ),
                (
                    "show_c",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="SHOW_C",
                        help_text="This field is undocumented",
                        null=True,
                    ),
                ),
                (
                    "show_b",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="SHOW_B",
                        help_text="This field is undocumented",
                        null=True,
                    ),
                ),
            ],
            options={
                "db_table": "HEADER_CD",
                "verbose_name": "HEADER_CD",
                "verbose_name_plural": "HEADER_CD",
            },
        ),
        migrations.CreateModel(
            name="ImageLinksCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "img_link_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="IMG_LINK_ID",
                        help_text="Image link identification number",
                        verbose_name="Image link ID",
                    ),
                ),
                (
                    "img_link_type",
                    calaccess_raw.fields.IntegerField(
                        choices=[(6501, "FILING ID"), (6502, "FILER ID")],
                        db_column="IMG_LINK_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2774529-Lookup-Codes-Cd", start_page=5
                            )
                        ],
                        help_text="Type of image link",
                        verbose_name="Image link type",
                    ),
                ),
                (
                    "img_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="IMG_ID",
                        help_text="Image identification number",
                        verbose_name="Image ID",
                    ),
                ),
                (
                    "img_type",
                    calaccess_raw.fields.IntegerField(
                        choices=[
                            (6001, "FAX"),
                            (6002, "PERSONAL PHOTO"),
                            (6004, "SCANNED CHECK"),
                            (6005, "SCANNED LETTER"),
                            (6007, "IMAGE TYPES"),
                        ],
                        db_column="IMG_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2774529-Lookup-Codes-Cd", start_page=4
                            )
                        ],
                        help_text="Type of image",
                        verbose_name="Image type",
                    ),
                ),
                (
                    "img_dt",
                    calaccess_raw.fields.DateField(
                        db_column="IMG_DT",
                        help_text="Image date",
                        null=True,
                        verbose_name="Image date",
                    ),
                ),
            ],
            options={
                "db_table": "IMAGE_LINKS_CD",
                "verbose_name": "IMAGE_LINKS_CD",
                "verbose_name_plural": "IMAGE_LINKS_CD",
            },
        ),
        migrations.CreateModel(
            name="LattCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "amount",
                    calaccess_raw.fields.DecimalField(
                        db_column="AMOUNT",
                        decimal_places=2,
                        help_text="Amount of payment",
                        max_digits=16,
                    ),
                ),
                (
                    "cum_amt",
                    calaccess_raw.fields.DecimalField(
                        db_column="CUM_AMT",
                        decimal_places=2,
                        help_text="Cumulative total to date",
                        max_digits=16,
                    ),
                ),
                (
                    "cumbeg_dt",
                    calaccess_raw.fields.DateField(
                        db_column="CUMBEG_DT",
                        help_text="Cumulative period beginning to date",
                        null=True,
                    ),
                ),
                (
                    "entity_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("FRM", b"Lobbying Firm"),
                            ("IND", b"Person (spending > $5000)"),
                            ("LBY", b"Lobbyist (an individual)"),
                            ("LCO", b"Lobbying Coalition"),
                            ("LEM", b"Lobbying Employer"),
                            ("OTH", b"Other"),
                            ("RCP", b"Recipient Committee"),
                        ],
                        db_column="ENTITY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=65
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=80
                            ),
                        ],
                        help_text="Entity Code of the Payment Recipient/Payee",
                        max_length=3,
                        verbose_name="entity code",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"S630",
                                b"Schedule 630: Payments Made to Lobbying Coalitions (Attachment to Form 625 or 635) ",
                            ),
                            (
                                b"S635-C",
                                b"Schedule 635C: Payments Received by Lobbying Coalitions",
                            ),
                            (
                                b"S640",
                                b"Schedule 640: Governmental Agencies Reporting (Attachment to Form 635 or Form 645)",
                            ),
                        ],
                        db_column="FORM_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=52
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=65
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=79
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=6,
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                    ),
                ),
                (
                    "memo_code",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_CODE",
                        help_text="Memo amount flag",
                        max_length=1,
                    ),
                ),
                (
                    "memo_refno",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_REFNO",
                        help_text="Reference to the text in a TEXT record",
                        max_length=20,
                    ),
                ),
                (
                    "pmt_date",
                    calaccess_raw.fields.DateField(
                        db_column="PMT_DATE", help_text="Date of payment", null=True
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("LATT", "LATT")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=65
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=79
                            ),
                        ],
                        help_text="Record Type Value: LATT",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "recip_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RECIP_CITY",
                        help_text="Recipient city",
                        max_length=30,
                    ),
                ),
                (
                    "recip_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RECIP_NAMF",
                        help_text="Recipient first name",
                        max_length=45,
                    ),
                ),
                (
                    "recip_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RECIP_NAML",
                        help_text="Recipient last name or business name",
                        max_length=200,
                    ),
                ),
                (
                    "recip_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RECIP_NAMS",
                        help_text="Recipient suffix",
                        max_length=10,
                    ),
                ),
                (
                    "recip_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RECIP_NAMT",
                        help_text="Recipient title or prefix",
                        max_length=10,
                    ),
                ),
                (
                    "recip_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RECIP_ST",
                        help_text="Recipient state",
                        max_length=2,
                    ),
                ),
                (
                    "recip_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RECIP_ZIP4",
                        help_text="Recipient ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "tran_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRAN_ID",
                        help_text="Permanent value unique to this item",
                        max_length=20,
                        verbose_name="transaction ID",
                    ),
                ),
            ],
            options={
                "db_table": "LATT_CD",
                "verbose_name": "LATT_CD",
                "verbose_name_plural": "LATT_CD",
            },
        ),
        migrations.CreateModel(
            name="LccmCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "amount",
                    calaccess_raw.fields.DecimalField(
                        db_column="AMOUNT",
                        decimal_places=2,
                        help_text="Amount of contribution",
                        max_digits=16,
                    ),
                ),
                (
                    "bakref_tid",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAKREF_TID",
                        help_text="Back reference to transaction identifier of parent record",
                        max_length=20,
                    ),
                ),
                (
                    "ctrib_date",
                    calaccess_raw.fields.DateField(
                        db_column="CTRIB_DATE",
                        help_text="Date of contribution",
                        null=True,
                    ),
                ),
                (
                    "ctrib_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CTRIB_NAMF",
                        help_text="Contributor first name",
                        max_length=45,
                    ),
                ),
                (
                    "ctrib_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CTRIB_NAML",
                        help_text="Contributor last name or business name",
                        max_length=200,
                    ),
                ),
                (
                    "ctrib_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CTRIB_NAMS",
                        help_text="Contributor suffix",
                        max_length=10,
                    ),
                ),
                (
                    "ctrib_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CTRIB_NAMT",
                        help_text="Contributor prefix or title.",
                        max_length=10,
                    ),
                ),
                (
                    "entity_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("COM", b"Committee"),
                            ("RCP", b"Recipient Committee"),
                            ("CTL", b"Controlled committee"),
                        ],
                        db_column="ENTITY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=64
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=78
                            ),
                        ],
                        help_text="Entity Code for Recipient of the Campaign Contribution Value",
                        max_length=3,
                        verbose_name="entity code",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"F615P2",
                                b"Form 615 (Lobbyist Report): Part 2, Campaign Contributions Made or Delivered",
                            ),
                            (
                                b"F625P4B",
                                b"Form 625 (Report of Lobbying Firm): Part 4: Campaign Contributions Made",
                            ),
                            (
                                b"F635P4B",
                                b"Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 4: Campaign Contributions Made",
                            ),
                            (
                                b"F645P3B",
                                b"Form 645 (Report of Person Spending $5,000 or More): Part 3: Campaign Contributions Made",
                            ),
                        ],
                        db_column="FORM_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=64
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=79, id="2712034-Cal-Format-201", start_page=78
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=7,
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                    ),
                ),
                (
                    "memo_code",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_CODE",
                        help_text="Memo amount flag",
                        max_length=1,
                    ),
                ),
                (
                    "memo_refno",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_REFNO",
                        help_text="Reference to the text contained in the TEXT record",
                        max_length=20,
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("LCCM", "LCCM")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=64
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=78
                            ),
                        ],
                        help_text="Record Type Value: LCCM",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "recip_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RECIP_CITY",
                        help_text="Recipient city",
                        max_length=30,
                    ),
                ),
                (
                    "recip_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RECIP_ID",
                        help_text="Recipient identification number",
                        max_length=9,
                    ),
                ),
                (
                    "recip_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RECIP_NAMF",
                        help_text="Recipient first name",
                        max_length=45,
                    ),
                ),
                (
                    "recip_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RECIP_NAML",
                        help_text="Recipient last name",
                        max_length=200,
                    ),
                ),
                (
                    "recip_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RECIP_NAMS",
                        help_text="Recipient name suffix",
                        max_length=10,
                    ),
                ),
                (
                    "recip_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RECIP_NAMT",
                        help_text="Recipient name prefix or title",
                        max_length=10,
                    ),
                ),
                (
                    "recip_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RECIP_ST",
                        help_text="Recipient state",
                        max_length=2,
                    ),
                ),
                (
                    "recip_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RECIP_ZIP4",
                        help_text="Recipient ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "tran_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRAN_ID",
                        help_text="Permanent value unique to this item",
                        max_length=20,
                        verbose_name="transaction ID",
                    ),
                ),
            ],
            options={
                "db_table": "LCCM_CD",
                "verbose_name": "LCCM_CD",
                "verbose_name_plural": "LCCM_CD",
            },
        ),
        migrations.CreateModel(
            name="LegislativeSessionsCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "session_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_ID",
                        help_text="Legislative session identification number",
                        null=True,
                        verbose_name="session ID",
                    ),
                ),
                (
                    "begin_date",
                    calaccess_raw.fields.DateField(
                        db_column="BEGIN_DATE",
                        help_text="Session start date",
                        null=True,
                    ),
                ),
                (
                    "end_date",
                    calaccess_raw.fields.DateField(
                        db_column="END_DATE", help_text="Session end date", null=True
                    ),
                ),
            ],
            options={
                "db_table": "LEGISLATIVE_SESSIONS_CD",
                "verbose_name": "LEGISLATIVE_SESSIONS_CD",
                "verbose_name_plural": "LEGISLATIVE_SESSIONS_CD",
            },
        ),
        migrations.CreateModel(
            name="LempCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "agencylist",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="AGENCYLIST",
                        help_text="Agencies to be lobbied",
                        max_length=200,
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "cli_city",
                    calaccess_raw.fields.CharField(
                        db_column="CLI_CITY",
                        help_text="Employing client city",
                        max_length=30,
                    ),
                ),
                (
                    "cli_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CLI_NAMF",
                        help_text="Employing client first name",
                        max_length=45,
                    ),
                ),
                (
                    "cli_naml",
                    calaccess_raw.fields.CharField(
                        db_column="CLI_NAML",
                        help_text="Employing client last name",
                        max_length=200,
                    ),
                ),
                (
                    "cli_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CLI_NAMS",
                        help_text="Employing client suffix",
                        max_length=10,
                    ),
                ),
                (
                    "cli_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CLI_NAMT",
                        help_text="Employing client prefix or title",
                        max_length=10,
                    ),
                ),
                (
                    "cli_phon",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CLI_PHON",
                        help_text="Employing client phone number",
                        max_length=20,
                    ),
                ),
                (
                    "cli_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CLI_ST",
                        help_text="Employing client state",
                        max_length=2,
                    ),
                ),
                (
                    "cli_zip4",
                    calaccess_raw.fields.CharField(
                        db_column="CLI_ZIP4",
                        help_text="Employing client ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "client_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CLIENT_ID",
                        help_text="Identification number of the Part 2A employer or Part 2B Client/Employer",
                        max_length=9,
                    ),
                ),
                (
                    "con_period",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CON_PERIOD",
                        help_text="Period of the contract",
                        max_length=30,
                    ),
                ),
                (
                    "descrip",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="DESCRIP",
                        help_text="Description of employer/client lobbying interest",
                        max_length=100,
                    ),
                ),
                (
                    "eff_date",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="EFF_DATE",
                        help_text="Effective Date of Lobbying Contract",
                        null=True,
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"F601P2A",
                                b"Form 601 (Lobbying Firm Registration Statement): Part 2: Section A, Lobbyist Employers",
                            ),
                            (
                                b"F601P2B",
                                b"Form 601 (Lobbying Firm Registration Statement): Part 2: Section B: Subcontracted Clients",
                            ),
                        ],
                        db_column="FORM_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=75
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=90
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=7,
                        verbose_name="form type",
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("LEMP", "LEMP")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=75
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=90
                            ),
                        ],
                        help_text="Record Type Value: LEMP",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "sub_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SUB_CITY",
                        help_text="Subcontracting lobbying firm city",
                        max_length=30,
                    ),
                ),
                (
                    "sub_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SUB_NAME",
                        help_text="Subcontracting lobbying firms name",
                        max_length=200,
                    ),
                ),
                (
                    "sub_phon",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SUB_PHON",
                        help_text="Subcontracting lobbying firm phone number",
                        max_length=20,
                    ),
                ),
                (
                    "sub_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SUB_ST",
                        help_text="Subcontracting lobbying firm state",
                        max_length=2,
                    ),
                ),
                (
                    "sub_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SUB_ZIP4",
                        help_text="Subcontracting lobbying firm ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "subfirm_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SUBFIRM_ID",
                        help_text="Identification number of subcontracting lobbying firm",
                        max_length=9,
                    ),
                ),
            ],
            options={
                "db_table": "LEMP_CD",
                "verbose_name": "LEMP_CD",
                "verbose_name_plural": "LEMP_CD",
            },
        ),
        migrations.CreateModel(
            name="LexpCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "amount",
                    calaccess_raw.fields.DecimalField(
                        blank=True,
                        db_column="AMOUNT",
                        decimal_places=2,
                        help_text="Amount of payment",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "bakref_tid",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAKREF_TID",
                        help_text="Backreference to the tranaction identifer of parent record",
                        max_length=20,
                    ),
                ),
                (
                    "bene_amt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BENE_AMT",
                        help_text="Amount benefiting benficiary",
                        max_length=12,
                    ),
                ),
                (
                    "bene_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BENE_NAME",
                        help_text="Name of the person beneifiting",
                        max_length=90,
                    ),
                ),
                (
                    "bene_posit",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BENE_POSIT",
                        help_text="Official position of the person beneifiting",
                        max_length=90,
                    ),
                ),
                (
                    "credcardco",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CREDCARDCO",
                        help_text="Name of the credit card company, if paid using a card",
                        max_length=200,
                    ),
                ),
                (
                    "entity_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("IND", b"Person (spending > $5000)"),
                            ("OTH", b"Other"),
                        ],
                        db_column="ENTITY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=61
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=75
                            ),
                        ],
                        help_text="Entity Code of the Payee",
                        max_length=3,
                        verbose_name="entity code",
                    ),
                ),
                (
                    "expn_date",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="EXPN_DATE",
                        help_text="Date of expenditure",
                        null=True,
                    ),
                ),
                (
                    "expn_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EXPN_DSCR",
                        help_text="Purpose of the expense and a description or explanation",
                        max_length=90,
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"F615P1",
                                b"Form 615 (Lobbyist Report): Part 1, Activity Expenses Paid, Incurred, Arranged or Provided by the Lobbyist",
                            ),
                            (
                                b"F625P3A",
                                b"Form 625 (Report of Lobbying Firm): Part 3 (Payments Made In Connection With Lobbying Activities), Section A: Activity Expenses",
                            ),
                            (
                                b"F635P3C",
                                b"Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3 (Payments Made in Connection with Lobbying Activities), Section C: Activity Expenses",
                            ),
                            (
                                b"F645P2A",
                                b"Form 645 (Report of Person Spending $5,000 or More): Part 2 (Payments Made this Period), Section A: Activity Expenses",
                            ),
                        ],
                        db_column="FORM_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=61
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=74
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=7,
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                    ),
                ),
                (
                    "memo_code",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_CODE",
                        help_text="Memo amount flag",
                        max_length=1,
                    ),
                ),
                (
                    "memo_refno",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_REFNO",
                        help_text="Reference to the text in a TEXT record",
                        max_length=20,
                    ),
                ),
                (
                    "payee_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_CITY",
                        help_text="Payee city",
                        max_length=30,
                    ),
                ),
                (
                    "payee_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_NAMF",
                        help_text="Payee first name",
                        max_length=45,
                    ),
                ),
                (
                    "payee_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_NAML",
                        help_text="Payee last name or business name",
                        max_length=200,
                    ),
                ),
                (
                    "payee_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_NAMS",
                        help_text="Payee suffix",
                        max_length=10,
                    ),
                ),
                (
                    "payee_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_NAMT",
                        help_text="Payee title or prefix",
                        max_length=10,
                    ),
                ),
                (
                    "payee_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_ST",
                        help_text="Payee state",
                        max_length=2,
                    ),
                ),
                (
                    "payee_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_ZIP4",
                        help_text="Payee ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("LEXP", "LEXP")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=61
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=74
                            ),
                        ],
                        help_text="Record Type Value: LEXP",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "recsubtype",
                    calaccess_raw.fields.CharField(
                        choices=[("1", "Main"), ("2", "Detail")],
                        db_column="RECSUBTYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=61
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=74
                            ),
                        ],
                        help_text="Record Subtype",
                        max_length=1,
                        verbose_name="record subtype",
                    ),
                ),
                (
                    "tran_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRAN_ID",
                        help_text="Permanent value unique to this item",
                        max_length=20,
                        verbose_name="transaction ID",
                    ),
                ),
            ],
            options={
                "db_table": "LEXP_CD",
                "verbose_name": "LEXP_CD",
                "verbose_name_plural": "LEXP_CD",
            },
        ),
        migrations.CreateModel(
            name="LoanCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "bakref_tid",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAKREF_TID",
                        help_text="Back Reference to transaction identifier of parent record",
                        max_length=20,
                    ),
                ),
                (
                    "cmte_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CMTE_ID",
                        help_text="Committee identification number",
                        max_length=9,
                        verbose_name="Committee ID",
                    ),
                ),
                (
                    "entity_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("COM", b"Committee"),
                            ("IND", b"Individual"),
                            ("OTH", b"Other"),
                            ("PTY", b"Political Party"),
                            ("RCP", b"Recipient committee"),
                            ("SCC", b"Small Contributor Committee"),
                        ],
                        db_column="ENTITY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=35
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=47
                            ),
                        ],
                        help_text="Entity code describing the lender",
                        max_length=3,
                        verbose_name="entity code",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"B1",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule B - Part 1, Loans Received",
                            ),
                            (
                                b"B2",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule B - Part 2, Loan Guarantors",
                            ),
                            (
                                b"B3",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule B - Part 3, Outstanding Bal",
                            ),
                            (
                                b"H",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule H, Loans Made to Others",
                            ),
                            (
                                b"H1",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule H - Part 1, Loans Made",
                            ),
                            (
                                b"H2",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule H- Part 2, Repayments Rcvd",
                            ),
                            (
                                b"H3",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule H - Part 3, Outstanding Loans",
                            ),
                        ],
                        db_column="FORM_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=35
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=47
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=2,
                    ),
                ),
                (
                    "intr_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INTR_CITY",
                        help_text="Intermediary's city",
                        max_length=30,
                    ),
                ),
                (
                    "intr_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INTR_NAMF",
                        help_text="Intermediary's first name",
                        max_length=45,
                    ),
                ),
                (
                    "intr_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INTR_NAML",
                        help_text="Intermediary's last name",
                        max_length=200,
                    ),
                ),
                (
                    "intr_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INTR_NAMS",
                        help_text="Intermediary's suffix",
                        max_length=10,
                    ),
                ),
                (
                    "intr_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INTR_NAMT",
                        help_text="Intermediary's title or prefix",
                        max_length=10,
                    ),
                ),
                (
                    "intr_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INTR_ST",
                        help_text="Intermediary's state",
                        max_length=2,
                    ),
                ),
                (
                    "intr_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INTR_ZIP4",
                        help_text="Intermediary's ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                    ),
                ),
                (
                    "lndr_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LNDR_NAMF",
                        help_text="Lender's first name",
                        max_length=45,
                    ),
                ),
                (
                    "lndr_naml",
                    calaccess_raw.fields.CharField(
                        db_column="LNDR_NAML",
                        help_text="Lender's last name or business name",
                        max_length=200,
                    ),
                ),
                (
                    "lndr_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LNDR_NAMS",
                        help_text="Lender's suffix",
                        max_length=10,
                    ),
                ),
                (
                    "lndr_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LNDR_NAMT",
                        help_text="Lender's title or prefix",
                        max_length=10,
                    ),
                ),
                (
                    "loan_amt1",
                    calaccess_raw.fields.DecimalField(
                        blank=True,
                        db_column="LOAN_AMT1",
                        decimal_places=2,
                        help_text="Repaid or forgiven amount; Original loan amount. The content of this column varies based on the schedule/part that the record applies to. See the CAL document for a description of the value of this field.",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "loan_amt2",
                    calaccess_raw.fields.DecimalField(
                        blank=True,
                        db_column="LOAN_AMT2",
                        decimal_places=2,
                        help_text="Outstanding Principal; unpaid balance. The content of this column varies based on the schedule/part that the record applies to. See the CAL document for a description of the value of this field.",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "loan_amt3",
                    calaccess_raw.fields.DecimalField(
                        blank=True,
                        db_column="LOAN_AMT3",
                        decimal_places=2,
                        help_text="Interest Paid; Unpaid interest; Interest received. The content of this column varies based on the schedule/part that the record applies to. See the CAL document for a description of the value of this field.",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "loan_amt4",
                    calaccess_raw.fields.DecimalField(
                        blank=True,
                        db_column="LOAN_AMT4",
                        decimal_places=2,
                        help_text="Cumulative Amount/Other. The content of this column varies based on the schedule/part that the record applies to. See the CAL document for a description of the value of this field.",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "loan_amt5",
                    calaccess_raw.fields.DecimalField(
                        blank=True,
                        db_column="LOAN_AMT5",
                        decimal_places=2,
                        help_text="This field is undocumented",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "loan_amt6",
                    calaccess_raw.fields.DecimalField(
                        blank=True,
                        db_column="LOAN_AMT6",
                        decimal_places=2,
                        help_text="This field is undocumented",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "loan_amt7",
                    calaccess_raw.fields.DecimalField(
                        blank=True,
                        db_column="LOAN_AMT7",
                        decimal_places=2,
                        help_text="This field is undocumented",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "loan_amt8",
                    calaccess_raw.fields.DecimalField(
                        blank=True,
                        db_column="LOAN_AMT8",
                        decimal_places=2,
                        help_text="This field is undocumented",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "loan_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LOAN_CITY",
                        help_text="Lender's city",
                        max_length=30,
                    ),
                ),
                (
                    "loan_date1",
                    calaccess_raw.fields.DateField(
                        db_column="LOAN_DATE1",
                        help_text="Date the loan was made or recieved. The content of this column varies based on the schedule/part that the record applies to. See the CAL document for a description of the value.",
                        null=True,
                    ),
                ),
                (
                    "loan_date2",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="LOAN_DATE2",
                        help_text="Date repaid/forgiven; date loan due. The content of this column varies based on the schedule/part that the record applies to. See the CAL document for a description of the value of this field.",
                        null=True,
                    ),
                ),
                (
                    "loan_emp",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LOAN_EMP",
                        help_text="Loan employer. Applies to the Form 460 Schedule B Part 1.",
                        max_length=200,
                    ),
                ),
                (
                    "loan_occ",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LOAN_OCC",
                        help_text="Loan occupation. Applies to the Form 460 Schedule B Part 1.",
                        max_length=60,
                    ),
                ),
                (
                    "loan_rate",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LOAN_RATE",
                        help_text="Interest Rate. The content of this column varies based on the schedule/part that the record applies to. See the CAL document for a description of the value of this field.",
                        max_length=30,
                    ),
                ),
                (
                    "loan_self",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LOAN_SELF",
                        help_text="Self-employed checkbox",
                        max_length=1,
                    ),
                ),
                (
                    "loan_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LOAN_ST",
                        help_text="Lender's state",
                        max_length=2,
                    ),
                ),
                (
                    "loan_type",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("H2T", "Third party payment"),
                            ("H2F", "Forgiven"),
                            ("H2R", "Repay"),
                            ("B2T", "Third party payment"),
                            ("B2F", "Forgiven"),
                            ("B2R", "Repay"),
                            ("B1G", "Guarantor"),
                            ("B1L", "Lender"),
                        ],
                        db_column="LOAN_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=35
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=47
                            ),
                        ],
                        help_text="Type of loan",
                        max_length=3,
                    ),
                ),
                (
                    "loan_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LOAN_ZIP4",
                        help_text="Lender's ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "memo_code",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_CODE",
                        help_text="Memo amount flag",
                        max_length=1,
                    ),
                ),
                (
                    "memo_refno",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_REFNO",
                        help_text="Reference to text contained in a TEXT record",
                        max_length=20,
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("LOAN", "LOAN")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=35
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=47
                            ),
                        ],
                        help_text="Record Type Value: LOAN",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "tran_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRAN_ID",
                        help_text="Permanent value unique to this item",
                        max_length=20,
                        verbose_name="transaction ID",
                    ),
                ),
                (
                    "tres_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_CITY",
                        help_text="Treasurer or responsible officer's city",
                        max_length=30,
                    ),
                ),
                (
                    "tres_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAMF",
                        help_text="Treasurer or responsible officer's first name",
                        max_length=45,
                    ),
                ),
                (
                    "tres_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAML",
                        help_text="Treasurer or responsible officer's last name",
                        max_length=200,
                    ),
                ),
                (
                    "tres_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAMS",
                        help_text="Treasurer or responsible officer's suffix",
                        max_length=10,
                    ),
                ),
                (
                    "tres_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAMT",
                        help_text="Treasurer or responsible officer's title or prefix",
                        max_length=10,
                    ),
                ),
                (
                    "tres_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_ST",
                        help_text="Treasurer or responsible officer's street address",
                        max_length=2,
                    ),
                ),
                (
                    "tres_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_ZIP4",
                        help_text="Treasurer or responsible officer's ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "xref_match",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="XREF_MATCH",
                        help_text='Related item on other schedule has same transaction identifier. "X" indicates this condition is true.',
                        max_length=1,
                    ),
                ),
                (
                    "xref_schnm",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="XREF_SCHNM",
                        help_text="Related record is included on Form 460 Schedule 'A' or 'E'",
                        max_length=2,
                    ),
                ),
            ],
            options={
                "db_table": "LOAN_CD",
                "verbose_name": "LOAN_CD",
                "verbose_name_plural": "LOAN_CD",
            },
        ),
        migrations.CreateModel(
            name="LobbyAmendmentsCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("F605", "F605")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=74
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=88
                            ),
                        ],
                        help_text="Record Type Value: F605",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"F601",
                                b"Form 601: Lobbying Firm Registration Statement",
                            ),
                            (
                                b"F603",
                                b"Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                            ),
                        ],
                        db_column="FORM_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=74
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=88
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=9,
                    ),
                ),
                (
                    "exec_date",
                    calaccess_raw.fields.DateField(
                        db_column="EXEC_DATE",
                        help_text="Date this amendment executed on",
                        max_length=22,
                        verbose_name="executed date",
                    ),
                ),
                (
                    "from_date",
                    calaccess_raw.fields.DateField(
                        db_column="FROM_DATE",
                        help_text="Reporting period from date of original report",
                        max_length=22,
                        verbose_name="reported from date",
                    ),
                ),
                (
                    "thru_date",
                    calaccess_raw.fields.DateField(
                        db_column="THRU_DATE",
                        help_text="Reporting date to/through date of original",
                        max_length=22,
                        verbose_name="reported through date",
                    ),
                ),
                (
                    "add_l_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ADD_L_CB",
                        help_text="Add lobbyist checkbox",
                        max_length=1,
                    ),
                ),
                (
                    "add_l_eff",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="ADD_L_EFF",
                        help_text="Add lobbyist effective date",
                        null=True,
                    ),
                ),
                (
                    "a_l_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="A_L_NAML",
                        help_text="Add lobbyist last name",
                        max_length=200,
                    ),
                ),
                (
                    "a_l_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="A_L_NAMF",
                        help_text="Add lobbyist first name",
                        max_length=45,
                    ),
                ),
                (
                    "a_l_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="A_L_NAMT",
                        help_text="Add lobbyist title or prefix",
                        max_length=10,
                    ),
                ),
                (
                    "a_l_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="A_L_NAMS",
                        help_text="Add lobbyist suffix",
                        max_length=10,
                    ),
                ),
                (
                    "del_l_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="DEL_L_CB",
                        help_text="Delete lobbyist checkbox",
                        max_length=8,
                    ),
                ),
                (
                    "del_l_eff",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="DEL_L_EFF",
                        help_text="Delete lobbyist effective date",
                        max_length=22,
                    ),
                ),
                (
                    "d_l_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="D_L_NAML",
                        help_text="Delete lobbyist last name",
                        max_length=200,
                    ),
                ),
                (
                    "d_l_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="D_L_NAMF",
                        help_text="Delete lobbyist first name",
                        max_length=45,
                    ),
                ),
                (
                    "d_l_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="D_L_NAMT",
                        help_text="Delete lobbyist title or prefix",
                        max_length=10,
                    ),
                ),
                (
                    "d_l_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="D_L_NAMS",
                        help_text="Delete lobbyiest suffix",
                        max_length=10,
                    ),
                ),
                (
                    "add_le_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ADD_LE_CB",
                        help_text="Add lobbyiest employer checkbox",
                        max_length=1,
                    ),
                ),
                (
                    "add_le_eff",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="ADD_LE_EFF",
                        help_text="Add lobbyist employer effective date",
                        null=True,
                    ),
                ),
                (
                    "a_le_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="A_LE_NAML",
                        help_text="Add lobbyist employer last name",
                        max_length=200,
                    ),
                ),
                (
                    "a_le_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="A_LE_NAMF",
                        help_text="Add lobbyist or employer first name",
                        max_length=45,
                    ),
                ),
                (
                    "a_le_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="A_LE_NAMT",
                        help_text="Add lobbyist employer title or prefix",
                        max_length=10,
                    ),
                ),
                (
                    "a_le_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="A_LE_NAMS",
                        help_text="Add lobbyist employer suffix",
                        max_length=10,
                    ),
                ),
                (
                    "del_le_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="DEL_LE_CB",
                        help_text="Delete lobbyist employer check box",
                        max_length=9,
                    ),
                ),
                (
                    "del_le_eff",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="DEL_LE_EFF",
                        help_text="Delete lobbyist employer effective date",
                        max_length=22,
                    ),
                ),
                (
                    "d_le_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="D_LE_NAML",
                        help_text="Delete lobbyist employer last name",
                        max_length=200,
                    ),
                ),
                (
                    "d_le_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="D_LE_NAMF",
                        help_text="Delete lobbyiest employer first name",
                        max_length=45,
                    ),
                ),
                (
                    "d_le_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="D_LE_NAMT",
                        help_text="Delete lobbyist employer name title or prefix",
                        max_length=12,
                    ),
                ),
                (
                    "d_le_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="D_LE_NAMS",
                        help_text="Delete lobbyist employer name",
                        max_length=10,
                    ),
                ),
                (
                    "add_lf_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ADD_LF_CB",
                        help_text="Add lobbying firm checkbox",
                        max_length=1,
                    ),
                ),
                (
                    "add_lf_eff",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="ADD_LF_EFF",
                        help_text="Add lobbying firm effective date",
                        null=True,
                    ),
                ),
                (
                    "a_lf_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="A_LF_NAME",
                        help_text="Add lobbying firm name",
                        max_length=200,
                    ),
                ),
                (
                    "del_lf_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="DEL_LF_CB",
                        help_text="Delete lobbying firm checkbox",
                        max_length=1,
                    ),
                ),
                (
                    "del_lf_eff",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="DEL_LF_EFF",
                        help_text="Delete lobbying firm effective date",
                        null=True,
                    ),
                ),
                (
                    "d_lf_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="D_LF_NAME",
                        help_text="Delete lobbying firm name",
                        max_length=200,
                    ),
                ),
                (
                    "other_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="OTHER_CB",
                        help_text="Other amendments checkbox",
                        max_length=1,
                    ),
                ),
                (
                    "other_eff",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="OTHER_EFF",
                        help_text="Other amendments effective date",
                        null=True,
                    ),
                ),
                (
                    "other_desc",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="OTHER_DESC",
                        help_text="Description of changes",
                        max_length=100,
                    ),
                ),
                (
                    "f606_yes",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="F606_YES",
                        help_text="Lobbyist ceasing all activity",
                        max_length=1,
                    ),
                ),
                (
                    "f606_no",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="F606_NO",
                        help_text="Lobbyist ceasing employment but staying active",
                        max_length=1,
                    ),
                ),
            ],
            options={
                "db_table": "LOBBY_AMENDMENTS_CD",
                "verbose_name": "LOBBY_AMENDMENTS_CD",
                "verbose_name_plural": "LOBBY_AMENDMENTS_CD",
            },
        ),
        migrations.CreateModel(
            name="LobbyingChgLogCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILER_ID",
                        db_index=True,
                        help_text="Filer's unique identification number",
                        null=True,
                        verbose_name="filer ID",
                    ),
                ),
                (
                    "change_no",
                    calaccess_raw.fields.IntegerField(
                        db_column="CHANGE_NO",
                        help_text="Number of changes this session",
                    ),
                ),
                (
                    "session_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_ID",
                        help_text="Legislative session identification number",
                        null=True,
                        verbose_name="session ID",
                    ),
                ),
                (
                    "log_dt",
                    calaccess_raw.fields.DateField(
                        db_column="LOG_DT",
                        help_text="This field is undocumented",
                        null=True,
                    ),
                ),
                (
                    "correction_flag",
                    calaccess_raw.fields.CharField(
                        db_column="CORRECTION_FLG",
                        help_text="This field is undocumented",
                        max_length=200,
                    ),
                ),
                (
                    "action",
                    calaccess_raw.fields.CharField(
                        db_column="ACTION",
                        help_text="This field is undocumented",
                        max_length=200,
                    ),
                ),
                (
                    "attribute_changed",
                    calaccess_raw.fields.CharField(
                        db_column="ATTRIBUTE_CHANGED",
                        help_text="This field is undocumented",
                        max_length=200,
                    ),
                ),
                (
                    "ethics_dt",
                    calaccess_raw.fields.DateField(
                        db_column="ETHICS_DT",
                        help_text="This field is undocumented",
                        null=True,
                    ),
                ),
                (
                    "interests",
                    calaccess_raw.fields.CharField(
                        db_column="INTERESTS",
                        help_text="This field is undocumented",
                        max_length=200,
                    ),
                ),
                (
                    "filer_full_name",
                    calaccess_raw.fields.CharField(
                        db_column="FILER_FULL_NAME",
                        help_text="Full name of filer",
                        max_length=200,
                    ),
                ),
                (
                    "filer_city",
                    calaccess_raw.fields.CharField(
                        db_column="FILER_CITY",
                        help_text="City address of filer",
                        max_length=200,
                    ),
                ),
                (
                    "filer_st",
                    calaccess_raw.fields.CharField(
                        db_column="FILER_ST",
                        help_text="State address of filer",
                        max_length=200,
                        verbose_name="Filer state",
                    ),
                ),
                (
                    "filer_zip",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILER_ZIP",
                        help_text="ZIP Code of filer",
                        null=True,
                        verbose_name="Filer ZIP Code",
                    ),
                ),
                (
                    "filer_phone",
                    calaccess_raw.fields.CharField(
                        db_column="FILER_PHONE",
                        help_text="Phone number of filer",
                        max_length=12,
                        null=True,
                        verbose_name="Filer phone number",
                    ),
                ),
                (
                    "entity_type",
                    calaccess_raw.fields.IntegerField(
                        choices=[
                            (0, "n/a"),
                            (1, "Client"),
                            (2, "Employer"),
                            (3, "Firm"),
                            (4, "Lobbyist"),
                            (10, "Major Donor"),
                            (16, "Recipient Committee"),
                            (20, "Treasurer/Responsible Officer"),
                        ],
                        db_column="ENTITY_TYPE",
                        help_text="This field is undocumented. The values might refer to either FILER_TYPES_CD.FILER_TYPE or GROUP_TYPES_CD.GRP_ID, but that's just a guess.",
                        null=True,
                    ),
                ),
                (
                    "entity_name",
                    calaccess_raw.fields.CharField(
                        db_column="ENTITY_NAME",
                        help_text="This field is undocumented",
                        max_length=500,
                    ),
                ),
                (
                    "entity_city",
                    calaccess_raw.fields.CharField(
                        db_column="ENTITY_CITY",
                        help_text="This field is undocumented",
                        max_length=500,
                    ),
                ),
                (
                    "entity_st",
                    calaccess_raw.fields.CharField(
                        db_column="ENTITY_ST",
                        help_text="This field is undocumented",
                        max_length=500,
                    ),
                ),
                (
                    "entity_zip",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTITY_ZIP",
                        help_text="This field is undocumented",
                        max_length=10,
                    ),
                ),
                (
                    "entity_phone",
                    calaccess_raw.fields.CharField(
                        db_column="ENTITY_PHONE",
                        help_text="Entity phone number",
                        max_length=12,
                        null=True,
                    ),
                ),
                (
                    "entity_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="ENTITY_ID",
                        help_text="Entity identification number",
                        null=True,
                    ),
                ),
                (
                    "responsible_officer",
                    calaccess_raw.fields.CharField(
                        db_column="RESPONSIBLE_OFFICER",
                        help_text="This field is undocumented",
                        max_length=500,
                    ),
                ),
                (
                    "effect_dt",
                    calaccess_raw.fields.DateField(
                        db_column="EFFECT_DT",
                        help_text="This field is undocumented",
                        null=True,
                        verbose_name="Effective date",
                    ),
                ),
                (
                    "filer_type",
                    calaccess_raw.fields.ForeignKeyField(
                        db_column="FILER_TYPE",
                        db_constraint=False,
                        help_text="Foreign key referencing FilerTypesCd.filer_type",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="lobby_change_logs",
                        to="calaccess_raw.FilerTypesCd",
                    ),
                ),
            ],
            options={
                "db_table": "LOBBYING_CHG_LOG_CD",
                "verbose_name": "LOBBYING_CHG_LOG_CD",
                "verbose_name_plural": "LOBBYING_CHG_LOG_CD",
            },
        ),
        migrations.CreateModel(
            name="LobbyistContributions1Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILER_ID",
                        db_index=True,
                        help_text="Filer's unique identification number",
                        null=True,
                        verbose_name="filer ID",
                    ),
                ),
                (
                    "filing_period_start_dt",
                    calaccess_raw.fields.DateField(
                        db_column="FILING_PERIOD_START_DT",
                        help_text="Start date of filing period",
                        null=True,
                        verbose_name="Filing period start date",
                    ),
                ),
                (
                    "filing_period_end_dt",
                    calaccess_raw.fields.DateField(
                        db_column="FILING_PERIOD_END_DT",
                        help_text="End date of filing period",
                        null=True,
                        verbose_name="Filing period end date",
                    ),
                ),
                (
                    "contribution_dt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CONTRIBUTION_DT",
                        help_text="Date of contribution",
                        max_length=32,
                        verbose_name="Contribution date",
                    ),
                ),
                (
                    "recipient_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RECIPIENT_NAME",
                        help_text="Recipient's name",
                        max_length=106,
                    ),
                ),
                (
                    "recipient_id",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="RECIPIENT_ID",
                        help_text="Recipient's identification number",
                        null=True,
                    ),
                ),
                (
                    "amount",
                    calaccess_raw.fields.FloatField(
                        blank=True,
                        db_column="AMOUNT",
                        help_text="Amount received",
                        null=True,
                    ),
                ),
            ],
            options={
                "db_table": "LOBBYIST_CONTRIBUTIONS1_CD",
                "verbose_name": "LOBBYIST_CONTRIBUTIONS1_CD",
                "verbose_name_plural": "LOBBYIST_CONTRIBUTIONS1_CD",
            },
        ),
        migrations.CreateModel(
            name="LobbyistContributions2Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILER_ID",
                        db_index=True,
                        help_text="Filer's unique identification number",
                        null=True,
                        verbose_name="filer ID",
                    ),
                ),
                (
                    "filing_period_start_dt",
                    calaccess_raw.fields.DateField(
                        db_column="FILING_PERIOD_START_DT",
                        help_text="Start date of filing period",
                        null=True,
                        verbose_name="Filing period start date",
                    ),
                ),
                (
                    "filing_period_end_dt",
                    calaccess_raw.fields.DateField(
                        db_column="FILING_PERIOD_END_DT",
                        help_text="End date of filing period",
                        null=True,
                        verbose_name="Filing period end date",
                    ),
                ),
                (
                    "contribution_dt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CONTRIBUTION_DT",
                        help_text="Date of contribution",
                        max_length=32,
                        verbose_name="Contribution date",
                    ),
                ),
                (
                    "recipient_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RECIPIENT_NAME",
                        help_text="Recipient's name",
                        max_length=106,
                    ),
                ),
                (
                    "recipient_id",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="RECIPIENT_ID",
                        help_text="Recipient's identification number",
                        null=True,
                    ),
                ),
                (
                    "amount",
                    calaccess_raw.fields.FloatField(
                        blank=True,
                        db_column="AMOUNT",
                        help_text="Amount received",
                        null=True,
                    ),
                ),
            ],
            options={
                "db_table": "LOBBYIST_CONTRIBUTIONS2_CD",
                "verbose_name": "LOBBYIST_CONTRIBUTIONS2_CD",
                "verbose_name_plural": "LOBBYIST_CONTRIBUTIONS2_CD",
            },
        ),
        migrations.CreateModel(
            name="LobbyistContributions3Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILER_ID",
                        db_index=True,
                        help_text="Filer's unique identification number",
                        null=True,
                        verbose_name="filer ID",
                    ),
                ),
                (
                    "filing_period_start_dt",
                    calaccess_raw.fields.DateField(
                        db_column="FILING_PERIOD_START_DT",
                        help_text="Start date of filing period",
                        null=True,
                        verbose_name="Filing period start date",
                    ),
                ),
                (
                    "filing_period_end_dt",
                    calaccess_raw.fields.DateField(
                        db_column="FILING_PERIOD_END_DT",
                        help_text="End date of filing period",
                        null=True,
                        verbose_name="Filing period end date",
                    ),
                ),
                (
                    "contribution_dt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CONTRIBUTION_DT",
                        help_text="Date of contribution",
                        max_length=32,
                        verbose_name="Contribution date",
                    ),
                ),
                (
                    "recipient_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RECIPIENT_NAME",
                        help_text="Recipient's name",
                        max_length=106,
                    ),
                ),
                (
                    "recipient_id",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="RECIPIENT_ID",
                        help_text="Recipient's identification number",
                        null=True,
                    ),
                ),
                (
                    "amount",
                    calaccess_raw.fields.FloatField(
                        blank=True,
                        db_column="AMOUNT",
                        help_text="Amount received",
                        null=True,
                    ),
                ),
            ],
            options={
                "db_table": "LOBBYIST_CONTRIBUTIONS3_CD",
                "verbose_name": "LOBBYIST_CONTRIBUTIONS3_CD",
                "verbose_name_plural": "LOBBYIST_CONTRIBUTIONS3_CD",
            },
        ),
        migrations.CreateModel(
            name="LobbyistEmpLobbyist1Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "lobbyist_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="LOBBYIST_ID",
                        help_text="Lobbyist identification number",
                        verbose_name="Lobbyist ID",
                    ),
                ),
                (
                    "employer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="EMPLOYER_ID",
                        help_text="Employer identification number",
                        verbose_name="Employer ID",
                    ),
                ),
                (
                    "lobbyist_last_name",
                    calaccess_raw.fields.CharField(
                        db_column="LOBBYIST_LAST_NAME",
                        help_text="Lobbyist last name",
                        max_length=17,
                    ),
                ),
                (
                    "lobbyist_first_name",
                    calaccess_raw.fields.CharField(
                        db_column="LOBBYIST_FIRST_NAME",
                        help_text="Lobbyist first name",
                        max_length=17,
                    ),
                ),
                (
                    "employer_name",
                    calaccess_raw.fields.CharField(
                        db_column="EMPLOYER_NAME",
                        help_text="Employer name",
                        max_length=300,
                    ),
                ),
                (
                    "session_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_ID",
                        help_text="Legislative session identification number",
                        null=True,
                        verbose_name="session ID",
                    ),
                ),
            ],
            options={
                "db_table": "LOBBYIST_EMP_LOBBYIST1_CD",
                "verbose_name": "LOBBYIST_EMP_LOBBYIST1_CD",
                "verbose_name_plural": "LOBBYIST_EMP_LOBBYIST1_CD",
            },
        ),
        migrations.CreateModel(
            name="LobbyistEmpLobbyist2Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "lobbyist_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="LOBBYIST_ID",
                        help_text="Lobbyist identification number",
                        verbose_name="Lobbyist ID",
                    ),
                ),
                (
                    "employer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="EMPLOYER_ID",
                        help_text="Employer identification number",
                        verbose_name="Employer ID",
                    ),
                ),
                (
                    "lobbyist_last_name",
                    calaccess_raw.fields.CharField(
                        db_column="LOBBYIST_LAST_NAME",
                        help_text="Lobbyist last name",
                        max_length=17,
                    ),
                ),
                (
                    "lobbyist_first_name",
                    calaccess_raw.fields.CharField(
                        db_column="LOBBYIST_FIRST_NAME",
                        help_text="Lobbyist first name",
                        max_length=17,
                    ),
                ),
                (
                    "employer_name",
                    calaccess_raw.fields.CharField(
                        db_column="EMPLOYER_NAME",
                        help_text="Employer name",
                        max_length=300,
                    ),
                ),
                (
                    "session_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_ID",
                        help_text="Legislative session identification number",
                        null=True,
                        verbose_name="session ID",
                    ),
                ),
            ],
            options={
                "db_table": "LOBBYIST_EMP_LOBBYIST2_CD",
                "verbose_name": "LOBBYIST_EMP_LOBBYIST2_CD",
                "verbose_name_plural": "LOBBYIST_EMP_LOBBYIST2_CD",
            },
        ),
        migrations.CreateModel(
            name="LobbyistEmployer1Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "employer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="EMPLOYER_ID",
                        help_text="Employer identification number",
                        verbose_name="Employer ID",
                    ),
                ),
                (
                    "session_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_ID",
                        help_text="Legislative session identification number",
                        null=True,
                        verbose_name="session ID",
                    ),
                ),
                (
                    "employer_name",
                    calaccess_raw.fields.CharField(
                        db_column="EMPLOYER_NAME",
                        help_text="Employer name",
                        max_length=300,
                    ),
                ),
                (
                    "current_qtr_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="CURRENT_QTR_AMT", help_text="Current quarter amount"
                    ),
                ),
                (
                    "session_total_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="SESSION_TOTAL_AMT",
                        help_text="Total amount for the session",
                    ),
                ),
                (
                    "contributor_id",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="CONTRIBUTOR_ID",
                        help_text="Contributor identification number",
                        null=True,
                        verbose_name="contributor ID",
                    ),
                ),
                (
                    "interest_cd",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        choices=[
                            (40301, "AGRICULTURE"),
                            (40302, "EDUCATION"),
                            (40303, "ENTERTAINMENT/RECREATION"),
                            (40304, "FINANCE/INSURANCE"),
                            (40305, "GOVERNMENT"),
                            (40306, "HEALTH"),
                            (40307, "LABOR UNIONS"),
                            (40308, "LEGAL"),
                            (40309, "LODGING/RESTAURANTS"),
                            (40310, "MANUFACTURING/INDUSTRIAL"),
                            (40311, "MERCHANDISE/RETAIL"),
                            (40312, "MISCELLANEOUS"),
                            (40313, "OIL AND GAS"),
                            (40314, "POLITICAL ORGANIZATIONS"),
                            (40315, "PROFESSIONAL/TRADE"),
                            (40316, "PUBLIC EMPLOYEES"),
                            (40317, "REAL ESTATE"),
                            (40318, "TRANSPORTATION"),
                            (40319, "UTILITIES"),
                        ],
                        db_column="INTEREST_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2774529-Lookup-Codes-Cd", start_page=19
                            )
                        ],
                        help_text="Interest Code",
                        null=True,
                        verbose_name="interest code",
                    ),
                ),
                (
                    "interest_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INTEREST_NAME",
                        help_text="Interest name",
                        max_length=24,
                        verbose_name="Interest name",
                    ),
                ),
                (
                    "session_yr_1",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_YR_1",
                        help_text="Total amount of year 1 of the session",
                        verbose_name="Total amount of year 1 of the session",
                    ),
                ),
                (
                    "session_yr_2",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_YR_2",
                        help_text="Total amount of year 2 of the session",
                        verbose_name="Total amount of year 2 of the session",
                    ),
                ),
                (
                    "yr_1_ytd_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="YR_1_YTD_AMT",
                        help_text="Year 1 year-to-date-amount",
                        verbose_name="Year 1 year-to-date-amount",
                    ),
                ),
                (
                    "yr_2_ytd_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="YR_2_YTD_AMT",
                        help_text="Year 2 year-to-date-amount",
                        verbose_name="Year 2 year-to-date-amount",
                    ),
                ),
                (
                    "qtr_1",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_1",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 1",
                    ),
                ),
                (
                    "qtr_2",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_2",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 2",
                    ),
                ),
                (
                    "qtr_3",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_3",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 3",
                    ),
                ),
                (
                    "qtr_4",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_4",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 4",
                    ),
                ),
                (
                    "qtr_5",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_5",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 5",
                    ),
                ),
                (
                    "qtr_6",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_6",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 6",
                    ),
                ),
                (
                    "qtr_7",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_7",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 7",
                    ),
                ),
                (
                    "qtr_8",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_8",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 8",
                    ),
                ),
            ],
            options={
                "db_table": "LOBBYIST_EMPLOYER1_CD",
                "verbose_name": "LOBBYIST_EMPLOYER1_CD",
                "verbose_name_plural": "LOBBYIST_EMPLOYER1_CD",
            },
        ),
        migrations.CreateModel(
            name="LobbyistEmployer2Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "employer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="EMPLOYER_ID",
                        help_text="Employer identification number",
                        verbose_name="Employer ID",
                    ),
                ),
                (
                    "session_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_ID",
                        help_text="Legislative session identification number",
                        null=True,
                        verbose_name="session ID",
                    ),
                ),
                (
                    "employer_name",
                    calaccess_raw.fields.CharField(
                        db_column="EMPLOYER_NAME",
                        help_text="Employer name",
                        max_length=300,
                    ),
                ),
                (
                    "current_qtr_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="CURRENT_QTR_AMT", help_text="Current quarter amount"
                    ),
                ),
                (
                    "session_total_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="SESSION_TOTAL_AMT",
                        help_text="Total amount for the session",
                    ),
                ),
                (
                    "contributor_id",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="CONTRIBUTOR_ID",
                        help_text="Contributor identification number",
                        null=True,
                        verbose_name="contributor ID",
                    ),
                ),
                (
                    "interest_cd",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        choices=[
                            (40301, "AGRICULTURE"),
                            (40302, "EDUCATION"),
                            (40303, "ENTERTAINMENT/RECREATION"),
                            (40304, "FINANCE/INSURANCE"),
                            (40305, "GOVERNMENT"),
                            (40306, "HEALTH"),
                            (40307, "LABOR UNIONS"),
                            (40308, "LEGAL"),
                            (40309, "LODGING/RESTAURANTS"),
                            (40310, "MANUFACTURING/INDUSTRIAL"),
                            (40311, "MERCHANDISE/RETAIL"),
                            (40312, "MISCELLANEOUS"),
                            (40313, "OIL AND GAS"),
                            (40314, "POLITICAL ORGANIZATIONS"),
                            (40315, "PROFESSIONAL/TRADE"),
                            (40316, "PUBLIC EMPLOYEES"),
                            (40317, "REAL ESTATE"),
                            (40318, "TRANSPORTATION"),
                            (40319, "UTILITIES"),
                        ],
                        db_column="INTEREST_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2774529-Lookup-Codes-Cd", start_page=19
                            )
                        ],
                        help_text="Interest Code",
                        null=True,
                        verbose_name="interest code",
                    ),
                ),
                (
                    "interest_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INTEREST_NAME",
                        help_text="Interest name",
                        max_length=24,
                    ),
                ),
                (
                    "session_yr_1",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_YR_1",
                        help_text="Total amount of year 1 of the session",
                        verbose_name="Total amount of year 1 of the session",
                    ),
                ),
                (
                    "session_yr_2",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_YR_2",
                        help_text="Total amount of year 2 of the session",
                        verbose_name="Total amount of year 2 of the session",
                    ),
                ),
                (
                    "yr_1_ytd_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="YR_1_YTD_AMT",
                        help_text="Year 1 year-to-date-amount",
                        verbose_name="Year 1 year-to-date-amount",
                    ),
                ),
                (
                    "yr_2_ytd_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="YR_2_YTD_AMT",
                        help_text="Year 2 year-to-date-amount",
                        verbose_name="Year 2 year-to-date-amount",
                    ),
                ),
                (
                    "qtr_1",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_1",
                        help_text="Quarter 1 total amount",
                        verbose_name="Quarter 1",
                    ),
                ),
                (
                    "qtr_2",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_2",
                        help_text="Quarter 2 total amount",
                        verbose_name="Quarter 2",
                    ),
                ),
                (
                    "qtr_3",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_3",
                        help_text="Quarter 3 total amount",
                        verbose_name="Quarter 3",
                    ),
                ),
                (
                    "qtr_4",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_4",
                        help_text="Quarter 4 total amount",
                        verbose_name="Quarter 4",
                    ),
                ),
                (
                    "qtr_5",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_5",
                        help_text="Quarter 5 total amount",
                        verbose_name="Quarter 5",
                    ),
                ),
                (
                    "qtr_6",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_6",
                        help_text="Quarter 6 total amount",
                        verbose_name="Quarter 6",
                    ),
                ),
                (
                    "qtr_7",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_7",
                        help_text="Quarter 7 total amount",
                        verbose_name="Quarter 7",
                    ),
                ),
                (
                    "qtr_8",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_8",
                        help_text="Quarter 8 total amount",
                        verbose_name="Quarter 8",
                    ),
                ),
            ],
            options={
                "db_table": "LOBBYIST_EMPLOYER2_CD",
                "verbose_name": "LOBBYIST_EMPLOYER2_CD",
                "verbose_name_plural": "LOBBYIST_EMPLOYER2_CD",
            },
        ),
        migrations.CreateModel(
            name="LobbyistEmployer3Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "employer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="EMPLOYER_ID",
                        help_text="Employer identification number",
                        verbose_name="Employer ID",
                    ),
                ),
                (
                    "session_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_ID",
                        help_text="Legislative session identification number",
                        null=True,
                        verbose_name="session ID",
                    ),
                ),
                (
                    "employer_name",
                    calaccess_raw.fields.CharField(
                        db_column="EMPLOYER_NAME",
                        help_text="Employer name",
                        max_length=300,
                    ),
                ),
                (
                    "current_qtr_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="CURRENT_QTR_AMT", help_text="Current quarter amount"
                    ),
                ),
                (
                    "session_total_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="SESSION_TOTAL_AMT",
                        help_text="Total amount for the session",
                    ),
                ),
                (
                    "contributor_id",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="CONTRIBUTOR_ID",
                        help_text="Contributor identification number",
                        null=True,
                        verbose_name="contributor ID",
                    ),
                ),
                (
                    "interest_cd",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        choices=[
                            (40301, "AGRICULTURE"),
                            (40302, "EDUCATION"),
                            (40303, "ENTERTAINMENT/RECREATION"),
                            (40304, "FINANCE/INSURANCE"),
                            (40305, "GOVERNMENT"),
                            (40306, "HEALTH"),
                            (40307, "LABOR UNIONS"),
                            (40308, "LEGAL"),
                            (40309, "LODGING/RESTAURANTS"),
                            (40310, "MANUFACTURING/INDUSTRIAL"),
                            (40311, "MERCHANDISE/RETAIL"),
                            (40312, "MISCELLANEOUS"),
                            (40313, "OIL AND GAS"),
                            (40314, "POLITICAL ORGANIZATIONS"),
                            (40315, "PROFESSIONAL/TRADE"),
                            (40316, "PUBLIC EMPLOYEES"),
                            (40317, "REAL ESTATE"),
                            (40318, "TRANSPORTATION"),
                            (40319, "UTILITIES"),
                        ],
                        db_column="INTEREST_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2774529-Lookup-Codes-Cd", start_page=19
                            )
                        ],
                        help_text="Interest Code",
                        null=True,
                        verbose_name="interest code",
                    ),
                ),
                (
                    "interest_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INTEREST_NAME",
                        help_text="Interest name",
                        max_length=24,
                    ),
                ),
                (
                    "session_yr_1",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_YR_1",
                        help_text="Total amount of year 1 of the session",
                        verbose_name="Total amount of year 1 of the session",
                    ),
                ),
                (
                    "session_yr_2",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_YR_2",
                        help_text="Total amount of year 2 of the session",
                        verbose_name="Total amount of year 2 of the session",
                    ),
                ),
                (
                    "yr_1_ytd_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="YR_1_YTD_AMT",
                        help_text="Year 1 year-to-date-amount",
                        verbose_name="Year 1 year-to-date-amount",
                    ),
                ),
                (
                    "yr_2_ytd_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="YR_2_YTD_AMT",
                        help_text="Year 2 year-to-date-amount",
                        verbose_name="Year 2 year-to-date-amount",
                    ),
                ),
                (
                    "qtr_1",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_1",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 1",
                    ),
                ),
                (
                    "qtr_2",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_2",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 2",
                    ),
                ),
                (
                    "qtr_3",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_3",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 3",
                    ),
                ),
                (
                    "qtr_4",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_4",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 4",
                    ),
                ),
                (
                    "qtr_5",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_5",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 5",
                    ),
                ),
                (
                    "qtr_6",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_6",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 6",
                    ),
                ),
                (
                    "qtr_7",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_7",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 7",
                    ),
                ),
                (
                    "qtr_8",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_8",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 8",
                    ),
                ),
            ],
            options={
                "db_table": "LOBBYIST_EMPLOYER3_CD",
                "verbose_name": "LOBBYIST_EMPLOYER3_CD",
                "verbose_name_plural": "LOBBYIST_EMPLOYER3_CD",
            },
        ),
        migrations.CreateModel(
            name="LobbyistEmployerFirms1Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "employer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="EMPLOYER_ID",
                        help_text="Employer identification number",
                        verbose_name="Employer ID",
                    ),
                ),
                (
                    "firm_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FIRM_ID",
                        help_text="Identification number of the firm, employer or coalition",
                        verbose_name="Firm ID",
                    ),
                ),
                (
                    "firm_name",
                    calaccess_raw.fields.CharField(
                        db_column="FIRM_NAME",
                        help_text="Name of firm, employer or coalition",
                        max_length=400,
                    ),
                ),
                (
                    "session_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_ID",
                        help_text="Legislative session identification number",
                        null=True,
                        verbose_name="session ID",
                    ),
                ),
                (
                    "termination_dt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TERMINATION_DT",
                        help_text="Termination effective date",
                        max_length=32,
                        verbose_name="termination date",
                    ),
                ),
            ],
            options={
                "db_table": "LOBBYIST_EMPLOYER_FIRMS1_CD",
                "verbose_name": "LOBBYIST_EMPLOYER_FIRMS1_CD",
                "verbose_name_plural": "LOBBYIST_EMPLOYER_FIRMS1_CD",
            },
        ),
        migrations.CreateModel(
            name="LobbyistEmployerFirms2Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "employer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="EMPLOYER_ID",
                        help_text="Employer identification number",
                        verbose_name="Employer ID",
                    ),
                ),
                (
                    "firm_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FIRM_ID",
                        help_text="Identification number of the firm, employer or coalition",
                        verbose_name="Firm ID",
                    ),
                ),
                (
                    "firm_name",
                    calaccess_raw.fields.CharField(
                        db_column="FIRM_NAME",
                        help_text="Name of firm, employer or coalition",
                        max_length=400,
                    ),
                ),
                (
                    "session_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_ID",
                        help_text="Legislative session identification number",
                        null=True,
                        verbose_name="session ID",
                    ),
                ),
                (
                    "termination_dt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TERMINATION_DT",
                        help_text="Termination effective date",
                        max_length=32,
                        verbose_name="termination date",
                    ),
                ),
            ],
            options={
                "db_table": "LOBBYIST_EMPLOYER_FIRMS2_CD",
                "verbose_name": "LOBBYIST_EMPLOYER_FIRMS2_CD",
                "verbose_name_plural": "LOBBYIST_EMPLOYER_FIRMS2_CD",
            },
        ),
        migrations.CreateModel(
            name="LobbyistEmployerHistoryCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "contributor_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="CONTRIBUTOR_ID",
                        help_text="Contributor identification number.",
                    ),
                ),
                (
                    "current_qtr_amt",
                    calaccess_raw.fields.IntegerField(
                        db_column="CURRENT_QTR_AMT", help_text="Current Quarter Amount"
                    ),
                ),
                (
                    "employer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="EMPLOYER_ID",
                        help_text="Employer identification number.",
                    ),
                ),
                (
                    "employer_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EMPLOYER_NAME",
                        help_text="Employer Name",
                        max_length=300,
                    ),
                ),
                (
                    "interest_cd",
                    calaccess_raw.fields.IntegerField(
                        choices=[
                            (40301, "AGRICULTURE"),
                            (40302, "EDUCATION"),
                            (40303, "ENTERTAINMENT/RECREATION"),
                            (40304, "FINANCE/INSURANCE"),
                            (40305, "GOVERNMENT"),
                            (40306, "HEALTH"),
                            (40307, "LABOR UNIONS"),
                            (40308, "LEGAL"),
                            (40309, "LODGING/RESTAURANTS"),
                            (40310, "MANUFACTURING/INDUSTRIAL"),
                            (40311, "MERCHANDISE/RETAIL"),
                            (40312, "MISCELLANEOUS"),
                            (40313, "OIL AND GAS"),
                            (40314, "POLITICAL ORGANIZATIONS"),
                            (40315, "PROFESSIONAL/TRADE"),
                            (40316, "PUBLIC EMPLOYEES"),
                            (40317, "REAL ESTATE"),
                            (40318, "TRANSPORTATION"),
                            (40319, "UTILITIES"),
                        ],
                        db_column="INTEREST_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2774529-Lookup-Codes-Cd", start_page=19
                            )
                        ],
                        help_text="Interest Code",
                        verbose_name="interest code",
                    ),
                ),
                (
                    "interest_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INTEREST_NAME",
                        help_text="Interest name.",
                        max_length=300,
                        verbose_name="Interest name.",
                    ),
                ),
                (
                    "qtr_1",
                    calaccess_raw.fields.IntegerField(
                        db_column="QTR_1",
                        help_text="Quarter 1 total amount.",
                        verbose_name="quarter 1 amount",
                    ),
                ),
                (
                    "qtr_2",
                    calaccess_raw.fields.IntegerField(
                        db_column="QTR_2",
                        help_text="Quarter 2 total amount.",
                        verbose_name="quarter 2 amount.",
                    ),
                ),
                (
                    "qtr_3",
                    calaccess_raw.fields.IntegerField(
                        db_column="QTR_3",
                        help_text="Quarter 3 total amount.",
                        verbose_name="quarter 3 amount",
                    ),
                ),
                (
                    "qtr_4",
                    calaccess_raw.fields.IntegerField(
                        db_column="QTR_4",
                        help_text="Quarter 4 total amount.",
                        verbose_name="quarter 4 amount",
                    ),
                ),
                (
                    "qtr_5",
                    calaccess_raw.fields.IntegerField(
                        db_column="QTR_5",
                        help_text="Quarter 5 total amount.",
                        verbose_name="quarter 5 amount5",
                    ),
                ),
                (
                    "qtr_6",
                    calaccess_raw.fields.IntegerField(
                        db_column="QTR_6",
                        help_text="Quarter 6 total amount.",
                        verbose_name="quarter 6 amount.",
                    ),
                ),
                (
                    "qtr_7",
                    calaccess_raw.fields.IntegerField(
                        db_column="QTR_7",
                        help_text="Quarter 7 total amount.",
                        verbose_name="quarter 7 amount.",
                    ),
                ),
                (
                    "qtr_8",
                    calaccess_raw.fields.IntegerField(
                        db_column="QTR_8",
                        help_text="Quarter 8 total amount.",
                        verbose_name="quarter 8 amount.",
                    ),
                ),
                (
                    "session_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_ID",
                        help_text="Session identification number.",
                        verbose_name="session identification number.",
                    ),
                ),
                (
                    "session_total_amt",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_TOTAL_AMT",
                        help_text="Total amount for the session.",
                        verbose_name="session total amount",
                    ),
                ),
                (
                    "session_yr_1",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_YR_1",
                        help_text="Total amount for year 1 of the session.",
                        verbose_name="session year 1",
                    ),
                ),
                (
                    "session_yr_2",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_YR_2",
                        help_text="Total amount for year 2 of the session.",
                        verbose_name="session year 2",
                    ),
                ),
                (
                    "yr_1_ytd_amt",
                    calaccess_raw.fields.IntegerField(
                        db_column="YR_1_YTD_AMT",
                        help_text="Year 1 year to date amount.",
                    ),
                ),
                (
                    "yr_2_ytd_amt",
                    calaccess_raw.fields.IntegerField(
                        db_column="YR_2_YTD_AMT",
                        help_text="Year 2 year to date amount.",
                    ),
                ),
            ],
            options={
                "db_table": "LOBBYIST_EMPLOYER_HISTORY_CD",
                "verbose_name": "LOBBYIST_EMPLOYER_HISTORY_CD",
                "verbose_name_plural": "LOBBYIST_EMPLOYER_HISTORY_CD",
            },
        ),
        migrations.CreateModel(
            name="LobbyistFirm1Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "firm_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FIRM_ID",
                        help_text="Identification number of the firm, employer or coalition",
                        verbose_name="Firm ID",
                    ),
                ),
                (
                    "session_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_ID",
                        help_text="Legislative session identification number",
                        null=True,
                        verbose_name="session ID",
                    ),
                ),
                (
                    "firm_name",
                    calaccess_raw.fields.CharField(
                        db_column="FIRM_NAME",
                        help_text="Name of firm, employer or coalition",
                        max_length=400,
                    ),
                ),
                (
                    "current_qtr_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="CURRENT_QTR_AMT", help_text="Current quarter amount"
                    ),
                ),
                (
                    "session_total_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="SESSION_TOTAL_AMT",
                        help_text="Total amount for the session",
                    ),
                ),
                (
                    "contributor_id",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="CONTRIBUTOR_ID",
                        help_text="Contributor identification number",
                        null=True,
                        verbose_name="contributor ID",
                    ),
                ),
                (
                    "session_yr_1",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_YR_1",
                        help_text="Total amount of year 1 of the session",
                    ),
                ),
                (
                    "session_yr_2",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_YR_2",
                        help_text="Total amount of year 2 of the session",
                    ),
                ),
                (
                    "yr_1_ytd_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="YR_1_YTD_AMT",
                        help_text="Year 1 year-to-date-amount",
                        verbose_name="Year 1 year-to-date-amount",
                    ),
                ),
                (
                    "yr_2_ytd_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="YR_2_YTD_AMT",
                        help_text="Year 2 year-to-date-amount",
                        verbose_name="Year 2 year-to-date-amount",
                    ),
                ),
                (
                    "qtr_1",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_1",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 1",
                    ),
                ),
                (
                    "qtr_2",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_2",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 2",
                    ),
                ),
                (
                    "qtr_3",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_3",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 3",
                    ),
                ),
                (
                    "qtr_4",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_4",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 4",
                    ),
                ),
                (
                    "qtr_5",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_5",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 5",
                    ),
                ),
                (
                    "qtr_6",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_6",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 6",
                    ),
                ),
                (
                    "qtr_7",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_7",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 7",
                    ),
                ),
                (
                    "qtr_8",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_8",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 8",
                    ),
                ),
            ],
            options={
                "db_table": "LOBBYIST_FIRM1_CD",
                "verbose_name": "LOBBYIST_FIRM1_CD",
                "verbose_name_plural": "LOBBYIST_FIRM1_CD",
            },
        ),
        migrations.CreateModel(
            name="LobbyistFirm2Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "firm_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FIRM_ID",
                        help_text="Identification number of the firm, employer or coalition",
                        verbose_name="Firm ID",
                    ),
                ),
                (
                    "session_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_ID",
                        help_text="Legislative session identification number",
                        null=True,
                        verbose_name="session ID",
                    ),
                ),
                (
                    "firm_name",
                    calaccess_raw.fields.CharField(
                        db_column="FIRM_NAME",
                        help_text="Name of firm, employer or coalition",
                        max_length=400,
                    ),
                ),
                (
                    "current_qtr_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="CURRENT_QTR_AMT", help_text="Current quarter amount"
                    ),
                ),
                (
                    "session_total_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="SESSION_TOTAL_AMT",
                        help_text="Total amount for the session",
                    ),
                ),
                (
                    "contributor_id",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="CONTRIBUTOR_ID",
                        help_text="Contributor identification number",
                        null=True,
                        verbose_name="contributor ID",
                    ),
                ),
                (
                    "session_yr_1",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_YR_1",
                        help_text="Total amount of year 1 of the session",
                    ),
                ),
                (
                    "session_yr_2",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_YR_2",
                        help_text="Total amount of year 2 of the session",
                    ),
                ),
                (
                    "yr_1_ytd_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="YR_1_YTD_AMT",
                        help_text="Year 1 year-to-date-amount",
                        verbose_name="Year 1 year-to-date-amount",
                    ),
                ),
                (
                    "yr_2_ytd_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="YR_2_YTD_AMT",
                        help_text="Year 2 year-to-date-amount",
                        verbose_name="Year 2 year-to-date-amount",
                    ),
                ),
                (
                    "qtr_1",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_1",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 1",
                    ),
                ),
                (
                    "qtr_2",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_2",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 2",
                    ),
                ),
                (
                    "qtr_3",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_3",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 3",
                    ),
                ),
                (
                    "qtr_4",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_4",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 4",
                    ),
                ),
                (
                    "qtr_5",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_5",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 5",
                    ),
                ),
                (
                    "qtr_6",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_6",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 6",
                    ),
                ),
                (
                    "qtr_7",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_7",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 7",
                    ),
                ),
                (
                    "qtr_8",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_8",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 8",
                    ),
                ),
            ],
            options={
                "db_table": "LOBBYIST_FIRM2_CD",
                "verbose_name": "LOBBYIST_FIRM2_CD",
                "verbose_name_plural": "LOBBYIST_FIRM2_CD",
            },
        ),
        migrations.CreateModel(
            name="LobbyistFirm3Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "firm_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FIRM_ID",
                        help_text="Identification number of the firm, employer or coalition",
                        verbose_name="Firm ID",
                    ),
                ),
                (
                    "session_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_ID",
                        help_text="Legislative session identification number",
                        null=True,
                        verbose_name="session ID",
                    ),
                ),
                (
                    "firm_name",
                    calaccess_raw.fields.CharField(
                        db_column="FIRM_NAME",
                        help_text="Name of firm, employer or coalition",
                        max_length=400,
                    ),
                ),
                (
                    "current_qtr_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="CURRENT_QTR_AMT", help_text="Current quarter amount"
                    ),
                ),
                (
                    "session_total_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="SESSION_TOTAL_AMT",
                        help_text="Total amount for the session",
                    ),
                ),
                (
                    "contributor_id",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="CONTRIBUTOR_ID",
                        help_text="Contributor identification number",
                        null=True,
                        verbose_name="contributor ID",
                    ),
                ),
                (
                    "session_yr_1",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_YR_1",
                        help_text="Total amount of year 1 of the session",
                    ),
                ),
                (
                    "session_yr_2",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_YR_2",
                        help_text="Total amount of year 2 of the session",
                    ),
                ),
                (
                    "yr_1_ytd_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="YR_1_YTD_AMT",
                        help_text="Year 1 year-to-date-amount",
                        verbose_name="Year 1 year-to-date-amount",
                    ),
                ),
                (
                    "yr_2_ytd_amt",
                    calaccess_raw.fields.FloatField(
                        db_column="YR_2_YTD_AMT",
                        help_text="Year 2 year-to-date-amount",
                        verbose_name="Year 2 year-to-date-amount",
                    ),
                ),
                (
                    "qtr_1",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_1",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 1",
                    ),
                ),
                (
                    "qtr_2",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_2",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 2",
                    ),
                ),
                (
                    "qtr_3",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_3",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 3",
                    ),
                ),
                (
                    "qtr_4",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_4",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 4",
                    ),
                ),
                (
                    "qtr_5",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_5",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 5",
                    ),
                ),
                (
                    "qtr_6",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_6",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 6",
                    ),
                ),
                (
                    "qtr_7",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_7",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 7",
                    ),
                ),
                (
                    "qtr_8",
                    calaccess_raw.fields.FloatField(
                        db_column="QTR_8",
                        help_text="Quarter total amount",
                        verbose_name="Quarter 8",
                    ),
                ),
            ],
            options={
                "db_table": "LOBBYIST_FIRM3_CD",
                "verbose_name": "LOBBYIST_FIRM3_CD",
                "verbose_name_plural": "LOBBYIST_FIRM3_CD",
            },
        ),
        migrations.CreateModel(
            name="LobbyistFirmEmployer1Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "firm_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FIRM_ID",
                        help_text="Identification number of the firm, employer or coalition",
                        verbose_name="Firm ID",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "filing_sequence",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_SEQUENCE",
                        help_text="Amendment number. 0 is the original filing. 1 to 999 are amendments",
                    ),
                ),
                (
                    "firm_name",
                    calaccess_raw.fields.CharField(
                        db_column="FIRM_NAME",
                        help_text="Name of firm, employer or coalition",
                        max_length=400,
                    ),
                ),
                (
                    "employer_name",
                    calaccess_raw.fields.CharField(
                        db_column="EMPLOYER_NAME",
                        help_text="Employer name",
                        max_length=300,
                    ),
                ),
                (
                    "rpt_start",
                    calaccess_raw.fields.DateField(
                        db_column="RPT_START",
                        help_text="Starting date for the period the report covers",
                        null=True,
                    ),
                ),
                (
                    "rpt_end",
                    calaccess_raw.fields.DateField(
                        db_column="RPT_END",
                        help_text="Ending date for the period the report covers",
                        null=True,
                    ),
                ),
                (
                    "per_total",
                    calaccess_raw.fields.FloatField(
                        db_column="PER_TOTAL", help_text="Total this reporting period"
                    ),
                ),
                (
                    "cum_total",
                    calaccess_raw.fields.FloatField(
                        db_column="CUM_TOTAL", help_text="Cumulative total to date"
                    ),
                ),
                (
                    "lby_actvty",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LBY_ACTVTY",
                        help_text="Description of lobbying activity",
                        max_length=182,
                    ),
                ),
                (
                    "ext_lby_actvty",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EXT_LBY_ACTVTY",
                        help_text="This field is undocumented",
                        max_length=32,
                    ),
                ),
            ],
            options={
                "db_table": "LOBBYIST_FIRM_EMPLOYER1_CD",
                "verbose_name": "LOBBYIST_FIRM_EMPLOYER1_CD",
                "verbose_name_plural": "LOBBYIST_FIRM_EMPLOYER1_CD",
            },
        ),
        migrations.CreateModel(
            name="LobbyistFirmEmployer2Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "firm_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FIRM_ID",
                        help_text="Identification number of the firm, employer or coalition",
                        verbose_name="Firm ID",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "filing_sequence",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_SEQUENCE",
                        help_text="Amendment number. 0 is the original filing. 1 to 999 are amendments",
                    ),
                ),
                (
                    "firm_name",
                    calaccess_raw.fields.CharField(
                        db_column="FIRM_NAME",
                        help_text="Name of firm, employer or coalition",
                        max_length=400,
                    ),
                ),
                (
                    "employer_name",
                    calaccess_raw.fields.CharField(
                        db_column="EMPLOYER_NAME",
                        help_text="Employer name",
                        max_length=300,
                    ),
                ),
                (
                    "rpt_start",
                    calaccess_raw.fields.DateField(
                        db_column="RPT_START",
                        help_text="Starting date for the period the report covers",
                        null=True,
                    ),
                ),
                (
                    "rpt_end",
                    calaccess_raw.fields.DateField(
                        db_column="RPT_END",
                        help_text="Ending date for the period the report covers",
                        null=True,
                    ),
                ),
                (
                    "per_total",
                    calaccess_raw.fields.FloatField(
                        db_column="PER_TOTAL", help_text="Total this reporting period"
                    ),
                ),
                (
                    "cum_total",
                    calaccess_raw.fields.FloatField(
                        db_column="CUM_TOTAL", help_text="Cumulative total to date"
                    ),
                ),
                (
                    "lby_actvty",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LBY_ACTVTY",
                        help_text="Description of lobbying activity",
                        max_length=182,
                    ),
                ),
                (
                    "ext_lby_actvty",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EXT_LBY_ACTVTY",
                        help_text="This field is undocumented",
                        max_length=32,
                    ),
                ),
            ],
            options={
                "db_table": "LOBBYIST_FIRM_EMPLOYER2_CD",
                "verbose_name": "LOBBYIST_FIRM_EMPLOYER2_CD",
                "verbose_name_plural": "LOBBYIST_FIRM_EMPLOYER2_CD",
            },
        ),
        migrations.CreateModel(
            name="LobbyistFirmHistoryCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "contributor_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="CONTRIBUTOR_ID",
                        help_text="Contributor identification number.",
                    ),
                ),
                (
                    "current_qtr_amt",
                    calaccess_raw.fields.IntegerField(
                        db_column="CURRENT_QTR_AMT", help_text="Current Quarter Amount"
                    ),
                ),
                (
                    "firm_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FIRM_ID",
                        help_text="Identification number of the Firm/Employer/Coalition.",
                    ),
                ),
                (
                    "firm_name",
                    calaccess_raw.fields.CharField(
                        db_column="FIRM_NAME",
                        help_text="Name of Firm/Employer/Coalition",
                        max_length=300,
                    ),
                ),
                (
                    "qtr_1",
                    calaccess_raw.fields.IntegerField(
                        db_column="QTR_1", help_text="Quarter total amount."
                    ),
                ),
                (
                    "qtr_2",
                    calaccess_raw.fields.IntegerField(
                        db_column="QTR_2", help_text="Quarter total amount."
                    ),
                ),
                (
                    "qtr_3",
                    calaccess_raw.fields.IntegerField(
                        db_column="QTR_3", help_text="Quarter total amount."
                    ),
                ),
                (
                    "qtr_4",
                    calaccess_raw.fields.IntegerField(
                        db_column="QTR_4", help_text="Quarter total amount."
                    ),
                ),
                (
                    "qtr_5",
                    calaccess_raw.fields.IntegerField(
                        db_column="QTR_5", help_text="Quarter total amount."
                    ),
                ),
                (
                    "qtr_6",
                    calaccess_raw.fields.IntegerField(
                        db_column="QTR_6", help_text="Quarter total amount."
                    ),
                ),
                (
                    "qtr_7",
                    calaccess_raw.fields.IntegerField(
                        db_column="QTR_7", help_text="Quarter total amount."
                    ),
                ),
                (
                    "qtr_8",
                    calaccess_raw.fields.IntegerField(
                        db_column="QTR_8", help_text="Quarter total amount."
                    ),
                ),
                (
                    "session_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_ID",
                        help_text="Session identification number.",
                    ),
                ),
                (
                    "session_total_amt",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_TOTAL_AMT",
                        help_text="Total amount for the session.",
                    ),
                ),
                (
                    "session_yr_1",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_YR_1",
                        help_text="Total amount for year 1 of the session.",
                    ),
                ),
                (
                    "session_yr_2",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_YR_2",
                        help_text="Total amount for year 2 of the session.",
                    ),
                ),
                (
                    "yr_1_ytd_amt",
                    calaccess_raw.fields.IntegerField(
                        db_column="YR_1_YTD_AMT",
                        help_text="Year 1 year to date amount.",
                        verbose_name="Year 1 year to date amount.",
                    ),
                ),
                (
                    "yr_2_ytd_amt",
                    calaccess_raw.fields.IntegerField(
                        db_column="YR_2_YTD_AMT",
                        help_text="Year 2 year to date amount",
                        verbose_name="Year 2 year to date amount",
                    ),
                ),
            ],
            options={
                "db_table": "LOBBYIST_FIRM_HISTORY_CD",
                "verbose_name": "LOBBYIST_FIRM_HISTORY_CD",
                "verbose_name_plural": "LOBBYIST_FIRM_HISTORY_CD",
            },
        ),
        migrations.CreateModel(
            name="LobbyistFirmLobbyist1Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "lobbyist_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="LOBBYIST_ID",
                        help_text="Lobbyist identification number",
                        verbose_name="Lobbyist ID",
                    ),
                ),
                (
                    "firm_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FIRM_ID",
                        help_text="Identification number of the firm, employer or coalition",
                        verbose_name="Firm ID",
                    ),
                ),
                (
                    "lobbyist_last_name",
                    calaccess_raw.fields.CharField(
                        db_column="LOBBYIST_LAST_NAME",
                        help_text="Lobbyist last name",
                        max_length=15,
                    ),
                ),
                (
                    "lobbyist_first_name",
                    calaccess_raw.fields.CharField(
                        db_column="LOBBYIST_FIRST_NAME",
                        help_text="Lobbyist first name",
                        max_length=17,
                    ),
                ),
                (
                    "firm_name",
                    calaccess_raw.fields.CharField(
                        db_column="FIRM_NAME",
                        help_text="Name of firm, employer or coalition",
                        max_length=400,
                    ),
                ),
                (
                    "session_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_ID",
                        help_text="Legislative session identification number",
                        null=True,
                        verbose_name="session ID",
                    ),
                ),
            ],
            options={
                "db_table": "LOBBYIST_FIRM_LOBBYIST1_CD",
                "verbose_name": "LOBBYIST_FIRM_LOBBYIST1_CD",
                "verbose_name_plural": "LOBBYIST_FIRM_LOBBYIST1_CD",
            },
        ),
        migrations.CreateModel(
            name="LobbyistFirmLobbyist2Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "lobbyist_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="LOBBYIST_ID",
                        help_text="Lobbyist identification number",
                        verbose_name="Lobbyist ID",
                    ),
                ),
                (
                    "firm_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FIRM_ID",
                        help_text="Identification number of the firm, employer or coalition",
                        verbose_name="Firm ID",
                    ),
                ),
                (
                    "lobbyist_last_name",
                    calaccess_raw.fields.CharField(
                        db_column="LOBBYIST_LAST_NAME",
                        help_text="Lobbyist last name",
                        max_length=15,
                    ),
                ),
                (
                    "lobbyist_first_name",
                    calaccess_raw.fields.CharField(
                        db_column="LOBBYIST_FIRST_NAME",
                        help_text="Lobbyist first name",
                        max_length=17,
                    ),
                ),
                (
                    "firm_name",
                    calaccess_raw.fields.CharField(
                        db_column="FIRM_NAME",
                        help_text="Name of firm, employer or coalition",
                        max_length=400,
                    ),
                ),
                (
                    "session_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="SESSION_ID",
                        help_text="Legislative session identification number",
                        null=True,
                        verbose_name="session ID",
                    ),
                ),
            ],
            options={
                "db_table": "LOBBYIST_FIRM_LOBBYIST2_CD",
                "verbose_name": "LOBBYIST_FIRM_LOBBYIST2_CD",
                "verbose_name_plural": "LOBBYIST_FIRM_LOBBYIST2_CD",
            },
        ),
        migrations.CreateModel(
            name="LookupCodesCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "code_type",
                    calaccess_raw.fields.IntegerField(
                        db_column="CODE_TYPE", help_text="This field is undocumented"
                    ),
                ),
                (
                    "code_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="CODE_ID",
                        help_text="The code's identification number",
                    ),
                ),
                (
                    "code_desc",
                    calaccess_raw.fields.CharField(
                        db_column="CODE_DESC",
                        help_text="Code description",
                        max_length=100,
                        null=True,
                    ),
                ),
            ],
            options={
                "db_table": "LOOKUP_CODES_CD",
                "verbose_name": "LOOKUP_CODES_CD",
                "verbose_name_plural": "LOOKUP_CODES_CD",
            },
        ),
        migrations.CreateModel(
            name="LothCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "amount",
                    calaccess_raw.fields.DecimalField(
                        blank=True,
                        db_column="AMOUNT",
                        decimal_places=2,
                        help_text="Amount of payment",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "cum_amt",
                    calaccess_raw.fields.DecimalField(
                        blank=True,
                        db_column="CUM_AMT",
                        decimal_places=2,
                        help_text="Cumulative total to date",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "firm_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FIRM_CITY",
                        help_text="Firm, employer or coalition's city",
                        max_length=30,
                    ),
                ),
                (
                    "firm_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FIRM_NAME",
                        help_text="Firm, employer or coalition's name",
                        max_length=200,
                    ),
                ),
                (
                    "firm_phon",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FIRM_PHON",
                        help_text="Firm, employer or coalition's phone number",
                        max_length=20,
                    ),
                ),
                (
                    "firm_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FIRM_ST",
                        help_text="Firm, employer or coalition's ZIP Code",
                        max_length=2,
                    ),
                ),
                (
                    "firm_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="FIRM_ZIP4",
                        help_text="Firm ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"F625P3B",
                                b"Form 625 (Report of Lobbying Firm): Part 3 (Payments Made In Connection With Lobbying Activities), Section B: Payments Made",
                            )
                        ],
                        db_column="FORM_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=63
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=77
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=7,
                        verbose_name="form type",
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                    ),
                ),
                (
                    "memo_code",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_CODE",
                        help_text="Memo amount flag",
                        max_length=1,
                    ),
                ),
                (
                    "memo_refno",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_REFNO",
                        help_text="Reference to text contained in a TEXT record",
                        max_length=20,
                    ),
                ),
                (
                    "pmt_date",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="PMT_DATE",
                        help_text="Date of payment",
                        null=True,
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("LOTH", "LOTH")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=63
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=77
                            ),
                        ],
                        help_text="Record Type Value: LOTH",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "subj_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SUBJ_NAMF",
                        help_text="First name of employer/client subject of lobbying",
                        max_length=45,
                    ),
                ),
                (
                    "subj_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SUBJ_NAML",
                        help_text="Last name of employer/client subject of lobbying",
                        max_length=200,
                    ),
                ),
                (
                    "subj_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SUBJ_NAMS",
                        help_text="Suffix of employer/client subject of lobbying",
                        max_length=45,
                    ),
                ),
                (
                    "subj_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SUBJ_NAMT",
                        help_text="Prefix or title of employer/client subject of lobbying",
                        max_length=45,
                    ),
                ),
                (
                    "tran_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRAN_ID",
                        help_text="Permanent value unique to this item",
                        max_length=20,
                        verbose_name="transaction ID",
                    ),
                ),
            ],
            options={
                "db_table": "LOTH_CD",
                "verbose_name": "LOTH_CD",
                "verbose_name_plural": "LOTH_CD",
            },
        ),
        migrations.CreateModel(
            name="LpayCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "advan_amt",
                    calaccess_raw.fields.DecimalField(
                        blank=True,
                        db_column="ADVAN_AMT",
                        decimal_places=2,
                        help_text="Advance and other payments amount",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "advan_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ADVAN_DSCR",
                        help_text="Description of advance and other payments",
                        max_length=100,
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "bakref_tid",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAKREF_TID",
                        help_text="Backreference to transaction identifer of parent record",
                        max_length=20,
                    ),
                ),
                (
                    "cum_total",
                    calaccess_raw.fields.DecimalField(
                        db_column="CUM_TOTAL",
                        decimal_places=2,
                        help_text="Cumulative total to date",
                        max_digits=14,
                    ),
                ),
                (
                    "emplr_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EMPLR_CITY",
                        help_text="Employer city",
                        max_length=30,
                    ),
                ),
                (
                    "emplr_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EMPLR_ID",
                        help_text="This field is undocumented",
                        max_length=9,
                    ),
                ),
                (
                    "emplr_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EMPLR_NAMF",
                        help_text="Employer first name",
                        max_length=45,
                    ),
                ),
                (
                    "emplr_naml",
                    calaccess_raw.fields.CharField(
                        db_column="EMPLR_NAML",
                        help_text="Name of firm, employer or coalition",
                        max_length=200,
                    ),
                ),
                (
                    "emplr_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EMPLR_NAMS",
                        help_text="Employer suffix",
                        max_length=10,
                    ),
                ),
                (
                    "emplr_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EMPLR_NAMT",
                        help_text="Employer title or prefix",
                        max_length=10,
                    ),
                ),
                (
                    "emplr_phon",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EMPLR_PHON",
                        help_text="Employer phone number",
                        max_length=20,
                    ),
                ),
                (
                    "emplr_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EMPLR_ST",
                        help_text="Employer state",
                        max_length=2,
                    ),
                ),
                (
                    "emplr_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EMPLR_ZIP4",
                        help_text="Employer ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "entity_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("FRM", b"Lobbying Firm"),
                            ("LCO", b"Lobbying Coalition"),
                            ("LEM", b"Lobbying Employer"),
                            ("OTH", b"Other"),
                            ("128", "Unknown"),
                        ],
                        db_column="ENTITY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=62
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=76
                            ),
                        ],
                        help_text="Entity Code of the Employer Values",
                        max_length=3,
                        verbose_name="entity code",
                    ),
                ),
                (
                    "fees_amt",
                    calaccess_raw.fields.DecimalField(
                        blank=True,
                        db_column="FEES_AMT",
                        decimal_places=2,
                        help_text="Fees and retainers amount",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"F625P2",
                                b"Form 625 (Report of Lobbying Firm): Part 2, Payments Received in Connection with Lobbying Activity",
                            ),
                            (
                                b"F635P3B",
                                b"Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3 (Payments Made in Connection with Lobbying Activities), Section B: Payments To Lobbying Firms",
                            ),
                        ],
                        db_column="FORM_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=62
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=76
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=7,
                        verbose_name="form type",
                    ),
                ),
                (
                    "lby_actvty",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="LBY_ACTVTY",
                        help_text="Description of lobbying activity",
                        max_length=200,
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                    ),
                ),
                (
                    "memo_code",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_CODE",
                        help_text="Memo amount flag",
                        max_length=1,
                    ),
                ),
                (
                    "memo_refno",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_REFNO",
                        help_text="Reference to the text contained in a TEXT record",
                        max_length=20,
                    ),
                ),
                (
                    "per_total",
                    calaccess_raw.fields.DecimalField(
                        db_column="PER_TOTAL",
                        decimal_places=2,
                        help_text="Total this reporting period",
                        max_digits=14,
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("LPAY", "LPAY")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=62
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=76
                            ),
                        ],
                        help_text="Record Type Value: LPAY",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "reimb_amt",
                    calaccess_raw.fields.DecimalField(
                        blank=True,
                        db_column="REIMB_AMT",
                        decimal_places=2,
                        help_text="Reimbursements of expense amount",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "tran_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRAN_ID",
                        help_text="Permanent value unique to this item",
                        max_length=20,
                        verbose_name="transaction ID",
                    ),
                ),
            ],
            options={
                "db_table": "LPAY_CD",
                "verbose_name": "LPAY_CD",
                "verbose_name_plural": "LPAY_CD",
            },
        ),
        migrations.CreateModel(
            name="NamesCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "namid",
                    calaccess_raw.fields.IntegerField(
                        db_column="NAMID",
                        help_text="Identification number unique to the name",
                    ),
                ),
                (
                    "naml",
                    calaccess_raw.fields.CharField(
                        db_column="NAML", help_text="Last name", max_length=200
                    ),
                ),
                (
                    "namf",
                    calaccess_raw.fields.CharField(
                        db_column="NAMF", help_text="First name", max_length=50
                    ),
                ),
                (
                    "namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="NAMT",
                        help_text="Name title or prefix",
                        max_length=100,
                    ),
                ),
                (
                    "nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="NAMS",
                        help_text="Name suffix",
                        max_length=30,
                    ),
                ),
                (
                    "moniker",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MONIKER",
                        help_text="Entity's moniker",
                        max_length=30,
                    ),
                ),
                (
                    "moniker_pos",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MONIKER_POS",
                        help_text="Location of the entity's moniker",
                        max_length=9,
                    ),
                ),
                (
                    "namm",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="NAMM",
                        help_text="Middle name",
                        max_length=20,
                    ),
                ),
                (
                    "fullname",
                    calaccess_raw.fields.CharField(
                        db_column="FULLNAME", help_text="Full name", max_length=200
                    ),
                ),
                (
                    "naml_search",
                    calaccess_raw.fields.CharField(
                        db_column="NAML_SEARCH", help_text="Last name", max_length=200
                    ),
                ),
            ],
            options={
                "db_table": "NAMES_CD",
                "verbose_name": "NAMES_CD",
                "verbose_name_plural": "NAMES_CD",
            },
        ),
        migrations.CreateModel(
            name="RawDataFile",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "file_name",
                    models.CharField(
                        help_text="Name of the raw source data file without extension",
                        max_length=100,
                        verbose_name="raw data file name",
                    ),
                ),
                (
                    "download_records_count",
                    models.IntegerField(
                        default=0,
                        help_text="Count of records in the original file downloaded from CAL-ACCESS",
                        verbose_name="download records count",
                    ),
                ),
                (
                    "clean_records_count",
                    models.IntegerField(
                        default=0,
                        help_text="Count of records in the cleaned file generated by calaccess_raw",
                        verbose_name="clean records count",
                    ),
                ),
                (
                    "load_records_count",
                    models.IntegerField(
                        default=0,
                        help_text="Count of records in the loaded from cleaned file into calaccess_raw's data model",
                        verbose_name="load records count",
                    ),
                ),
                (
                    "download_columns_count",
                    models.IntegerField(
                        default=0,
                        help_text="Count of columns in the original file downloaded from CAL-ACCESS",
                        verbose_name="download columns count",
                    ),
                ),
                (
                    "clean_columns_count",
                    models.IntegerField(
                        default=0,
                        help_text="Count of columns in the cleaned file generated by calaccess_raw",
                        verbose_name="clean columns count",
                    ),
                ),
                (
                    "load_columns_count",
                    models.IntegerField(
                        default=0,
                        help_text="Count of columns on the loaded calaccess_raw data model",
                        verbose_name="load columns count",
                    ),
                ),
                (
                    "download_file_archive",
                    models.FileField(
                        blank=True,
                        help_text="An archive of the original raw data file downloaded from CAL-ACCESS.",
                        max_length=255,
                        upload_to=archive_directory_path,
                        verbose_name="archive of download file",
                    ),
                ),
                (
                    "clean_file_archive",
                    models.FileField(
                        blank=True,
                        help_text="An archive of the raw data file after being cleaned.",
                        max_length=255,
                        upload_to=archive_directory_path,
                        verbose_name="archive of clean file",
                    ),
                ),
            ],
            options={
                "ordering": ("-version_id", "file_name"),
                "verbose_name": "CAL-ACCESS raw data file",
            },
        ),
        migrations.CreateModel(
            name="RawDataVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "release_datetime",
                    models.DateTimeField(
                        help_text="Date and time the version of the CAL-ACCESS database was released (value of last-modified field in HTTP response header)",
                        unique=True,
                        verbose_name="date and time of release",
                    ),
                ),
                (
                    "size",
                    models.BigIntegerField(
                        help_text="Size of the .ZIP file for this version of the CAL-ACCESS raw source data (value of content-length field in HTTP response header)",
                        verbose_name="size of raw data version in bytes",
                    ),
                ),
                (
                    "zip_file_archive",
                    models.FileField(
                        blank=True,
                        help_text="An archive of the original zipped file downloaded from CAL-ACCESS.",
                        max_length=255,
                        upload_to=archive_directory_path,
                        verbose_name="archive of zip file",
                    ),
                ),
                (
                    "clean_zip_archive",
                    models.FileField(
                        blank=True,
                        help_text="An archive zip of cleaned (and error log) files",
                        max_length=255,
                        upload_to=archive_directory_path,
                        verbose_name="cleaned files zip archive",
                    ),
                ),
            ],
            options={
                "ordering": ("-release_datetime",),
                "verbose_name": "CAL-ACCESS raw data version",
            },
        ),
        migrations.CreateModel(
            name="RcptCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "amount",
                    calaccess_raw.fields.DecimalField(
                        db_column="AMOUNT",
                        decimal_places=2,
                        help_text="Amount Received (Monetary, Inkkind, Promise)",
                        max_digits=14,
                    ),
                ),
                (
                    "bakref_tid",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAKREF_TID",
                        help_text="Back Reference to a transaction identifier of a parent record",
                        max_length=20,
                    ),
                ),
                (
                    "bal_juris",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_JURIS",
                        help_text="Jurisdiction of ballot measure. Used on the Form 401 Schedule A",
                        max_length=40,
                    ),
                ),
                (
                    "bal_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_NAME",
                        help_text="Ballot measure name. Used on the Form 401 Schedule A",
                        max_length=200,
                    ),
                ),
                (
                    "bal_num",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_NUM",
                        help_text="Ballot measure number or letter. Used on the Form 401 Schedule A",
                        max_length=7,
                    ),
                ),
                (
                    "cand_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMF",
                        help_text="Candidate/officeholder's first name. Used on the Form 401 Schedule A",
                        max_length=45,
                    ),
                ),
                (
                    "cand_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAML",
                        help_text="Candidate/officeholder's last name. Used on the Form 401 Schedule A",
                        max_length=200,
                    ),
                ),
                (
                    "cand_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMS",
                        help_text="Candidate/officeholder's name suffix. Used on the Form 401 Schedule A",
                        max_length=10,
                    ),
                ),
                (
                    "cand_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMT",
                        help_text="Candidate/officeholder's name prefix or title. Used on the Form 401 Schedule A",
                        max_length=10,
                    ),
                ),
                (
                    "cmte_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CMTE_ID",
                        help_text="Committee Identification number",
                        max_length=9,
                    ),
                ),
                (
                    "ctrib_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CTRIB_CITY",
                        help_text="Contributor's City",
                        max_length=30,
                    ),
                ),
                (
                    "ctrib_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CTRIB_DSCR",
                        help_text="Description of goods/services received",
                        max_length=90,
                    ),
                ),
                (
                    "ctrib_emp",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CTRIB_EMP",
                        help_text="Employer",
                        max_length=200,
                    ),
                ),
                (
                    "ctrib_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CTRIB_NAMF",
                        help_text="Contributor's First Name",
                        max_length=45,
                    ),
                ),
                (
                    "ctrib_naml",
                    calaccess_raw.fields.CharField(
                        db_column="CTRIB_NAML",
                        help_text="Contributor's last name or business name",
                        max_length=200,
                    ),
                ),
                (
                    "ctrib_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CTRIB_NAMS",
                        help_text="Contributor's Suffix",
                        max_length=10,
                    ),
                ),
                (
                    "ctrib_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CTRIB_NAMT",
                        help_text="Contributor's Prefix or Title",
                        max_length=10,
                    ),
                ),
                (
                    "ctrib_occ",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CTRIB_OCC",
                        help_text="Occupation",
                        max_length=60,
                    ),
                ),
                (
                    "ctrib_self",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CTRIB_SELF",
                        help_text="Self Employed Check-box",
                        max_length=1,
                    ),
                ),
                (
                    "ctrib_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CTRIB_ST",
                        help_text="Contributor's State",
                        max_length=2,
                    ),
                ),
                (
                    "ctrib_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CTRIB_ZIP4",
                        help_text="Contributor's ZIP+4",
                        max_length=10,
                    ),
                ),
                (
                    "cum_oth",
                    calaccess_raw.fields.DecimalField(
                        blank=True,
                        db_column="CUM_OTH",
                        decimal_places=2,
                        help_text="Cumulative Other (Sched A, A-1)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "cum_ytd",
                    calaccess_raw.fields.DecimalField(
                        blank=True,
                        db_column="CUM_YTD",
                        decimal_places=2,
                        help_text="Cumulative year to date amount (Form 460 Schedule A and Form 401 Schedule A, A-1)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "date_thru",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="DATE_THRU",
                        help_text="End of date range for items received",
                        null=True,
                    ),
                ),
                (
                    "dist_no",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="DIST_NO",
                        help_text="Office District Number (used on F401A)",
                        max_length=3,
                    ),
                ),
                (
                    "entity_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("COM", b"Committee"),
                            ("IND", b"Individual"),
                            ("PTY", b"Political Party"),
                            ("OTH", b"Other"),
                            ("RCP", b"Recipient committee"),
                            ("SCC", b"Small Contributor Committee"),
                            ("Com", b"Committee"),
                            ("CAO", b"Candidate/officeholder"),
                            ("BNM", b"Ballot measure's name/title"),
                            ("OFF", b"Officer"),
                            ("0", "Unknown"),
                            ("PTH", "Unknown"),
                            ("RFD", "Unknown"),
                            ("MBR", "Unknown"),
                        ],
                        db_column="ENTITY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=71
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=29
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=37
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=9,
                                id=b"2712033-Cal-Format-1-05-02",
                                start_page=8,
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=11, id=b"2712034-Cal-Format-201", start_page=9
                            ),
                        ],
                        help_text="Entity Code describing the contributor",
                        max_length=3,
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"E530",
                                b"Electronic Form 530: Electronic Issue Advocacy Report",
                            ),
                            (
                                b"F900",
                                b"Form 900: Public employee's retirement board, candidate campaign statement",
                            ),
                            (
                                b"F401A",
                                b"Form 401 (Slate Mailer Organization Campaign Statement): Schedule A, Payments Received",
                            ),
                            (
                                b"A",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule A, Monetary Contributions Received",
                            ),
                            (
                                b"A-1",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule A-1, Contributions Transferred to Special Election Commitee",
                            ),
                            (
                                b"C",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule C, Non-Monetary Contributions Received",
                            ),
                            (
                                b"I",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule I, miscellanous increases to cash",
                            ),
                            (
                                b"F496P3",
                                b"Form 496 (Late Independent Expenditure Report): Part 3, Contributions > $100 Received",
                            ),
                        ],
                        db_column="FORM_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=29
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=37
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=9,
                    ),
                ),
                (
                    "int_rate",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INT_RATE",
                        help_text="This field is undocumented",
                        max_length=9,
                    ),
                ),
                (
                    "intr_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INTR_CITY",
                        help_text="Intermediary's City",
                        max_length=30,
                    ),
                ),
                (
                    "intr_cmteid",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INTR_CMTEID",
                        help_text="This field is undocumented",
                        max_length=9,
                    ),
                ),
                (
                    "intr_emp",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INTR_EMP",
                        help_text="Intermediary's Employer",
                        max_length=200,
                    ),
                ),
                (
                    "intr_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INTR_NAMF",
                        help_text="Intermediary's First Name",
                        max_length=45,
                    ),
                ),
                (
                    "intr_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INTR_NAML",
                        help_text="Intermediary's Last Name",
                        max_length=200,
                    ),
                ),
                (
                    "intr_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INTR_NAMS",
                        help_text="Intermediary's Suffix",
                        max_length=10,
                    ),
                ),
                (
                    "intr_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INTR_NAMT",
                        help_text="Intermediary's Prefix or Title",
                        max_length=10,
                    ),
                ),
                (
                    "intr_occ",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INTR_OCC",
                        help_text="Intermediary's Occupation",
                        max_length=60,
                    ),
                ),
                (
                    "intr_self",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INTR_SELF",
                        help_text="Intermediary's self employed check box",
                        max_length=1,
                    ),
                ),
                (
                    "intr_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INTR_ST",
                        help_text="Intermediary's state",
                        max_length=2,
                    ),
                ),
                (
                    "intr_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="INTR_ZIP4",
                        help_text="Intermediary's zip code",
                        max_length=10,
                    ),
                ),
                (
                    "juris_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"ASM", b"Assembly District"),
                            (b"BOE", b"Board of Equalization District"),
                            (b"CIT", b"City"),
                            (b"CTY", b"County"),
                            (b"LOC", b"Local"),
                            (b"OTH", b"Other"),
                            (b"SEN", b"Senate District"),
                            (b"STW", b"Statewide"),
                            ("BED", b"Other"),
                            ("CLB", b"Other"),
                            ("COU", b"County"),
                            ("CO", b"Other"),
                            ("SAC", "Unknown"),
                            ("PER", "Unknown"),
                            ("SF", "Unknown"),
                            ("OR", "Unknown"),
                            ("AL", "Unknown"),
                            ("4", "Unknown"),
                            ("CA", "Unknown"),
                        ],
                        db_column="JURIS_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=74
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=30
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=40
                            ),
                        ],
                        help_text="Office jurisdiction code. See the CAL document for the list of legal values. Used on Form 401 Schedule A",
                        max_length=3,
                    ),
                ),
                (
                    "juris_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="JURIS_DSCR",
                        help_text="Office Jurisdiction Description (used on F401A)",
                        max_length=40,
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                    ),
                ),
                (
                    "memo_code",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_CODE",
                        help_text="Memo amount flag (Date/Amount are informational only)",
                        max_length=1,
                    ),
                ),
                (
                    "memo_refno",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_REFNO",
                        help_text="Reference to text contained in a TEXT record",
                        max_length=20,
                    ),
                ),
                (
                    "off_s_h_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[("S", b"SOUGHT"), ("H", b"HELD")],
                        db_column="OFF_S_H_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=75
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=30
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=40
                            ),
                        ],
                        help_text="Office is sought or held code",
                        max_length=1,
                    ),
                ),
                (
                    "offic_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="OFFIC_DSCR",
                        help_text="Office Sought Description (used on F401A)",
                        max_length=40,
                    ),
                ),
                (
                    "office_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"APP", b"State Appellate Court Justice"),
                            (b"ASM", b"State Assembly Person"),
                            (b"ASR", b"Assessor"),
                            (b"ATT", b"Attorney General"),
                            (b"BED", b"Board of Education"),
                            (b"BOE", b"Board of Equalization Member"),
                            (b"BSU", b"Board of Supervisors"),
                            (b"CAT", b"City Attorney"),
                            (b"CCB", b"Community College Board"),
                            (b"CCM", b"City Council Member"),
                            (b"CON", b"State Controller"),
                            (b"COU", b"County Counsel"),
                            (b"CSU", b"County Supervisor"),
                            (b"CTR", b"Local Controller"),
                            (b"DAT", b"District Attorney"),
                            (b"GOV", b"Governor"),
                            (b"INS", b"Insurance Commissioner"),
                            (b"LTG", b"Lieutenant Governor"),
                            (b"MAY", b"Mayor"),
                            (b"OTH", b"Other"),
                            (b"PDR", b"Public Defender"),
                            (b"PER", b"Public Employees Retirement System"),
                            (b"PLN", b"Planning Commissioner"),
                            (b"SCJ", b"Superior Court Judge"),
                            (b"SEN", b"State Senator"),
                            (b"SHC", b"Sheriff-Coroner"),
                            (b"SOS", b"Secretary of State"),
                            (b"SPM", b"Supreme Court Justice"),
                            (b"SUP", b"Superintendent of Public Instruction"),
                            (b"TRE", b"State Treasurer"),
                            (b"TRS", b"Local Treasurer"),
                            ("asm", b"State Assembly Person"),
                            ("gov", b"Governor"),
                            ("OTh", b"Other"),
                            ("oth", b"Other"),
                            ("csu", b"County Supervisor"),
                            ("H", "Unknown"),
                            ("HOU", "Unknown"),
                            ("ASS", "Unknown"),
                        ],
                        db_column="OFFICE_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=10
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=12
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712032-Cal-Errata-201", start_page=2
                            ),
                        ],
                        help_text="Identifies the office being sought",
                        max_length=3,
                        verbose_name="office code",
                    ),
                ),
                (
                    "rcpt_date",
                    calaccess_raw.fields.DateField(
                        db_column="RCPT_DATE", help_text="Date item received", null=True
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                "E530",
                                b"Electronic Form 530: Electronic Issue Advocacy Report",
                            ),
                            ("RCPT", "Receipt"),
                        ],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=71
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=37
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=29
                            ),
                        ],
                        help_text="Record Type Value: CVR",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "sup_opp_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("S", b"SUPPORT"),
                            ("O", b"OPPOSITION"),
                            ("F", "Unknown"),
                        ],
                        db_column="SUP_OPP_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=74
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=30
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=40
                            ),
                        ],
                        help_text="Support or opposition code",
                        max_length=1,
                    ),
                ),
                (
                    "tran_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRAN_ID",
                        help_text="Permanent value unique to this item",
                        max_length=20,
                        verbose_name="transaction ID",
                    ),
                ),
                (
                    "tran_type",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("F", "Forgiven Loan"),
                            ("I", "Intermediary"),
                            ("R", "Returned (Negative Amount?)"),
                            ("T", "Third Party Repayment"),
                            ("X", "Transfer"),
                            ("0", "Unknown"),
                            ("I", "Unknown"),
                            ("M", "Unknown"),
                            ("N", "Unknown"),
                            ("R", "Unknown"),
                            ("T", "Unknown"),
                        ],
                        db_column="TRAN_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=72
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=29
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=38
                            ),
                        ],
                        help_text="Transaction Type",
                        max_length=1,
                    ),
                ),
                (
                    "tres_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_CITY",
                        help_text="City portion of the treasurer or responsible officer's street address",
                        max_length=30,
                    ),
                ),
                (
                    "tres_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAMF",
                        help_text="Treasurer or responsible officer's first name",
                        max_length=45,
                    ),
                ),
                (
                    "tres_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAML",
                        help_text="Treasurer or responsible officer's last name",
                        max_length=200,
                    ),
                ),
                (
                    "tres_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAMS",
                        help_text="Treasurer or responsible officer's suffix",
                        max_length=10,
                    ),
                ),
                (
                    "tres_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_NAMT",
                        help_text="Treasurer or responsible officer's prefix or title",
                        max_length=10,
                    ),
                ),
                (
                    "tres_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_ST",
                        help_text="State portion of the treasurer or responsible officer's address",
                        max_length=2,
                    ),
                ),
                (
                    "tres_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRES_ZIP4",
                        help_text="Zip code portion of the treasurer or responsible officer's address",
                        max_length=10,
                        null=True,
                    ),
                ),
                (
                    "xref_match",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="XREF_MATCH",
                        help_text="Related item on other schedule has same transaction identifier. 'X' indicates this condition is true",
                        max_length=1,
                    ),
                ),
                (
                    "xref_schnm",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="XREF_SCHNM",
                        help_text="Related record is included on Sched 'B2' or 'F'",
                        max_length=2,
                    ),
                ),
            ],
            options={
                "db_table": "RCPT_CD",
                "verbose_name": "RCPT_CD",
                "verbose_name_plural": "RCPT_CD",
            },
        ),
        migrations.CreateModel(
            name="ReceivedFilingsCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filer_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILER_ID",
                        db_index=True,
                        help_text="Filer's unique identification number",
                        null=True,
                        verbose_name="filer ID",
                    ),
                ),
                (
                    "filing_file_name",
                    calaccess_raw.fields.CharField(
                        db_column="FILING_FILE_NAME",
                        help_text="The field is undocumented",
                        max_length=14,
                    ),
                ),
                (
                    "received_date",
                    calaccess_raw.fields.DateField(
                        db_column="RECEIVED_DATE", help_text="Date received", null=True
                    ),
                ),
                (
                    "filing_directory",
                    calaccess_raw.fields.CharField(
                        db_column="FILING_DIRECTORY",
                        help_text="This field is undocumented",
                        max_length=45,
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        null=True,
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "form_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (
                                b"F400",
                                b"Form 400: Statement of Organization (Slate Mailer Organization)",
                            ),
                            (
                                b"F401",
                                b"Form 401: Slate Mailer Organization Campaign Statement",
                            ),
                            (
                                b"F402",
                                b"Form 402: Statement of Termination (Slate Mailer Organization)",
                            ),
                            (
                                b"F410",
                                b"Form 410: Statement of Organization Recipient Committee",
                            ),
                            (
                                b"F425",
                                b"Form 425: Semi-Annual Statement of no Activity",
                            ),
                            (
                                b"F450",
                                b"Form 450: Recipient Committee Campaign Disclosure Statement - Short Form",
                            ),
                            (
                                b"F460",
                                b"Form 460: Recipient Committee Campaign Statement",
                            ),
                            (
                                b"F461",
                                b"Form 461: Independent Expenditure Committee & Major Donor Committee Campaign Statement",
                            ),
                            (
                                b"F465",
                                b"Form 465: Supplemental Independent Expenditure Report",
                            ),
                            (b"F496", b"Form 496: Late Independent Expenditure Report"),
                            (b"F497", b"Form 497: Late Contribution Report"),
                            (b"F498", b"Form 498: Slate Mailer Late Payment Report"),
                            (
                                b"F601",
                                b"Form 601: Lobbying Firm Registration Statement",
                            ),
                            (
                                b"F602",
                                b"Form 602: Lobbying Firm Activity Authorization",
                            ),
                            (
                                b"F603",
                                b"Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                            ),
                            (b"F604", b"Form 604: Lobbyist Certification Statement"),
                            (b"F606", b"Form 606: Notice of Termination"),
                            (b"F607", b"Form 607: Notice of Withdrawal"),
                            (b"F615", b"Form 615: Lobbyist Report"),
                            (b"F625", b"Form 625: Report of Lobbying Firm"),
                            (
                                b"F635",
                                b"Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                            ),
                            (
                                b"F645",
                                b"Form 645: Report of Person Spending $5,000 or More",
                            ),
                        ],
                        db_column="FORM_ID",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=8, id="2711624-Overview", start_page=4
                            )
                        ],
                        help_text="Form identification code",
                        max_length=4,
                        verbose_name="form identification code",
                    ),
                ),
                (
                    "receive_comment",
                    calaccess_raw.fields.CharField(
                        db_column="RECEIVE_COMMENT",
                        help_text="A comment",
                        max_length=51,
                    ),
                ),
            ],
            options={
                "db_table": "RECEIVED_FILINGS_CD",
                "verbose_name": "RECEIVED_FILINGS_CD",
                "verbose_name_plural": "RECEIVED_FILINGS_CD",
            },
        ),
        migrations.CreateModel(
            name="ReportsCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "rpt_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="RPT_ID", help_text="Unique identification number"
                    ),
                ),
                (
                    "rpt_name",
                    calaccess_raw.fields.CharField(
                        db_column="RPT_NAME",
                        help_text="Name of the report",
                        max_length=74,
                    ),
                ),
                (
                    "rpt_desc_field",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="RPT_DESC_",
                        help_text="Description of the report",
                        max_length=32,
                    ),
                ),
                (
                    "path",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PATH",
                        help_text="Report path",
                        max_length=32,
                    ),
                ),
                (
                    "data_object",
                    calaccess_raw.fields.CharField(
                        db_column="DATA_OBJECT",
                        help_text="This field is undocumented",
                        max_length=38,
                    ),
                ),
                (
                    "parms_flg_y_n",
                    calaccess_raw.fields.IntegerField(
                        blank=True,
                        db_column="PARMS_FLG_Y_N",
                        help_text="Parameters indication flag",
                        null=True,
                    ),
                ),
                (
                    "rpt_type",
                    calaccess_raw.fields.IntegerField(
                        choices=[
                            (401, "PUBLIC REPORTS"),
                            (402, "AUDITS"),
                            (403, "FINANCIAL REPORTS"),
                            (404, "AUDITS"),
                            (405, "MAILING LABELS"),
                            (406, "OTHER REPORTS"),
                            (0, "N/A"),
                        ],
                        db_column="RPT_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2774529-Lookup-Codes-Cd", start_page=2
                            )
                        ],
                        help_text="Type of the report",
                    ),
                ),
                (
                    "parm_definition",
                    calaccess_raw.fields.IntegerField(
                        db_column="PARM_DEFINITION", help_text="Parameter definition"
                    ),
                ),
            ],
            options={
                "db_table": "REPORTS_CD",
                "verbose_name": "REPORTS_CD",
                "verbose_name_plural": "REPORTS_CD",
            },
        ),
        migrations.CreateModel(
            name="S401Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("S401", "S401")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=39
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=51
                            ),
                        ],
                        help_text="Record Type Value: S401",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (
                                b"F401B",
                                b"Form 401 (Slate Mailer Organization Campaign Statement): Schedule B, Payments Made",
                            ),
                            (
                                b"F401B-1",
                                b"Form 401 (Slate Mailer Organization Campaign Statement): Schedule B-1, Payments Made by Agent or Independent Contractor",
                            ),
                            (
                                b"F401C",
                                b"Form 401 (Slate Mailer Organization Campaign Statement): Schedule C, Persons Receiving $1,000 or More",
                            ),
                            (
                                b"F401D",
                                b"Form 401 (Slate Mailer Organization Campaign Statement): Schedule D, Candidates and Measures Not Listed on Schedule A",
                            ),
                        ],
                        db_column="FORM_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=39
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=51
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=7,
                    ),
                ),
                (
                    "tran_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRAN_ID",
                        help_text="Permanent value unique to this item",
                        max_length=20,
                        verbose_name="transaction ID",
                    ),
                ),
                (
                    "agent_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="AGENT_NAML",
                        help_text="Agent or independent contractor's last name",
                        max_length=200,
                    ),
                ),
                (
                    "agent_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="AGENT_NAMF",
                        help_text="Agent or independent contractor's first name",
                        max_length=45,
                    ),
                ),
                (
                    "agent_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="AGENT_NAMT",
                        help_text="Agent or independent contractor's title or prefix",
                        max_length=200,
                    ),
                ),
                (
                    "agent_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="AGENT_NAMS",
                        help_text="Agent or independent contractor's suffix",
                        max_length=10,
                    ),
                ),
                (
                    "payee_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_NAML",
                        help_text="Payee's business name or last name if the payee is an individual",
                        max_length=200,
                    ),
                ),
                (
                    "payee_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_NAMF",
                        help_text="Payee's first name if the payee is an individual",
                        max_length=45,
                    ),
                ),
                (
                    "payee_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_NAMT",
                        help_text="Payee's title or prefix if the payee is an individual",
                        max_length=10,
                    ),
                ),
                (
                    "payee_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_NAMS",
                        help_text="Payee's suffix if the payee is an individual",
                        max_length=10,
                    ),
                ),
                (
                    "payee_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_CITY",
                        help_text="Payee's city address",
                        max_length=30,
                    ),
                ),
                (
                    "payee_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_ST",
                        help_text="Payee state address",
                        max_length=2,
                    ),
                ),
                (
                    "payee_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYEE_ZIP4",
                        help_text="Payee ZIP Code",
                        max_length=10,
                    ),
                ),
                (
                    "amount",
                    calaccess_raw.fields.DecimalField(
                        db_column="AMOUNT",
                        decimal_places=2,
                        help_text="Amount (Sched F401B, 401B-1, 401C)",
                        max_digits=16,
                    ),
                ),
                (
                    "aggregate",
                    calaccess_raw.fields.DecimalField(
                        db_column="AGGREGATE",
                        decimal_places=2,
                        help_text="Aggregate year-to-date amount (Sched 401C)",
                        max_digits=16,
                    ),
                ),
                (
                    "expn_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EXPN_DSCR",
                        help_text="Purpose of expense and/or description/explanation",
                        max_length=90,
                    ),
                ),
                (
                    "cand_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAML",
                        help_text="Candidate/officeholder last name",
                        max_length=200,
                    ),
                ),
                (
                    "cand_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMF",
                        help_text="Candidate/officeholder first name",
                        max_length=45,
                    ),
                ),
                (
                    "cand_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMT",
                        help_text="Candidate/officeholder title or prefix",
                        max_length=10,
                    ),
                ),
                (
                    "cand_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMS",
                        help_text="Candidate/officeholder suffix",
                        max_length=10,
                    ),
                ),
                (
                    "office_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"APP", b"State Appellate Court Justice"),
                            (b"ASM", b"State Assembly Person"),
                            (b"ASR", b"Assessor"),
                            (b"ATT", b"Attorney General"),
                            (b"BED", b"Board of Education"),
                            (b"BOE", b"Board of Equalization Member"),
                            (b"BSU", b"Board of Supervisors"),
                            (b"CAT", b"City Attorney"),
                            (b"CCB", b"Community College Board"),
                            (b"CCM", b"City Council Member"),
                            (b"CON", b"State Controller"),
                            (b"COU", b"County Counsel"),
                            (b"CSU", b"County Supervisor"),
                            (b"CTR", b"Local Controller"),
                            (b"DAT", b"District Attorney"),
                            (b"GOV", b"Governor"),
                            (b"INS", b"Insurance Commissioner"),
                            (b"LTG", b"Lieutenant Governor"),
                            (b"MAY", b"Mayor"),
                            (b"OTH", b"Other"),
                            (b"PDR", b"Public Defender"),
                            (b"PER", b"Public Employees Retirement System"),
                            (b"PLN", b"Planning Commissioner"),
                            (b"SCJ", b"Superior Court Judge"),
                            (b"SEN", b"State Senator"),
                            (b"SHC", b"Sheriff-Coroner"),
                            (b"SOS", b"Secretary of State"),
                            (b"SPM", b"Supreme Court Justice"),
                            (b"SUP", b"Superintendent of Public Instruction"),
                            (b"TRE", b"State Treasurer"),
                            (b"TRS", b"Local Treasurer"),
                            ("asm", b"State Assembly Person"),
                            ("ltg", b"Lieutenant Governor"),
                            ("OTh", b"Other"),
                            ("att", b"Attorney General"),
                            ("oth", b"Other"),
                            ("tre", b"State Treasurer"),
                            ("con", b"State Controller"),
                            ("boe", b"Board of Equalization Member"),
                            ("sos", b"Secretary of State"),
                            ("sup", b"Superintendent of Public Instruction"),
                            ("H", "Unknown"),
                        ],
                        db_column="OFFICE_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id=b"2712033-Cal-Format-1-05-02", start_page=10
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id=b"2712034-Cal-Format-201", start_page=12
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id=b"2712032-Cal-Errata-201", start_page=2
                            ),
                        ],
                        help_text="Identifies the office being sought",
                        max_length=3,
                        verbose_name="office code",
                    ),
                ),
                (
                    "offic_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="OFFIC_DSCR",
                        help_text="Office sought description",
                        max_length=40,
                    ),
                ),
                (
                    "juris_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"ASM", b"Assembly District"),
                            (b"BOE", b"Board of Equalization District"),
                            (b"CIT", b"City"),
                            (b"CTY", b"County"),
                            (b"LOC", b"Local"),
                            (b"OTH", b"Other"),
                            (b"SEN", b"Senate District"),
                            (b"STW", b"Statewide"),
                            ("SAC", "Unknown"),
                            ("CT", "Unknown"),
                            ("ca", "Unknown"),
                            ("CAL", "Unknown"),
                            ("OR", "Unknown"),
                            ("AL", "Unknown"),
                            ("CA", "Unknown"),
                            ("10", "Unknown"),
                        ],
                        db_column="JURIS_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=77
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=39
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=52
                            ),
                        ],
                        help_text="Office jurisdiction code",
                        max_length=3,
                    ),
                ),
                (
                    "juris_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="JURIS_DSCR",
                        help_text="Office jurisdiction description",
                        max_length=40,
                    ),
                ),
                (
                    "dist_no",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="DIST_NO",
                        help_text="District number for the office being sought. Populated for Senate, Assembly, or Board of Equalization races.",
                        max_length=3,
                    ),
                ),
                (
                    "off_s_h_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[("S", b"SOUGHT"), ("H", b"HELD")],
                        db_column="OFF_S_H_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=39
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=52
                            ),
                        ],
                        help_text="Office is sought or held code",
                        max_length=1,
                    ),
                ),
                (
                    "bal_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_NAME",
                        help_text="Ballot measure name",
                        max_length=200,
                    ),
                ),
                (
                    "bal_num",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_NUM",
                        help_text="Ballot measure number or letter",
                        max_length=7,
                    ),
                ),
                (
                    "bal_juris",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_JURIS",
                        help_text="Ballot measure jurisdiction",
                        max_length=40,
                    ),
                ),
                (
                    "sup_opp_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[("S", b"SUPPORT"), ("O", b"OPPOSITION")],
                        db_column="SUP_OPP_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=39
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=52
                            ),
                        ],
                        help_text="Support or opposition code",
                        max_length=1,
                    ),
                ),
                (
                    "memo_code",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_CODE",
                        help_text="Memo amount flag",
                        max_length=1,
                    ),
                ),
                (
                    "memo_refno",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_REFNO",
                        help_text="Reference to text contained in the TEXT record",
                        max_length=20,
                    ),
                ),
                (
                    "bakref_tid",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAKREF_TID",
                        help_text="Back reference to transaction identifier of parent record",
                        max_length=20,
                    ),
                ),
            ],
            options={
                "db_table": "S401_CD",
                "verbose_name": "S401_CD",
                "verbose_name_plural": "S401_CD",
            },
        ),
        migrations.CreateModel(
            name="S496Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("S496", "S496")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=40
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=53
                            ),
                        ],
                        help_text="Record Type Value: S496",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"F496", b"Form 496: Late Independent Expenditure Report")
                        ],
                        db_column="FORM_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=40
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=53
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=4,
                    ),
                ),
                (
                    "tran_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRAN_ID",
                        help_text="Permanent value unique to this item",
                        max_length=20,
                        verbose_name="transaction ID",
                    ),
                ),
                (
                    "amount",
                    calaccess_raw.fields.DecimalField(
                        db_column="AMOUNT",
                        decimal_places=2,
                        help_text="Expenditure amount",
                        max_digits=16,
                    ),
                ),
                (
                    "exp_date",
                    calaccess_raw.fields.DateField(
                        db_column="EXP_DATE", help_text="Expenditure dates", null=True
                    ),
                ),
                (
                    "expn_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EXPN_DSCR",
                        help_text="Purpose of expense and/or description/explanation",
                        max_length=90,
                    ),
                ),
                (
                    "memo_code",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_CODE",
                        help_text="Memo amount flag",
                        max_length=1,
                    ),
                ),
                (
                    "memo_refno",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_REFNO",
                        help_text="Reference to text contained in a TEXT record",
                        max_length=20,
                    ),
                ),
                (
                    "date_thru",
                    calaccess_raw.fields.DateField(
                        db_column="DATE_THRU",
                        help_text="End of date range for items paid",
                        null=True,
                    ),
                ),
            ],
            options={
                "db_table": "S496_CD",
                "verbose_name": "S496_CD",
                "verbose_name_plural": "S496_CD",
            },
        ),
        migrations.CreateModel(
            name="S497Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("S497", "S497")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=41
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=54
                            ),
                        ],
                        help_text="Record Type Value: S497",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"F497P1",
                                b"Form 497 (Late Contribution Report): Part 1, Contribution(s) Received",
                            ),
                            (
                                b"F497P2",
                                b"Form 497 (Late Contribution Report): Part 2, Contribution(s) Made",
                            ),
                        ],
                        db_column="FORM_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=41
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=54
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=6,
                    ),
                ),
                (
                    "tran_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRAN_ID",
                        help_text="Permanent value unique to this item",
                        max_length=20,
                        verbose_name="transaction ID",
                    ),
                ),
                (
                    "entity_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("BNM", b"Ballot measure's name/title"),
                            ("CAO", b"Candidate/officeholder"),
                            ("CTL", b"Controlled committee"),
                            ("COM", b"Committee"),
                            ("com", b"Committee"),
                            ("IND", b"Individual"),
                            ("OFF", b"Officer"),
                            ("OTH", b"Other"),
                            ("PTY", b"Political Party"),
                            ("RCP", b"Recipient committee"),
                            ("SCC", b"Small Contributor Committee"),
                            ("0", "Unknown"),
                        ],
                        db_column="ENTITY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=9,
                                id=b"2712033-Cal-Format-1-05-02",
                                start_page=8,
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=11, id=b"2712034-Cal-Format-201", start_page=9
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=41
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=54
                            ),
                        ],
                        help_text="Entity Code describing the Contributor/Recipient",
                        max_length=3,
                        verbose_name="entity code",
                    ),
                ),
                (
                    "enty_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_NAML",
                        help_text="Last name of Contributor/Recipient",
                        max_length=200,
                    ),
                ),
                (
                    "enty_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_NAMF",
                        help_text="First name of Contributor/Recipient",
                        max_length=45,
                    ),
                ),
                (
                    "enty_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_NAMT",
                        help_text="Name title or prefix of Contributor/Recipient",
                        max_length=10,
                    ),
                ),
                (
                    "enty_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_NAMS",
                        help_text="Name suffix of Contributor/Recipient",
                        max_length=10,
                    ),
                ),
                (
                    "enty_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_CITY",
                        help_text="City address of Contributor/Recipient",
                        max_length=30,
                    ),
                ),
                (
                    "enty_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_ST",
                        help_text="State address of Contributor/Recipient",
                        max_length=2,
                    ),
                ),
                (
                    "enty_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="ENTY_ZIP4",
                        help_text="ZIP Code of Contributor/Recipient",
                        max_length=10,
                    ),
                ),
                (
                    "ctrib_emp",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CTRIB_EMP",
                        help_text="Employer of Contributor (populated for some Recipients as well)",
                        max_length=200,
                    ),
                ),
                (
                    "ctrib_occ",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CTRIB_OCC",
                        help_text="Occupation of Contributor (populated for some Recipients as well)",
                        max_length=60,
                    ),
                ),
                (
                    "ctrib_self",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CTRIB_SELF",
                        help_text='Contributor self-employed checkbox. "X" indicates the contributor is self-employed.',
                        max_length=1,
                        verbose_name="Contributor self-employed checkbox",
                    ),
                ),
                (
                    "elec_date",
                    calaccess_raw.fields.DateField(
                        db_column="ELEC_DATE", help_text="Date of election", null=True
                    ),
                ),
                (
                    "ctrib_date",
                    calaccess_raw.fields.DateField(
                        db_column="CTRIB_DATE",
                        help_text="Date item received/made",
                        null=True,
                    ),
                ),
                (
                    "date_thru",
                    calaccess_raw.fields.DateField(
                        db_column="DATE_THRU",
                        help_text="End of date range for items received",
                        null=True,
                    ),
                ),
                (
                    "amount",
                    calaccess_raw.fields.DecimalField(
                        db_column="AMOUNT",
                        decimal_places=2,
                        help_text="Amount received/made",
                        max_digits=16,
                    ),
                ),
                (
                    "cmte_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CMTE_ID",
                        help_text="Committee identification number",
                        max_length=9,
                        verbose_name="Committee ID",
                    ),
                ),
                (
                    "cand_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAML",
                        help_text="Candidate/officeholder's last name",
                        max_length=200,
                    ),
                ),
                (
                    "cand_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMF",
                        help_text="Candidate/officeholder's first name",
                        max_length=45,
                    ),
                ),
                (
                    "cand_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMT",
                        help_text="Candidate/officeholder's title or prefix",
                        max_length=10,
                    ),
                ),
                (
                    "cand_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMS",
                        help_text="Candidate/officeholder's suffix",
                        max_length=10,
                    ),
                ),
                (
                    "office_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"APP", b"State Appellate Court Justice"),
                            (b"ASM", b"State Assembly Person"),
                            (b"ASR", b"Assessor"),
                            (b"ATT", b"Attorney General"),
                            (b"BED", b"Board of Education"),
                            (b"BOE", b"Board of Equalization Member"),
                            (b"BSU", b"Board of Supervisors"),
                            (b"CAT", b"City Attorney"),
                            (b"CCB", b"Community College Board"),
                            (b"CCM", b"City Council Member"),
                            (b"CON", b"State Controller"),
                            (b"COU", b"County Counsel"),
                            (b"CSU", b"County Supervisor"),
                            (b"CTR", b"Local Controller"),
                            (b"DAT", b"District Attorney"),
                            (b"GOV", b"Governor"),
                            (b"INS", b"Insurance Commissioner"),
                            (b"LTG", b"Lieutenant Governor"),
                            (b"MAY", b"Mayor"),
                            (b"OTH", b"Other"),
                            (b"PDR", b"Public Defender"),
                            (b"PER", b"Public Employees Retirement System"),
                            (b"PLN", b"Planning Commissioner"),
                            (b"SCJ", b"Superior Court Judge"),
                            (b"SEN", b"State Senator"),
                            (b"SHC", b"Sheriff-Coroner"),
                            (b"SOS", b"Secretary of State"),
                            (b"SPM", b"Supreme Court Justice"),
                            (b"SUP", b"Superintendent of Public Instruction"),
                            (b"TRE", b"State Treasurer"),
                            (b"TRS", b"Local Treasurer"),
                            ("asm", b"State Assembly Person"),
                            ("sen", b"State Senator"),
                            ("Asm", b"State Assembly Person"),
                            ("May", b"Mayor"),
                            ("ASm", b"State Assembly Person"),
                            ("oth", b"Other"),
                            ("csu", b"County Supervisor"),
                            ("Oth", b"Other"),
                            ("H", "Unknown"),
                            ("S", "Unknown"),
                            ("OF", "Unknown"),
                            ("HOU", "Unknown"),
                            ("LOC", "Unknown"),
                            ("LEG", "Unknown"),
                            ("STW", "Unknown"),
                            ("P", "Unknown"),
                            ("LTV", "Unknown"),
                            ("LT", "Unknown"),
                            ("CTY", "Unknown"),
                            ("OFF", "Unknown"),
                            ("REP", "Unknown"),
                            ("COM", "Unknown"),
                            ("N/A", "Unknown"),
                        ],
                        db_column="OFFICE_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id=b"2712033-Cal-Format-1-05-02", start_page=10
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id=b"2712034-Cal-Format-201", start_page=12
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id=b"2712032-Cal-Errata-201", start_page=2
                            ),
                        ],
                        help_text="Identifies the office being sought",
                        max_length=3,
                        verbose_name="office code",
                    ),
                ),
                (
                    "offic_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="OFFIC_DSCR",
                        help_text="Office sought description",
                        max_length=40,
                    ),
                ),
                (
                    "juris_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"ASM", b"Assembly District"),
                            (b"BOE", b"Board of Equalization District"),
                            (b"CIT", b"City"),
                            (b"CTY", b"County"),
                            (b"LOC", b"Local"),
                            (b"OTH", b"Other"),
                            (b"SEN", b"Senate District"),
                            (b"STW", b"Statewide"),
                            ("asm", b"Assembly District"),
                            ("sen", b"Senate District"),
                            ("cit", b"City"),
                            ("GOV", b"Statewide"),
                            ("MAY", b"City"),
                            ("BSU", b"County"),
                            ("CSU", b"County"),
                            ("SUP", b"Statewide"),
                            ("BED", b"Other"),
                            ("CCB", b"Other"),
                            ("CCM", b"Other"),
                            ("CLB", b"Other"),
                            ("IRV", b"City"),
                            ("Fon", b"City"),
                            ("JRS", b"Statewide"),
                            ("CO", b"County"),
                            ("Riv", b"County"),
                            ("SNE", b"Senate District"),
                            ("83", b"Statewide"),
                            ("PER", "Unknown"),
                            ("FED", "Unknown"),
                            ("CA", "Unknown"),
                            ("JR", "Unknown"),
                        ],
                        db_column="JURIS_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=42
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=55
                            ),
                        ],
                        help_text="Jurisdiction code describing the office being sought",
                        max_length=3,
                        verbose_name="jurisdiction code",
                    ),
                ),
                (
                    "juris_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="JURIS_DSCR",
                        help_text="Office jurisdiction description",
                        max_length=40,
                    ),
                ),
                (
                    "dist_no",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="DIST_NO",
                        help_text="District number for the office being sought. Populated for Senate, Assembly, or Board of Equalization races.",
                        max_length=3,
                    ),
                ),
                (
                    "off_s_h_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"H", b"HELD"),
                            (b"S", b"SOUGHT"),
                            ("s", b"SOUGHT"),
                            ("h", b"HELD"),
                            ("F", "UNKNOWN"),
                            ("T", "UNKNOWN"),
                        ],
                        db_column="OFF_S_H_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=42
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=55
                            ),
                        ],
                        help_text="Office is sought or held code",
                        max_length=1,
                    ),
                ),
                (
                    "bal_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_NAME",
                        help_text="Ballot measure name",
                        max_length=200,
                    ),
                ),
                (
                    "bal_num",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_NUM",
                        help_text="Ballot measure number",
                        max_length=7,
                    ),
                ),
                (
                    "bal_juris",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_JURIS",
                        help_text="Ballot measure jurisdiction",
                        max_length=40,
                    ),
                ),
                (
                    "memo_code",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_CODE",
                        help_text="Memo amount flag",
                        max_length=1,
                    ),
                ),
                (
                    "memo_refno",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_REFNO",
                        help_text="Reference to text contained in TEXT code",
                        max_length=20,
                    ),
                ),
                (
                    "bal_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_ID",
                        help_text="This field is undocumented",
                        max_length=9,
                    ),
                ),
                (
                    "cand_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_ID",
                        help_text="This field is undocumented",
                        max_length=9,
                    ),
                ),
                (
                    "sup_off_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SUP_OFF_CD",
                        help_text="This field is undocumented",
                        max_length=1,
                    ),
                ),
                (
                    "sup_opp_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[(b"O", b"OPPOSITION"), (b"S", b"SUPPORT")],
                        db_column="SUP_OPP_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=82
                            )
                        ],
                        help_text="Support or opposition code",
                        max_length=1,
                    ),
                ),
            ],
            options={
                "db_table": "S497_CD",
                "verbose_name": "S497_CD",
                "verbose_name_plural": "S497_CD",
            },
        ),
        migrations.CreateModel(
            name="S498Cd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("S498", "S498")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=43
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=56
                            ),
                        ],
                        help_text="Record Type Value: S498",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (
                                b"F498-A",
                                b"Form 498 (Slate Mailer Late Payment Report): Part A, Late Payments Attributed To",
                            ),
                            (
                                b"F498-R",
                                b"Form 498 (Slate Mailer Late Payment Report): Part R, Late Payments Received From",
                            ),
                        ],
                        db_column="FORM_TYPE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=43
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=56
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=9,
                    ),
                ),
                (
                    "tran_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TRAN_ID",
                        help_text="Permanent value unique to this item",
                        max_length=20,
                        verbose_name="transaction ID",
                    ),
                ),
                (
                    "entity_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("CAO", b"Candidate/officeholder"),
                            ("COM", b"Committee"),
                            ("IND", b"Individual"),
                            ("OTH", b"Other"),
                            ("RCP", b"Recipient committee"),
                        ],
                        db_column="ENTITY_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=9,
                                id=b"2712033-Cal-Format-1-05-02",
                                start_page=8,
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=11, id=b"2712034-Cal-Format-201", start_page=9
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=43
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=56
                            ),
                        ],
                        help_text="Entity code",
                        max_length=3,
                        verbose_name="entity code",
                    ),
                ),
                (
                    "cmte_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CMTE_ID",
                        help_text="Committee identification number",
                        max_length=9,
                        verbose_name="Committee ID",
                    ),
                ),
                (
                    "payor_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYOR_NAML",
                        help_text="Payor's last name or business name",
                        max_length=200,
                    ),
                ),
                (
                    "payor_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYOR_NAMF",
                        help_text="Payor's first name.",
                        max_length=45,
                    ),
                ),
                (
                    "payor_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYOR_NAMT",
                        help_text="Payor's Prefix or title.",
                        max_length=10,
                    ),
                ),
                (
                    "payor_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYOR_NAMS",
                        help_text="Payor's suffix.",
                        max_length=10,
                    ),
                ),
                (
                    "payor_city",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYOR_CITY",
                        help_text="Payor's city.",
                        max_length=30,
                    ),
                ),
                (
                    "payor_st",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYOR_ST",
                        help_text="Payor's State.",
                        max_length=2,
                    ),
                ),
                (
                    "payor_zip4",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PAYOR_ZIP4",
                        help_text="Payor's zip code",
                        max_length=10,
                    ),
                ),
                (
                    "date_rcvd",
                    calaccess_raw.fields.DateField(
                        db_column="DATE_RCVD", help_text="Date received", null=True
                    ),
                ),
                (
                    "amt_rcvd",
                    calaccess_raw.fields.DecimalField(
                        db_column="AMT_RCVD",
                        decimal_places=2,
                        help_text="Amount received",
                        max_digits=16,
                    ),
                ),
                (
                    "cand_naml",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAML",
                        help_text="Candidate/officerholder last name",
                        max_length=200,
                    ),
                ),
                (
                    "cand_namf",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMF",
                        help_text="Candidate/officerholder first name",
                        max_length=45,
                    ),
                ),
                (
                    "cand_namt",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMT",
                        help_text="Candidate/officerholder title or prefix",
                        max_length=10,
                    ),
                ),
                (
                    "cand_nams",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="CAND_NAMS",
                        help_text="Candidate/officerholder suffix",
                        max_length=10,
                    ),
                ),
                (
                    "office_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"APP", b"State Appellate Court Justice"),
                            (b"ASM", b"State Assembly Person"),
                            (b"ASR", b"Assessor"),
                            (b"ATT", b"Attorney General"),
                            (b"BED", b"Board of Education"),
                            (b"BOE", b"Board of Equalization Member"),
                            (b"BSU", b"Board of Supervisors"),
                            (b"CAT", b"City Attorney"),
                            (b"CCB", b"Community College Board"),
                            (b"CCM", b"City Council Member"),
                            (b"CON", b"State Controller"),
                            (b"COU", b"County Counsel"),
                            (b"CSU", b"County Supervisor"),
                            (b"CTR", b"Local Controller"),
                            (b"DAT", b"District Attorney"),
                            (b"GOV", b"Governor"),
                            (b"INS", b"Insurance Commissioner"),
                            (b"LTG", b"Lieutenant Governor"),
                            (b"MAY", b"Mayor"),
                            (b"OTH", b"Other"),
                            (b"PDR", b"Public Defender"),
                            (b"PER", b"Public Employees Retirement System"),
                            (b"PLN", b"Planning Commissioner"),
                            (b"SCJ", b"Superior Court Judge"),
                            (b"SEN", b"State Senator"),
                            (b"SHC", b"Sheriff-Coroner"),
                            (b"SOS", b"Secretary of State"),
                            (b"SPM", b"Supreme Court Justice"),
                            (b"SUP", b"Superintendent of Public Instruction"),
                            (b"TRE", b"State Treasurer"),
                            (b"TRS", b"Local Treasurer"),
                            ("gov", b"Governor"),
                            ("oth", b"Other"),
                        ],
                        db_column="OFFICE_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id=b"2712033-Cal-Format-1-05-02", start_page=10
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id=b"2712034-Cal-Format-201", start_page=12
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id=b"2712032-Cal-Errata-201", start_page=2
                            ),
                        ],
                        help_text="Identifies the office being sought",
                        max_length=4,
                        verbose_name="office code",
                    ),
                ),
                (
                    "offic_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="OFFIC_DSCR",
                        help_text="Description of office sought",
                        max_length=40,
                    ),
                ),
                (
                    "juris_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            (b"ASM", b"Assembly District"),
                            (b"BOE", b"Board of Equalization District"),
                            (b"CIT", b"City"),
                            (b"CTY", b"County"),
                            (b"LOC", b"Local"),
                            (b"OTH", b"Other"),
                            (b"SEN", b"Senate District"),
                            (b"STW", b"Statewide"),
                            ("GOV", b"Statewide"),
                            ("COU", b"County"),
                        ],
                        db_column="JURIS_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=43
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=57
                            ),
                        ],
                        help_text="Office jurisdiction code",
                        max_length=3,
                    ),
                ),
                (
                    "juris_dscr",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="JURIS_DSCR",
                        help_text="Office jurisdiction description",
                        max_length=40,
                    ),
                ),
                (
                    "dist_no",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="DIST_NO",
                        help_text="District number for the office being sought. Populated for Senate, Assembly, or Board of Equalization races.",
                        max_length=3,
                    ),
                ),
                (
                    "off_s_h_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[(b"H", b"HELD"), (b"S", b"SOUGHT")],
                        db_column="OFF_S_H_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=44
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=57
                            ),
                        ],
                        help_text="Office is sought or held code",
                        max_length=1,
                    ),
                ),
                (
                    "bal_name",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_NAME",
                        help_text="Ballot measure name",
                        max_length=200,
                    ),
                ),
                (
                    "bal_num",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_NUM",
                        help_text="Ballot measure number or letter.",
                        max_length=7,
                    ),
                ),
                (
                    "bal_juris",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="BAL_JURIS",
                        help_text="Jurisdiction of ballot measure",
                        max_length=40,
                    ),
                ),
                (
                    "sup_opp_cd",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[(b"O", b"OPPOSITION"), (b"S", b"SUPPORT")],
                        db_column="SUP_OPP_CD",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=43
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=57
                            ),
                        ],
                        help_text="Support or opposition code",
                        max_length=1,
                    ),
                ),
                (
                    "amt_attrib",
                    calaccess_raw.fields.DecimalField(
                        db_column="AMT_ATTRIB",
                        decimal_places=2,
                        help_text="Amount attributed (only if Form_type = 'F498-A')",
                        max_digits=16,
                    ),
                ),
                (
                    "memo_code",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_CODE",
                        help_text="Memo amount flat",
                        max_length=1,
                    ),
                ),
                (
                    "memo_refno",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="MEMO_REFNO",
                        help_text="Reference text contained in TEXT record",
                        max_length=20,
                    ),
                ),
                (
                    "employer",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="EMPLOYER",
                        help_text="This field is undocumented",
                        max_length=200,
                    ),
                ),
                (
                    "occupation",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="OCCUPATION",
                        help_text="This field is undocumented",
                        max_length=60,
                    ),
                ),
                (
                    "selfemp_cb",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="SELFEMP_CB",
                        help_text="Self-employed checkbox",
                        max_length=1,
                    ),
                ),
            ],
            options={
                "db_table": "S498_CD",
                "verbose_name": "S498_CD",
                "verbose_name_plural": "S498_CD",
            },
        ),
        migrations.CreateModel(
            name="SmryCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.CharField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                        max_length=8,
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[("SMRY", "SMRY")],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=27
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=59
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=35
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=72
                            ),
                        ],
                        help_text="Record Type Value: SMRY",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"F401",
                                b"Form 401: Slate Mailer Organization Campaign Statement",
                            ),
                            (
                                b"F401A",
                                b"Form 401 (Slate Mailer Organization Campaign Statement): Schedule A, Payments Received",
                            ),
                            (
                                b"F401B",
                                b"Form 401 (Slate Mailer Organization Campaign Statement): Schedule B, Payments Made",
                            ),
                            (
                                b"F401B-1",
                                b"Form 401 (Slate Mailer Organization Campaign Statement): Schedule B-1, Payments Made by Agent or Independent Contractor",
                            ),
                            (
                                b"F450",
                                b"Form 450: Recipient Committee Campaign Disclosure Statement - Short Form",
                            ),
                            (
                                b"F460",
                                b"Form 460: Recipient Committee Campaign Statement",
                            ),
                            (
                                b"A",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule A, Monetary Contributions Received",
                            ),
                            (
                                b"B1",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule B - Part 1, Loans Received",
                            ),
                            (
                                b"B2",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule B - Part 2, Loan Guarantors",
                            ),
                            (
                                b"B3",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule B - Part 3, Outstanding Bal",
                            ),
                            (
                                b"C",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule C, Non-Monetary Contributions Received",
                            ),
                            (
                                b"D",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule D, Summary of Expenditures Supporting / Opposing Other Candidates, Measures and Committees",
                            ),
                            (
                                b"E",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule E, Payments Made",
                            ),
                            (
                                b"F",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule F, Accrued Expenses (Unpaid Bills)",
                            ),
                            (
                                b"G",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule G, Payments Made by an Agent or Independent Contractor (on Behalf of This Committee)",
                            ),
                            (
                                b"H",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule H, Loans Made to Others",
                            ),
                            (
                                b"H1",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule H - Part 1, Loans Made",
                            ),
                            (
                                b"H2",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule H- Part 2, Repayments Rcvd",
                            ),
                            (
                                b"H3",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule H - Part 3, Outstanding Loans",
                            ),
                            (
                                b"I",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule I, miscellanous increases to cash",
                            ),
                            (
                                b"F461",
                                b"Form 461: Independent Expenditure Committee & Major Donor Committee Campaign Statement",
                            ),
                            (
                                b"F465",
                                b"Form 465: Supplemental Independent Expenditure Report",
                            ),
                            (b"F625", b"Form 625: Report of Lobbying Firm"),
                            (
                                b"F625P2",
                                b"Form 625 (Report of Lobbying Firm): Part 2, Payments Received in Connection with Lobbying Activity",
                            ),
                            (
                                b"F625P3A",
                                b"Form 625 (Report of Lobbying Firm): Part 3 (Payments Made In Connection With Lobbying Activities), Section A: Activity Expenses",
                            ),
                            (
                                b"F625P3B",
                                b"Form 625 (Report of Lobbying Firm): Part 3 (Payments Made In Connection With Lobbying Activities), Section B: Payments Made",
                            ),
                            (
                                b"F635",
                                b"Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                            ),
                            (
                                b"F635P3A",
                                b"Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3 (Payments Made in Connection with Lobbying Activities), Section A: Payments To In-house Employee Lobbyists",
                            ),
                            (
                                b"F635P3B",
                                b"Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3 (Payments Made in Connection with Lobbying Activities), Section B: Payments To Lobbying Firms",
                            ),
                            (
                                b"F635P3C",
                                b"Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3 (Payments Made in Connection with Lobbying Activities), Section C: Activity Expenses",
                            ),
                            (
                                b"F635P3D",
                                b"Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3 (Payments Made in Connection with Lobbying Activities), Section D: Other Payments to Influence Legislative or Administrative Action",
                            ),
                            (
                                b"F635P3E",
                                b"Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3 (Payments Made in Connection with Lobbying Activities), Section E: Payments in Connection with Administrative Testimony in Ratemaking Proceedings Before The California Public Utilities Commission",
                            ),
                            (
                                b"S640",
                                b"Schedule 640: Governmental Agencies Reporting (Attachment to Form 635 or Form 645)",
                            ),
                            (
                                b"F645",
                                b"Form 645: Report of Person Spending $5,000 or More",
                            ),
                            (
                                b"F645P2A",
                                b"Form 645 (Report of Person Spending $5,000 or More): Part 2 (Payments Made this Period), Section A: Activity Expenses",
                            ),
                            (
                                b"F645P2B",
                                b"Form 645 (Report of Person Spending $5,000 or More): Part 2 (Payments Made this Period), Section B: Other Payments to Influence Legislative or Administrative Action",
                            ),
                            (
                                b"F645P2C",
                                b"Form 645 (Report of Person Spending $5,000 or More): Part 2 (Payments Made this Period), Section C: Payments in Connection with Administrative Testimony in Ratemaking Proceedings Before the California Public Utilities Commission",
                            ),
                            (
                                b"F900",
                                b"Form 900: Public employee's retirement board, candidate campaign statement",
                            ),
                            (
                                "401A",
                                calaccess_raw.annotations.FilingFormSection(
                                    db_value=b"F401A",
                                    documentcloud_id=None,
                                    end_page=7,
                                    form=calaccess_raw.annotations.FilingForm(
                                        b"F401",
                                        b"Slate Mailer Organization Campaign Statement",
                                        description=b"Form 401 is filed by slate mailer organizations to disclose payments made and received in connection with producing slate mailers.",
                                        documentcloud_id=b"2781366-401-2005-01",
                                        group=b"CAMPAIGN",
                                    ),
                                    id=b"A",
                                    start_page=5,
                                    title=b"Schedule A, Payments Received",
                                ),
                            ),
                            (
                                "401B",
                                calaccess_raw.annotations.FilingFormSection(
                                    db_value=b"F401B",
                                    documentcloud_id=None,
                                    end_page=9,
                                    form=calaccess_raw.annotations.FilingForm(
                                        b"F401",
                                        b"Slate Mailer Organization Campaign Statement",
                                        description=b"Form 401 is filed by slate mailer organizations to disclose payments made and received in connection with producing slate mailers.",
                                        documentcloud_id=b"2781366-401-2005-01",
                                        group=b"CAMPAIGN",
                                    ),
                                    id=b"B",
                                    start_page=8,
                                    title=b"Schedule B, Payments Made",
                                ),
                            ),
                            (
                                "401B-1",
                                calaccess_raw.annotations.FilingFormSection(
                                    db_value=b"F401B-1",
                                    documentcloud_id=None,
                                    end_page=None,
                                    form=calaccess_raw.annotations.FilingForm(
                                        b"F401",
                                        b"Slate Mailer Organization Campaign Statement",
                                        description=b"Form 401 is filed by slate mailer organizations to disclose payments made and received in connection with producing slate mailers.",
                                        documentcloud_id=b"2781366-401-2005-01",
                                        group=b"CAMPAIGN",
                                    ),
                                    id=b"B-1",
                                    start_page=10,
                                    title=b"Schedule B-1, Payments Made by Agent or Independent Contractor",
                                ),
                            ),
                        ],
                        db_column="FORM_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=86
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=28,
                                id="2712033-Cal-Format-1-05-02",
                                start_page=27,
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=60,
                                id="2712033-Cal-Format-1-05-02",
                                start_page=59,
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=37, id="2712034-Cal-Format-201", start_page=36
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                end_page=74, id="2712034-Cal-Format-201", start_page=73
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=8,
                    ),
                ),
                (
                    "amount_a",
                    calaccess_raw.fields.DecimalField(
                        blank=True,
                        db_column="AMOUNT_A",
                        decimal_places=2,
                        help_text="Summary amount from column A",
                        max_digits=14,
                        null=True,
                        verbose_name="amount A",
                    ),
                ),
                (
                    "amount_b",
                    calaccess_raw.fields.DecimalField(
                        blank=True,
                        db_column="AMOUNT_B",
                        decimal_places=2,
                        help_text="Summary amount from column B",
                        max_digits=14,
                        null=True,
                        verbose_name="amount B",
                    ),
                ),
                (
                    "amount_c",
                    calaccess_raw.fields.DecimalField(
                        blank=True,
                        db_column="AMOUNT_C",
                        decimal_places=2,
                        help_text="Summary amount from column C",
                        max_digits=14,
                        null=True,
                        verbose_name="amount C",
                    ),
                ),
                (
                    "elec_dt",
                    calaccess_raw.fields.DateField(
                        blank=True,
                        db_column="ELEC_DT",
                        help_text="Election date",
                        null=True,
                        verbose_name="election date",
                    ),
                ),
            ],
            options={
                "ordering": ("filing_id", "-amend_id", "form_type", "line_item"),
                "db_table": "SMRY_CD",
                "verbose_name": "SMRY_CD",
                "verbose_name_plural": "SMRY_CD",
            },
        ),
        migrations.CreateModel(
            name="SpltCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "elec_amount",
                    calaccess_raw.fields.DecimalField(
                        db_column="ELEC_AMOUNT",
                        decimal_places=2,
                        help_text="Per Election to Date Amount",
                        max_digits=16,
                    ),
                ),
                (
                    "elec_code",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        choices=[
                            ("P", "Primary"),
                            ("G", "General"),
                            ("S", "Special"),
                            ("R", "Runoff"),
                            ("g", "General"),
                            ("p", "primary"),
                            ("C", "Unknown"),
                            ("D", "Unknown"),
                            ("F", "Unknown"),
                            ("M", "Unknown"),
                            ("N", "Unknown"),
                            ("X", "Unknown"),
                            ("O", "Unknown"),
                            ("0", "Unknown"),
                            ("1", "Unknown"),
                            ("2", "Unknown"),
                        ],
                        db_column="ELEC_CODE",
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=18
                            )
                        ],
                        help_text="Per Election to Date Code",
                        max_length=2,
                    ),
                ),
                (
                    "elec_date",
                    calaccess_raw.fields.DateField(
                        db_column="ELEC_DATE", help_text="Date of Election", null=True
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                    ),
                ),
                (
                    "pform_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"A",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule A, Monetary Contributions Received",
                            ),
                            (
                                b"B1",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule B - Part 1, Loans Received",
                            ),
                            (
                                b"B2",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule B - Part 2, Loan Guarantors",
                            ),
                            (
                                b"C",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule C, Non-Monetary Contributions Received",
                            ),
                            (
                                b"D",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule D, Summary of Expenditures Supporting / Opposing Other Candidates, Measures and Committees",
                            ),
                            (
                                b"F450P5",
                                b"Form 450 (Recipient Committee Campaign Disclosure Statement - Short Form): Part 5, Payments Made",
                            ),
                            (
                                b"H",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule H, Loans Made to Others",
                            ),
                        ],
                        db_column="PFORM_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=18
                            )
                        ],
                        help_text="Parent Schedule Type",
                        max_length=7,
                    ),
                ),
                (
                    "ptran_id",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="PTRAN_ID",
                        help_text="Parent transaction ID",
                        max_length=32,
                        verbose_name="parent transaction ID",
                    ),
                ),
            ],
            options={
                "db_table": "SPLT_CD",
                "verbose_name": "SPLT_CD",
                "verbose_name_plural": "SPLT_CD",
            },
        ),
        migrations.CreateModel(
            name="TextMemoCd",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "filing_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="FILING_ID",
                        db_index=True,
                        help_text="Unique filing identificiation number",
                        verbose_name="filing ID",
                    ),
                ),
                (
                    "amend_id",
                    calaccess_raw.fields.IntegerField(
                        db_column="AMEND_ID",
                        db_index=True,
                        help_text="Amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                        verbose_name="amendment ID",
                    ),
                ),
                (
                    "line_item",
                    calaccess_raw.fields.IntegerField(
                        db_column="LINE_ITEM",
                        db_index=True,
                        help_text="Line item number of this record",
                    ),
                ),
                (
                    "rec_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            ("TEXT", "TEXT"),
                            ("MEMO", "MEMO"),
                            ("trun", "Unknown"),
                            ("Unde", "Under"),
                            ("am", "Unknown"),
                            ("sele", "Unknown"),
                            ("Term", "Unknown"),
                            ("re", "Unknown"),
                            ("i", "Unknown"),
                        ],
                        db_column="REC_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=16
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=13
                            ),
                        ],
                        help_text="Record Type Value: TEXT",
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "form_type",
                    calaccess_raw.fields.CharField(
                        choices=[
                            (
                                b"F401",
                                b"Form 401: Slate Mailer Organization Campaign Statement",
                            ),
                            (
                                b"F405",
                                b"Form 405: Amendment to Campaign Disclosure Statement",
                            ),
                            (
                                b"F410",
                                b"Form 410: Statement of Organization Recipient Committee",
                            ),
                            (
                                b"F425",
                                b"Form 425: Semi-Annual Statement of no Activity",
                            ),
                            (
                                b"F450",
                                b"Form 450: Recipient Committee Campaign Disclosure Statement - Short Form",
                            ),
                            (
                                b"F460",
                                b"Form 460: Recipient Committee Campaign Statement",
                            ),
                            (
                                b"F461",
                                b"Form 461: Independent Expenditure Committee & Major Donor Committee Campaign Statement",
                            ),
                            (
                                b"F465",
                                b"Form 465: Supplemental Independent Expenditure Report",
                            ),
                            (b"F496", b"Form 496: Late Independent Expenditure Report"),
                            (b"F497", b"Form 497: Late Contribution Report"),
                            (b"F498", b"Form 498: Slate Mailer Late Payment Report"),
                            (
                                b"F601",
                                b"Form 601: Lobbying Firm Registration Statement",
                            ),
                            (
                                b"F602",
                                b"Form 602: Lobbying Firm Activity Authorization",
                            ),
                            (
                                b"F603",
                                b"Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                            ),
                            (b"F604", b"Form 604: Lobbyist Certification Statement"),
                            (
                                b"F605",
                                b"Form 605: Amendment to Registration, Lobbying Firm, Lobbyist Employer, Lobbying Coalition",
                            ),
                            (b"F606", b"Form 606: Notice of Termination"),
                            (b"F607", b"Form 607: Notice of Withdrawal"),
                            (b"F615", b"Form 615: Lobbyist Report"),
                            (b"F625", b"Form 625: Report of Lobbying Firm"),
                            (
                                b"F635",
                                b"Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                            ),
                            (
                                b"F645",
                                b"Form 645: Report of Person Spending $5,000 or More",
                            ),
                            (
                                b"S630",
                                b"Schedule 630: Payments Made to Lobbying Coalitions (Attachment to Form 625 or 635) ",
                            ),
                            (
                                b"S635-C",
                                b"Schedule 635C: Payments Received by Lobbying Coalitions",
                            ),
                            (
                                b"S640",
                                b"Schedule 640: Governmental Agencies Reporting (Attachment to Form 635 or Form 645)",
                            ),
                            (
                                "410",
                                b"Form 410: Statement of Organization Recipient Committee",
                            ),
                            (
                                "460",
                                b"Form 460: Recipient Committee Campaign Statement",
                            ),
                            (
                                "461",
                                b"Form 461: Independent Expenditure Committee & Major Donor Committee Campaign Statement",
                            ),
                            (
                                "465",
                                b"Form 465: Supplemental Independent Expenditure Report",
                            ),
                            ("496", b"Form 496: Late Independent Expenditure Report"),
                            ("497", b"Form 497: Late Contribution Report"),
                            (
                                "497P1",
                                b"Form 497 (Late Contribution Report): Part 1, Contribution(s) Received",
                            ),
                            (
                                "497P2",
                                b"Form 497 (Late Contribution Report): Part 2, Contribution(s) Made",
                            ),
                            (
                                "F401A",
                                b"Form 401 (Slate Mailer Organization Campaign Statement): Schedule A, Payments Received",
                            ),
                            (
                                "F401B",
                                b"Form 401 (Slate Mailer Organization Campaign Statement): Schedule B, Payments Made",
                            ),
                            (
                                "F401B-1",
                                b"Form 401 (Slate Mailer Organization Campaign Statement): Schedule B-1, Payments Made by Agent or Independent Contractor",
                            ),
                            (
                                "F450P5",
                                b"Form 450 (Recipient Committee Campaign Disclosure Statement - Short Form): Part 5, Payments Made",
                            ),
                            (
                                "F461P1",
                                b"Form 461 (Independent Expenditure Committee & Major Donor Committee Campaign Statement): Part 1, Name and Address of Filer",
                            ),
                            (
                                "F461P2",
                                b"Form 461 (Independent Expenditure Committee & Major Donor Committee Campaign Statement): Part 2, Nature and Interests of Filer",
                            ),
                            (
                                "F461P5",
                                b"Form 461 (Independent Expenditure Committee & Major Donor Committee Campaign Statement): Part 5, Contributions (Including Loans, Forgiveness of Loans, and LoanGuarantees) and Expenditures Made",
                            ),
                            (
                                "F465P3",
                                b"Form 465 (Supplemental Independent Expenditure Report): Part 3, Independent Expenditures Made",
                            ),
                            (
                                "F496P3",
                                b"Form 496 (Late Independent Expenditure Report): Part 3, Contributions > $100 Received",
                            ),
                            (
                                "F497P1",
                                b"Form 497 (Late Contribution Report): Part 1, Contribution(s) Received",
                            ),
                            (
                                "F497P2",
                                b"Form 497 (Late Contribution Report): Part 2, Contribution(s) Made",
                            ),
                            (
                                "F498-A",
                                b"Form 498 (Slate Mailer Late Payment Report): Part A, Late Payments Attributed To",
                            ),
                            (
                                "F498-R",
                                b"Form 498 (Slate Mailer Late Payment Report): Part R, Late Payments Received From",
                            ),
                            (
                                "F601P2A",
                                b"Form 601 (Lobbying Firm Registration Statement): Part 2: Section A, Lobbyist Employers",
                            ),
                            (
                                "F601P2B",
                                b"Form 601 (Lobbying Firm Registration Statement): Part 2: Section B: Subcontracted Clients",
                            ),
                            (
                                "F615P1",
                                b"Form 615 (Lobbyist Report): Part 1, Activity Expenses Paid, Incurred, Arranged or Provided by the Lobbyist",
                            ),
                            (
                                "F615P2",
                                b"Form 615 (Lobbyist Report): Part 2, Campaign Contributions Made or Delivered",
                            ),
                            (
                                "F625P2",
                                b"Form 625 (Report of Lobbying Firm): Part 2, Payments Received in Connection with Lobbying Activity",
                            ),
                            (
                                "F625P3A",
                                b"Form 625 (Report of Lobbying Firm): Part 3 (Payments Made In Connection With Lobbying Activities), Section A: Activity Expenses",
                            ),
                            (
                                "F625P3B",
                                b"Form 625 (Report of Lobbying Firm): Part 3 (Payments Made In Connection With Lobbying Activities), Section B: Payments Made",
                            ),
                            (
                                "F625P4B",
                                b"Form 625 (Report of Lobbying Firm): Part 4: Campaign Contributions Made",
                            ),
                            (
                                "S635",
                                b"Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                            ),
                            (
                                "F635P3B",
                                b"Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3 (Payments Made in Connection with Lobbying Activities), Section B: Payments To Lobbying Firms",
                            ),
                            (
                                "F635P3C",
                                b"Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3 (Payments Made in Connection with Lobbying Activities), Section C: Activity Expenses",
                            ),
                            (
                                "F635P4B",
                                b"Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 4: Campaign Contributions Made",
                            ),
                            (
                                "F645P2A",
                                b"Form 645 (Report of Person Spending $5,000 or More): Part 2 (Payments Made this Period), Section A: Activity Expenses",
                            ),
                            (
                                "F645P3B",
                                b"Form 645 (Report of Person Spending $5,000 or More): Part 3: Campaign Contributions Made",
                            ),
                            ("S497", b"Form 497: Late Contribution Report"),
                            (
                                "S635C",
                                b"Schedule 635C: Payments Received by Lobbying Coalitions",
                            ),
                            ("A", "Schedule A of any form (e.g., Forms 401 or 460)"),
                            ("A4", "Schedule A of any form (e.g., Forms 401 or 460)"),
                            ("A6", "Schedule A of any form (e.g., Forms 401 or 460)"),
                            ("B", "Schedule B of any form (e.g., Forms 401 or 460)"),
                            ("B1", "Schedule B, Part 1 of Forms 401 or 460"),
                            ("B2", "Schedule B, Part 2 of Forms 401 or 460"),
                            ("B3", "Schedule B, Part 3 of Forms 401 or 460"),
                            ("C", "Schedule C of any form (e.g., Forms 401 or F460)"),
                            ("COMMENTS", "Possibly comments by FPPC for any form?"),
                            (
                                "CVR",
                                "Cover page for any form (e.g., Forms 460, 461 or 497)",
                            ),
                            (
                                "D",
                                "Schedule D of any form (e.g., Forms 401, 460 or 461)",
                            ),
                            (
                                "DEBTF",
                                b"Form 460 (Recipient Committee Campaign Statement): Schedule F, Accrued Expenses (Unpaid Bills)",
                            ),
                            (
                                "E",
                                "Schedule E of any form (e.g., Forms 460, 461 or 465)",
                            ),
                            (
                                "EXPNT",
                                "Expenditures outlined on any form (e.g. Form 460)",
                            ),
                            ("F", "Schedule F of any form (e.g., Form 460)"),
                            ("G", "Schedule G of any form (e.g., Form 460)"),
                            ("H", "Schedule H of any form (e.g., Form 460)"),
                            ("H1", "Schedule H, Part 1 of any form (e.g., Form 460)"),
                            ("H2", "Schedule H2, Part 2 of any form (e.g., Form 460)"),
                            ("H3", "Schedule H3, Part 3 of any form (e.g., Form 460)"),
                            ("I", "Schedule I of any form (e.g., Form 460)"),
                            ("PT5", "Part 5 of any form (e.g., Form 461"),
                            (
                                "RCPTB1",
                                "Schedule B, Part 1 of any form (e.g., Form 460",
                            ),
                            ("RCPTC", "Schedule C of any form (e.g., Form 460)"),
                            ("RCPTI", "Schedule I of any form (e.g., Form 460)"),
                            ("SCH A", "Schedule A of any form (e.g., Form 460)"),
                            ("SF", "Schedule F of any form (e.g., Form 460)"),
                            ("SPLT", "A memo that applies to multiple items?"),
                            ("SMRY", "Summary section of any form (e.g., Form 460)"),
                            ("SUM", "Summary section of any form (e.g., Form 460)"),
                            ("SUMMARY", "Summary section of any form (e.g., Form 460)"),
                        ],
                        db_column="FORM_TYPE",
                        db_index=True,
                        documentcloud_pages=[
                            calaccess_raw.annotations.DocumentCloud(
                                id="2711616-MapCalFormat2Fields", start_page=90
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712034-Cal-Format-201", start_page=16
                            ),
                            calaccess_raw.annotations.DocumentCloud(
                                id="2712033-Cal-Format-1-05-02", start_page=13
                            ),
                        ],
                        help_text="Name of the source filing form or schedule",
                        max_length=8,
                        verbose_name="form type",
                    ),
                ),
                (
                    "ref_no",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="REF_NO",
                        help_text="Links text memo to a specific record",
                        max_length=20,
                        verbose_name="reference number",
                    ),
                ),
                (
                    "text4000",
                    calaccess_raw.fields.CharField(
                        blank=True,
                        db_column="TEXT4000",
                        help_text="Contents of the text memo",
                        max_length=4000,
                        verbose_name="text",
                    ),
                ),
            ],
            options={
                "db_table": "TEXT_MEMO_CD",
                "verbose_name": "TEXT_MEMO_CD",
                "verbose_name_plural": "TEXT_MEMO_CD",
            },
        ),
        migrations.AddField(
            model_name="rawdatafile",
            name="version",
            field=models.ForeignKey(
                help_text="Foreign key referencing the version of the raw source data in which the file was included",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="files",
                to="calaccess_raw.RawDataVersion",
                verbose_name="raw data version",
            ),
        ),
        migrations.AddField(
            model_name="filertypeperiodscd",
            name="filer_type",
            field=calaccess_raw.fields.ForeignKeyField(
                db_column="FILER_TYPE",
                db_constraint=False,
                help_text="Foreign key referencing FilerTypesCd.filer_type",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="filing_type_periods",
                to="calaccess_raw.FilerTypesCd",
            ),
        ),
        migrations.AddField(
            model_name="filertypeperiodscd",
            name="period_id",
            field=calaccess_raw.fields.ForeignKeyField(
                db_column="PERIOD_ID",
                db_constraint=False,
                help_text="Foreign key referencing FilingPeriodCd.period_id",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="filing_type_periods",
                to="calaccess_raw.FilingPeriodCd",
            ),
        ),
        migrations.AddField(
            model_name="filertofilertypecd",
            name="filer_type",
            field=calaccess_raw.fields.ForeignKeyField(
                db_column="FILER_TYPE",
                db_constraint=False,
                help_text="Foreign key referencing FilerTypesCd.filer_type",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="filers",
                to="calaccess_raw.FilerTypesCd",
            ),
        ),
        migrations.AddField(
            model_name="rawdatafile",
            name="clean_file_size",
            field=models.BigIntegerField(
                default=0,
                help_text="Size of the .CSV file",
                verbose_name="size of clean data file in bytes",
            ),
        ),
        migrations.AddField(
            model_name="rawdatafile",
            name="download_file_size",
            field=models.BigIntegerField(
                default=0,
                help_text="Size of the .TSV file",
                verbose_name="size of raw data file in bytes",
            ),
        ),
        migrations.AddField(
            model_name="rawdatafile",
            name="error_log_archive",
            field=models.FileField(
                blank=True,
                help_text="An archive of the error log containing lines from the original download file that could not be parsed and are excluded from the cleaned file.",
                max_length=255,
                upload_to=archive_directory_path,
                verbose_name="archive of error log",
            ),
        ),
        migrations.AddField(
            model_name="rawdatafile",
            name="error_count",
            field=models.IntegerField(
                default=0,
                help_text="Count of records in the original download that could not be parsed and are excluded from the cleaned file.",
                verbose_name="error count",
            ),
        ),
        migrations.AddField(
            model_name="rawdatafile",
            name="clean_finish_datetime",
            field=models.DateTimeField(
                help_text="Date and time when the cleaning of the file finished",
                null=True,
                verbose_name="date and time cleaning finished",
            ),
        ),
        migrations.AddField(
            model_name="rawdatafile",
            name="clean_start_datetime",
            field=models.DateTimeField(
                help_text="Date and time when the cleaning of the file started",
                null=True,
                verbose_name="date and time cleaning started",
            ),
        ),
        migrations.AddField(
            model_name="rawdatafile",
            name="load_finish_datetime",
            field=models.DateTimeField(
                help_text="Date and time when the loading of the file finished",
                null=True,
                verbose_name="date and time extraction finished",
            ),
        ),
        migrations.AddField(
            model_name="rawdatafile",
            name="load_start_datetime",
            field=models.DateTimeField(
                help_text="Date and time when the loading of the file started",
                null=True,
                verbose_name="date and time loading started",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="rawdatafile",
            unique_together=set([("version", "file_name")]),
        ),
        migrations.AlterModelOptions(
            name="acronymscd",
            options={"ordering": ("acronym",)},
        ),
        migrations.AlterModelOptions(
            name="addresscd",
            options={},
        ),
        migrations.AlterModelOptions(
            name="ballotmeasurescd",
            options={
                "ordering": (
                    "-election_date",
                    "measure_no",
                    "measure_short_name",
                    "measure_name",
                )
            },
        ),
        migrations.AlterModelOptions(
            name="cvr2campaigndisclosurecd",
            options={},
        ),
        migrations.AlterModelOptions(
            name="cvr2lobbydisclosurecd",
            options={},
        ),
        migrations.AlterModelOptions(
            name="cvr2registrationcd",
            options={},
        ),
        migrations.AlterModelOptions(
            name="cvr2socd",
            options={},
        ),
        migrations.AlterModelOptions(
            name="cvr3verificationinfocd",
            options={"ordering": ("-sig_date",)},
        ),
        migrations.AlterModelOptions(
            name="cvrcampaigndisclosurecd",
            options={"ordering": ("-rpt_date",)},
        ),
        migrations.AlterModelOptions(
            name="cvre530cd",
            options={"ordering": ("-pmnt_dt",)},
        ),
        migrations.AlterModelOptions(
            name="cvrf470cd",
            options={},
        ),
        migrations.AlterModelOptions(
            name="cvrlobbydisclosurecd",
            options={"ordering": ("-rpt_date",)},
        ),
        migrations.AlterModelOptions(
            name="cvrregistrationcd",
            options={"ordering": ("-rpt_date",)},
        ),
        migrations.AlterModelOptions(
            name="cvrsocd",
            options={"ordering": ("-rpt_date",)},
        ),
        migrations.AlterModelOptions(
            name="debtcd",
            options={},
        ),
        migrations.AlterModelOptions(
            name="efsfilinglogcd",
            options={"ordering": ("-filing_date",)},
        ),
        migrations.AlterModelOptions(
            name="expncd",
            options={"ordering": ("-expn_date",)},
        ),
        migrations.AlterModelOptions(
            name="f495p2cd",
            options={"ordering": ("-elect_date",)},
        ),
        migrations.AlterModelOptions(
            name="f501502cd",
            options={"ordering": ("-rpt_date",)},
        ),
        migrations.AlterModelOptions(
            name="f690p2cd",
            options={"ordering": ("-exec_date",)},
        ),
        migrations.AlterModelOptions(
            name="fileracronymscd",
            options={"ordering": ("acronym",)},
        ),
        migrations.AlterModelOptions(
            name="fileraddresscd",
            options={},
        ),
        migrations.AlterModelOptions(
            name="filerethicsclasscd",
            options={"ordering": ("-ethics_date",)},
        ),
        migrations.AlterModelOptions(
            name="filerfilingscd",
            options={},
        ),
        migrations.AlterModelOptions(
            name="filerinterestscd",
            options={"ordering": ("-effect_date",)},
        ),
        migrations.AlterModelOptions(
            name="filerlinkscd",
            options={},
        ),
        migrations.AlterModelOptions(
            name="filernamecd",
            options={"ordering": ("naml", "namf")},
        ),
        migrations.AlterModelOptions(
            name="filerscd",
            options={"ordering": ("-filer_id",)},
        ),
        migrations.AlterModelOptions(
            name="filerstatustypescd",
            options={"ordering": ("status_type",)},
        ),
        migrations.AlterModelOptions(
            name="filertofilertypecd",
            options={},
        ),
        migrations.AlterModelOptions(
            name="filertypeperiodscd",
            options={},
        ),
        migrations.AlterModelOptions(
            name="filertypescd",
            options={"ordering": ("filer_type",)},
        ),
        migrations.AlterModelOptions(
            name="filerxrefcd",
            options={},
        ),
        migrations.AlterModelOptions(
            name="filingperiodcd",
            options={"ordering": ("-end_date",)},
        ),
        migrations.AlterModelOptions(
            name="filingscd",
            options={"ordering": ("-filing_id",)},
        ),
        migrations.AlterModelOptions(
            name="grouptypescd",
            options={"ordering": ("grp_id",)},
        ),
        migrations.AlterModelOptions(
            name="hdrcd",
            options={"ordering": ("-filing_id", "-amend_id")},
        ),
        migrations.AlterModelOptions(
            name="headercd",
            options={"ordering": ("form_id", "line_number")},
        ),
        migrations.AlterModelOptions(
            name="imagelinkscd",
            options={"ordering": ("-img_dt",)},
        ),
        migrations.AlterModelOptions(
            name="lattcd",
            options={"ordering": ("-pmt_date",)},
        ),
        migrations.AlterModelOptions(
            name="lccmcd",
            options={"ordering": ("-ctrib_date",)},
        ),
        migrations.AlterModelOptions(
            name="legislativesessionscd",
            options={"ordering": ("-begin_date",)},
        ),
        migrations.AlterModelOptions(
            name="lempcd",
            options={"ordering": ("-eff_date",)},
        ),
        migrations.AlterModelOptions(
            name="lexpcd",
            options={"ordering": ("-expn_date",)},
        ),
        migrations.AlterModelOptions(
            name="loancd",
            options={"ordering": ("-loan_date1",)},
        ),
        migrations.AlterModelOptions(
            name="lobbyamendmentscd",
            options={"ordering": ("-exec_date",)},
        ),
        migrations.AlterModelOptions(
            name="lobbyingchglogcd",
            options={"ordering": ("-log_dt",)},
        ),
        migrations.AlterModelOptions(
            name="lobbyistcontributions1cd",
            options={"ordering": ("-filing_period_start_dt",)},
        ),
        migrations.AlterModelOptions(
            name="lobbyistcontributions2cd",
            options={"ordering": ("-filing_period_start_dt",)},
        ),
        migrations.AlterModelOptions(
            name="lobbyistcontributions3cd",
            options={"ordering": ("-filing_period_start_dt",)},
        ),
        migrations.AlterModelOptions(
            name="lobbyistemplobbyist1cd",
            options={"ordering": ("-session_id",)},
        ),
        migrations.AlterModelOptions(
            name="lobbyistemplobbyist2cd",
            options={"ordering": ("-session_id",)},
        ),
        migrations.AlterModelOptions(
            name="lobbyistemployer1cd",
            options={"ordering": ("-session_id",)},
        ),
        migrations.AlterModelOptions(
            name="lobbyistemployer2cd",
            options={"ordering": ("-session_id",)},
        ),
        migrations.AlterModelOptions(
            name="lobbyistemployer3cd",
            options={"ordering": ("-session_id",)},
        ),
        migrations.AlterModelOptions(
            name="lobbyistemployerfirms1cd",
            options={"ordering": ("-session_id",)},
        ),
        migrations.AlterModelOptions(
            name="lobbyistemployerfirms2cd",
            options={"ordering": ("-session_id",)},
        ),
        migrations.AlterModelOptions(
            name="lobbyistemployerhistorycd",
            options={},
        ),
        migrations.AlterModelOptions(
            name="lobbyistfirm1cd",
            options={},
        ),
        migrations.AlterModelOptions(
            name="lobbyistfirm2cd",
            options={},
        ),
        migrations.AlterModelOptions(
            name="lobbyistfirm3cd",
            options={},
        ),
        migrations.AlterModelOptions(
            name="lobbyistfirmemployer1cd",
            options={"ordering": ("-rpt_start",)},
        ),
        migrations.AlterModelOptions(
            name="lobbyistfirmemployer2cd",
            options={"ordering": ("-rpt_start",)},
        ),
        migrations.AlterModelOptions(
            name="lobbyistfirmhistorycd",
            options={},
        ),
        migrations.AlterModelOptions(
            name="lobbyistfirmlobbyist1cd",
            options={"ordering": ("-session_id",)},
        ),
        migrations.AlterModelOptions(
            name="lobbyistfirmlobbyist2cd",
            options={"ordering": ("-session_id",)},
        ),
        migrations.AlterModelOptions(
            name="lookupcodescd",
            options={},
        ),
        migrations.AlterModelOptions(
            name="lothcd",
            options={"ordering": ("-pmt_date",)},
        ),
        migrations.AlterModelOptions(
            name="lpaycd",
            options={},
        ),
        migrations.AlterModelOptions(
            name="namescd",
            options={"ordering": ("naml", "namf")},
        ),
        migrations.AlterModelOptions(
            name="rcptcd",
            options={"ordering": ("-rcpt_date",)},
        ),
        migrations.AlterModelOptions(
            name="receivedfilingscd",
            options={"ordering": ("-received_date",)},
        ),
        migrations.AlterModelOptions(
            name="reportscd",
            options={"ordering": ("rpt_name",)},
        ),
        migrations.AlterModelOptions(
            name="s401cd",
            options={},
        ),
        migrations.AlterModelOptions(
            name="s496cd",
            options={"ordering": ("-exp_date",)},
        ),
        migrations.AlterModelOptions(
            name="s497cd",
            options={"ordering": ("-ctrib_date",)},
        ),
        migrations.AlterModelOptions(
            name="s498cd",
            options={"ordering": ("-date_rcvd",)},
        ),
        migrations.AlterModelOptions(
            name="smrycd",
            options={"ordering": ("filing_id", "-amend_id", "form_type", "line_item")},
        ),
        migrations.AlterModelOptions(
            name="spltcd",
            options={},
        ),
        migrations.AlterModelOptions(
            name="textmemocd",
            options={},
        ),
        migrations.AlterField(
            model_name="cvre530cd",
            name="filing_id",
            field=calaccess_raw.fields.IntegerField(
                db_column="FILING_ID",
                db_index=True,
                help_text="Unique filing identification number",
                verbose_name="filing ID",
            ),
        ),
        migrations.AlterField(
            model_name="filerfilingscd",
            name="filing_id",
            field=calaccess_raw.fields.IntegerField(
                db_column="FILING_ID",
                db_index=True,
                help_text="Unique filing identification number",
                verbose_name="filing ID",
            ),
        ),
        migrations.AlterField(
            model_name="filernamecd",
            name="effect_dt",
            field=calaccess_raw.fields.DateField(
                db_column="EFFECT_DT", help_text="effective date for status", null=True
            ),
        ),
        migrations.AlterField(
            model_name="filernamecd",
            name="filer_id",
            field=calaccess_raw.fields.IntegerField(
                db_column="FILER_ID",
                db_index=True,
                help_text="filer's unique identification number",
                null=True,
                verbose_name="filer ID",
            ),
        ),
        migrations.AlterField(
            model_name="filernamecd",
            name="xref_filer_id",
            field=calaccess_raw.fields.CharField(
                db_column="XREF_FILER_ID",
                db_index=True,
                help_text="alternative filer ID found on many forms",
                max_length=15,
                verbose_name="crossreference filer ID",
            ),
        ),
        migrations.AlterField(
            model_name="filingscd",
            name="filing_id",
            field=calaccess_raw.fields.IntegerField(
                db_column="FILING_ID",
                db_index=True,
                help_text="Unique filing identification number",
                verbose_name="filing ID",
            ),
        ),
        migrations.AlterField(
            model_name="hdrcd",
            name="filing_id",
            field=calaccess_raw.fields.IntegerField(
                db_column="FILING_ID",
                db_index=True,
                help_text="Unique filing identification number",
                verbose_name="filing ID",
            ),
        ),
        migrations.AlterField(
            model_name="receivedfilingscd",
            name="filing_id",
            field=calaccess_raw.fields.IntegerField(
                blank=True,
                db_column="FILING_ID",
                db_index=True,
                help_text="Unique filing identification number",
                null=True,
                verbose_name="filing ID",
            ),
        ),
        migrations.AlterField(
            model_name="smrycd",
            name="filing_id",
            field=calaccess_raw.fields.IntegerField(
                db_column="FILING_ID",
                db_index=True,
                help_text="Unique filing identification number",
                verbose_name="filing ID",
            ),
        ),
        migrations.AlterField(
            model_name="spltcd",
            name="amend_id",
            field=calaccess_raw.fields.IntegerField(
                db_column="AMEND_ID",
                db_index=True,
                help_text="amendment identification number. A number of 0 is the original filing and 1 to 999 amendments.",
                verbose_name="amendment ID",
            ),
        ),
        migrations.AlterField(
            model_name="spltcd",
            name="elec_amount",
            field=calaccess_raw.fields.DecimalField(
                db_column="ELEC_AMOUNT",
                decimal_places=2,
                help_text="per election to date amount",
                max_digits=16,
                verbose_name="election amount",
            ),
        ),
        migrations.AlterField(
            model_name="spltcd",
            name="elec_code",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("P", "Primary"),
                    ("G", "General"),
                    ("S", "Special"),
                    ("R", "Runoff"),
                    ("g", "General"),
                    ("p", "primary"),
                    ("C", "Unknown"),
                    ("D", "Unknown"),
                    ("F", "Unknown"),
                    ("M", "Unknown"),
                    ("N", "Unknown"),
                    ("X", "Unknown"),
                    ("O", "Unknown"),
                    ("0", "Unknown"),
                    ("1", "Unknown"),
                    ("2", "Unknown"),
                ],
                db_column="ELEC_CODE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=18
                    )
                ],
                help_text="per election to date code",
                max_length=2,
                verbose_name="election code",
            ),
        ),
        migrations.AlterField(
            model_name="spltcd",
            name="elec_date",
            field=calaccess_raw.fields.DateField(
                db_column="ELEC_DATE", help_text="date of election", null=True
            ),
        ),
        migrations.AlterField(
            model_name="spltcd",
            name="filing_id",
            field=calaccess_raw.fields.IntegerField(
                db_column="FILING_ID",
                db_index=True,
                help_text="unique filing identification number",
                verbose_name="filing ID",
            ),
        ),
        migrations.AlterField(
            model_name="spltcd",
            name="line_item",
            field=calaccess_raw.fields.IntegerField(
                db_column="LINE_ITEM",
                db_index=True,
                help_text="line item number of this record",
            ),
        ),
        migrations.AlterField(
            model_name="spltcd",
            name="ptran_id",
            field=calaccess_raw.fields.CharField(
                blank=True,
                db_column="PTRAN_ID",
                help_text="parent transaction ID",
                max_length=32,
                verbose_name="parent transaction ID",
            ),
        ),
        migrations.AlterField(
            model_name="textmemocd",
            name="filing_id",
            field=calaccess_raw.fields.IntegerField(
                db_column="FILING_ID",
                db_index=True,
                help_text="Unique filing identification number",
                verbose_name="filing ID",
            ),
        ),
        migrations.AlterModelOptions(
            name="rawdataversion",
            options={
                "get_latest_by": "release_datetime",
                "ordering": ("-release_datetime",),
                "verbose_name": "CAL-ACCESS raw data version",
            },
        ),
        migrations.RemoveField(
            model_name="rawdataversion",
            name="zip_file_archive",
        ),
        migrations.AddField(
            model_name="rawdataversion",
            name="download_zip_archive",
            field=models.FileField(
                blank=True,
                help_text="An archive of the original zipped file downloaded from CAL-ACCESS.",
                max_length=255,
                upload_to=archive_directory_path,
                verbose_name="download files zip file",
            ),
        ),
        migrations.AddField(
            model_name="rawdataversion",
            name="download_finish_datetime",
            field=models.DateTimeField(
                help_text="Date and time when the download of the CAL-ACCESS database export finished",
                null=True,
                verbose_name="date and time download finished",
            ),
        ),
        migrations.AddField(
            model_name="rawdataversion",
            name="download_start_datetime",
            field=models.DateTimeField(
                help_text="Date and time when the download of the CAL-ACCESS database export started",
                null=True,
                verbose_name="date and time download started",
            ),
        ),
        migrations.AddField(
            model_name="rawdataversion",
            name="extract_finish_datetime",
            field=models.DateTimeField(
                help_text="Date and time when extraction of the CAL-ACCESS data files finished",
                null=True,
                verbose_name="date and time extraction finished",
            ),
        ),
        migrations.AddField(
            model_name="rawdataversion",
            name="extract_start_datetime",
            field=models.DateTimeField(
                help_text="Date and time when extraction of the CAL-ACCESS data files started",
                null=True,
                verbose_name="date and time extraction started",
            ),
        ),
        migrations.AddField(
            model_name="rawdataversion",
            name="update_finish_datetime",
            field=models.DateTimeField(
                help_text="Date and time when the update to the CAL-ACCESS version finished",
                null=True,
                verbose_name="date and time update finished",
            ),
        ),
        migrations.AddField(
            model_name="rawdataversion",
            name="update_start_datetime",
            field=models.DateTimeField(
                help_text="Date and time when the update to the CAL-ACCESS version started",
                null=True,
                verbose_name="date and time update started",
            ),
        ),
        migrations.AlterModelOptions(
            name="rawdataversion",
            options={
                "ordering": ("-release_datetime",),
                "verbose_name": "CAL-ACCESS raw data version",
            },
        ),
    ]
