# coding: utf-8

"""
    Blog Post endpoints

    \"Use these endpoints for interacting with Blog Posts, Blog Authors, and Blog Tags\"  # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from hubspot.cms.blogs.blog_posts.api_client import ApiClient
from hubspot.cms.blogs.blog_posts.exceptions import ApiTypeError, ApiValueError


class DefaultApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def archive(self, batch_input_string, **kwargs):  # noqa: E501
        """Archive a batch of Blog Posts  # noqa: E501

        Archive the Blog Post objects identified in the request body.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive(batch_input_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param BatchInputString batch_input_string: The JSON array of Blog Post ids. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.archive_with_http_info(batch_input_string, **kwargs)  # noqa: E501

    def archive_with_http_info(self, batch_input_string, **kwargs):  # noqa: E501
        """Archive a batch of Blog Posts  # noqa: E501

        Archive the Blog Post objects identified in the request body.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_with_http_info(batch_input_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param BatchInputString batch_input_string: The JSON array of Blog Post ids. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["batch_input_string"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method archive" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'batch_input_string' is set
        if self.api_client.client_side_validation and (
            "batch_input_string" not in local_var_params
            or local_var_params["batch_input_string"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `batch_input_string` when calling `archive`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_string" in local_var_params:
            body_params = local_var_params["batch_input_string"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/blogs/posts/batch/archive",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def archive_0(self, object_id, **kwargs):  # noqa: E501
        """Delete a Blog Post  # noqa: E501

        Delete the Blog Post object identified by the id in the path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_0(object_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: The Blog Post id. (required)
        :param bool archived: Whether to return only results that have been archived.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.archive_0_with_http_info(object_id, **kwargs)  # noqa: E501

    def archive_0_with_http_info(self, object_id, **kwargs):  # noqa: E501
        """Delete a Blog Post  # noqa: E501

        Delete the Blog Post object identified by the id in the path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_0_with_http_info(object_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: The Blog Post id. (required)
        :param bool archived: Whether to return only results that have been archived.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["object_id", "archived"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_0" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'object_id' is set
        if self.api_client.client_side_validation and (
            "object_id" not in local_var_params
            or local_var_params["object_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `object_id` when calling `archive_0`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "object_id" in local_var_params:
            path_params["objectId"] = local_var_params["object_id"]  # noqa: E501

        query_params = []
        if (
            "archived" in local_var_params and local_var_params["archived"] is not None
        ):  # noqa: E501
            query_params.append(
                ("archived", local_var_params["archived"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/blogs/posts/{objectId}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def clone(self, content_clone_request_v_next, **kwargs):  # noqa: E501
        """Clone a Blog Post  # noqa: E501

        Clone a Blog.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clone(content_clone_request_v_next, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ContentCloneRequestVNext content_clone_request_v_next: The JSON representation of the ContentCloneRequest object. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BlogPost
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.clone_with_http_info(
            content_clone_request_v_next, **kwargs
        )  # noqa: E501

    def clone_with_http_info(
        self, content_clone_request_v_next, **kwargs
    ):  # noqa: E501
        """Clone a Blog Post  # noqa: E501

        Clone a Blog.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clone_with_http_info(content_clone_request_v_next, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ContentCloneRequestVNext content_clone_request_v_next: The JSON representation of the ContentCloneRequest object. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BlogPost, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["content_clone_request_v_next"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method clone" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'content_clone_request_v_next' is set
        if self.api_client.client_side_validation and (
            "content_clone_request_v_next" not in local_var_params
            or local_var_params["content_clone_request_v_next"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `content_clone_request_v_next` when calling `clone`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "content_clone_request_v_next" in local_var_params:
            body_params = local_var_params["content_clone_request_v_next"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/blogs/posts/clone",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="BlogPost",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create(self, blog_post, **kwargs):  # noqa: E501
        """Create a new Blog Post  # noqa: E501

        Create a new Blog Post.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create(blog_post, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param BlogPost blog_post: The JSON representation of a new Blog Post. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BlogPost
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.create_with_http_info(blog_post, **kwargs)  # noqa: E501

    def create_with_http_info(self, blog_post, **kwargs):  # noqa: E501
        """Create a new Blog Post  # noqa: E501

        Create a new Blog Post.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_with_http_info(blog_post, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param BlogPost blog_post: The JSON representation of a new Blog Post. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BlogPost, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["blog_post"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method create" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'blog_post' is set
        if self.api_client.client_side_validation and (
            "blog_post" not in local_var_params
            or local_var_params["blog_post"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `blog_post` when calling `create`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "blog_post" in local_var_params:
            body_params = local_var_params["blog_post"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/blogs/posts",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="BlogPost",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_0(self, batch_input_blog_post, **kwargs):  # noqa: E501
        """Create a batch of Blog Posts  # noqa: E501

        Create the Blog Post objects detailed in the request body.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_0(batch_input_blog_post, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param BatchInputBlogPost batch_input_blog_post: The JSON array of new Blog Posts to create. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.create_0_with_http_info(
            batch_input_blog_post, **kwargs
        )  # noqa: E501

    def create_0_with_http_info(self, batch_input_blog_post, **kwargs):  # noqa: E501
        """Create a batch of Blog Posts  # noqa: E501

        Create the Blog Post objects detailed in the request body.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_0_with_http_info(batch_input_blog_post, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param BatchInputBlogPost batch_input_blog_post: The JSON array of new Blog Posts to create. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["batch_input_blog_post"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_0" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'batch_input_blog_post' is set
        if self.api_client.client_side_validation and (
            "batch_input_blog_post" not in local_var_params
            or local_var_params["batch_input_blog_post"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `batch_input_blog_post` when calling `create_0`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_blog_post" in local_var_params:
            body_params = local_var_params["batch_input_blog_post"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/blogs/posts/batch/create",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_by_id(self, object_id, **kwargs):  # noqa: E501
        """Retrieve a Blog Post  # noqa: E501

        Retrieve the Blog Post object identified by the id in the path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id(object_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: The Blog Post id. (required)
        :param bool archived: Specifies whether to return archived Blog Posts. Defaults to `false`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BlogPost
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_by_id_with_http_info(object_id, **kwargs)  # noqa: E501

    def get_by_id_with_http_info(self, object_id, **kwargs):  # noqa: E501
        """Retrieve a Blog Post  # noqa: E501

        Retrieve the Blog Post object identified by the id in the path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id_with_http_info(object_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: The Blog Post id. (required)
        :param bool archived: Specifies whether to return archived Blog Posts. Defaults to `false`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BlogPost, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["object_id", "archived"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'object_id' is set
        if self.api_client.client_side_validation and (
            "object_id" not in local_var_params
            or local_var_params["object_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `object_id` when calling `get_by_id`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "object_id" in local_var_params:
            path_params["objectId"] = local_var_params["object_id"]  # noqa: E501

        query_params = []
        if (
            "archived" in local_var_params and local_var_params["archived"] is not None
        ):  # noqa: E501
            query_params.append(
                ("archived", local_var_params["archived"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/blogs/posts/{objectId}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="BlogPost",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_draft_by_id(self, object_id, **kwargs):  # noqa: E501
        """Retrieve the full draft version of the Blog Post  # noqa: E501

        Retrieve the full draft version of the Blog Post.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_draft_by_id(object_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: The Blog Post id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BlogPost
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_draft_by_id_with_http_info(object_id, **kwargs)  # noqa: E501

    def get_draft_by_id_with_http_info(self, object_id, **kwargs):  # noqa: E501
        """Retrieve the full draft version of the Blog Post  # noqa: E501

        Retrieve the full draft version of the Blog Post.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_draft_by_id_with_http_info(object_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: The Blog Post id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BlogPost, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["object_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_draft_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'object_id' is set
        if self.api_client.client_side_validation and (
            "object_id" not in local_var_params
            or local_var_params["object_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `object_id` when calling `get_draft_by_id`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "object_id" in local_var_params:
            path_params["objectId"] = local_var_params["object_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/blogs/posts/{objectId}/draft",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="BlogPost",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_page(self, **kwargs):  # noqa: E501
        """Get all Blog Posts  # noqa: E501

        Get the list of blog posts. Supports paging and filtering. This method would be useful for an integration that examined these models and used an external service to suggest edits.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_page(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param datetime created_at: Only return Blog Posts created at exactly the specified time.
        :param datetime created_after: Only return Blog Posts created after the specified time.
        :param datetime created_before: Only return Blog Posts created before the specified time.
        :param datetime updated_at: Only return Blog Posts last updated at exactly the specified time.
        :param datetime updated_after: Only return Blog Posts last updated after the specified time.
        :param datetime updated_before: Only return Blog Posts last updated before the specified time.
        :param list[str] sort: Specifies which fields to use for sorting results. Valid fields are `name`, `createdAt`, `updatedAt`, `createdBy`, `updatedBy`. `createdAt` will be used by default.
        :param str after: The cursor token value to get the next set of results. You can get this from the `paging.next.after` JSON property of a paged response containing more results.
        :param int limit: The maximum number of results to return. Default is 100.
        :param bool archived: Specifies whether to return archived Blog Posts. Defaults to `false`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CollectionResponseWithTotalBlogPostForwardPaging
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_page_with_http_info(**kwargs)  # noqa: E501

    def get_page_with_http_info(self, **kwargs):  # noqa: E501
        """Get all Blog Posts  # noqa: E501

        Get the list of blog posts. Supports paging and filtering. This method would be useful for an integration that examined these models and used an external service to suggest edits.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_page_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param datetime created_at: Only return Blog Posts created at exactly the specified time.
        :param datetime created_after: Only return Blog Posts created after the specified time.
        :param datetime created_before: Only return Blog Posts created before the specified time.
        :param datetime updated_at: Only return Blog Posts last updated at exactly the specified time.
        :param datetime updated_after: Only return Blog Posts last updated after the specified time.
        :param datetime updated_before: Only return Blog Posts last updated before the specified time.
        :param list[str] sort: Specifies which fields to use for sorting results. Valid fields are `name`, `createdAt`, `updatedAt`, `createdBy`, `updatedBy`. `createdAt` will be used by default.
        :param str after: The cursor token value to get the next set of results. You can get this from the `paging.next.after` JSON property of a paged response containing more results.
        :param int limit: The maximum number of results to return. Default is 100.
        :param bool archived: Specifies whether to return archived Blog Posts. Defaults to `false`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CollectionResponseWithTotalBlogPostForwardPaging, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "created_at",
            "created_after",
            "created_before",
            "updated_at",
            "updated_after",
            "updated_before",
            "sort",
            "after",
            "limit",
            "archived",
        ]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if (
            "created_at" in local_var_params
            and local_var_params["created_at"] is not None
        ):  # noqa: E501
            query_params.append(
                ("createdAt", local_var_params["created_at"])
            )  # noqa: E501
        if (
            "created_after" in local_var_params
            and local_var_params["created_after"] is not None
        ):  # noqa: E501
            query_params.append(
                ("createdAfter", local_var_params["created_after"])
            )  # noqa: E501
        if (
            "created_before" in local_var_params
            and local_var_params["created_before"] is not None
        ):  # noqa: E501
            query_params.append(
                ("createdBefore", local_var_params["created_before"])
            )  # noqa: E501
        if (
            "updated_at" in local_var_params
            and local_var_params["updated_at"] is not None
        ):  # noqa: E501
            query_params.append(
                ("updatedAt", local_var_params["updated_at"])
            )  # noqa: E501
        if (
            "updated_after" in local_var_params
            and local_var_params["updated_after"] is not None
        ):  # noqa: E501
            query_params.append(
                ("updatedAfter", local_var_params["updated_after"])
            )  # noqa: E501
        if (
            "updated_before" in local_var_params
            and local_var_params["updated_before"] is not None
        ):  # noqa: E501
            query_params.append(
                ("updatedBefore", local_var_params["updated_before"])
            )  # noqa: E501
        if (
            "sort" in local_var_params and local_var_params["sort"] is not None
        ):  # noqa: E501
            query_params.append(("sort", local_var_params["sort"]))  # noqa: E501
            collection_formats["sort"] = "multi"  # noqa: E501
        if (
            "after" in local_var_params and local_var_params["after"] is not None
        ):  # noqa: E501
            query_params.append(("after", local_var_params["after"]))  # noqa: E501
        if (
            "limit" in local_var_params and local_var_params["limit"] is not None
        ):  # noqa: E501
            query_params.append(("limit", local_var_params["limit"]))  # noqa: E501
        if (
            "archived" in local_var_params and local_var_params["archived"] is not None
        ):  # noqa: E501
            query_params.append(
                ("archived", local_var_params["archived"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/blogs/posts",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="CollectionResponseWithTotalBlogPostForwardPaging",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_previous_version(self, object_id, revision_id, **kwargs):  # noqa: E501
        """Retrieves a previous version of a blog post  # noqa: E501

        Retrieves a previous version of a blog post.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_previous_version(object_id, revision_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: The Blog Post id. (required)
        :param str revision_id: The Blog Post version id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: VersionBlogPost
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_previous_version_with_http_info(
            object_id, revision_id, **kwargs
        )  # noqa: E501

    def get_previous_version_with_http_info(
        self, object_id, revision_id, **kwargs
    ):  # noqa: E501
        """Retrieves a previous version of a blog post  # noqa: E501

        Retrieves a previous version of a blog post.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_previous_version_with_http_info(object_id, revision_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: The Blog Post id. (required)
        :param str revision_id: The Blog Post version id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(VersionBlogPost, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["object_id", "revision_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_previous_version" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'object_id' is set
        if self.api_client.client_side_validation and (
            "object_id" not in local_var_params
            or local_var_params["object_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `object_id` when calling `get_previous_version`"
            )  # noqa: E501
        # verify the required parameter 'revision_id' is set
        if self.api_client.client_side_validation and (
            "revision_id" not in local_var_params
            or local_var_params["revision_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `revision_id` when calling `get_previous_version`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "object_id" in local_var_params:
            path_params["objectId"] = local_var_params["object_id"]  # noqa: E501
        if "revision_id" in local_var_params:
            path_params["revisionId"] = local_var_params["revision_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/blogs/posts/{objectId}/revisions/{revisionId}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="VersionBlogPost",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_previous_versions(self, object_id, **kwargs):  # noqa: E501
        """Retrieves all the previous versions of a blog post  # noqa: E501

        Retrieves all the previous versions of a blog post.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_previous_versions(object_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: The Blog Post id. (required)
        :param str after: The cursor token value to get the next set of results. You can get this from the `paging.next.after` JSON property of a paged response containing more results.
        :param str before:
        :param int limit: The maximum number of results to return. Default is 100.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CollectionResponseWithTotalVersionBlogPost
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_previous_versions_with_http_info(
            object_id, **kwargs
        )  # noqa: E501

    def get_previous_versions_with_http_info(self, object_id, **kwargs):  # noqa: E501
        """Retrieves all the previous versions of a blog post  # noqa: E501

        Retrieves all the previous versions of a blog post.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_previous_versions_with_http_info(object_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: The Blog Post id. (required)
        :param str after: The cursor token value to get the next set of results. You can get this from the `paging.next.after` JSON property of a paged response containing more results.
        :param str before:
        :param int limit: The maximum number of results to return. Default is 100.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CollectionResponseWithTotalVersionBlogPost, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["object_id", "after", "before", "limit"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_previous_versions" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'object_id' is set
        if self.api_client.client_side_validation and (
            "object_id" not in local_var_params
            or local_var_params["object_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `object_id` when calling `get_previous_versions`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "object_id" in local_var_params:
            path_params["objectId"] = local_var_params["object_id"]  # noqa: E501

        query_params = []
        if (
            "after" in local_var_params and local_var_params["after"] is not None
        ):  # noqa: E501
            query_params.append(("after", local_var_params["after"]))  # noqa: E501
        if (
            "before" in local_var_params and local_var_params["before"] is not None
        ):  # noqa: E501
            query_params.append(("before", local_var_params["before"]))  # noqa: E501
        if (
            "limit" in local_var_params and local_var_params["limit"] is not None
        ):  # noqa: E501
            query_params.append(("limit", local_var_params["limit"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/blogs/posts/{objectId}/revisions",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="CollectionResponseWithTotalVersionBlogPost",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def push_live(self, object_id, **kwargs):  # noqa: E501
        """Push Blog Post draft edits live  # noqa: E501

        Take any changes from the draft version of the Blog Post and apply them to the live version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.push_live(object_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: The id of the Blog Post for which it's draft will be pushed live. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.push_live_with_http_info(object_id, **kwargs)  # noqa: E501

    def push_live_with_http_info(self, object_id, **kwargs):  # noqa: E501
        """Push Blog Post draft edits live  # noqa: E501

        Take any changes from the draft version of the Blog Post and apply them to the live version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.push_live_with_http_info(object_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: The id of the Blog Post for which it's draft will be pushed live. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["object_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method push_live" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'object_id' is set
        if self.api_client.client_side_validation and (
            "object_id" not in local_var_params
            or local_var_params["object_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `object_id` when calling `push_live`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "object_id" in local_var_params:
            path_params["objectId"] = local_var_params["object_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/blogs/posts/{objectId}/draft/push-live",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def read(self, batch_input_string, **kwargs):  # noqa: E501
        """Retrieve a batch of Blog Posts  # noqa: E501

        Retrieve the Blog Post objects identified in the request body.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read(batch_input_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param BatchInputString batch_input_string: The JSON array of Blog Post ids. (required)
        :param bool archived: Specifies whether to return archived Blog Posts. Defaults to `false`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.read_with_http_info(batch_input_string, **kwargs)  # noqa: E501

    def read_with_http_info(self, batch_input_string, **kwargs):  # noqa: E501
        """Retrieve a batch of Blog Posts  # noqa: E501

        Retrieve the Blog Post objects identified in the request body.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_with_http_info(batch_input_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param BatchInputString batch_input_string: The JSON array of Blog Post ids. (required)
        :param bool archived: Specifies whether to return archived Blog Posts. Defaults to `false`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["batch_input_string", "archived"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method read" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'batch_input_string' is set
        if self.api_client.client_side_validation and (
            "batch_input_string" not in local_var_params
            or local_var_params["batch_input_string"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `batch_input_string` when calling `read`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if (
            "archived" in local_var_params and local_var_params["archived"] is not None
        ):  # noqa: E501
            query_params.append(
                ("archived", local_var_params["archived"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_string" in local_var_params:
            body_params = local_var_params["batch_input_string"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/blogs/posts/batch/read",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def reset_draft(self, object_id, **kwargs):  # noqa: E501
        """Reset the Blog Post draft to the live version  # noqa: E501

        Discards any edits and resets the draft to the live version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_draft(object_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: The id of the Blog Post for which it's draft will be reset. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.reset_draft_with_http_info(object_id, **kwargs)  # noqa: E501

    def reset_draft_with_http_info(self, object_id, **kwargs):  # noqa: E501
        """Reset the Blog Post draft to the live version  # noqa: E501

        Discards any edits and resets the draft to the live version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_draft_with_http_info(object_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: The id of the Blog Post for which it's draft will be reset. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["object_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_draft" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'object_id' is set
        if self.api_client.client_side_validation and (
            "object_id" not in local_var_params
            or local_var_params["object_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `object_id` when calling `reset_draft`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "object_id" in local_var_params:
            path_params["objectId"] = local_var_params["object_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/blogs/posts/{objectId}/draft/reset",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def restore_previous_version(self, object_id, revision_id, **kwargs):  # noqa: E501
        """Restore a previous version of a blog post  # noqa: E501

        Takes a specified version of a blog post and restores it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.restore_previous_version(object_id, revision_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: The Blog Post id. (required)
        :param str revision_id: The Blog Post version id to restore. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BlogPost
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.restore_previous_version_with_http_info(
            object_id, revision_id, **kwargs
        )  # noqa: E501

    def restore_previous_version_with_http_info(
        self, object_id, revision_id, **kwargs
    ):  # noqa: E501
        """Restore a previous version of a blog post  # noqa: E501

        Takes a specified version of a blog post and restores it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.restore_previous_version_with_http_info(object_id, revision_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: The Blog Post id. (required)
        :param str revision_id: The Blog Post version id to restore. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BlogPost, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["object_id", "revision_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method restore_previous_version" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'object_id' is set
        if self.api_client.client_side_validation and (
            "object_id" not in local_var_params
            or local_var_params["object_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `object_id` when calling `restore_previous_version`"
            )  # noqa: E501
        # verify the required parameter 'revision_id' is set
        if self.api_client.client_side_validation and (
            "revision_id" not in local_var_params
            or local_var_params["revision_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `revision_id` when calling `restore_previous_version`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "object_id" in local_var_params:
            path_params["objectId"] = local_var_params["object_id"]  # noqa: E501
        if "revision_id" in local_var_params:
            path_params["revisionId"] = local_var_params["revision_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/blogs/posts/{objectId}/revisions/{revisionId}/restore",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="BlogPost",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def restore_previous_version_to_draft(
        self, object_id, revision_id, **kwargs
    ):  # noqa: E501
        """Restore a previous version of a blog post, to the draft version of the blog post  # noqa: E501

        Takes a specified version of a blog post, sets it as the new draft version of the blog post.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.restore_previous_version_to_draft(object_id, revision_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: The Blog Post id. (required)
        :param int revision_id: The Blog Post version id to restore. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BlogPost
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.restore_previous_version_to_draft_with_http_info(
            object_id, revision_id, **kwargs
        )  # noqa: E501

    def restore_previous_version_to_draft_with_http_info(
        self, object_id, revision_id, **kwargs
    ):  # noqa: E501
        """Restore a previous version of a blog post, to the draft version of the blog post  # noqa: E501

        Takes a specified version of a blog post, sets it as the new draft version of the blog post.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.restore_previous_version_to_draft_with_http_info(object_id, revision_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: The Blog Post id. (required)
        :param int revision_id: The Blog Post version id to restore. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BlogPost, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["object_id", "revision_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method restore_previous_version_to_draft" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'object_id' is set
        if self.api_client.client_side_validation and (
            "object_id" not in local_var_params
            or local_var_params["object_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `object_id` when calling `restore_previous_version_to_draft`"
            )  # noqa: E501
        # verify the required parameter 'revision_id' is set
        if self.api_client.client_side_validation and (
            "revision_id" not in local_var_params
            or local_var_params["revision_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `revision_id` when calling `restore_previous_version_to_draft`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "object_id" in local_var_params:
            path_params["objectId"] = local_var_params["object_id"]  # noqa: E501
        if "revision_id" in local_var_params:
            path_params["revisionId"] = local_var_params["revision_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/blogs/posts/{objectId}/revisions/{revisionId}/restore-to-draft",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="BlogPost",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def schedule(self, content_schedule_request_v_next, **kwargs):  # noqa: E501
        """Schedule a Blog Post to be Published  # noqa: E501

        Schedule a Blog Post to be Published.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedule(content_schedule_request_v_next, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ContentScheduleRequestVNext content_schedule_request_v_next: The JSON representation of the ContentCloneRequestVNext object. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.schedule_with_http_info(
            content_schedule_request_v_next, **kwargs
        )  # noqa: E501

    def schedule_with_http_info(
        self, content_schedule_request_v_next, **kwargs
    ):  # noqa: E501
        """Schedule a Blog Post to be Published  # noqa: E501

        Schedule a Blog Post to be Published.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedule_with_http_info(content_schedule_request_v_next, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ContentScheduleRequestVNext content_schedule_request_v_next: The JSON representation of the ContentCloneRequestVNext object. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["content_schedule_request_v_next"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method schedule" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'content_schedule_request_v_next' is set
        if self.api_client.client_side_validation and (
            "content_schedule_request_v_next" not in local_var_params
            or local_var_params["content_schedule_request_v_next"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `content_schedule_request_v_next` when calling `schedule`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "content_schedule_request_v_next" in local_var_params:
            body_params = local_var_params["content_schedule_request_v_next"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/blogs/posts/schedule",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update(self, batch_input_json_node, **kwargs):  # noqa: E501
        """Update a batch of Blog Posts  # noqa: E501

        Update the Blog Post objects identified in the request body.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update(batch_input_json_node, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param BatchInputJsonNode batch_input_json_node: (required)
        :param bool archived: Whether to return only results that have been archived.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.update_with_http_info(batch_input_json_node, **kwargs)  # noqa: E501

    def update_with_http_info(self, batch_input_json_node, **kwargs):  # noqa: E501
        """Update a batch of Blog Posts  # noqa: E501

        Update the Blog Post objects identified in the request body.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_with_http_info(batch_input_json_node, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param BatchInputJsonNode batch_input_json_node: (required)
        :param bool archived: Whether to return only results that have been archived.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["batch_input_json_node", "archived"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method update" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'batch_input_json_node' is set
        if self.api_client.client_side_validation and (
            "batch_input_json_node" not in local_var_params
            or local_var_params["batch_input_json_node"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `batch_input_json_node` when calling `update`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if (
            "archived" in local_var_params and local_var_params["archived"] is not None
        ):  # noqa: E501
            query_params.append(
                ("archived", local_var_params["archived"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_json_node" in local_var_params:
            body_params = local_var_params["batch_input_json_node"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/blogs/posts/batch/update",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_0(self, object_id, blog_post, **kwargs):  # noqa: E501
        """Update a Blog Post  # noqa: E501

        Sparse updates a single Blog Post object identified by the id in the path. All the column values need not be specified. Only the that need to be modified can be specified.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_0(object_id, blog_post, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: The Blog Post id. (required)
        :param BlogPost blog_post: The JSON representation of the updated Blog Post. (required)
        :param bool archived: Specifies whether to update archived Blog Posts. Defaults to `false`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BlogPost
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.update_0_with_http_info(
            object_id, blog_post, **kwargs
        )  # noqa: E501

    def update_0_with_http_info(self, object_id, blog_post, **kwargs):  # noqa: E501
        """Update a Blog Post  # noqa: E501

        Sparse updates a single Blog Post object identified by the id in the path. All the column values need not be specified. Only the that need to be modified can be specified.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_0_with_http_info(object_id, blog_post, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: The Blog Post id. (required)
        :param BlogPost blog_post: The JSON representation of the updated Blog Post. (required)
        :param bool archived: Specifies whether to update archived Blog Posts. Defaults to `false`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BlogPost, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["object_id", "blog_post", "archived"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_0" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'object_id' is set
        if self.api_client.client_side_validation and (
            "object_id" not in local_var_params
            or local_var_params["object_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `object_id` when calling `update_0`"
            )  # noqa: E501
        # verify the required parameter 'blog_post' is set
        if self.api_client.client_side_validation and (
            "blog_post" not in local_var_params
            or local_var_params["blog_post"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `blog_post` when calling `update_0`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "object_id" in local_var_params:
            path_params["objectId"] = local_var_params["object_id"]  # noqa: E501

        query_params = []
        if (
            "archived" in local_var_params and local_var_params["archived"] is not None
        ):  # noqa: E501
            query_params.append(
                ("archived", local_var_params["archived"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "blog_post" in local_var_params:
            body_params = local_var_params["blog_post"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/blogs/posts/{objectId}",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="BlogPost",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_draft(self, object_id, blog_post, **kwargs):  # noqa: E501
        """Update a Blog Post draft  # noqa: E501

        Sparse updates the draft version of a single Blog Post object identified by the id in the path. All the column values need not be specified. Only the that need to be modified can be specified.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_draft(object_id, blog_post, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: The Blog Post id. (required)
        :param BlogPost blog_post: The JSON representation of the updated Blog Post to be applied to the draft. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BlogPost
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.update_draft_with_http_info(
            object_id, blog_post, **kwargs
        )  # noqa: E501

    def update_draft_with_http_info(self, object_id, blog_post, **kwargs):  # noqa: E501
        """Update a Blog Post draft  # noqa: E501

        Sparse updates the draft version of a single Blog Post object identified by the id in the path. All the column values need not be specified. Only the that need to be modified can be specified.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_draft_with_http_info(object_id, blog_post, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: The Blog Post id. (required)
        :param BlogPost blog_post: The JSON representation of the updated Blog Post to be applied to the draft. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BlogPost, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["object_id", "blog_post"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_draft" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'object_id' is set
        if self.api_client.client_side_validation and (
            "object_id" not in local_var_params
            or local_var_params["object_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `object_id` when calling `update_draft`"
            )  # noqa: E501
        # verify the required parameter 'blog_post' is set
        if self.api_client.client_side_validation and (
            "blog_post" not in local_var_params
            or local_var_params["blog_post"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `blog_post` when calling `update_draft`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "object_id" in local_var_params:
            path_params["objectId"] = local_var_params["object_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "blog_post" in local_var_params:
            body_params = local_var_params["blog_post"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/blogs/posts/{objectId}/draft",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="BlogPost",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
