# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cli2gui', 'cli2gui.application', 'cli2gui.tojson']

package_data = \
{'': ['*']}

install_requires = \
['Pillow>=9.1.0,<10',
 'PySimpleGUI>=4.59.0,<5',
 'PyYAML>=6.0,<7',
 'getostheme>=2021,<2023']

extras_require = \
{'pandoc': ['catpandoc>=2022.1,<2024'],
 'qt': ['PySimpleGUIQt>=0.35.0,<2'],
 'web': ['PySimpleGUIWeb>=0.39.0,<2']}

setup_kwargs = {
    'name': 'cli2gui',
    'version': '2022.1',
    'description': 'Use this module to convert a cli program to a gui',
    'long_description': '[![GitHub top language](https://img.shields.io/github/languages/top/FHPythonUtils/Cli2Gui.svg?style=for-the-badge)](../../)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/Cli2Gui.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/Cli2Gui.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/Cli2Gui.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/Cli2Gui.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/Cli2Gui.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/cli2gui.svg?style=for-the-badge)](https://pypistats.org/packages/cli2gui)\n[![PyPI Total Downloads](https://img.shields.io/badge/dynamic/json?style=for-the-badge&label=total%20downloads&query=%24.total_downloads&url=https%3A%2F%2Fapi.pepy.tech%2Fapi%2Fprojects%2Fcli2gui)](https://pepy.tech/project/cli2gui)\n[![PyPI Version](https://img.shields.io/pypi/v/cli2gui.svg?style=for-the-badge)](https://pypi.org/project/cli2gui)\n\n<!-- omit in toc -->\n# Cli2Gui\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\nUse this module to convert a CLI program to a GUI\n\n- [Comparison to similar projects](#comparison-to-similar-projects)\n\t- [Parser Support](#parser-support)\n\t- [GUI Toolkit Support](#gui-toolkit-support)\n\t- [GUI Feature Support](#gui-feature-support)\n- [Roadmap](#roadmap)\n- [Using Cli2Gui in your project](#using-cli2gui-in-your-project)\n\t- [Decorator](#decorator)\n\t- [Function](#function)\n\t- [run_function (optional)](#run_function-optional)\n\t- [auto_enable (optional)](#auto_enable-optional)\n\t- [parser (optional)](#parser-optional)\n\t- [gui (optional)](#gui-optional)\n\t- [theme (optional)](#theme-optional)\n\t- [darkTheme (optional)](#darktheme-optional)\n\t- [sizes (optional)](#sizes-optional)\n\t- [image (optional)](#image-optional)\n\t- [program_name (optional)](#program_name-optional)\n\t- [program_description (optional)](#program_description-optional)\n\t- [max_args_shown (optional)](#max_args_shown-optional)\n\t- [menu (optional)](#menu-optional)\n- [Click2Gui](#click2gui)\n\t- [run_function (required)](#run_function-required)\n\t- [parser (not applicable)](#parser-not-applicable)\n- [Data Structures](#data-structures)\n- [Documentation](#documentation)\n- [Install With PIP](#install-with-pip)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Windows - Python.org](#windows---pythonorg)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n\t- [Dnf](#dnf)\n- [Install Python on MacOS](#install-python-on-macos)\n\t- [Homebrew](#homebrew)\n\t- [MacOS - Python.org](#macos---pythonorg)\n- [How to run](#how-to-run)\n\t- [Windows](#windows)\n\t- [Linux/ MacOS](#linux-macos)\n- [Download Project](#download-project)\n\t- [Clone](#clone)\n\t\t- [Using The Command Line](#using-the-command-line)\n\t\t- [Using GitHub Desktop](#using-github-desktop)\n\t- [Download Zip File](#download-zip-file)\n- [Screenshots](#screenshots)\n\t- [Desktop](#desktop)\n\t- [Themes](#themes)\n- [Community Files](#community-files)\n\t- [Licence](#licence)\n\t- [Changelog](#changelog)\n\t- [Code of Conduct](#code-of-conduct)\n\t- [Contributing](#contributing)\n\t- [Security](#security)\n\t- [Support](#support)\n\t- [Rationale](#rationale)\n\n## Comparison to similar projects\n\nDo let me know if any of these are incorrect. Some of the comparisons are\nbased off documentation/ the readme\n\n### Parser Support\n\n<!--\nTODO add link to quick. (is this qt quick?)\n-->\n\n| Parser           | Cli2Gui              | [Gooey](https://github.com/chriskiehl/Gooey)              | Quick              |\n| ---------------- | -------------------- | ------------------ | ------------------ |\n| [Argparse](https://docs.python.org/3/library/argparse.html)         | ✔                   | ✔                 | ❌                |\n| [Optparse](https://docs.python.org/3/library/optparse.html)         | ✔                   | ❌                | ❌                |\n| [DocOpt](https://github.com/docopt/docopt)           | ✔                   | ❌                | ❌                |\n| [Click](https://github.com/pallets/click)            | ✔                 * | ❌                | ✔                 |\n| [GetOpt](https://docs.python.org/3/library/getopt.html)           | ✔                   | ❌                | ❌                |\n| [Dephell Argparse](https://github.com/dephell/dephell_argparse) | ✔                   | ❌                | ❌                |\n\n```none\n* Partial support (use [Click2Gui](#click2gui))\n\nThis works for simpler programs but sadly falls flat for more complex programs\n```\n\n### GUI Toolkit Support\n\n| GUI Toolkits | Cli2Gui            | Gooey              | Quick              |\n| ------------ | ------------------ | ------------------ | ------------------ |\n| Tkinter      | ✔                 | ❌                | ❌                |\n| WxWidgets    | ❌                | ✔                 | ❌                |\n| Qt           | ✔                 | ❌                | ✔                 |\n| Gtk          | ❌                | ❌                | ❌                |\n| Web          | ✔                 | ❌                | ❌                |\n\n### GUI Feature Support\n\n| Basic GUI                  | Cli2Gui            | Gooey              | Quick              |\n| -------------------------- | ------------------ | ------------------ | ------------------ |\n| Override name/ description | ✔                 | ✔                 | ❌                |\n| Theming                    | ✔                 | ⚠        Limited  | ⚠        Limited  |\n| DarkMode                   | ✔                 | ❌                | ✔                 |\n| Window Size                | ✔                 | ✔                 | ❌                |\n| Element Size               | ✔                 | ❌                | ❌                |\n| Custom Images              | ✔                 | ✔                 | ❌                |\n\nCli2Gui is pretty lacking in these features and will probably remain that way\nto ease maintainability - the primary aim is to support multiple argparse\nlibraries over fancy widgets\n\n| Advanced GUI           | Cli2Gui            | Gooey              | Quick              |\n| ---------------------- | ------------------ | ------------------ | ------------------ |\n| Dropdown               | ✔                 | ✔                 | ✔                 |\n| Slider                 | ❌                | ✔                 | ✔                 |\n| Tabs                   | ❌                | ✔                 | ✔                 |\n| Menus                  | ✔                 | ✔                 | ❌                |\n| Max Args before Scroll | ✔                 | ❌                | ❌                |\n\n## Roadmap\n\nFor completed components, see the changelog (link below)\n\n| Feature     | Description                           | Status              |\n| ----------- | ------------------------------------- | ------------------- |\n| Python Fire | https://github.com/google/python-fire | Under consideration |\n\n## Using Cli2Gui in your project\n\n```python\nfrom cli2gui import Cli2Gui\n```\n\n### Decorator\n\n```python\n@Cli2Gui(run_function, auto_enable=False, parser="argparse", gui="pysimplegui",\n\t\ttheme="", darkTheme="", sizes="", image="", program_name="",\n\t\tprogram_description="", max_args_shown=5, **kwargs)\n```\n\n### Function\n\n`Cli2Gui` is a function factory.\nIt takes keywords arguments like `run_function` and `auto_enable`,\nand returns a decorator function.\n\nThe decorator function takes a function like `main`\nand returns a new function:\n\n```python\n# main.py\n\ndef run(args):\n\tprint(args.arg)\n\n# The main function can be used as a CLI entrypoint\n# Example: python -m mymodule:main.main\ndef main():\n\tparser = argparse.ArgumentParser(description="this is an example parser")\n\tparser.add_argument("arg", type=str, help="positional arg")\n\targs = parser.parse_args()\n\trun(args)\n\ndecorator_function = Cli2Gui(\n\trun_function=run,\n\tauto_enable=True,\n)\n\n# The gui function can be used as a GUI entrypoint\n# Example: python -m mymodule:main.gui\ngui = decorator_function(main)\n\nif __name__ == "__main__":\n\t# When main.py is called as script, run the GUI version\n\t# Example: python main.py\n\t# Example: ./main.py\n\tgui()\n```\n\n### run_function (optional)\n\nThe function to call when the user clicks `Start`. Defaults to None. If not\nspecified, program continues as normal (can only run once)\n\n```python\ndef run(args):\n\tprint(args.arg)\n\n@Cli2Gui(run_function=run)\ndef main():\n\t# Typically, the main function has no arguments,\n\t# but parses arguments from sys.argv,\n\t# which happens in parser.parse_args()\n\tparser = argparse.ArgumentParser(description="this is an example parser")\n\tparser.add_argument("arg", type=str, help="positional arg")\n\targs = parser.parse_args()\n\trun(args)\n```\n\n### auto_enable (optional)\n\nEnable the GUI by default. Defailt is False.\n\nTo enable GUI, add `--cli2gui`.\nTo disable GUI, add `--disable-cli2gui`.\n\n```python\n@Cli2Gui(auto_enable=False)\n```\n\n### parser (optional)\n\nOverride the parser to use, defaults to argparse. Current options are:\n"argparse", "getopt", "optparse", "docopt", "dephell_argparse"\n\n```python\n@Cli2Gui(parser="argparse")\n```\n\n### gui (optional)\n\nOverride the gui to use. Current options are:\n"pysimplegui", "pysimpleguiqt","pysimpleguiweb". Defaults to "pysimplegui".\n\npysimplegui is the recommended option\n\n```python\n@Cli2Gui(gui="pysimplegui")\n```\n\n### theme (optional)\n\nSet a base24 theme. Can also pass a base24 scheme file. eg. `one-light.yaml`\n\n```python\n@Cli2Gui(theme=["#e7e7e9", "#dfdfe1", "#cacace", "#a0a1a7", "#696c77",\n\t\t"#383a42", "#202227", "#090a0b", "#ca1243", "#c18401", "#febb2a",\n\t\t"#50a14f", "#0184bc", "#4078f2", "#a626a4", "#986801", "#f0f0f1",\n\t\t"#fafafa", "#ec2258", "#f4a701", "#6db76c", "#01a7ef", "#709af5",\n\t\t"#d02fcd"])\n```\n\n### darkTheme (optional)\n\nSet a base24 dark theme variant. Can also pass a base24 scheme file. eg.\n`one-dark.yaml`\n\n```python\n@Cli2Gui(darkTheme=["#282c34", "#3f4451", "#4f5666", "#545862", "#9196a1",\n\t\t"#abb2bf", "#e6e6e6", "#ffffff", "#e06c75", "#d19a66", "#e5c07b",\n\t\t"#98c379", "#56b6c2", "#61afef", "#c678dd", "#be5046", "#21252b",\n\t\t"#181a1f", "#ff7b86", "#efb074", "#b1e18b", "#63d4e0", "#67cdff",\n\t\t"#e48bff"])\n```\n\n### sizes (optional)\n\nSet the UI sizes such as the button size\n\n```python\n@Cli2Gui(sizes={\n\t\t"title_size": 28,\n\t\t"label_size": (30, None),\n\t\t"input_size": (30, 1),\n\t\t"button":(10, 1),\n\t\t"padding":(5, 10),\n\t\t"helpText_size": 14,\n\t\t"text_size": 11})\n```\n\n### image (optional)\n\nSet the program icon. File extensions can be any that PIL supports\n\n```python\n@Cli2Gui(image="path/to/image.png")\n```\n\n### program_name (optional)\n\nOverride the program name\n\n```python\n@Cli2Gui(program_name="custom name")\n```\n\n### program_description (optional)\n\nOverride the program description\n\n```python\n@Cli2Gui(program_description="this is a custom description")\n```\n\n### max_args_shown (optional)\n\nMaximum number of args shown before using a scrollbar\n\n```python\n@Cli2Gui(max_args_shown=5)\n```\n\n### menu (optional)\n\nAdd a menu to the program. Defaults to None. eg.\n\n```python\nTHIS_DIR = str(Path(__file__).resolve().parent)\nmenu={"File": THIS_DIR + "/file.md"}\n```\n\nWorks significantly better with pysimplegui than pysimpleguiqt\n\n```python\n@Cli2Gui(menu={"File": THIS_DIR + "/file.md", "Another File": THIS_DIR + "/another_file.md", })\n```\n\n## Click2Gui\n\n```python\ndef Click2Gui(run_function, gui="pysimplegui", theme="", darkTheme="",\n\t\tsizes="", image="", program_name="", program_description="",\n\t\tmax_args_shown=5, menu="", **kwargs):\n```\n\nVery similar to the decorator but with the following differences...\n\n### run_function (required)\n\nSpecify the click function to use. (attempts were made to offer full program\nsupport however this behaved very poorly)\n\n### parser (not applicable)\n\nAs this is exclusively for click, this option is not present\n\n## Data Structures\n\nSee the [DATA_STRUCTURES](/DATA_STRUCTURES.md) for more information.\n\n## Documentation\n\nA high-level overview of how the documentation is organized organized will help you know\nwhere to look for certain things:\n\n<!--\n- [Tutorials](/documentation/tutorials) take you by the hand through a series of steps to get\n  started using the software. Start here if you’re new.\n-->\n- The [Technical Reference](/documentation/reference) documents APIs and other aspects of the\n  machinery. This documentation describes how to use the classes and functions at a lower level\n  and assume that you have a good high-level understanding of the software.\n<!--\n- The [Help](/documentation/help) guide provides a starting point and outlines common issues that you\n  may have.\n-->\n\n## Install With PIP\n\n```python\npip install cli2gui\n```\n\nHead to https://pypi.org/project/cli2gui/ for more info\n\n## Language information\n\n### Built for\n\nThis program has been written for Python versions 3.7 - 3.10 and has been tested with both 3.7 and\n3.10\n\n## Install Python on Windows\n\n### Chocolatey\n\n```powershell\nchoco install python\n```\n\n### Windows - Python.org\n\nTo install Python, go to https://www.python.org/downloads/windows/ and download the latest\nversion.\n\n## Install Python on Linux\n\n### Apt\n\n```bash\nsudo apt install python3.x\n```\n\n### Dnf\n\n```bash\nsudo dnf install python3.x\n```\n\n## Install Python on MacOS\n\n### Homebrew\n\n```bash\nbrew install python@3.x\n```\n\n### MacOS - Python.org\n\nTo install Python, go to https://www.python.org/downloads/macos/ and download the latest\nversion.\n\n## How to run\n\n### Windows\n\n- Module\n\t`py -3.x -m [module]` or `[module]` (if module installs a script)\n\n- File\n\t`py -3.x [file]` or `./[file]`\n\n### Linux/ MacOS\n\n- Module\n\t`python3.x -m [module]` or `[module]` (if module installs a script)\n\n- File\n\t`python3.x [file]` or `./[file]`\n\n## Download Project\n\n### Clone\n\n#### Using The Command Line\n\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to\nclone to\n4. Type \'git clone\' followed by URL in step 2\n\n\t```bash\n\tgit clone https://github.com/FHPythonUtils/Cli2Gui\n\t```\n\nMore information can be found at\nhttps://help.github.com/en/articles/cloning-a-repository\n\n#### Using GitHub Desktop\n\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\nhttps://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\n## Screenshots\n\n### Desktop\n\n<div>\n<img src="readme-assets/screenshots/desktop/screenshot-0.png" alt="Screenshot 1" width="600">\n<img src="readme-assets/screenshots/desktop/screenshot-1.png" alt="Screenshot 2" width="600">\n<img src="readme-assets/screenshots/desktop/screenshot-2.png" alt="Screenshot 3" width="600">\n</div>\n\n### Themes\n\n|                                       Light                                        |                                        Dark                                        |                                       Black                                        |\n| :--------------------------------------------------------------------------------: | :--------------------------------------------------------------------------------: | :--------------------------------------------------------------------------------: |\n| <img src="readme-assets/screenshots/themes/theme-1.png" alt="Theme 1" width="200"> | <img src="readme-assets/screenshots/themes/theme-2.png" alt="Theme 2" width="200"> | <img src="readme-assets/screenshots/themes/theme-3.png" alt="Theme 3" width="200"> |\n\n## Community Files\n\n### Licence\n\nMIT License\nCopyright (c) FredHappyface\n(See the [LICENSE](/LICENSE.md) for more information.)\n\n### Changelog\n\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\n\nOnline communities include people from many backgrounds. The *Project*\ncontributors are committed to providing a friendly, safe and welcoming\nenvironment for all. Please see the\n[Code of Conduct](https://github.com/FHPythonUtils/.github/blob/master/CODE_OF_CONDUCT.md)\n for more information.\n\n### Contributing\n\nContributions are welcome, please see the\n[Contributing Guidelines](https://github.com/FHPythonUtils/.github/blob/master/CONTRIBUTING.md)\nfor more information.\n\n### Security\n\nThank you for improving the security of the project, please see the\n[Security Policy](https://github.com/FHPythonUtils/.github/blob/master/SECURITY.md)\nfor more information.\n\n### Support\n\nThank you for using this project, I hope it is of use to you. Please be aware that\nthose involved with the project often do so for fun along with other commitments\n(such as work, family, etc). Please see the\n[Support Policy](https://github.com/FHPythonUtils/.github/blob/master/SUPPORT.md)\nfor more information.\n\n### Rationale\n\nThe rationale acts as a guide to various processes regarding projects such as\nthe versioning scheme and the programming styles used. Please see the\n[Rationale](https://github.com/FHPythonUtils/.github/blob/master/RATIONALE.md)\nfor more information.\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FHPythonUtils/Cli2Gui',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
