import BaseStyle from '@primevue/core/base/style';

var theme = function theme(_ref) {
  var dt = _ref.dt;
  return "\n.p-tabs {\n    display: flex;\n    flex-direction: column;\n}\n\n.p-tablist {\n    display: flex;\n    position: relative;\n}\n\n.p-tabs-scrollable > .p-tablist {\n    overflow: hidden;\n}\n\n.p-tablist-viewport {\n    overflow-x: auto;\n    overflow-y: hidden;\n    scroll-behavior: smooth;\n    scrollbar-width: none;\n    overscroll-behavior: contain auto;\n}\n\n.p-tablist-viewport::-webkit-scrollbar {\n    display: none;\n}\n\n.p-tablist-tab-list {\n    position: relative;\n    display: flex;\n    background: ".concat(dt('tabs.tablist.background'), ";\n    border-style: solid;\n    border-color: ").concat(dt('tabs.tablist.border.color'), ";\n    border-width: ").concat(dt('tabs.tablist.border.width'), ";\n}\n\n.p-tablist-content {\n    flex-grow: 1;\n}\n\n.p-tablist-nav-button {\n    all: unset;\n    position: absolute !important;\n    flex-shrink: 0;\n    inset-block-start: 0;\n    z-index: 2;\n    height: 100%;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    background: ").concat(dt('tabs.nav.button.background'), ";\n    color: ").concat(dt('tabs.nav.button.color'), ";\n    width: ").concat(dt('tabs.nav.button.width'), ";\n    transition: color ").concat(dt('tabs.transition.duration'), ", outline-color ").concat(dt('tabs.transition.duration'), ", box-shadow ").concat(dt('tabs.transition.duration'), ";\n    box-shadow: ").concat(dt('tabs.nav.button.shadow'), ";\n    outline-color: transparent;\n    cursor: pointer;\n}\n\n.p-tablist-nav-button:focus-visible {\n    z-index: 1;\n    box-shadow: ").concat(dt('tabs.nav.button.focus.ring.shadow'), ";\n    outline: ").concat(dt('tabs.nav.button.focus.ring.width'), " ").concat(dt('tabs.nav.button.focus.ring.style'), " ").concat(dt('tabs.nav.button.focus.ring.color'), ";\n    outline-offset: ").concat(dt('tabs.nav.button.focus.ring.offset'), ";\n}\n\n.p-tablist-nav-button:hover {\n    color: ").concat(dt('tabs.nav.button.hover.color'), ";\n}\n\n.p-tablist-prev-button {\n    inset-inline-start: 0;\n}\n\n.p-tablist-next-button {\n    inset-inline-end: 0;\n}\n\n.p-tablist-prev-button:dir(rtl),\n.p-tablist-next-button:dir(rtl) {\n    transform: rotate(180deg);\n}\n\n\n.p-tab {\n    flex-shrink: 0;\n    cursor: pointer;\n    user-select: none;\n    position: relative;\n    border-style: solid;\n    white-space: nowrap;\n    background: ").concat(dt('tabs.tab.background'), ";\n    border-width: ").concat(dt('tabs.tab.border.width'), ";\n    border-color: ").concat(dt('tabs.tab.border.color'), ";\n    color: ").concat(dt('tabs.tab.color'), ";\n    padding: ").concat(dt('tabs.tab.padding'), ";\n    font-weight: ").concat(dt('tabs.tab.font.weight'), ";\n    transition: background ").concat(dt('tabs.transition.duration'), ", border-color ").concat(dt('tabs.transition.duration'), ", color ").concat(dt('tabs.transition.duration'), ", outline-color ").concat(dt('tabs.transition.duration'), ", box-shadow ").concat(dt('tabs.transition.duration'), ";\n    margin: ").concat(dt('tabs.tab.margin'), ";\n    outline-color: transparent;\n}\n\n.p-tab:not(.p-disabled):focus-visible {\n    z-index: 1;\n    box-shadow: ").concat(dt('tabs.tab.focus.ring.shadow'), ";\n    outline: ").concat(dt('tabs.tab.focus.ring.width'), " ").concat(dt('tabs.tab.focus.ring.style'), " ").concat(dt('tabs.tab.focus.ring.color'), ";\n    outline-offset: ").concat(dt('tabs.tab.focus.ring.offset'), ";\n}\n\n.p-tab:not(.p-tab-active):not(.p-disabled):hover {\n    background: ").concat(dt('tabs.tab.hover.background'), ";\n    border-color: ").concat(dt('tabs.tab.hover.border.color'), ";\n    color: ").concat(dt('tabs.tab.hover.color'), ";\n}\n\n.p-tab-active {\n    background: ").concat(dt('tabs.tab.active.background'), ";\n    border-color: ").concat(dt('tabs.tab.active.border.color'), ";\n    color: ").concat(dt('tabs.tab.active.color'), ";\n}\n\n.p-tabpanels {\n    background: ").concat(dt('tabs.tabpanel.background'), ";\n    color: ").concat(dt('tabs.tabpanel.color'), ";\n    padding: ").concat(dt('tabs.tabpanel.padding'), ";\n    outline: 0 none;\n}\n\n.p-tabpanel:focus-visible {\n    box-shadow: ").concat(dt('tabs.tabpanel.focus.ring.shadow'), ";\n    outline: ").concat(dt('tabs.tabpanel.focus.ring.width'), " ").concat(dt('tabs.tabpanel.focus.ring.style'), " ").concat(dt('tabs.tabpanel.focus.ring.color'), ";\n    outline-offset: ").concat(dt('tabs.tabpanel.focus.ring.offset'), ";\n}\n\n.p-tablist-active-bar {\n    z-index: 1;\n    display: block;\n    position: absolute;\n    inset-block-end: ").concat(dt('tabs.active.bar.bottom'), ";\n    height: ").concat(dt('tabs.active.bar.height'), ";\n    background: ").concat(dt('tabs.active.bar.background'), ";\n    transition: 250ms cubic-bezier(0.35, 0, 0.25, 1);\n}\n");
};
var classes = {
  root: function root(_ref2) {
    var props = _ref2.props;
    return ['p-tabs p-component', {
      'p-tabs-scrollable': props.scrollable
    }];
  }
};
var TabsStyle = BaseStyle.extend({
  name: 'tabs',
  theme: theme,
  classes: classes
});

export { TabsStyle as default };
//# sourceMappingURL=index.mjs.map
