cjm-kaggle-utils
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

## Install

``` sh
pip install cjm_kaggle_utils
```

## How to use

### save_kaggle_creds

``` python
from cjm_kaggle_utils.core import save_kaggle_creds
```

``` python
username = "name"
key = "12345"
save_kaggle_creds(username, key, overwrite=False)
```

    Credentials already present. Set `overwrite=True` to replace them.

### dl_kaggle

``` python
from cjm_kaggle_utils.core import dl_kaggle
from pathlib import Path
```

``` python
# Get the path to the directory where datasets are stored
dataset_dir = Path("./Datasets/")
dataset_dir.mkdir(parents=True, exist_ok=True)
print(f"Dataset Directory: {dataset_dir}")

# Create the path to the data directory
archive_dir = dataset_dir/'../Archive'
archive_dir.mkdir(parents=True, exist_ok=True)
print(f"Archive Directory: {archive_dir}")
```

    Dataset Directory: Datasets
    Archive Directory: Datasets/../Archive

``` python
# Set the name of the dataset
dataset_name = 'yolox-openvino-inference-demo-files'

# Construct the Kaggle dataset name by combining the username and dataset name
kaggle_dataset = f'innominate817/{dataset_name}'
```

``` python
# Create the path to the zip file that contains the dataset
archive_path = Path(f'{archive_dir}/{dataset_name}.zip')
print(f"Archive Path: {archive_path}")

# Create the path to the directory where the dataset will be extracted
dataset_path = Path(f'{dataset_dir}/{dataset_name}')
print(f"Dataset Path: {dataset_path}")
```

    Archive Path: Datasets/../Archive/yolox-openvino-inference-demo-files.zip
    Dataset Path: Datasets/yolox-openvino-inference-demo-files

``` python
dl_kaggle(kaggle_dataset, archive_path, dataset_path)
```

    Dataset already downloaded
