# Interactive visualization

[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/Malkovsky/python-examples/master)

This repository contains a framework for iteractive visualization of algorithms based on widgets in jupyter notebook. Here are some examples of animations generated by the framework. The code is provided in [overview](https://github.com/Malkovsky/interactive-visualization/blob/master/examples/overview.ipynb) notebook

## Text animations

Here's an example of quicksort algorithm using text state representation

![Quicksort](https://raw.githubusercontent.com/Malkovsky/interactive-visualization/master/images/quicksort.gif)

## Matplotlib animations

Using `matplotlib` one can visualize some plane algorithm, for example [EM algorithm for Old Faithfull eruption data](https://en.wikipedia.org/wiki/Expectation%E2%80%93maximization_algorithm)

![em](https://raw.githubusercontent.com/Malkovsky/interactive-visualization/master/images/em_gmm.gif)

or domino coloring based on 5-coloring algorithm for planar graphs

![coloring](https://raw.githubusercontent.com/Malkovsky/interactive-visualization/master/images/planar_coloring.gif)

or convex hull construction

![convex_hull](https://raw.githubusercontent.com/Malkovsky/interactive-visualization/master/images/convex_hull.gif)

## Graphviz

Using `graphviz` one can visualize basic graph algorithms, here's an example of Dijkstra algorithm

![dijkstra](https://raw.githubusercontent.com/Malkovsky/interactive-visualization/master/images/dijkstra_slow.gif)

# Requirements and installation

A proper installation on debian-based systems is
```
cat apt.txt | xargs sudo apt-get install
pip install interactive-visualization
```
For other linux-based OS use the appropriate package manager to install packages listed in `apt.txt` which currently contains `graphviz` and `latex` needed for proper visualization in notebooks. Note that there also might be problems with [ipywidgets](https://ipywidgets.readthedocs.io/en/stable/user_install.html) in jupyter lab, check the docs for installation instructions.

# Creating an interactive animation using the framework
See [manual](https://github.com/Malkovsky/interactive-visualization/blob/master/manuals/manual.ipynb) for more reference.

# Examples
## Eng
### [Covid-19](https://github.com/Malkovsky/interactive-visualization/blob/master/examples/covid19.ipynb)
Some basic parse and analysis of global Covid-19 data from Johns Hopkins University.
## Rus
### [Замощене доминошками](https://github.com/Malkovsky/interactive-visualization/blob/master/examples/domino_tiling.ipynb)
Рассматривается задача покрытия фигур на плоскости, состоящиех из квадратных клеток одинакового размера и два её программных решения: с помощью динамического программирования по профилю и с помощью нахождения максимального паросочетания. Бонусом идет раскраска планарного графа в 5 цветов (не протестировано).
### [Обходы на графах](https://github.com/Malkovsky/interactive-visualization/blob/master/examples/basic_searches.ipynb)
Разобраны обходы в глубину и ширину, а так же их базовые применения.
### [Кратчайшие пути на графах](https://github.com/Malkovsky/interactive-visualization/blob/master/examples/shortest_paths.ipynb)
Основные алгоритмы для задачи о крайших путях от одной вершины до всех остальных. Все алгоритмы представлены как модификации "сканирующего метода".
### [Префиксное дерево](https://github.com/Malkovsky/interactive-visualization/blob/master/examples/preffix_tree.ipynb)
Префиксное дерево, префикс-функцию, алгоритм Ахо-Корасик и их применения в марковских моделях для обработки текста.
