# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 access_mode: pulumi.Input[str],
                 network_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 vpc_id: pulumi.Input[str],
                 ad_domain: Optional[pulumi.Input['ServiceAdDomainArgs']] = None,
                 auth_type: Optional[pulumi.Input[str]] = None,
                 dedicated_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enterprise_id: Optional[pulumi.Input[str]] = None,
                 internet_access_port: Optional[pulumi.Input[int]] = None,
                 management_subnet_cidr: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[str] access_mode: Specifies the access mode of Workspace service.
               The valid values are as follows:
               + **INTERNET**: internet access.
               + **DEDICATED**: dedicated line access.
               + **BOTH**: both internet access and dedicated access are supported.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_ids: The network ID list of subnets that the service have.
               The subnets corresponding to this parameter must be included in the VPC resource corresponding to `vpc_id`.
               These subnet segments cannot conflict with `172.16.0.0/12`.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID to which the service belongs.
               Changing this will create a new resource.
        :param pulumi.Input['ServiceAdDomainArgs'] ad_domain: Specifies the configuration of AD domain.
               Required if `auth_type` is **LOCAL_AD**. Make sure that the selected VPC network and the network to which AD
               belongs can be connected. The object structure is documented below.
        :param pulumi.Input[str] auth_type: Specifies the authentication type of Workspace service.
               The valid values are as follows:
               + **LITE_AS**: Local authentication.
               + **LOCAL_AD**: Connect to AD domain.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dedicated_subnets: The subnet segments of the dedicated access.
        :param pulumi.Input[str] enterprise_id: Specifies the enterprise ID.
               The enterprise ID is the unique identification in the Workspace service.
               If omitted, the system will automatically generate an enterprise ID.
               The ID can contain `1` to `32` characters, only letters, digits, hyphens (-) and underscores (_) are allowed.
        :param pulumi.Input[int] internet_access_port: Specifies the internet access port.
               The valid value is range from `1,025` to `65,535`.
        :param pulumi.Input[str] management_subnet_cidr: The subnet segment of the management component.
        :param pulumi.Input[str] region: The region in which to register the Workspace service.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        pulumi.set(__self__, "access_mode", access_mode)
        pulumi.set(__self__, "network_ids", network_ids)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if ad_domain is not None:
            pulumi.set(__self__, "ad_domain", ad_domain)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if dedicated_subnets is not None:
            pulumi.set(__self__, "dedicated_subnets", dedicated_subnets)
        if enterprise_id is not None:
            pulumi.set(__self__, "enterprise_id", enterprise_id)
        if internet_access_port is not None:
            pulumi.set(__self__, "internet_access_port", internet_access_port)
        if management_subnet_cidr is not None:
            pulumi.set(__self__, "management_subnet_cidr", management_subnet_cidr)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> pulumi.Input[str]:
        """
        Specifies the access mode of Workspace service.
        The valid values are as follows:
        + **INTERNET**: internet access.
        + **DEDICATED**: dedicated line access.
        + **BOTH**: both internet access and dedicated access are supported.
        """
        return pulumi.get(self, "access_mode")

    @access_mode.setter
    def access_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_mode", value)

    @property
    @pulumi.getter(name="networkIds")
    def network_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The network ID list of subnets that the service have.
        The subnets corresponding to this parameter must be included in the VPC resource corresponding to `vpc_id`.
        These subnet segments cannot conflict with `172.16.0.0/12`.
        """
        return pulumi.get(self, "network_ids")

    @network_ids.setter
    def network_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "network_ids", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Specifies the VPC ID to which the service belongs.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="adDomain")
    def ad_domain(self) -> Optional[pulumi.Input['ServiceAdDomainArgs']]:
        """
        Specifies the configuration of AD domain.
        Required if `auth_type` is **LOCAL_AD**. Make sure that the selected VPC network and the network to which AD
        belongs can be connected. The object structure is documented below.
        """
        return pulumi.get(self, "ad_domain")

    @ad_domain.setter
    def ad_domain(self, value: Optional[pulumi.Input['ServiceAdDomainArgs']]):
        pulumi.set(self, "ad_domain", value)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the authentication type of Workspace service.
        The valid values are as follows:
        + **LITE_AS**: Local authentication.
        + **LOCAL_AD**: Connect to AD domain.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter(name="dedicatedSubnets")
    def dedicated_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The subnet segments of the dedicated access.
        """
        return pulumi.get(self, "dedicated_subnets")

    @dedicated_subnets.setter
    def dedicated_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dedicated_subnets", value)

    @property
    @pulumi.getter(name="enterpriseId")
    def enterprise_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise ID.
        The enterprise ID is the unique identification in the Workspace service.
        If omitted, the system will automatically generate an enterprise ID.
        The ID can contain `1` to `32` characters, only letters, digits, hyphens (-) and underscores (_) are allowed.
        """
        return pulumi.get(self, "enterprise_id")

    @enterprise_id.setter
    def enterprise_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_id", value)

    @property
    @pulumi.getter(name="internetAccessPort")
    def internet_access_port(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the internet access port.
        The valid value is range from `1,025` to `65,535`.
        """
        return pulumi.get(self, "internet_access_port")

    @internet_access_port.setter
    def internet_access_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internet_access_port", value)

    @property
    @pulumi.getter(name="managementSubnetCidr")
    def management_subnet_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet segment of the management component.
        """
        return pulumi.get(self, "management_subnet_cidr")

    @management_subnet_cidr.setter
    def management_subnet_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_subnet_cidr", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to register the Workspace service.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 access_mode: Optional[pulumi.Input[str]] = None,
                 ad_domain: Optional[pulumi.Input['ServiceAdDomainArgs']] = None,
                 auth_type: Optional[pulumi.Input[str]] = None,
                 dedicated_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 desktop_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDesktopSecurityGroupArgs']]]] = None,
                 enterprise_id: Optional[pulumi.Input[str]] = None,
                 infrastructure_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceInfrastructureSecurityGroupArgs']]]] = None,
                 internet_access_address: Optional[pulumi.Input[str]] = None,
                 internet_access_port: Optional[pulumi.Input[int]] = None,
                 management_subnet_cidr: Optional[pulumi.Input[str]] = None,
                 network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input[str] access_mode: Specifies the access mode of Workspace service.
               The valid values are as follows:
               + **INTERNET**: internet access.
               + **DEDICATED**: dedicated line access.
               + **BOTH**: both internet access and dedicated access are supported.
        :param pulumi.Input['ServiceAdDomainArgs'] ad_domain: Specifies the configuration of AD domain.
               Required if `auth_type` is **LOCAL_AD**. Make sure that the selected VPC network and the network to which AD
               belongs can be connected. The object structure is documented below.
        :param pulumi.Input[str] auth_type: Specifies the authentication type of Workspace service.
               The valid values are as follows:
               + **LITE_AS**: Local authentication.
               + **LOCAL_AD**: Connect to AD domain.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dedicated_subnets: The subnet segments of the dedicated access.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceDesktopSecurityGroupArgs']]] desktop_security_groups: The desktop security group automatically created under the specified VPC after the service
               is registered. The object structure is documented below.
        :param pulumi.Input[str] enterprise_id: Specifies the enterprise ID.
               The enterprise ID is the unique identification in the Workspace service.
               If omitted, the system will automatically generate an enterprise ID.
               The ID can contain `1` to `32` characters, only letters, digits, hyphens (-) and underscores (_) are allowed.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceInfrastructureSecurityGroupArgs']]] infrastructure_security_groups: The management component security group automatically created under the specified
               VPC after the service is registered. The object structure is documented below.
        :param pulumi.Input[str] internet_access_address: The internet access address.
               This attribute is returned only when the access_mode is **INTERNET** or **BOTH**.
        :param pulumi.Input[int] internet_access_port: Specifies the internet access port.
               The valid value is range from `1,025` to `65,535`.
        :param pulumi.Input[str] management_subnet_cidr: The subnet segment of the management component.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_ids: The network ID list of subnets that the service have.
               The subnets corresponding to this parameter must be included in the VPC resource corresponding to `vpc_id`.
               These subnet segments cannot conflict with `172.16.0.0/12`.
        :param pulumi.Input[str] region: The region in which to register the Workspace service.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[str] status: The current status of the Workspace service.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID to which the service belongs.
               Changing this will create a new resource.
        """
        if access_mode is not None:
            pulumi.set(__self__, "access_mode", access_mode)
        if ad_domain is not None:
            pulumi.set(__self__, "ad_domain", ad_domain)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if dedicated_subnets is not None:
            pulumi.set(__self__, "dedicated_subnets", dedicated_subnets)
        if desktop_security_groups is not None:
            pulumi.set(__self__, "desktop_security_groups", desktop_security_groups)
        if enterprise_id is not None:
            pulumi.set(__self__, "enterprise_id", enterprise_id)
        if infrastructure_security_groups is not None:
            pulumi.set(__self__, "infrastructure_security_groups", infrastructure_security_groups)
        if internet_access_address is not None:
            pulumi.set(__self__, "internet_access_address", internet_access_address)
        if internet_access_port is not None:
            pulumi.set(__self__, "internet_access_port", internet_access_port)
        if management_subnet_cidr is not None:
            pulumi.set(__self__, "management_subnet_cidr", management_subnet_cidr)
        if network_ids is not None:
            pulumi.set(__self__, "network_ids", network_ids)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the access mode of Workspace service.
        The valid values are as follows:
        + **INTERNET**: internet access.
        + **DEDICATED**: dedicated line access.
        + **BOTH**: both internet access and dedicated access are supported.
        """
        return pulumi.get(self, "access_mode")

    @access_mode.setter
    def access_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_mode", value)

    @property
    @pulumi.getter(name="adDomain")
    def ad_domain(self) -> Optional[pulumi.Input['ServiceAdDomainArgs']]:
        """
        Specifies the configuration of AD domain.
        Required if `auth_type` is **LOCAL_AD**. Make sure that the selected VPC network and the network to which AD
        belongs can be connected. The object structure is documented below.
        """
        return pulumi.get(self, "ad_domain")

    @ad_domain.setter
    def ad_domain(self, value: Optional[pulumi.Input['ServiceAdDomainArgs']]):
        pulumi.set(self, "ad_domain", value)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the authentication type of Workspace service.
        The valid values are as follows:
        + **LITE_AS**: Local authentication.
        + **LOCAL_AD**: Connect to AD domain.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter(name="dedicatedSubnets")
    def dedicated_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The subnet segments of the dedicated access.
        """
        return pulumi.get(self, "dedicated_subnets")

    @dedicated_subnets.setter
    def dedicated_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dedicated_subnets", value)

    @property
    @pulumi.getter(name="desktopSecurityGroups")
    def desktop_security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDesktopSecurityGroupArgs']]]]:
        """
        The desktop security group automatically created under the specified VPC after the service
        is registered. The object structure is documented below.
        """
        return pulumi.get(self, "desktop_security_groups")

    @desktop_security_groups.setter
    def desktop_security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDesktopSecurityGroupArgs']]]]):
        pulumi.set(self, "desktop_security_groups", value)

    @property
    @pulumi.getter(name="enterpriseId")
    def enterprise_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise ID.
        The enterprise ID is the unique identification in the Workspace service.
        If omitted, the system will automatically generate an enterprise ID.
        The ID can contain `1` to `32` characters, only letters, digits, hyphens (-) and underscores (_) are allowed.
        """
        return pulumi.get(self, "enterprise_id")

    @enterprise_id.setter
    def enterprise_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_id", value)

    @property
    @pulumi.getter(name="infrastructureSecurityGroups")
    def infrastructure_security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceInfrastructureSecurityGroupArgs']]]]:
        """
        The management component security group automatically created under the specified
        VPC after the service is registered. The object structure is documented below.
        """
        return pulumi.get(self, "infrastructure_security_groups")

    @infrastructure_security_groups.setter
    def infrastructure_security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceInfrastructureSecurityGroupArgs']]]]):
        pulumi.set(self, "infrastructure_security_groups", value)

    @property
    @pulumi.getter(name="internetAccessAddress")
    def internet_access_address(self) -> Optional[pulumi.Input[str]]:
        """
        The internet access address.
        This attribute is returned only when the access_mode is **INTERNET** or **BOTH**.
        """
        return pulumi.get(self, "internet_access_address")

    @internet_access_address.setter
    def internet_access_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internet_access_address", value)

    @property
    @pulumi.getter(name="internetAccessPort")
    def internet_access_port(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the internet access port.
        The valid value is range from `1,025` to `65,535`.
        """
        return pulumi.get(self, "internet_access_port")

    @internet_access_port.setter
    def internet_access_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internet_access_port", value)

    @property
    @pulumi.getter(name="managementSubnetCidr")
    def management_subnet_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet segment of the management component.
        """
        return pulumi.get(self, "management_subnet_cidr")

    @management_subnet_cidr.setter
    def management_subnet_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_subnet_cidr", value)

    @property
    @pulumi.getter(name="networkIds")
    def network_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The network ID list of subnets that the service have.
        The subnets corresponding to this parameter must be included in the VPC resource corresponding to `vpc_id`.
        These subnet segments cannot conflict with `172.16.0.0/12`.
        """
        return pulumi.get(self, "network_ids")

    @network_ids.setter
    def network_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_ids", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to register the Workspace service.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The current status of the Workspace service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the VPC ID to which the service belongs.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_mode: Optional[pulumi.Input[str]] = None,
                 ad_domain: Optional[pulumi.Input[pulumi.InputType['ServiceAdDomainArgs']]] = None,
                 auth_type: Optional[pulumi.Input[str]] = None,
                 dedicated_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enterprise_id: Optional[pulumi.Input[str]] = None,
                 internet_access_port: Optional[pulumi.Input[int]] = None,
                 management_subnet_cidr: Optional[pulumi.Input[str]] = None,
                 network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Use this resource to register or unregister the Workspace service in HuaweiCloud.

        ## Example Usage
        ### Register the Workspace service and use local authentication

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        network_ids = config.require_object("networkIds")
        test = huaweicloud.workspace.Service("test",
            access_mode="INTERNET",
            vpc_id=vpc_id,
            network_ids=network_ids)
        ```
        ## Appendix

        <a name="secgroup_rules_for_ad_domain_connection"></a>
        If a firewall is deployed between Windows AD and the Workspace service, you need to open the following ports on the
        firewall for the desktops of Workspace service to connect to Windows AD or DNS:

        | Protocol | Ports | Usage |
        | ---- | ---- | ---- |
        | TCP | 135 | RPC protocol (required for LDAP, Distributed File System, and Distributed File Replication) |
        | UDP | 137 | NetBIOS name resolution (required by the network login service) |
        | UDP | 138 | NetBIOS datagram service (distributed file system, network login and other services need to use this port) |
        | TCP | 139 | NetBIOS-SSN Service (Network Basic I/O Interface) |
        | TCP | 445 | NetBIOS-SSN Service (Network Basic I/O Interface) |
        | UDP | 445 | NetBIOS-SSN Service (Network Basic I/O Interface) |
        | TCP | 49152-65535 | RPC dynamic ports (ports that are not hardened and open by AD. If AD is hardened, ports 50152-51151 need to be opened) |
        | UDP | 49152-65535 | RPC dynamic ports (ports that are not hardened and open by AD. If AD is hardened, ports 50152-51151 need to be opened) |
        | TCP | 88 | Kerberos Key Distribution Center Service |
        | UDP | 88 | Kerberos Key Distribution Center Service |
        | UDP | 123 | Port used by NTP service |
        | TCP | 389 | LDAP server |
        | UDP | 389 | LDAP server |
        | TCP | 464 | Kerberos authentication protocol |
        | UDP | 464 | Kerberos Authentication Protocol |
        | UDP | 500 | isakmp |
        | TCP | 593 | RPC over HTTP |
        | TCP | 636 | LDAP SSL |
        | TCP | 53 | DNS server |
        | UDP | 53 | DNS server |

        ## Import

        Service can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Workspace/service:Service test fd3f81cb-d95f-43ce-b342-81b6b5dcadda
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_mode: Specifies the access mode of Workspace service.
               The valid values are as follows:
               + **INTERNET**: internet access.
               + **DEDICATED**: dedicated line access.
               + **BOTH**: both internet access and dedicated access are supported.
        :param pulumi.Input[pulumi.InputType['ServiceAdDomainArgs']] ad_domain: Specifies the configuration of AD domain.
               Required if `auth_type` is **LOCAL_AD**. Make sure that the selected VPC network and the network to which AD
               belongs can be connected. The object structure is documented below.
        :param pulumi.Input[str] auth_type: Specifies the authentication type of Workspace service.
               The valid values are as follows:
               + **LITE_AS**: Local authentication.
               + **LOCAL_AD**: Connect to AD domain.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dedicated_subnets: The subnet segments of the dedicated access.
        :param pulumi.Input[str] enterprise_id: Specifies the enterprise ID.
               The enterprise ID is the unique identification in the Workspace service.
               If omitted, the system will automatically generate an enterprise ID.
               The ID can contain `1` to `32` characters, only letters, digits, hyphens (-) and underscores (_) are allowed.
        :param pulumi.Input[int] internet_access_port: Specifies the internet access port.
               The valid value is range from `1,025` to `65,535`.
        :param pulumi.Input[str] management_subnet_cidr: The subnet segment of the management component.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_ids: The network ID list of subnets that the service have.
               The subnets corresponding to this parameter must be included in the VPC resource corresponding to `vpc_id`.
               These subnet segments cannot conflict with `172.16.0.0/12`.
        :param pulumi.Input[str] region: The region in which to register the Workspace service.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID to which the service belongs.
               Changing this will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to register or unregister the Workspace service in HuaweiCloud.

        ## Example Usage
        ### Register the Workspace service and use local authentication

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        network_ids = config.require_object("networkIds")
        test = huaweicloud.workspace.Service("test",
            access_mode="INTERNET",
            vpc_id=vpc_id,
            network_ids=network_ids)
        ```
        ## Appendix

        <a name="secgroup_rules_for_ad_domain_connection"></a>
        If a firewall is deployed between Windows AD and the Workspace service, you need to open the following ports on the
        firewall for the desktops of Workspace service to connect to Windows AD or DNS:

        | Protocol | Ports | Usage |
        | ---- | ---- | ---- |
        | TCP | 135 | RPC protocol (required for LDAP, Distributed File System, and Distributed File Replication) |
        | UDP | 137 | NetBIOS name resolution (required by the network login service) |
        | UDP | 138 | NetBIOS datagram service (distributed file system, network login and other services need to use this port) |
        | TCP | 139 | NetBIOS-SSN Service (Network Basic I/O Interface) |
        | TCP | 445 | NetBIOS-SSN Service (Network Basic I/O Interface) |
        | UDP | 445 | NetBIOS-SSN Service (Network Basic I/O Interface) |
        | TCP | 49152-65535 | RPC dynamic ports (ports that are not hardened and open by AD. If AD is hardened, ports 50152-51151 need to be opened) |
        | UDP | 49152-65535 | RPC dynamic ports (ports that are not hardened and open by AD. If AD is hardened, ports 50152-51151 need to be opened) |
        | TCP | 88 | Kerberos Key Distribution Center Service |
        | UDP | 88 | Kerberos Key Distribution Center Service |
        | UDP | 123 | Port used by NTP service |
        | TCP | 389 | LDAP server |
        | UDP | 389 | LDAP server |
        | TCP | 464 | Kerberos authentication protocol |
        | UDP | 464 | Kerberos Authentication Protocol |
        | UDP | 500 | isakmp |
        | TCP | 593 | RPC over HTTP |
        | TCP | 636 | LDAP SSL |
        | TCP | 53 | DNS server |
        | UDP | 53 | DNS server |

        ## Import

        Service can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Workspace/service:Service test fd3f81cb-d95f-43ce-b342-81b6b5dcadda
        ```

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_mode: Optional[pulumi.Input[str]] = None,
                 ad_domain: Optional[pulumi.Input[pulumi.InputType['ServiceAdDomainArgs']]] = None,
                 auth_type: Optional[pulumi.Input[str]] = None,
                 dedicated_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enterprise_id: Optional[pulumi.Input[str]] = None,
                 internet_access_port: Optional[pulumi.Input[int]] = None,
                 management_subnet_cidr: Optional[pulumi.Input[str]] = None,
                 network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            if access_mode is None and not opts.urn:
                raise TypeError("Missing required property 'access_mode'")
            __props__.__dict__["access_mode"] = access_mode
            __props__.__dict__["ad_domain"] = ad_domain
            __props__.__dict__["auth_type"] = auth_type
            __props__.__dict__["dedicated_subnets"] = dedicated_subnets
            __props__.__dict__["enterprise_id"] = enterprise_id
            __props__.__dict__["internet_access_port"] = internet_access_port
            __props__.__dict__["management_subnet_cidr"] = management_subnet_cidr
            if network_ids is None and not opts.urn:
                raise TypeError("Missing required property 'network_ids'")
            __props__.__dict__["network_ids"] = network_ids
            __props__.__dict__["region"] = region
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["desktop_security_groups"] = None
            __props__.__dict__["infrastructure_security_groups"] = None
            __props__.__dict__["internet_access_address"] = None
            __props__.__dict__["status"] = None
        super(Service, __self__).__init__(
            'huaweicloud:Workspace/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_mode: Optional[pulumi.Input[str]] = None,
            ad_domain: Optional[pulumi.Input[pulumi.InputType['ServiceAdDomainArgs']]] = None,
            auth_type: Optional[pulumi.Input[str]] = None,
            dedicated_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            desktop_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceDesktopSecurityGroupArgs']]]]] = None,
            enterprise_id: Optional[pulumi.Input[str]] = None,
            infrastructure_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceInfrastructureSecurityGroupArgs']]]]] = None,
            internet_access_address: Optional[pulumi.Input[str]] = None,
            internet_access_port: Optional[pulumi.Input[int]] = None,
            management_subnet_cidr: Optional[pulumi.Input[str]] = None,
            network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_mode: Specifies the access mode of Workspace service.
               The valid values are as follows:
               + **INTERNET**: internet access.
               + **DEDICATED**: dedicated line access.
               + **BOTH**: both internet access and dedicated access are supported.
        :param pulumi.Input[pulumi.InputType['ServiceAdDomainArgs']] ad_domain: Specifies the configuration of AD domain.
               Required if `auth_type` is **LOCAL_AD**. Make sure that the selected VPC network and the network to which AD
               belongs can be connected. The object structure is documented below.
        :param pulumi.Input[str] auth_type: Specifies the authentication type of Workspace service.
               The valid values are as follows:
               + **LITE_AS**: Local authentication.
               + **LOCAL_AD**: Connect to AD domain.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dedicated_subnets: The subnet segments of the dedicated access.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceDesktopSecurityGroupArgs']]]] desktop_security_groups: The desktop security group automatically created under the specified VPC after the service
               is registered. The object structure is documented below.
        :param pulumi.Input[str] enterprise_id: Specifies the enterprise ID.
               The enterprise ID is the unique identification in the Workspace service.
               If omitted, the system will automatically generate an enterprise ID.
               The ID can contain `1` to `32` characters, only letters, digits, hyphens (-) and underscores (_) are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceInfrastructureSecurityGroupArgs']]]] infrastructure_security_groups: The management component security group automatically created under the specified
               VPC after the service is registered. The object structure is documented below.
        :param pulumi.Input[str] internet_access_address: The internet access address.
               This attribute is returned only when the access_mode is **INTERNET** or **BOTH**.
        :param pulumi.Input[int] internet_access_port: Specifies the internet access port.
               The valid value is range from `1,025` to `65,535`.
        :param pulumi.Input[str] management_subnet_cidr: The subnet segment of the management component.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_ids: The network ID list of subnets that the service have.
               The subnets corresponding to this parameter must be included in the VPC resource corresponding to `vpc_id`.
               These subnet segments cannot conflict with `172.16.0.0/12`.
        :param pulumi.Input[str] region: The region in which to register the Workspace service.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[str] status: The current status of the Workspace service.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID to which the service belongs.
               Changing this will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["access_mode"] = access_mode
        __props__.__dict__["ad_domain"] = ad_domain
        __props__.__dict__["auth_type"] = auth_type
        __props__.__dict__["dedicated_subnets"] = dedicated_subnets
        __props__.__dict__["desktop_security_groups"] = desktop_security_groups
        __props__.__dict__["enterprise_id"] = enterprise_id
        __props__.__dict__["infrastructure_security_groups"] = infrastructure_security_groups
        __props__.__dict__["internet_access_address"] = internet_access_address
        __props__.__dict__["internet_access_port"] = internet_access_port
        __props__.__dict__["management_subnet_cidr"] = management_subnet_cidr
        __props__.__dict__["network_ids"] = network_ids
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["vpc_id"] = vpc_id
        return Service(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> pulumi.Output[str]:
        """
        Specifies the access mode of Workspace service.
        The valid values are as follows:
        + **INTERNET**: internet access.
        + **DEDICATED**: dedicated line access.
        + **BOTH**: both internet access and dedicated access are supported.
        """
        return pulumi.get(self, "access_mode")

    @property
    @pulumi.getter(name="adDomain")
    def ad_domain(self) -> pulumi.Output['outputs.ServiceAdDomain']:
        """
        Specifies the configuration of AD domain.
        Required if `auth_type` is **LOCAL_AD**. Make sure that the selected VPC network and the network to which AD
        belongs can be connected. The object structure is documented below.
        """
        return pulumi.get(self, "ad_domain")

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the authentication type of Workspace service.
        The valid values are as follows:
        + **LITE_AS**: Local authentication.
        + **LOCAL_AD**: Connect to AD domain.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="dedicatedSubnets")
    def dedicated_subnets(self) -> pulumi.Output[Sequence[str]]:
        """
        The subnet segments of the dedicated access.
        """
        return pulumi.get(self, "dedicated_subnets")

    @property
    @pulumi.getter(name="desktopSecurityGroups")
    def desktop_security_groups(self) -> pulumi.Output[Sequence['outputs.ServiceDesktopSecurityGroup']]:
        """
        The desktop security group automatically created under the specified VPC after the service
        is registered. The object structure is documented below.
        """
        return pulumi.get(self, "desktop_security_groups")

    @property
    @pulumi.getter(name="enterpriseId")
    def enterprise_id(self) -> pulumi.Output[str]:
        """
        Specifies the enterprise ID.
        The enterprise ID is the unique identification in the Workspace service.
        If omitted, the system will automatically generate an enterprise ID.
        The ID can contain `1` to `32` characters, only letters, digits, hyphens (-) and underscores (_) are allowed.
        """
        return pulumi.get(self, "enterprise_id")

    @property
    @pulumi.getter(name="infrastructureSecurityGroups")
    def infrastructure_security_groups(self) -> pulumi.Output[Sequence['outputs.ServiceInfrastructureSecurityGroup']]:
        """
        The management component security group automatically created under the specified
        VPC after the service is registered. The object structure is documented below.
        """
        return pulumi.get(self, "infrastructure_security_groups")

    @property
    @pulumi.getter(name="internetAccessAddress")
    def internet_access_address(self) -> pulumi.Output[str]:
        """
        The internet access address.
        This attribute is returned only when the access_mode is **INTERNET** or **BOTH**.
        """
        return pulumi.get(self, "internet_access_address")

    @property
    @pulumi.getter(name="internetAccessPort")
    def internet_access_port(self) -> pulumi.Output[int]:
        """
        Specifies the internet access port.
        The valid value is range from `1,025` to `65,535`.
        """
        return pulumi.get(self, "internet_access_port")

    @property
    @pulumi.getter(name="managementSubnetCidr")
    def management_subnet_cidr(self) -> pulumi.Output[str]:
        """
        The subnet segment of the management component.
        """
        return pulumi.get(self, "management_subnet_cidr")

    @property
    @pulumi.getter(name="networkIds")
    def network_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The network ID list of subnets that the service have.
        The subnets corresponding to this parameter must be included in the VPC resource corresponding to `vpc_id`.
        These subnet segments cannot conflict with `172.16.0.0/12`.
        """
        return pulumi.get(self, "network_ids")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to register the Workspace service.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The current status of the Workspace service.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Specifies the VPC ID to which the service belongs.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

