# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDedicatedInstancesResult',
    'AwaitableGetDedicatedInstancesResult',
    'get_dedicated_instances',
    'get_dedicated_instances_output',
]

@pulumi.output_type
class GetDedicatedInstancesResult:
    """
    A collection of values returned by getDedicatedInstances.
    """
    def __init__(__self__, id=None, instances=None, name=None, region=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of WAF dedicated instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetDedicatedInstancesInstanceResult']:
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of WAF dedicated instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")


class AwaitableGetDedicatedInstancesResult(GetDedicatedInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDedicatedInstancesResult(
            id=self.id,
            instances=self.instances,
            name=self.name,
            region=self.region)


def get_dedicated_instances(id: Optional[str] = None,
                            name: Optional[str] = None,
                            region: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDedicatedInstancesResult:
    """
    Use this data source to get a list of WAF dedicated instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    instance_name = config.require_object("instanceName")
    instances = huaweicloud.Waf.get_dedicated_instances(name=instance_name)
    ```


    :param str id: The id of WAF dedicated instance.
    :param str name: The name of WAF dedicated instance.
    :param str region: The region in which to query the WAF dedicated instance.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Waf/getDedicatedInstances:getDedicatedInstances', __args__, opts=opts, typ=GetDedicatedInstancesResult).value

    return AwaitableGetDedicatedInstancesResult(
        id=__ret__.id,
        instances=__ret__.instances,
        name=__ret__.name,
        region=__ret__.region)


@_utilities.lift_output_func(get_dedicated_instances)
def get_dedicated_instances_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                                   name: Optional[pulumi.Input[Optional[str]]] = None,
                                   region: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDedicatedInstancesResult]:
    """
    Use this data source to get a list of WAF dedicated instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    instance_name = config.require_object("instanceName")
    instances = huaweicloud.Waf.get_dedicated_instances(name=instance_name)
    ```


    :param str id: The id of WAF dedicated instance.
    :param str name: The name of WAF dedicated instance.
    :param str region: The region in which to query the WAF dedicated instance.
           If omitted, the provider-level region will be used.
    """
    ...
