# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DedicatedInstanceArgs', 'DedicatedInstance']

@pulumi.input_type
class DedicatedInstanceArgs:
    def __init__(__self__, *,
                 available_zone: pulumi.Input[str],
                 ecs_flavor: pulumi.Input[str],
                 security_groups: pulumi.Input[Sequence[pulumi.Input[str]]],
                 specification_code: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 cpu_architecture: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DedicatedInstance resource.
        :param pulumi.Input[str] available_zone: The available zone names for the dedicated instances. It can be
               obtained through this data source `get_availability_zones`. Changing this will create a new instance.
        :param pulumi.Input[str] ecs_flavor: The flavor of the ECS used by the WAF instance. Flavors can be obtained
               through this data source `_ecs.get_flavors`. Changing this will create a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: The security group of the instance. This is an array of security group
               ids. Changing this will create a new instance.
        :param pulumi.Input[str] specification_code: The specification code of instance. Different specifications have
               different throughput. Changing this will create a new instance. Values are:
               + `waf.instance.professional` - The professional edition, throughput: 100 Mbit/s; QPS: 2,000 (Reference only).
               + `waf.instance.enterprise` - The enterprise edition, throughput: 500 Mbit/s; QPS: 10,000 (Reference only).
        :param pulumi.Input[str] subnet_id: The subnet id of WAF dedicated instance VPC. Changing this will create a
               new instance.
        :param pulumi.Input[str] vpc_id: The VPC id of WAF dedicated instance. Changing this will create a new
               instance.
        :param pulumi.Input[str] cpu_architecture: The ECS cpu architecture of instance, Default value is `x86`.
               Changing this will create a new instance.
        :param pulumi.Input[str] group_id: The instance group ID used by the WAF dedicated instance in ELB mode.
               Changing this will create a new instance.
        :param pulumi.Input[str] name: The name of WAF dedicated instance. Duplicate names are allowed, we suggest to keeping the
               name unique.
        :param pulumi.Input[str] region: The region in which to create the WAF dedicated instance. If omitted, the
               provider-level region will be used. Changing this setting will create a new instance.
        """
        pulumi.set(__self__, "available_zone", available_zone)
        pulumi.set(__self__, "ecs_flavor", ecs_flavor)
        pulumi.set(__self__, "security_groups", security_groups)
        pulumi.set(__self__, "specification_code", specification_code)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if cpu_architecture is not None:
            pulumi.set(__self__, "cpu_architecture", cpu_architecture)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="availableZone")
    def available_zone(self) -> pulumi.Input[str]:
        """
        The available zone names for the dedicated instances. It can be
        obtained through this data source `get_availability_zones`. Changing this will create a new instance.
        """
        return pulumi.get(self, "available_zone")

    @available_zone.setter
    def available_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "available_zone", value)

    @property
    @pulumi.getter(name="ecsFlavor")
    def ecs_flavor(self) -> pulumi.Input[str]:
        """
        The flavor of the ECS used by the WAF instance. Flavors can be obtained
        through this data source `_ecs.get_flavors`. Changing this will create a new instance.
        """
        return pulumi.get(self, "ecs_flavor")

    @ecs_flavor.setter
    def ecs_flavor(self, value: pulumi.Input[str]):
        pulumi.set(self, "ecs_flavor", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The security group of the instance. This is an array of security group
        ids. Changing this will create a new instance.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="specificationCode")
    def specification_code(self) -> pulumi.Input[str]:
        """
        The specification code of instance. Different specifications have
        different throughput. Changing this will create a new instance. Values are:
        + `waf.instance.professional` - The professional edition, throughput: 100 Mbit/s; QPS: 2,000 (Reference only).
        + `waf.instance.enterprise` - The enterprise edition, throughput: 500 Mbit/s; QPS: 10,000 (Reference only).
        """
        return pulumi.get(self, "specification_code")

    @specification_code.setter
    def specification_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "specification_code", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The subnet id of WAF dedicated instance VPC. Changing this will create a
        new instance.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        The VPC id of WAF dedicated instance. Changing this will create a new
        instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="cpuArchitecture")
    def cpu_architecture(self) -> Optional[pulumi.Input[str]]:
        """
        The ECS cpu architecture of instance, Default value is `x86`.
        Changing this will create a new instance.
        """
        return pulumi.get(self, "cpu_architecture")

    @cpu_architecture.setter
    def cpu_architecture(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu_architecture", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The instance group ID used by the WAF dedicated instance in ELB mode.
        Changing this will create a new instance.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of WAF dedicated instance. Duplicate names are allowed, we suggest to keeping the
        name unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the WAF dedicated instance. If omitted, the
        provider-level region will be used. Changing this setting will create a new instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DedicatedInstanceState:
    def __init__(__self__, *,
                 access_status: Optional[pulumi.Input[int]] = None,
                 available_zone: Optional[pulumi.Input[str]] = None,
                 cpu_architecture: Optional[pulumi.Input[str]] = None,
                 ecs_flavor: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 run_status: Optional[pulumi.Input[int]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 server_id: Optional[pulumi.Input[str]] = None,
                 service_ip: Optional[pulumi.Input[str]] = None,
                 specification_code: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 upgradable: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DedicatedInstance resources.
        :param pulumi.Input[int] access_status: The access status of the instance. `0`: inaccessible, `1`: accessible.
        :param pulumi.Input[str] available_zone: The available zone names for the dedicated instances. It can be
               obtained through this data source `get_availability_zones`. Changing this will create a new instance.
        :param pulumi.Input[str] cpu_architecture: The ECS cpu architecture of instance, Default value is `x86`.
               Changing this will create a new instance.
        :param pulumi.Input[str] ecs_flavor: The flavor of the ECS used by the WAF instance. Flavors can be obtained
               through this data source `_ecs.get_flavors`. Changing this will create a new instance.
        :param pulumi.Input[str] group_id: The instance group ID used by the WAF dedicated instance in ELB mode.
               Changing this will create a new instance.
        :param pulumi.Input[str] name: The name of WAF dedicated instance. Duplicate names are allowed, we suggest to keeping the
               name unique.
        :param pulumi.Input[str] region: The region in which to create the WAF dedicated instance. If omitted, the
               provider-level region will be used. Changing this setting will create a new instance.
        :param pulumi.Input[int] run_status: The running status of the instance. Values are:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: The security group of the instance. This is an array of security group
               ids. Changing this will create a new instance.
        :param pulumi.Input[str] server_id: The id of the instance server.
        :param pulumi.Input[str] service_ip: The ip of the instance service.
        :param pulumi.Input[str] specification_code: The specification code of instance. Different specifications have
               different throughput. Changing this will create a new instance. Values are:
               + `waf.instance.professional` - The professional edition, throughput: 100 Mbit/s; QPS: 2,000 (Reference only).
               + `waf.instance.enterprise` - The enterprise edition, throughput: 500 Mbit/s; QPS: 10,000 (Reference only).
        :param pulumi.Input[str] subnet_id: The subnet id of WAF dedicated instance VPC. Changing this will create a
               new instance.
        :param pulumi.Input[int] upgradable: The instance is to support upgrades. `0`: Cannot be upgraded, `1`: Can be upgraded.
        :param pulumi.Input[str] vpc_id: The VPC id of WAF dedicated instance. Changing this will create a new
               instance.
        """
        if access_status is not None:
            pulumi.set(__self__, "access_status", access_status)
        if available_zone is not None:
            pulumi.set(__self__, "available_zone", available_zone)
        if cpu_architecture is not None:
            pulumi.set(__self__, "cpu_architecture", cpu_architecture)
        if ecs_flavor is not None:
            pulumi.set(__self__, "ecs_flavor", ecs_flavor)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if run_status is not None:
            pulumi.set(__self__, "run_status", run_status)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)
        if service_ip is not None:
            pulumi.set(__self__, "service_ip", service_ip)
        if specification_code is not None:
            pulumi.set(__self__, "specification_code", specification_code)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if upgradable is not None:
            pulumi.set(__self__, "upgradable", upgradable)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="accessStatus")
    def access_status(self) -> Optional[pulumi.Input[int]]:
        """
        The access status of the instance. `0`: inaccessible, `1`: accessible.
        """
        return pulumi.get(self, "access_status")

    @access_status.setter
    def access_status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "access_status", value)

    @property
    @pulumi.getter(name="availableZone")
    def available_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The available zone names for the dedicated instances. It can be
        obtained through this data source `get_availability_zones`. Changing this will create a new instance.
        """
        return pulumi.get(self, "available_zone")

    @available_zone.setter
    def available_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "available_zone", value)

    @property
    @pulumi.getter(name="cpuArchitecture")
    def cpu_architecture(self) -> Optional[pulumi.Input[str]]:
        """
        The ECS cpu architecture of instance, Default value is `x86`.
        Changing this will create a new instance.
        """
        return pulumi.get(self, "cpu_architecture")

    @cpu_architecture.setter
    def cpu_architecture(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu_architecture", value)

    @property
    @pulumi.getter(name="ecsFlavor")
    def ecs_flavor(self) -> Optional[pulumi.Input[str]]:
        """
        The flavor of the ECS used by the WAF instance. Flavors can be obtained
        through this data source `_ecs.get_flavors`. Changing this will create a new instance.
        """
        return pulumi.get(self, "ecs_flavor")

    @ecs_flavor.setter
    def ecs_flavor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecs_flavor", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The instance group ID used by the WAF dedicated instance in ELB mode.
        Changing this will create a new instance.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of WAF dedicated instance. Duplicate names are allowed, we suggest to keeping the
        name unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the WAF dedicated instance. If omitted, the
        provider-level region will be used. Changing this setting will create a new instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="runStatus")
    def run_status(self) -> Optional[pulumi.Input[int]]:
        """
        The running status of the instance. Values are:
        """
        return pulumi.get(self, "run_status")

    @run_status.setter
    def run_status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "run_status", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The security group of the instance. This is an array of security group
        ids. Changing this will create a new instance.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the instance server.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_id", value)

    @property
    @pulumi.getter(name="serviceIp")
    def service_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The ip of the instance service.
        """
        return pulumi.get(self, "service_ip")

    @service_ip.setter
    def service_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_ip", value)

    @property
    @pulumi.getter(name="specificationCode")
    def specification_code(self) -> Optional[pulumi.Input[str]]:
        """
        The specification code of instance. Different specifications have
        different throughput. Changing this will create a new instance. Values are:
        + `waf.instance.professional` - The professional edition, throughput: 100 Mbit/s; QPS: 2,000 (Reference only).
        + `waf.instance.enterprise` - The enterprise edition, throughput: 500 Mbit/s; QPS: 10,000 (Reference only).
        """
        return pulumi.get(self, "specification_code")

    @specification_code.setter
    def specification_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "specification_code", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet id of WAF dedicated instance VPC. Changing this will create a
        new instance.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def upgradable(self) -> Optional[pulumi.Input[int]]:
        """
        The instance is to support upgrades. `0`: Cannot be upgraded, `1`: Can be upgraded.
        """
        return pulumi.get(self, "upgradable")

    @upgradable.setter
    def upgradable(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "upgradable", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC id of WAF dedicated instance. Changing this will create a new
        instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class DedicatedInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 available_zone: Optional[pulumi.Input[str]] = None,
                 cpu_architecture: Optional[pulumi.Input[str]] = None,
                 ecs_flavor: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 specification_code: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a WAF dedicated instance resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        az_name = config.require_object("azName")
        ecs_flavor_id = config.require_object("ecsFlavorId")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        security_group_id = config.require_object("securityGroupId")
        instance1 = huaweicloud.waf.DedicatedInstance("instance1",
            available_zone=az_name,
            specification_code="waf.instance.professional",
            ecs_flavor=ecs_flavor_id,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_groups=[security_group_id])
        ```

        ## Import

        WAF dedicated instance can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Waf/dedicatedInstance:DedicatedInstance instance_1 2f87641090206b821f07e0f6bd6
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] available_zone: The available zone names for the dedicated instances. It can be
               obtained through this data source `get_availability_zones`. Changing this will create a new instance.
        :param pulumi.Input[str] cpu_architecture: The ECS cpu architecture of instance, Default value is `x86`.
               Changing this will create a new instance.
        :param pulumi.Input[str] ecs_flavor: The flavor of the ECS used by the WAF instance. Flavors can be obtained
               through this data source `_ecs.get_flavors`. Changing this will create a new instance.
        :param pulumi.Input[str] group_id: The instance group ID used by the WAF dedicated instance in ELB mode.
               Changing this will create a new instance.
        :param pulumi.Input[str] name: The name of WAF dedicated instance. Duplicate names are allowed, we suggest to keeping the
               name unique.
        :param pulumi.Input[str] region: The region in which to create the WAF dedicated instance. If omitted, the
               provider-level region will be used. Changing this setting will create a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: The security group of the instance. This is an array of security group
               ids. Changing this will create a new instance.
        :param pulumi.Input[str] specification_code: The specification code of instance. Different specifications have
               different throughput. Changing this will create a new instance. Values are:
               + `waf.instance.professional` - The professional edition, throughput: 100 Mbit/s; QPS: 2,000 (Reference only).
               + `waf.instance.enterprise` - The enterprise edition, throughput: 500 Mbit/s; QPS: 10,000 (Reference only).
        :param pulumi.Input[str] subnet_id: The subnet id of WAF dedicated instance VPC. Changing this will create a
               new instance.
        :param pulumi.Input[str] vpc_id: The VPC id of WAF dedicated instance. Changing this will create a new
               instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DedicatedInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a WAF dedicated instance resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        az_name = config.require_object("azName")
        ecs_flavor_id = config.require_object("ecsFlavorId")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        security_group_id = config.require_object("securityGroupId")
        instance1 = huaweicloud.waf.DedicatedInstance("instance1",
            available_zone=az_name,
            specification_code="waf.instance.professional",
            ecs_flavor=ecs_flavor_id,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_groups=[security_group_id])
        ```

        ## Import

        WAF dedicated instance can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Waf/dedicatedInstance:DedicatedInstance instance_1 2f87641090206b821f07e0f6bd6
        ```

        :param str resource_name: The name of the resource.
        :param DedicatedInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DedicatedInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 available_zone: Optional[pulumi.Input[str]] = None,
                 cpu_architecture: Optional[pulumi.Input[str]] = None,
                 ecs_flavor: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 specification_code: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DedicatedInstanceArgs.__new__(DedicatedInstanceArgs)

            if available_zone is None and not opts.urn:
                raise TypeError("Missing required property 'available_zone'")
            __props__.__dict__["available_zone"] = available_zone
            __props__.__dict__["cpu_architecture"] = cpu_architecture
            if ecs_flavor is None and not opts.urn:
                raise TypeError("Missing required property 'ecs_flavor'")
            __props__.__dict__["ecs_flavor"] = ecs_flavor
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if security_groups is None and not opts.urn:
                raise TypeError("Missing required property 'security_groups'")
            __props__.__dict__["security_groups"] = security_groups
            if specification_code is None and not opts.urn:
                raise TypeError("Missing required property 'specification_code'")
            __props__.__dict__["specification_code"] = specification_code
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["access_status"] = None
            __props__.__dict__["run_status"] = None
            __props__.__dict__["server_id"] = None
            __props__.__dict__["service_ip"] = None
            __props__.__dict__["upgradable"] = None
        super(DedicatedInstance, __self__).__init__(
            'huaweicloud:Waf/dedicatedInstance:DedicatedInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_status: Optional[pulumi.Input[int]] = None,
            available_zone: Optional[pulumi.Input[str]] = None,
            cpu_architecture: Optional[pulumi.Input[str]] = None,
            ecs_flavor: Optional[pulumi.Input[str]] = None,
            group_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            run_status: Optional[pulumi.Input[int]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            server_id: Optional[pulumi.Input[str]] = None,
            service_ip: Optional[pulumi.Input[str]] = None,
            specification_code: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            upgradable: Optional[pulumi.Input[int]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'DedicatedInstance':
        """
        Get an existing DedicatedInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] access_status: The access status of the instance. `0`: inaccessible, `1`: accessible.
        :param pulumi.Input[str] available_zone: The available zone names for the dedicated instances. It can be
               obtained through this data source `get_availability_zones`. Changing this will create a new instance.
        :param pulumi.Input[str] cpu_architecture: The ECS cpu architecture of instance, Default value is `x86`.
               Changing this will create a new instance.
        :param pulumi.Input[str] ecs_flavor: The flavor of the ECS used by the WAF instance. Flavors can be obtained
               through this data source `_ecs.get_flavors`. Changing this will create a new instance.
        :param pulumi.Input[str] group_id: The instance group ID used by the WAF dedicated instance in ELB mode.
               Changing this will create a new instance.
        :param pulumi.Input[str] name: The name of WAF dedicated instance. Duplicate names are allowed, we suggest to keeping the
               name unique.
        :param pulumi.Input[str] region: The region in which to create the WAF dedicated instance. If omitted, the
               provider-level region will be used. Changing this setting will create a new instance.
        :param pulumi.Input[int] run_status: The running status of the instance. Values are:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: The security group of the instance. This is an array of security group
               ids. Changing this will create a new instance.
        :param pulumi.Input[str] server_id: The id of the instance server.
        :param pulumi.Input[str] service_ip: The ip of the instance service.
        :param pulumi.Input[str] specification_code: The specification code of instance. Different specifications have
               different throughput. Changing this will create a new instance. Values are:
               + `waf.instance.professional` - The professional edition, throughput: 100 Mbit/s; QPS: 2,000 (Reference only).
               + `waf.instance.enterprise` - The enterprise edition, throughput: 500 Mbit/s; QPS: 10,000 (Reference only).
        :param pulumi.Input[str] subnet_id: The subnet id of WAF dedicated instance VPC. Changing this will create a
               new instance.
        :param pulumi.Input[int] upgradable: The instance is to support upgrades. `0`: Cannot be upgraded, `1`: Can be upgraded.
        :param pulumi.Input[str] vpc_id: The VPC id of WAF dedicated instance. Changing this will create a new
               instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DedicatedInstanceState.__new__(_DedicatedInstanceState)

        __props__.__dict__["access_status"] = access_status
        __props__.__dict__["available_zone"] = available_zone
        __props__.__dict__["cpu_architecture"] = cpu_architecture
        __props__.__dict__["ecs_flavor"] = ecs_flavor
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["run_status"] = run_status
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["server_id"] = server_id
        __props__.__dict__["service_ip"] = service_ip
        __props__.__dict__["specification_code"] = specification_code
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["upgradable"] = upgradable
        __props__.__dict__["vpc_id"] = vpc_id
        return DedicatedInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessStatus")
    def access_status(self) -> pulumi.Output[int]:
        """
        The access status of the instance. `0`: inaccessible, `1`: accessible.
        """
        return pulumi.get(self, "access_status")

    @property
    @pulumi.getter(name="availableZone")
    def available_zone(self) -> pulumi.Output[str]:
        """
        The available zone names for the dedicated instances. It can be
        obtained through this data source `get_availability_zones`. Changing this will create a new instance.
        """
        return pulumi.get(self, "available_zone")

    @property
    @pulumi.getter(name="cpuArchitecture")
    def cpu_architecture(self) -> pulumi.Output[Optional[str]]:
        """
        The ECS cpu architecture of instance, Default value is `x86`.
        Changing this will create a new instance.
        """
        return pulumi.get(self, "cpu_architecture")

    @property
    @pulumi.getter(name="ecsFlavor")
    def ecs_flavor(self) -> pulumi.Output[str]:
        """
        The flavor of the ECS used by the WAF instance. Flavors can be obtained
        through this data source `_ecs.get_flavors`. Changing this will create a new instance.
        """
        return pulumi.get(self, "ecs_flavor")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[Optional[str]]:
        """
        The instance group ID used by the WAF dedicated instance in ELB mode.
        Changing this will create a new instance.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of WAF dedicated instance. Duplicate names are allowed, we suggest to keeping the
        name unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the WAF dedicated instance. If omitted, the
        provider-level region will be used. Changing this setting will create a new instance.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="runStatus")
    def run_status(self) -> pulumi.Output[int]:
        """
        The running status of the instance. Values are:
        """
        return pulumi.get(self, "run_status")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Sequence[str]]:
        """
        The security group of the instance. This is an array of security group
        ids. Changing this will create a new instance.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Output[str]:
        """
        The id of the instance server.
        """
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter(name="serviceIp")
    def service_ip(self) -> pulumi.Output[str]:
        """
        The ip of the instance service.
        """
        return pulumi.get(self, "service_ip")

    @property
    @pulumi.getter(name="specificationCode")
    def specification_code(self) -> pulumi.Output[str]:
        """
        The specification code of instance. Different specifications have
        different throughput. Changing this will create a new instance. Values are:
        + `waf.instance.professional` - The professional edition, throughput: 100 Mbit/s; QPS: 2,000 (Reference only).
        + `waf.instance.enterprise` - The enterprise edition, throughput: 500 Mbit/s; QPS: 10,000 (Reference only).
        """
        return pulumi.get(self, "specification_code")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The subnet id of WAF dedicated instance VPC. Changing this will create a
        new instance.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def upgradable(self) -> pulumi.Output[int]:
        """
        The instance is to support upgrades. `0`: Cannot be upgraded, `1`: Can be upgraded.
        """
        return pulumi.get(self, "upgradable")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The VPC id of WAF dedicated instance. Changing this will create a new
        instance.
        """
        return pulumi.get(self, "vpc_id")

