# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpcArgs', 'Vpc']

@pulumi.input_type
class VpcArgs:
    def __init__(__self__, *,
                 cidr: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secondary_cidr: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Vpc resource.
        :param pulumi.Input[str] cidr: Specifies the range of available subnets in the VPC. The value ranges from 10.0.0.0/8 to
               10.255.255.0/24, 172.16.0.0/12 to 172.31.255.0/24, or 192.168.0.0/16 to 192.168.255.0/24.
        :param pulumi.Input[str] description: Specifies supplementary information about the VPC. The value is a string of
               no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the VPC. Changing this
               creates a new VPC resource.
        :param pulumi.Input[str] name: Specifies the name of the VPC. The name must be unique for a tenant. The value is a string
               of no more than 64 characters and can contain digits, letters, underscores (_), and hyphens (-).
        :param pulumi.Input[str] region: Specifies the region in which to create the VPC. If omitted, the
               provider-level region will be used. Changing this creates a new VPC resource.
        :param pulumi.Input[str] secondary_cidr: Specifies the secondary CIDR block of the VPC.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the VPC.
        """
        pulumi.set(__self__, "cidr", cidr)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secondary_cidr is not None:
            pulumi.set(__self__, "secondary_cidr", secondary_cidr)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Input[str]:
        """
        Specifies the range of available subnets in the VPC. The value ranges from 10.0.0.0/8 to
        10.255.255.0/24, 172.16.0.0/12 to 172.31.255.0/24, or 192.168.0.0/16 to 192.168.255.0/24.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: pulumi.Input[str]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies supplementary information about the VPC. The value is a string of
        no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the VPC. Changing this
        creates a new VPC resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the VPC. The name must be unique for a tenant. The value is a string
        of no more than 64 characters and can contain digits, letters, underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the VPC. If omitted, the
        provider-level region will be used. Changing this creates a new VPC resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="secondaryCidr")
    def secondary_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the secondary CIDR block of the VPC.
        """
        return pulumi.get(self, "secondary_cidr")

    @secondary_cidr.setter
    def secondary_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_cidr", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to associate with the VPC.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _VpcState:
    def __init__(__self__, *,
                 cidr: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['VpcRouteArgs']]]] = None,
                 secondary_cidr: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Vpc resources.
        :param pulumi.Input[str] cidr: Specifies the range of available subnets in the VPC. The value ranges from 10.0.0.0/8 to
               10.255.255.0/24, 172.16.0.0/12 to 172.31.255.0/24, or 192.168.0.0/16 to 192.168.255.0/24.
        :param pulumi.Input[str] description: Specifies supplementary information about the VPC. The value is a string of
               no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the VPC. Changing this
               creates a new VPC resource.
        :param pulumi.Input[str] name: Specifies the name of the VPC. The name must be unique for a tenant. The value is a string
               of no more than 64 characters and can contain digits, letters, underscores (_), and hyphens (-).
        :param pulumi.Input[str] region: Specifies the region in which to create the VPC. If omitted, the
               provider-level region will be used. Changing this creates a new VPC resource.
        :param pulumi.Input[str] secondary_cidr: Specifies the secondary CIDR block of the VPC.
        :param pulumi.Input[str] status: The current status of the VPC. Possible values are as follows: CREATING, OK or ERROR.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the VPC.
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routes is not None:
            warnings.warn("""use huaweicloud_vpc_route_table data source to get all routes""", DeprecationWarning)
            pulumi.log.warn("""routes is deprecated: use huaweicloud_vpc_route_table data source to get all routes""")
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if secondary_cidr is not None:
            pulumi.set(__self__, "secondary_cidr", secondary_cidr)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the range of available subnets in the VPC. The value ranges from 10.0.0.0/8 to
        10.255.255.0/24, 172.16.0.0/12 to 172.31.255.0/24, or 192.168.0.0/16 to 192.168.255.0/24.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies supplementary information about the VPC. The value is a string of
        no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the VPC. Changing this
        creates a new VPC resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the VPC. The name must be unique for a tenant. The value is a string
        of no more than 64 characters and can contain digits, letters, underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the VPC. If omitted, the
        provider-level region will be used. Changing this creates a new VPC resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcRouteArgs']]]]:
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcRouteArgs']]]]):
        pulumi.set(self, "routes", value)

    @property
    @pulumi.getter(name="secondaryCidr")
    def secondary_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the secondary CIDR block of the VPC.
        """
        return pulumi.get(self, "secondary_cidr")

    @secondary_cidr.setter
    def secondary_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_cidr", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The current status of the VPC. Possible values are as follows: CREATING, OK or ERROR.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to associate with the VPC.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class Vpc(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secondary_cidr: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages a VPC resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_name = config.get("vpcName")
        if vpc_name is None:
            vpc_name = "huaweicloud_vpc"
        vpc_cidr = config.get("vpcCidr")
        if vpc_cidr is None:
            vpc_cidr = "192.168.0.0/16"
        vpc = huaweicloud.vpc.Vpc("vpc", cidr=vpc_cidr)
        vpc_with_tags = huaweicloud.vpc.Vpc("vpcWithTags",
            cidr=vpc_cidr,
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```

        ## Import

        VPCs can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vpc/vpc:Vpc vpc_v1 7117d38e-4c8f-4624-a505-bd96b97d024c
        ```

         Note that the imported state may not be identical to your resource definition when `secondary_cidr` was set. You you can ignore changes as below. resource "huaweicloud_vpc" "vpc_v1" {

         ...

         lifecycle {

         ignore_changes = [ secondary_cidr ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cidr: Specifies the range of available subnets in the VPC. The value ranges from 10.0.0.0/8 to
               10.255.255.0/24, 172.16.0.0/12 to 172.31.255.0/24, or 192.168.0.0/16 to 192.168.255.0/24.
        :param pulumi.Input[str] description: Specifies supplementary information about the VPC. The value is a string of
               no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the VPC. Changing this
               creates a new VPC resource.
        :param pulumi.Input[str] name: Specifies the name of the VPC. The name must be unique for a tenant. The value is a string
               of no more than 64 characters and can contain digits, letters, underscores (_), and hyphens (-).
        :param pulumi.Input[str] region: Specifies the region in which to create the VPC. If omitted, the
               provider-level region will be used. Changing this creates a new VPC resource.
        :param pulumi.Input[str] secondary_cidr: Specifies the secondary CIDR block of the VPC.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the VPC.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VPC resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_name = config.get("vpcName")
        if vpc_name is None:
            vpc_name = "huaweicloud_vpc"
        vpc_cidr = config.get("vpcCidr")
        if vpc_cidr is None:
            vpc_cidr = "192.168.0.0/16"
        vpc = huaweicloud.vpc.Vpc("vpc", cidr=vpc_cidr)
        vpc_with_tags = huaweicloud.vpc.Vpc("vpcWithTags",
            cidr=vpc_cidr,
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```

        ## Import

        VPCs can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vpc/vpc:Vpc vpc_v1 7117d38e-4c8f-4624-a505-bd96b97d024c
        ```

         Note that the imported state may not be identical to your resource definition when `secondary_cidr` was set. You you can ignore changes as below. resource "huaweicloud_vpc" "vpc_v1" {

         ...

         lifecycle {

         ignore_changes = [ secondary_cidr ]

         } }

        :param str resource_name: The name of the resource.
        :param VpcArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secondary_cidr: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcArgs.__new__(VpcArgs)

            if cidr is None and not opts.urn:
                raise TypeError("Missing required property 'cidr'")
            __props__.__dict__["cidr"] = cidr
            __props__.__dict__["description"] = description
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["secondary_cidr"] = secondary_cidr
            __props__.__dict__["tags"] = tags
            __props__.__dict__["routes"] = None
            __props__.__dict__["status"] = None
        super(Vpc, __self__).__init__(
            'huaweicloud:Vpc/vpc:Vpc',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cidr: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            routes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcRouteArgs']]]]] = None,
            secondary_cidr: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'Vpc':
        """
        Get an existing Vpc resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cidr: Specifies the range of available subnets in the VPC. The value ranges from 10.0.0.0/8 to
               10.255.255.0/24, 172.16.0.0/12 to 172.31.255.0/24, or 192.168.0.0/16 to 192.168.255.0/24.
        :param pulumi.Input[str] description: Specifies supplementary information about the VPC. The value is a string of
               no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the VPC. Changing this
               creates a new VPC resource.
        :param pulumi.Input[str] name: Specifies the name of the VPC. The name must be unique for a tenant. The value is a string
               of no more than 64 characters and can contain digits, letters, underscores (_), and hyphens (-).
        :param pulumi.Input[str] region: Specifies the region in which to create the VPC. If omitted, the
               provider-level region will be used. Changing this creates a new VPC resource.
        :param pulumi.Input[str] secondary_cidr: Specifies the secondary CIDR block of the VPC.
        :param pulumi.Input[str] status: The current status of the VPC. Possible values are as follows: CREATING, OK or ERROR.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the VPC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcState.__new__(_VpcState)

        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["description"] = description
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["routes"] = routes
        __props__.__dict__["secondary_cidr"] = secondary_cidr
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return Vpc(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[str]:
        """
        Specifies the range of available subnets in the VPC. The value ranges from 10.0.0.0/8 to
        10.255.255.0/24, 172.16.0.0/12 to 172.31.255.0/24, or 192.168.0.0/16 to 192.168.255.0/24.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies supplementary information about the VPC. The value is a string of
        no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Specifies the enterprise project id of the VPC. Changing this
        creates a new VPC resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the VPC. The name must be unique for a tenant. The value is a string
        of no more than 64 characters and can contain digits, letters, underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the VPC. If omitted, the
        provider-level region will be used. Changing this creates a new VPC resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def routes(self) -> pulumi.Output[Sequence['outputs.VpcRoute']]:
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter(name="secondaryCidr")
    def secondary_cidr(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the secondary CIDR block of the VPC.
        """
        return pulumi.get(self, "secondary_cidr")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The current status of the VPC. Possible values are as follows: CREATING, OK or ERROR.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the key/value pairs to associate with the VPC.
        """
        return pulumi.get(self, "tags")

