# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetSubnetResult',
    'AwaitableGetSubnetResult',
    'get_subnet',
    'get_subnet_output',
]

@pulumi.output_type
class GetSubnetResult:
    """
    A collection of values returned by getSubnet.
    """
    def __init__(__self__, availability_zone=None, cidr=None, description=None, dhcp_enable=None, dns_lists=None, gateway_ip=None, id=None, ipv4_subnet_id=None, ipv6_cidr=None, ipv6_enable=None, ipv6_gateway=None, ipv6_subnet_id=None, name=None, primary_dns=None, region=None, secondary_dns=None, status=None, subnet_id=None, vpc_id=None):
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if cidr and not isinstance(cidr, str):
            raise TypeError("Expected argument 'cidr' to be a str")
        pulumi.set(__self__, "cidr", cidr)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dhcp_enable and not isinstance(dhcp_enable, bool):
            raise TypeError("Expected argument 'dhcp_enable' to be a bool")
        pulumi.set(__self__, "dhcp_enable", dhcp_enable)
        if dns_lists and not isinstance(dns_lists, list):
            raise TypeError("Expected argument 'dns_lists' to be a list")
        pulumi.set(__self__, "dns_lists", dns_lists)
        if gateway_ip and not isinstance(gateway_ip, str):
            raise TypeError("Expected argument 'gateway_ip' to be a str")
        pulumi.set(__self__, "gateway_ip", gateway_ip)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipv4_subnet_id and not isinstance(ipv4_subnet_id, str):
            raise TypeError("Expected argument 'ipv4_subnet_id' to be a str")
        pulumi.set(__self__, "ipv4_subnet_id", ipv4_subnet_id)
        if ipv6_cidr and not isinstance(ipv6_cidr, str):
            raise TypeError("Expected argument 'ipv6_cidr' to be a str")
        pulumi.set(__self__, "ipv6_cidr", ipv6_cidr)
        if ipv6_enable and not isinstance(ipv6_enable, bool):
            raise TypeError("Expected argument 'ipv6_enable' to be a bool")
        pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        if ipv6_gateway and not isinstance(ipv6_gateway, str):
            raise TypeError("Expected argument 'ipv6_gateway' to be a str")
        pulumi.set(__self__, "ipv6_gateway", ipv6_gateway)
        if ipv6_subnet_id and not isinstance(ipv6_subnet_id, str):
            raise TypeError("Expected argument 'ipv6_subnet_id' to be a str")
        pulumi.set(__self__, "ipv6_subnet_id", ipv6_subnet_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if primary_dns and not isinstance(primary_dns, str):
            raise TypeError("Expected argument 'primary_dns' to be a str")
        pulumi.set(__self__, "primary_dns", primary_dns)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if secondary_dns and not isinstance(secondary_dns, str):
            raise TypeError("Expected argument 'secondary_dns' to be a str")
        pulumi.set(__self__, "secondary_dns", secondary_dns)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def cidr(self) -> str:
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dhcpEnable")
    def dhcp_enable(self) -> bool:
        return pulumi.get(self, "dhcp_enable")

    @property
    @pulumi.getter(name="dnsLists")
    def dns_lists(self) -> Sequence[str]:
        return pulumi.get(self, "dns_lists")

    @property
    @pulumi.getter(name="gatewayIp")
    def gateway_ip(self) -> str:
        return pulumi.get(self, "gateway_ip")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipv4SubnetId")
    def ipv4_subnet_id(self) -> str:
        return pulumi.get(self, "ipv4_subnet_id")

    @property
    @pulumi.getter(name="ipv6Cidr")
    def ipv6_cidr(self) -> str:
        return pulumi.get(self, "ipv6_cidr")

    @property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> bool:
        return pulumi.get(self, "ipv6_enable")

    @property
    @pulumi.getter(name="ipv6Gateway")
    def ipv6_gateway(self) -> str:
        return pulumi.get(self, "ipv6_gateway")

    @property
    @pulumi.getter(name="ipv6SubnetId")
    def ipv6_subnet_id(self) -> str:
        return pulumi.get(self, "ipv6_subnet_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryDns")
    def primary_dns(self) -> str:
        return pulumi.get(self, "primary_dns")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secondaryDns")
    def secondary_dns(self) -> str:
        return pulumi.get(self, "secondary_dns")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        return pulumi.get(self, "vpc_id")


class AwaitableGetSubnetResult(GetSubnetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubnetResult(
            availability_zone=self.availability_zone,
            cidr=self.cidr,
            description=self.description,
            dhcp_enable=self.dhcp_enable,
            dns_lists=self.dns_lists,
            gateway_ip=self.gateway_ip,
            id=self.id,
            ipv4_subnet_id=self.ipv4_subnet_id,
            ipv6_cidr=self.ipv6_cidr,
            ipv6_enable=self.ipv6_enable,
            ipv6_gateway=self.ipv6_gateway,
            ipv6_subnet_id=self.ipv6_subnet_id,
            name=self.name,
            primary_dns=self.primary_dns,
            region=self.region,
            secondary_dns=self.secondary_dns,
            status=self.status,
            subnet_id=self.subnet_id,
            vpc_id=self.vpc_id)


def get_subnet(availability_zone: Optional[str] = None,
               cidr: Optional[str] = None,
               gateway_ip: Optional[str] = None,
               id: Optional[str] = None,
               name: Optional[str] = None,
               primary_dns: Optional[str] = None,
               region: Optional[str] = None,
               secondary_dns: Optional[str] = None,
               status: Optional[str] = None,
               vpc_id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubnetResult:
    """
    Provides details about a specific VPC subnet.

    This resource can prove useful when a module accepts a subnet id as an input variable and needs to, for example,
    determine the id of the VPC that the subnet belongs to.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    subnet = huaweicloud.Vpc.get_subnet(id=var["subnet_id"])
    pulumi.export("subnetVpcId", subnet.vpc_id)
    ```
    ## **Attributes Reference**

    In addition to all arguments above, the following attributes are exported:

    * `dns_list` - The IP address list of DNS servers on the subnet.

    * `dhcp_enable` - Whether the DHCP is enabled.

    * `description` - The description of the subnet.

    * `ipv4_subnet_id` - The ID of the IPv4 subnet (Native OpenStack API).

    * `ipv6_enable` - Whether the IPv6 is enabled.

    * `ipv6_subnet_id` - The ID of the IPv6 subnet (Native OpenStack API).

    * `ipv6_cidr` - The IPv6 subnet CIDR block.

    * `ipv6_gateway` - The IPv6 subnet gateway.


    :param str availability_zone: Specifies the availability zone (AZ) to which the subnet should belong.
    :param str cidr: Specifies the network segment of specific subnet to retrieve. The value must be in CIDR
           format.
    :param str gateway_ip: Specifies the subnet gateway address of specific subnet.
    :param str id: - Specifies a resource ID in UUID format.
    :param str name: Specifies the name of the specific subnet to retrieve.
    :param str primary_dns: Specifies the IP address of DNS server 1 on the specific subnet.
    :param str region: Specifies the region in which to obtain the subnet. If omitted, the provider-level
           region will be used.
    :param str secondary_dns: Specifies the IP address of DNS server 2 on the specific subnet.
    :param str status: Specifies the value can be ACTIVE, DOWN, UNKNOWN, or ERROR.
    :param str vpc_id: Specifies the id of the VPC that the desired subnet belongs to.
    """
    __args__ = dict()
    __args__['availabilityZone'] = availability_zone
    __args__['cidr'] = cidr
    __args__['gatewayIp'] = gateway_ip
    __args__['id'] = id
    __args__['name'] = name
    __args__['primaryDns'] = primary_dns
    __args__['region'] = region
    __args__['secondaryDns'] = secondary_dns
    __args__['status'] = status
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Vpc/getSubnet:getSubnet', __args__, opts=opts, typ=GetSubnetResult).value

    return AwaitableGetSubnetResult(
        availability_zone=__ret__.availability_zone,
        cidr=__ret__.cidr,
        description=__ret__.description,
        dhcp_enable=__ret__.dhcp_enable,
        dns_lists=__ret__.dns_lists,
        gateway_ip=__ret__.gateway_ip,
        id=__ret__.id,
        ipv4_subnet_id=__ret__.ipv4_subnet_id,
        ipv6_cidr=__ret__.ipv6_cidr,
        ipv6_enable=__ret__.ipv6_enable,
        ipv6_gateway=__ret__.ipv6_gateway,
        ipv6_subnet_id=__ret__.ipv6_subnet_id,
        name=__ret__.name,
        primary_dns=__ret__.primary_dns,
        region=__ret__.region,
        secondary_dns=__ret__.secondary_dns,
        status=__ret__.status,
        subnet_id=__ret__.subnet_id,
        vpc_id=__ret__.vpc_id)


@_utilities.lift_output_func(get_subnet)
def get_subnet_output(availability_zone: Optional[pulumi.Input[Optional[str]]] = None,
                      cidr: Optional[pulumi.Input[Optional[str]]] = None,
                      gateway_ip: Optional[pulumi.Input[Optional[str]]] = None,
                      id: Optional[pulumi.Input[Optional[str]]] = None,
                      name: Optional[pulumi.Input[Optional[str]]] = None,
                      primary_dns: Optional[pulumi.Input[Optional[str]]] = None,
                      region: Optional[pulumi.Input[Optional[str]]] = None,
                      secondary_dns: Optional[pulumi.Input[Optional[str]]] = None,
                      status: Optional[pulumi.Input[Optional[str]]] = None,
                      vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSubnetResult]:
    """
    Provides details about a specific VPC subnet.

    This resource can prove useful when a module accepts a subnet id as an input variable and needs to, for example,
    determine the id of the VPC that the subnet belongs to.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    subnet = huaweicloud.Vpc.get_subnet(id=var["subnet_id"])
    pulumi.export("subnetVpcId", subnet.vpc_id)
    ```
    ## **Attributes Reference**

    In addition to all arguments above, the following attributes are exported:

    * `dns_list` - The IP address list of DNS servers on the subnet.

    * `dhcp_enable` - Whether the DHCP is enabled.

    * `description` - The description of the subnet.

    * `ipv4_subnet_id` - The ID of the IPv4 subnet (Native OpenStack API).

    * `ipv6_enable` - Whether the IPv6 is enabled.

    * `ipv6_subnet_id` - The ID of the IPv6 subnet (Native OpenStack API).

    * `ipv6_cidr` - The IPv6 subnet CIDR block.

    * `ipv6_gateway` - The IPv6 subnet gateway.


    :param str availability_zone: Specifies the availability zone (AZ) to which the subnet should belong.
    :param str cidr: Specifies the network segment of specific subnet to retrieve. The value must be in CIDR
           format.
    :param str gateway_ip: Specifies the subnet gateway address of specific subnet.
    :param str id: - Specifies a resource ID in UUID format.
    :param str name: Specifies the name of the specific subnet to retrieve.
    :param str primary_dns: Specifies the IP address of DNS server 1 on the specific subnet.
    :param str region: Specifies the region in which to obtain the subnet. If omitted, the provider-level
           region will be used.
    :param str secondary_dns: Specifies the IP address of DNS server 2 on the specific subnet.
    :param str status: Specifies the value can be ACTIVE, DOWN, UNKNOWN, or ERROR.
    :param str vpc_id: Specifies the id of the VPC that the desired subnet belongs to.
    """
    ...
