# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EipArgs', 'Eip']

@pulumi.input_type
class EipArgs:
    def __init__(__self__, *,
                 bandwidth: pulumi.Input['EipBandwidthArgs'],
                 publicip: pulumi.Input['EipPublicipArgs'],
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Eip resource.
        :param pulumi.Input['EipBandwidthArgs'] bandwidth: The bandwidth object.
        :param pulumi.Input['EipPublicipArgs'] publicip: The elastic IP address object.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are *true* and *false*. Defaults to *false*. Changing this creates a new resource.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the elastic IP. Valid values are
               *prePaid* and *postPaid*, defaults to *postPaid*. Changing this creates a new eip.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the elastic IP. Changing this
               creates a new eip.
        :param pulumi.Input[str] name: The bandwidth name, which is a string of 1 to 64 characters that contain letters, digits,
               underscores (_), and hyphens (-). This parameter is mandatory when `share_type` is set to **PER**.
        :param pulumi.Input[int] period: Specifies the charging period of the elastic IP. If `period_unit` is set to
               *month*, the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter
               is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the elastic IP. Valid values are
               *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new
               eip.
        :param pulumi.Input[str] region: The region in which to create the EIP resource. If omitted, the provider-level
               region will be used. Changing this creates a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the elastic IP.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "publicip", publicip)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Input['EipBandwidthArgs']:
        """
        The bandwidth object.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: pulumi.Input['EipBandwidthArgs']):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter
    def publicip(self) -> pulumi.Input['EipPublicipArgs']:
        """
        The elastic IP address object.
        """
        return pulumi.get(self, "publicip")

    @publicip.setter
    def publicip(self, value: pulumi.Input['EipPublicipArgs']):
        pulumi.set(self, "publicip", value)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are *true* and *false*. Defaults to *false*. Changing this creates a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the elastic IP. Valid values are
        *prePaid* and *postPaid*, defaults to *postPaid*. Changing this creates a new eip.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the elastic IP. Changing this
        creates a new eip.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The bandwidth name, which is a string of 1 to 64 characters that contain letters, digits,
        underscores (_), and hyphens (-). This parameter is mandatory when `share_type` is set to **PER**.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the elastic IP. If `period_unit` is set to
        *month*, the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter
        is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the elastic IP. Valid values are
        *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new
        eip.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the EIP resource. If omitted, the provider-level
        region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to associate with the elastic IP.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _EipState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 bandwidth: Optional[pulumi.Input['EipBandwidthArgs']] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 ipv6_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 port_id: Optional[pulumi.Input[str]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 publicip: Optional[pulumi.Input['EipPublicipArgs']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Eip resources.
        :param pulumi.Input[str] address: The IPv4 address of the EIP.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are *true* and *false*. Defaults to *false*. Changing this creates a new resource.
        :param pulumi.Input['EipBandwidthArgs'] bandwidth: The bandwidth object.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the elastic IP. Valid values are
               *prePaid* and *postPaid*, defaults to *postPaid*. Changing this creates a new eip.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the elastic IP. Changing this
               creates a new eip.
        :param pulumi.Input[str] ipv6_address: The IPv6 address of the EIP.
        :param pulumi.Input[str] name: The bandwidth name, which is a string of 1 to 64 characters that contain letters, digits,
               underscores (_), and hyphens (-). This parameter is mandatory when `share_type` is set to **PER**.
        :param pulumi.Input[int] period: Specifies the charging period of the elastic IP. If `period_unit` is set to
               *month*, the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter
               is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the elastic IP. Valid values are
               *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new
               eip.
        :param pulumi.Input[str] port_id: The port ID which the EIP associated with.
        :param pulumi.Input[str] private_ip: The private IP address bound to the EIP.
        :param pulumi.Input['EipPublicipArgs'] publicip: The elastic IP address object.
        :param pulumi.Input[str] region: The region in which to create the EIP resource. If omitted, the provider-level
               region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] status: The status of EIP.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the elastic IP.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if publicip is not None:
            pulumi.set(__self__, "publicip", publicip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 address of the EIP.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are *true* and *false*. Defaults to *false*. Changing this creates a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input['EipBandwidthArgs']]:
        """
        The bandwidth object.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input['EipBandwidthArgs']]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the elastic IP. Valid values are
        *prePaid* and *postPaid*, defaults to *postPaid*. Changing this creates a new eip.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the elastic IP. Changing this
        creates a new eip.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 address of the EIP.
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The bandwidth name, which is a string of 1 to 64 characters that contain letters, digits,
        underscores (_), and hyphens (-). This parameter is mandatory when `share_type` is set to **PER**.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the elastic IP. If `period_unit` is set to
        *month*, the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter
        is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the elastic IP. Valid values are
        *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new
        eip.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[pulumi.Input[str]]:
        """
        The port ID which the EIP associated with.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_id", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The private IP address bound to the EIP.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter
    def publicip(self) -> Optional[pulumi.Input['EipPublicipArgs']]:
        """
        The elastic IP address object.
        """
        return pulumi.get(self, "publicip")

    @publicip.setter
    def publicip(self, value: Optional[pulumi.Input['EipPublicipArgs']]):
        pulumi.set(self, "publicip", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the EIP resource. If omitted, the provider-level
        region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of EIP.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to associate with the elastic IP.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class Eip(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 bandwidth: Optional[pulumi.Input[pulumi.InputType['EipBandwidthArgs']]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 publicip: Optional[pulumi.Input[pulumi.InputType['EipPublicipArgs']]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages an EIP resource within HuaweiCloud.

        ## Example Usage
        ### EIP with Dedicated Bandwidth

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        eip1 = huaweicloud.vpc.Eip("eip1",
            bandwidth=huaweicloud.vpc.EipBandwidthArgs(
                charge_mode="traffic",
                name="test",
                share_type="PER",
                size=10,
            ),
            publicip=huaweicloud.vpc.EipPublicipArgs(
                type="5_bgp",
            ))
        ```
        ### EIP with Shared Bandwidth

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        bandwidth1 = huaweicloud.vpc.Bandwidth("bandwidth1", size=5)
        eip1 = huaweicloud.vpc.Eip("eip1",
            publicip=huaweicloud.vpc.EipPublicipArgs(
                type="5_bgp",
            ),
            bandwidth=huaweicloud.vpc.EipBandwidthArgs(
                share_type="WHOLE",
                id=bandwidth1.id,
            ))
        ```

        ## Import

        EIPs can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vpc/eip:Eip eip_1 2c7f39f3-702b-48d1-940c-b50384177ee1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are *true* and *false*. Defaults to *false*. Changing this creates a new resource.
        :param pulumi.Input[pulumi.InputType['EipBandwidthArgs']] bandwidth: The bandwidth object.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the elastic IP. Valid values are
               *prePaid* and *postPaid*, defaults to *postPaid*. Changing this creates a new eip.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the elastic IP. Changing this
               creates a new eip.
        :param pulumi.Input[str] name: The bandwidth name, which is a string of 1 to 64 characters that contain letters, digits,
               underscores (_), and hyphens (-). This parameter is mandatory when `share_type` is set to **PER**.
        :param pulumi.Input[int] period: Specifies the charging period of the elastic IP. If `period_unit` is set to
               *month*, the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter
               is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the elastic IP. Valid values are
               *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new
               eip.
        :param pulumi.Input[pulumi.InputType['EipPublicipArgs']] publicip: The elastic IP address object.
        :param pulumi.Input[str] region: The region in which to create the EIP resource. If omitted, the provider-level
               region will be used. Changing this creates a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the elastic IP.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EipArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an EIP resource within HuaweiCloud.

        ## Example Usage
        ### EIP with Dedicated Bandwidth

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        eip1 = huaweicloud.vpc.Eip("eip1",
            bandwidth=huaweicloud.vpc.EipBandwidthArgs(
                charge_mode="traffic",
                name="test",
                share_type="PER",
                size=10,
            ),
            publicip=huaweicloud.vpc.EipPublicipArgs(
                type="5_bgp",
            ))
        ```
        ### EIP with Shared Bandwidth

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        bandwidth1 = huaweicloud.vpc.Bandwidth("bandwidth1", size=5)
        eip1 = huaweicloud.vpc.Eip("eip1",
            publicip=huaweicloud.vpc.EipPublicipArgs(
                type="5_bgp",
            ),
            bandwidth=huaweicloud.vpc.EipBandwidthArgs(
                share_type="WHOLE",
                id=bandwidth1.id,
            ))
        ```

        ## Import

        EIPs can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vpc/eip:Eip eip_1 2c7f39f3-702b-48d1-940c-b50384177ee1
        ```

        :param str resource_name: The name of the resource.
        :param EipArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EipArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 bandwidth: Optional[pulumi.Input[pulumi.InputType['EipBandwidthArgs']]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 publicip: Optional[pulumi.Input[pulumi.InputType['EipPublicipArgs']]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EipArgs.__new__(EipArgs)

            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            if bandwidth is None and not opts.urn:
                raise TypeError("Missing required property 'bandwidth'")
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["name"] = name
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            if publicip is None and not opts.urn:
                raise TypeError("Missing required property 'publicip'")
            __props__.__dict__["publicip"] = publicip
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["address"] = None
            __props__.__dict__["ipv6_address"] = None
            __props__.__dict__["port_id"] = None
            __props__.__dict__["private_ip"] = None
            __props__.__dict__["status"] = None
        super(Eip, __self__).__init__(
            'huaweicloud:Vpc/eip:Eip',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[str]] = None,
            auto_pay: Optional[pulumi.Input[str]] = None,
            auto_renew: Optional[pulumi.Input[str]] = None,
            bandwidth: Optional[pulumi.Input[pulumi.InputType['EipBandwidthArgs']]] = None,
            charging_mode: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            ipv6_address: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            port_id: Optional[pulumi.Input[str]] = None,
            private_ip: Optional[pulumi.Input[str]] = None,
            publicip: Optional[pulumi.Input[pulumi.InputType['EipPublicipArgs']]] = None,
            region: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'Eip':
        """
        Get an existing Eip resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address: The IPv4 address of the EIP.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are *true* and *false*. Defaults to *false*. Changing this creates a new resource.
        :param pulumi.Input[pulumi.InputType['EipBandwidthArgs']] bandwidth: The bandwidth object.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the elastic IP. Valid values are
               *prePaid* and *postPaid*, defaults to *postPaid*. Changing this creates a new eip.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the elastic IP. Changing this
               creates a new eip.
        :param pulumi.Input[str] ipv6_address: The IPv6 address of the EIP.
        :param pulumi.Input[str] name: The bandwidth name, which is a string of 1 to 64 characters that contain letters, digits,
               underscores (_), and hyphens (-). This parameter is mandatory when `share_type` is set to **PER**.
        :param pulumi.Input[int] period: Specifies the charging period of the elastic IP. If `period_unit` is set to
               *month*, the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter
               is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the elastic IP. Valid values are
               *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new
               eip.
        :param pulumi.Input[str] port_id: The port ID which the EIP associated with.
        :param pulumi.Input[str] private_ip: The private IP address bound to the EIP.
        :param pulumi.Input[pulumi.InputType['EipPublicipArgs']] publicip: The elastic IP address object.
        :param pulumi.Input[str] region: The region in which to create the EIP resource. If omitted, the provider-level
               region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] status: The status of EIP.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the elastic IP.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EipState.__new__(_EipState)

        __props__.__dict__["address"] = address
        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["ipv6_address"] = ipv6_address
        __props__.__dict__["name"] = name
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["port_id"] = port_id
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["publicip"] = publicip
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return Eip(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Output[str]:
        """
        The IPv4 address of the EIP.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "auto_pay")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are *true* and *false*. Defaults to *false*. Changing this creates a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output['outputs.EipBandwidth']:
        """
        The bandwidth object.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[str]:
        """
        Specifies the charging mode of the elastic IP. Valid values are
        *prePaid* and *postPaid*, defaults to *postPaid*. Changing this creates a new eip.
        """
        return pulumi.get(self, "charging_mode")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        The enterprise project id of the elastic IP. Changing this
        creates a new eip.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> pulumi.Output[str]:
        """
        The IPv6 address of the EIP.
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The bandwidth name, which is a string of 1 to 64 characters that contain letters, digits,
        underscores (_), and hyphens (-). This parameter is mandatory when `share_type` is set to **PER**.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the charging period of the elastic IP. If `period_unit` is set to
        *month*, the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter
        is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the charging period unit of the elastic IP. Valid values are
        *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new
        eip.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> pulumi.Output[str]:
        """
        The port ID which the EIP associated with.
        """
        return pulumi.get(self, "port_id")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[str]:
        """
        The private IP address bound to the EIP.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter
    def publicip(self) -> pulumi.Output['outputs.EipPublicip']:
        """
        The elastic IP address object.
        """
        return pulumi.get(self, "publicip")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the EIP resource. If omitted, the provider-level
        region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of EIP.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the key/value pairs to associate with the elastic IP.
        """
        return pulumi.get(self, "tags")

