# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BandwidthArgs', 'Bandwidth']

@pulumi.input_type
class BandwidthArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[int],
                 charge_mode: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Bandwidth resource.
        :param pulumi.Input[int] size: Specifies the size of the Shared Bandwidth. The value ranges from 5 Mbit/s to 2000 Mbit/s.
        :param pulumi.Input[str] charge_mode: Specifies whether the billing is based on bandwidth or
               95th percentile bandwidth (enhanced). Possible values can be **bandwidth** and **95peak_plus**.
               The default value is **bandwidth**, and **95peak_plus** is only valid for v4 and v5 Customer.
               Changing this creates a new bandwidth.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the Shared Bandwidth.
               Changing this creates a new bandwidth.
        :param pulumi.Input[str] name: Specifies the bandwidth name. The value is a string of 1 to 64 characters that
               can contain letters, digits, underscores (_), hyphens (-), and periods (.).
        :param pulumi.Input[str] region: Specifies the region in which to create the Shared Bandwidth.
               If omitted, the provider-level region will be used. Changing this creates a new bandwidth.
        """
        pulumi.set(__self__, "size", size)
        if charge_mode is not None:
            pulumi.set(__self__, "charge_mode", charge_mode)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        Specifies the size of the Shared Bandwidth. The value ranges from 5 Mbit/s to 2000 Mbit/s.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="chargeMode")
    def charge_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the billing is based on bandwidth or
        95th percentile bandwidth (enhanced). Possible values can be **bandwidth** and **95peak_plus**.
        The default value is **bandwidth**, and **95peak_plus** is only valid for v4 and v5 Customer.
        Changing this creates a new bandwidth.
        """
        return pulumi.get(self, "charge_mode")

    @charge_mode.setter
    def charge_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charge_mode", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the Shared Bandwidth.
        Changing this creates a new bandwidth.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the bandwidth name. The value is a string of 1 to 64 characters that
        can contain letters, digits, underscores (_), hyphens (-), and periods (.).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the Shared Bandwidth.
        If omitted, the provider-level region will be used. Changing this creates a new bandwidth.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _BandwidthState:
    def __init__(__self__, *,
                 bandwidth_type: Optional[pulumi.Input[str]] = None,
                 charge_mode: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 publicips: Optional[pulumi.Input[Sequence[pulumi.Input['BandwidthPublicipArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 share_type: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Bandwidth resources.
        :param pulumi.Input[str] bandwidth_type: Indicates the bandwidth type.
        :param pulumi.Input[str] charge_mode: Specifies whether the billing is based on bandwidth or
               95th percentile bandwidth (enhanced). Possible values can be **bandwidth** and **95peak_plus**.
               The default value is **bandwidth**, and **95peak_plus** is only valid for v4 and v5 Customer.
               Changing this creates a new bandwidth.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the Shared Bandwidth.
               Changing this creates a new bandwidth.
        :param pulumi.Input[str] name: Specifies the bandwidth name. The value is a string of 1 to 64 characters that
               can contain letters, digits, underscores (_), hyphens (-), and periods (.).
        :param pulumi.Input[Sequence[pulumi.Input['BandwidthPublicipArgs']]] publicips: An array of EIPs that use the bandwidth. The object includes the following:
        :param pulumi.Input[str] region: Specifies the region in which to create the Shared Bandwidth.
               If omitted, the provider-level region will be used. Changing this creates a new bandwidth.
        :param pulumi.Input[str] share_type: Indicates whether the bandwidth is shared or dedicated.
        :param pulumi.Input[int] size: Specifies the size of the Shared Bandwidth. The value ranges from 5 Mbit/s to 2000 Mbit/s.
        :param pulumi.Input[str] status: Indicates the bandwidth status.
        """
        if bandwidth_type is not None:
            pulumi.set(__self__, "bandwidth_type", bandwidth_type)
        if charge_mode is not None:
            pulumi.set(__self__, "charge_mode", charge_mode)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if publicips is not None:
            pulumi.set(__self__, "publicips", publicips)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if share_type is not None:
            pulumi.set(__self__, "share_type", share_type)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="bandwidthType")
    def bandwidth_type(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the bandwidth type.
        """
        return pulumi.get(self, "bandwidth_type")

    @bandwidth_type.setter
    def bandwidth_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth_type", value)

    @property
    @pulumi.getter(name="chargeMode")
    def charge_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the billing is based on bandwidth or
        95th percentile bandwidth (enhanced). Possible values can be **bandwidth** and **95peak_plus**.
        The default value is **bandwidth**, and **95peak_plus** is only valid for v4 and v5 Customer.
        Changing this creates a new bandwidth.
        """
        return pulumi.get(self, "charge_mode")

    @charge_mode.setter
    def charge_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charge_mode", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the Shared Bandwidth.
        Changing this creates a new bandwidth.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the bandwidth name. The value is a string of 1 to 64 characters that
        can contain letters, digits, underscores (_), hyphens (-), and periods (.).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def publicips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BandwidthPublicipArgs']]]]:
        """
        An array of EIPs that use the bandwidth. The object includes the following:
        """
        return pulumi.get(self, "publicips")

    @publicips.setter
    def publicips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BandwidthPublicipArgs']]]]):
        pulumi.set(self, "publicips", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the Shared Bandwidth.
        If omitted, the provider-level region will be used. Changing this creates a new bandwidth.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="shareType")
    def share_type(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether the bandwidth is shared or dedicated.
        """
        return pulumi.get(self, "share_type")

    @share_type.setter
    def share_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "share_type", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the size of the Shared Bandwidth. The value ranges from 5 Mbit/s to 2000 Mbit/s.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the bandwidth status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class Bandwidth(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 charge_mode: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Manages a **Shared** Bandwidth resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        bandwidth1 = huaweicloud.vpc.Bandwidth("bandwidth1", size=5)
        ```

        ## Import

        Shared Bandwidths can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vpc/bandwidth:Bandwidth bandwidth_1 7117d38e-4c8f-4624-a505-bd96b97d024c
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] charge_mode: Specifies whether the billing is based on bandwidth or
               95th percentile bandwidth (enhanced). Possible values can be **bandwidth** and **95peak_plus**.
               The default value is **bandwidth**, and **95peak_plus** is only valid for v4 and v5 Customer.
               Changing this creates a new bandwidth.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the Shared Bandwidth.
               Changing this creates a new bandwidth.
        :param pulumi.Input[str] name: Specifies the bandwidth name. The value is a string of 1 to 64 characters that
               can contain letters, digits, underscores (_), hyphens (-), and periods (.).
        :param pulumi.Input[str] region: Specifies the region in which to create the Shared Bandwidth.
               If omitted, the provider-level region will be used. Changing this creates a new bandwidth.
        :param pulumi.Input[int] size: Specifies the size of the Shared Bandwidth. The value ranges from 5 Mbit/s to 2000 Mbit/s.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BandwidthArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a **Shared** Bandwidth resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        bandwidth1 = huaweicloud.vpc.Bandwidth("bandwidth1", size=5)
        ```

        ## Import

        Shared Bandwidths can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vpc/bandwidth:Bandwidth bandwidth_1 7117d38e-4c8f-4624-a505-bd96b97d024c
        ```

        :param str resource_name: The name of the resource.
        :param BandwidthArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BandwidthArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 charge_mode: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BandwidthArgs.__new__(BandwidthArgs)

            __props__.__dict__["charge_mode"] = charge_mode
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["bandwidth_type"] = None
            __props__.__dict__["publicips"] = None
            __props__.__dict__["share_type"] = None
            __props__.__dict__["status"] = None
        super(Bandwidth, __self__).__init__(
            'huaweicloud:Vpc/bandwidth:Bandwidth',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth_type: Optional[pulumi.Input[str]] = None,
            charge_mode: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            publicips: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BandwidthPublicipArgs']]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            share_type: Optional[pulumi.Input[str]] = None,
            size: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'Bandwidth':
        """
        Get an existing Bandwidth resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bandwidth_type: Indicates the bandwidth type.
        :param pulumi.Input[str] charge_mode: Specifies whether the billing is based on bandwidth or
               95th percentile bandwidth (enhanced). Possible values can be **bandwidth** and **95peak_plus**.
               The default value is **bandwidth**, and **95peak_plus** is only valid for v4 and v5 Customer.
               Changing this creates a new bandwidth.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the Shared Bandwidth.
               Changing this creates a new bandwidth.
        :param pulumi.Input[str] name: Specifies the bandwidth name. The value is a string of 1 to 64 characters that
               can contain letters, digits, underscores (_), hyphens (-), and periods (.).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BandwidthPublicipArgs']]]] publicips: An array of EIPs that use the bandwidth. The object includes the following:
        :param pulumi.Input[str] region: Specifies the region in which to create the Shared Bandwidth.
               If omitted, the provider-level region will be used. Changing this creates a new bandwidth.
        :param pulumi.Input[str] share_type: Indicates whether the bandwidth is shared or dedicated.
        :param pulumi.Input[int] size: Specifies the size of the Shared Bandwidth. The value ranges from 5 Mbit/s to 2000 Mbit/s.
        :param pulumi.Input[str] status: Indicates the bandwidth status.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BandwidthState.__new__(_BandwidthState)

        __props__.__dict__["bandwidth_type"] = bandwidth_type
        __props__.__dict__["charge_mode"] = charge_mode
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["name"] = name
        __props__.__dict__["publicips"] = publicips
        __props__.__dict__["region"] = region
        __props__.__dict__["share_type"] = share_type
        __props__.__dict__["size"] = size
        __props__.__dict__["status"] = status
        return Bandwidth(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bandwidthType")
    def bandwidth_type(self) -> pulumi.Output[str]:
        """
        Indicates the bandwidth type.
        """
        return pulumi.get(self, "bandwidth_type")

    @property
    @pulumi.getter(name="chargeMode")
    def charge_mode(self) -> pulumi.Output[str]:
        """
        Specifies whether the billing is based on bandwidth or
        95th percentile bandwidth (enhanced). Possible values can be **bandwidth** and **95peak_plus**.
        The default value is **bandwidth**, and **95peak_plus** is only valid for v4 and v5 Customer.
        Changing this creates a new bandwidth.
        """
        return pulumi.get(self, "charge_mode")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Specifies the enterprise project id of the Shared Bandwidth.
        Changing this creates a new bandwidth.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the bandwidth name. The value is a string of 1 to 64 characters that
        can contain letters, digits, underscores (_), hyphens (-), and periods (.).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def publicips(self) -> pulumi.Output[Sequence['outputs.BandwidthPublicip']]:
        """
        An array of EIPs that use the bandwidth. The object includes the following:
        """
        return pulumi.get(self, "publicips")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the Shared Bandwidth.
        If omitted, the provider-level region will be used. Changing this creates a new bandwidth.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="shareType")
    def share_type(self) -> pulumi.Output[str]:
        """
        Indicates whether the bandwidth is shared or dedicated.
        """
        return pulumi.get(self, "share_type")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[int]:
        """
        Specifies the size of the Shared Bandwidth. The value ranges from 5 Mbit/s to 2000 Mbit/s.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Indicates the bandwidth status.
        """
        return pulumi.get(self, "status")

