# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'BandwidthPublicipArgs',
    'EipBandwidthArgs',
    'EipPublicipArgs',
    'PortAllowedAddressPairArgs',
    'PortExtraDhcpOptionArgs',
    'PortFixedIpArgs',
    'RouteTableRouteArgs',
    'SecgroupRuleArgs',
    'VpcRouteArgs',
]

@pulumi.input_type
class BandwidthPublicipArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ip_version: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: The ID of the EIP or IPv6 port that uses the bandwidth.
        :param pulumi.Input[str] ip_address: The IPv4 or IPv6 address.
        :param pulumi.Input[int] ip_version: The IP version, either 4 or 6.
        :param pulumi.Input[str] type: The EIP type. Possible values are *5_bgp* (dynamic BGP) and *5_sbgp* (static BGP).
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the EIP or IPv6 port that uses the bandwidth.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 or IPv6 address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[int]]:
        """
        The IP version, either 4 or 6.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The EIP type. Possible values are *5_bgp* (dynamic BGP) and *5_sbgp* (static BGP).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class EipBandwidthArgs:
    def __init__(__self__, *,
                 share_type: pulumi.Input[str],
                 charge_mode: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] share_type: Whether the bandwidth is dedicated or shared. Changing this creates a new
               resource. Possible values are as follows:
               + **PER**: Dedicated bandwidth
               + **WHOLE**: Shared bandwidth
        :param pulumi.Input[str] charge_mode: Specifies whether the bandwidth is billed by traffic or by bandwidth
               size. The value can be *traffic* or *bandwidth*. Changing this creates a new resource.
        :param pulumi.Input[str] id: The shared bandwidth id. This parameter is mandatory when
               `share_type` is set to **WHOLE**. Changing this creates a new resource.
        :param pulumi.Input[str] name: The bandwidth name, which is a string of 1 to 64 characters that contain letters, digits,
               underscores (_), and hyphens (-). This parameter is mandatory when `share_type` is set to **PER**.
        :param pulumi.Input[int] size: The bandwidth size. The value ranges from 1 to 300 Mbit/s. This parameter is mandatory
               when `share_type` is set to **PER**.
        """
        pulumi.set(__self__, "share_type", share_type)
        if charge_mode is not None:
            pulumi.set(__self__, "charge_mode", charge_mode)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter(name="shareType")
    def share_type(self) -> pulumi.Input[str]:
        """
        Whether the bandwidth is dedicated or shared. Changing this creates a new
        resource. Possible values are as follows:
        + **PER**: Dedicated bandwidth
        + **WHOLE**: Shared bandwidth
        """
        return pulumi.get(self, "share_type")

    @share_type.setter
    def share_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "share_type", value)

    @property
    @pulumi.getter(name="chargeMode")
    def charge_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the bandwidth is billed by traffic or by bandwidth
        size. The value can be *traffic* or *bandwidth*. Changing this creates a new resource.
        """
        return pulumi.get(self, "charge_mode")

    @charge_mode.setter
    def charge_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charge_mode", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The shared bandwidth id. This parameter is mandatory when
        `share_type` is set to **WHOLE**. Changing this creates a new resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The bandwidth name, which is a string of 1 to 64 characters that contain letters, digits,
        underscores (_), and hyphens (-). This parameter is mandatory when `share_type` is set to **PER**.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        The bandwidth size. The value ranges from 1 to 300 Mbit/s. This parameter is mandatory
        when `share_type` is set to **PER**.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)


@pulumi.input_type
class EipPublicipArgs:
    def __init__(__self__, *,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ip_version: Optional[pulumi.Input[int]] = None,
                 port_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ip_address: Specifies the EIP to be assigned. The value must be a valid **IPv4**
               address in the available IP address range. The system automatically assigns an EIP if you do not specify it.
               Changing this creates a new resource.
        :param pulumi.Input[int] ip_version: Specifies the IP version, either 4 (default) or 6.
        :param pulumi.Input[str] port_id: The port ID which the EIP associated with.
        :param pulumi.Input[str] type: Specifies the EIP type. Possible values are *5_bgp* (dynamic BGP)
               and *5_sbgp* (static BGP), the default value is *5_bgp*. Changing this creates a new resource.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the EIP to be assigned. The value must be a valid **IPv4**
        address in the available IP address range. The system automatically assigns an EIP if you do not specify it.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the IP version, either 4 (default) or 6.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[pulumi.Input[str]]:
        """
        The port ID which the EIP associated with.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the EIP type. Possible values are *5_bgp* (dynamic BGP)
        and *5_sbgp* (static BGP), the default value is *5_bgp*. Changing this creates a new resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class PortAllowedAddressPairArgs:
    def __init__(__self__, *,
                 ip_address: pulumi.Input[str],
                 mac_address: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "ip_address", ip_address)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac_address", value)


@pulumi.input_type
class PortExtraDhcpOptionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str],
                 ip_version: Optional[pulumi.Input[int]] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ip_version", value)


@pulumi.input_type
class PortFixedIpArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[str],
                 ip_address: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "subnet_id", subnet_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)


@pulumi.input_type
class RouteTableRouteArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input[str],
                 nexthop: pulumi.Input[str],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] destination: - Specifies the destination address in the CIDR notation format,
               for example, 192.168.200.0/24. The destination of each route must be unique and cannot overlap
               with any subnet in the VPC.
        :param pulumi.Input[str] nexthop: - Specifies the next hop.
               + If the route type is **ecs**, the value is an ECS instance ID in the VPC.
               + If the route type is **eni**, the value is the extension NIC of an ECS in the VPC.
               + If the route type is **vip**, the value is a virtual IP address.
               + If the route type is **nat**, the value is a VPN gateway ID.
               + If the route type is **peering**, the value is a VPC peering connection ID.
               + If the route type is **vpn**, the value is a VPN gateway ID.
               + If the route type is **dc**, the value is a Direct Connect gateway ID.
               + If the route type is **cc**, the value is a Cloud Connection ID.
        :param pulumi.Input[str] type: - Specifies the route type. Currently, the value can be:
               **ecs**, **eni**, **vip**, **nat**, **peering**, **vpn**, **dc** and **cc**.
        :param pulumi.Input[str] description: - Specifies the supplementary information about the route.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "nexthop", nexthop)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input[str]:
        """
        - Specifies the destination address in the CIDR notation format,
        for example, 192.168.200.0/24. The destination of each route must be unique and cannot overlap
        with any subnet in the VPC.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def nexthop(self) -> pulumi.Input[str]:
        """
        - Specifies the next hop.
        + If the route type is **ecs**, the value is an ECS instance ID in the VPC.
        + If the route type is **eni**, the value is the extension NIC of an ECS in the VPC.
        + If the route type is **vip**, the value is a virtual IP address.
        + If the route type is **nat**, the value is a VPN gateway ID.
        + If the route type is **peering**, the value is a VPC peering connection ID.
        + If the route type is **vpn**, the value is a VPN gateway ID.
        + If the route type is **dc**, the value is a Direct Connect gateway ID.
        + If the route type is **cc**, the value is a Cloud Connection ID.
        """
        return pulumi.get(self, "nexthop")

    @nexthop.setter
    def nexthop(self, value: pulumi.Input[str]):
        pulumi.set(self, "nexthop", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        - Specifies the route type. Currently, the value can be:
        **ecs**, **eni**, **vip**, **nat**, **peering**, **vpn**, **dc** and **cc**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the supplementary information about the route.
        The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class SecgroupRuleArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 ethertype: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 port_range_max: Optional[pulumi.Input[int]] = None,
                 port_range_min: Optional[pulumi.Input[int]] = None,
                 ports: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 remote_address_group_id: Optional[pulumi.Input[str]] = None,
                 remote_group_id: Optional[pulumi.Input[str]] = None,
                 remote_ip_prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] action: The effective policy.
        :param pulumi.Input[str] description: Specifies the description for the security group.
        :param pulumi.Input[str] direction: The direction of the rule. The value can be *egress* or *ingress*.
        :param pulumi.Input[str] ethertype: The IP protocol version. The value can be *IPv4* or *IPv6*.
        :param pulumi.Input[str] id: The security group rule ID.
        :param pulumi.Input[str] ports: The port value range.
        :param pulumi.Input[int] priority: The priority number.
        :param pulumi.Input[str] protocol: The protocol type.
        :param pulumi.Input[str] remote_address_group_id: The ID of the remote address group.
        :param pulumi.Input[str] remote_group_id: The ID of the peer security group.
        :param pulumi.Input[str] remote_ip_prefix: The remote IP address. The value can be in the CIDR format or IP addresses.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if ethertype is not None:
            pulumi.set(__self__, "ethertype", ethertype)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if port_range_max is not None:
            pulumi.set(__self__, "port_range_max", port_range_max)
        if port_range_min is not None:
            pulumi.set(__self__, "port_range_min", port_range_min)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if remote_address_group_id is not None:
            pulumi.set(__self__, "remote_address_group_id", remote_address_group_id)
        if remote_group_id is not None:
            pulumi.set(__self__, "remote_group_id", remote_group_id)
        if remote_ip_prefix is not None:
            pulumi.set(__self__, "remote_ip_prefix", remote_ip_prefix)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The effective policy.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description for the security group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[str]]:
        """
        The direction of the rule. The value can be *egress* or *ingress*.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def ethertype(self) -> Optional[pulumi.Input[str]]:
        """
        The IP protocol version. The value can be *IPv4* or *IPv6*.
        """
        return pulumi.get(self, "ethertype")

    @ethertype.setter
    def ethertype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ethertype", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The security group rule ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="portRangeMax")
    def port_range_max(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "port_range_max")

    @port_range_max.setter
    def port_range_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port_range_max", value)

    @property
    @pulumi.getter(name="portRangeMin")
    def port_range_min(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "port_range_min")

    @port_range_min.setter
    def port_range_min(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port_range_min", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[str]]:
        """
        The port value range.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority number.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol type.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="remoteAddressGroupId")
    def remote_address_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the remote address group.
        """
        return pulumi.get(self, "remote_address_group_id")

    @remote_address_group_id.setter
    def remote_address_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_address_group_id", value)

    @property
    @pulumi.getter(name="remoteGroupId")
    def remote_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the peer security group.
        """
        return pulumi.get(self, "remote_group_id")

    @remote_group_id.setter
    def remote_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_group_id", value)

    @property
    @pulumi.getter(name="remoteIpPrefix")
    def remote_ip_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The remote IP address. The value can be in the CIDR format or IP addresses.
        """
        return pulumi.get(self, "remote_ip_prefix")

    @remote_ip_prefix.setter
    def remote_ip_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_ip_prefix", value)


@pulumi.input_type
class VpcRouteArgs:
    def __init__(__self__, *,
                 destination: Optional[pulumi.Input[str]] = None,
                 nexthop: Optional[pulumi.Input[str]] = None):
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if nexthop is not None:
            pulumi.set(__self__, "nexthop", nexthop)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def nexthop(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "nexthop")

    @nexthop.setter
    def nexthop(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nexthop", value)


