# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TranscodingTemplateGroupArgs', 'TranscodingTemplateGroup']

@pulumi.input_type
class TranscodingTemplateGroupArgs:
    def __init__(__self__, *,
                 quality_infos: pulumi.Input[Sequence[pulumi.Input['TranscodingTemplateGroupQualityInfoArgs']]],
                 audio_codec: Optional[pulumi.Input[str]] = None,
                 auto_encrypt: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hls_segment_duration: Optional[pulumi.Input[int]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 low_bitrate_hd: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 video_codec: Optional[pulumi.Input[str]] = None,
                 watermark_template_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a TranscodingTemplateGroup resource.
        :param pulumi.Input[Sequence[pulumi.Input['TranscodingTemplateGroupQualityInfoArgs']]] quality_infos: Specifies the quality info list of the template group.
               The object structure is documented below.
        :param pulumi.Input[str] audio_codec: Specifies the audio codec. The value can be: **AAC** and **HEAAC1**.
               Defaults to: **AAC**.
        :param pulumi.Input[bool] auto_encrypt: Specifies whether to automatically encrypt. Before enabling, you need to configure
               the HLS encryption key URL. When `auto_encrypt` is **true**, the `output_format` must be **HLS**.
               Defaults to: **false**.
        :param pulumi.Input[str] description: Specifies the description of the template group.
        :param pulumi.Input[int] hls_segment_duration: Specifies the HLS segment duration. The value can be: **2**, **3**, **5**
               and **10**. Defaults to: **5**. This parameter is used only when `output_format` is set to **HLS** or **DASH_HLS**.
        :param pulumi.Input[bool] is_default: Specifies whether to use this group as default group. Defaults to: **false**.
        :param pulumi.Input[bool] low_bitrate_hd: Specifies whether to enable low bitrate HD. Defaults to: **false**.
        :param pulumi.Input[str] name: Specifies the name of the template group. The value can be a string of 1 to 128
               characters that can consist of letters, digits and underscores (_).
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] video_codec: Specifies the video codec. The value can be: **H264** and **H265**.
               Defaults to: **H264**.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] watermark_template_ids: Specifies the list of the watermark template IDs.
        """
        pulumi.set(__self__, "quality_infos", quality_infos)
        if audio_codec is not None:
            pulumi.set(__self__, "audio_codec", audio_codec)
        if auto_encrypt is not None:
            pulumi.set(__self__, "auto_encrypt", auto_encrypt)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hls_segment_duration is not None:
            pulumi.set(__self__, "hls_segment_duration", hls_segment_duration)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if low_bitrate_hd is not None:
            pulumi.set(__self__, "low_bitrate_hd", low_bitrate_hd)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if video_codec is not None:
            pulumi.set(__self__, "video_codec", video_codec)
        if watermark_template_ids is not None:
            pulumi.set(__self__, "watermark_template_ids", watermark_template_ids)

    @property
    @pulumi.getter(name="qualityInfos")
    def quality_infos(self) -> pulumi.Input[Sequence[pulumi.Input['TranscodingTemplateGroupQualityInfoArgs']]]:
        """
        Specifies the quality info list of the template group.
        The object structure is documented below.
        """
        return pulumi.get(self, "quality_infos")

    @quality_infos.setter
    def quality_infos(self, value: pulumi.Input[Sequence[pulumi.Input['TranscodingTemplateGroupQualityInfoArgs']]]):
        pulumi.set(self, "quality_infos", value)

    @property
    @pulumi.getter(name="audioCodec")
    def audio_codec(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the audio codec. The value can be: **AAC** and **HEAAC1**.
        Defaults to: **AAC**.
        """
        return pulumi.get(self, "audio_codec")

    @audio_codec.setter
    def audio_codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audio_codec", value)

    @property
    @pulumi.getter(name="autoEncrypt")
    def auto_encrypt(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to automatically encrypt. Before enabling, you need to configure
        the HLS encryption key URL. When `auto_encrypt` is **true**, the `output_format` must be **HLS**.
        Defaults to: **false**.
        """
        return pulumi.get(self, "auto_encrypt")

    @auto_encrypt.setter
    def auto_encrypt(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_encrypt", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the template group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="hlsSegmentDuration")
    def hls_segment_duration(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the HLS segment duration. The value can be: **2**, **3**, **5**
        and **10**. Defaults to: **5**. This parameter is used only when `output_format` is set to **HLS** or **DASH_HLS**.
        """
        return pulumi.get(self, "hls_segment_duration")

    @hls_segment_duration.setter
    def hls_segment_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hls_segment_duration", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use this group as default group. Defaults to: **false**.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter(name="lowBitrateHd")
    def low_bitrate_hd(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable low bitrate HD. Defaults to: **false**.
        """
        return pulumi.get(self, "low_bitrate_hd")

    @low_bitrate_hd.setter
    def low_bitrate_hd(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "low_bitrate_hd", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the template group. The value can be a string of 1 to 128
        characters that can consist of letters, digits and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="videoCodec")
    def video_codec(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the video codec. The value can be: **H264** and **H265**.
        Defaults to: **H264**.
        """
        return pulumi.get(self, "video_codec")

    @video_codec.setter
    def video_codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "video_codec", value)

    @property
    @pulumi.getter(name="watermarkTemplateIds")
    def watermark_template_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the list of the watermark template IDs.
        """
        return pulumi.get(self, "watermark_template_ids")

    @watermark_template_ids.setter
    def watermark_template_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "watermark_template_ids", value)


@pulumi.input_type
class _TranscodingTemplateGroupState:
    def __init__(__self__, *,
                 audio_codec: Optional[pulumi.Input[str]] = None,
                 auto_encrypt: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hls_segment_duration: Optional[pulumi.Input[int]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 low_bitrate_hd: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 quality_infos: Optional[pulumi.Input[Sequence[pulumi.Input['TranscodingTemplateGroupQualityInfoArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 video_codec: Optional[pulumi.Input[str]] = None,
                 watermark_template_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering TranscodingTemplateGroup resources.
        :param pulumi.Input[str] audio_codec: Specifies the audio codec. The value can be: **AAC** and **HEAAC1**.
               Defaults to: **AAC**.
        :param pulumi.Input[bool] auto_encrypt: Specifies whether to automatically encrypt. Before enabling, you need to configure
               the HLS encryption key URL. When `auto_encrypt` is **true**, the `output_format` must be **HLS**.
               Defaults to: **false**.
        :param pulumi.Input[str] description: Specifies the description of the template group.
        :param pulumi.Input[int] hls_segment_duration: Specifies the HLS segment duration. The value can be: **2**, **3**, **5**
               and **10**. Defaults to: **5**. This parameter is used only when `output_format` is set to **HLS** or **DASH_HLS**.
        :param pulumi.Input[bool] is_default: Specifies whether to use this group as default group. Defaults to: **false**.
        :param pulumi.Input[bool] low_bitrate_hd: Specifies whether to enable low bitrate HD. Defaults to: **false**.
        :param pulumi.Input[str] name: Specifies the name of the template group. The value can be a string of 1 to 128
               characters that can consist of letters, digits and underscores (_).
        :param pulumi.Input[Sequence[pulumi.Input['TranscodingTemplateGroupQualityInfoArgs']]] quality_infos: Specifies the quality info list of the template group.
               The object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] type: Indicates the type of the template group.
        :param pulumi.Input[str] video_codec: Specifies the video codec. The value can be: **H264** and **H265**.
               Defaults to: **H264**.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] watermark_template_ids: Specifies the list of the watermark template IDs.
        """
        if audio_codec is not None:
            pulumi.set(__self__, "audio_codec", audio_codec)
        if auto_encrypt is not None:
            pulumi.set(__self__, "auto_encrypt", auto_encrypt)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hls_segment_duration is not None:
            pulumi.set(__self__, "hls_segment_duration", hls_segment_duration)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if low_bitrate_hd is not None:
            pulumi.set(__self__, "low_bitrate_hd", low_bitrate_hd)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if quality_infos is not None:
            pulumi.set(__self__, "quality_infos", quality_infos)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if video_codec is not None:
            pulumi.set(__self__, "video_codec", video_codec)
        if watermark_template_ids is not None:
            pulumi.set(__self__, "watermark_template_ids", watermark_template_ids)

    @property
    @pulumi.getter(name="audioCodec")
    def audio_codec(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the audio codec. The value can be: **AAC** and **HEAAC1**.
        Defaults to: **AAC**.
        """
        return pulumi.get(self, "audio_codec")

    @audio_codec.setter
    def audio_codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audio_codec", value)

    @property
    @pulumi.getter(name="autoEncrypt")
    def auto_encrypt(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to automatically encrypt. Before enabling, you need to configure
        the HLS encryption key URL. When `auto_encrypt` is **true**, the `output_format` must be **HLS**.
        Defaults to: **false**.
        """
        return pulumi.get(self, "auto_encrypt")

    @auto_encrypt.setter
    def auto_encrypt(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_encrypt", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the template group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="hlsSegmentDuration")
    def hls_segment_duration(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the HLS segment duration. The value can be: **2**, **3**, **5**
        and **10**. Defaults to: **5**. This parameter is used only when `output_format` is set to **HLS** or **DASH_HLS**.
        """
        return pulumi.get(self, "hls_segment_duration")

    @hls_segment_duration.setter
    def hls_segment_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hls_segment_duration", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use this group as default group. Defaults to: **false**.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter(name="lowBitrateHd")
    def low_bitrate_hd(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable low bitrate HD. Defaults to: **false**.
        """
        return pulumi.get(self, "low_bitrate_hd")

    @low_bitrate_hd.setter
    def low_bitrate_hd(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "low_bitrate_hd", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the template group. The value can be a string of 1 to 128
        characters that can consist of letters, digits and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="qualityInfos")
    def quality_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TranscodingTemplateGroupQualityInfoArgs']]]]:
        """
        Specifies the quality info list of the template group.
        The object structure is documented below.
        """
        return pulumi.get(self, "quality_infos")

    @quality_infos.setter
    def quality_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TranscodingTemplateGroupQualityInfoArgs']]]]):
        pulumi.set(self, "quality_infos", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the type of the template group.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="videoCodec")
    def video_codec(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the video codec. The value can be: **H264** and **H265**.
        Defaults to: **H264**.
        """
        return pulumi.get(self, "video_codec")

    @video_codec.setter
    def video_codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "video_codec", value)

    @property
    @pulumi.getter(name="watermarkTemplateIds")
    def watermark_template_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the list of the watermark template IDs.
        """
        return pulumi.get(self, "watermark_template_ids")

    @watermark_template_ids.setter
    def watermark_template_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "watermark_template_ids", value)


class TranscodingTemplateGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audio_codec: Optional[pulumi.Input[str]] = None,
                 auto_encrypt: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hls_segment_duration: Optional[pulumi.Input[int]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 low_bitrate_hd: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 quality_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TranscodingTemplateGroupQualityInfoArgs']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 video_codec: Optional[pulumi.Input[str]] = None,
                 watermark_template_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages a VOD transcoding template group resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test = huaweicloud.vod.TranscodingTemplateGroup("test",
            audio_codec="AAC",
            description="test group",
            hls_segment_duration=5,
            low_bitrate_hd=False,
            quality_infos=[huaweicloud.vod.TranscodingTemplateGroupQualityInfoArgs(
                audio=huaweicloud.vod.TranscodingTemplateGroupQualityInfoAudioArgs(
                    bitrate=0,
                    channels=2,
                    sample_rate=1,
                ),
                output_format="HLS",
                video=huaweicloud.vod.TranscodingTemplateGroupQualityInfoVideoArgs(
                    bitrate=1000,
                    frame_rate=1,
                    height=720,
                    quality="HD",
                    width=1280,
                ),
            )],
            video_codec="H264")
        ```

        ## Import

        VOD transcoding template groups can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vod/transcodingTemplateGroup:TranscodingTemplateGroup test 589e49809bb84447a759f6fa9aa19949
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] audio_codec: Specifies the audio codec. The value can be: **AAC** and **HEAAC1**.
               Defaults to: **AAC**.
        :param pulumi.Input[bool] auto_encrypt: Specifies whether to automatically encrypt. Before enabling, you need to configure
               the HLS encryption key URL. When `auto_encrypt` is **true**, the `output_format` must be **HLS**.
               Defaults to: **false**.
        :param pulumi.Input[str] description: Specifies the description of the template group.
        :param pulumi.Input[int] hls_segment_duration: Specifies the HLS segment duration. The value can be: **2**, **3**, **5**
               and **10**. Defaults to: **5**. This parameter is used only when `output_format` is set to **HLS** or **DASH_HLS**.
        :param pulumi.Input[bool] is_default: Specifies whether to use this group as default group. Defaults to: **false**.
        :param pulumi.Input[bool] low_bitrate_hd: Specifies whether to enable low bitrate HD. Defaults to: **false**.
        :param pulumi.Input[str] name: Specifies the name of the template group. The value can be a string of 1 to 128
               characters that can consist of letters, digits and underscores (_).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TranscodingTemplateGroupQualityInfoArgs']]]] quality_infos: Specifies the quality info list of the template group.
               The object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] video_codec: Specifies the video codec. The value can be: **H264** and **H265**.
               Defaults to: **H264**.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] watermark_template_ids: Specifies the list of the watermark template IDs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TranscodingTemplateGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VOD transcoding template group resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test = huaweicloud.vod.TranscodingTemplateGroup("test",
            audio_codec="AAC",
            description="test group",
            hls_segment_duration=5,
            low_bitrate_hd=False,
            quality_infos=[huaweicloud.vod.TranscodingTemplateGroupQualityInfoArgs(
                audio=huaweicloud.vod.TranscodingTemplateGroupQualityInfoAudioArgs(
                    bitrate=0,
                    channels=2,
                    sample_rate=1,
                ),
                output_format="HLS",
                video=huaweicloud.vod.TranscodingTemplateGroupQualityInfoVideoArgs(
                    bitrate=1000,
                    frame_rate=1,
                    height=720,
                    quality="HD",
                    width=1280,
                ),
            )],
            video_codec="H264")
        ```

        ## Import

        VOD transcoding template groups can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vod/transcodingTemplateGroup:TranscodingTemplateGroup test 589e49809bb84447a759f6fa9aa19949
        ```

        :param str resource_name: The name of the resource.
        :param TranscodingTemplateGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TranscodingTemplateGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audio_codec: Optional[pulumi.Input[str]] = None,
                 auto_encrypt: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hls_segment_duration: Optional[pulumi.Input[int]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 low_bitrate_hd: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 quality_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TranscodingTemplateGroupQualityInfoArgs']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 video_codec: Optional[pulumi.Input[str]] = None,
                 watermark_template_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TranscodingTemplateGroupArgs.__new__(TranscodingTemplateGroupArgs)

            __props__.__dict__["audio_codec"] = audio_codec
            __props__.__dict__["auto_encrypt"] = auto_encrypt
            __props__.__dict__["description"] = description
            __props__.__dict__["hls_segment_duration"] = hls_segment_duration
            __props__.__dict__["is_default"] = is_default
            __props__.__dict__["low_bitrate_hd"] = low_bitrate_hd
            __props__.__dict__["name"] = name
            if quality_infos is None and not opts.urn:
                raise TypeError("Missing required property 'quality_infos'")
            __props__.__dict__["quality_infos"] = quality_infos
            __props__.__dict__["region"] = region
            __props__.__dict__["video_codec"] = video_codec
            __props__.__dict__["watermark_template_ids"] = watermark_template_ids
            __props__.__dict__["type"] = None
        super(TranscodingTemplateGroup, __self__).__init__(
            'huaweicloud:Vod/transcodingTemplateGroup:TranscodingTemplateGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audio_codec: Optional[pulumi.Input[str]] = None,
            auto_encrypt: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            hls_segment_duration: Optional[pulumi.Input[int]] = None,
            is_default: Optional[pulumi.Input[bool]] = None,
            low_bitrate_hd: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            quality_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TranscodingTemplateGroupQualityInfoArgs']]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            video_codec: Optional[pulumi.Input[str]] = None,
            watermark_template_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'TranscodingTemplateGroup':
        """
        Get an existing TranscodingTemplateGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] audio_codec: Specifies the audio codec. The value can be: **AAC** and **HEAAC1**.
               Defaults to: **AAC**.
        :param pulumi.Input[bool] auto_encrypt: Specifies whether to automatically encrypt. Before enabling, you need to configure
               the HLS encryption key URL. When `auto_encrypt` is **true**, the `output_format` must be **HLS**.
               Defaults to: **false**.
        :param pulumi.Input[str] description: Specifies the description of the template group.
        :param pulumi.Input[int] hls_segment_duration: Specifies the HLS segment duration. The value can be: **2**, **3**, **5**
               and **10**. Defaults to: **5**. This parameter is used only when `output_format` is set to **HLS** or **DASH_HLS**.
        :param pulumi.Input[bool] is_default: Specifies whether to use this group as default group. Defaults to: **false**.
        :param pulumi.Input[bool] low_bitrate_hd: Specifies whether to enable low bitrate HD. Defaults to: **false**.
        :param pulumi.Input[str] name: Specifies the name of the template group. The value can be a string of 1 to 128
               characters that can consist of letters, digits and underscores (_).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TranscodingTemplateGroupQualityInfoArgs']]]] quality_infos: Specifies the quality info list of the template group.
               The object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] type: Indicates the type of the template group.
        :param pulumi.Input[str] video_codec: Specifies the video codec. The value can be: **H264** and **H265**.
               Defaults to: **H264**.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] watermark_template_ids: Specifies the list of the watermark template IDs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TranscodingTemplateGroupState.__new__(_TranscodingTemplateGroupState)

        __props__.__dict__["audio_codec"] = audio_codec
        __props__.__dict__["auto_encrypt"] = auto_encrypt
        __props__.__dict__["description"] = description
        __props__.__dict__["hls_segment_duration"] = hls_segment_duration
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["low_bitrate_hd"] = low_bitrate_hd
        __props__.__dict__["name"] = name
        __props__.__dict__["quality_infos"] = quality_infos
        __props__.__dict__["region"] = region
        __props__.__dict__["type"] = type
        __props__.__dict__["video_codec"] = video_codec
        __props__.__dict__["watermark_template_ids"] = watermark_template_ids
        return TranscodingTemplateGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="audioCodec")
    def audio_codec(self) -> pulumi.Output[str]:
        """
        Specifies the audio codec. The value can be: **AAC** and **HEAAC1**.
        Defaults to: **AAC**.
        """
        return pulumi.get(self, "audio_codec")

    @property
    @pulumi.getter(name="autoEncrypt")
    def auto_encrypt(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to automatically encrypt. Before enabling, you need to configure
        the HLS encryption key URL. When `auto_encrypt` is **true**, the `output_format` must be **HLS**.
        Defaults to: **false**.
        """
        return pulumi.get(self, "auto_encrypt")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of the template group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="hlsSegmentDuration")
    def hls_segment_duration(self) -> pulumi.Output[int]:
        """
        Specifies the HLS segment duration. The value can be: **2**, **3**, **5**
        and **10**. Defaults to: **5**. This parameter is used only when `output_format` is set to **HLS** or **DASH_HLS**.
        """
        return pulumi.get(self, "hls_segment_duration")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to use this group as default group. Defaults to: **false**.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="lowBitrateHd")
    def low_bitrate_hd(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable low bitrate HD. Defaults to: **false**.
        """
        return pulumi.get(self, "low_bitrate_hd")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the template group. The value can be a string of 1 to 128
        characters that can consist of letters, digits and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="qualityInfos")
    def quality_infos(self) -> pulumi.Output[Sequence['outputs.TranscodingTemplateGroupQualityInfo']]:
        """
        Specifies the quality info list of the template group.
        The object structure is documented below.
        """
        return pulumi.get(self, "quality_infos")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Indicates the type of the template group.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="videoCodec")
    def video_codec(self) -> pulumi.Output[str]:
        """
        Specifies the video codec. The value can be: **H264** and **H265**.
        Defaults to: **H264**.
        """
        return pulumi.get(self, "video_codec")

    @property
    @pulumi.getter(name="watermarkTemplateIds")
    def watermark_template_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies the list of the watermark template IDs.
        """
        return pulumi.get(self, "watermark_template_ids")

