# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'MediaAssetThumbnailArgs',
    'TranscodingTemplateGroupQualityInfoArgs',
    'TranscodingTemplateGroupQualityInfoAudioArgs',
    'TranscodingTemplateGroupQualityInfoVideoArgs',
]

@pulumi.input_type
class MediaAssetThumbnailArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 aspect_ratio: Optional[pulumi.Input[int]] = None,
                 cover_position: Optional[pulumi.Input[int]] = None,
                 dots: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 format: Optional[pulumi.Input[int]] = None,
                 max_length: Optional[pulumi.Input[int]] = None,
                 time: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] type: Specifies the screenshot type. Valid values are: **time** and **dots**.
               Changing this creates a new resource.
        :param pulumi.Input[int] aspect_ratio: Specifies the screenshot aspect ratio. The value can be:
               + **0**: adaptive (maintain the original aspect ratio).
               + **1**: 16:9.
        :param pulumi.Input[int] cover_position: Specifies the number of screenshots as the cover. Defaults to: **1**.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] dots: Specifies an array of time points of screenshot. Required when `type` is **dots**.
               Changing this creates a new resource.
        :param pulumi.Input[int] format: Specifies the screenshot file format. Currently, only **1** (jpg) is supported.
               Defaults to: **1**. Changing this creates a new resource.
        :param pulumi.Input[int] max_length: Specifies the size of the longest side of the screenshot. Unit: pixel.
               The width dimension is calculated by scaling the dimension proportional to the original video pixels.
               Changing this creates a new resource.
        :param pulumi.Input[int] time: Specifies the screenshot time interval (unit: second). The value range is 1 to 12.
               Required when `type` is **time**. Changing this creates a new resource.
        """
        pulumi.set(__self__, "type", type)
        if aspect_ratio is not None:
            pulumi.set(__self__, "aspect_ratio", aspect_ratio)
        if cover_position is not None:
            pulumi.set(__self__, "cover_position", cover_position)
        if dots is not None:
            pulumi.set(__self__, "dots", dots)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the screenshot type. Valid values are: **time** and **dots**.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="aspectRatio")
    def aspect_ratio(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the screenshot aspect ratio. The value can be:
        + **0**: adaptive (maintain the original aspect ratio).
        + **1**: 16:9.
        """
        return pulumi.get(self, "aspect_ratio")

    @aspect_ratio.setter
    def aspect_ratio(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "aspect_ratio", value)

    @property
    @pulumi.getter(name="coverPosition")
    def cover_position(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of screenshots as the cover. Defaults to: **1**.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "cover_position")

    @cover_position.setter
    def cover_position(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cover_position", value)

    @property
    @pulumi.getter
    def dots(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Specifies an array of time points of screenshot. Required when `type` is **dots**.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "dots")

    @dots.setter
    def dots(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "dots", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the screenshot file format. Currently, only **1** (jpg) is supported.
        Defaults to: **1**. Changing this creates a new resource.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the size of the longest side of the screenshot. Unit: pixel.
        The width dimension is calculated by scaling the dimension proportional to the original video pixels.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "max_length")

    @max_length.setter
    def max_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_length", value)

    @property
    @pulumi.getter
    def time(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the screenshot time interval (unit: second). The value range is 1 to 12.
        Required when `type` is **time**. Changing this creates a new resource.
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "time", value)


@pulumi.input_type
class TranscodingTemplateGroupQualityInfoArgs:
    def __init__(__self__, *,
                 output_format: pulumi.Input[str],
                 audio: Optional[pulumi.Input['TranscodingTemplateGroupQualityInfoAudioArgs']] = None,
                 video: Optional[pulumi.Input['TranscodingTemplateGroupQualityInfoVideoArgs']] = None):
        """
        :param pulumi.Input[str] output_format: Specifies the output format. The value can be: **HLS**, **MP4**, **DASH**,
               **DASH_HLS**, **MP3** and **ADTS**.
        :param pulumi.Input['TranscodingTemplateGroupQualityInfoAudioArgs'] audio: Specifies the audio configurations.
               The object structure is documented below.
        :param pulumi.Input['TranscodingTemplateGroupQualityInfoVideoArgs'] video: Specifies the video configurations.
               The object structure is documented below.
        """
        pulumi.set(__self__, "output_format", output_format)
        if audio is not None:
            pulumi.set(__self__, "audio", audio)
        if video is not None:
            pulumi.set(__self__, "video", video)

    @property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> pulumi.Input[str]:
        """
        Specifies the output format. The value can be: **HLS**, **MP4**, **DASH**,
        **DASH_HLS**, **MP3** and **ADTS**.
        """
        return pulumi.get(self, "output_format")

    @output_format.setter
    def output_format(self, value: pulumi.Input[str]):
        pulumi.set(self, "output_format", value)

    @property
    @pulumi.getter
    def audio(self) -> Optional[pulumi.Input['TranscodingTemplateGroupQualityInfoAudioArgs']]:
        """
        Specifies the audio configurations.
        The object structure is documented below.
        """
        return pulumi.get(self, "audio")

    @audio.setter
    def audio(self, value: Optional[pulumi.Input['TranscodingTemplateGroupQualityInfoAudioArgs']]):
        pulumi.set(self, "audio", value)

    @property
    @pulumi.getter
    def video(self) -> Optional[pulumi.Input['TranscodingTemplateGroupQualityInfoVideoArgs']]:
        """
        Specifies the video configurations.
        The object structure is documented below.
        """
        return pulumi.get(self, "video")

    @video.setter
    def video(self, value: Optional[pulumi.Input['TranscodingTemplateGroupQualityInfoVideoArgs']]):
        pulumi.set(self, "video", value)


@pulumi.input_type
class TranscodingTemplateGroupQualityInfoAudioArgs:
    def __init__(__self__, *,
                 channels: pulumi.Input[int],
                 sample_rate: pulumi.Input[int],
                 bitrate: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] channels: Specifies the audio channels. The value can be:
               + **1**: Mono
               + **2**: Stereo
        :param pulumi.Input[int] sample_rate: Specifies the audio sample rate. The value can be:
               + **1**: AUTO
               + **2**: 22,050 Hz
               + **3**: 32,000 Hz
               + **4**: 44,100 Hz
               + **5**: 48,000 Hz
               + **6**: 96,000 Hz
        :param pulumi.Input[int] bitrate: Specifies the audio bitrate. The value can be **0** or range from
               **8** to **1000**. Defaults to: **0**. If set to **0**, the output audio will be produced at the recommended bitrate.
        """
        pulumi.set(__self__, "channels", channels)
        pulumi.set(__self__, "sample_rate", sample_rate)
        if bitrate is not None:
            pulumi.set(__self__, "bitrate", bitrate)

    @property
    @pulumi.getter
    def channels(self) -> pulumi.Input[int]:
        """
        Specifies the audio channels. The value can be:
        + **1**: Mono
        + **2**: Stereo
        """
        return pulumi.get(self, "channels")

    @channels.setter
    def channels(self, value: pulumi.Input[int]):
        pulumi.set(self, "channels", value)

    @property
    @pulumi.getter(name="sampleRate")
    def sample_rate(self) -> pulumi.Input[int]:
        """
        Specifies the audio sample rate. The value can be:
        + **1**: AUTO
        + **2**: 22,050 Hz
        + **3**: 32,000 Hz
        + **4**: 44,100 Hz
        + **5**: 48,000 Hz
        + **6**: 96,000 Hz
        """
        return pulumi.get(self, "sample_rate")

    @sample_rate.setter
    def sample_rate(self, value: pulumi.Input[int]):
        pulumi.set(self, "sample_rate", value)

    @property
    @pulumi.getter
    def bitrate(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the audio bitrate. The value can be **0** or range from
        **8** to **1000**. Defaults to: **0**. If set to **0**, the output audio will be produced at the recommended bitrate.
        """
        return pulumi.get(self, "bitrate")

    @bitrate.setter
    def bitrate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bitrate", value)


@pulumi.input_type
class TranscodingTemplateGroupQualityInfoVideoArgs:
    def __init__(__self__, *,
                 quality: pulumi.Input[str],
                 bitrate: Optional[pulumi.Input[int]] = None,
                 frame_rate: Optional[pulumi.Input[int]] = None,
                 height: Optional[pulumi.Input[int]] = None,
                 width: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] quality: Specifies the video quality.
               The value can be: **4K**, **2K**, **FHD**, **SD**, **LD** and **HD**.
        :param pulumi.Input[int] bitrate: Specifies the audio bitrate. The value can be **0** or range from
               **8** to **1000**. Defaults to: **0**. If set to **0**, the output audio will be produced at the recommended bitrate.
        :param pulumi.Input[int] frame_rate: Specifies the video frame rate. The value ranges from **1** to **75**.
               Defaults to: **1**. If set to **1**, the frame rate of the transcoded video is the same as that of the
               untransocded video.
        :param pulumi.Input[int] height: Specifies the video height. The value can be **0** or range from **128** to **2160**.
               Defaults to: **0**. If set to **0**, the system will automatically adjust the `height` according to the `width`.
        :param pulumi.Input[int] width: Specifies the video width. The value can be **0** or range from **128** to **3840**.
               Defaults to: **0**. If set to **0**, the system will automatically adjust the `width` according to the `height`.
        """
        pulumi.set(__self__, "quality", quality)
        if bitrate is not None:
            pulumi.set(__self__, "bitrate", bitrate)
        if frame_rate is not None:
            pulumi.set(__self__, "frame_rate", frame_rate)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def quality(self) -> pulumi.Input[str]:
        """
        Specifies the video quality.
        The value can be: **4K**, **2K**, **FHD**, **SD**, **LD** and **HD**.
        """
        return pulumi.get(self, "quality")

    @quality.setter
    def quality(self, value: pulumi.Input[str]):
        pulumi.set(self, "quality", value)

    @property
    @pulumi.getter
    def bitrate(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the audio bitrate. The value can be **0** or range from
        **8** to **1000**. Defaults to: **0**. If set to **0**, the output audio will be produced at the recommended bitrate.
        """
        return pulumi.get(self, "bitrate")

    @bitrate.setter
    def bitrate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bitrate", value)

    @property
    @pulumi.getter(name="frameRate")
    def frame_rate(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the video frame rate. The value ranges from **1** to **75**.
        Defaults to: **1**. If set to **1**, the frame rate of the transcoded video is the same as that of the
        untransocded video.
        """
        return pulumi.get(self, "frame_rate")

    @frame_rate.setter
    def frame_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "frame_rate", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the video height. The value can be **0** or range from **128** to **2160**.
        Defaults to: **0**. If set to **0**, the system will automatically adjust the `height` according to the `width`.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the video width. The value can be **0** or range from **128** to **3840**.
        Defaults to: **0**. If set to **0**, the system will automatically adjust the `width` according to the `height`.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "width", value)


