# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['RepositoryArgs', 'Repository']

@pulumi.input_type
class RepositoryArgs:
    def __init__(__self__, *,
                 organization: pulumi.Input[str],
                 category: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_public: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Repository resource.
        :param pulumi.Input[str] organization: Specifies the name of the organization (namespace) the repository belongs.
               Changing this creates a new resource.
        :param pulumi.Input[str] category: Specifies the category of the repository.
               The value can be `app_server`, `linux`, `framework_app`, `database`, `lang`, `other`, `windows`, `arm`.
        :param pulumi.Input[str] description: Specifies the description of the repository.
        :param pulumi.Input[bool] is_public: Specifies whether the repository is public. Default is false.
        :param pulumi.Input[str] name: Specifies the name of the repository. Changing this creates a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        pulumi.set(__self__, "organization", organization)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_public is not None:
            pulumi.set(__self__, "is_public", is_public)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Input[str]:
        """
        Specifies the name of the organization (namespace) the repository belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the category of the repository.
        The value can be `app_server`, `linux`, `framework_app`, `database`, `lang`, `other`, `windows`, `arm`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the repository.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the repository is public. Default is false.
        """
        return pulumi.get(self, "is_public")

    @is_public.setter
    def is_public(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_public", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the repository. Changing this creates a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _RepositoryState:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 internal_path: Optional[pulumi.Input[str]] = None,
                 is_public: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 num_images: Optional[pulumi.Input[int]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 repository_id: Optional[pulumi.Input[int]] = None,
                 size: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Repository resources.
        :param pulumi.Input[str] category: Specifies the category of the repository.
               The value can be `app_server`, `linux`, `framework_app`, `database`, `lang`, `other`, `windows`, `arm`.
        :param pulumi.Input[str] description: Specifies the description of the repository.
        :param pulumi.Input[str] internal_path: Intra-cluster image address for docker pull.
        :param pulumi.Input[bool] is_public: Specifies whether the repository is public. Default is false.
        :param pulumi.Input[str] name: Specifies the name of the repository. Changing this creates a new resource.
        :param pulumi.Input[int] num_images: Number of image tags in a repository.
        :param pulumi.Input[str] organization: Specifies the name of the organization (namespace) the repository belongs.
               Changing this creates a new resource.
        :param pulumi.Input[str] path: Image address for docker pull.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[int] repository_id: Numeric ID of the repository
        :param pulumi.Input[int] size: Repository size.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if internal_path is not None:
            pulumi.set(__self__, "internal_path", internal_path)
        if is_public is not None:
            pulumi.set(__self__, "is_public", is_public)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_images is not None:
            pulumi.set(__self__, "num_images", num_images)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the category of the repository.
        The value can be `app_server`, `linux`, `framework_app`, `database`, `lang`, `other`, `windows`, `arm`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the repository.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="internalPath")
    def internal_path(self) -> Optional[pulumi.Input[str]]:
        """
        Intra-cluster image address for docker pull.
        """
        return pulumi.get(self, "internal_path")

    @internal_path.setter
    def internal_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internal_path", value)

    @property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the repository is public. Default is false.
        """
        return pulumi.get(self, "is_public")

    @is_public.setter
    def is_public(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_public", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the repository. Changing this creates a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numImages")
    def num_images(self) -> Optional[pulumi.Input[int]]:
        """
        Number of image tags in a repository.
        """
        return pulumi.get(self, "num_images")

    @num_images.setter
    def num_images(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_images", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the organization (namespace) the repository belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Image address for docker pull.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[pulumi.Input[int]]:
        """
        Numeric ID of the repository
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "repository_id", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        Repository size.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)


class Repository(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_public: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a SWR repository resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        organization_name = config.require_object("organizationName")
        test = huaweicloud.swr.Repository("test",
            organization=organization_name,
            description="Test repository",
            category="linux")
        ```

        ## Import

        Repository can be imported using the organization name and repository name separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Swr/repository:Repository test org-name/repo-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] category: Specifies the category of the repository.
               The value can be `app_server`, `linux`, `framework_app`, `database`, `lang`, `other`, `windows`, `arm`.
        :param pulumi.Input[str] description: Specifies the description of the repository.
        :param pulumi.Input[bool] is_public: Specifies whether the repository is public. Default is false.
        :param pulumi.Input[str] name: Specifies the name of the repository. Changing this creates a new resource.
        :param pulumi.Input[str] organization: Specifies the name of the organization (namespace) the repository belongs.
               Changing this creates a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RepositoryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a SWR repository resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        organization_name = config.require_object("organizationName")
        test = huaweicloud.swr.Repository("test",
            organization=organization_name,
            description="Test repository",
            category="linux")
        ```

        ## Import

        Repository can be imported using the organization name and repository name separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Swr/repository:Repository test org-name/repo-name
        ```

        :param str resource_name: The name of the resource.
        :param RepositoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepositoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_public: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepositoryArgs.__new__(RepositoryArgs)

            __props__.__dict__["category"] = category
            __props__.__dict__["description"] = description
            __props__.__dict__["is_public"] = is_public
            __props__.__dict__["name"] = name
            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            __props__.__dict__["region"] = region
            __props__.__dict__["internal_path"] = None
            __props__.__dict__["num_images"] = None
            __props__.__dict__["path"] = None
            __props__.__dict__["repository_id"] = None
            __props__.__dict__["size"] = None
        super(Repository, __self__).__init__(
            'huaweicloud:Swr/repository:Repository',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            category: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            internal_path: Optional[pulumi.Input[str]] = None,
            is_public: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            num_images: Optional[pulumi.Input[int]] = None,
            organization: Optional[pulumi.Input[str]] = None,
            path: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            repository_id: Optional[pulumi.Input[int]] = None,
            size: Optional[pulumi.Input[int]] = None) -> 'Repository':
        """
        Get an existing Repository resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] category: Specifies the category of the repository.
               The value can be `app_server`, `linux`, `framework_app`, `database`, `lang`, `other`, `windows`, `arm`.
        :param pulumi.Input[str] description: Specifies the description of the repository.
        :param pulumi.Input[str] internal_path: Intra-cluster image address for docker pull.
        :param pulumi.Input[bool] is_public: Specifies whether the repository is public. Default is false.
        :param pulumi.Input[str] name: Specifies the name of the repository. Changing this creates a new resource.
        :param pulumi.Input[int] num_images: Number of image tags in a repository.
        :param pulumi.Input[str] organization: Specifies the name of the organization (namespace) the repository belongs.
               Changing this creates a new resource.
        :param pulumi.Input[str] path: Image address for docker pull.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[int] repository_id: Numeric ID of the repository
        :param pulumi.Input[int] size: Repository size.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RepositoryState.__new__(_RepositoryState)

        __props__.__dict__["category"] = category
        __props__.__dict__["description"] = description
        __props__.__dict__["internal_path"] = internal_path
        __props__.__dict__["is_public"] = is_public
        __props__.__dict__["name"] = name
        __props__.__dict__["num_images"] = num_images
        __props__.__dict__["organization"] = organization
        __props__.__dict__["path"] = path
        __props__.__dict__["region"] = region
        __props__.__dict__["repository_id"] = repository_id
        __props__.__dict__["size"] = size
        return Repository(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def category(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the category of the repository.
        The value can be `app_server`, `linux`, `framework_app`, `database`, `lang`, `other`, `windows`, `arm`.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of the repository.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="internalPath")
    def internal_path(self) -> pulumi.Output[str]:
        """
        Intra-cluster image address for docker pull.
        """
        return pulumi.get(self, "internal_path")

    @property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the repository is public. Default is false.
        """
        return pulumi.get(self, "is_public")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the repository. Changing this creates a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numImages")
    def num_images(self) -> pulumi.Output[int]:
        """
        Number of image tags in a repository.
        """
        return pulumi.get(self, "num_images")

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Output[str]:
        """
        Specifies the name of the organization (namespace) the repository belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[str]:
        """
        Image address for docker pull.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Output[int]:
        """
        Numeric ID of the repository
        """
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[int]:
        """
        Repository size.
        """
        return pulumi.get(self, "size")

