# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OrganizationPermissionsArgs', 'OrganizationPermissions']

@pulumi.input_type
class OrganizationPermissionsArgs:
    def __init__(__self__, *,
                 organization: pulumi.Input[str],
                 users: pulumi.Input[Sequence[pulumi.Input['OrganizationPermissionsUserArgs']]],
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a OrganizationPermissions resource.
        :param pulumi.Input[str] organization: Specifies the name of the organization (namespace) to be accessed.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['OrganizationPermissionsUserArgs']]] users: Specifies the users to access to the organization (namespace).
               Structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "users", users)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Input[str]:
        """
        Specifies the name of the organization (namespace) to be accessed.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter
    def users(self) -> pulumi.Input[Sequence[pulumi.Input['OrganizationPermissionsUserArgs']]]:
        """
        Specifies the users to access to the organization (namespace).
        Structure is documented below.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: pulumi.Input[Sequence[pulumi.Input['OrganizationPermissionsUserArgs']]]):
        pulumi.set(self, "users", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _OrganizationPermissionsState:
    def __init__(__self__, *,
                 creator: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 self_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationPermissionsSelfPermissionArgs']]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationPermissionsUserArgs']]]] = None):
        """
        Input properties used for looking up and filtering OrganizationPermissions resources.
        :param pulumi.Input[str] creator: The creator user name of the organization.
        :param pulumi.Input[str] organization: Specifies the name of the organization (namespace) to be accessed.
               Changing this creates a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['OrganizationPermissionsSelfPermissionArgs']]] self_permissions: The permission informations of current user.
        :param pulumi.Input[Sequence[pulumi.Input['OrganizationPermissionsUserArgs']]] users: Specifies the users to access to the organization (namespace).
               Structure is documented below.
        """
        if creator is not None:
            pulumi.set(__self__, "creator", creator)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if self_permissions is not None:
            pulumi.set(__self__, "self_permissions", self_permissions)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def creator(self) -> Optional[pulumi.Input[str]]:
        """
        The creator user name of the organization.
        """
        return pulumi.get(self, "creator")

    @creator.setter
    def creator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creator", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the organization (namespace) to be accessed.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="selfPermissions")
    def self_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationPermissionsSelfPermissionArgs']]]]:
        """
        The permission informations of current user.
        """
        return pulumi.get(self, "self_permissions")

    @self_permissions.setter
    def self_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationPermissionsSelfPermissionArgs']]]]):
        pulumi.set(self, "self_permissions", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationPermissionsUserArgs']]]]:
        """
        Specifies the users to access to the organization (namespace).
        Structure is documented below.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationPermissionsUserArgs']]]]):
        pulumi.set(self, "users", value)


class OrganizationPermissions(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OrganizationPermissionsUserArgs']]]]] = None,
                 __props__=None):
        """
        Manages user permissions for the SWR organization resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        organization_name = config.require_object("organizationName")
        user1 = config.require_object("user1")
        user2 = config.require_object("user2")
        test = huaweicloud.swr.OrganizationPermissions("test",
            organization=organization_name,
            users=[
                huaweicloud.swr.OrganizationPermissionsUserArgs(
                    user_name=user1["name"],
                    user_id=user1["id"],
                    permission="Read",
                ),
                huaweicloud.swr.OrganizationPermissionsUserArgs(
                    user_name=user2["name"],
                    user_id=user2["id"],
                    permission="Read",
                ),
            ])
        ```

        ## Import

        Organization Permissions can be imported using the `id` (organization name), e.g.

        ```sh
         $ pulumi import huaweicloud:Swr/organizationPermissions:OrganizationPermissions test terraform-test
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] organization: Specifies the name of the organization (namespace) to be accessed.
               Changing this creates a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OrganizationPermissionsUserArgs']]]] users: Specifies the users to access to the organization (namespace).
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationPermissionsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages user permissions for the SWR organization resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        organization_name = config.require_object("organizationName")
        user1 = config.require_object("user1")
        user2 = config.require_object("user2")
        test = huaweicloud.swr.OrganizationPermissions("test",
            organization=organization_name,
            users=[
                huaweicloud.swr.OrganizationPermissionsUserArgs(
                    user_name=user1["name"],
                    user_id=user1["id"],
                    permission="Read",
                ),
                huaweicloud.swr.OrganizationPermissionsUserArgs(
                    user_name=user2["name"],
                    user_id=user2["id"],
                    permission="Read",
                ),
            ])
        ```

        ## Import

        Organization Permissions can be imported using the `id` (organization name), e.g.

        ```sh
         $ pulumi import huaweicloud:Swr/organizationPermissions:OrganizationPermissions test terraform-test
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationPermissionsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationPermissionsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OrganizationPermissionsUserArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationPermissionsArgs.__new__(OrganizationPermissionsArgs)

            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            __props__.__dict__["region"] = region
            if users is None and not opts.urn:
                raise TypeError("Missing required property 'users'")
            __props__.__dict__["users"] = users
            __props__.__dict__["creator"] = None
            __props__.__dict__["self_permissions"] = None
        super(OrganizationPermissions, __self__).__init__(
            'huaweicloud:Swr/organizationPermissions:OrganizationPermissions',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creator: Optional[pulumi.Input[str]] = None,
            organization: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            self_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OrganizationPermissionsSelfPermissionArgs']]]]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OrganizationPermissionsUserArgs']]]]] = None) -> 'OrganizationPermissions':
        """
        Get an existing OrganizationPermissions resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] creator: The creator user name of the organization.
        :param pulumi.Input[str] organization: Specifies the name of the organization (namespace) to be accessed.
               Changing this creates a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OrganizationPermissionsSelfPermissionArgs']]]] self_permissions: The permission informations of current user.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OrganizationPermissionsUserArgs']]]] users: Specifies the users to access to the organization (namespace).
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationPermissionsState.__new__(_OrganizationPermissionsState)

        __props__.__dict__["creator"] = creator
        __props__.__dict__["organization"] = organization
        __props__.__dict__["region"] = region
        __props__.__dict__["self_permissions"] = self_permissions
        __props__.__dict__["users"] = users
        return OrganizationPermissions(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def creator(self) -> pulumi.Output[str]:
        """
        The creator user name of the organization.
        """
        return pulumi.get(self, "creator")

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Output[str]:
        """
        Specifies the name of the organization (namespace) to be accessed.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="selfPermissions")
    def self_permissions(self) -> pulumi.Output[Sequence['outputs.OrganizationPermissionsSelfPermission']]:
        """
        The permission informations of current user.
        """
        return pulumi.get(self, "self_permissions")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Sequence['outputs.OrganizationPermissionsUser']]:
        """
        Specifies the users to access to the organization (namespace).
        Structure is documented below.
        """
        return pulumi.get(self, "users")

