# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ComponentInstanceArgs', 'ComponentInstance']

@pulumi.input_type
class ComponentInstanceArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[str],
                 component_id: pulumi.Input[str],
                 environment_id: pulumi.Input[str],
                 flavor_id: pulumi.Input[str],
                 refer_resources: pulumi.Input[Sequence[pulumi.Input['ComponentInstanceReferResourceArgs']]],
                 replica: pulumi.Input[int],
                 version: pulumi.Input[str],
                 artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceArtifactArgs']]]] = None,
                 configuration: Optional[pulumi.Input['ComponentInstanceConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 external_accesses: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceExternalAccessArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ComponentInstance resource.
        :param pulumi.Input[str] application_id: Specifies the application ID to which the instance belongs.
               Changing this will create a new instance.
        :param pulumi.Input[str] component_id: Specifies the component ID to build (deploy).
               Changing this will create a new instance.
        :param pulumi.Input[str] environment_id: Specifies the environment ID in which the component to build (deployed).
               Changing this will create a new instance.
        :param pulumi.Input[str] flavor_id: Specifies the resource specifications, which can be obtained by using data source or
               the customize resource specifications.
               The format of customize resource specifications is **CUSTOM-xxG:xxC-xxC:xxGi-xxGi**.
               The meaning of each part is:
               + **xxG**: storage capacity allocated to a component instance (reserved field). You can set it to a fixed number.
               + **xxC-xxC**: the maximum and minimum number of CPU cores allocated to a component instance.
               + **xxGi-xxGi**: the maximum and minimum memory allocated to a component instance.
        :param pulumi.Input[Sequence[pulumi.Input['ComponentInstanceReferResourceArgs']]] refer_resources: Specifies the deployed resources.
               The object structure is documented below.
        :param pulumi.Input[int] replica: Specifies the number of instance replicas.
               Changing this will create a new instance.
        :param pulumi.Input[str] version: Specifies the version number.
        :param pulumi.Input[Sequence[pulumi.Input['ComponentInstanceArtifactArgs']]] artifacts: Specifies the component artifact settings.
               The key indicates the component name. In the Docker container scenario, the key indicates the container name.
               The object structure is documented below.
        :param pulumi.Input['ComponentInstanceConfigurationArgs'] configuration: Specifies the configuration parameters, such as environment variables,
               deployment configurations, and O&M monitoring.
               The object structure is documented below.
        :param pulumi.Input[str] description: Specifies the description of the instance.
               The description can contian a maximum of `128` characters.
        :param pulumi.Input[Sequence[pulumi.Input['ComponentInstanceExternalAccessArgs']]] external_accesses: Specifies the configuration of the external network access.
               The object structure is documented below.
        :param pulumi.Input[str] name: Specifies the name of a configuration item or secret.
        :param pulumi.Input[str] region: Specifies the region in which to create (deploy) the ServiceStage (component) instance.
               If omitted, the provider-level region will be used. Changing this will create a new instance.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "component_id", component_id)
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "flavor_id", flavor_id)
        pulumi.set(__self__, "refer_resources", refer_resources)
        pulumi.set(__self__, "replica", replica)
        pulumi.set(__self__, "version", version)
        if artifacts is not None:
            pulumi.set(__self__, "artifacts", artifacts)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_accesses is not None:
            pulumi.set(__self__, "external_accesses", external_accesses)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[str]:
        """
        Specifies the application ID to which the instance belongs.
        Changing this will create a new instance.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> pulumi.Input[str]:
        """
        Specifies the component ID to build (deploy).
        Changing this will create a new instance.
        """
        return pulumi.get(self, "component_id")

    @component_id.setter
    def component_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "component_id", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[str]:
        """
        Specifies the environment ID in which the component to build (deployed).
        Changing this will create a new instance.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Input[str]:
        """
        Specifies the resource specifications, which can be obtained by using data source or
        the customize resource specifications.
        The format of customize resource specifications is **CUSTOM-xxG:xxC-xxC:xxGi-xxGi**.
        The meaning of each part is:
        + **xxG**: storage capacity allocated to a component instance (reserved field). You can set it to a fixed number.
        + **xxC-xxC**: the maximum and minimum number of CPU cores allocated to a component instance.
        + **xxGi-xxGi**: the maximum and minimum memory allocated to a component instance.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter(name="referResources")
    def refer_resources(self) -> pulumi.Input[Sequence[pulumi.Input['ComponentInstanceReferResourceArgs']]]:
        """
        Specifies the deployed resources.
        The object structure is documented below.
        """
        return pulumi.get(self, "refer_resources")

    @refer_resources.setter
    def refer_resources(self, value: pulumi.Input[Sequence[pulumi.Input['ComponentInstanceReferResourceArgs']]]):
        pulumi.set(self, "refer_resources", value)

    @property
    @pulumi.getter
    def replica(self) -> pulumi.Input[int]:
        """
        Specifies the number of instance replicas.
        Changing this will create a new instance.
        """
        return pulumi.get(self, "replica")

    @replica.setter
    def replica(self, value: pulumi.Input[int]):
        pulumi.set(self, "replica", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        Specifies the version number.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceArtifactArgs']]]]:
        """
        Specifies the component artifact settings.
        The key indicates the component name. In the Docker container scenario, the key indicates the container name.
        The object structure is documented below.
        """
        return pulumi.get(self, "artifacts")

    @artifacts.setter
    def artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceArtifactArgs']]]]):
        pulumi.set(self, "artifacts", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['ComponentInstanceConfigurationArgs']]:
        """
        Specifies the configuration parameters, such as environment variables,
        deployment configurations, and O&M monitoring.
        The object structure is documented below.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['ComponentInstanceConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the instance.
        The description can contian a maximum of `128` characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="externalAccesses")
    def external_accesses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceExternalAccessArgs']]]]:
        """
        Specifies the configuration of the external network access.
        The object structure is documented below.
        """
        return pulumi.get(self, "external_accesses")

    @external_accesses.setter
    def external_accesses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceExternalAccessArgs']]]]):
        pulumi.set(self, "external_accesses", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of a configuration item or secret.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create (deploy) the ServiceStage (component) instance.
        If omitted, the provider-level region will be used. Changing this will create a new instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ComponentInstanceState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[str]] = None,
                 artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceArtifactArgs']]]] = None,
                 component_id: Optional[pulumi.Input[str]] = None,
                 configuration: Optional[pulumi.Input['ComponentInstanceConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 external_accesses: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceExternalAccessArgs']]]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 refer_resources: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceReferResourceArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ComponentInstance resources.
        :param pulumi.Input[str] application_id: Specifies the application ID to which the instance belongs.
               Changing this will create a new instance.
        :param pulumi.Input[Sequence[pulumi.Input['ComponentInstanceArtifactArgs']]] artifacts: Specifies the component artifact settings.
               The key indicates the component name. In the Docker container scenario, the key indicates the container name.
               The object structure is documented below.
        :param pulumi.Input[str] component_id: Specifies the component ID to build (deploy).
               Changing this will create a new instance.
        :param pulumi.Input['ComponentInstanceConfigurationArgs'] configuration: Specifies the configuration parameters, such as environment variables,
               deployment configurations, and O&M monitoring.
               The object structure is documented below.
        :param pulumi.Input[str] description: Specifies the description of the instance.
               The description can contian a maximum of `128` characters.
        :param pulumi.Input[str] environment_id: Specifies the environment ID in which the component to build (deployed).
               Changing this will create a new instance.
        :param pulumi.Input[Sequence[pulumi.Input['ComponentInstanceExternalAccessArgs']]] external_accesses: Specifies the configuration of the external network access.
               The object structure is documented below.
        :param pulumi.Input[str] flavor_id: Specifies the resource specifications, which can be obtained by using data source or
               the customize resource specifications.
               The format of customize resource specifications is **CUSTOM-xxG:xxC-xxC:xxGi-xxGi**.
               The meaning of each part is:
               + **xxG**: storage capacity allocated to a component instance (reserved field). You can set it to a fixed number.
               + **xxC-xxC**: the maximum and minimum number of CPU cores allocated to a component instance.
               + **xxGi-xxGi**: the maximum and minimum memory allocated to a component instance.
        :param pulumi.Input[str] name: Specifies the name of a configuration item or secret.
        :param pulumi.Input[Sequence[pulumi.Input['ComponentInstanceReferResourceArgs']]] refer_resources: Specifies the deployed resources.
               The object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to create (deploy) the ServiceStage (component) instance.
               If omitted, the provider-level region will be used. Changing this will create a new instance.
        :param pulumi.Input[int] replica: Specifies the number of instance replicas.
               Changing this will create a new instance.
        :param pulumi.Input[str] status: The instance status, which supports:
               + **FAILED**
               + **RUNNING**
               + **DOWN**
               + **STOPPED**
               + **UNKNOWN**
               + **PARTIALLY_FAILED**
        :param pulumi.Input[str] version: Specifies the version number.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if artifacts is not None:
            pulumi.set(__self__, "artifacts", artifacts)
        if component_id is not None:
            pulumi.set(__self__, "component_id", component_id)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if external_accesses is not None:
            pulumi.set(__self__, "external_accesses", external_accesses)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if refer_resources is not None:
            pulumi.set(__self__, "refer_resources", refer_resources)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica is not None:
            pulumi.set(__self__, "replica", replica)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the application ID to which the instance belongs.
        Changing this will create a new instance.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter
    def artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceArtifactArgs']]]]:
        """
        Specifies the component artifact settings.
        The key indicates the component name. In the Docker container scenario, the key indicates the container name.
        The object structure is documented below.
        """
        return pulumi.get(self, "artifacts")

    @artifacts.setter
    def artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceArtifactArgs']]]]):
        pulumi.set(self, "artifacts", value)

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the component ID to build (deploy).
        Changing this will create a new instance.
        """
        return pulumi.get(self, "component_id")

    @component_id.setter
    def component_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "component_id", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['ComponentInstanceConfigurationArgs']]:
        """
        Specifies the configuration parameters, such as environment variables,
        deployment configurations, and O&M monitoring.
        The object structure is documented below.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['ComponentInstanceConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the instance.
        The description can contian a maximum of `128` characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the environment ID in which the component to build (deployed).
        Changing this will create a new instance.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="externalAccesses")
    def external_accesses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceExternalAccessArgs']]]]:
        """
        Specifies the configuration of the external network access.
        The object structure is documented below.
        """
        return pulumi.get(self, "external_accesses")

    @external_accesses.setter
    def external_accesses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceExternalAccessArgs']]]]):
        pulumi.set(self, "external_accesses", value)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the resource specifications, which can be obtained by using data source or
        the customize resource specifications.
        The format of customize resource specifications is **CUSTOM-xxG:xxC-xxC:xxGi-xxGi**.
        The meaning of each part is:
        + **xxG**: storage capacity allocated to a component instance (reserved field). You can set it to a fixed number.
        + **xxC-xxC**: the maximum and minimum number of CPU cores allocated to a component instance.
        + **xxGi-xxGi**: the maximum and minimum memory allocated to a component instance.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of a configuration item or secret.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="referResources")
    def refer_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceReferResourceArgs']]]]:
        """
        Specifies the deployed resources.
        The object structure is documented below.
        """
        return pulumi.get(self, "refer_resources")

    @refer_resources.setter
    def refer_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceReferResourceArgs']]]]):
        pulumi.set(self, "refer_resources", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create (deploy) the ServiceStage (component) instance.
        If omitted, the provider-level region will be used. Changing this will create a new instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def replica(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of instance replicas.
        Changing this will create a new instance.
        """
        return pulumi.get(self, "replica")

    @replica.setter
    def replica(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replica", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The instance status, which supports:
        + **FAILED**
        + **RUNNING**
        + **DOWN**
        + **STOPPED**
        + **UNKNOWN**
        + **PARTIALLY_FAILED**
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version number.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class ComponentInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComponentInstanceArtifactArgs']]]]] = None,
                 component_id: Optional[pulumi.Input[str]] = None,
                 configuration: Optional[pulumi.Input[pulumi.InputType['ComponentInstanceConfigurationArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 external_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComponentInstanceExternalAccessArgs']]]]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 refer_resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComponentInstanceReferResourceArgs']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica: Optional[pulumi.Input[int]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource is used to deploy a component under specified application within HuaweiCloud ServiceStage service.

        ## Example Usage
        ### Deploy a component in the container with specified SWR image

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        app_id = config.require_object("appId")
        component_id = config.require_object("componentId")
        env_id = config.require_object("envId")
        instance_name = config.require_object("instanceName")
        flavor_id = config.require_object("flavorId")
        component_name = config.require_object("componentName")
        swr_image_url = config.require_object("swrImageUrl")
        cce_cluster_id = config.require_object("cceClusterId")
        cse_engine_id = config.require_object("cseEngineId")
        default = huaweicloud.service_stage.ComponentInstance("default",
            application_id=app_id,
            component_id=component_id,
            environment_id=env_id,
            version="1.0.0",
            replica=1,
            flavor_id=flavor_id,
            artifacts=[huaweicloud.service_stage.ComponentInstanceArtifactArgs(
                name=component_name,
                type="image",
                storage="swr",
                url=swr_image_url,
                auth_type="iam",
            )],
            refer_resources=[
                huaweicloud.service_stage.ComponentInstanceReferResourceArgs(
                    type="cce",
                    id=cce_cluster_id,
                    parameters={
                        "type": "VirtualMachine",
                        "namespace": "default",
                    },
                ),
                huaweicloud.service_stage.ComponentInstanceReferResourceArgs(
                    type="cse",
                    id=cse_engine_id,
                ),
            ],
            configuration=huaweicloud.service_stage.ComponentInstanceConfigurationArgs(
                env_variables=[huaweicloud.service_stage.ComponentInstanceConfigurationEnvVariableArgs(
                    name="TZ",
                    value="Asia/Shanghai",
                )],
                log_collection_policies=[huaweicloud.service_stage.ComponentInstanceConfigurationLogCollectionPolicyArgs(
                    host_path="/tmp",
                    container_mountings=[huaweicloud.service_stage.ComponentInstanceConfigurationLogCollectionPolicyContainerMountingArgs(
                        path="/attached/01",
                        aging_period="Hourly",
                    )],
                )],
            ))
        ```
        ### Deploy a component in the ECS instance with specified jar package

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        app_id = config.require_object("appId")
        component_id = config.require_object("componentId")
        env_id = config.require_object("envId")
        instance_name = config.require_object("instanceName")
        flavor_id = config.require_object("flavorId")
        component_name = config.require_object("componentName")
        jar_url = config.require_object("jarUrl")
        obs_bucket_name = config.require_object("obsBucketName")
        obs_bucket_endpoint = config.require_object("obsBucketEndpoint")
        obs_object_key = config.require_object("obsObjectKey")
        ecs_instance_id = config.require_object("ecsInstanceId")
        test = huaweicloud.service_stage.ComponentInstance("test",
            application_id=app_id,
            component_id=component_id,
            environment_id=env_id,
            version="1.0.0",
            replica=1,
            flavor_id=flavor_id,
            artifacts=[huaweicloud.service_stage.ComponentInstanceArtifactArgs(
                name=component_name,
                auth_type="iam",
                type="package",
                storage="obs",
                url=jar_url,
                properties=huaweicloud.service_stage.ComponentInstanceArtifactPropertiesArgs(
                    bucket=obs_bucket_name,
                    endpoint=obs_bucket_endpoint,
                    key=obs_object_key,
                ),
            )],
            refer_resources=[huaweicloud.service_stage.ComponentInstanceReferResourceArgs(
                type="ecs",
                id="Default",
                parameters={
                    "hosts": f"[\\"{ecs_instance_id}\\"]",
                },
            )])
        ```

        ## Import

        Instances can be imported using their related `application_id`, `component_id` and `id`, separated by a slash (/), e.g.

        ```sh
         $ pulumi import huaweicloud:ServiceStage/componentInstance:ComponentInstance test 4e65a759-e7b1-4e9e-8277-857f8e261f3c/4e65a759-e7b1-4e9e-8277-857f8e261f3c/c0a13d88-d4e3-11ec-93a9-0255ac101d30
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: Specifies the application ID to which the instance belongs.
               Changing this will create a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComponentInstanceArtifactArgs']]]] artifacts: Specifies the component artifact settings.
               The key indicates the component name. In the Docker container scenario, the key indicates the container name.
               The object structure is documented below.
        :param pulumi.Input[str] component_id: Specifies the component ID to build (deploy).
               Changing this will create a new instance.
        :param pulumi.Input[pulumi.InputType['ComponentInstanceConfigurationArgs']] configuration: Specifies the configuration parameters, such as environment variables,
               deployment configurations, and O&M monitoring.
               The object structure is documented below.
        :param pulumi.Input[str] description: Specifies the description of the instance.
               The description can contian a maximum of `128` characters.
        :param pulumi.Input[str] environment_id: Specifies the environment ID in which the component to build (deployed).
               Changing this will create a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComponentInstanceExternalAccessArgs']]]] external_accesses: Specifies the configuration of the external network access.
               The object structure is documented below.
        :param pulumi.Input[str] flavor_id: Specifies the resource specifications, which can be obtained by using data source or
               the customize resource specifications.
               The format of customize resource specifications is **CUSTOM-xxG:xxC-xxC:xxGi-xxGi**.
               The meaning of each part is:
               + **xxG**: storage capacity allocated to a component instance (reserved field). You can set it to a fixed number.
               + **xxC-xxC**: the maximum and minimum number of CPU cores allocated to a component instance.
               + **xxGi-xxGi**: the maximum and minimum memory allocated to a component instance.
        :param pulumi.Input[str] name: Specifies the name of a configuration item or secret.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComponentInstanceReferResourceArgs']]]] refer_resources: Specifies the deployed resources.
               The object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to create (deploy) the ServiceStage (component) instance.
               If omitted, the provider-level region will be used. Changing this will create a new instance.
        :param pulumi.Input[int] replica: Specifies the number of instance replicas.
               Changing this will create a new instance.
        :param pulumi.Input[str] version: Specifies the version number.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComponentInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource is used to deploy a component under specified application within HuaweiCloud ServiceStage service.

        ## Example Usage
        ### Deploy a component in the container with specified SWR image

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        app_id = config.require_object("appId")
        component_id = config.require_object("componentId")
        env_id = config.require_object("envId")
        instance_name = config.require_object("instanceName")
        flavor_id = config.require_object("flavorId")
        component_name = config.require_object("componentName")
        swr_image_url = config.require_object("swrImageUrl")
        cce_cluster_id = config.require_object("cceClusterId")
        cse_engine_id = config.require_object("cseEngineId")
        default = huaweicloud.service_stage.ComponentInstance("default",
            application_id=app_id,
            component_id=component_id,
            environment_id=env_id,
            version="1.0.0",
            replica=1,
            flavor_id=flavor_id,
            artifacts=[huaweicloud.service_stage.ComponentInstanceArtifactArgs(
                name=component_name,
                type="image",
                storage="swr",
                url=swr_image_url,
                auth_type="iam",
            )],
            refer_resources=[
                huaweicloud.service_stage.ComponentInstanceReferResourceArgs(
                    type="cce",
                    id=cce_cluster_id,
                    parameters={
                        "type": "VirtualMachine",
                        "namespace": "default",
                    },
                ),
                huaweicloud.service_stage.ComponentInstanceReferResourceArgs(
                    type="cse",
                    id=cse_engine_id,
                ),
            ],
            configuration=huaweicloud.service_stage.ComponentInstanceConfigurationArgs(
                env_variables=[huaweicloud.service_stage.ComponentInstanceConfigurationEnvVariableArgs(
                    name="TZ",
                    value="Asia/Shanghai",
                )],
                log_collection_policies=[huaweicloud.service_stage.ComponentInstanceConfigurationLogCollectionPolicyArgs(
                    host_path="/tmp",
                    container_mountings=[huaweicloud.service_stage.ComponentInstanceConfigurationLogCollectionPolicyContainerMountingArgs(
                        path="/attached/01",
                        aging_period="Hourly",
                    )],
                )],
            ))
        ```
        ### Deploy a component in the ECS instance with specified jar package

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        app_id = config.require_object("appId")
        component_id = config.require_object("componentId")
        env_id = config.require_object("envId")
        instance_name = config.require_object("instanceName")
        flavor_id = config.require_object("flavorId")
        component_name = config.require_object("componentName")
        jar_url = config.require_object("jarUrl")
        obs_bucket_name = config.require_object("obsBucketName")
        obs_bucket_endpoint = config.require_object("obsBucketEndpoint")
        obs_object_key = config.require_object("obsObjectKey")
        ecs_instance_id = config.require_object("ecsInstanceId")
        test = huaweicloud.service_stage.ComponentInstance("test",
            application_id=app_id,
            component_id=component_id,
            environment_id=env_id,
            version="1.0.0",
            replica=1,
            flavor_id=flavor_id,
            artifacts=[huaweicloud.service_stage.ComponentInstanceArtifactArgs(
                name=component_name,
                auth_type="iam",
                type="package",
                storage="obs",
                url=jar_url,
                properties=huaweicloud.service_stage.ComponentInstanceArtifactPropertiesArgs(
                    bucket=obs_bucket_name,
                    endpoint=obs_bucket_endpoint,
                    key=obs_object_key,
                ),
            )],
            refer_resources=[huaweicloud.service_stage.ComponentInstanceReferResourceArgs(
                type="ecs",
                id="Default",
                parameters={
                    "hosts": f"[\\"{ecs_instance_id}\\"]",
                },
            )])
        ```

        ## Import

        Instances can be imported using their related `application_id`, `component_id` and `id`, separated by a slash (/), e.g.

        ```sh
         $ pulumi import huaweicloud:ServiceStage/componentInstance:ComponentInstance test 4e65a759-e7b1-4e9e-8277-857f8e261f3c/4e65a759-e7b1-4e9e-8277-857f8e261f3c/c0a13d88-d4e3-11ec-93a9-0255ac101d30
        ```

        :param str resource_name: The name of the resource.
        :param ComponentInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComponentInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComponentInstanceArtifactArgs']]]]] = None,
                 component_id: Optional[pulumi.Input[str]] = None,
                 configuration: Optional[pulumi.Input[pulumi.InputType['ComponentInstanceConfigurationArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 external_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComponentInstanceExternalAccessArgs']]]]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 refer_resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComponentInstanceReferResourceArgs']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica: Optional[pulumi.Input[int]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComponentInstanceArgs.__new__(ComponentInstanceArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["artifacts"] = artifacts
            if component_id is None and not opts.urn:
                raise TypeError("Missing required property 'component_id'")
            __props__.__dict__["component_id"] = component_id
            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["description"] = description
            if environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'environment_id'")
            __props__.__dict__["environment_id"] = environment_id
            __props__.__dict__["external_accesses"] = external_accesses
            if flavor_id is None and not opts.urn:
                raise TypeError("Missing required property 'flavor_id'")
            __props__.__dict__["flavor_id"] = flavor_id
            __props__.__dict__["name"] = name
            if refer_resources is None and not opts.urn:
                raise TypeError("Missing required property 'refer_resources'")
            __props__.__dict__["refer_resources"] = refer_resources
            __props__.__dict__["region"] = region
            if replica is None and not opts.urn:
                raise TypeError("Missing required property 'replica'")
            __props__.__dict__["replica"] = replica
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["status"] = None
        super(ComponentInstance, __self__).__init__(
            'huaweicloud:ServiceStage/componentInstance:ComponentInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[str]] = None,
            artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComponentInstanceArtifactArgs']]]]] = None,
            component_id: Optional[pulumi.Input[str]] = None,
            configuration: Optional[pulumi.Input[pulumi.InputType['ComponentInstanceConfigurationArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            environment_id: Optional[pulumi.Input[str]] = None,
            external_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComponentInstanceExternalAccessArgs']]]]] = None,
            flavor_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            refer_resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComponentInstanceReferResourceArgs']]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            replica: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'ComponentInstance':
        """
        Get an existing ComponentInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: Specifies the application ID to which the instance belongs.
               Changing this will create a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComponentInstanceArtifactArgs']]]] artifacts: Specifies the component artifact settings.
               The key indicates the component name. In the Docker container scenario, the key indicates the container name.
               The object structure is documented below.
        :param pulumi.Input[str] component_id: Specifies the component ID to build (deploy).
               Changing this will create a new instance.
        :param pulumi.Input[pulumi.InputType['ComponentInstanceConfigurationArgs']] configuration: Specifies the configuration parameters, such as environment variables,
               deployment configurations, and O&M monitoring.
               The object structure is documented below.
        :param pulumi.Input[str] description: Specifies the description of the instance.
               The description can contian a maximum of `128` characters.
        :param pulumi.Input[str] environment_id: Specifies the environment ID in which the component to build (deployed).
               Changing this will create a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComponentInstanceExternalAccessArgs']]]] external_accesses: Specifies the configuration of the external network access.
               The object structure is documented below.
        :param pulumi.Input[str] flavor_id: Specifies the resource specifications, which can be obtained by using data source or
               the customize resource specifications.
               The format of customize resource specifications is **CUSTOM-xxG:xxC-xxC:xxGi-xxGi**.
               The meaning of each part is:
               + **xxG**: storage capacity allocated to a component instance (reserved field). You can set it to a fixed number.
               + **xxC-xxC**: the maximum and minimum number of CPU cores allocated to a component instance.
               + **xxGi-xxGi**: the maximum and minimum memory allocated to a component instance.
        :param pulumi.Input[str] name: Specifies the name of a configuration item or secret.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComponentInstanceReferResourceArgs']]]] refer_resources: Specifies the deployed resources.
               The object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to create (deploy) the ServiceStage (component) instance.
               If omitted, the provider-level region will be used. Changing this will create a new instance.
        :param pulumi.Input[int] replica: Specifies the number of instance replicas.
               Changing this will create a new instance.
        :param pulumi.Input[str] status: The instance status, which supports:
               + **FAILED**
               + **RUNNING**
               + **DOWN**
               + **STOPPED**
               + **UNKNOWN**
               + **PARTIALLY_FAILED**
        :param pulumi.Input[str] version: Specifies the version number.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComponentInstanceState.__new__(_ComponentInstanceState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["artifacts"] = artifacts
        __props__.__dict__["component_id"] = component_id
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["description"] = description
        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["external_accesses"] = external_accesses
        __props__.__dict__["flavor_id"] = flavor_id
        __props__.__dict__["name"] = name
        __props__.__dict__["refer_resources"] = refer_resources
        __props__.__dict__["region"] = region
        __props__.__dict__["replica"] = replica
        __props__.__dict__["status"] = status
        __props__.__dict__["version"] = version
        return ComponentInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[str]:
        """
        Specifies the application ID to which the instance belongs.
        Changing this will create a new instance.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter
    def artifacts(self) -> pulumi.Output[Sequence['outputs.ComponentInstanceArtifact']]:
        """
        Specifies the component artifact settings.
        The key indicates the component name. In the Docker container scenario, the key indicates the container name.
        The object structure is documented below.
        """
        return pulumi.get(self, "artifacts")

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> pulumi.Output[str]:
        """
        Specifies the component ID to build (deploy).
        Changing this will create a new instance.
        """
        return pulumi.get(self, "component_id")

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output['outputs.ComponentInstanceConfiguration']:
        """
        Specifies the configuration parameters, such as environment variables,
        deployment configurations, and O&M monitoring.
        The object structure is documented below.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of the instance.
        The description can contian a maximum of `128` characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[str]:
        """
        Specifies the environment ID in which the component to build (deployed).
        Changing this will create a new instance.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="externalAccesses")
    def external_accesses(self) -> pulumi.Output[Sequence['outputs.ComponentInstanceExternalAccess']]:
        """
        Specifies the configuration of the external network access.
        The object structure is documented below.
        """
        return pulumi.get(self, "external_accesses")

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[str]:
        """
        Specifies the resource specifications, which can be obtained by using data source or
        the customize resource specifications.
        The format of customize resource specifications is **CUSTOM-xxG:xxC-xxC:xxGi-xxGi**.
        The meaning of each part is:
        + **xxG**: storage capacity allocated to a component instance (reserved field). You can set it to a fixed number.
        + **xxC-xxC**: the maximum and minimum number of CPU cores allocated to a component instance.
        + **xxGi-xxGi**: the maximum and minimum memory allocated to a component instance.
        """
        return pulumi.get(self, "flavor_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of a configuration item or secret.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="referResources")
    def refer_resources(self) -> pulumi.Output[Sequence['outputs.ComponentInstanceReferResource']]:
        """
        Specifies the deployed resources.
        The object structure is documented below.
        """
        return pulumi.get(self, "refer_resources")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create (deploy) the ServiceStage (component) instance.
        If omitted, the provider-level region will be used. Changing this will create a new instance.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def replica(self) -> pulumi.Output[int]:
        """
        Specifies the number of instance replicas.
        Changing this will create a new instance.
        """
        return pulumi.get(self, "replica")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The instance status, which supports:
        + **FAILED**
        + **RUNNING**
        + **DOWN**
        + **STOPPED**
        + **UNKNOWN**
        + **PARTIALLY_FAILED**
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Specifies the version number.
        """
        return pulumi.get(self, "version")

