# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ComponentArgs', 'Component']

@pulumi.input_type
class ComponentArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[str],
                 runtime: pulumi.Input[str],
                 type: pulumi.Input[str],
                 builder: Optional[pulumi.Input['ComponentBuilderArgs']] = None,
                 framework: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input['ComponentSourceArgs']] = None):
        """
        The set of arguments for constructing a Component resource.
        :param pulumi.Input[str] application_id: Specifies the application ID to which the component belongs.
               Changing this parameter will create a new component.
        :param pulumi.Input[str] runtime: Specifies the component runtime, such as **Docker**, **Java8**, etc.
               Changing this parameter will create a new component.
        :param pulumi.Input[str] type: Specifies the type of repository source or storage.
               The valid values are **GitHub**, **GitLab**, **Gitee**, **Bitbucket** and **package**.
        :param pulumi.Input['ComponentBuilderArgs'] builder: Specifies the component builder.
               The object structure is documented below.
        :param pulumi.Input[str] framework: Specifies the component framework.
               + The framework of type **Webapp** is **Web**.
               + The framework of type **MicroService** supports: **Java Classis**, **Go Classis**, **Mesher**, **Spring Cloud**,
               **Dubbo**.
               + The framework of type **Common** can be empty.
        :param pulumi.Input[str] name: Specifies the authorization name.
               The name can contain of 2 to 64 characters, only letters, digits, underscores (_) and hyphens (-) are allowed, and the
               name must start with a letter and end with a letter or digit.
        :param pulumi.Input[str] region: Specifies the region where the application and component are located.
               If omitted, the provider-level region will be used. Changing this parameter will create a new component.
        :param pulumi.Input['ComponentSourceArgs'] source: Specifies the repository source.
               The object structure is documented below.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "runtime", runtime)
        pulumi.set(__self__, "type", type)
        if builder is not None:
            pulumi.set(__self__, "builder", builder)
        if framework is not None:
            pulumi.set(__self__, "framework", framework)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[str]:
        """
        Specifies the application ID to which the component belongs.
        Changing this parameter will create a new component.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Input[str]:
        """
        Specifies the component runtime, such as **Docker**, **Java8**, etc.
        Changing this parameter will create a new component.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: pulumi.Input[str]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the type of repository source or storage.
        The valid values are **GitHub**, **GitLab**, **Gitee**, **Bitbucket** and **package**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def builder(self) -> Optional[pulumi.Input['ComponentBuilderArgs']]:
        """
        Specifies the component builder.
        The object structure is documented below.
        """
        return pulumi.get(self, "builder")

    @builder.setter
    def builder(self, value: Optional[pulumi.Input['ComponentBuilderArgs']]):
        pulumi.set(self, "builder", value)

    @property
    @pulumi.getter
    def framework(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the component framework.
        + The framework of type **Webapp** is **Web**.
        + The framework of type **MicroService** supports: **Java Classis**, **Go Classis**, **Mesher**, **Spring Cloud**,
        **Dubbo**.
        + The framework of type **Common** can be empty.
        """
        return pulumi.get(self, "framework")

    @framework.setter
    def framework(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "framework", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the authorization name.
        The name can contain of 2 to 64 characters, only letters, digits, underscores (_) and hyphens (-) are allowed, and the
        name must start with a letter and end with a letter or digit.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region where the application and component are located.
        If omitted, the provider-level region will be used. Changing this parameter will create a new component.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['ComponentSourceArgs']]:
        """
        Specifies the repository source.
        The object structure is documented below.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['ComponentSourceArgs']]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class _ComponentState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[str]] = None,
                 builder: Optional[pulumi.Input['ComponentBuilderArgs']] = None,
                 framework: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input['ComponentSourceArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Component resources.
        :param pulumi.Input[str] application_id: Specifies the application ID to which the component belongs.
               Changing this parameter will create a new component.
        :param pulumi.Input['ComponentBuilderArgs'] builder: Specifies the component builder.
               The object structure is documented below.
        :param pulumi.Input[str] framework: Specifies the component framework.
               + The framework of type **Webapp** is **Web**.
               + The framework of type **MicroService** supports: **Java Classis**, **Go Classis**, **Mesher**, **Spring Cloud**,
               **Dubbo**.
               + The framework of type **Common** can be empty.
        :param pulumi.Input[str] name: Specifies the authorization name.
               The name can contain of 2 to 64 characters, only letters, digits, underscores (_) and hyphens (-) are allowed, and the
               name must start with a letter and end with a letter or digit.
        :param pulumi.Input[str] region: Specifies the region where the application and component are located.
               If omitted, the provider-level region will be used. Changing this parameter will create a new component.
        :param pulumi.Input[str] runtime: Specifies the component runtime, such as **Docker**, **Java8**, etc.
               Changing this parameter will create a new component.
        :param pulumi.Input['ComponentSourceArgs'] source: Specifies the repository source.
               The object structure is documented below.
        :param pulumi.Input[str] type: Specifies the type of repository source or storage.
               The valid values are **GitHub**, **GitLab**, **Gitee**, **Bitbucket** and **package**.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if builder is not None:
            pulumi.set(__self__, "builder", builder)
        if framework is not None:
            pulumi.set(__self__, "framework", framework)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the application ID to which the component belongs.
        Changing this parameter will create a new component.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter
    def builder(self) -> Optional[pulumi.Input['ComponentBuilderArgs']]:
        """
        Specifies the component builder.
        The object structure is documented below.
        """
        return pulumi.get(self, "builder")

    @builder.setter
    def builder(self, value: Optional[pulumi.Input['ComponentBuilderArgs']]):
        pulumi.set(self, "builder", value)

    @property
    @pulumi.getter
    def framework(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the component framework.
        + The framework of type **Webapp** is **Web**.
        + The framework of type **MicroService** supports: **Java Classis**, **Go Classis**, **Mesher**, **Spring Cloud**,
        **Dubbo**.
        + The framework of type **Common** can be empty.
        """
        return pulumi.get(self, "framework")

    @framework.setter
    def framework(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "framework", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the authorization name.
        The name can contain of 2 to 64 characters, only letters, digits, underscores (_) and hyphens (-) are allowed, and the
        name must start with a letter and end with a letter or digit.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region where the application and component are located.
        If omitted, the provider-level region will be used. Changing this parameter will create a new component.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the component runtime, such as **Docker**, **Java8**, etc.
        Changing this parameter will create a new component.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['ComponentSourceArgs']]:
        """
        Specifies the repository source.
        The object structure is documented below.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['ComponentSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of repository source or storage.
        The valid values are **GitHub**, **GitLab**, **Gitee**, **Bitbucket** and **package**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class Component(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 builder: Optional[pulumi.Input[pulumi.InputType['ComponentBuilderArgs']]] = None,
                 framework: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[pulumi.InputType['ComponentSourceArgs']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource is used to manage a component under specified application within HuaweiCloud ServiceStage service.

        ## Example Usage

        ## Import

        Components can be imported using their `application_id` and `id`, separated by a slash (/), e.g.

        ```sh
         $ pulumi import huaweicloud:ServiceStage/component:Component test dd7a1ce2-c48c-4f41-85bb-d0d09969eec9/9ab8ef79-d318-4de5-acf9-e1e1e25a0395
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: Specifies the application ID to which the component belongs.
               Changing this parameter will create a new component.
        :param pulumi.Input[pulumi.InputType['ComponentBuilderArgs']] builder: Specifies the component builder.
               The object structure is documented below.
        :param pulumi.Input[str] framework: Specifies the component framework.
               + The framework of type **Webapp** is **Web**.
               + The framework of type **MicroService** supports: **Java Classis**, **Go Classis**, **Mesher**, **Spring Cloud**,
               **Dubbo**.
               + The framework of type **Common** can be empty.
        :param pulumi.Input[str] name: Specifies the authorization name.
               The name can contain of 2 to 64 characters, only letters, digits, underscores (_) and hyphens (-) are allowed, and the
               name must start with a letter and end with a letter or digit.
        :param pulumi.Input[str] region: Specifies the region where the application and component are located.
               If omitted, the provider-level region will be used. Changing this parameter will create a new component.
        :param pulumi.Input[str] runtime: Specifies the component runtime, such as **Docker**, **Java8**, etc.
               Changing this parameter will create a new component.
        :param pulumi.Input[pulumi.InputType['ComponentSourceArgs']] source: Specifies the repository source.
               The object structure is documented below.
        :param pulumi.Input[str] type: Specifies the type of repository source or storage.
               The valid values are **GitHub**, **GitLab**, **Gitee**, **Bitbucket** and **package**.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComponentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource is used to manage a component under specified application within HuaweiCloud ServiceStage service.

        ## Example Usage

        ## Import

        Components can be imported using their `application_id` and `id`, separated by a slash (/), e.g.

        ```sh
         $ pulumi import huaweicloud:ServiceStage/component:Component test dd7a1ce2-c48c-4f41-85bb-d0d09969eec9/9ab8ef79-d318-4de5-acf9-e1e1e25a0395
        ```

        :param str resource_name: The name of the resource.
        :param ComponentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComponentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 builder: Optional[pulumi.Input[pulumi.InputType['ComponentBuilderArgs']]] = None,
                 framework: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[pulumi.InputType['ComponentSourceArgs']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComponentArgs.__new__(ComponentArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["builder"] = builder
            __props__.__dict__["framework"] = framework
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if runtime is None and not opts.urn:
                raise TypeError("Missing required property 'runtime'")
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["source"] = source
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(Component, __self__).__init__(
            'huaweicloud:ServiceStage/component:Component',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[str]] = None,
            builder: Optional[pulumi.Input[pulumi.InputType['ComponentBuilderArgs']]] = None,
            framework: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            runtime: Optional[pulumi.Input[str]] = None,
            source: Optional[pulumi.Input[pulumi.InputType['ComponentSourceArgs']]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'Component':
        """
        Get an existing Component resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: Specifies the application ID to which the component belongs.
               Changing this parameter will create a new component.
        :param pulumi.Input[pulumi.InputType['ComponentBuilderArgs']] builder: Specifies the component builder.
               The object structure is documented below.
        :param pulumi.Input[str] framework: Specifies the component framework.
               + The framework of type **Webapp** is **Web**.
               + The framework of type **MicroService** supports: **Java Classis**, **Go Classis**, **Mesher**, **Spring Cloud**,
               **Dubbo**.
               + The framework of type **Common** can be empty.
        :param pulumi.Input[str] name: Specifies the authorization name.
               The name can contain of 2 to 64 characters, only letters, digits, underscores (_) and hyphens (-) are allowed, and the
               name must start with a letter and end with a letter or digit.
        :param pulumi.Input[str] region: Specifies the region where the application and component are located.
               If omitted, the provider-level region will be used. Changing this parameter will create a new component.
        :param pulumi.Input[str] runtime: Specifies the component runtime, such as **Docker**, **Java8**, etc.
               Changing this parameter will create a new component.
        :param pulumi.Input[pulumi.InputType['ComponentSourceArgs']] source: Specifies the repository source.
               The object structure is documented below.
        :param pulumi.Input[str] type: Specifies the type of repository source or storage.
               The valid values are **GitHub**, **GitLab**, **Gitee**, **Bitbucket** and **package**.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComponentState.__new__(_ComponentState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["builder"] = builder
        __props__.__dict__["framework"] = framework
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["source"] = source
        __props__.__dict__["type"] = type
        return Component(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[str]:
        """
        Specifies the application ID to which the component belongs.
        Changing this parameter will create a new component.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter
    def builder(self) -> pulumi.Output['outputs.ComponentBuilder']:
        """
        Specifies the component builder.
        The object structure is documented below.
        """
        return pulumi.get(self, "builder")

    @property
    @pulumi.getter
    def framework(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the component framework.
        + The framework of type **Webapp** is **Web**.
        + The framework of type **MicroService** supports: **Java Classis**, **Go Classis**, **Mesher**, **Spring Cloud**,
        **Dubbo**.
        + The framework of type **Common** can be empty.
        """
        return pulumi.get(self, "framework")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the authorization name.
        The name can contain of 2 to 64 characters, only letters, digits, underscores (_) and hyphens (-) are allowed, and the
        name must start with a letter and end with a letter or digit.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region where the application and component are located.
        If omitted, the provider-level region will be used. Changing this parameter will create a new component.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[str]:
        """
        Specifies the component runtime, such as **Docker**, **Java8**, etc.
        Changing this parameter will create a new component.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.ComponentSource']:
        """
        Specifies the repository source.
        The object structure is documented below.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Specifies the type of repository source or storage.
        The valid values are **GitHub**, **GitLab**, **Gitee**, **Bitbucket** and **package**.
        """
        return pulumi.get(self, "type")

