# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplicationArgs', 'Application']

@pulumi.input_type
class ApplicationArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationEnvironmentArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Application resource.
        :param pulumi.Input[str] description: Specifies the application description.
               The description can contian a maximum of `128` characters.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise projcet ID to which the application
               belongs. Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationEnvironmentArgs']]] environments: Specifies the configurations of the environment variables.
               The object structure is documented below.
        :param pulumi.Input[str] name: Specifies the variable name. The name can contain `1` to `64` characters, only letters,
               digits, underscores (_), hyphens (-) and dots (.) are allowed. The name cannot start with a digit or dot.
        :param pulumi.Input[str] region: Specifies the region in which to create the ServiceStage application.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if environments is not None:
            pulumi.set(__self__, "environments", environments)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the application description.
        The description can contian a maximum of `128` characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise projcet ID to which the application
        belongs. Changing this will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def environments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationEnvironmentArgs']]]]:
        """
        Specifies the configurations of the environment variables.
        The object structure is documented below.
        """
        return pulumi.get(self, "environments")

    @environments.setter
    def environments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationEnvironmentArgs']]]]):
        pulumi.set(self, "environments", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the variable name. The name can contain `1` to `64` characters, only letters,
        digits, underscores (_), hyphens (-) and dots (.) are allowed. The name cannot start with a digit or dot.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the ServiceStage application.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ApplicationState:
    def __init__(__self__, *,
                 component_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationEnvironmentArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Application resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] component_ids: The list of component IDs associated under the application.
        :param pulumi.Input[str] description: Specifies the application description.
               The description can contian a maximum of `128` characters.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise projcet ID to which the application
               belongs. Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationEnvironmentArgs']]] environments: Specifies the configurations of the environment variables.
               The object structure is documented below.
        :param pulumi.Input[str] name: Specifies the variable name. The name can contain `1` to `64` characters, only letters,
               digits, underscores (_), hyphens (-) and dots (.) are allowed. The name cannot start with a digit or dot.
        :param pulumi.Input[str] region: Specifies the region in which to create the ServiceStage application.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        if component_ids is not None:
            pulumi.set(__self__, "component_ids", component_ids)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if environments is not None:
            pulumi.set(__self__, "environments", environments)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="componentIds")
    def component_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of component IDs associated under the application.
        """
        return pulumi.get(self, "component_ids")

    @component_ids.setter
    def component_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "component_ids", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the application description.
        The description can contian a maximum of `128` characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise projcet ID to which the application
        belongs. Changing this will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def environments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationEnvironmentArgs']]]]:
        """
        Specifies the configurations of the environment variables.
        The object structure is documented below.
        """
        return pulumi.get(self, "environments")

    @environments.setter
    def environments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationEnvironmentArgs']]]]):
        pulumi.set(self, "environments", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the variable name. The name can contain `1` to `64` characters, only letters,
        digits, underscores (_), hyphens (-) and dots (.) are allowed. The name cannot start with a digit or dot.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the ServiceStage application.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


class Application(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplicationEnvironmentArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an application resource within HuaweiCloud ServiceStage.

        ## Example Usage
        ### Create an application and an environment variable

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        env_id = config.require_object("envId")
        app_name = config.require_object("appName")
        vpc_id = config.require_object("vpcId")
        test = huaweicloud.service_stage.Application("test", environments=[huaweicloud.service_stage.ApplicationEnvironmentArgs(
            id=env_id,
            variables=[huaweicloud.service_stage.ApplicationEnvironmentVariableArgs(
                name="owner",
                value="terraform",
            )],
        )])
        ```

        ## Import

        Applications can be imported using their `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:ServiceStage/application:Application test eeea08e7-c838-4794-926c-abc12f3e10e8
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Specifies the application description.
               The description can contian a maximum of `128` characters.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise projcet ID to which the application
               belongs. Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplicationEnvironmentArgs']]]] environments: Specifies the configurations of the environment variables.
               The object structure is documented below.
        :param pulumi.Input[str] name: Specifies the variable name. The name can contain `1` to `64` characters, only letters,
               digits, underscores (_), hyphens (-) and dots (.) are allowed. The name cannot start with a digit or dot.
        :param pulumi.Input[str] region: Specifies the region in which to create the ServiceStage application.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ApplicationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an application resource within HuaweiCloud ServiceStage.

        ## Example Usage
        ### Create an application and an environment variable

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        env_id = config.require_object("envId")
        app_name = config.require_object("appName")
        vpc_id = config.require_object("vpcId")
        test = huaweicloud.service_stage.Application("test", environments=[huaweicloud.service_stage.ApplicationEnvironmentArgs(
            id=env_id,
            variables=[huaweicloud.service_stage.ApplicationEnvironmentVariableArgs(
                name="owner",
                value="terraform",
            )],
        )])
        ```

        ## Import

        Applications can be imported using their `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:ServiceStage/application:Application test eeea08e7-c838-4794-926c-abc12f3e10e8
        ```

        :param str resource_name: The name of the resource.
        :param ApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplicationEnvironmentArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationArgs.__new__(ApplicationArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["environments"] = environments
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["component_ids"] = None
        super(Application, __self__).__init__(
            'huaweicloud:ServiceStage/application:Application',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            component_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            environments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplicationEnvironmentArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None) -> 'Application':
        """
        Get an existing Application resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] component_ids: The list of component IDs associated under the application.
        :param pulumi.Input[str] description: Specifies the application description.
               The description can contian a maximum of `128` characters.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise projcet ID to which the application
               belongs. Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplicationEnvironmentArgs']]]] environments: Specifies the configurations of the environment variables.
               The object structure is documented below.
        :param pulumi.Input[str] name: Specifies the variable name. The name can contain `1` to `64` characters, only letters,
               digits, underscores (_), hyphens (-) and dots (.) are allowed. The name cannot start with a digit or dot.
        :param pulumi.Input[str] region: Specifies the region in which to create the ServiceStage application.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationState.__new__(_ApplicationState)

        __props__.__dict__["component_ids"] = component_ids
        __props__.__dict__["description"] = description
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["environments"] = environments
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        return Application(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="componentIds")
    def component_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of component IDs associated under the application.
        """
        return pulumi.get(self, "component_ids")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the application description.
        The description can contian a maximum of `128` characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Specifies the enterprise projcet ID to which the application
        belongs. Changing this will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def environments(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationEnvironment']]]:
        """
        Specifies the configurations of the environment variables.
        The object structure is documented below.
        """
        return pulumi.get(self, "environments")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the variable name. The name can contain `1` to `64` characters, only letters,
        digits, underscores (_), hyphens (-) and dots (.) are allowed. The name cannot start with a digit or dot.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the ServiceStage application.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

