# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetCertificatesResult',
    'AwaitableGetCertificatesResult',
    'get_certificates',
    'get_certificates_output',
]

@pulumi.output_type
class GetCertificatesResult:
    """
    A collection of values returned by getCertificates.
    """
    def __init__(__self__, certificates=None, deploy_support=None, enterprise_project_id=None, id=None, name=None, region=None, status=None):
        if certificates and not isinstance(certificates, list):
            raise TypeError("Expected argument 'certificates' to be a list")
        pulumi.set(__self__, "certificates", certificates)
        if deploy_support and not isinstance(deploy_support, bool):
            raise TypeError("Expected argument 'deploy_support' to be a bool")
        pulumi.set(__self__, "deploy_support", deploy_support)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def certificates(self) -> Sequence['outputs.GetCertificatesCertificateResult']:
        """
        Certificate list. For details, see Data structure of the Certificate field.
        The Certificate structure is documented below.
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter(name="deploySupport")
    def deploy_support(self) -> Optional[bool]:
        """
        Whether to support deployment.
        """
        return pulumi.get(self, "deploy_support")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[str]:
        """
        The enterprise project id of the project.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Certificate name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Certificate status.  
        The options are as follows:
        - ALL: All certificate status.
        - PAID: The certificate has been paid and needs to be applied for from the CA.
        - ISSUED: The certificate has been issued.
        - CHECKING: The certificate application is being reviewed.
        - CANCELCHECKING: The certificate application cancellation is being reviewed.
        - UNPASSED: The certificate application fails.
        - EXPIRED: The certificate has expired.
        - REVOKING: The certificate revocation application is being reviewed.
        - REVOKED: The certificate has been revoked.
        - UPLOAD: The certificate is being managed.
        - CHECKING_ORG: The organization verification is to be completed.
        - ISSUING: The certificate is to be issued.
        - SUPPLEMENTCHECKING: Additional domain names to be added for a multi-domain certificate are being reviewed.
        """
        return pulumi.get(self, "status")


class AwaitableGetCertificatesResult(GetCertificatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificatesResult(
            certificates=self.certificates,
            deploy_support=self.deploy_support,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            name=self.name,
            region=self.region,
            status=self.status)


def get_certificates(deploy_support: Optional[bool] = None,
                     enterprise_project_id: Optional[str] = None,
                     name: Optional[str] = None,
                     region: Optional[str] = None,
                     status: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificatesResult:
    """
    Use this data source to get the list of SCM certificates.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    test = huaweicloud.Scm.get_certificates(status="ALL")
    ```


    :param bool deploy_support: Whether to support deployment.
    :param str enterprise_project_id: The enterprise project id of the project.
    :param str name: Certificate name.
    :param str region: Specifies the region in which to query the data source.
           If omitted, the provider-level region will be used.
    :param str status: Certificate status.  
           The options are as follows:
           - ALL: All certificate status.
           - PAID: The certificate has been paid and needs to be applied for from the CA.
           - ISSUED: The certificate has been issued.
           - CHECKING: The certificate application is being reviewed.
           - CANCELCHECKING: The certificate application cancellation is being reviewed.
           - UNPASSED: The certificate application fails.
           - EXPIRED: The certificate has expired.
           - REVOKING: The certificate revocation application is being reviewed.
           - REVOKED: The certificate has been revoked.
           - UPLOAD: The certificate is being managed.
           - CHECKING_ORG: The organization verification is to be completed.
           - ISSUING: The certificate is to be issued.
           - SUPPLEMENTCHECKING: Additional domain names to be added for a multi-domain certificate are being reviewed.
    """
    __args__ = dict()
    __args__['deploySupport'] = deploy_support
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Scm/getCertificates:getCertificates', __args__, opts=opts, typ=GetCertificatesResult).value

    return AwaitableGetCertificatesResult(
        certificates=__ret__.certificates,
        deploy_support=__ret__.deploy_support,
        enterprise_project_id=__ret__.enterprise_project_id,
        id=__ret__.id,
        name=__ret__.name,
        region=__ret__.region,
        status=__ret__.status)


@_utilities.lift_output_func(get_certificates)
def get_certificates_output(deploy_support: Optional[pulumi.Input[Optional[bool]]] = None,
                            enterprise_project_id: Optional[pulumi.Input[Optional[str]]] = None,
                            name: Optional[pulumi.Input[Optional[str]]] = None,
                            region: Optional[pulumi.Input[Optional[str]]] = None,
                            status: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCertificatesResult]:
    """
    Use this data source to get the list of SCM certificates.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    test = huaweicloud.Scm.get_certificates(status="ALL")
    ```


    :param bool deploy_support: Whether to support deployment.
    :param str enterprise_project_id: The enterprise project id of the project.
    :param str name: Certificate name.
    :param str region: Specifies the region in which to query the data source.
           If omitted, the provider-level region will be used.
    :param str status: Certificate status.  
           The options are as follows:
           - ALL: All certificate status.
           - PAID: The certificate has been paid and needs to be applied for from the CA.
           - ISSUED: The certificate has been issued.
           - CHECKING: The certificate application is being reviewed.
           - CANCELCHECKING: The certificate application cancellation is being reviewed.
           - UNPASSED: The certificate application fails.
           - EXPIRED: The certificate has expired.
           - REVOKING: The certificate revocation application is being reviewed.
           - REVOKED: The certificate has been revoked.
           - UPLOAD: The certificate is being managed.
           - CHECKING_ORG: The organization verification is to be completed.
           - ISSUING: The certificate is to be issued.
           - SUPPLEMENTCHECKING: Additional domain names to be added for a multi-domain certificate are being reviewed.
    """
    ...
