# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 certificate: pulumi.Input[str],
                 certificate_chain: pulumi.Input[str],
                 private_key: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateTargetArgs']]]] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input[str] certificate: The public encrypted key of the Certificate, PEM format.
        :param pulumi.Input[str] certificate_chain: The chain of the certificate.
               It can be extracted from the *server.crt* file in the Nginx directory,
               usually after the second paragraph is the certificate chain.
        :param pulumi.Input[str] private_key: The private encrypted key of the Certificate, PEM format.
        :param pulumi.Input[str] name: Human-readable name for the Certificate.
               Does not have to be unique. The value contains a maximum of 63 characters.
        :param pulumi.Input[str] region: The region in which to create the SCM certificate resource.
               If omitted, the provider-level region will be used.
               Changing this setting will push a new certificate.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateTargetArgs']]] targets: The service to which the certificate needs to be pushed.
        """
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "certificate_chain", certificate_chain)
        pulumi.set(__self__, "private_key", private_key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Input[str]:
        """
        The public encrypted key of the Certificate, PEM format.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> pulumi.Input[str]:
        """
        The chain of the certificate.
        It can be extracted from the *server.crt* file in the Nginx directory,
        usually after the second paragraph is the certificate chain.
        """
        return pulumi.get(self, "certificate_chain")

    @certificate_chain.setter
    def certificate_chain(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_chain", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Input[str]:
        """
        The private encrypted key of the Certificate, PEM format.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name for the Certificate.
        Does not have to be unique. The value contains a maximum of 63 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the SCM certificate resource.
        If omitted, the provider-level region will be used.
        Changing this setting will push a new certificate.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateTargetArgs']]]]:
        """
        The service to which the certificate needs to be pushed.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateTargetArgs']]]]):
        pulumi.set(self, "targets", value)


@pulumi.input_type
class _CertificateState:
    def __init__(__self__, *,
                 authentifications: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthentificationArgs']]]] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 certificate_chain: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 domain_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 not_after: Optional[pulumi.Input[str]] = None,
                 not_before: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 push_support: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateTargetArgs']]]] = None):
        """
        Input properties used for looking up and filtering Certificate resources.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateAuthentificationArgs']]] authentifications: (List) Domain ownership verification information.
               This is a list, each item of data is as follows:
        :param pulumi.Input[str] certificate: The public encrypted key of the Certificate, PEM format.
        :param pulumi.Input[str] certificate_chain: The chain of the certificate.
               It can be extracted from the *server.crt* file in the Nginx directory,
               usually after the second paragraph is the certificate chain.
        :param pulumi.Input[str] domain: Domain name mapping to the verification value
        :param pulumi.Input[int] domain_count: Number of domain names can be bound to a certificate.
        :param pulumi.Input[str] name: Human-readable name for the Certificate.
               Does not have to be unique. The value contains a maximum of 63 characters.
        :param pulumi.Input[str] not_after: Time when the certificate becomes invalid. If no valid value is obtained, this parameter is left blank.
        :param pulumi.Input[str] not_before: Time when the certificate takes effect. If no valid value is obtained, this parameter is left blank.
        :param pulumi.Input[str] private_key: The private encrypted key of the Certificate, PEM format.
        :param pulumi.Input[str] push_support: Whether a certificate can be pushed.
        :param pulumi.Input[str] region: The region in which to create the SCM certificate resource.
               If omitted, the provider-level region will be used.
               Changing this setting will push a new certificate.
        :param pulumi.Input[str] status: Certificate status. The value can be:
        :param pulumi.Input[Sequence[pulumi.Input['CertificateTargetArgs']]] targets: The service to which the certificate needs to be pushed.
        """
        if authentifications is not None:
            pulumi.set(__self__, "authentifications", authentifications)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_chain is not None:
            pulumi.set(__self__, "certificate_chain", certificate_chain)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if domain_count is not None:
            pulumi.set(__self__, "domain_count", domain_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if not_after is not None:
            pulumi.set(__self__, "not_after", not_after)
        if not_before is not None:
            pulumi.set(__self__, "not_before", not_before)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if push_support is not None:
            pulumi.set(__self__, "push_support", push_support)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter
    def authentifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthentificationArgs']]]]:
        """
        (List) Domain ownership verification information.
        This is a list, each item of data is as follows:
        """
        return pulumi.get(self, "authentifications")

    @authentifications.setter
    def authentifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthentificationArgs']]]]):
        pulumi.set(self, "authentifications", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The public encrypted key of the Certificate, PEM format.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> Optional[pulumi.Input[str]]:
        """
        The chain of the certificate.
        It can be extracted from the *server.crt* file in the Nginx directory,
        usually after the second paragraph is the certificate chain.
        """
        return pulumi.get(self, "certificate_chain")

    @certificate_chain.setter
    def certificate_chain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_chain", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        Domain name mapping to the verification value
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="domainCount")
    def domain_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of domain names can be bound to a certificate.
        """
        return pulumi.get(self, "domain_count")

    @domain_count.setter
    def domain_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "domain_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name for the Certificate.
        Does not have to be unique. The value contains a maximum of 63 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notAfter")
    def not_after(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the certificate becomes invalid. If no valid value is obtained, this parameter is left blank.
        """
        return pulumi.get(self, "not_after")

    @not_after.setter
    def not_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "not_after", value)

    @property
    @pulumi.getter(name="notBefore")
    def not_before(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the certificate takes effect. If no valid value is obtained, this parameter is left blank.
        """
        return pulumi.get(self, "not_before")

    @not_before.setter
    def not_before(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "not_before", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        The private encrypted key of the Certificate, PEM format.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="pushSupport")
    def push_support(self) -> Optional[pulumi.Input[str]]:
        """
        Whether a certificate can be pushed.
        """
        return pulumi.get(self, "push_support")

    @push_support.setter
    def push_support(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "push_support", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the SCM certificate resource.
        If omitted, the provider-level region will be used.
        Changing this setting will push a new certificate.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate status. The value can be:
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateTargetArgs']]]]:
        """
        The service to which the certificate needs to be pushed.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateTargetArgs']]]]):
        pulumi.set(self, "targets", value)


class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 certificate_chain: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateTargetArgs']]]]] = None,
                 __props__=None):
        """
        SSL Certificate Manager (SCM) allows you to purchase Secure Sockets Layer (SSL) certificates from the world's leading
        digital certificate authorities (CAs), upload existing SSL certificates, and centrally manage all your SSL certificates
        in one place.

        ## Example Usage
        ### Load the certificate contents from the local files

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        certificate1 = huaweicloud.scm.Certificate("certificate1",
            certificate=(lambda path: open(path).read())("/usr/local/data/certificate/cert_xxx/xxx_ca.crt"),
            certificate_chain=(lambda path: open(path).read())("/usr/local/data/certificate/cert_xxx/xxx_ca_chain.crt"),
            private_key=(lambda path: open(path).read())("/usr/local/data/certificate/cert_xxx/xxx_server.key"))
        ```
        ### Write the contents of the certificate into the Terrafrom script

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        certificate2 = huaweicloud.scm.Certificate("certificate2",
            certificate=\"\"\"-----BEGIN CERTIFICATE-----
        MIIC9DCCAl2gAwIBAgIUUcJZn3ep4l8iHu6lL/jE2UV+G8gwDQYJKoZIhvcNAQEL
        ZWlqaW5nMQswC...
        (This is an example, please replace it with a encrypted key of valid SSL certificate.)
        -----END CERTIFICATE----------

        \"\"\",
            certificate_chain=\"\"\"-----BEGIN CERTIFICATE-----
        MIIC9DCCAl2gAwIBAgIUUcJZn3ep4l8iHu6lL/jE2UV+G8gwDQYJKoZIhvcNAQEL
        BQAwgYsxCzAJB...
        (This is an example, please replace it with a encrypted key of valid SSL certificate.)
        -----END CERTIFICATE----------

        \"\"\",
            private_key=\"\"\"-----BEGIN PRIVATE KEY-----
        QWH3GbHx5bGQyexHj2hre4yEahn4dAKKdjSAMUuSfLWygp2pEdNFOegYTdqk/snv
        mhNmxp74oUcVfi1Msw6KY2...
        (This is an example, please replace it with a encrypted key of valid SSL certificate.)
        -----END PRIVATE KEY-----

        \"\"\")
        ```
        ### Push the SSL certificate to another HUAWEI CLOUD service

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        # Load the certificate contents from the local files.
        certificate3 = huaweicloud.scm.Certificate("certificate3",
            certificate=(lambda path: open(path).read())("/usr/local/data/certificate/cert_xxx/xxx_ca.crt"),
            certificate_chain=(lambda path: open(path).read())("/usr/local/data/certificate/cert_xxx/xxx_ca_chain.crt"),
            private_key=(lambda path: open(path).read())("/usr/local/data/certificate/cert_xxx/xxx_server.key"),
            targets=[
                huaweicloud.scm.CertificateTargetArgs(
                    projects=["la-south-2"],
                    service="Enhance_ELB",
                ),
                huaweicloud.scm.CertificateTargetArgs(
                    service="CDN",
                ),
            ])
        ```

        ## Import

        Certificates can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Scm/certificate:Certificate certificate_1 scs1627959834994
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate: The public encrypted key of the Certificate, PEM format.
        :param pulumi.Input[str] certificate_chain: The chain of the certificate.
               It can be extracted from the *server.crt* file in the Nginx directory,
               usually after the second paragraph is the certificate chain.
        :param pulumi.Input[str] name: Human-readable name for the Certificate.
               Does not have to be unique. The value contains a maximum of 63 characters.
        :param pulumi.Input[str] private_key: The private encrypted key of the Certificate, PEM format.
        :param pulumi.Input[str] region: The region in which to create the SCM certificate resource.
               If omitted, the provider-level region will be used.
               Changing this setting will push a new certificate.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateTargetArgs']]]] targets: The service to which the certificate needs to be pushed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        SSL Certificate Manager (SCM) allows you to purchase Secure Sockets Layer (SSL) certificates from the world's leading
        digital certificate authorities (CAs), upload existing SSL certificates, and centrally manage all your SSL certificates
        in one place.

        ## Example Usage
        ### Load the certificate contents from the local files

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        certificate1 = huaweicloud.scm.Certificate("certificate1",
            certificate=(lambda path: open(path).read())("/usr/local/data/certificate/cert_xxx/xxx_ca.crt"),
            certificate_chain=(lambda path: open(path).read())("/usr/local/data/certificate/cert_xxx/xxx_ca_chain.crt"),
            private_key=(lambda path: open(path).read())("/usr/local/data/certificate/cert_xxx/xxx_server.key"))
        ```
        ### Write the contents of the certificate into the Terrafrom script

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        certificate2 = huaweicloud.scm.Certificate("certificate2",
            certificate=\"\"\"-----BEGIN CERTIFICATE-----
        MIIC9DCCAl2gAwIBAgIUUcJZn3ep4l8iHu6lL/jE2UV+G8gwDQYJKoZIhvcNAQEL
        ZWlqaW5nMQswC...
        (This is an example, please replace it with a encrypted key of valid SSL certificate.)
        -----END CERTIFICATE----------

        \"\"\",
            certificate_chain=\"\"\"-----BEGIN CERTIFICATE-----
        MIIC9DCCAl2gAwIBAgIUUcJZn3ep4l8iHu6lL/jE2UV+G8gwDQYJKoZIhvcNAQEL
        BQAwgYsxCzAJB...
        (This is an example, please replace it with a encrypted key of valid SSL certificate.)
        -----END CERTIFICATE----------

        \"\"\",
            private_key=\"\"\"-----BEGIN PRIVATE KEY-----
        QWH3GbHx5bGQyexHj2hre4yEahn4dAKKdjSAMUuSfLWygp2pEdNFOegYTdqk/snv
        mhNmxp74oUcVfi1Msw6KY2...
        (This is an example, please replace it with a encrypted key of valid SSL certificate.)
        -----END PRIVATE KEY-----

        \"\"\")
        ```
        ### Push the SSL certificate to another HUAWEI CLOUD service

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        # Load the certificate contents from the local files.
        certificate3 = huaweicloud.scm.Certificate("certificate3",
            certificate=(lambda path: open(path).read())("/usr/local/data/certificate/cert_xxx/xxx_ca.crt"),
            certificate_chain=(lambda path: open(path).read())("/usr/local/data/certificate/cert_xxx/xxx_ca_chain.crt"),
            private_key=(lambda path: open(path).read())("/usr/local/data/certificate/cert_xxx/xxx_server.key"),
            targets=[
                huaweicloud.scm.CertificateTargetArgs(
                    projects=["la-south-2"],
                    service="Enhance_ELB",
                ),
                huaweicloud.scm.CertificateTargetArgs(
                    service="CDN",
                ),
            ])
        ```

        ## Import

        Certificates can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Scm/certificate:Certificate certificate_1 scs1627959834994
        ```

        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 certificate_chain: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateTargetArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            if certificate is None and not opts.urn:
                raise TypeError("Missing required property 'certificate'")
            __props__.__dict__["certificate"] = certificate
            if certificate_chain is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_chain'")
            __props__.__dict__["certificate_chain"] = certificate_chain
            __props__.__dict__["name"] = name
            if private_key is None and not opts.urn:
                raise TypeError("Missing required property 'private_key'")
            __props__.__dict__["private_key"] = private_key
            __props__.__dict__["region"] = region
            __props__.__dict__["targets"] = targets
            __props__.__dict__["authentifications"] = None
            __props__.__dict__["domain"] = None
            __props__.__dict__["domain_count"] = None
            __props__.__dict__["not_after"] = None
            __props__.__dict__["not_before"] = None
            __props__.__dict__["push_support"] = None
            __props__.__dict__["status"] = None
        super(Certificate, __self__).__init__(
            'huaweicloud:Scm/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentifications: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateAuthentificationArgs']]]]] = None,
            certificate: Optional[pulumi.Input[str]] = None,
            certificate_chain: Optional[pulumi.Input[str]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            domain_count: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            not_after: Optional[pulumi.Input[str]] = None,
            not_before: Optional[pulumi.Input[str]] = None,
            private_key: Optional[pulumi.Input[str]] = None,
            push_support: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            targets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateTargetArgs']]]]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateAuthentificationArgs']]]] authentifications: (List) Domain ownership verification information.
               This is a list, each item of data is as follows:
        :param pulumi.Input[str] certificate: The public encrypted key of the Certificate, PEM format.
        :param pulumi.Input[str] certificate_chain: The chain of the certificate.
               It can be extracted from the *server.crt* file in the Nginx directory,
               usually after the second paragraph is the certificate chain.
        :param pulumi.Input[str] domain: Domain name mapping to the verification value
        :param pulumi.Input[int] domain_count: Number of domain names can be bound to a certificate.
        :param pulumi.Input[str] name: Human-readable name for the Certificate.
               Does not have to be unique. The value contains a maximum of 63 characters.
        :param pulumi.Input[str] not_after: Time when the certificate becomes invalid. If no valid value is obtained, this parameter is left blank.
        :param pulumi.Input[str] not_before: Time when the certificate takes effect. If no valid value is obtained, this parameter is left blank.
        :param pulumi.Input[str] private_key: The private encrypted key of the Certificate, PEM format.
        :param pulumi.Input[str] push_support: Whether a certificate can be pushed.
        :param pulumi.Input[str] region: The region in which to create the SCM certificate resource.
               If omitted, the provider-level region will be used.
               Changing this setting will push a new certificate.
        :param pulumi.Input[str] status: Certificate status. The value can be:
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateTargetArgs']]]] targets: The service to which the certificate needs to be pushed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateState.__new__(_CertificateState)

        __props__.__dict__["authentifications"] = authentifications
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["certificate_chain"] = certificate_chain
        __props__.__dict__["domain"] = domain
        __props__.__dict__["domain_count"] = domain_count
        __props__.__dict__["name"] = name
        __props__.__dict__["not_after"] = not_after
        __props__.__dict__["not_before"] = not_before
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["push_support"] = push_support
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["targets"] = targets
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def authentifications(self) -> pulumi.Output[Sequence['outputs.CertificateAuthentification']]:
        """
        (List) Domain ownership verification information.
        This is a list, each item of data is as follows:
        """
        return pulumi.get(self, "authentifications")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[str]:
        """
        The public encrypted key of the Certificate, PEM format.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> pulumi.Output[str]:
        """
        The chain of the certificate.
        It can be extracted from the *server.crt* file in the Nginx directory,
        usually after the second paragraph is the certificate chain.
        """
        return pulumi.get(self, "certificate_chain")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        Domain name mapping to the verification value
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="domainCount")
    def domain_count(self) -> pulumi.Output[int]:
        """
        Number of domain names can be bound to a certificate.
        """
        return pulumi.get(self, "domain_count")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Human-readable name for the Certificate.
        Does not have to be unique. The value contains a maximum of 63 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notAfter")
    def not_after(self) -> pulumi.Output[str]:
        """
        Time when the certificate becomes invalid. If no valid value is obtained, this parameter is left blank.
        """
        return pulumi.get(self, "not_after")

    @property
    @pulumi.getter(name="notBefore")
    def not_before(self) -> pulumi.Output[str]:
        """
        Time when the certificate takes effect. If no valid value is obtained, this parameter is left blank.
        """
        return pulumi.get(self, "not_before")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[str]:
        """
        The private encrypted key of the Certificate, PEM format.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="pushSupport")
    def push_support(self) -> pulumi.Output[str]:
        """
        Whether a certificate can be pushed.
        """
        return pulumi.get(self, "push_support")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the SCM certificate resource.
        If omitted, the provider-level region will be used.
        Changing this setting will push a new certificate.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Certificate status. The value can be:
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def targets(self) -> pulumi.Output[Optional[Sequence['outputs.CertificateTarget']]]:
        """
        The service to which the certificate needs to be pushed.
        """
        return pulumi.get(self, "targets")

