# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEngineVersionsResult',
    'AwaitableGetEngineVersionsResult',
    'get_engine_versions',
    'get_engine_versions_output',
]

@pulumi.output_type
class GetEngineVersionsResult:
    """
    A collection of values returned by getEngineVersions.
    """
    def __init__(__self__, id=None, region=None, type=None, versions=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if versions and not isinstance(versions, list):
            raise TypeError("Expected argument 'versions' to be a list")
        pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def versions(self) -> Optional[Sequence['outputs.GetEngineVersionsVersionResult']]:
        """
        List of RDS versions. Structure is documented below.
        """
        return pulumi.get(self, "versions")


class AwaitableGetEngineVersionsResult(GetEngineVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEngineVersionsResult(
            id=self.id,
            region=self.region,
            type=self.type,
            versions=self.versions)


def get_engine_versions(region: Optional[str] = None,
                        type: Optional[str] = None,
                        versions: Optional[Sequence[pulumi.InputType['GetEngineVersionsVersionArgs']]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEngineVersionsResult:
    """
    Use this data source to obtain all version information of the specified engine type of HuaweiCloud RDS.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    test = huaweicloud.Rds.get_engine_versions(type="SQLServer")
    ```


    :param str region: The region in which to obtain the RDS engine versions.
           If omitted, the provider-level region will be used.
    :param str type: Specifies the RDS engine type.
           The valid values are **MySQL**, **PostgreSQL** and **SQLServer**, default to **MySQL**.
    :param Sequence[pulumi.InputType['GetEngineVersionsVersionArgs']] versions: List of RDS versions. Structure is documented below.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['type'] = type
    __args__['versions'] = versions
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Rds/getEngineVersions:getEngineVersions', __args__, opts=opts, typ=GetEngineVersionsResult).value

    return AwaitableGetEngineVersionsResult(
        id=__ret__.id,
        region=__ret__.region,
        type=__ret__.type,
        versions=__ret__.versions)


@_utilities.lift_output_func(get_engine_versions)
def get_engine_versions_output(region: Optional[pulumi.Input[Optional[str]]] = None,
                               type: Optional[pulumi.Input[Optional[str]]] = None,
                               versions: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetEngineVersionsVersionArgs']]]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEngineVersionsResult]:
    """
    Use this data source to obtain all version information of the specified engine type of HuaweiCloud RDS.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    test = huaweicloud.Rds.get_engine_versions(type="SQLServer")
    ```


    :param str region: The region in which to obtain the RDS engine versions.
           If omitted, the provider-level region will be used.
    :param str type: Specifies the RDS engine type.
           The valid values are **MySQL**, **PostgreSQL** and **SQLServer**, default to **MySQL**.
    :param Sequence[pulumi.InputType['GetEngineVersionsVersionArgs']] versions: List of RDS versions. Structure is documented below.
    """
    ...
