# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from ._inputs import *

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[str]] = None,
                 agency_domain_name: Optional[pulumi.Input[str]] = None,
                 agency_name: Optional[pulumi.Input[str]] = None,
                 assume_role: Optional[pulumi.Input['ProviderAssumeRoleArgs']] = None,
                 auth_url: Optional[pulumi.Input[str]] = None,
                 cacert_file: Optional[pulumi.Input[str]] = None,
                 cert: Optional[pulumi.Input[str]] = None,
                 cloud: Optional[pulumi.Input[str]] = None,
                 delegated_project: Optional[pulumi.Input[str]] = None,
                 domain_id: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 endpoints: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 insecure: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 security_token: Optional[pulumi.Input[str]] = None,
                 shared_config_file: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 tenant_name: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[str] access_key: The access key of the HuaweiCloud to use.
        :param pulumi.Input[str] agency_domain_name: The name of domain who created the agency (Identity v3).
        :param pulumi.Input[str] agency_name: The name of agency
        :param pulumi.Input[str] auth_url: The Identity authentication URL.
        :param pulumi.Input[str] cacert_file: A Custom CA certificate.
        :param pulumi.Input[str] cert: A client certificate to authenticate with.
        :param pulumi.Input[str] cloud: The endpoint of cloud provider, defaults to myhuaweicloud.com
        :param pulumi.Input[str] delegated_project: The name of delegated project (Identity v3).
        :param pulumi.Input[str] domain_id: The ID of the Domain to scope to.
        :param pulumi.Input[str] domain_name: The name of the Domain to scope to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] endpoints: The custom endpoints used to override the default endpoint URL.
        :param pulumi.Input[str] enterprise_project_id: enterprise project id
        :param pulumi.Input[bool] insecure: Trust self-signed certificates.
        :param pulumi.Input[str] key: A client private key to authenticate with.
        :param pulumi.Input[int] max_retries: How many times HTTP connection should be retried until giving up.
        :param pulumi.Input[str] password: Password to login with.
        :param pulumi.Input[str] profile: The profile name as set in the shared config file.
        :param pulumi.Input[str] project_id: The ID of the project to login with.
        :param pulumi.Input[str] project_name: The name of the project to login with.
        :param pulumi.Input[str] region: The HuaweiCloud region to connect to.
        :param pulumi.Input[str] secret_key: The secret key of the HuaweiCloud to use.
        :param pulumi.Input[str] security_token: The security token to authenticate with a temporary security credential.
        :param pulumi.Input[str] shared_config_file: The path to the shared config file. If not set, the default is ~/.hcloud/config.json.
        :param pulumi.Input[str] tenant_id: The ID of the Tenant (Identity v2) to login with.
        :param pulumi.Input[str] tenant_name: The name of the Tenant (Identity v2) to login with.
        :param pulumi.Input[str] token: Authentication token to use as an alternative to username/password.
        :param pulumi.Input[str] user_id: User ID to login with.
        :param pulumi.Input[str] user_name: Username to login with.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if agency_domain_name is not None:
            pulumi.set(__self__, "agency_domain_name", agency_domain_name)
        if agency_name is not None:
            pulumi.set(__self__, "agency_name", agency_name)
        if assume_role is not None:
            pulumi.set(__self__, "assume_role", assume_role)
        if auth_url is not None:
            pulumi.set(__self__, "auth_url", auth_url)
        if cacert_file is not None:
            pulumi.set(__self__, "cacert_file", cacert_file)
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if delegated_project is not None:
            pulumi.set(__self__, "delegated_project", delegated_project)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if security_token is not None:
            pulumi.set(__self__, "security_token", security_token)
        if shared_config_file is not None:
            pulumi.set(__self__, "shared_config_file", shared_config_file)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if tenant_name is not None:
            pulumi.set(__self__, "tenant_name", tenant_name)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[str]]:
        """
        The access key of the HuaweiCloud to use.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter(name="agencyDomainName")
    def agency_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of domain who created the agency (Identity v3).
        """
        return pulumi.get(self, "agency_domain_name")

    @agency_domain_name.setter
    def agency_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agency_domain_name", value)

    @property
    @pulumi.getter(name="agencyName")
    def agency_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of agency
        """
        return pulumi.get(self, "agency_name")

    @agency_name.setter
    def agency_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agency_name", value)

    @property
    @pulumi.getter(name="assumeRole")
    def assume_role(self) -> Optional[pulumi.Input['ProviderAssumeRoleArgs']]:
        return pulumi.get(self, "assume_role")

    @assume_role.setter
    def assume_role(self, value: Optional[pulumi.Input['ProviderAssumeRoleArgs']]):
        pulumi.set(self, "assume_role", value)

    @property
    @pulumi.getter(name="authUrl")
    def auth_url(self) -> Optional[pulumi.Input[str]]:
        """
        The Identity authentication URL.
        """
        return pulumi.get(self, "auth_url")

    @auth_url.setter
    def auth_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_url", value)

    @property
    @pulumi.getter(name="cacertFile")
    def cacert_file(self) -> Optional[pulumi.Input[str]]:
        """
        A Custom CA certificate.
        """
        return pulumi.get(self, "cacert_file")

    @cacert_file.setter
    def cacert_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cacert_file", value)

    @property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[str]]:
        """
        A client certificate to authenticate with.
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert", value)

    @property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint of cloud provider, defaults to myhuaweicloud.com
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud", value)

    @property
    @pulumi.getter(name="delegatedProject")
    def delegated_project(self) -> Optional[pulumi.Input[str]]:
        """
        The name of delegated project (Identity v3).
        """
        return pulumi.get(self, "delegated_project")

    @delegated_project.setter
    def delegated_project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delegated_project", value)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Domain to scope to.
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_id", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Domain to scope to.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The custom endpoints used to override the default endpoint URL.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        enterprise project id
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def insecure(self) -> Optional[pulumi.Input[bool]]:
        """
        Trust self-signed certificates.
        """
        return pulumi.get(self, "insecure")

    @insecure.setter
    def insecure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "insecure", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        A client private key to authenticate with.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[int]]:
        """
        How many times HTTP connection should be retried until giving up.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password to login with.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[str]]:
        """
        The profile name as set in the shared config file.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project to login with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the project to login with.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The HuaweiCloud region to connect to.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        The secret key of the HuaweiCloud to use.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter(name="securityToken")
    def security_token(self) -> Optional[pulumi.Input[str]]:
        """
        The security token to authenticate with a temporary security credential.
        """
        return pulumi.get(self, "security_token")

    @security_token.setter
    def security_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_token", value)

    @property
    @pulumi.getter(name="sharedConfigFile")
    def shared_config_file(self) -> Optional[pulumi.Input[str]]:
        """
        The path to the shared config file. If not set, the default is ~/.hcloud/config.json.
        """
        return pulumi.get(self, "shared_config_file")

    @shared_config_file.setter
    def shared_config_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_config_file", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Tenant (Identity v2) to login with.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="tenantName")
    def tenant_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Tenant (Identity v2) to login with.
        """
        return pulumi.get(self, "tenant_name")

    @tenant_name.setter
    def tenant_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_name", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        Authentication token to use as an alternative to username/password.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        User ID to login with.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Username to login with.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[str]] = None,
                 agency_domain_name: Optional[pulumi.Input[str]] = None,
                 agency_name: Optional[pulumi.Input[str]] = None,
                 assume_role: Optional[pulumi.Input[pulumi.InputType['ProviderAssumeRoleArgs']]] = None,
                 auth_url: Optional[pulumi.Input[str]] = None,
                 cacert_file: Optional[pulumi.Input[str]] = None,
                 cert: Optional[pulumi.Input[str]] = None,
                 cloud: Optional[pulumi.Input[str]] = None,
                 delegated_project: Optional[pulumi.Input[str]] = None,
                 domain_id: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 endpoints: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 insecure: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 security_token: Optional[pulumi.Input[str]] = None,
                 shared_config_file: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 tenant_name: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The provider type for the huaweicloud package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_key: The access key of the HuaweiCloud to use.
        :param pulumi.Input[str] agency_domain_name: The name of domain who created the agency (Identity v3).
        :param pulumi.Input[str] agency_name: The name of agency
        :param pulumi.Input[str] auth_url: The Identity authentication URL.
        :param pulumi.Input[str] cacert_file: A Custom CA certificate.
        :param pulumi.Input[str] cert: A client certificate to authenticate with.
        :param pulumi.Input[str] cloud: The endpoint of cloud provider, defaults to myhuaweicloud.com
        :param pulumi.Input[str] delegated_project: The name of delegated project (Identity v3).
        :param pulumi.Input[str] domain_id: The ID of the Domain to scope to.
        :param pulumi.Input[str] domain_name: The name of the Domain to scope to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] endpoints: The custom endpoints used to override the default endpoint URL.
        :param pulumi.Input[str] enterprise_project_id: enterprise project id
        :param pulumi.Input[bool] insecure: Trust self-signed certificates.
        :param pulumi.Input[str] key: A client private key to authenticate with.
        :param pulumi.Input[int] max_retries: How many times HTTP connection should be retried until giving up.
        :param pulumi.Input[str] password: Password to login with.
        :param pulumi.Input[str] profile: The profile name as set in the shared config file.
        :param pulumi.Input[str] project_id: The ID of the project to login with.
        :param pulumi.Input[str] project_name: The name of the project to login with.
        :param pulumi.Input[str] region: The HuaweiCloud region to connect to.
        :param pulumi.Input[str] secret_key: The secret key of the HuaweiCloud to use.
        :param pulumi.Input[str] security_token: The security token to authenticate with a temporary security credential.
        :param pulumi.Input[str] shared_config_file: The path to the shared config file. If not set, the default is ~/.hcloud/config.json.
        :param pulumi.Input[str] tenant_id: The ID of the Tenant (Identity v2) to login with.
        :param pulumi.Input[str] tenant_name: The name of the Tenant (Identity v2) to login with.
        :param pulumi.Input[str] token: Authentication token to use as an alternative to username/password.
        :param pulumi.Input[str] user_id: User ID to login with.
        :param pulumi.Input[str] user_name: Username to login with.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the huaweicloud package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[str]] = None,
                 agency_domain_name: Optional[pulumi.Input[str]] = None,
                 agency_name: Optional[pulumi.Input[str]] = None,
                 assume_role: Optional[pulumi.Input[pulumi.InputType['ProviderAssumeRoleArgs']]] = None,
                 auth_url: Optional[pulumi.Input[str]] = None,
                 cacert_file: Optional[pulumi.Input[str]] = None,
                 cert: Optional[pulumi.Input[str]] = None,
                 cloud: Optional[pulumi.Input[str]] = None,
                 delegated_project: Optional[pulumi.Input[str]] = None,
                 domain_id: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 endpoints: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 insecure: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 security_token: Optional[pulumi.Input[str]] = None,
                 shared_config_file: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 tenant_name: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["access_key"] = access_key
            __props__.__dict__["agency_domain_name"] = agency_domain_name
            __props__.__dict__["agency_name"] = agency_name
            __props__.__dict__["assume_role"] = pulumi.Output.from_input(assume_role).apply(pulumi.runtime.to_json) if assume_role is not None else None
            __props__.__dict__["auth_url"] = auth_url
            __props__.__dict__["cacert_file"] = cacert_file
            __props__.__dict__["cert"] = cert
            __props__.__dict__["cloud"] = cloud
            __props__.__dict__["delegated_project"] = delegated_project
            __props__.__dict__["domain_id"] = domain_id
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["endpoints"] = pulumi.Output.from_input(endpoints).apply(pulumi.runtime.to_json) if endpoints is not None else None
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["insecure"] = pulumi.Output.from_input(insecure).apply(pulumi.runtime.to_json) if insecure is not None else None
            __props__.__dict__["key"] = key
            __props__.__dict__["max_retries"] = pulumi.Output.from_input(max_retries).apply(pulumi.runtime.to_json) if max_retries is not None else None
            __props__.__dict__["password"] = password
            __props__.__dict__["profile"] = profile
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["region"] = region
            __props__.__dict__["secret_key"] = secret_key
            __props__.__dict__["security_token"] = security_token
            __props__.__dict__["shared_config_file"] = shared_config_file
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["tenant_name"] = tenant_name
            __props__.__dict__["token"] = token
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["user_name"] = user_name
        super(Provider, __self__).__init__(
            'huaweicloud',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[Optional[str]]:
        """
        The access key of the HuaweiCloud to use.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="agencyDomainName")
    def agency_domain_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of domain who created the agency (Identity v3).
        """
        return pulumi.get(self, "agency_domain_name")

    @property
    @pulumi.getter(name="agencyName")
    def agency_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of agency
        """
        return pulumi.get(self, "agency_name")

    @property
    @pulumi.getter(name="authUrl")
    def auth_url(self) -> pulumi.Output[Optional[str]]:
        """
        The Identity authentication URL.
        """
        return pulumi.get(self, "auth_url")

    @property
    @pulumi.getter(name="cacertFile")
    def cacert_file(self) -> pulumi.Output[Optional[str]]:
        """
        A Custom CA certificate.
        """
        return pulumi.get(self, "cacert_file")

    @property
    @pulumi.getter
    def cert(self) -> pulumi.Output[Optional[str]]:
        """
        A client certificate to authenticate with.
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter
    def cloud(self) -> pulumi.Output[Optional[str]]:
        """
        The endpoint of cloud provider, defaults to myhuaweicloud.com
        """
        return pulumi.get(self, "cloud")

    @property
    @pulumi.getter(name="delegatedProject")
    def delegated_project(self) -> pulumi.Output[Optional[str]]:
        """
        The name of delegated project (Identity v3).
        """
        return pulumi.get(self, "delegated_project")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the Domain to scope to.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the Domain to scope to.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[Optional[str]]:
        """
        enterprise project id
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[Optional[str]]:
        """
        A client private key to authenticate with.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        Password to login with.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def profile(self) -> pulumi.Output[Optional[str]]:
        """
        The profile name as set in the shared config file.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the project to login with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the project to login with.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        The HuaweiCloud region to connect to.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[Optional[str]]:
        """
        The secret key of the HuaweiCloud to use.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="securityToken")
    def security_token(self) -> pulumi.Output[Optional[str]]:
        """
        The security token to authenticate with a temporary security credential.
        """
        return pulumi.get(self, "security_token")

    @property
    @pulumi.getter(name="sharedConfigFile")
    def shared_config_file(self) -> pulumi.Output[Optional[str]]:
        """
        The path to the shared config file. If not set, the default is ~/.hcloud/config.json.
        """
        return pulumi.get(self, "shared_config_file")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the Tenant (Identity v2) to login with.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="tenantName")
    def tenant_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the Tenant (Identity v2) to login with.
        """
        return pulumi.get(self, "tenant_name")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[str]]:
        """
        Authentication token to use as an alternative to username/password.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[Optional[str]]:
        """
        User ID to login with.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[Optional[str]]:
        """
        Username to login with.
        """
        return pulumi.get(self, "user_name")

