# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'MigrationTaskBandwidthPolicy',
    'MigrationTaskDestinationObject',
    'MigrationTaskSmnConfig',
    'MigrationTaskSourceCdn',
    'MigrationTaskSourceObject',
]

@pulumi.output_type
class MigrationTaskBandwidthPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxBandwidth":
            suggest = "max_bandwidth"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationTaskBandwidthPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationTaskBandwidthPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationTaskBandwidthPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end: str,
                 max_bandwidth: int,
                 start: str):
        """
        :param str end: Specifies the end time of the traffic limit rule. The format is **hh:mm**,
               e.g. **12:03**.
        :param int max_bandwidth: Specifies the maximum traffic bandwidth allowed in the specified time
               segment. The unit is byte/s. The value ranges from **1** MB/s to **200** MB/s.
        :param str start: Specifies the start time of the traffic limit rule. The format is **hh:mm**,
               e.g. **12:03**.
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "max_bandwidth", max_bandwidth)
        pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> str:
        """
        Specifies the end time of the traffic limit rule. The format is **hh:mm**,
        e.g. **12:03**.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter(name="maxBandwidth")
    def max_bandwidth(self) -> int:
        """
        Specifies the maximum traffic bandwidth allowed in the specified time
        segment. The unit is byte/s. The value ranges from **1** MB/s to **200** MB/s.
        """
        return pulumi.get(self, "max_bandwidth")

    @property
    @pulumi.getter
    def start(self) -> str:
        """
        Specifies the start time of the traffic limit rule. The format is **hh:mm**,
        e.g. **12:03**.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class MigrationTaskDestinationObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "savePrefix":
            suggest = "save_prefix"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "securityToken":
            suggest = "security_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationTaskDestinationObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationTaskDestinationObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationTaskDestinationObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 region: str,
                 access_key: Optional[str] = None,
                 save_prefix: Optional[str] = None,
                 secret_key: Optional[str] = None,
                 security_token: Optional[str] = None):
        """
        :param str bucket: Specifies the name of the destination bucket.
               Changing this creates a new resource.
        :param str region: Specifies the region where the destination bucket is located.
               Changing this creates a new resource.
        :param str access_key: Specifies the access key for accessing the destination bucket.
               Changing this creates a new resource.
        :param str save_prefix: Specifies the path prefix in the destination bucket. The prefix is added
               before the object key to form a new key. Changing this creates a new resource.
        :param str secret_key: Specifies the secret key for accessing the destination bucket.
               Changing this creates a new resource.
        :param str security_token: Specifies the temporary token for accessing the destination bucket.
               Changing this creates a new resource.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "region", region)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if save_prefix is not None:
            pulumi.set(__self__, "save_prefix", save_prefix)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if security_token is not None:
            pulumi.set(__self__, "security_token", security_token)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Specifies the name of the destination bucket.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Specifies the region where the destination bucket is located.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[str]:
        """
        Specifies the access key for accessing the destination bucket.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="savePrefix")
    def save_prefix(self) -> Optional[str]:
        """
        Specifies the path prefix in the destination bucket. The prefix is added
        before the object key to form a new key. Changing this creates a new resource.
        """
        return pulumi.get(self, "save_prefix")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        Specifies the secret key for accessing the destination bucket.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="securityToken")
    def security_token(self) -> Optional[str]:
        """
        Specifies the temporary token for accessing the destination bucket.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "security_token")


@pulumi.output_type
class MigrationTaskSmnConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topicUrn":
            suggest = "topic_urn"
        elif key == "triggerConditions":
            suggest = "trigger_conditions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationTaskSmnConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationTaskSmnConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationTaskSmnConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 topic_urn: str,
                 trigger_conditions: Sequence[str],
                 language: Optional[str] = None):
        """
        :param str topic_urn: Specifies the SMN message topic URN bound to a migration task.
               Changing this creates a new resource.
        :param Sequence[str] trigger_conditions: Specifies the trigger conditions of sending messages using SMN.
               The value can be:
               + **FAILURE**: indicates that an SMN message will be sent after the migration task fails.
               + **SUCCESS**: indicates that an SMN message will be sent after the migration task succeeds.
        :param str language: Specifies the SMN message language. The value can be **zh-cn** or
               **en-us**. Default value: **en-us**. Changing this creates a new resource.
        """
        pulumi.set(__self__, "topic_urn", topic_urn)
        pulumi.set(__self__, "trigger_conditions", trigger_conditions)
        if language is not None:
            pulumi.set(__self__, "language", language)

    @property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> str:
        """
        Specifies the SMN message topic URN bound to a migration task.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "topic_urn")

    @property
    @pulumi.getter(name="triggerConditions")
    def trigger_conditions(self) -> Sequence[str]:
        """
        Specifies the trigger conditions of sending messages using SMN.
        The value can be:
        + **FAILURE**: indicates that an SMN message will be sent after the migration task fails.
        + **SUCCESS**: indicates that an SMN message will be sent after the migration task succeeds.
        """
        return pulumi.get(self, "trigger_conditions")

    @property
    @pulumi.getter
    def language(self) -> Optional[str]:
        """
        Specifies the SMN message language. The value can be **zh-cn** or
        **en-us**. Default value: **en-us**. Changing this creates a new resource.
        """
        return pulumi.get(self, "language")


@pulumi.output_type
class MigrationTaskSourceCdn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationKey":
            suggest = "authentication_key"
        elif key == "authenticationType":
            suggest = "authentication_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationTaskSourceCdn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationTaskSourceCdn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationTaskSourceCdn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain: str,
                 protocol: str,
                 authentication_key: Optional[str] = None,
                 authentication_type: Optional[str] = None):
        """
        :param str domain: Specifies the domain name from which to obtain objects to be migrated.
               Changing this creates a new resource.
        :param str protocol: Specifies the protocol type. Valid values are **HTTP** and **HTTPS**.
               Changing this creates a new resource.
        :param str authentication_key: Specifies the CDN authentication key.
               Changing this creates a new resource.
        :param str authentication_type: Specifies the authentication type. Valid values are **NONE**,
               **QINIU_PRIVATE_AUTHENTICATION**, **ALIYUN_OSS_A**, **ALIYUN_OSS_B**, **ALIYUN_OSS_C**,
               **KSYUN_PRIVATE_AUTHENTICATION**. Default value: **None**. Changing this creates a new resource.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "protocol", protocol)
        if authentication_key is not None:
            pulumi.set(__self__, "authentication_key", authentication_key)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        Specifies the domain name from which to obtain objects to be migrated.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Specifies the protocol type. Valid values are **HTTP** and **HTTPS**.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="authenticationKey")
    def authentication_key(self) -> Optional[str]:
        """
        Specifies the CDN authentication key.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "authentication_key")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[str]:
        """
        Specifies the authentication type. Valid values are **NONE**,
        **QINIU_PRIVATE_AUTHENTICATION**, **ALIYUN_OSS_A**, **ALIYUN_OSS_B**, **ALIYUN_OSS_C**,
        **KSYUN_PRIVATE_AUTHENTICATION**. Default value: **None**. Changing this creates a new resource.
        """
        return pulumi.get(self, "authentication_type")


@pulumi.output_type
class MigrationTaskSourceObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "appId":
            suggest = "app_id"
        elif key == "dataSource":
            suggest = "data_source"
        elif key == "listFileBucket":
            suggest = "list_file_bucket"
        elif key == "listFileKey":
            suggest = "list_file_key"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "securityToken":
            suggest = "security_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationTaskSourceObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationTaskSourceObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationTaskSourceObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: Optional[str] = None,
                 app_id: Optional[str] = None,
                 bucket: Optional[str] = None,
                 data_source: Optional[str] = None,
                 list_file_bucket: Optional[str] = None,
                 list_file_key: Optional[str] = None,
                 objects: Optional[Sequence[str]] = None,
                 region: Optional[str] = None,
                 secret_key: Optional[str] = None,
                 security_token: Optional[str] = None):
        """
        :param str access_key: Specifies the access key for accessing the destination bucket.
               Changing this creates a new resource.
        :param str app_id: Specifies the APP ID. This parameter is mandatory when `data_source` is  
               **Tencent**. Changing this creates a new resource.
        :param str bucket: Specifies the name of the destination bucket.
               Changing this creates a new resource.
        :param str data_source: Specifies the source cloud service provider. If `type` is
               **url_list**,set this parameter to **URLSource**. The value can be **AWS**, **Azure**, **Aliyun**, **Tencent**,
               **HuaweiCloud**, **QingCloud**, **KingsoftCloud**, **Baidu**, **Qiniu**, **URLSource** and **UCloud**.
               The default value is **Aliyun**. Changing this creates a new resource.
        :param str list_file_bucket: Specifies the name of the OBS bucket for storing the object list files.
               `list_file_bucket` is mandatory when `type` is set to **list** or **url_list**. Changing this creates a new resource.
        :param str list_file_key: Specifies the object name of the list file or URL list file.
               `list_file_key` is mandatory when `type` is set to **list** or **url_list**. Changing this creates a new resource.
        :param Sequence[str] objects: Specifies the list of object keys.
               + If `type` is set to **object**, this parameter specifies the names of the objects to be migrated. The strings
               ending with a slash (/) indicate the folders to be migrated, and the strings not ending with a slash (/) indicate the
               files to be migrated.
               + If `type` is set to **prefix**, this parameter indicates the name prefixes of the objects to be migrated.
               Set this parameter to [""] to migrate the entire bucket
        :param str region: Specifies the region where the destination bucket is located.
               Changing this creates a new resource.
        :param str secret_key: Specifies the secret key for accessing the destination bucket.
               Changing this creates a new resource.
        :param str security_token: Specifies the temporary token for accessing the destination bucket.
               Changing this creates a new resource.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if list_file_bucket is not None:
            pulumi.set(__self__, "list_file_bucket", list_file_bucket)
        if list_file_key is not None:
            pulumi.set(__self__, "list_file_key", list_file_key)
        if objects is not None:
            pulumi.set(__self__, "objects", objects)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if security_token is not None:
            pulumi.set(__self__, "security_token", security_token)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[str]:
        """
        Specifies the access key for accessing the destination bucket.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[str]:
        """
        Specifies the APP ID. This parameter is mandatory when `data_source` is  
        **Tencent**. Changing this creates a new resource.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        Specifies the name of the destination bucket.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[str]:
        """
        Specifies the source cloud service provider. If `type` is
        **url_list**,set this parameter to **URLSource**. The value can be **AWS**, **Azure**, **Aliyun**, **Tencent**,
        **HuaweiCloud**, **QingCloud**, **KingsoftCloud**, **Baidu**, **Qiniu**, **URLSource** and **UCloud**.
        The default value is **Aliyun**. Changing this creates a new resource.
        """
        return pulumi.get(self, "data_source")

    @property
    @pulumi.getter(name="listFileBucket")
    def list_file_bucket(self) -> Optional[str]:
        """
        Specifies the name of the OBS bucket for storing the object list files.
        `list_file_bucket` is mandatory when `type` is set to **list** or **url_list**. Changing this creates a new resource.
        """
        return pulumi.get(self, "list_file_bucket")

    @property
    @pulumi.getter(name="listFileKey")
    def list_file_key(self) -> Optional[str]:
        """
        Specifies the object name of the list file or URL list file.
        `list_file_key` is mandatory when `type` is set to **list** or **url_list**. Changing this creates a new resource.
        """
        return pulumi.get(self, "list_file_key")

    @property
    @pulumi.getter
    def objects(self) -> Optional[Sequence[str]]:
        """
        Specifies the list of object keys.
        + If `type` is set to **object**, this parameter specifies the names of the objects to be migrated. The strings
        ending with a slash (/) indicate the folders to be migrated, and the strings not ending with a slash (/) indicate the
        files to be migrated.
        + If `type` is set to **prefix**, this parameter indicates the name prefixes of the objects to be migrated.
        Set this parameter to [""] to migrate the entire bucket
        """
        return pulumi.get(self, "objects")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Specifies the region where the destination bucket is located.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        Specifies the secret key for accessing the destination bucket.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="securityToken")
    def security_token(self) -> Optional[str]:
        """
        Specifies the temporary token for accessing the destination bucket.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "security_token")


