# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ClusterAnalysisCoreNodes',
    'ClusterAnalysisTaskNodes',
    'ClusterCustomNode',
    'ClusterMasterNodes',
    'ClusterStreamingCoreNodes',
    'ClusterStreamingTaskNodes',
]

@pulumi.output_type
class ClusterAnalysisCoreNodes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVolumeCount":
            suggest = "data_volume_count"
        elif key == "nodeNumber":
            suggest = "node_number"
        elif key == "rootVolumeSize":
            suggest = "root_volume_size"
        elif key == "rootVolumeType":
            suggest = "root_volume_type"
        elif key == "assignedRoles":
            suggest = "assigned_roles"
        elif key == "dataVolumeSize":
            suggest = "data_volume_size"
        elif key == "dataVolumeType":
            suggest = "data_volume_type"
        elif key == "hostIps":
            suggest = "host_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAnalysisCoreNodes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAnalysisCoreNodes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAnalysisCoreNodes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_volume_count: int,
                 flavor: str,
                 node_number: int,
                 root_volume_size: int,
                 root_volume_type: str,
                 assigned_roles: Optional[Sequence[str]] = None,
                 data_volume_size: Optional[int] = None,
                 data_volume_type: Optional[str] = None,
                 host_ips: Optional[Sequence[str]] = None):
        """
        :param int data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        :param str flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param int node_number: Specifies the number of nodes for the node group.
        :param int root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param str root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param Sequence[str] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
        :param int data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param str data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param Sequence[str] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)

    @property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> int:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        """
        return pulumi.get(self, "data_volume_count")

    @property
    @pulumi.getter
    def flavor(self) -> str:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> int:
        """
        Specifies the number of nodes for the node group.
        """
        return pulumi.get(self, "node_number")

    @property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> int:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> str:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[Sequence[str]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.
        """
        return pulumi.get(self, "assigned_roles")

    @property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[int]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[str]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[Sequence[str]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")


@pulumi.output_type
class ClusterAnalysisTaskNodes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVolumeCount":
            suggest = "data_volume_count"
        elif key == "nodeNumber":
            suggest = "node_number"
        elif key == "rootVolumeSize":
            suggest = "root_volume_size"
        elif key == "rootVolumeType":
            suggest = "root_volume_type"
        elif key == "assignedRoles":
            suggest = "assigned_roles"
        elif key == "dataVolumeSize":
            suggest = "data_volume_size"
        elif key == "dataVolumeType":
            suggest = "data_volume_type"
        elif key == "hostIps":
            suggest = "host_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAnalysisTaskNodes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAnalysisTaskNodes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAnalysisTaskNodes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_volume_count: int,
                 flavor: str,
                 node_number: int,
                 root_volume_size: int,
                 root_volume_type: str,
                 assigned_roles: Optional[Sequence[str]] = None,
                 data_volume_size: Optional[int] = None,
                 data_volume_type: Optional[str] = None,
                 host_ips: Optional[Sequence[str]] = None):
        """
        :param int data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        :param str flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param int node_number: Specifies the number of nodes for the node group.
        :param int root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param str root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param Sequence[str] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
        :param int data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param str data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param Sequence[str] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)

    @property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> int:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        """
        return pulumi.get(self, "data_volume_count")

    @property
    @pulumi.getter
    def flavor(self) -> str:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> int:
        """
        Specifies the number of nodes for the node group.
        """
        return pulumi.get(self, "node_number")

    @property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> int:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> str:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[Sequence[str]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.
        """
        return pulumi.get(self, "assigned_roles")

    @property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[int]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[str]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[Sequence[str]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")


@pulumi.output_type
class ClusterCustomNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVolumeCount":
            suggest = "data_volume_count"
        elif key == "groupName":
            suggest = "group_name"
        elif key == "nodeNumber":
            suggest = "node_number"
        elif key == "rootVolumeSize":
            suggest = "root_volume_size"
        elif key == "rootVolumeType":
            suggest = "root_volume_type"
        elif key == "assignedRoles":
            suggest = "assigned_roles"
        elif key == "dataVolumeSize":
            suggest = "data_volume_size"
        elif key == "dataVolumeType":
            suggest = "data_volume_type"
        elif key == "hostIps":
            suggest = "host_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCustomNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCustomNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCustomNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_volume_count: int,
                 flavor: str,
                 group_name: str,
                 node_number: int,
                 root_volume_size: int,
                 root_volume_type: str,
                 assigned_roles: Optional[Sequence[str]] = None,
                 data_volume_size: Optional[int] = None,
                 data_volume_type: Optional[str] = None,
                 host_ips: Optional[Sequence[str]] = None):
        """
        :param int data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        :param str flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param str group_name: Specifies the name of nodes for the node group.
        :param int node_number: Specifies the number of nodes for the node group.
        :param int root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param str root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param Sequence[str] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
        :param int data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param str data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param Sequence[str] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)

    @property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> int:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        """
        return pulumi.get(self, "data_volume_count")

    @property
    @pulumi.getter
    def flavor(self) -> str:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> str:
        """
        Specifies the name of nodes for the node group.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> int:
        """
        Specifies the number of nodes for the node group.
        """
        return pulumi.get(self, "node_number")

    @property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> int:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> str:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[Sequence[str]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.
        """
        return pulumi.get(self, "assigned_roles")

    @property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[int]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[str]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[Sequence[str]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")


@pulumi.output_type
class ClusterMasterNodes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVolumeCount":
            suggest = "data_volume_count"
        elif key == "nodeNumber":
            suggest = "node_number"
        elif key == "rootVolumeSize":
            suggest = "root_volume_size"
        elif key == "rootVolumeType":
            suggest = "root_volume_type"
        elif key == "assignedRoles":
            suggest = "assigned_roles"
        elif key == "dataVolumeSize":
            suggest = "data_volume_size"
        elif key == "dataVolumeType":
            suggest = "data_volume_type"
        elif key == "hostIps":
            suggest = "host_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMasterNodes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMasterNodes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMasterNodes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_volume_count: int,
                 flavor: str,
                 node_number: int,
                 root_volume_size: int,
                 root_volume_type: str,
                 assigned_roles: Optional[Sequence[str]] = None,
                 data_volume_size: Optional[int] = None,
                 data_volume_type: Optional[str] = None,
                 host_ips: Optional[Sequence[str]] = None):
        """
        :param int data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        :param str flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param int node_number: Specifies the number of nodes for the node group.
        :param int root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param str root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param Sequence[str] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
        :param int data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param str data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param Sequence[str] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)

    @property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> int:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        """
        return pulumi.get(self, "data_volume_count")

    @property
    @pulumi.getter
    def flavor(self) -> str:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> int:
        """
        Specifies the number of nodes for the node group.
        """
        return pulumi.get(self, "node_number")

    @property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> int:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> str:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[Sequence[str]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.
        """
        return pulumi.get(self, "assigned_roles")

    @property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[int]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[str]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[Sequence[str]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")


@pulumi.output_type
class ClusterStreamingCoreNodes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVolumeCount":
            suggest = "data_volume_count"
        elif key == "nodeNumber":
            suggest = "node_number"
        elif key == "rootVolumeSize":
            suggest = "root_volume_size"
        elif key == "rootVolumeType":
            suggest = "root_volume_type"
        elif key == "assignedRoles":
            suggest = "assigned_roles"
        elif key == "dataVolumeSize":
            suggest = "data_volume_size"
        elif key == "dataVolumeType":
            suggest = "data_volume_type"
        elif key == "hostIps":
            suggest = "host_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterStreamingCoreNodes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterStreamingCoreNodes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterStreamingCoreNodes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_volume_count: int,
                 flavor: str,
                 node_number: int,
                 root_volume_size: int,
                 root_volume_type: str,
                 assigned_roles: Optional[Sequence[str]] = None,
                 data_volume_size: Optional[int] = None,
                 data_volume_type: Optional[str] = None,
                 host_ips: Optional[Sequence[str]] = None):
        """
        :param int data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        :param str flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param int node_number: Specifies the number of nodes for the node group.
        :param int root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param str root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param Sequence[str] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
        :param int data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param str data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param Sequence[str] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)

    @property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> int:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        """
        return pulumi.get(self, "data_volume_count")

    @property
    @pulumi.getter
    def flavor(self) -> str:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> int:
        """
        Specifies the number of nodes for the node group.
        """
        return pulumi.get(self, "node_number")

    @property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> int:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> str:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[Sequence[str]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.
        """
        return pulumi.get(self, "assigned_roles")

    @property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[int]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[str]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[Sequence[str]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")


@pulumi.output_type
class ClusterStreamingTaskNodes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVolumeCount":
            suggest = "data_volume_count"
        elif key == "nodeNumber":
            suggest = "node_number"
        elif key == "rootVolumeSize":
            suggest = "root_volume_size"
        elif key == "rootVolumeType":
            suggest = "root_volume_type"
        elif key == "assignedRoles":
            suggest = "assigned_roles"
        elif key == "dataVolumeSize":
            suggest = "data_volume_size"
        elif key == "dataVolumeType":
            suggest = "data_volume_type"
        elif key == "hostIps":
            suggest = "host_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterStreamingTaskNodes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterStreamingTaskNodes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterStreamingTaskNodes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_volume_count: int,
                 flavor: str,
                 node_number: int,
                 root_volume_size: int,
                 root_volume_type: str,
                 assigned_roles: Optional[Sequence[str]] = None,
                 data_volume_size: Optional[int] = None,
                 data_volume_type: Optional[str] = None,
                 host_ips: Optional[Sequence[str]] = None):
        """
        :param int data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        :param str flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param int node_number: Specifies the number of nodes for the node group.
        :param int root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param str root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param Sequence[str] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
        :param int data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param str data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param Sequence[str] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)

    @property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> int:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        """
        return pulumi.get(self, "data_volume_count")

    @property
    @pulumi.getter
    def flavor(self) -> str:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> int:
        """
        Specifies the number of nodes for the node group.
        """
        return pulumi.get(self, "node_number")

    @property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> int:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> str:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[Sequence[str]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.
        """
        return pulumi.get(self, "assigned_roles")

    @property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[int]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[str]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[Sequence[str]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")


