# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TranscodingTemplateArgs', 'TranscodingTemplate']

@pulumi.input_type
class TranscodingTemplateArgs:
    def __init__(__self__, *,
                 output_format: pulumi.Input[int],
                 audio: Optional[pulumi.Input['TranscodingTemplateAudioArgs']] = None,
                 dash_segment_duration: Optional[pulumi.Input[int]] = None,
                 hls_segment_duration: Optional[pulumi.Input[int]] = None,
                 low_bitrate_hd: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 video: Optional[pulumi.Input['TranscodingTemplateVideoArgs']] = None):
        """
        The set of arguments for constructing a TranscodingTemplate resource.
        :param pulumi.Input[int] output_format: Specifies the packaging type. Possible values are:
               + **1**: HLS
               + **2**: DASH
               + **3**: HLS+DASH
               + **4**: MP4
               + **5**: MP3
               + **6**: ADTS
        :param pulumi.Input['TranscodingTemplateAudioArgs'] audio: Specifies the audio parameters. The object structure is documented below.
        :param pulumi.Input[int] dash_segment_duration: Specifies the dash segment duration. This parameter is used only when `output_format`
               is set to 2 or 3. The value ranges from 2 to 10. The default value is 5. The unit is second.
        :param pulumi.Input[int] hls_segment_duration: Specifies the HLS segment duration. This parameter is used only
               when `output_format` is set to 1 or 3. The value ranges from 2 to 10. The default value is 5. The unit is second.
        :param pulumi.Input[bool] low_bitrate_hd: Specifies Whether to enable low bitrate HD. The default value is false.
        :param pulumi.Input[str] name: Specifies the name of a transcoding template.
        :param pulumi.Input[str] region: The region in which to create the transcoding template resource. If omitted,
               the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input['TranscodingTemplateVideoArgs'] video: Specifies the video parameters. The object structure is documented below.
        """
        pulumi.set(__self__, "output_format", output_format)
        if audio is not None:
            pulumi.set(__self__, "audio", audio)
        if dash_segment_duration is not None:
            pulumi.set(__self__, "dash_segment_duration", dash_segment_duration)
        if hls_segment_duration is not None:
            pulumi.set(__self__, "hls_segment_duration", hls_segment_duration)
        if low_bitrate_hd is not None:
            pulumi.set(__self__, "low_bitrate_hd", low_bitrate_hd)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if video is not None:
            pulumi.set(__self__, "video", video)

    @property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> pulumi.Input[int]:
        """
        Specifies the packaging type. Possible values are:
        + **1**: HLS
        + **2**: DASH
        + **3**: HLS+DASH
        + **4**: MP4
        + **5**: MP3
        + **6**: ADTS
        """
        return pulumi.get(self, "output_format")

    @output_format.setter
    def output_format(self, value: pulumi.Input[int]):
        pulumi.set(self, "output_format", value)

    @property
    @pulumi.getter
    def audio(self) -> Optional[pulumi.Input['TranscodingTemplateAudioArgs']]:
        """
        Specifies the audio parameters. The object structure is documented below.
        """
        return pulumi.get(self, "audio")

    @audio.setter
    def audio(self, value: Optional[pulumi.Input['TranscodingTemplateAudioArgs']]):
        pulumi.set(self, "audio", value)

    @property
    @pulumi.getter(name="dashSegmentDuration")
    def dash_segment_duration(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the dash segment duration. This parameter is used only when `output_format`
        is set to 2 or 3. The value ranges from 2 to 10. The default value is 5. The unit is second.
        """
        return pulumi.get(self, "dash_segment_duration")

    @dash_segment_duration.setter
    def dash_segment_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "dash_segment_duration", value)

    @property
    @pulumi.getter(name="hlsSegmentDuration")
    def hls_segment_duration(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the HLS segment duration. This parameter is used only
        when `output_format` is set to 1 or 3. The value ranges from 2 to 10. The default value is 5. The unit is second.
        """
        return pulumi.get(self, "hls_segment_duration")

    @hls_segment_duration.setter
    def hls_segment_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hls_segment_duration", value)

    @property
    @pulumi.getter(name="lowBitrateHd")
    def low_bitrate_hd(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies Whether to enable low bitrate HD. The default value is false.
        """
        return pulumi.get(self, "low_bitrate_hd")

    @low_bitrate_hd.setter
    def low_bitrate_hd(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "low_bitrate_hd", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of a transcoding template.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the transcoding template resource. If omitted,
        the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def video(self) -> Optional[pulumi.Input['TranscodingTemplateVideoArgs']]:
        """
        Specifies the video parameters. The object structure is documented below.
        """
        return pulumi.get(self, "video")

    @video.setter
    def video(self, value: Optional[pulumi.Input['TranscodingTemplateVideoArgs']]):
        pulumi.set(self, "video", value)


@pulumi.input_type
class _TranscodingTemplateState:
    def __init__(__self__, *,
                 audio: Optional[pulumi.Input['TranscodingTemplateAudioArgs']] = None,
                 dash_segment_duration: Optional[pulumi.Input[int]] = None,
                 hls_segment_duration: Optional[pulumi.Input[int]] = None,
                 low_bitrate_hd: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_format: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 video: Optional[pulumi.Input['TranscodingTemplateVideoArgs']] = None):
        """
        Input properties used for looking up and filtering TranscodingTemplate resources.
        :param pulumi.Input['TranscodingTemplateAudioArgs'] audio: Specifies the audio parameters. The object structure is documented below.
        :param pulumi.Input[int] dash_segment_duration: Specifies the dash segment duration. This parameter is used only when `output_format`
               is set to 2 or 3. The value ranges from 2 to 10. The default value is 5. The unit is second.
        :param pulumi.Input[int] hls_segment_duration: Specifies the HLS segment duration. This parameter is used only
               when `output_format` is set to 1 or 3. The value ranges from 2 to 10. The default value is 5. The unit is second.
        :param pulumi.Input[bool] low_bitrate_hd: Specifies Whether to enable low bitrate HD. The default value is false.
        :param pulumi.Input[str] name: Specifies the name of a transcoding template.
        :param pulumi.Input[int] output_format: Specifies the packaging type. Possible values are:
               + **1**: HLS
               + **2**: DASH
               + **3**: HLS+DASH
               + **4**: MP4
               + **5**: MP3
               + **6**: ADTS
        :param pulumi.Input[str] region: The region in which to create the transcoding template resource. If omitted,
               the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input['TranscodingTemplateVideoArgs'] video: Specifies the video parameters. The object structure is documented below.
        """
        if audio is not None:
            pulumi.set(__self__, "audio", audio)
        if dash_segment_duration is not None:
            pulumi.set(__self__, "dash_segment_duration", dash_segment_duration)
        if hls_segment_duration is not None:
            pulumi.set(__self__, "hls_segment_duration", hls_segment_duration)
        if low_bitrate_hd is not None:
            pulumi.set(__self__, "low_bitrate_hd", low_bitrate_hd)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_format is not None:
            pulumi.set(__self__, "output_format", output_format)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if video is not None:
            pulumi.set(__self__, "video", video)

    @property
    @pulumi.getter
    def audio(self) -> Optional[pulumi.Input['TranscodingTemplateAudioArgs']]:
        """
        Specifies the audio parameters. The object structure is documented below.
        """
        return pulumi.get(self, "audio")

    @audio.setter
    def audio(self, value: Optional[pulumi.Input['TranscodingTemplateAudioArgs']]):
        pulumi.set(self, "audio", value)

    @property
    @pulumi.getter(name="dashSegmentDuration")
    def dash_segment_duration(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the dash segment duration. This parameter is used only when `output_format`
        is set to 2 or 3. The value ranges from 2 to 10. The default value is 5. The unit is second.
        """
        return pulumi.get(self, "dash_segment_duration")

    @dash_segment_duration.setter
    def dash_segment_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "dash_segment_duration", value)

    @property
    @pulumi.getter(name="hlsSegmentDuration")
    def hls_segment_duration(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the HLS segment duration. This parameter is used only
        when `output_format` is set to 1 or 3. The value ranges from 2 to 10. The default value is 5. The unit is second.
        """
        return pulumi.get(self, "hls_segment_duration")

    @hls_segment_duration.setter
    def hls_segment_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hls_segment_duration", value)

    @property
    @pulumi.getter(name="lowBitrateHd")
    def low_bitrate_hd(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies Whether to enable low bitrate HD. The default value is false.
        """
        return pulumi.get(self, "low_bitrate_hd")

    @low_bitrate_hd.setter
    def low_bitrate_hd(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "low_bitrate_hd", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of a transcoding template.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the packaging type. Possible values are:
        + **1**: HLS
        + **2**: DASH
        + **3**: HLS+DASH
        + **4**: MP4
        + **5**: MP3
        + **6**: ADTS
        """
        return pulumi.get(self, "output_format")

    @output_format.setter
    def output_format(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "output_format", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the transcoding template resource. If omitted,
        the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def video(self) -> Optional[pulumi.Input['TranscodingTemplateVideoArgs']]:
        """
        Specifies the video parameters. The object structure is documented below.
        """
        return pulumi.get(self, "video")

    @video.setter
    def video(self, value: Optional[pulumi.Input['TranscodingTemplateVideoArgs']]):
        pulumi.set(self, "video", value)


class TranscodingTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audio: Optional[pulumi.Input[pulumi.InputType['TranscodingTemplateAudioArgs']]] = None,
                 dash_segment_duration: Optional[pulumi.Input[int]] = None,
                 hls_segment_duration: Optional[pulumi.Input[int]] = None,
                 low_bitrate_hd: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_format: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 video: Optional[pulumi.Input[pulumi.InputType['TranscodingTemplateVideoArgs']]] = None,
                 __props__=None):
        """
        Manages an MPC transcoding template resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test = huaweicloud.mpc.TranscodingTemplate("test",
            audio=huaweicloud.mpc.TranscodingTemplateAudioArgs(
                bitrate=0,
                channels=2,
                codec=2,
                output_policy="transcode",
                sample_rate=1,
            ),
            dash_segment_duration=5,
            hls_segment_duration=5,
            low_bitrate_hd=True,
            output_format=1,
            video=huaweicloud.mpc.TranscodingTemplateVideoArgs(
                bitrate=0,
                black_bar_removal=0,
                codec=2,
                fps=0,
                height=0,
                level=15,
                max_consecutive_bframes=7,
                max_iframes_interval=5,
                max_reference_frames=4,
                output_policy="transcode",
                profile=4,
                quality=1,
                width=0,
            ))
        ```

        ## Import

        MPC transcoding templates can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Mpc/transcodingTemplate:TranscodingTemplate test 542899
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['TranscodingTemplateAudioArgs']] audio: Specifies the audio parameters. The object structure is documented below.
        :param pulumi.Input[int] dash_segment_duration: Specifies the dash segment duration. This parameter is used only when `output_format`
               is set to 2 or 3. The value ranges from 2 to 10. The default value is 5. The unit is second.
        :param pulumi.Input[int] hls_segment_duration: Specifies the HLS segment duration. This parameter is used only
               when `output_format` is set to 1 or 3. The value ranges from 2 to 10. The default value is 5. The unit is second.
        :param pulumi.Input[bool] low_bitrate_hd: Specifies Whether to enable low bitrate HD. The default value is false.
        :param pulumi.Input[str] name: Specifies the name of a transcoding template.
        :param pulumi.Input[int] output_format: Specifies the packaging type. Possible values are:
               + **1**: HLS
               + **2**: DASH
               + **3**: HLS+DASH
               + **4**: MP4
               + **5**: MP3
               + **6**: ADTS
        :param pulumi.Input[str] region: The region in which to create the transcoding template resource. If omitted,
               the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[pulumi.InputType['TranscodingTemplateVideoArgs']] video: Specifies the video parameters. The object structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TranscodingTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an MPC transcoding template resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test = huaweicloud.mpc.TranscodingTemplate("test",
            audio=huaweicloud.mpc.TranscodingTemplateAudioArgs(
                bitrate=0,
                channels=2,
                codec=2,
                output_policy="transcode",
                sample_rate=1,
            ),
            dash_segment_duration=5,
            hls_segment_duration=5,
            low_bitrate_hd=True,
            output_format=1,
            video=huaweicloud.mpc.TranscodingTemplateVideoArgs(
                bitrate=0,
                black_bar_removal=0,
                codec=2,
                fps=0,
                height=0,
                level=15,
                max_consecutive_bframes=7,
                max_iframes_interval=5,
                max_reference_frames=4,
                output_policy="transcode",
                profile=4,
                quality=1,
                width=0,
            ))
        ```

        ## Import

        MPC transcoding templates can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Mpc/transcodingTemplate:TranscodingTemplate test 542899
        ```

        :param str resource_name: The name of the resource.
        :param TranscodingTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TranscodingTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audio: Optional[pulumi.Input[pulumi.InputType['TranscodingTemplateAudioArgs']]] = None,
                 dash_segment_duration: Optional[pulumi.Input[int]] = None,
                 hls_segment_duration: Optional[pulumi.Input[int]] = None,
                 low_bitrate_hd: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_format: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 video: Optional[pulumi.Input[pulumi.InputType['TranscodingTemplateVideoArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TranscodingTemplateArgs.__new__(TranscodingTemplateArgs)

            __props__.__dict__["audio"] = audio
            __props__.__dict__["dash_segment_duration"] = dash_segment_duration
            __props__.__dict__["hls_segment_duration"] = hls_segment_duration
            __props__.__dict__["low_bitrate_hd"] = low_bitrate_hd
            __props__.__dict__["name"] = name
            if output_format is None and not opts.urn:
                raise TypeError("Missing required property 'output_format'")
            __props__.__dict__["output_format"] = output_format
            __props__.__dict__["region"] = region
            __props__.__dict__["video"] = video
        super(TranscodingTemplate, __self__).__init__(
            'huaweicloud:Mpc/transcodingTemplate:TranscodingTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audio: Optional[pulumi.Input[pulumi.InputType['TranscodingTemplateAudioArgs']]] = None,
            dash_segment_duration: Optional[pulumi.Input[int]] = None,
            hls_segment_duration: Optional[pulumi.Input[int]] = None,
            low_bitrate_hd: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            output_format: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            video: Optional[pulumi.Input[pulumi.InputType['TranscodingTemplateVideoArgs']]] = None) -> 'TranscodingTemplate':
        """
        Get an existing TranscodingTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['TranscodingTemplateAudioArgs']] audio: Specifies the audio parameters. The object structure is documented below.
        :param pulumi.Input[int] dash_segment_duration: Specifies the dash segment duration. This parameter is used only when `output_format`
               is set to 2 or 3. The value ranges from 2 to 10. The default value is 5. The unit is second.
        :param pulumi.Input[int] hls_segment_duration: Specifies the HLS segment duration. This parameter is used only
               when `output_format` is set to 1 or 3. The value ranges from 2 to 10. The default value is 5. The unit is second.
        :param pulumi.Input[bool] low_bitrate_hd: Specifies Whether to enable low bitrate HD. The default value is false.
        :param pulumi.Input[str] name: Specifies the name of a transcoding template.
        :param pulumi.Input[int] output_format: Specifies the packaging type. Possible values are:
               + **1**: HLS
               + **2**: DASH
               + **3**: HLS+DASH
               + **4**: MP4
               + **5**: MP3
               + **6**: ADTS
        :param pulumi.Input[str] region: The region in which to create the transcoding template resource. If omitted,
               the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[pulumi.InputType['TranscodingTemplateVideoArgs']] video: Specifies the video parameters. The object structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TranscodingTemplateState.__new__(_TranscodingTemplateState)

        __props__.__dict__["audio"] = audio
        __props__.__dict__["dash_segment_duration"] = dash_segment_duration
        __props__.__dict__["hls_segment_duration"] = hls_segment_duration
        __props__.__dict__["low_bitrate_hd"] = low_bitrate_hd
        __props__.__dict__["name"] = name
        __props__.__dict__["output_format"] = output_format
        __props__.__dict__["region"] = region
        __props__.__dict__["video"] = video
        return TranscodingTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def audio(self) -> pulumi.Output[Optional['outputs.TranscodingTemplateAudio']]:
        """
        Specifies the audio parameters. The object structure is documented below.
        """
        return pulumi.get(self, "audio")

    @property
    @pulumi.getter(name="dashSegmentDuration")
    def dash_segment_duration(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the dash segment duration. This parameter is used only when `output_format`
        is set to 2 or 3. The value ranges from 2 to 10. The default value is 5. The unit is second.
        """
        return pulumi.get(self, "dash_segment_duration")

    @property
    @pulumi.getter(name="hlsSegmentDuration")
    def hls_segment_duration(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the HLS segment duration. This parameter is used only
        when `output_format` is set to 1 or 3. The value ranges from 2 to 10. The default value is 5. The unit is second.
        """
        return pulumi.get(self, "hls_segment_duration")

    @property
    @pulumi.getter(name="lowBitrateHd")
    def low_bitrate_hd(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies Whether to enable low bitrate HD. The default value is false.
        """
        return pulumi.get(self, "low_bitrate_hd")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of a transcoding template.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> pulumi.Output[int]:
        """
        Specifies the packaging type. Possible values are:
        + **1**: HLS
        + **2**: DASH
        + **3**: HLS+DASH
        + **4**: MP4
        + **5**: MP3
        + **6**: ADTS
        """
        return pulumi.get(self, "output_format")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the transcoding template resource. If omitted,
        the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def video(self) -> pulumi.Output[Optional['outputs.TranscodingTemplateVideo']]:
        """
        Specifies the video parameters. The object structure is documented below.
        """
        return pulumi.get(self, "video")

