# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NotebookArgs', 'Notebook']

@pulumi.input_type
class NotebookArgs:
    def __init__(__self__, *,
                 flavor_id: pulumi.Input[str],
                 image_id: pulumi.Input[str],
                 volume: pulumi.Input['NotebookVolumeArgs'],
                 allowed_access_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pool_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Notebook resource.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID. The options are as follows:
               - **modelarts.vm.cpu.2u**: General-purpose Intel CPU specifications, suitable for data exploration and algorithm
               discovery.
               - **modelarts.vm.cpu.8u**: General computing-plus Intel CPU specifications, suitable for compute-intensive
               applications.
               - **modelarts.bm.gpu.v100NV32**: One NVIDIA V100 GPU with 32GB of memory, suitable for deep learning algorithm
               training and debugging.
               - **modelarts.bm.d910.xlarge.1**: One Ascend 910 NPU with 32GB of memory, suitable for deep learning code running
               and debugging.
               - **modelarts.bm.d910.xlarge.2**: Two Ascend 910 NPU with 32GB of memory, suitable for deep learning code running
               and debugging.
               - **modelarts.bm.d910.xlarge.8**: Eight Ascend 910 NPU with 32GB of memory, suitable for deep learning code running
               and debugging.
        :param pulumi.Input[str] image_id: Specifies the image ID of notebook.
        :param pulumi.Input['NotebookVolumeArgs'] volume: Specifies the volume information. Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_access_ips: Specifies public IP addresses that are allowed for remote SSH access.
               If the parameter is not specified, all IP addresses will be allowed for remote SSH access.
        :param pulumi.Input[str] description: Specifies the description of notebook. It contains a maximum of 512 characters and
               cannot contain special characters `&<>"'/`.
        :param pulumi.Input[str] key_pair: Specifies the key pair name for remote SSH access.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the name of the notebook. The name consists of 1 to 64 characters,
               starting with a letter. Only letters, digits and underscores (_) are allowed.
        :param pulumi.Input[str] pool_id: Specifies the ID of Dedicated resource pool which the notebook used.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] workspace_id: Specifies the workspace ID which the notebook belongs to.
               The default value is `0`. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "flavor_id", flavor_id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "volume", volume)
        if allowed_access_ips is not None:
            pulumi.set(__self__, "allowed_access_ips", allowed_access_ips)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pool_id is not None:
            pulumi.set(__self__, "pool_id", pool_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Input[str]:
        """
        Specifies the flavor ID. The options are as follows:
        - **modelarts.vm.cpu.2u**: General-purpose Intel CPU specifications, suitable for data exploration and algorithm
        discovery.
        - **modelarts.vm.cpu.8u**: General computing-plus Intel CPU specifications, suitable for compute-intensive
        applications.
        - **modelarts.bm.gpu.v100NV32**: One NVIDIA V100 GPU with 32GB of memory, suitable for deep learning algorithm
        training and debugging.
        - **modelarts.bm.d910.xlarge.1**: One Ascend 910 NPU with 32GB of memory, suitable for deep learning code running
        and debugging.
        - **modelarts.bm.d910.xlarge.2**: Two Ascend 910 NPU with 32GB of memory, suitable for deep learning code running
        and debugging.
        - **modelarts.bm.d910.xlarge.8**: Eight Ascend 910 NPU with 32GB of memory, suitable for deep learning code running
        and debugging.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[str]:
        """
        Specifies the image ID of notebook.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter
    def volume(self) -> pulumi.Input['NotebookVolumeArgs']:
        """
        Specifies the volume information. Structure is documented below.
        """
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: pulumi.Input['NotebookVolumeArgs']):
        pulumi.set(self, "volume", value)

    @property
    @pulumi.getter(name="allowedAccessIps")
    def allowed_access_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies public IP addresses that are allowed for remote SSH access.
        If the parameter is not specified, all IP addresses will be allowed for remote SSH access.
        """
        return pulumi.get(self, "allowed_access_ips")

    @allowed_access_ips.setter
    def allowed_access_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_access_ips", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of notebook. It contains a maximum of 512 characters and
        cannot contain special characters `&<>"'/`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the key pair name for remote SSH access.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the notebook. The name consists of 1 to 64 characters,
        starting with a letter. Only letters, digits and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of Dedicated resource pool which the notebook used.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "pool_id")

    @pool_id.setter
    def pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pool_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the workspace ID which the notebook belongs to.
        The default value is `0`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class _NotebookState:
    def __init__(__self__, *,
                 allowed_access_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 auto_stop_enabled: Optional[pulumi.Input[bool]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 image_name: Optional[pulumi.Input[str]] = None,
                 image_swr_path: Optional[pulumi.Input[str]] = None,
                 image_type: Optional[pulumi.Input[str]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 mount_storages: Optional[pulumi.Input[Sequence[pulumi.Input['NotebookMountStorageArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pool_id: Optional[pulumi.Input[str]] = None,
                 pool_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 ssh_uri: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 volume: Optional[pulumi.Input['NotebookVolumeArgs']] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Notebook resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_access_ips: Specifies public IP addresses that are allowed for remote SSH access.
               If the parameter is not specified, all IP addresses will be allowed for remote SSH access.
        :param pulumi.Input[bool] auto_stop_enabled: Whether enabled the notebook instance to automatically stop.
        :param pulumi.Input[str] created_at: The notebook creation time.
        :param pulumi.Input[str] description: Specifies the description of notebook. It contains a maximum of 512 characters and
               cannot contain special characters `&<>"'/`.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID. The options are as follows:
               - **modelarts.vm.cpu.2u**: General-purpose Intel CPU specifications, suitable for data exploration and algorithm
               discovery.
               - **modelarts.vm.cpu.8u**: General computing-plus Intel CPU specifications, suitable for compute-intensive
               applications.
               - **modelarts.bm.gpu.v100NV32**: One NVIDIA V100 GPU with 32GB of memory, suitable for deep learning algorithm
               training and debugging.
               - **modelarts.bm.d910.xlarge.1**: One Ascend 910 NPU with 32GB of memory, suitable for deep learning code running
               and debugging.
               - **modelarts.bm.d910.xlarge.2**: Two Ascend 910 NPU with 32GB of memory, suitable for deep learning code running
               and debugging.
               - **modelarts.bm.d910.xlarge.8**: Eight Ascend 910 NPU with 32GB of memory, suitable for deep learning code running
               and debugging.
        :param pulumi.Input[str] image_id: Specifies the image ID of notebook.
        :param pulumi.Input[str] image_name: The image name.
        :param pulumi.Input[str] image_swr_path: The image path in swr.
        :param pulumi.Input[str] image_type: The image type. Valid values include: `BUILD_IN`, `DEDICATED`.
        :param pulumi.Input[str] key_pair: Specifies the key pair name for remote SSH access.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['NotebookMountStorageArgs']]] mount_storages: An array of storages which mount to the notebook. Structure is documented below.
        :param pulumi.Input[str] name: Specifies the name of the notebook. The name consists of 1 to 64 characters,
               starting with a letter. Only letters, digits and underscores (_) are allowed.
        :param pulumi.Input[str] pool_id: Specifies the ID of Dedicated resource pool which the notebook used.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] pool_name: The name of Dedicated resource pool which the notebook used.
        :param pulumi.Input[str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] ssh_uri: The uri for remote SSH access.
               * `volume/mount_path` - The local mount path of volume.
        :param pulumi.Input[str] status: The status of mount.
        :param pulumi.Input[str] updated_at: The notebook update time.
        :param pulumi.Input[str] url: The web url of the notebook.
        :param pulumi.Input['NotebookVolumeArgs'] volume: Specifies the volume information. Structure is documented below.
        :param pulumi.Input[str] workspace_id: Specifies the workspace ID which the notebook belongs to.
               The default value is `0`. Changing this parameter will create a new resource.
        """
        if allowed_access_ips is not None:
            pulumi.set(__self__, "allowed_access_ips", allowed_access_ips)
        if auto_stop_enabled is not None:
            pulumi.set(__self__, "auto_stop_enabled", auto_stop_enabled)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if image_swr_path is not None:
            pulumi.set(__self__, "image_swr_path", image_swr_path)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if mount_storages is not None:
            pulumi.set(__self__, "mount_storages", mount_storages)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pool_id is not None:
            pulumi.set(__self__, "pool_id", pool_id)
        if pool_name is not None:
            pulumi.set(__self__, "pool_name", pool_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if ssh_uri is not None:
            pulumi.set(__self__, "ssh_uri", ssh_uri)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if volume is not None:
            pulumi.set(__self__, "volume", volume)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="allowedAccessIps")
    def allowed_access_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies public IP addresses that are allowed for remote SSH access.
        If the parameter is not specified, all IP addresses will be allowed for remote SSH access.
        """
        return pulumi.get(self, "allowed_access_ips")

    @allowed_access_ips.setter
    def allowed_access_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_access_ips", value)

    @property
    @pulumi.getter(name="autoStopEnabled")
    def auto_stop_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enabled the notebook instance to automatically stop.
        """
        return pulumi.get(self, "auto_stop_enabled")

    @auto_stop_enabled.setter
    def auto_stop_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_stop_enabled", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The notebook creation time.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of notebook. It contains a maximum of 512 characters and
        cannot contain special characters `&<>"'/`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the flavor ID. The options are as follows:
        - **modelarts.vm.cpu.2u**: General-purpose Intel CPU specifications, suitable for data exploration and algorithm
        discovery.
        - **modelarts.vm.cpu.8u**: General computing-plus Intel CPU specifications, suitable for compute-intensive
        applications.
        - **modelarts.bm.gpu.v100NV32**: One NVIDIA V100 GPU with 32GB of memory, suitable for deep learning algorithm
        training and debugging.
        - **modelarts.bm.d910.xlarge.1**: One Ascend 910 NPU with 32GB of memory, suitable for deep learning code running
        and debugging.
        - **modelarts.bm.d910.xlarge.2**: Two Ascend 910 NPU with 32GB of memory, suitable for deep learning code running
        and debugging.
        - **modelarts.bm.d910.xlarge.8**: Eight Ascend 910 NPU with 32GB of memory, suitable for deep learning code running
        and debugging.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the image ID of notebook.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[str]]:
        """
        The image name.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_name", value)

    @property
    @pulumi.getter(name="imageSwrPath")
    def image_swr_path(self) -> Optional[pulumi.Input[str]]:
        """
        The image path in swr.
        """
        return pulumi.get(self, "image_swr_path")

    @image_swr_path.setter
    def image_swr_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_swr_path", value)

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[pulumi.Input[str]]:
        """
        The image type. Valid values include: `BUILD_IN`, `DEDICATED`.
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_type", value)

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the key pair name for remote SSH access.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair", value)

    @property
    @pulumi.getter(name="mountStorages")
    def mount_storages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotebookMountStorageArgs']]]]:
        """
        An array of storages which mount to the notebook. Structure is documented below.
        """
        return pulumi.get(self, "mount_storages")

    @mount_storages.setter
    def mount_storages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotebookMountStorageArgs']]]]):
        pulumi.set(self, "mount_storages", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the notebook. The name consists of 1 to 64 characters,
        starting with a letter. Only letters, digits and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of Dedicated resource pool which the notebook used.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "pool_id")

    @pool_id.setter
    def pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pool_id", value)

    @property
    @pulumi.getter(name="poolName")
    def pool_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of Dedicated resource pool which the notebook used.
        """
        return pulumi.get(self, "pool_name")

    @pool_name.setter
    def pool_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pool_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sshUri")
    def ssh_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The uri for remote SSH access.
        * `volume/mount_path` - The local mount path of volume.
        """
        return pulumi.get(self, "ssh_uri")

    @ssh_uri.setter
    def ssh_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_uri", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of mount.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The notebook update time.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The web url of the notebook.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def volume(self) -> Optional[pulumi.Input['NotebookVolumeArgs']]:
        """
        Specifies the volume information. Structure is documented below.
        """
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: Optional[pulumi.Input['NotebookVolumeArgs']]):
        pulumi.set(self, "volume", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the workspace ID which the notebook belongs to.
        The default value is `0`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_id", value)


class Notebook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_access_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pool_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 volume: Optional[pulumi.Input[pulumi.InputType['NotebookVolumeArgs']]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages ModelArts notebook resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        notebook_name = config.require_object("notebookName")
        key_pair_name = config.require_object("keyPairName")
        ip = config.require_object("ip")
        notebook = huaweicloud.model_arts.Notebook("notebook",
            flavor_id="modelarts.vm.cpu.2u",
            image_id="e1a07296-22a8-4f05-8bc8-e936c8e54090",
            allowed_access_ips=[ip],
            key_pair=key_pair_name,
            volume=huaweicloud.model_arts.NotebookVolumeArgs(
                type="EFS",
            ))
        ```

        ## Import

        The notebook can be imported by `id`.

        ```sh
         $ pulumi import huaweicloud:ModelArts/notebook:Notebook test b11b407c-e604-4e8d-8bc4-92398320b847
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_access_ips: Specifies public IP addresses that are allowed for remote SSH access.
               If the parameter is not specified, all IP addresses will be allowed for remote SSH access.
        :param pulumi.Input[str] description: Specifies the description of notebook. It contains a maximum of 512 characters and
               cannot contain special characters `&<>"'/`.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID. The options are as follows:
               - **modelarts.vm.cpu.2u**: General-purpose Intel CPU specifications, suitable for data exploration and algorithm
               discovery.
               - **modelarts.vm.cpu.8u**: General computing-plus Intel CPU specifications, suitable for compute-intensive
               applications.
               - **modelarts.bm.gpu.v100NV32**: One NVIDIA V100 GPU with 32GB of memory, suitable for deep learning algorithm
               training and debugging.
               - **modelarts.bm.d910.xlarge.1**: One Ascend 910 NPU with 32GB of memory, suitable for deep learning code running
               and debugging.
               - **modelarts.bm.d910.xlarge.2**: Two Ascend 910 NPU with 32GB of memory, suitable for deep learning code running
               and debugging.
               - **modelarts.bm.d910.xlarge.8**: Eight Ascend 910 NPU with 32GB of memory, suitable for deep learning code running
               and debugging.
        :param pulumi.Input[str] image_id: Specifies the image ID of notebook.
        :param pulumi.Input[str] key_pair: Specifies the key pair name for remote SSH access.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the name of the notebook. The name consists of 1 to 64 characters,
               starting with a letter. Only letters, digits and underscores (_) are allowed.
        :param pulumi.Input[str] pool_id: Specifies the ID of Dedicated resource pool which the notebook used.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['NotebookVolumeArgs']] volume: Specifies the volume information. Structure is documented below.
        :param pulumi.Input[str] workspace_id: Specifies the workspace ID which the notebook belongs to.
               The default value is `0`. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NotebookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages ModelArts notebook resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        notebook_name = config.require_object("notebookName")
        key_pair_name = config.require_object("keyPairName")
        ip = config.require_object("ip")
        notebook = huaweicloud.model_arts.Notebook("notebook",
            flavor_id="modelarts.vm.cpu.2u",
            image_id="e1a07296-22a8-4f05-8bc8-e936c8e54090",
            allowed_access_ips=[ip],
            key_pair=key_pair_name,
            volume=huaweicloud.model_arts.NotebookVolumeArgs(
                type="EFS",
            ))
        ```

        ## Import

        The notebook can be imported by `id`.

        ```sh
         $ pulumi import huaweicloud:ModelArts/notebook:Notebook test b11b407c-e604-4e8d-8bc4-92398320b847
        ```

        :param str resource_name: The name of the resource.
        :param NotebookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NotebookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_access_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pool_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 volume: Optional[pulumi.Input[pulumi.InputType['NotebookVolumeArgs']]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NotebookArgs.__new__(NotebookArgs)

            __props__.__dict__["allowed_access_ips"] = allowed_access_ips
            __props__.__dict__["description"] = description
            if flavor_id is None and not opts.urn:
                raise TypeError("Missing required property 'flavor_id'")
            __props__.__dict__["flavor_id"] = flavor_id
            if image_id is None and not opts.urn:
                raise TypeError("Missing required property 'image_id'")
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["key_pair"] = key_pair
            __props__.__dict__["name"] = name
            __props__.__dict__["pool_id"] = pool_id
            __props__.__dict__["region"] = region
            if volume is None and not opts.urn:
                raise TypeError("Missing required property 'volume'")
            __props__.__dict__["volume"] = volume
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["auto_stop_enabled"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["image_name"] = None
            __props__.__dict__["image_swr_path"] = None
            __props__.__dict__["image_type"] = None
            __props__.__dict__["mount_storages"] = None
            __props__.__dict__["pool_name"] = None
            __props__.__dict__["ssh_uri"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["url"] = None
        super(Notebook, __self__).__init__(
            'huaweicloud:ModelArts/notebook:Notebook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_access_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            auto_stop_enabled: Optional[pulumi.Input[bool]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            flavor_id: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            image_name: Optional[pulumi.Input[str]] = None,
            image_swr_path: Optional[pulumi.Input[str]] = None,
            image_type: Optional[pulumi.Input[str]] = None,
            key_pair: Optional[pulumi.Input[str]] = None,
            mount_storages: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NotebookMountStorageArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            pool_id: Optional[pulumi.Input[str]] = None,
            pool_name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            ssh_uri: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None,
            volume: Optional[pulumi.Input[pulumi.InputType['NotebookVolumeArgs']]] = None,
            workspace_id: Optional[pulumi.Input[str]] = None) -> 'Notebook':
        """
        Get an existing Notebook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_access_ips: Specifies public IP addresses that are allowed for remote SSH access.
               If the parameter is not specified, all IP addresses will be allowed for remote SSH access.
        :param pulumi.Input[bool] auto_stop_enabled: Whether enabled the notebook instance to automatically stop.
        :param pulumi.Input[str] created_at: The notebook creation time.
        :param pulumi.Input[str] description: Specifies the description of notebook. It contains a maximum of 512 characters and
               cannot contain special characters `&<>"'/`.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID. The options are as follows:
               - **modelarts.vm.cpu.2u**: General-purpose Intel CPU specifications, suitable for data exploration and algorithm
               discovery.
               - **modelarts.vm.cpu.8u**: General computing-plus Intel CPU specifications, suitable for compute-intensive
               applications.
               - **modelarts.bm.gpu.v100NV32**: One NVIDIA V100 GPU with 32GB of memory, suitable for deep learning algorithm
               training and debugging.
               - **modelarts.bm.d910.xlarge.1**: One Ascend 910 NPU with 32GB of memory, suitable for deep learning code running
               and debugging.
               - **modelarts.bm.d910.xlarge.2**: Two Ascend 910 NPU with 32GB of memory, suitable for deep learning code running
               and debugging.
               - **modelarts.bm.d910.xlarge.8**: Eight Ascend 910 NPU with 32GB of memory, suitable for deep learning code running
               and debugging.
        :param pulumi.Input[str] image_id: Specifies the image ID of notebook.
        :param pulumi.Input[str] image_name: The image name.
        :param pulumi.Input[str] image_swr_path: The image path in swr.
        :param pulumi.Input[str] image_type: The image type. Valid values include: `BUILD_IN`, `DEDICATED`.
        :param pulumi.Input[str] key_pair: Specifies the key pair name for remote SSH access.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NotebookMountStorageArgs']]]] mount_storages: An array of storages which mount to the notebook. Structure is documented below.
        :param pulumi.Input[str] name: Specifies the name of the notebook. The name consists of 1 to 64 characters,
               starting with a letter. Only letters, digits and underscores (_) are allowed.
        :param pulumi.Input[str] pool_id: Specifies the ID of Dedicated resource pool which the notebook used.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] pool_name: The name of Dedicated resource pool which the notebook used.
        :param pulumi.Input[str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] ssh_uri: The uri for remote SSH access.
               * `volume/mount_path` - The local mount path of volume.
        :param pulumi.Input[str] status: The status of mount.
        :param pulumi.Input[str] updated_at: The notebook update time.
        :param pulumi.Input[str] url: The web url of the notebook.
        :param pulumi.Input[pulumi.InputType['NotebookVolumeArgs']] volume: Specifies the volume information. Structure is documented below.
        :param pulumi.Input[str] workspace_id: Specifies the workspace ID which the notebook belongs to.
               The default value is `0`. Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NotebookState.__new__(_NotebookState)

        __props__.__dict__["allowed_access_ips"] = allowed_access_ips
        __props__.__dict__["auto_stop_enabled"] = auto_stop_enabled
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["flavor_id"] = flavor_id
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["image_name"] = image_name
        __props__.__dict__["image_swr_path"] = image_swr_path
        __props__.__dict__["image_type"] = image_type
        __props__.__dict__["key_pair"] = key_pair
        __props__.__dict__["mount_storages"] = mount_storages
        __props__.__dict__["name"] = name
        __props__.__dict__["pool_id"] = pool_id
        __props__.__dict__["pool_name"] = pool_name
        __props__.__dict__["region"] = region
        __props__.__dict__["ssh_uri"] = ssh_uri
        __props__.__dict__["status"] = status
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["url"] = url
        __props__.__dict__["volume"] = volume
        __props__.__dict__["workspace_id"] = workspace_id
        return Notebook(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedAccessIps")
    def allowed_access_ips(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies public IP addresses that are allowed for remote SSH access.
        If the parameter is not specified, all IP addresses will be allowed for remote SSH access.
        """
        return pulumi.get(self, "allowed_access_ips")

    @property
    @pulumi.getter(name="autoStopEnabled")
    def auto_stop_enabled(self) -> pulumi.Output[bool]:
        """
        Whether enabled the notebook instance to automatically stop.
        """
        return pulumi.get(self, "auto_stop_enabled")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The notebook creation time.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of notebook. It contains a maximum of 512 characters and
        cannot contain special characters `&<>"'/`.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[str]:
        """
        Specifies the flavor ID. The options are as follows:
        - **modelarts.vm.cpu.2u**: General-purpose Intel CPU specifications, suitable for data exploration and algorithm
        discovery.
        - **modelarts.vm.cpu.8u**: General computing-plus Intel CPU specifications, suitable for compute-intensive
        applications.
        - **modelarts.bm.gpu.v100NV32**: One NVIDIA V100 GPU with 32GB of memory, suitable for deep learning algorithm
        training and debugging.
        - **modelarts.bm.d910.xlarge.1**: One Ascend 910 NPU with 32GB of memory, suitable for deep learning code running
        and debugging.
        - **modelarts.bm.d910.xlarge.2**: Two Ascend 910 NPU with 32GB of memory, suitable for deep learning code running
        and debugging.
        - **modelarts.bm.d910.xlarge.8**: Eight Ascend 910 NPU with 32GB of memory, suitable for deep learning code running
        and debugging.
        """
        return pulumi.get(self, "flavor_id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[str]:
        """
        Specifies the image ID of notebook.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Output[str]:
        """
        The image name.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="imageSwrPath")
    def image_swr_path(self) -> pulumi.Output[str]:
        """
        The image path in swr.
        """
        return pulumi.get(self, "image_swr_path")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> pulumi.Output[str]:
        """
        The image type. Valid values include: `BUILD_IN`, `DEDICATED`.
        """
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the key pair name for remote SSH access.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "key_pair")

    @property
    @pulumi.getter(name="mountStorages")
    def mount_storages(self) -> pulumi.Output[Sequence['outputs.NotebookMountStorage']]:
        """
        An array of storages which mount to the notebook. Structure is documented below.
        """
        return pulumi.get(self, "mount_storages")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the notebook. The name consists of 1 to 64 characters,
        starting with a letter. Only letters, digits and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the ID of Dedicated resource pool which the notebook used.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "pool_id")

    @property
    @pulumi.getter(name="poolName")
    def pool_name(self) -> pulumi.Output[str]:
        """
        The name of Dedicated resource pool which the notebook used.
        """
        return pulumi.get(self, "pool_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="sshUri")
    def ssh_uri(self) -> pulumi.Output[str]:
        """
        The uri for remote SSH access.
        * `volume/mount_path` - The local mount path of volume.
        """
        return pulumi.get(self, "ssh_uri")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of mount.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The notebook update time.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        The web url of the notebook.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def volume(self) -> pulumi.Output['outputs.NotebookVolume']:
        """
        Specifies the volume information. Structure is documented below.
        """
        return pulumi.get(self, "volume")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[str]:
        """
        Specifies the workspace ID which the notebook belongs to.
        The default value is `0`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "workspace_id")

