# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDataset_versionsResult',
    'AwaitableGetDataset_versionsResult',
    'get_dataset_versions',
    'get_dataset_versions_output',
]

@pulumi.output_type
class GetDataset_versionsResult:
    """
    A collection of values returned by getDataset_versions.
    """
    def __init__(__self__, dataset_id=None, id=None, name=None, region=None, split_ratio=None, versions=None):
        if dataset_id and not isinstance(dataset_id, str):
            raise TypeError("Expected argument 'dataset_id' to be a str")
        pulumi.set(__self__, "dataset_id", dataset_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if split_ratio and not isinstance(split_ratio, str):
            raise TypeError("Expected argument 'split_ratio' to be a str")
        pulumi.set(__self__, "split_ratio", split_ratio)
        if versions and not isinstance(versions, list):
            raise TypeError("Expected argument 'versions' to be a list")
        pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the dataset version.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="splitRatio")
    def split_ratio(self) -> Optional[str]:
        """
        The ratio of splitting which randomly divides a labeled sample into a training set and
        a validation set.
        """
        return pulumi.get(self, "split_ratio")

    @property
    @pulumi.getter
    def versions(self) -> Sequence['outputs.GetDataset_versionsVersionResult']:
        """
        Indicates a list of all dataset versions found. Structure is documented below.
        """
        return pulumi.get(self, "versions")


class AwaitableGetDataset_versionsResult(GetDataset_versionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataset_versionsResult(
            dataset_id=self.dataset_id,
            id=self.id,
            name=self.name,
            region=self.region,
            split_ratio=self.split_ratio,
            versions=self.versions)


def get_dataset_versions(dataset_id: Optional[str] = None,
                         name: Optional[str] = None,
                         region: Optional[str] = None,
                         split_ratio: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataset_versionsResult:
    """
    Use this data source to get a list of ModelArts dataset versions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    dataset_id = config.require_object("datasetId")
    test = huaweicloud.ModelArts.get_dataset_versions(dataset_id=dataset_id)
    ```


    :param str dataset_id: Specifies the ID of dataset.
    :param str name: Specifies the name of the dataset version.
    :param str region: Specifies the region in which to obtain dataset versions. If omitted, the
           provider-level region will be used.
    :param str split_ratio: Specifies the range of splitting ratio which randomly divides a labeled sample
           into a training set and a validation set. Separate the minimum and maximum split ratios with commas,
           for example: "0.0,1.0".
    """
    __args__ = dict()
    __args__['datasetId'] = dataset_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['splitRatio'] = split_ratio
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:ModelArts/getDataset_versions:getDataset_versions', __args__, opts=opts, typ=GetDataset_versionsResult).value

    return AwaitableGetDataset_versionsResult(
        dataset_id=__ret__.dataset_id,
        id=__ret__.id,
        name=__ret__.name,
        region=__ret__.region,
        split_ratio=__ret__.split_ratio,
        versions=__ret__.versions)


@_utilities.lift_output_func(get_dataset_versions)
def get_dataset_versions_output(dataset_id: Optional[pulumi.Input[str]] = None,
                                name: Optional[pulumi.Input[Optional[str]]] = None,
                                region: Optional[pulumi.Input[Optional[str]]] = None,
                                split_ratio: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDataset_versionsResult]:
    """
    Use this data source to get a list of ModelArts dataset versions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    dataset_id = config.require_object("datasetId")
    test = huaweicloud.ModelArts.get_dataset_versions(dataset_id=dataset_id)
    ```


    :param str dataset_id: Specifies the ID of dataset.
    :param str name: Specifies the name of the dataset version.
    :param str region: Specifies the region in which to obtain dataset versions. If omitted, the
           provider-level region will be used.
    :param str split_ratio: Specifies the range of splitting ratio which randomly divides a labeled sample
           into a training set and a validation set. Separate the minimum and maximum split ratios with commas,
           for example: "0.0,1.0".
    """
    ...
