# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DeviceCertificateArgs', 'DeviceCertificate']

@pulumi.input_type
class DeviceCertificateArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None,
                 space_id: Optional[pulumi.Input[str]] = None,
                 verify_content: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DeviceCertificate resource.
        :param pulumi.Input[str] content: Specifies the content of device CA certificate.
               Changing this parameter will create a new resource. Create a private CA certificate,
               please following [reference](https://support.huaweicloud.com/usermanual-iothub/iot_01_0104.html)
        :param pulumi.Input[str] region: Specifies the region in which to create the IoTDA device CA certificate
               resource. If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] space_id: Specifies the resource space ID to which the device CA certificate belongs.
               If omitted, the certificate will belong to the default resource space.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] verify_content: Specifies the content of verification certificate. Can only be used to verify
               the validity of the device CA certificate after creation. Get the verification certificate,
               please following [reference](https://support.huaweicloud.com/usermanual-iothub/iot_01_0106.html)
        """
        pulumi.set(__self__, "content", content)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if space_id is not None:
            pulumi.set(__self__, "space_id", space_id)
        if verify_content is not None:
            pulumi.set(__self__, "verify_content", verify_content)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input[str]:
        """
        Specifies the content of device CA certificate.
        Changing this parameter will create a new resource. Create a private CA certificate,
        please following [reference](https://support.huaweicloud.com/usermanual-iothub/iot_01_0104.html)
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[str]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the IoTDA device CA certificate
        resource. If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="spaceId")
    def space_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the resource space ID to which the device CA certificate belongs.
        If omitted, the certificate will belong to the default resource space.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "space_id")

    @space_id.setter
    def space_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "space_id", value)

    @property
    @pulumi.getter(name="verifyContent")
    def verify_content(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the content of verification certificate. Can only be used to verify
        the validity of the device CA certificate after creation. Get the verification certificate,
        please following [reference](https://support.huaweicloud.com/usermanual-iothub/iot_01_0106.html)
        """
        return pulumi.get(self, "verify_content")

    @verify_content.setter
    def verify_content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "verify_content", value)


@pulumi.input_type
class _DeviceCertificateState:
    def __init__(__self__, *,
                 cn: Optional[pulumi.Input[str]] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 effective_date: Optional[pulumi.Input[str]] = None,
                 expiry_date: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 space_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 verify_code: Optional[pulumi.Input[str]] = None,
                 verify_content: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DeviceCertificate resources.
        :param pulumi.Input[str] cn: The CN name of the device CA certificate.
        :param pulumi.Input[str] content: Specifies the content of device CA certificate.
               Changing this parameter will create a new resource. Create a private CA certificate,
               please following [reference](https://support.huaweicloud.com/usermanual-iothub/iot_01_0104.html)
        :param pulumi.Input[str] effective_date: The effective date of the device CA certificate.
               The format is: **yyyyMMdd'T'HHmmss'Z'**, e.g., **20151212T121212Z**.
        :param pulumi.Input[str] expiry_date: The expiry date of the device CA certificate.
               The format is: **yyyyMMdd'T'HHmmss'Z'**, e.g., **20151212T121212Z**.
        :param pulumi.Input[str] owner: The owner of the device CA certificate.
        :param pulumi.Input[str] region: Specifies the region in which to create the IoTDA device CA certificate
               resource. If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] space_id: Specifies the resource space ID to which the device CA certificate belongs.
               If omitted, the certificate will belong to the default resource space.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] status: The status of the device CA certificate. The valid values are **Unverified** and **Verified**.
        :param pulumi.Input[str] verify_code: The verify code of the device CA certificate.
        :param pulumi.Input[str] verify_content: Specifies the content of verification certificate. Can only be used to verify
               the validity of the device CA certificate after creation. Get the verification certificate,
               please following [reference](https://support.huaweicloud.com/usermanual-iothub/iot_01_0106.html)
        """
        if cn is not None:
            pulumi.set(__self__, "cn", cn)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if effective_date is not None:
            pulumi.set(__self__, "effective_date", effective_date)
        if expiry_date is not None:
            pulumi.set(__self__, "expiry_date", expiry_date)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if space_id is not None:
            pulumi.set(__self__, "space_id", space_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if verify_code is not None:
            pulumi.set(__self__, "verify_code", verify_code)
        if verify_content is not None:
            pulumi.set(__self__, "verify_content", verify_content)

    @property
    @pulumi.getter
    def cn(self) -> Optional[pulumi.Input[str]]:
        """
        The CN name of the device CA certificate.
        """
        return pulumi.get(self, "cn")

    @cn.setter
    def cn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cn", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the content of device CA certificate.
        Changing this parameter will create a new resource. Create a private CA certificate,
        please following [reference](https://support.huaweicloud.com/usermanual-iothub/iot_01_0104.html)
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="effectiveDate")
    def effective_date(self) -> Optional[pulumi.Input[str]]:
        """
        The effective date of the device CA certificate.
        The format is: **yyyyMMdd'T'HHmmss'Z'**, e.g., **20151212T121212Z**.
        """
        return pulumi.get(self, "effective_date")

    @effective_date.setter
    def effective_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effective_date", value)

    @property
    @pulumi.getter(name="expiryDate")
    def expiry_date(self) -> Optional[pulumi.Input[str]]:
        """
        The expiry date of the device CA certificate.
        The format is: **yyyyMMdd'T'HHmmss'Z'**, e.g., **20151212T121212Z**.
        """
        return pulumi.get(self, "expiry_date")

    @expiry_date.setter
    def expiry_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiry_date", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[str]]:
        """
        The owner of the device CA certificate.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the IoTDA device CA certificate
        resource. If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="spaceId")
    def space_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the resource space ID to which the device CA certificate belongs.
        If omitted, the certificate will belong to the default resource space.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "space_id")

    @space_id.setter
    def space_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "space_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the device CA certificate. The valid values are **Unverified** and **Verified**.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="verifyCode")
    def verify_code(self) -> Optional[pulumi.Input[str]]:
        """
        The verify code of the device CA certificate.
        """
        return pulumi.get(self, "verify_code")

    @verify_code.setter
    def verify_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "verify_code", value)

    @property
    @pulumi.getter(name="verifyContent")
    def verify_content(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the content of verification certificate. Can only be used to verify
        the validity of the device CA certificate after creation. Get the verification certificate,
        please following [reference](https://support.huaweicloud.com/usermanual-iothub/iot_01_0106.html)
        """
        return pulumi.get(self, "verify_content")

    @verify_content.setter
    def verify_content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "verify_content", value)


class DeviceCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 space_id: Optional[pulumi.Input[str]] = None,
                 verify_content: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an IoTDA device CA certificate within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        certificate_content = config.require_object("certificateContent")
        test = huaweicloud.io_tda.DeviceCertificate("test", content=certificate_content)
        ```

        ## Import

        Device CA certificates can be imported by `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:IoTDA/deviceCertificate:DeviceCertificate test 62b3cec5558d4b703f064534
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`content`, `space_id`, `verify_content`. It is generally recommended running `terraform plan` after importing the resource. You can then decide if changes should be applied to the resource, or the resource definition should be updated to align with the group. Also you can ignore changes as below. resource "huaweicloud_iotda_device_certificate" "test" {

         ...

         lifecycle {

         ignore_changes = [

         content, space_id, verify_content

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] content: Specifies the content of device CA certificate.
               Changing this parameter will create a new resource. Create a private CA certificate,
               please following [reference](https://support.huaweicloud.com/usermanual-iothub/iot_01_0104.html)
        :param pulumi.Input[str] region: Specifies the region in which to create the IoTDA device CA certificate
               resource. If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] space_id: Specifies the resource space ID to which the device CA certificate belongs.
               If omitted, the certificate will belong to the default resource space.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] verify_content: Specifies the content of verification certificate. Can only be used to verify
               the validity of the device CA certificate after creation. Get the verification certificate,
               please following [reference](https://support.huaweicloud.com/usermanual-iothub/iot_01_0106.html)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeviceCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an IoTDA device CA certificate within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        certificate_content = config.require_object("certificateContent")
        test = huaweicloud.io_tda.DeviceCertificate("test", content=certificate_content)
        ```

        ## Import

        Device CA certificates can be imported by `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:IoTDA/deviceCertificate:DeviceCertificate test 62b3cec5558d4b703f064534
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`content`, `space_id`, `verify_content`. It is generally recommended running `terraform plan` after importing the resource. You can then decide if changes should be applied to the resource, or the resource definition should be updated to align with the group. Also you can ignore changes as below. resource "huaweicloud_iotda_device_certificate" "test" {

         ...

         lifecycle {

         ignore_changes = [

         content, space_id, verify_content

         ]

         } }

        :param str resource_name: The name of the resource.
        :param DeviceCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeviceCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 space_id: Optional[pulumi.Input[str]] = None,
                 verify_content: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeviceCertificateArgs.__new__(DeviceCertificateArgs)

            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            __props__.__dict__["region"] = region
            __props__.__dict__["space_id"] = space_id
            __props__.__dict__["verify_content"] = verify_content
            __props__.__dict__["cn"] = None
            __props__.__dict__["effective_date"] = None
            __props__.__dict__["expiry_date"] = None
            __props__.__dict__["owner"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["verify_code"] = None
        super(DeviceCertificate, __self__).__init__(
            'huaweicloud:IoTDA/deviceCertificate:DeviceCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cn: Optional[pulumi.Input[str]] = None,
            content: Optional[pulumi.Input[str]] = None,
            effective_date: Optional[pulumi.Input[str]] = None,
            expiry_date: Optional[pulumi.Input[str]] = None,
            owner: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            space_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            verify_code: Optional[pulumi.Input[str]] = None,
            verify_content: Optional[pulumi.Input[str]] = None) -> 'DeviceCertificate':
        """
        Get an existing DeviceCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cn: The CN name of the device CA certificate.
        :param pulumi.Input[str] content: Specifies the content of device CA certificate.
               Changing this parameter will create a new resource. Create a private CA certificate,
               please following [reference](https://support.huaweicloud.com/usermanual-iothub/iot_01_0104.html)
        :param pulumi.Input[str] effective_date: The effective date of the device CA certificate.
               The format is: **yyyyMMdd'T'HHmmss'Z'**, e.g., **20151212T121212Z**.
        :param pulumi.Input[str] expiry_date: The expiry date of the device CA certificate.
               The format is: **yyyyMMdd'T'HHmmss'Z'**, e.g., **20151212T121212Z**.
        :param pulumi.Input[str] owner: The owner of the device CA certificate.
        :param pulumi.Input[str] region: Specifies the region in which to create the IoTDA device CA certificate
               resource. If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] space_id: Specifies the resource space ID to which the device CA certificate belongs.
               If omitted, the certificate will belong to the default resource space.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] status: The status of the device CA certificate. The valid values are **Unverified** and **Verified**.
        :param pulumi.Input[str] verify_code: The verify code of the device CA certificate.
        :param pulumi.Input[str] verify_content: Specifies the content of verification certificate. Can only be used to verify
               the validity of the device CA certificate after creation. Get the verification certificate,
               please following [reference](https://support.huaweicloud.com/usermanual-iothub/iot_01_0106.html)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeviceCertificateState.__new__(_DeviceCertificateState)

        __props__.__dict__["cn"] = cn
        __props__.__dict__["content"] = content
        __props__.__dict__["effective_date"] = effective_date
        __props__.__dict__["expiry_date"] = expiry_date
        __props__.__dict__["owner"] = owner
        __props__.__dict__["region"] = region
        __props__.__dict__["space_id"] = space_id
        __props__.__dict__["status"] = status
        __props__.__dict__["verify_code"] = verify_code
        __props__.__dict__["verify_content"] = verify_content
        return DeviceCertificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cn(self) -> pulumi.Output[str]:
        """
        The CN name of the device CA certificate.
        """
        return pulumi.get(self, "cn")

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[str]:
        """
        Specifies the content of device CA certificate.
        Changing this parameter will create a new resource. Create a private CA certificate,
        please following [reference](https://support.huaweicloud.com/usermanual-iothub/iot_01_0104.html)
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="effectiveDate")
    def effective_date(self) -> pulumi.Output[str]:
        """
        The effective date of the device CA certificate.
        The format is: **yyyyMMdd'T'HHmmss'Z'**, e.g., **20151212T121212Z**.
        """
        return pulumi.get(self, "effective_date")

    @property
    @pulumi.getter(name="expiryDate")
    def expiry_date(self) -> pulumi.Output[str]:
        """
        The expiry date of the device CA certificate.
        The format is: **yyyyMMdd'T'HHmmss'Z'**, e.g., **20151212T121212Z**.
        """
        return pulumi.get(self, "expiry_date")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[str]:
        """
        The owner of the device CA certificate.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the IoTDA device CA certificate
        resource. If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="spaceId")
    def space_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the resource space ID to which the device CA certificate belongs.
        If omitted, the certificate will belong to the default resource space.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "space_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the device CA certificate. The valid values are **Unverified** and **Verified**.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="verifyCode")
    def verify_code(self) -> pulumi.Output[str]:
        """
        The verify code of the device CA certificate.
        """
        return pulumi.get(self, "verify_code")

    @property
    @pulumi.getter(name="verifyContent")
    def verify_content(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the content of verification certificate. Can only be used to verify
        the validity of the device CA certificate after creation. Get the verification certificate,
        please following [reference](https://support.huaweicloud.com/usermanual-iothub/iot_01_0106.html)
        """
        return pulumi.get(self, "verify_content")

