# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerArgs', 'Server']

@pulumi.input_type
class ServerArgs:
    def __init__(__self__, *,
                 coverage_sites: pulumi.Input[Sequence[pulumi.Input['ServerCoverageSiteArgs']]],
                 flavor_id: pulumi.Input[str],
                 image_id: pulumi.Input[str],
                 security_groups: pulumi.Input[Sequence[pulumi.Input[str]]],
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 system_disk_size: pulumi.Input[int],
                 system_disk_type: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 admin_pass: Optional[pulumi.Input[str]] = None,
                 bind_eip: Optional[pulumi.Input[bool]] = None,
                 coverage_level: Optional[pulumi.Input[str]] = None,
                 coverage_policy: Optional[pulumi.Input[str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['ServerDataDiskArgs']]]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Server resource.
        :param pulumi.Input[Sequence[pulumi.Input['ServerCoverageSiteArgs']]] coverage_sites: Specifies an array of site ID and operator for the IEC server. The
               object structure is documented below. Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID of the desired flavor for the IEC server. Changing
               this parameter creates a new IEC server resource.
        :param pulumi.Input[str] image_id: Specifies the image ID of the desired image for the IEC server. Changing
               this parameter creates a new IEC server resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: Specifies an array of one or more security group IDs to associate with
               the IEC server. Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: Specifies an array of one or more subnet ID of Network for the IEC server
               binding. Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[int] system_disk_size: Specifies the size of system disk for the IEC server binding. The
               value range is 40 to 100 in GB. Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[str] system_disk_type: Specifies the type of system disk for the IEC server binding. Valid
               value is *SAS*(high I/O disk type). Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[str] vpc_id: Specifies the ID of vpc for the IEC server. VPC mode only *CUSTOMER* can be
               used to create IEC server. Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[str] admin_pass: Specifies the administrative password to assign to the IEC server. This
               parameter can contain a maximum of 26 characters, which may consist of letters, digits and Special characters(~!?,.:
               ;-_'"(){}[]/<>@#$%^&*+|\\\\=) and space. This parameter and `key_pair` are alternative. Changing this changes the root
               password on the existing server.
        :param pulumi.Input[bool] bind_eip: Specifies whether the IEC server is bound to EIP. Changing this parameter
               creates a new IEC server resource.
        :param pulumi.Input[str] coverage_level: Specifies the coverage level of IEC sites. Valid value is *SITE*.
               Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[str] coverage_policy: Specifies the policy of IEC sites. Valid values are *centralize*
               and *discrete*, *centralize* is default. Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[Sequence[pulumi.Input['ServerDataDiskArgs']]] data_disks: Specifies the array of data disks to attach to the IEC server. Up to two
               data disks can be specified. The object structure is documented below. Changing this parameter creates a new IEC
               server resource.
        :param pulumi.Input[str] key_pair: Specifies the name of a key pair to put on the IEC server. The key pair must
               already be created and associated with the tenant's account. This parameter and `admin_pass` are alternative. Changing
               this parameter creates a new IEC server resource.
        :param pulumi.Input[str] name: Specifies the IEC server name. This parameter can contain a maximum of 64
               characters, which may consist of letters, digits, dot(.), underscores (_), and hyphens (-). Changing this parameter
               creates a new IEC server resource.
        :param pulumi.Input[str] user_data: Specifies the user data (information after encoding) configured during IEC
               server creation. The value can come from a variety of sources: inline, read in from the *file* function. Changing this
               parameter creates a new IEC server resource.
        """
        pulumi.set(__self__, "coverage_sites", coverage_sites)
        pulumi.set(__self__, "flavor_id", flavor_id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "security_groups", security_groups)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        pulumi.set(__self__, "system_disk_size", system_disk_size)
        pulumi.set(__self__, "system_disk_type", system_disk_type)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if admin_pass is not None:
            pulumi.set(__self__, "admin_pass", admin_pass)
        if bind_eip is not None:
            pulumi.set(__self__, "bind_eip", bind_eip)
        if coverage_level is not None:
            pulumi.set(__self__, "coverage_level", coverage_level)
        if coverage_policy is not None:
            pulumi.set(__self__, "coverage_policy", coverage_policy)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @property
    @pulumi.getter(name="coverageSites")
    def coverage_sites(self) -> pulumi.Input[Sequence[pulumi.Input['ServerCoverageSiteArgs']]]:
        """
        Specifies an array of site ID and operator for the IEC server. The
        object structure is documented below. Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "coverage_sites")

    @coverage_sites.setter
    def coverage_sites(self, value: pulumi.Input[Sequence[pulumi.Input['ServerCoverageSiteArgs']]]):
        pulumi.set(self, "coverage_sites", value)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Input[str]:
        """
        Specifies the flavor ID of the desired flavor for the IEC server. Changing
        this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[str]:
        """
        Specifies the image ID of the desired image for the IEC server. Changing
        this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies an array of one or more security group IDs to associate with
        the IEC server. Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies an array of one or more subnet ID of Network for the IEC server
        binding. Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> pulumi.Input[int]:
        """
        Specifies the size of system disk for the IEC server binding. The
        value range is 40 to 100 in GB. Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "system_disk_size", value)

    @property
    @pulumi.getter(name="systemDiskType")
    def system_disk_type(self) -> pulumi.Input[str]:
        """
        Specifies the type of system disk for the IEC server binding. Valid
        value is *SAS*(high I/O disk type). Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "system_disk_type")

    @system_disk_type.setter
    def system_disk_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "system_disk_type", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of vpc for the IEC server. VPC mode only *CUSTOMER* can be
        used to create IEC server. Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the administrative password to assign to the IEC server. This
        parameter can contain a maximum of 26 characters, which may consist of letters, digits and Special characters(~!?,.:
        ;-_'"(){}[]/<>@#$%^&*+|\\\\=) and space. This parameter and `key_pair` are alternative. Changing this changes the root
        password on the existing server.
        """
        return pulumi.get(self, "admin_pass")

    @admin_pass.setter
    def admin_pass(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_pass", value)

    @property
    @pulumi.getter(name="bindEip")
    def bind_eip(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the IEC server is bound to EIP. Changing this parameter
        creates a new IEC server resource.
        """
        return pulumi.get(self, "bind_eip")

    @bind_eip.setter
    def bind_eip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bind_eip", value)

    @property
    @pulumi.getter(name="coverageLevel")
    def coverage_level(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the coverage level of IEC sites. Valid value is *SITE*.
        Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "coverage_level")

    @coverage_level.setter
    def coverage_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "coverage_level", value)

    @property
    @pulumi.getter(name="coveragePolicy")
    def coverage_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the policy of IEC sites. Valid values are *centralize*
        and *discrete*, *centralize* is default. Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "coverage_policy")

    @coverage_policy.setter
    def coverage_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "coverage_policy", value)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerDataDiskArgs']]]]:
        """
        Specifies the array of data disks to attach to the IEC server. Up to two
        data disks can be specified. The object structure is documented below. Changing this parameter creates a new IEC
        server resource.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of a key pair to put on the IEC server. The key pair must
        already be created and associated with the tenant's account. This parameter and `admin_pass` are alternative. Changing
        this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IEC server name. This parameter can contain a maximum of 64
        characters, which may consist of letters, digits, dot(.), underscores (_), and hyphens (-). Changing this parameter
        creates a new IEC server resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user data (information after encoding) configured during IEC
        server creation. The value can come from a variety of sources: inline, read in from the *file* function. Changing this
        parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)


@pulumi.input_type
class _ServerState:
    def __init__(__self__, *,
                 admin_pass: Optional[pulumi.Input[str]] = None,
                 bind_eip: Optional[pulumi.Input[bool]] = None,
                 coverage_level: Optional[pulumi.Input[str]] = None,
                 coverage_policy: Optional[pulumi.Input[str]] = None,
                 coverage_sites: Optional[pulumi.Input[Sequence[pulumi.Input['ServerCoverageSiteArgs']]]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['ServerDataDiskArgs']]]] = None,
                 edgecloud_id: Optional[pulumi.Input[str]] = None,
                 edgecloud_name: Optional[pulumi.Input[str]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 flavor_name: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 image_name: Optional[pulumi.Input[str]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nics: Optional[pulumi.Input[Sequence[pulumi.Input['ServerNicArgs']]]] = None,
                 origin_server_id: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 system_disk_id: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 system_disk_type: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 volume_attacheds: Optional[pulumi.Input[Sequence[pulumi.Input['ServerVolumeAttachedArgs']]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Server resources.
        :param pulumi.Input[str] admin_pass: Specifies the administrative password to assign to the IEC server. This
               parameter can contain a maximum of 26 characters, which may consist of letters, digits and Special characters(~!?,.:
               ;-_'"(){}[]/<>@#$%^&*+|\\\\=) and space. This parameter and `key_pair` are alternative. Changing this changes the root
               password on the existing server.
        :param pulumi.Input[bool] bind_eip: Specifies whether the IEC server is bound to EIP. Changing this parameter
               creates a new IEC server resource.
        :param pulumi.Input[str] coverage_level: Specifies the coverage level of IEC sites. Valid value is *SITE*.
               Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[str] coverage_policy: Specifies the policy of IEC sites. Valid values are *centralize*
               and *discrete*, *centralize* is default. Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[Sequence[pulumi.Input['ServerCoverageSiteArgs']]] coverage_sites: Specifies an array of site ID and operator for the IEC server. The
               object structure is documented below. Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[Sequence[pulumi.Input['ServerDataDiskArgs']]] data_disks: Specifies the array of data disks to attach to the IEC server. Up to two
               data disks can be specified. The object structure is documented below. Changing this parameter creates a new IEC
               server resource.
        :param pulumi.Input[str] edgecloud_id: The ID of the edgecloud service.
        :param pulumi.Input[str] edgecloud_name: The Name of the edgecloud service.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID of the desired flavor for the IEC server. Changing
               this parameter creates a new IEC server resource.
        :param pulumi.Input[str] flavor_name: The flavor name of the IEC server.
        :param pulumi.Input[str] image_id: Specifies the image ID of the desired image for the IEC server. Changing
               this parameter creates a new IEC server resource.
        :param pulumi.Input[str] image_name: The image name of the IEC server.
        :param pulumi.Input[str] key_pair: Specifies the name of a key pair to put on the IEC server. The key pair must
               already be created and associated with the tenant's account. This parameter and `admin_pass` are alternative. Changing
               this parameter creates a new IEC server resource.
        :param pulumi.Input[str] name: Specifies the IEC server name. This parameter can contain a maximum of 64
               characters, which may consist of letters, digits, dot(.), underscores (_), and hyphens (-). Changing this parameter
               creates a new IEC server resource.
        :param pulumi.Input[Sequence[pulumi.Input['ServerNicArgs']]] nics: An array of one or more networks to attach to the IEC server. The object structure is documented below.
        :param pulumi.Input[str] origin_server_id: The ID of origin server.
        :param pulumi.Input[str] public_ip: The EIP address that is associted to the IEC server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: Specifies an array of one or more security group IDs to associate with
               the IEC server. Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[str] status: The status of IEC server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: Specifies an array of one or more subnet ID of Network for the IEC server
               binding. Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[str] system_disk_id: The system disk voume ID.
        :param pulumi.Input[int] system_disk_size: Specifies the size of system disk for the IEC server binding. The
               value range is 40 to 100 in GB. Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[str] system_disk_type: Specifies the type of system disk for the IEC server binding. Valid
               value is *SAS*(high I/O disk type). Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[str] user_data: Specifies the user data (information after encoding) configured during IEC
               server creation. The value can come from a variety of sources: inline, read in from the *file* function. Changing this
               parameter creates a new IEC server resource.
        :param pulumi.Input[Sequence[pulumi.Input['ServerVolumeAttachedArgs']]] volume_attacheds: An array of one or more disks to attach to the IEC server. The object structure is documented
               below.
        :param pulumi.Input[str] vpc_id: Specifies the ID of vpc for the IEC server. VPC mode only *CUSTOMER* can be
               used to create IEC server. Changing this parameter creates a new IEC server resource.
        """
        if admin_pass is not None:
            pulumi.set(__self__, "admin_pass", admin_pass)
        if bind_eip is not None:
            pulumi.set(__self__, "bind_eip", bind_eip)
        if coverage_level is not None:
            pulumi.set(__self__, "coverage_level", coverage_level)
        if coverage_policy is not None:
            pulumi.set(__self__, "coverage_policy", coverage_policy)
        if coverage_sites is not None:
            pulumi.set(__self__, "coverage_sites", coverage_sites)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if edgecloud_id is not None:
            pulumi.set(__self__, "edgecloud_id", edgecloud_id)
        if edgecloud_name is not None:
            pulumi.set(__self__, "edgecloud_name", edgecloud_name)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if flavor_name is not None:
            pulumi.set(__self__, "flavor_name", flavor_name)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nics is not None:
            pulumi.set(__self__, "nics", nics)
        if origin_server_id is not None:
            pulumi.set(__self__, "origin_server_id", origin_server_id)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if system_disk_id is not None:
            pulumi.set(__self__, "system_disk_id", system_disk_id)
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if system_disk_type is not None:
            pulumi.set(__self__, "system_disk_type", system_disk_type)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if volume_attacheds is not None:
            pulumi.set(__self__, "volume_attacheds", volume_attacheds)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the administrative password to assign to the IEC server. This
        parameter can contain a maximum of 26 characters, which may consist of letters, digits and Special characters(~!?,.:
        ;-_'"(){}[]/<>@#$%^&*+|\\\\=) and space. This parameter and `key_pair` are alternative. Changing this changes the root
        password on the existing server.
        """
        return pulumi.get(self, "admin_pass")

    @admin_pass.setter
    def admin_pass(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_pass", value)

    @property
    @pulumi.getter(name="bindEip")
    def bind_eip(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the IEC server is bound to EIP. Changing this parameter
        creates a new IEC server resource.
        """
        return pulumi.get(self, "bind_eip")

    @bind_eip.setter
    def bind_eip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bind_eip", value)

    @property
    @pulumi.getter(name="coverageLevel")
    def coverage_level(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the coverage level of IEC sites. Valid value is *SITE*.
        Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "coverage_level")

    @coverage_level.setter
    def coverage_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "coverage_level", value)

    @property
    @pulumi.getter(name="coveragePolicy")
    def coverage_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the policy of IEC sites. Valid values are *centralize*
        and *discrete*, *centralize* is default. Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "coverage_policy")

    @coverage_policy.setter
    def coverage_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "coverage_policy", value)

    @property
    @pulumi.getter(name="coverageSites")
    def coverage_sites(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerCoverageSiteArgs']]]]:
        """
        Specifies an array of site ID and operator for the IEC server. The
        object structure is documented below. Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "coverage_sites")

    @coverage_sites.setter
    def coverage_sites(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerCoverageSiteArgs']]]]):
        pulumi.set(self, "coverage_sites", value)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerDataDiskArgs']]]]:
        """
        Specifies the array of data disks to attach to the IEC server. Up to two
        data disks can be specified. The object structure is documented below. Changing this parameter creates a new IEC
        server resource.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter(name="edgecloudId")
    def edgecloud_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the edgecloud service.
        """
        return pulumi.get(self, "edgecloud_id")

    @edgecloud_id.setter
    def edgecloud_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edgecloud_id", value)

    @property
    @pulumi.getter(name="edgecloudName")
    def edgecloud_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Name of the edgecloud service.
        """
        return pulumi.get(self, "edgecloud_name")

    @edgecloud_name.setter
    def edgecloud_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edgecloud_name", value)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the flavor ID of the desired flavor for the IEC server. Changing
        this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> Optional[pulumi.Input[str]]:
        """
        The flavor name of the IEC server.
        """
        return pulumi.get(self, "flavor_name")

    @flavor_name.setter
    def flavor_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor_name", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the image ID of the desired image for the IEC server. Changing
        this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[str]]:
        """
        The image name of the IEC server.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_name", value)

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of a key pair to put on the IEC server. The key pair must
        already be created and associated with the tenant's account. This parameter and `admin_pass` are alternative. Changing
        this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IEC server name. This parameter can contain a maximum of 64
        characters, which may consist of letters, digits, dot(.), underscores (_), and hyphens (-). Changing this parameter
        creates a new IEC server resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def nics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerNicArgs']]]]:
        """
        An array of one or more networks to attach to the IEC server. The object structure is documented below.
        """
        return pulumi.get(self, "nics")

    @nics.setter
    def nics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerNicArgs']]]]):
        pulumi.set(self, "nics", value)

    @property
    @pulumi.getter(name="originServerId")
    def origin_server_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of origin server.
        """
        return pulumi.get(self, "origin_server_id")

    @origin_server_id.setter
    def origin_server_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "origin_server_id", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The EIP address that is associted to the IEC server.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies an array of one or more security group IDs to associate with
        the IEC server. Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of IEC server.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies an array of one or more subnet ID of Network for the IEC server
        binding. Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="systemDiskId")
    def system_disk_id(self) -> Optional[pulumi.Input[str]]:
        """
        The system disk voume ID.
        """
        return pulumi.get(self, "system_disk_id")

    @system_disk_id.setter
    def system_disk_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_id", value)

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the size of system disk for the IEC server binding. The
        value range is 40 to 100 in GB. Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "system_disk_size", value)

    @property
    @pulumi.getter(name="systemDiskType")
    def system_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of system disk for the IEC server binding. Valid
        value is *SAS*(high I/O disk type). Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "system_disk_type")

    @system_disk_type.setter
    def system_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_type", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user data (information after encoding) configured during IEC
        server creation. The value can come from a variety of sources: inline, read in from the *file* function. Changing this
        parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="volumeAttacheds")
    def volume_attacheds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerVolumeAttachedArgs']]]]:
        """
        An array of one or more disks to attach to the IEC server. The object structure is documented
        below.
        """
        return pulumi.get(self, "volume_attacheds")

    @volume_attacheds.setter
    def volume_attacheds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerVolumeAttachedArgs']]]]):
        pulumi.set(self, "volume_attacheds", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of vpc for the IEC server. VPC mode only *CUSTOMER* can be
        used to create IEC server. Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Server(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_pass: Optional[pulumi.Input[str]] = None,
                 bind_eip: Optional[pulumi.Input[bool]] = None,
                 coverage_level: Optional[pulumi.Input[str]] = None,
                 coverage_policy: Optional[pulumi.Input[str]] = None,
                 coverage_sites: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerCoverageSiteArgs']]]]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerDataDiskArgs']]]]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 system_disk_type: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a IEC server resource within HuaweiCloud.

        ## Example Usage
        ### Basic Server Instance

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        iec_server_name = config.require_object("iecServerName")
        iec_iamge_id = config.require_object("iecIamgeId")
        iec_flavor_id = config.require_object("iecFlavorId")
        iec_site_id = config.require_object("iecSiteId")
        iec_site_operator = config.require_object("iecSiteOperator")
        iec_vpc_id = config.require_object("iecVpcId")
        iec_subnet_id = config.require_object("iecSubnetId")
        iec_secgroup_id = config.require_object("iecSecgroupId")
        iec_server_password = config.require_object("iecServerPassword")
        server_test = huaweicloud.iec.Server("serverTest",
            image_id=iec_iamge_id,
            flavor_id=iec_flavor_id,
            vpc_id=iec_vpc_id,
            subnet_ids=[iec_subnet_id],
            security_groups=[iec_secgroup_id],
            admin_pass=iec_server_password,
            bind_eip=True,
            system_disk_type="SAS",
            system_disk_size=40,
            coverage_sites=[huaweicloud.iec.ServerCoverageSiteArgs(
                site_id=iec_site_id,
                operator=iec_site_operator,
            )])
        ```
        ### Server Instance With Multiple Data Disks

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        iec_server_name = config.require_object("iecServerName")
        iec_iamge_id = config.require_object("iecIamgeId")
        iec_flavor_id = config.require_object("iecFlavorId")
        iec_site_id = config.require_object("iecSiteId")
        iec_site_operator = config.require_object("iecSiteOperator")
        iec_vpc_id = config.require_object("iecVpcId")
        iec_subnet_id = config.require_object("iecSubnetId")
        iec_secgroup_id = config.require_object("iecSecgroupId")
        iec_server_password = config.require_object("iecServerPassword")
        server_test = huaweicloud.iec.Server("serverTest",
            image_id=iec_iamge_id,
            flavor_id=iec_flavor_id,
            vpc_id=iec_vpc_id,
            subnet_ids=[iec_subnet_id],
            security_groups=[iec_secgroup_id],
            admin_pass=iec_server_password,
            bind_eip=True,
            system_disk_type="SAS",
            system_disk_size=40,
            data_disks=[
                huaweicloud.iec.ServerDataDiskArgs(
                    type="SAS",
                    size=20,
                ),
                huaweicloud.iec.ServerDataDiskArgs(
                    type="SAS",
                    size=40,
                ),
            ],
            coverage_sites=[huaweicloud.iec.ServerCoverageSiteArgs(
                site_id=iec_site_id,
                operator=iec_site_operator,
            )])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_pass: Specifies the administrative password to assign to the IEC server. This
               parameter can contain a maximum of 26 characters, which may consist of letters, digits and Special characters(~!?,.:
               ;-_'"(){}[]/<>@#$%^&*+|\\\\=) and space. This parameter and `key_pair` are alternative. Changing this changes the root
               password on the existing server.
        :param pulumi.Input[bool] bind_eip: Specifies whether the IEC server is bound to EIP. Changing this parameter
               creates a new IEC server resource.
        :param pulumi.Input[str] coverage_level: Specifies the coverage level of IEC sites. Valid value is *SITE*.
               Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[str] coverage_policy: Specifies the policy of IEC sites. Valid values are *centralize*
               and *discrete*, *centralize* is default. Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerCoverageSiteArgs']]]] coverage_sites: Specifies an array of site ID and operator for the IEC server. The
               object structure is documented below. Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerDataDiskArgs']]]] data_disks: Specifies the array of data disks to attach to the IEC server. Up to two
               data disks can be specified. The object structure is documented below. Changing this parameter creates a new IEC
               server resource.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID of the desired flavor for the IEC server. Changing
               this parameter creates a new IEC server resource.
        :param pulumi.Input[str] image_id: Specifies the image ID of the desired image for the IEC server. Changing
               this parameter creates a new IEC server resource.
        :param pulumi.Input[str] key_pair: Specifies the name of a key pair to put on the IEC server. The key pair must
               already be created and associated with the tenant's account. This parameter and `admin_pass` are alternative. Changing
               this parameter creates a new IEC server resource.
        :param pulumi.Input[str] name: Specifies the IEC server name. This parameter can contain a maximum of 64
               characters, which may consist of letters, digits, dot(.), underscores (_), and hyphens (-). Changing this parameter
               creates a new IEC server resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: Specifies an array of one or more security group IDs to associate with
               the IEC server. Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: Specifies an array of one or more subnet ID of Network for the IEC server
               binding. Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[int] system_disk_size: Specifies the size of system disk for the IEC server binding. The
               value range is 40 to 100 in GB. Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[str] system_disk_type: Specifies the type of system disk for the IEC server binding. Valid
               value is *SAS*(high I/O disk type). Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[str] user_data: Specifies the user data (information after encoding) configured during IEC
               server creation. The value can come from a variety of sources: inline, read in from the *file* function. Changing this
               parameter creates a new IEC server resource.
        :param pulumi.Input[str] vpc_id: Specifies the ID of vpc for the IEC server. VPC mode only *CUSTOMER* can be
               used to create IEC server. Changing this parameter creates a new IEC server resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a IEC server resource within HuaweiCloud.

        ## Example Usage
        ### Basic Server Instance

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        iec_server_name = config.require_object("iecServerName")
        iec_iamge_id = config.require_object("iecIamgeId")
        iec_flavor_id = config.require_object("iecFlavorId")
        iec_site_id = config.require_object("iecSiteId")
        iec_site_operator = config.require_object("iecSiteOperator")
        iec_vpc_id = config.require_object("iecVpcId")
        iec_subnet_id = config.require_object("iecSubnetId")
        iec_secgroup_id = config.require_object("iecSecgroupId")
        iec_server_password = config.require_object("iecServerPassword")
        server_test = huaweicloud.iec.Server("serverTest",
            image_id=iec_iamge_id,
            flavor_id=iec_flavor_id,
            vpc_id=iec_vpc_id,
            subnet_ids=[iec_subnet_id],
            security_groups=[iec_secgroup_id],
            admin_pass=iec_server_password,
            bind_eip=True,
            system_disk_type="SAS",
            system_disk_size=40,
            coverage_sites=[huaweicloud.iec.ServerCoverageSiteArgs(
                site_id=iec_site_id,
                operator=iec_site_operator,
            )])
        ```
        ### Server Instance With Multiple Data Disks

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        iec_server_name = config.require_object("iecServerName")
        iec_iamge_id = config.require_object("iecIamgeId")
        iec_flavor_id = config.require_object("iecFlavorId")
        iec_site_id = config.require_object("iecSiteId")
        iec_site_operator = config.require_object("iecSiteOperator")
        iec_vpc_id = config.require_object("iecVpcId")
        iec_subnet_id = config.require_object("iecSubnetId")
        iec_secgroup_id = config.require_object("iecSecgroupId")
        iec_server_password = config.require_object("iecServerPassword")
        server_test = huaweicloud.iec.Server("serverTest",
            image_id=iec_iamge_id,
            flavor_id=iec_flavor_id,
            vpc_id=iec_vpc_id,
            subnet_ids=[iec_subnet_id],
            security_groups=[iec_secgroup_id],
            admin_pass=iec_server_password,
            bind_eip=True,
            system_disk_type="SAS",
            system_disk_size=40,
            data_disks=[
                huaweicloud.iec.ServerDataDiskArgs(
                    type="SAS",
                    size=20,
                ),
                huaweicloud.iec.ServerDataDiskArgs(
                    type="SAS",
                    size=40,
                ),
            ],
            coverage_sites=[huaweicloud.iec.ServerCoverageSiteArgs(
                site_id=iec_site_id,
                operator=iec_site_operator,
            )])
        ```

        :param str resource_name: The name of the resource.
        :param ServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_pass: Optional[pulumi.Input[str]] = None,
                 bind_eip: Optional[pulumi.Input[bool]] = None,
                 coverage_level: Optional[pulumi.Input[str]] = None,
                 coverage_policy: Optional[pulumi.Input[str]] = None,
                 coverage_sites: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerCoverageSiteArgs']]]]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerDataDiskArgs']]]]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 system_disk_type: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerArgs.__new__(ServerArgs)

            __props__.__dict__["admin_pass"] = admin_pass
            __props__.__dict__["bind_eip"] = bind_eip
            __props__.__dict__["coverage_level"] = coverage_level
            __props__.__dict__["coverage_policy"] = coverage_policy
            if coverage_sites is None and not opts.urn:
                raise TypeError("Missing required property 'coverage_sites'")
            __props__.__dict__["coverage_sites"] = coverage_sites
            __props__.__dict__["data_disks"] = data_disks
            if flavor_id is None and not opts.urn:
                raise TypeError("Missing required property 'flavor_id'")
            __props__.__dict__["flavor_id"] = flavor_id
            if image_id is None and not opts.urn:
                raise TypeError("Missing required property 'image_id'")
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["key_pair"] = key_pair
            __props__.__dict__["name"] = name
            if security_groups is None and not opts.urn:
                raise TypeError("Missing required property 'security_groups'")
            __props__.__dict__["security_groups"] = security_groups
            if subnet_ids is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_ids'")
            __props__.__dict__["subnet_ids"] = subnet_ids
            if system_disk_size is None and not opts.urn:
                raise TypeError("Missing required property 'system_disk_size'")
            __props__.__dict__["system_disk_size"] = system_disk_size
            if system_disk_type is None and not opts.urn:
                raise TypeError("Missing required property 'system_disk_type'")
            __props__.__dict__["system_disk_type"] = system_disk_type
            __props__.__dict__["user_data"] = user_data
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["edgecloud_id"] = None
            __props__.__dict__["edgecloud_name"] = None
            __props__.__dict__["flavor_name"] = None
            __props__.__dict__["image_name"] = None
            __props__.__dict__["nics"] = None
            __props__.__dict__["origin_server_id"] = None
            __props__.__dict__["public_ip"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["system_disk_id"] = None
            __props__.__dict__["volume_attacheds"] = None
        super(Server, __self__).__init__(
            'huaweicloud:Iec/server:Server',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_pass: Optional[pulumi.Input[str]] = None,
            bind_eip: Optional[pulumi.Input[bool]] = None,
            coverage_level: Optional[pulumi.Input[str]] = None,
            coverage_policy: Optional[pulumi.Input[str]] = None,
            coverage_sites: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerCoverageSiteArgs']]]]] = None,
            data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerDataDiskArgs']]]]] = None,
            edgecloud_id: Optional[pulumi.Input[str]] = None,
            edgecloud_name: Optional[pulumi.Input[str]] = None,
            flavor_id: Optional[pulumi.Input[str]] = None,
            flavor_name: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            image_name: Optional[pulumi.Input[str]] = None,
            key_pair: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            nics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerNicArgs']]]]] = None,
            origin_server_id: Optional[pulumi.Input[str]] = None,
            public_ip: Optional[pulumi.Input[str]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            system_disk_id: Optional[pulumi.Input[str]] = None,
            system_disk_size: Optional[pulumi.Input[int]] = None,
            system_disk_type: Optional[pulumi.Input[str]] = None,
            user_data: Optional[pulumi.Input[str]] = None,
            volume_attacheds: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerVolumeAttachedArgs']]]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'Server':
        """
        Get an existing Server resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_pass: Specifies the administrative password to assign to the IEC server. This
               parameter can contain a maximum of 26 characters, which may consist of letters, digits and Special characters(~!?,.:
               ;-_'"(){}[]/<>@#$%^&*+|\\\\=) and space. This parameter and `key_pair` are alternative. Changing this changes the root
               password on the existing server.
        :param pulumi.Input[bool] bind_eip: Specifies whether the IEC server is bound to EIP. Changing this parameter
               creates a new IEC server resource.
        :param pulumi.Input[str] coverage_level: Specifies the coverage level of IEC sites. Valid value is *SITE*.
               Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[str] coverage_policy: Specifies the policy of IEC sites. Valid values are *centralize*
               and *discrete*, *centralize* is default. Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerCoverageSiteArgs']]]] coverage_sites: Specifies an array of site ID and operator for the IEC server. The
               object structure is documented below. Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerDataDiskArgs']]]] data_disks: Specifies the array of data disks to attach to the IEC server. Up to two
               data disks can be specified. The object structure is documented below. Changing this parameter creates a new IEC
               server resource.
        :param pulumi.Input[str] edgecloud_id: The ID of the edgecloud service.
        :param pulumi.Input[str] edgecloud_name: The Name of the edgecloud service.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID of the desired flavor for the IEC server. Changing
               this parameter creates a new IEC server resource.
        :param pulumi.Input[str] flavor_name: The flavor name of the IEC server.
        :param pulumi.Input[str] image_id: Specifies the image ID of the desired image for the IEC server. Changing
               this parameter creates a new IEC server resource.
        :param pulumi.Input[str] image_name: The image name of the IEC server.
        :param pulumi.Input[str] key_pair: Specifies the name of a key pair to put on the IEC server. The key pair must
               already be created and associated with the tenant's account. This parameter and `admin_pass` are alternative. Changing
               this parameter creates a new IEC server resource.
        :param pulumi.Input[str] name: Specifies the IEC server name. This parameter can contain a maximum of 64
               characters, which may consist of letters, digits, dot(.), underscores (_), and hyphens (-). Changing this parameter
               creates a new IEC server resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerNicArgs']]]] nics: An array of one or more networks to attach to the IEC server. The object structure is documented below.
        :param pulumi.Input[str] origin_server_id: The ID of origin server.
        :param pulumi.Input[str] public_ip: The EIP address that is associted to the IEC server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: Specifies an array of one or more security group IDs to associate with
               the IEC server. Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[str] status: The status of IEC server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: Specifies an array of one or more subnet ID of Network for the IEC server
               binding. Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[str] system_disk_id: The system disk voume ID.
        :param pulumi.Input[int] system_disk_size: Specifies the size of system disk for the IEC server binding. The
               value range is 40 to 100 in GB. Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[str] system_disk_type: Specifies the type of system disk for the IEC server binding. Valid
               value is *SAS*(high I/O disk type). Changing this parameter creates a new IEC server resource.
        :param pulumi.Input[str] user_data: Specifies the user data (information after encoding) configured during IEC
               server creation. The value can come from a variety of sources: inline, read in from the *file* function. Changing this
               parameter creates a new IEC server resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerVolumeAttachedArgs']]]] volume_attacheds: An array of one or more disks to attach to the IEC server. The object structure is documented
               below.
        :param pulumi.Input[str] vpc_id: Specifies the ID of vpc for the IEC server. VPC mode only *CUSTOMER* can be
               used to create IEC server. Changing this parameter creates a new IEC server resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerState.__new__(_ServerState)

        __props__.__dict__["admin_pass"] = admin_pass
        __props__.__dict__["bind_eip"] = bind_eip
        __props__.__dict__["coverage_level"] = coverage_level
        __props__.__dict__["coverage_policy"] = coverage_policy
        __props__.__dict__["coverage_sites"] = coverage_sites
        __props__.__dict__["data_disks"] = data_disks
        __props__.__dict__["edgecloud_id"] = edgecloud_id
        __props__.__dict__["edgecloud_name"] = edgecloud_name
        __props__.__dict__["flavor_id"] = flavor_id
        __props__.__dict__["flavor_name"] = flavor_name
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["image_name"] = image_name
        __props__.__dict__["key_pair"] = key_pair
        __props__.__dict__["name"] = name
        __props__.__dict__["nics"] = nics
        __props__.__dict__["origin_server_id"] = origin_server_id
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["system_disk_id"] = system_disk_id
        __props__.__dict__["system_disk_size"] = system_disk_size
        __props__.__dict__["system_disk_type"] = system_disk_type
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["volume_attacheds"] = volume_attacheds
        __props__.__dict__["vpc_id"] = vpc_id
        return Server(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the administrative password to assign to the IEC server. This
        parameter can contain a maximum of 26 characters, which may consist of letters, digits and Special characters(~!?,.:
        ;-_'"(){}[]/<>@#$%^&*+|\\\\=) and space. This parameter and `key_pair` are alternative. Changing this changes the root
        password on the existing server.
        """
        return pulumi.get(self, "admin_pass")

    @property
    @pulumi.getter(name="bindEip")
    def bind_eip(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the IEC server is bound to EIP. Changing this parameter
        creates a new IEC server resource.
        """
        return pulumi.get(self, "bind_eip")

    @property
    @pulumi.getter(name="coverageLevel")
    def coverage_level(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the coverage level of IEC sites. Valid value is *SITE*.
        Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "coverage_level")

    @property
    @pulumi.getter(name="coveragePolicy")
    def coverage_policy(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the policy of IEC sites. Valid values are *centralize*
        and *discrete*, *centralize* is default. Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "coverage_policy")

    @property
    @pulumi.getter(name="coverageSites")
    def coverage_sites(self) -> pulumi.Output[Sequence['outputs.ServerCoverageSite']]:
        """
        Specifies an array of site ID and operator for the IEC server. The
        object structure is documented below. Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "coverage_sites")

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> pulumi.Output[Optional[Sequence['outputs.ServerDataDisk']]]:
        """
        Specifies the array of data disks to attach to the IEC server. Up to two
        data disks can be specified. The object structure is documented below. Changing this parameter creates a new IEC
        server resource.
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="edgecloudId")
    def edgecloud_id(self) -> pulumi.Output[str]:
        """
        The ID of the edgecloud service.
        """
        return pulumi.get(self, "edgecloud_id")

    @property
    @pulumi.getter(name="edgecloudName")
    def edgecloud_name(self) -> pulumi.Output[str]:
        """
        The Name of the edgecloud service.
        """
        return pulumi.get(self, "edgecloud_name")

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[str]:
        """
        Specifies the flavor ID of the desired flavor for the IEC server. Changing
        this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "flavor_id")

    @property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> pulumi.Output[str]:
        """
        The flavor name of the IEC server.
        """
        return pulumi.get(self, "flavor_name")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[str]:
        """
        Specifies the image ID of the desired image for the IEC server. Changing
        this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Output[str]:
        """
        The image name of the IEC server.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the name of a key pair to put on the IEC server. The key pair must
        already be created and associated with the tenant's account. This parameter and `admin_pass` are alternative. Changing
        this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "key_pair")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the IEC server name. This parameter can contain a maximum of 64
        characters, which may consist of letters, digits, dot(.), underscores (_), and hyphens (-). Changing this parameter
        creates a new IEC server resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nics(self) -> pulumi.Output[Sequence['outputs.ServerNic']]:
        """
        An array of one or more networks to attach to the IEC server. The object structure is documented below.
        """
        return pulumi.get(self, "nics")

    @property
    @pulumi.getter(name="originServerId")
    def origin_server_id(self) -> pulumi.Output[str]:
        """
        The ID of origin server.
        """
        return pulumi.get(self, "origin_server_id")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[str]:
        """
        The EIP address that is associted to the IEC server.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies an array of one or more security group IDs to associate with
        the IEC server. Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of IEC server.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies an array of one or more subnet ID of Network for the IEC server
        binding. Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="systemDiskId")
    def system_disk_id(self) -> pulumi.Output[str]:
        """
        The system disk voume ID.
        """
        return pulumi.get(self, "system_disk_id")

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> pulumi.Output[int]:
        """
        Specifies the size of system disk for the IEC server binding. The
        value range is 40 to 100 in GB. Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "system_disk_size")

    @property
    @pulumi.getter(name="systemDiskType")
    def system_disk_type(self) -> pulumi.Output[str]:
        """
        Specifies the type of system disk for the IEC server binding. Valid
        value is *SAS*(high I/O disk type). Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "system_disk_type")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the user data (information after encoding) configured during IEC
        server creation. The value can come from a variety of sources: inline, read in from the *file* function. Changing this
        parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter(name="volumeAttacheds")
    def volume_attacheds(self) -> pulumi.Output[Sequence['outputs.ServerVolumeAttached']]:
        """
        An array of one or more disks to attach to the IEC server. The object structure is documented
        below.
        """
        return pulumi.get(self, "volume_attacheds")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of vpc for the IEC server. VPC mode only *CUSTOMER* can be
        used to create IEC server. Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "vpc_id")

