# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkAclArgs', 'NetworkAcl']

@pulumi.input_type
class NetworkAclArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclNetworkArgs']]]] = None):
        """
        The set of arguments for constructing a NetworkAcl resource.
        :param pulumi.Input[str] description: Specifies the supplementary information about the iec network ACL. This parameter
               can contain a maximum of 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[str] name: Specifies the iec network ACL name. This parameter can contain a maximum of 64 characters,
               which may consist of letters, digits, dot (.), underscores (_), and hyphens (-).
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAclNetworkArgs']]] networks: Specifies an list of one or more networks. The networks object structure is documented
               below.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the supplementary information about the iec network ACL. This parameter
        can contain a maximum of 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the iec network ACL name. This parameter can contain a maximum of 64 characters,
        which may consist of letters, digits, dot (.), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclNetworkArgs']]]]:
        """
        Specifies an list of one or more networks. The networks object structure is documented
        below.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclNetworkArgs']]]]):
        pulumi.set(self, "networks", value)


@pulumi.input_type
class _NetworkAclState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 inbound_rules: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclNetworkArgs']]]] = None,
                 outbound_rules: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering NetworkAcl resources.
        :param pulumi.Input[str] description: Specifies the supplementary information about the iec network ACL. This parameter
               can contain a maximum of 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] inbound_rules: A list of the IDs of ingress rules associated with the iec network ACL.
        :param pulumi.Input[str] name: Specifies the iec network ACL name. This parameter can contain a maximum of 64 characters,
               which may consist of letters, digits, dot (.), underscores (_), and hyphens (-).
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAclNetworkArgs']]] networks: Specifies an list of one or more networks. The networks object structure is documented
               below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] outbound_rules: A list of the IDs of egress rules associated with the iec network ACL.
        :param pulumi.Input[str] status: The status of the iec network ACL.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if inbound_rules is not None:
            pulumi.set(__self__, "inbound_rules", inbound_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if outbound_rules is not None:
            pulumi.set(__self__, "outbound_rules", outbound_rules)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the supplementary information about the iec network ACL. This parameter
        can contain a maximum of 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="inboundRules")
    def inbound_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the IDs of ingress rules associated with the iec network ACL.
        """
        return pulumi.get(self, "inbound_rules")

    @inbound_rules.setter
    def inbound_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "inbound_rules", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the iec network ACL name. This parameter can contain a maximum of 64 characters,
        which may consist of letters, digits, dot (.), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclNetworkArgs']]]]:
        """
        Specifies an list of one or more networks. The networks object structure is documented
        below.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter(name="outboundRules")
    def outbound_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the IDs of egress rules associated with the iec network ACL.
        """
        return pulumi.get(self, "outbound_rules")

    @outbound_rules.setter
    def outbound_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "outbound_rules", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the iec network ACL.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class NetworkAcl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAclNetworkArgs']]]]] = None,
                 __props__=None):
        """
        Manages a network ACL resource within HuaweiCloud IEC.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        iec_vpc_id = config.require_object("iecVpcId")
        iec_subnet_id = config.require_object("iecSubnetId")
        acl_test = huaweicloud.iec.NetworkAcl("aclTest",
            description="This is a network ACL of IEC with networks.",
            networks=[huaweicloud.iec.NetworkAclNetworkArgs(
                vpc_id=iec_vpc_id,
                subnet_id=iec_subnet_id,
            )])
        ```

        ## Import

        Network ACL can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Iec/networkAcl:NetworkAcl acl_test 40b1159c-4e6e-11eb-a00e-fa165c365e51
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Specifies the supplementary information about the iec network ACL. This parameter
               can contain a maximum of 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[str] name: Specifies the iec network ACL name. This parameter can contain a maximum of 64 characters,
               which may consist of letters, digits, dot (.), underscores (_), and hyphens (-).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAclNetworkArgs']]]] networks: Specifies an list of one or more networks. The networks object structure is documented
               below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[NetworkAclArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a network ACL resource within HuaweiCloud IEC.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        iec_vpc_id = config.require_object("iecVpcId")
        iec_subnet_id = config.require_object("iecSubnetId")
        acl_test = huaweicloud.iec.NetworkAcl("aclTest",
            description="This is a network ACL of IEC with networks.",
            networks=[huaweicloud.iec.NetworkAclNetworkArgs(
                vpc_id=iec_vpc_id,
                subnet_id=iec_subnet_id,
            )])
        ```

        ## Import

        Network ACL can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Iec/networkAcl:NetworkAcl acl_test 40b1159c-4e6e-11eb-a00e-fa165c365e51
        ```

        :param str resource_name: The name of the resource.
        :param NetworkAclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkAclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAclNetworkArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkAclArgs.__new__(NetworkAclArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["networks"] = networks
            __props__.__dict__["inbound_rules"] = None
            __props__.__dict__["outbound_rules"] = None
            __props__.__dict__["status"] = None
        super(NetworkAcl, __self__).__init__(
            'huaweicloud:Iec/networkAcl:NetworkAcl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            inbound_rules: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAclNetworkArgs']]]]] = None,
            outbound_rules: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'NetworkAcl':
        """
        Get an existing NetworkAcl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Specifies the supplementary information about the iec network ACL. This parameter
               can contain a maximum of 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] inbound_rules: A list of the IDs of ingress rules associated with the iec network ACL.
        :param pulumi.Input[str] name: Specifies the iec network ACL name. This parameter can contain a maximum of 64 characters,
               which may consist of letters, digits, dot (.), underscores (_), and hyphens (-).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAclNetworkArgs']]]] networks: Specifies an list of one or more networks. The networks object structure is documented
               below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] outbound_rules: A list of the IDs of egress rules associated with the iec network ACL.
        :param pulumi.Input[str] status: The status of the iec network ACL.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkAclState.__new__(_NetworkAclState)

        __props__.__dict__["description"] = description
        __props__.__dict__["inbound_rules"] = inbound_rules
        __props__.__dict__["name"] = name
        __props__.__dict__["networks"] = networks
        __props__.__dict__["outbound_rules"] = outbound_rules
        __props__.__dict__["status"] = status
        return NetworkAcl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the supplementary information about the iec network ACL. This parameter
        can contain a maximum of 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="inboundRules")
    def inbound_rules(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of the IDs of ingress rules associated with the iec network ACL.
        """
        return pulumi.get(self, "inbound_rules")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the iec network ACL name. This parameter can contain a maximum of 64 characters,
        which may consist of letters, digits, dot (.), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Optional[Sequence['outputs.NetworkAclNetwork']]]:
        """
        Specifies an list of one or more networks. The networks object structure is documented
        below.
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter(name="outboundRules")
    def outbound_rules(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of the IDs of egress rules associated with the iec network ACL.
        """
        return pulumi.get(self, "outbound_rules")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the iec network ACL.
        """
        return pulumi.get(self, "status")

