# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetVpcResult',
    'AwaitableGetVpcResult',
    'get_vpc',
    'get_vpc_output',
]

@pulumi.output_type
class GetVpcResult:
    """
    A collection of values returned by getVpc.
    """
    def __init__(__self__, cidr=None, id=None, mode=None, name=None, region=None, subnet_num=None):
        if cidr and not isinstance(cidr, str):
            raise TypeError("Expected argument 'cidr' to be a str")
        pulumi.set(__self__, "cidr", cidr)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if mode and not isinstance(mode, str):
            raise TypeError("Expected argument 'mode' to be a str")
        pulumi.set(__self__, "mode", mode)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if subnet_num and not isinstance(subnet_num, int):
            raise TypeError("Expected argument 'subnet_num' to be a int")
        pulumi.set(__self__, "subnet_num", subnet_num)

    @property
    @pulumi.getter
    def cidr(self) -> str:
        """
        Indicates the IP address range for the VPC.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Indicates the mode of the IEC VPC. Possible values are *SYSTEM* and *CUSTOMER*.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="subnetNum")
    def subnet_num(self) -> int:
        return pulumi.get(self, "subnet_num")


class AwaitableGetVpcResult(GetVpcResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcResult(
            cidr=self.cidr,
            id=self.id,
            mode=self.mode,
            name=self.name,
            region=self.region,
            subnet_num=self.subnet_num)


def get_vpc(id: Optional[str] = None,
            name: Optional[str] = None,
            region: Optional[str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcResult:
    """
    Use this data source to get the details of a specific IEC VPC.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    vpc_name = config.require_object("vpcName")
    my_vpc = huaweicloud.Iec.get_vpc(name=vpc_name)
    ```


    :param str id: Specifies the ID of the IEC VPC to retrieve.
    :param str name: Specifies the name of the IEC VPC. The name can contain a maximum of 64 characters. Only
           letters, digits, underscores (_), hyphens (-), and periods (.) are allowed.
    :param str region: Specifies the region in which to obtain the vpc. If omitted, the provider-level region
           will be used.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Iec/getVpc:getVpc', __args__, opts=opts, typ=GetVpcResult).value

    return AwaitableGetVpcResult(
        cidr=__ret__.cidr,
        id=__ret__.id,
        mode=__ret__.mode,
        name=__ret__.name,
        region=__ret__.region,
        subnet_num=__ret__.subnet_num)


@_utilities.lift_output_func(get_vpc)
def get_vpc_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                   name: Optional[pulumi.Input[Optional[str]]] = None,
                   region: Optional[pulumi.Input[Optional[str]]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVpcResult]:
    """
    Use this data source to get the details of a specific IEC VPC.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    vpc_name = config.require_object("vpcName")
    my_vpc = huaweicloud.Iec.get_vpc(name=vpc_name)
    ```


    :param str id: Specifies the ID of the IEC VPC to retrieve.
    :param str name: Specifies the name of the IEC VPC. The name can contain a maximum of 64 characters. Only
           letters, digits, underscores (_), hyphens (-), and periods (.) are allowed.
    :param str region: Specifies the region in which to obtain the vpc. If omitted, the provider-level region
           will be used.
    """
    ...
