# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetSecurityGroupResult',
    'AwaitableGetSecurityGroupResult',
    'get_security_group',
    'get_security_group_output',
]

@pulumi.output_type
class GetSecurityGroupResult:
    """
    A collection of values returned by getSecurityGroup.
    """
    def __init__(__self__, description=None, id=None, name=None, security_group_rules=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if security_group_rules and not isinstance(security_group_rules, list):
            raise TypeError("Expected argument 'security_group_rules' to be a list")
        pulumi.set(__self__, "security_group_rules", security_group_rules)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description for the IEC security group rules.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="securityGroupRules")
    def security_group_rules(self) -> Sequence['outputs.GetSecurityGroupSecurityGroupRuleResult']:
        """
        An Array of one or more security group rules. The object is documented below.
        """
        return pulumi.get(self, "security_group_rules")


class AwaitableGetSecurityGroupResult(GetSecurityGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityGroupResult(
            description=self.description,
            id=self.id,
            name=self.name,
            security_group_rules=self.security_group_rules)


def get_security_group(name: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityGroupResult:
    """
    Use this data source to get the details of a specific IEC security group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    sg_name = config.require_object("sgName")
    my_sg = huaweicloud.Iec.get_security_group(name=sg_name)
    ```


    :param str name: Specifies the name of the security group with a maximum of 64 characters.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Iec/getSecurityGroup:getSecurityGroup', __args__, opts=opts, typ=GetSecurityGroupResult).value

    return AwaitableGetSecurityGroupResult(
        description=__ret__.description,
        id=__ret__.id,
        name=__ret__.name,
        security_group_rules=__ret__.security_group_rules)


@_utilities.lift_output_func(get_security_group)
def get_security_group_output(name: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSecurityGroupResult]:
    """
    Use this data source to get the details of a specific IEC security group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    sg_name = config.require_object("sgName")
    my_sg = huaweicloud.Iec.get_security_group(name=sg_name)
    ```


    :param str name: Specifies the name of the security group with a maximum of 64 characters.
    """
    ...
