# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['RoleArgs', 'Role']

@pulumi.input_type
class RoleArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 policy: pulumi.Input[str],
                 type: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Role resource.
        :param pulumi.Input[str] description: Description of the custom policy.
        :param pulumi.Input[str] policy: Document of the custom policy in JSON format. For more details, please refer to the
               [offical document](https://support.huaweicloud.com/intl/en-us/usermanual-iam/iam_01_0017.html).
        :param pulumi.Input[str] type: Display mode. Valid options are *AX*: Account level and *XA*: Project level.
        :param pulumi.Input[str] name: Name of the custom policy.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        Description of the custom policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Input[str]:
        """
        Document of the custom policy in JSON format. For more details, please refer to the
        [offical document](https://support.huaweicloud.com/intl/en-us/usermanual-iam/iam_01_0017.html).
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Display mode. Valid options are *AX*: Account level and *XA*: Project level.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the custom policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RoleState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 references: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Role resources.
        :param pulumi.Input[str] description: Description of the custom policy.
        :param pulumi.Input[str] name: Name of the custom policy.
        :param pulumi.Input[str] policy: Document of the custom policy in JSON format. For more details, please refer to the
               [offical document](https://support.huaweicloud.com/intl/en-us/usermanual-iam/iam_01_0017.html).
        :param pulumi.Input[int] references: The number of references.
        :param pulumi.Input[str] type: Display mode. Valid options are *AX*: Account level and *XA*: Project level.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if references is not None:
            pulumi.set(__self__, "references", references)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the custom policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the custom policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        Document of the custom policy in JSON format. For more details, please refer to the
        [offical document](https://support.huaweicloud.com/intl/en-us/usermanual-iam/iam_01_0017.html).
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def references(self) -> Optional[pulumi.Input[int]]:
        """
        The number of references.
        """
        return pulumi.get(self, "references")

    @references.setter
    def references(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "references", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Display mode. Valid options are *AX*: Account level and *XA*: Project level.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class Role(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a **Custom Policy** resource within HuaweiCloud IAM service.

        ->**Note** You *must* have admin privileges in your HuaweiCloud cloud to use this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        role1 = huaweicloud.iam.Role("role1",
            description="created by terraform",
            policy=\"\"\"{
          "Version": "1.1",
          "Statement": [
            {
              "Action": [
                "obs:bucket:GetBucketAcl"
              ],
              "Effect": "Allow",
              "Resource": [
                "obs:*:*:bucket:*"
              ],
              "Condition": {
                "StringStartWith": {
                  "g:ProjectName": [
                    "cn-north-4"
                  ]
                }
              }
            }
          ]
        }

        \"\"\",
            type="AX")
        ```

        ## Import

        Roles can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Iam/role:Role role1 89c60255-9bd6-460c-822a-e2b959ede9d2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the custom policy.
        :param pulumi.Input[str] name: Name of the custom policy.
        :param pulumi.Input[str] policy: Document of the custom policy in JSON format. For more details, please refer to the
               [offical document](https://support.huaweicloud.com/intl/en-us/usermanual-iam/iam_01_0017.html).
        :param pulumi.Input[str] type: Display mode. Valid options are *AX*: Account level and *XA*: Project level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a **Custom Policy** resource within HuaweiCloud IAM service.

        ->**Note** You *must* have admin privileges in your HuaweiCloud cloud to use this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        role1 = huaweicloud.iam.Role("role1",
            description="created by terraform",
            policy=\"\"\"{
          "Version": "1.1",
          "Statement": [
            {
              "Action": [
                "obs:bucket:GetBucketAcl"
              ],
              "Effect": "Allow",
              "Resource": [
                "obs:*:*:bucket:*"
              ],
              "Condition": {
                "StringStartWith": {
                  "g:ProjectName": [
                    "cn-north-4"
                  ]
                }
              }
            }
          ]
        }

        \"\"\",
            type="AX")
        ```

        ## Import

        Roles can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Iam/role:Role role1 89c60255-9bd6-460c-822a-e2b959ede9d2
        ```

        :param str resource_name: The name of the resource.
        :param RoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoleArgs.__new__(RoleArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if policy is None and not opts.urn:
                raise TypeError("Missing required property 'policy'")
            __props__.__dict__["policy"] = policy
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["references"] = None
        super(Role, __self__).__init__(
            'huaweicloud:Iam/role:Role',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            policy: Optional[pulumi.Input[str]] = None,
            references: Optional[pulumi.Input[int]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'Role':
        """
        Get an existing Role resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the custom policy.
        :param pulumi.Input[str] name: Name of the custom policy.
        :param pulumi.Input[str] policy: Document of the custom policy in JSON format. For more details, please refer to the
               [offical document](https://support.huaweicloud.com/intl/en-us/usermanual-iam/iam_01_0017.html).
        :param pulumi.Input[int] references: The number of references.
        :param pulumi.Input[str] type: Display mode. Valid options are *AX*: Account level and *XA*: Project level.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoleState.__new__(_RoleState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["policy"] = policy
        __props__.__dict__["references"] = references
        __props__.__dict__["type"] = type
        return Role(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of the custom policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the custom policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Output[str]:
        """
        Document of the custom policy in JSON format. For more details, please refer to the
        [offical document](https://support.huaweicloud.com/intl/en-us/usermanual-iam/iam_01_0017.html).
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def references(self) -> pulumi.Output[int]:
        """
        The number of references.
        """
        return pulumi.get(self, "references")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Display mode. Valid options are *AX*: Account level and *XA*: Project level.
        """
        return pulumi.get(self, "type")

