# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetRoleResult',
    'AwaitableGetRoleResult',
    'get_role',
    'get_role_output',
]

@pulumi.output_type
class GetRoleResult:
    """
    A collection of values returned by getRole.
    """
    def __init__(__self__, catalog=None, description=None, display_name=None, id=None, name=None, policy=None, type=None):
        if catalog and not isinstance(catalog, str):
            raise TypeError("Expected argument 'catalog' to be a str")
        pulumi.set(__self__, "catalog", catalog)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policy and not isinstance(policy, str):
            raise TypeError("Expected argument 'policy' to be a str")
        pulumi.set(__self__, "policy", policy)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def catalog(self) -> str:
        """
        The service catalog of the policy.
        """
        return pulumi.get(self, "catalog")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def policy(self) -> str:
        """
        The content of the policy.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The display mode of the policy.
        """
        return pulumi.get(self, "type")


class AwaitableGetRoleResult(GetRoleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRoleResult(
            catalog=self.catalog,
            description=self.description,
            display_name=self.display_name,
            id=self.id,
            name=self.name,
            policy=self.policy,
            type=self.type)


def get_role(display_name: Optional[str] = None,
             name: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRoleResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    kms_adm = huaweicloud.Iam.get_role(display_name="KMS Administrator")
    ```


    :param str display_name: Specifies the display name of the role displayed on the console.
           Required if `name` is empty.
    :param str name: Specifies the name of the role for internal use.
           Required if `display_name` is empty.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Iam/getRole:getRole', __args__, opts=opts, typ=GetRoleResult).value

    return AwaitableGetRoleResult(
        catalog=__ret__.catalog,
        description=__ret__.description,
        display_name=__ret__.display_name,
        id=__ret__.id,
        name=__ret__.name,
        policy=__ret__.policy,
        type=__ret__.type)


@_utilities.lift_output_func(get_role)
def get_role_output(display_name: Optional[pulumi.Input[Optional[str]]] = None,
                    name: Optional[pulumi.Input[Optional[str]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRoleResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    kms_adm = huaweicloud.Iam.get_role(display_name="KMS Administrator")
    ```


    :param str display_name: Specifies the display name of the role displayed on the console.
           Required if `name` is empty.
    :param str name: Specifies the name of the role for internal use.
           Required if `display_name` is empty.
    """
    ...
