# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetCustomRoleResult',
    'AwaitableGetCustomRoleResult',
    'get_custom_role',
    'get_custom_role_output',
]

@pulumi.output_type
class GetCustomRoleResult:
    """
    A collection of values returned by getCustomRole.
    """
    def __init__(__self__, catalog=None, description=None, domain_id=None, id=None, name=None, policy=None, references=None, type=None):
        if catalog and not isinstance(catalog, str):
            raise TypeError("Expected argument 'catalog' to be a str")
        pulumi.set(__self__, "catalog", catalog)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain_id and not isinstance(domain_id, str):
            raise TypeError("Expected argument 'domain_id' to be a str")
        pulumi.set(__self__, "domain_id", domain_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policy and not isinstance(policy, str):
            raise TypeError("Expected argument 'policy' to be a str")
        pulumi.set(__self__, "policy", policy)
        if references and not isinstance(references, int):
            raise TypeError("Expected argument 'references' to be a int")
        pulumi.set(__self__, "references", references)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def catalog(self) -> str:
        """
        The catalog of the custom policy.
        """
        return pulumi.get(self, "catalog")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> str:
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def policy(self) -> str:
        """
        Document of the custom policy.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def references(self) -> int:
        return pulumi.get(self, "references")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


class AwaitableGetCustomRoleResult(GetCustomRoleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomRoleResult(
            catalog=self.catalog,
            description=self.description,
            domain_id=self.domain_id,
            id=self.id,
            name=self.name,
            policy=self.policy,
            references=self.references,
            type=self.type)


def get_custom_role(description: Optional[str] = None,
                    domain_id: Optional[str] = None,
                    id: Optional[str] = None,
                    name: Optional[str] = None,
                    references: Optional[int] = None,
                    type: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomRoleResult:
    """
    Use this data source to get the ID of an IAM **custom policy**.

    > You *must* have IAM read privileges to use this data source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    role = huaweicloud.Iam.get_custom_role(name="custom_role")
    ```


    :param str description: Description of the custom policy.
    :param str domain_id: The domain the policy belongs to.
    :param str id: ID of the custom policy.
    :param str name: Name of the custom policy.
    :param int references: The number of citations for the custom policy.
    :param str type: Display mode. Valid options are *AX*: Account level and *XA*: Project level.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['domainId'] = domain_id
    __args__['id'] = id
    __args__['name'] = name
    __args__['references'] = references
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Iam/getCustomRole:getCustomRole', __args__, opts=opts, typ=GetCustomRoleResult).value

    return AwaitableGetCustomRoleResult(
        catalog=__ret__.catalog,
        description=__ret__.description,
        domain_id=__ret__.domain_id,
        id=__ret__.id,
        name=__ret__.name,
        policy=__ret__.policy,
        references=__ret__.references,
        type=__ret__.type)


@_utilities.lift_output_func(get_custom_role)
def get_custom_role_output(description: Optional[pulumi.Input[Optional[str]]] = None,
                           domain_id: Optional[pulumi.Input[Optional[str]]] = None,
                           id: Optional[pulumi.Input[Optional[str]]] = None,
                           name: Optional[pulumi.Input[Optional[str]]] = None,
                           references: Optional[pulumi.Input[Optional[int]]] = None,
                           type: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCustomRoleResult]:
    """
    Use this data source to get the ID of an IAM **custom policy**.

    > You *must* have IAM read privileges to use this data source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    role = huaweicloud.Iam.get_custom_role(name="custom_role")
    ```


    :param str description: Description of the custom policy.
    :param str domain_id: The domain the policy belongs to.
    :param str id: ID of the custom policy.
    :param str name: Name of the custom policy.
    :param int references: The number of citations for the custom policy.
    :param str type: Display mode. Valid options are *AX*: Account level and *XA*: Project level.
    """
    ...
