# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'AclIpCidrArgs',
    'AclIpRangeArgs',
    'AgencyProjectRoleArgs',
    'ProviderAccessConfigArgs',
    'ProviderConversionRuleArgs',
    'ProviderConversionRuleLocalArgs',
    'ProviderConversionRuleRemoteArgs',
]

@pulumi.input_type
class AclIpCidrArgs:
    def __init__(__self__, *,
                 cidr: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cidr: Specifies the IPv4 CIDR block, for example, **192.168.0.0/24**.
        :param pulumi.Input[str] description: Specifies a description about an IP address range. This parameter can contain a
               maximum of 255 characters and the following charactors are not allowed:**@#%^&*<>\\\\**.
        """
        pulumi.set(__self__, "cidr", cidr)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Input[str]:
        """
        Specifies the IPv4 CIDR block, for example, **192.168.0.0/24**.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: pulumi.Input[str]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a description about an IP address range. This parameter can contain a
        maximum of 255 characters and the following charactors are not allowed:**@#%^&*<>\\\\**.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class AclIpRangeArgs:
    def __init__(__self__, *,
                 range: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] range: Specifies the Ip address range, for example, **0.0.0.0-255.255.255.0**.
        :param pulumi.Input[str] description: Specifies a description about an IP address range. This parameter can contain a
               maximum of 255 characters and the following charactors are not allowed:**@#%^&*<>\\\\**.
        """
        pulumi.set(__self__, "range", range)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def range(self) -> pulumi.Input[str]:
        """
        Specifies the Ip address range, for example, **0.0.0.0-255.255.255.0**.
        """
        return pulumi.get(self, "range")

    @range.setter
    def range(self, value: pulumi.Input[str]):
        pulumi.set(self, "range", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a description about an IP address range. This parameter can contain a
        maximum of 255 characters and the following charactors are not allowed:**@#%^&*<>\\\\**.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class AgencyProjectRoleArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[str],
                 roles: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[str] project: Specifies the name of project.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: Specifies an array of role names.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        Specifies the name of project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies an array of role names.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "roles", value)


@pulumi.input_type
class ProviderAccessConfigArgs:
    def __init__(__self__, *,
                 access_type: pulumi.Input[str],
                 client_id: pulumi.Input[str],
                 provider_url: pulumi.Input[str],
                 signing_key: pulumi.Input[str],
                 authorization_endpoint: Optional[pulumi.Input[str]] = None,
                 response_mode: Optional[pulumi.Input[str]] = None,
                 response_type: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] access_type: Specifies the access type of the identity provider.
               Available options are:
               + `program`: programmatic access only.
               + `program_console`: programmatic access and management console access.
        :param pulumi.Input[str] client_id: Specifies the ID of a client registered with the OpenID Connect identity provider.
        :param pulumi.Input[str] provider_url: Specifies the URL of the identity provider.
               This field corresponds to the iss field in the ID token.
        :param pulumi.Input[str] signing_key: Public key used to sign the ID token of the OpenID Connect identity provider.
               This field is required only if the protocol is set to *oidc*.
        :param pulumi.Input[str] authorization_endpoint: Specifies the authorization endpoint of the OpenID Connect identity
               provider. This field is required only if the access type is set to `program_console`.
        :param pulumi.Input[str] response_mode: Response mode.
               Valid values is *form_post* and *fragment*, default value is *form_post*.
               This field is required only if the access type is set to `program_console`.
        :param pulumi.Input[str] response_type: Response type. Valid values is *id_token*, default value is *id_token*.
               This field is required only if the access type is set to `program_console`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: Specifies the scopes of authorization requests. It is an array of one or more scopes.
               Valid values are *openid*, *email*, *profile* and other values defined by you.
               This field is required only if the access type is set to `program_console`.
        """
        pulumi.set(__self__, "access_type", access_type)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "provider_url", provider_url)
        pulumi.set(__self__, "signing_key", signing_key)
        if authorization_endpoint is not None:
            pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        if response_mode is not None:
            pulumi.set(__self__, "response_mode", response_mode)
        if response_type is not None:
            pulumi.set(__self__, "response_type", response_type)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> pulumi.Input[str]:
        """
        Specifies the access type of the identity provider.
        Available options are:
        + `program`: programmatic access only.
        + `program_console`: programmatic access and management console access.
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_type", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of a client registered with the OpenID Connect identity provider.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="providerUrl")
    def provider_url(self) -> pulumi.Input[str]:
        """
        Specifies the URL of the identity provider.
        This field corresponds to the iss field in the ID token.
        """
        return pulumi.get(self, "provider_url")

    @provider_url.setter
    def provider_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider_url", value)

    @property
    @pulumi.getter(name="signingKey")
    def signing_key(self) -> pulumi.Input[str]:
        """
        Public key used to sign the ID token of the OpenID Connect identity provider.
        This field is required only if the protocol is set to *oidc*.
        """
        return pulumi.get(self, "signing_key")

    @signing_key.setter
    def signing_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "signing_key", value)

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the authorization endpoint of the OpenID Connect identity
        provider. This field is required only if the access type is set to `program_console`.
        """
        return pulumi.get(self, "authorization_endpoint")

    @authorization_endpoint.setter
    def authorization_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_endpoint", value)

    @property
    @pulumi.getter(name="responseMode")
    def response_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Response mode.
        Valid values is *form_post* and *fragment*, default value is *form_post*.
        This field is required only if the access type is set to `program_console`.
        """
        return pulumi.get(self, "response_mode")

    @response_mode.setter
    def response_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_mode", value)

    @property
    @pulumi.getter(name="responseType")
    def response_type(self) -> Optional[pulumi.Input[str]]:
        """
        Response type. Valid values is *id_token*, default value is *id_token*.
        This field is required only if the access type is set to `program_console`.
        """
        return pulumi.get(self, "response_type")

    @response_type.setter
    def response_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_type", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the scopes of authorization requests. It is an array of one or more scopes.
        Valid values are *openid*, *email*, *profile* and other values defined by you.
        This field is required only if the access type is set to `program_console`.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scopes", value)


@pulumi.input_type
class ProviderConversionRuleArgs:
    def __init__(__self__, *,
                 locals: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderConversionRuleLocalArgs']]]] = None,
                 remotes: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderConversionRuleRemoteArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ProviderConversionRuleLocalArgs']]] locals: The federated user information on the cloud platform.
        :param pulumi.Input[Sequence[pulumi.Input['ProviderConversionRuleRemoteArgs']]] remotes: The description of the identity provider.
        """
        if locals is not None:
            pulumi.set(__self__, "locals", locals)
        if remotes is not None:
            pulumi.set(__self__, "remotes", remotes)

    @property
    @pulumi.getter
    def locals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProviderConversionRuleLocalArgs']]]]:
        """
        The federated user information on the cloud platform.
        """
        return pulumi.get(self, "locals")

    @locals.setter
    def locals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderConversionRuleLocalArgs']]]]):
        pulumi.set(self, "locals", value)

    @property
    @pulumi.getter
    def remotes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProviderConversionRuleRemoteArgs']]]]:
        """
        The description of the identity provider.
        """
        return pulumi.get(self, "remotes")

    @remotes.setter
    def remotes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderConversionRuleRemoteArgs']]]]):
        pulumi.set(self, "remotes", value)


@pulumi.input_type
class ProviderConversionRuleLocalArgs:
    def __init__(__self__, *,
                 group: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] group: The user group to which the federated user belongs on the cloud platform.
        :param pulumi.Input[str] username: The name of a federated user on the cloud platform.
        """
        if group is not None:
            pulumi.set(__self__, "group", group)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[str]]:
        """
        The user group to which the federated user belongs on the cloud platform.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a federated user on the cloud platform.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class ProviderConversionRuleRemoteArgs:
    def __init__(__self__, *,
                 attribute: Optional[pulumi.Input[str]] = None,
                 condition: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] attribute: The attribute in the IDP assertion.
        :param pulumi.Input[str] condition: The condition of conversion rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: The rule is matched only if the specified strings appear in the attribute type.
        """
        if attribute is not None:
            pulumi.set(__self__, "attribute", attribute)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def attribute(self) -> Optional[pulumi.Input[str]]:
        """
        The attribute in the IDP assertion.
        """
        return pulumi.get(self, "attribute")

    @attribute.setter
    def attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attribute", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[str]]:
        """
        The condition of conversion rule.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The rule is matched only if the specified strings appear in the attribute type.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


