# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetOpengaussInstanceResult',
    'AwaitableGetOpengaussInstanceResult',
    'get_opengauss_instance',
    'get_opengauss_instance_output',
]

@pulumi.output_type
class GetOpengaussInstanceResult:
    """
    A collection of values returned by getOpengaussInstance.
    """
    def __init__(__self__, availability_zone=None, backup_strategies=None, coordinator_num=None, datastores=None, db_user_name=None, enterprise_project_id=None, flavor=None, has=None, id=None, maintenance_window=None, name=None, nodes=None, port=None, private_ips=None, region=None, security_group_id=None, sharding_num=None, status=None, subnet_id=None, switch_strategy=None, time_zone=None, type=None, volumes=None, vpc_id=None):
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_strategies and not isinstance(backup_strategies, list):
            raise TypeError("Expected argument 'backup_strategies' to be a list")
        pulumi.set(__self__, "backup_strategies", backup_strategies)
        if coordinator_num and not isinstance(coordinator_num, int):
            raise TypeError("Expected argument 'coordinator_num' to be a int")
        pulumi.set(__self__, "coordinator_num", coordinator_num)
        if datastores and not isinstance(datastores, list):
            raise TypeError("Expected argument 'datastores' to be a list")
        pulumi.set(__self__, "datastores", datastores)
        if db_user_name and not isinstance(db_user_name, str):
            raise TypeError("Expected argument 'db_user_name' to be a str")
        pulumi.set(__self__, "db_user_name", db_user_name)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor and not isinstance(flavor, str):
            raise TypeError("Expected argument 'flavor' to be a str")
        pulumi.set(__self__, "flavor", flavor)
        if has and not isinstance(has, list):
            raise TypeError("Expected argument 'has' to be a list")
        pulumi.set(__self__, "has", has)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if maintenance_window and not isinstance(maintenance_window, str):
            raise TypeError("Expected argument 'maintenance_window' to be a str")
        pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nodes and not isinstance(nodes, list):
            raise TypeError("Expected argument 'nodes' to be a list")
        pulumi.set(__self__, "nodes", nodes)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if private_ips and not isinstance(private_ips, list):
            raise TypeError("Expected argument 'private_ips' to be a list")
        pulumi.set(__self__, "private_ips", private_ips)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if security_group_id and not isinstance(security_group_id, str):
            raise TypeError("Expected argument 'security_group_id' to be a str")
        pulumi.set(__self__, "security_group_id", security_group_id)
        if sharding_num and not isinstance(sharding_num, int):
            raise TypeError("Expected argument 'sharding_num' to be a int")
        pulumi.set(__self__, "sharding_num", sharding_num)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if switch_strategy and not isinstance(switch_strategy, str):
            raise TypeError("Expected argument 'switch_strategy' to be a str")
        pulumi.set(__self__, "switch_strategy", switch_strategy)
        if time_zone and not isinstance(time_zone, str):
            raise TypeError("Expected argument 'time_zone' to be a str")
        pulumi.set(__self__, "time_zone", time_zone)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if volumes and not isinstance(volumes, list):
            raise TypeError("Expected argument 'volumes' to be a list")
        pulumi.set(__self__, "volumes", volumes)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        Indicates the availability zone where the node resides.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="backupStrategies")
    def backup_strategies(self) -> Sequence['outputs.GetOpengaussInstanceBackupStrategyResult']:
        """
        Indicates the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategies")

    @property
    @pulumi.getter(name="coordinatorNum")
    def coordinator_num(self) -> int:
        """
        Indicates the count of coordinator node.
        """
        return pulumi.get(self, "coordinator_num")

    @property
    @pulumi.getter
    def datastores(self) -> Sequence['outputs.GetOpengaussInstanceDatastoreResult']:
        """
        Indicates the database information. Structure is documented below.
        """
        return pulumi.get(self, "datastores")

    @property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> str:
        """
        Indicates the default username.
        """
        return pulumi.get(self, "db_user_name")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> str:
        """
        Indicates the enterprise project id.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def flavor(self) -> str:
        """
        Indicates the instance specifications.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter
    def has(self) -> Sequence['outputs.GetOpengaussInstanceHaResult']:
        """
        Indicates the instance ha information. Structure is documented below.
        """
        return pulumi.get(self, "has")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> str:
        """
        Indicates the maintenance window.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Indicates the node name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetOpengaussInstanceNodeResult']:
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Indicates the database port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Sequence[str]:
        """
        Indicates the list of private IP address of the nodes.
        """
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        Indicates the security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="shardingNum")
    def sharding_num(self) -> int:
        """
        Indicates the sharding num.
        """
        return pulumi.get(self, "sharding_num")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="switchStrategy")
    def switch_strategy(self) -> str:
        """
        Indicates the switch strategy.
        """
        return pulumi.get(self, "switch_strategy")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        """
        Indicates the default username.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the volume type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetOpengaussInstanceVolumeResult']:
        """
        Indicates the volume information. Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        return pulumi.get(self, "vpc_id")


class AwaitableGetOpengaussInstanceResult(GetOpengaussInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOpengaussInstanceResult(
            availability_zone=self.availability_zone,
            backup_strategies=self.backup_strategies,
            coordinator_num=self.coordinator_num,
            datastores=self.datastores,
            db_user_name=self.db_user_name,
            enterprise_project_id=self.enterprise_project_id,
            flavor=self.flavor,
            has=self.has,
            id=self.id,
            maintenance_window=self.maintenance_window,
            name=self.name,
            nodes=self.nodes,
            port=self.port,
            private_ips=self.private_ips,
            region=self.region,
            security_group_id=self.security_group_id,
            sharding_num=self.sharding_num,
            status=self.status,
            subnet_id=self.subnet_id,
            switch_strategy=self.switch_strategy,
            time_zone=self.time_zone,
            type=self.type,
            volumes=self.volumes,
            vpc_id=self.vpc_id)


def get_opengauss_instance(name: Optional[str] = None,
                           region: Optional[str] = None,
                           subnet_id: Optional[str] = None,
                           vpc_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOpengaussInstanceResult:
    """
    Use this data source to get available HuaweiCloud gaussdb opengauss instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    this = huaweicloud.GaussDBforOpenGauss.get_opengauss_instance(name="gaussdb-instance")
    ```


    :param str name: Specifies the name of the instance.
    :param str region: The region in which to obtain the instance. If omitted, the provider-level region will
           be used.
    :param str subnet_id: Specifies the network ID of a subnet.
    :param str vpc_id: Specifies the VPC ID.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['subnetId'] = subnet_id
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:GaussDBforOpenGauss/getOpengaussInstance:getOpengaussInstance', __args__, opts=opts, typ=GetOpengaussInstanceResult).value

    return AwaitableGetOpengaussInstanceResult(
        availability_zone=__ret__.availability_zone,
        backup_strategies=__ret__.backup_strategies,
        coordinator_num=__ret__.coordinator_num,
        datastores=__ret__.datastores,
        db_user_name=__ret__.db_user_name,
        enterprise_project_id=__ret__.enterprise_project_id,
        flavor=__ret__.flavor,
        has=__ret__.has,
        id=__ret__.id,
        maintenance_window=__ret__.maintenance_window,
        name=__ret__.name,
        nodes=__ret__.nodes,
        port=__ret__.port,
        private_ips=__ret__.private_ips,
        region=__ret__.region,
        security_group_id=__ret__.security_group_id,
        sharding_num=__ret__.sharding_num,
        status=__ret__.status,
        subnet_id=__ret__.subnet_id,
        switch_strategy=__ret__.switch_strategy,
        time_zone=__ret__.time_zone,
        type=__ret__.type,
        volumes=__ret__.volumes,
        vpc_id=__ret__.vpc_id)


@_utilities.lift_output_func(get_opengauss_instance)
def get_opengauss_instance_output(name: Optional[pulumi.Input[Optional[str]]] = None,
                                  region: Optional[pulumi.Input[Optional[str]]] = None,
                                  subnet_id: Optional[pulumi.Input[Optional[str]]] = None,
                                  vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOpengaussInstanceResult]:
    """
    Use this data source to get available HuaweiCloud gaussdb opengauss instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    this = huaweicloud.GaussDBforOpenGauss.get_opengauss_instance(name="gaussdb-instance")
    ```


    :param str name: Specifies the name of the instance.
    :param str region: The region in which to obtain the instance. If omitted, the provider-level region will
           be used.
    :param str subnet_id: Specifies the network ID of a subnet.
    :param str vpc_id: Specifies the VPC ID.
    """
    ...
