# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetCassandraFlavorsResult',
    'AwaitableGetCassandraFlavorsResult',
    'get_cassandra_flavors',
    'get_cassandra_flavors_output',
]

@pulumi.output_type
class GetCassandraFlavorsResult:
    """
    A collection of values returned by getCassandraFlavors.
    """
    def __init__(__self__, flavors=None, id=None, memory=None, region=None, vcpus=None, version=None):
        if flavors and not isinstance(flavors, list):
            raise TypeError("Expected argument 'flavors' to be a list")
        pulumi.set(__self__, "flavors", flavors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if memory and not isinstance(memory, str):
            raise TypeError("Expected argument 'memory' to be a str")
        pulumi.set(__self__, "memory", memory)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if vcpus and not isinstance(vcpus, str):
            raise TypeError("Expected argument 'vcpus' to be a str")
        pulumi.set(__self__, "vcpus", vcpus)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def flavors(self) -> Sequence['outputs.GetCassandraFlavorsFlavorResult']:
        """
        Indicates the flavors information. Structure is documented below.
        """
        return pulumi.get(self, "flavors")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def memory(self) -> Optional[str]:
        """
        Indicates the memory size in GB.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def vcpus(self) -> Optional[str]:
        """
        Indicates the CPU size.
        """
        return pulumi.get(self, "vcpus")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Indicates the database version.
        """
        return pulumi.get(self, "version")


class AwaitableGetCassandraFlavorsResult(GetCassandraFlavorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCassandraFlavorsResult(
            flavors=self.flavors,
            id=self.id,
            memory=self.memory,
            region=self.region,
            vcpus=self.vcpus,
            version=self.version)


def get_cassandra_flavors(memory: Optional[str] = None,
                          region: Optional[str] = None,
                          vcpus: Optional[str] = None,
                          version: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCassandraFlavorsResult:
    """
    Use this data source to get available HuaweiCloud gaussdb cassandra flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    flavors = huaweicloud.GaussDBforNoSQL.get_cassandra_flavors()
    ```


    :param str memory: Specifies the memory size of the flavors.
    :param str region: The region in which to obtain the flavors. If omitted, the provider-level region will be
           used.
    :param str vcpus: Specifies the count of vcpus of the flavors.
    :param str version: Specifies the engine version of the flavors.
    """
    __args__ = dict()
    __args__['memory'] = memory
    __args__['region'] = region
    __args__['vcpus'] = vcpus
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:GaussDBforNoSQL/getCassandraFlavors:getCassandraFlavors', __args__, opts=opts, typ=GetCassandraFlavorsResult).value

    return AwaitableGetCassandraFlavorsResult(
        flavors=__ret__.flavors,
        id=__ret__.id,
        memory=__ret__.memory,
        region=__ret__.region,
        vcpus=__ret__.vcpus,
        version=__ret__.version)


@_utilities.lift_output_func(get_cassandra_flavors)
def get_cassandra_flavors_output(memory: Optional[pulumi.Input[Optional[str]]] = None,
                                 region: Optional[pulumi.Input[Optional[str]]] = None,
                                 vcpus: Optional[pulumi.Input[Optional[str]]] = None,
                                 version: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCassandraFlavorsResult]:
    """
    Use this data source to get available HuaweiCloud gaussdb cassandra flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    flavors = huaweicloud.GaussDBforNoSQL.get_cassandra_flavors()
    ```


    :param str memory: Specifies the memory size of the flavors.
    :param str region: The region in which to obtain the flavors. If omitted, the provider-level region will be
           used.
    :param str vcpus: Specifies the count of vcpus of the flavors.
    :param str version: Specifies the engine version of the flavors.
    """
    ...
