# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetMysqlInstanceResult',
    'AwaitableGetMysqlInstanceResult',
    'get_mysql_instance',
    'get_mysql_instance_output',
]

@pulumi.output_type
class GetMysqlInstanceResult:
    """
    A collection of values returned by getMysqlInstance.
    """
    def __init__(__self__, availability_zone_mode=None, backup_strategies=None, configuration_id=None, datastores=None, db_user_name=None, enterprise_project_id=None, flavor=None, id=None, master_availability_zone=None, mode=None, name=None, nodes=None, port=None, private_write_ip=None, read_replicas=None, region=None, security_group_id=None, status=None, subnet_id=None, time_zone=None, vpc_id=None):
        if availability_zone_mode and not isinstance(availability_zone_mode, str):
            raise TypeError("Expected argument 'availability_zone_mode' to be a str")
        pulumi.set(__self__, "availability_zone_mode", availability_zone_mode)
        if backup_strategies and not isinstance(backup_strategies, list):
            raise TypeError("Expected argument 'backup_strategies' to be a list")
        pulumi.set(__self__, "backup_strategies", backup_strategies)
        if configuration_id and not isinstance(configuration_id, str):
            raise TypeError("Expected argument 'configuration_id' to be a str")
        pulumi.set(__self__, "configuration_id", configuration_id)
        if datastores and not isinstance(datastores, list):
            raise TypeError("Expected argument 'datastores' to be a list")
        pulumi.set(__self__, "datastores", datastores)
        if db_user_name and not isinstance(db_user_name, str):
            raise TypeError("Expected argument 'db_user_name' to be a str")
        pulumi.set(__self__, "db_user_name", db_user_name)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor and not isinstance(flavor, str):
            raise TypeError("Expected argument 'flavor' to be a str")
        pulumi.set(__self__, "flavor", flavor)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if master_availability_zone and not isinstance(master_availability_zone, str):
            raise TypeError("Expected argument 'master_availability_zone' to be a str")
        pulumi.set(__self__, "master_availability_zone", master_availability_zone)
        if mode and not isinstance(mode, str):
            raise TypeError("Expected argument 'mode' to be a str")
        pulumi.set(__self__, "mode", mode)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nodes and not isinstance(nodes, list):
            raise TypeError("Expected argument 'nodes' to be a list")
        pulumi.set(__self__, "nodes", nodes)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if private_write_ip and not isinstance(private_write_ip, str):
            raise TypeError("Expected argument 'private_write_ip' to be a str")
        pulumi.set(__self__, "private_write_ip", private_write_ip)
        if read_replicas and not isinstance(read_replicas, int):
            raise TypeError("Expected argument 'read_replicas' to be a int")
        pulumi.set(__self__, "read_replicas", read_replicas)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if security_group_id and not isinstance(security_group_id, str):
            raise TypeError("Expected argument 'security_group_id' to be a str")
        pulumi.set(__self__, "security_group_id", security_group_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if time_zone and not isinstance(time_zone, str):
            raise TypeError("Expected argument 'time_zone' to be a str")
        pulumi.set(__self__, "time_zone", time_zone)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availabilityZoneMode")
    def availability_zone_mode(self) -> str:
        """
        Indicates the availability zone mode: "single" or "multi".
        """
        return pulumi.get(self, "availability_zone_mode")

    @property
    @pulumi.getter(name="backupStrategies")
    def backup_strategies(self) -> Sequence['outputs.GetMysqlInstanceBackupStrategyResult']:
        """
        Indicates the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategies")

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> str:
        """
        Indicates the configuration ID.
        """
        return pulumi.get(self, "configuration_id")

    @property
    @pulumi.getter
    def datastores(self) -> Sequence['outputs.GetMysqlInstanceDatastoreResult']:
        """
        Indicates the database information. Structure is documented below.
        """
        return pulumi.get(self, "datastores")

    @property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> str:
        """
        Indicates the default username.
        """
        return pulumi.get(self, "db_user_name")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> str:
        """
        Indicates the enterprise project id.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def flavor(self) -> str:
        """
        Indicates the instance specifications.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="masterAvailabilityZone")
    def master_availability_zone(self) -> str:
        """
        Indicates the availability zone where the master node resides.
        """
        return pulumi.get(self, "master_availability_zone")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Indicates the instance mode.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Indicates the node name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetMysqlInstanceNodeResult']:
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Indicates the database port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateWriteIp")
    def private_write_ip(self) -> str:
        """
        Indicates the private IP address of the DB instance.
        """
        return pulumi.get(self, "private_write_ip")

    @property
    @pulumi.getter(name="readReplicas")
    def read_replicas(self) -> int:
        """
        Indicates the count of read replicas.
        """
        return pulumi.get(self, "read_replicas")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        Indicates the security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        """
        Indicates the time zone.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        return pulumi.get(self, "vpc_id")


class AwaitableGetMysqlInstanceResult(GetMysqlInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMysqlInstanceResult(
            availability_zone_mode=self.availability_zone_mode,
            backup_strategies=self.backup_strategies,
            configuration_id=self.configuration_id,
            datastores=self.datastores,
            db_user_name=self.db_user_name,
            enterprise_project_id=self.enterprise_project_id,
            flavor=self.flavor,
            id=self.id,
            master_availability_zone=self.master_availability_zone,
            mode=self.mode,
            name=self.name,
            nodes=self.nodes,
            port=self.port,
            private_write_ip=self.private_write_ip,
            read_replicas=self.read_replicas,
            region=self.region,
            security_group_id=self.security_group_id,
            status=self.status,
            subnet_id=self.subnet_id,
            time_zone=self.time_zone,
            vpc_id=self.vpc_id)


def get_mysql_instance(name: Optional[str] = None,
                       region: Optional[str] = None,
                       subnet_id: Optional[str] = None,
                       vpc_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMysqlInstanceResult:
    """
    Use this data source to get available HuaweiCloud gaussdb mysql instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    this = huaweicloud.GaussDB.get_mysql_instance(name="gaussdb-instance")
    ```


    :param str name: Specifies the name of the instance.
    :param str region: The region in which to obtain the instance. If omitted, the provider-level region will
           be used.
    :param str subnet_id: Specifies the network ID of a subnet.
    :param str vpc_id: Specifies the VPC ID.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['subnetId'] = subnet_id
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:GaussDB/getMysqlInstance:getMysqlInstance', __args__, opts=opts, typ=GetMysqlInstanceResult).value

    return AwaitableGetMysqlInstanceResult(
        availability_zone_mode=__ret__.availability_zone_mode,
        backup_strategies=__ret__.backup_strategies,
        configuration_id=__ret__.configuration_id,
        datastores=__ret__.datastores,
        db_user_name=__ret__.db_user_name,
        enterprise_project_id=__ret__.enterprise_project_id,
        flavor=__ret__.flavor,
        id=__ret__.id,
        master_availability_zone=__ret__.master_availability_zone,
        mode=__ret__.mode,
        name=__ret__.name,
        nodes=__ret__.nodes,
        port=__ret__.port,
        private_write_ip=__ret__.private_write_ip,
        read_replicas=__ret__.read_replicas,
        region=__ret__.region,
        security_group_id=__ret__.security_group_id,
        status=__ret__.status,
        subnet_id=__ret__.subnet_id,
        time_zone=__ret__.time_zone,
        vpc_id=__ret__.vpc_id)


@_utilities.lift_output_func(get_mysql_instance)
def get_mysql_instance_output(name: Optional[pulumi.Input[Optional[str]]] = None,
                              region: Optional[pulumi.Input[Optional[str]]] = None,
                              subnet_id: Optional[pulumi.Input[Optional[str]]] = None,
                              vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMysqlInstanceResult]:
    """
    Use this data source to get available HuaweiCloud gaussdb mysql instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    this = huaweicloud.GaussDB.get_mysql_instance(name="gaussdb-instance")
    ```


    :param str name: Specifies the name of the instance.
    :param str region: The region in which to obtain the instance. If omitted, the provider-level region will
           be used.
    :param str subnet_id: Specifies the network ID of a subnet.
    :param str vpc_id: Specifies the VPC ID.
    """
    ...
