# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetMysqlFlavorsResult',
    'AwaitableGetMysqlFlavorsResult',
    'get_mysql_flavors',
    'get_mysql_flavors_output',
]

@pulumi.output_type
class GetMysqlFlavorsResult:
    """
    A collection of values returned by getMysqlFlavors.
    """
    def __init__(__self__, availability_zone_mode=None, engine=None, flavors=None, id=None, region=None, version=None):
        if availability_zone_mode and not isinstance(availability_zone_mode, str):
            raise TypeError("Expected argument 'availability_zone_mode' to be a str")
        pulumi.set(__self__, "availability_zone_mode", availability_zone_mode)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if flavors and not isinstance(flavors, list):
            raise TypeError("Expected argument 'flavors' to be a list")
        pulumi.set(__self__, "flavors", flavors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="availabilityZoneMode")
    def availability_zone_mode(self) -> Optional[str]:
        return pulumi.get(self, "availability_zone_mode")

    @property
    @pulumi.getter
    def engine(self) -> Optional[str]:
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def flavors(self) -> Sequence['outputs.GetMysqlFlavorsFlavorResult']:
        """
        Indicates the flavors information. Structure is documented below.
        """
        return pulumi.get(self, "flavors")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Indicates the database version.
        """
        return pulumi.get(self, "version")


class AwaitableGetMysqlFlavorsResult(GetMysqlFlavorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMysqlFlavorsResult(
            availability_zone_mode=self.availability_zone_mode,
            engine=self.engine,
            flavors=self.flavors,
            id=self.id,
            region=self.region,
            version=self.version)


def get_mysql_flavors(availability_zone_mode: Optional[str] = None,
                      engine: Optional[str] = None,
                      region: Optional[str] = None,
                      version: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMysqlFlavorsResult:
    """
    Use this data source to get available HuaweiCloud gaussdb mysql flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    flavors = huaweicloud.GaussDB.get_mysql_flavors()
    ```


    :param str availability_zone_mode: Specifies the availability zone mode. Currently support `single` and '
           multi'. Defaults to `single`.
    :param str engine: Specifies the database engine. Only "gaussdb-mysql" is supported now.
    :param str region: The region in which to obtain the flavors. If omitted, the provider-level region will be
           used.
    :param str version: Specifies the database version. Only "8.0" is supported now.
    """
    __args__ = dict()
    __args__['availabilityZoneMode'] = availability_zone_mode
    __args__['engine'] = engine
    __args__['region'] = region
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:GaussDB/getMysqlFlavors:getMysqlFlavors', __args__, opts=opts, typ=GetMysqlFlavorsResult).value

    return AwaitableGetMysqlFlavorsResult(
        availability_zone_mode=__ret__.availability_zone_mode,
        engine=__ret__.engine,
        flavors=__ret__.flavors,
        id=__ret__.id,
        region=__ret__.region,
        version=__ret__.version)


@_utilities.lift_output_func(get_mysql_flavors)
def get_mysql_flavors_output(availability_zone_mode: Optional[pulumi.Input[Optional[str]]] = None,
                             engine: Optional[pulumi.Input[Optional[str]]] = None,
                             region: Optional[pulumi.Input[Optional[str]]] = None,
                             version: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMysqlFlavorsResult]:
    """
    Use this data source to get available HuaweiCloud gaussdb mysql flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    flavors = huaweicloud.GaussDB.get_mysql_flavors()
    ```


    :param str availability_zone_mode: Specifies the availability zone mode. Currently support `single` and '
           multi'. Defaults to `single`.
    :param str engine: Specifies the database engine. Only "gaussdb-mysql" is supported now.
    :param str region: The region in which to obtain the flavors. If omitted, the provider-level region will be
           used.
    :param str version: Specifies the database version. Only "8.0" is supported now.
    """
    ...
