# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DependencyArgs', 'Dependency']

@pulumi.input_type
class DependencyArgs:
    def __init__(__self__, *,
                 link: pulumi.Input[str],
                 runtime: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Dependency resource.
        :param pulumi.Input[str] runtime: Specifies the dependency package runtime.
               The valid values are **Java8**, **Node.js6.10**, **Node.js8.10**, **Node.js10.16**, **Node.js12.13**, **Python2.7**,
               **Python3.6**, **Go1.8**, **Go1.x**, **C#(.NET Core 2.0)**, **C#(.NET Core 2.1)**, **C#(.NET Core 3.1)** and
               **PHP7.3**.
        :param pulumi.Input[str] description: Specifies the dependency description.
               The description can contain a maximum of 512 characters.
        :param pulumi.Input[str] name: Specifies the dependeny name.
               The name can contain a maximum of 96 characters and must start with a letter and end with a letter or digit.
               Only letters, digits, underscores (_), periods (.), and hyphens (-) are allowed.
        :param pulumi.Input[str] region: Specifies the region in which to create a custom dependency package.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        pulumi.set(__self__, "link", link)
        pulumi.set(__self__, "runtime", runtime)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def link(self) -> pulumi.Input[str]:
        return pulumi.get(self, "link")

    @link.setter
    def link(self, value: pulumi.Input[str]):
        pulumi.set(self, "link", value)

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Input[str]:
        """
        Specifies the dependency package runtime.
        The valid values are **Java8**, **Node.js6.10**, **Node.js8.10**, **Node.js10.16**, **Node.js12.13**, **Python2.7**,
        **Python3.6**, **Go1.8**, **Go1.x**, **C#(.NET Core 2.0)**, **C#(.NET Core 2.1)**, **C#(.NET Core 3.1)** and
        **PHP7.3**.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: pulumi.Input[str]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the dependency description.
        The description can contain a maximum of 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the dependeny name.
        The name can contain a maximum of 96 characters and must start with a letter and end with a letter or digit.
        Only letters, digits, underscores (_), periods (.), and hyphens (-) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create a custom dependency package.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DependencyState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 link: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Dependency resources.
        :param pulumi.Input[str] description: Specifies the dependency description.
               The description can contain a maximum of 512 characters.
        :param pulumi.Input[str] etag: The unique ID of the dependency package.
        :param pulumi.Input[str] name: Specifies the dependeny name.
               The name can contain a maximum of 96 characters and must start with a letter and end with a letter or digit.
               Only letters, digits, underscores (_), periods (.), and hyphens (-) are allowed.
        :param pulumi.Input[str] owner: The base64 encoded digest of the dependency after encryption by MD5.
        :param pulumi.Input[str] region: Specifies the region in which to create a custom dependency package.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[str] runtime: Specifies the dependency package runtime.
               The valid values are **Java8**, **Node.js6.10**, **Node.js8.10**, **Node.js10.16**, **Node.js12.13**, **Python2.7**,
               **Python3.6**, **Go1.8**, **Go1.x**, **C#(.NET Core 2.0)**, **C#(.NET Core 2.1)**, **C#(.NET Core 3.1)** and
               **PHP7.3**.
        :param pulumi.Input[int] size: The dependency package size in bytes.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the dependency description.
        The description can contain a maximum of 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        The unique ID of the dependency package.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def link(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "link")

    @link.setter
    def link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "link", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the dependeny name.
        The name can contain a maximum of 96 characters and must start with a letter and end with a letter or digit.
        Only letters, digits, underscores (_), periods (.), and hyphens (-) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[str]]:
        """
        The base64 encoded digest of the dependency after encryption by MD5.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create a custom dependency package.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the dependency package runtime.
        The valid values are **Java8**, **Node.js6.10**, **Node.js8.10**, **Node.js10.16**, **Node.js12.13**, **Python2.7**,
        **Python3.6**, **Go1.8**, **Go1.x**, **C#(.NET Core 2.0)**, **C#(.NET Core 2.1)**, **C#(.NET Core 3.1)** and
        **PHP7.3**.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        The dependency package size in bytes.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)


class Dependency(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 link: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a custom dependency package within HuaweiCloud FunctionGraph.

        ## Example Usage

        ## Import

        Dependencies can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:FunctionGraph/dependency:Dependency test 795e722f-0c23-41b6-a189-dcd56f889cf6
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Specifies the dependency description.
               The description can contain a maximum of 512 characters.
        :param pulumi.Input[str] name: Specifies the dependeny name.
               The name can contain a maximum of 96 characters and must start with a letter and end with a letter or digit.
               Only letters, digits, underscores (_), periods (.), and hyphens (-) are allowed.
        :param pulumi.Input[str] region: Specifies the region in which to create a custom dependency package.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[str] runtime: Specifies the dependency package runtime.
               The valid values are **Java8**, **Node.js6.10**, **Node.js8.10**, **Node.js10.16**, **Node.js12.13**, **Python2.7**,
               **Python3.6**, **Go1.8**, **Go1.x**, **C#(.NET Core 2.0)**, **C#(.NET Core 2.1)**, **C#(.NET Core 3.1)** and
               **PHP7.3**.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DependencyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a custom dependency package within HuaweiCloud FunctionGraph.

        ## Example Usage

        ## Import

        Dependencies can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:FunctionGraph/dependency:Dependency test 795e722f-0c23-41b6-a189-dcd56f889cf6
        ```

        :param str resource_name: The name of the resource.
        :param DependencyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DependencyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 link: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DependencyArgs.__new__(DependencyArgs)

            __props__.__dict__["description"] = description
            if link is None and not opts.urn:
                raise TypeError("Missing required property 'link'")
            __props__.__dict__["link"] = link
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if runtime is None and not opts.urn:
                raise TypeError("Missing required property 'runtime'")
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["etag"] = None
            __props__.__dict__["owner"] = None
            __props__.__dict__["size"] = None
        super(Dependency, __self__).__init__(
            'huaweicloud:FunctionGraph/dependency:Dependency',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            link: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            owner: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            runtime: Optional[pulumi.Input[str]] = None,
            size: Optional[pulumi.Input[int]] = None) -> 'Dependency':
        """
        Get an existing Dependency resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Specifies the dependency description.
               The description can contain a maximum of 512 characters.
        :param pulumi.Input[str] etag: The unique ID of the dependency package.
        :param pulumi.Input[str] name: Specifies the dependeny name.
               The name can contain a maximum of 96 characters and must start with a letter and end with a letter or digit.
               Only letters, digits, underscores (_), periods (.), and hyphens (-) are allowed.
        :param pulumi.Input[str] owner: The base64 encoded digest of the dependency after encryption by MD5.
        :param pulumi.Input[str] region: Specifies the region in which to create a custom dependency package.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[str] runtime: Specifies the dependency package runtime.
               The valid values are **Java8**, **Node.js6.10**, **Node.js8.10**, **Node.js10.16**, **Node.js12.13**, **Python2.7**,
               **Python3.6**, **Go1.8**, **Go1.x**, **C#(.NET Core 2.0)**, **C#(.NET Core 2.1)**, **C#(.NET Core 3.1)** and
               **PHP7.3**.
        :param pulumi.Input[int] size: The dependency package size in bytes.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DependencyState.__new__(_DependencyState)

        __props__.__dict__["description"] = description
        __props__.__dict__["etag"] = etag
        __props__.__dict__["link"] = link
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["region"] = region
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["size"] = size
        return Dependency(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Specifies the dependency description.
        The description can contain a maximum of 512 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        The unique ID of the dependency package.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def link(self) -> pulumi.Output[str]:
        return pulumi.get(self, "link")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the dependeny name.
        The name can contain a maximum of 96 characters and must start with a letter and end with a letter or digit.
        Only letters, digits, underscores (_), periods (.), and hyphens (-) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[str]:
        """
        The base64 encoded digest of the dependency after encryption by MD5.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create a custom dependency package.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[str]:
        """
        Specifies the dependency package runtime.
        The valid values are **Java8**, **Node.js6.10**, **Node.js8.10**, **Node.js10.16**, **Node.js12.13**, **Python2.7**,
        **Python3.6**, **Go1.8**, **Go1.x**, **C#(.NET Core 2.0)**, **C#(.NET Core 2.1)**, **C#(.NET Core 3.1)** and
        **PHP7.3**.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[int]:
        """
        The dependency package size in bytes.
        """
        return pulumi.get(self, "size")

