# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VolumeArgs', 'Volume']

@pulumi.input_type
class VolumeArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[str],
                 volume_type: pulumi.Input[str],
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 backup_id: Optional[pulumi.Input[str]] = None,
                 cascade: Optional[pulumi.Input[bool]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_type: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 kms_id: Optional[pulumi.Input[str]] = None,
                 multiattach: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Volume resource.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone for the disk. Changing this creates
               a new disk.
        :param pulumi.Input[str] volume_type: Specifies the disk type. Currently, the value can be SAS, SSD, GPSSD or
               ESSD.
               + SAS: specifies the high I/O disk type.
               + SSD: specifies the ultra-high I/O disk type.
               + GPSSD: specifies the general purpose SSD disk type.
               + ESSD: Extreme SSD type.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**.
               Changing this creates a new disk.
        :param pulumi.Input[str] backup_id: Specifies the backup ID from which to create the disk. Changing this
               creates a new disk.
        :param pulumi.Input[bool] cascade: Specifies the delete mode of snapshot. The default value is false. All snapshot
               associated with the disk will also be deleted when the parameter is set to true.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the disk.
               The valid values are as follows:
               + **prePaid**: the yearly/monthly billing mode.
               + **postPaid**: the pay-per-use billing mode.
               Changing this creates a new disk.
        :param pulumi.Input[str] description: Specifies the disk description. The value can contain a maximum of 255 bytes.
        :param pulumi.Input[str] device_type: Specifies the device type of disk to create. Valid options are VBD and
               SCSI. Defaults to VBD. Changing this creates a new disk.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the disk. Changing this
               creates a new disk.
        :param pulumi.Input[str] image_id: Specifies the image ID from which to create the disk. Changing this creates
               a new disk.
        :param pulumi.Input[str] kms_id: Specifies the Encryption KMS ID to create the disk. Changing this creates a
               new disk.
        :param pulumi.Input[bool] multiattach: Specifies whether the disk is shareable. The default value is false.
               Changing this creates a new disk.
        :param pulumi.Input[str] name: Specifies the disk name. The value can contain a maximum of 255 bytes.
        :param pulumi.Input[int] period: Specifies the charging period of the disk.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the valid value is 1.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this creates a new disk.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the disk.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this creates a new disk.
        :param pulumi.Input[str] region: Specifies the region in which to create the disk. If omitted, the
               provider-level region will be used. Changing this creates a new disk.
        :param pulumi.Input[int] size: Specifies the disk size, in GB. The valid value is range from:
               + System disk: 1 GB to 1024 GB
               + Data disk: 10 GB to 32768 GB
        :param pulumi.Input[str] snapshot_id: Specifies the snapshot ID from which to create the disk. Changing this
               creates a new disk.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the disk.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "volume_type", volume_type)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if cascade is not None:
            pulumi.set(__self__, "cascade", cascade)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_type is not None:
            pulumi.set(__self__, "device_type", device_type)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if kms_id is not None:
            pulumi.set(__self__, "kms_id", kms_id)
        if multiattach is not None:
            pulumi.set(__self__, "multiattach", multiattach)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[str]:
        """
        Specifies the availability zone for the disk. Changing this creates
        a new disk.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Input[str]:
        """
        Specifies the disk type. Currently, the value can be SAS, SSD, GPSSD or
        ESSD.
        + SAS: specifies the high I/O disk type.
        + SSD: specifies the ultra-high I/O disk type.
        + GPSSD: specifies the general purpose SSD disk type.
        + ESSD: Extreme SSD type.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_type", value)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are **true** and **false**.
        Changing this creates a new disk.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the backup ID from which to create the disk. Changing this
        creates a new disk.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_id", value)

    @property
    @pulumi.getter
    def cascade(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies the delete mode of snapshot. The default value is false. All snapshot
        associated with the disk will also be deleted when the parameter is set to true.
        """
        return pulumi.get(self, "cascade")

    @cascade.setter
    def cascade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cascade", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the disk.
        The valid values are as follows:
        + **prePaid**: the yearly/monthly billing mode.
        + **postPaid**: the pay-per-use billing mode.
        Changing this creates a new disk.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the disk description. The value can contain a maximum of 255 bytes.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the device type of disk to create. Valid options are VBD and
        SCSI. Defaults to VBD. Changing this creates a new disk.
        """
        return pulumi.get(self, "device_type")

    @device_type.setter
    def device_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_type", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the disk. Changing this
        creates a new disk.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the image ID from which to create the disk. Changing this creates
        a new disk.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="kmsId")
    def kms_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Encryption KMS ID to create the disk. Changing this creates a
        new disk.
        """
        return pulumi.get(self, "kms_id")

    @kms_id.setter
    def kms_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_id", value)

    @property
    @pulumi.getter
    def multiattach(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the disk is shareable. The default value is false.
        Changing this creates a new disk.
        """
        return pulumi.get(self, "multiattach")

    @multiattach.setter
    def multiattach(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multiattach", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the disk name. The value can contain a maximum of 255 bytes.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the disk.
        If `period_unit` is set to **month**, the value ranges from 1 to 9.
        If `period_unit` is set to **year**, the valid value is 1.
        This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this creates a new disk.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the disk.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this creates a new disk.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the disk. If omitted, the
        provider-level region will be used. Changing this creates a new disk.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the disk size, in GB. The valid value is range from:
        + System disk: 1 GB to 1024 GB
        + Data disk: 10 GB to 32768 GB
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the snapshot ID from which to create the disk. Changing this
        creates a new disk.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to associate with the disk.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _VolumeState:
    def __init__(__self__, *,
                 attachments: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeAttachmentArgs']]]] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_id: Optional[pulumi.Input[str]] = None,
                 cascade: Optional[pulumi.Input[bool]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_type: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 kms_id: Optional[pulumi.Input[str]] = None,
                 multiattach: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None,
                 wwn: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Volume resources.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeAttachmentArgs']]] attachments: If a disk is attached to an instance, this attribute will display the Attachment ID, Instance ID, and
               the Device as the Instance sees it.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**.
               Changing this creates a new disk.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone for the disk. Changing this creates
               a new disk.
        :param pulumi.Input[str] backup_id: Specifies the backup ID from which to create the disk. Changing this
               creates a new disk.
        :param pulumi.Input[bool] cascade: Specifies the delete mode of snapshot. The default value is false. All snapshot
               associated with the disk will also be deleted when the parameter is set to true.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the disk.
               The valid values are as follows:
               + **prePaid**: the yearly/monthly billing mode.
               + **postPaid**: the pay-per-use billing mode.
               Changing this creates a new disk.
        :param pulumi.Input[str] description: Specifies the disk description. The value can contain a maximum of 255 bytes.
        :param pulumi.Input[str] device_type: Specifies the device type of disk to create. Valid options are VBD and
               SCSI. Defaults to VBD. Changing this creates a new disk.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the disk. Changing this
               creates a new disk.
        :param pulumi.Input[str] image_id: Specifies the image ID from which to create the disk. Changing this creates
               a new disk.
        :param pulumi.Input[str] kms_id: Specifies the Encryption KMS ID to create the disk. Changing this creates a
               new disk.
        :param pulumi.Input[bool] multiattach: Specifies whether the disk is shareable. The default value is false.
               Changing this creates a new disk.
        :param pulumi.Input[str] name: Specifies the disk name. The value can contain a maximum of 255 bytes.
        :param pulumi.Input[int] period: Specifies the charging period of the disk.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the valid value is 1.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this creates a new disk.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the disk.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this creates a new disk.
        :param pulumi.Input[str] region: Specifies the region in which to create the disk. If omitted, the
               provider-level region will be used. Changing this creates a new disk.
        :param pulumi.Input[int] size: Specifies the disk size, in GB. The valid value is range from:
               + System disk: 1 GB to 1024 GB
               + Data disk: 10 GB to 32768 GB
        :param pulumi.Input[str] snapshot_id: Specifies the snapshot ID from which to create the disk. Changing this
               creates a new disk.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the disk.
        :param pulumi.Input[str] volume_type: Specifies the disk type. Currently, the value can be SAS, SSD, GPSSD or
               ESSD.
               + SAS: specifies the high I/O disk type.
               + SSD: specifies the ultra-high I/O disk type.
               + GPSSD: specifies the general purpose SSD disk type.
               + ESSD: Extreme SSD type.
        :param pulumi.Input[str] wwn: The unique identifier used for mounting the EVS disk.
        """
        if attachments is not None:
            pulumi.set(__self__, "attachments", attachments)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if cascade is not None:
            pulumi.set(__self__, "cascade", cascade)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_type is not None:
            pulumi.set(__self__, "device_type", device_type)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if kms_id is not None:
            pulumi.set(__self__, "kms_id", kms_id)
        if multiattach is not None:
            pulumi.set(__self__, "multiattach", multiattach)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)
        if wwn is not None:
            pulumi.set(__self__, "wwn", wwn)

    @property
    @pulumi.getter
    def attachments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeAttachmentArgs']]]]:
        """
        If a disk is attached to an instance, this attribute will display the Attachment ID, Instance ID, and
        the Device as the Instance sees it.
        """
        return pulumi.get(self, "attachments")

    @attachments.setter
    def attachments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeAttachmentArgs']]]]):
        pulumi.set(self, "attachments", value)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are **true** and **false**.
        Changing this creates a new disk.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the availability zone for the disk. Changing this creates
        a new disk.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the backup ID from which to create the disk. Changing this
        creates a new disk.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_id", value)

    @property
    @pulumi.getter
    def cascade(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies the delete mode of snapshot. The default value is false. All snapshot
        associated with the disk will also be deleted when the parameter is set to true.
        """
        return pulumi.get(self, "cascade")

    @cascade.setter
    def cascade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cascade", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the disk.
        The valid values are as follows:
        + **prePaid**: the yearly/monthly billing mode.
        + **postPaid**: the pay-per-use billing mode.
        Changing this creates a new disk.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the disk description. The value can contain a maximum of 255 bytes.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the device type of disk to create. Valid options are VBD and
        SCSI. Defaults to VBD. Changing this creates a new disk.
        """
        return pulumi.get(self, "device_type")

    @device_type.setter
    def device_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_type", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the disk. Changing this
        creates a new disk.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the image ID from which to create the disk. Changing this creates
        a new disk.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="kmsId")
    def kms_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Encryption KMS ID to create the disk. Changing this creates a
        new disk.
        """
        return pulumi.get(self, "kms_id")

    @kms_id.setter
    def kms_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_id", value)

    @property
    @pulumi.getter
    def multiattach(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the disk is shareable. The default value is false.
        Changing this creates a new disk.
        """
        return pulumi.get(self, "multiattach")

    @multiattach.setter
    def multiattach(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multiattach", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the disk name. The value can contain a maximum of 255 bytes.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the disk.
        If `period_unit` is set to **month**, the value ranges from 1 to 9.
        If `period_unit` is set to **year**, the valid value is 1.
        This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this creates a new disk.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the disk.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this creates a new disk.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the disk. If omitted, the
        provider-level region will be used. Changing this creates a new disk.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the disk size, in GB. The valid value is range from:
        + System disk: 1 GB to 1024 GB
        + Data disk: 10 GB to 32768 GB
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the snapshot ID from which to create the disk. Changing this
        creates a new disk.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to associate with the disk.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the disk type. Currently, the value can be SAS, SSD, GPSSD or
        ESSD.
        + SAS: specifies the high I/O disk type.
        + SSD: specifies the ultra-high I/O disk type.
        + GPSSD: specifies the general purpose SSD disk type.
        + ESSD: Extreme SSD type.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)

    @property
    @pulumi.getter
    def wwn(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier used for mounting the EVS disk.
        """
        return pulumi.get(self, "wwn")

    @wwn.setter
    def wwn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wwn", value)


class Volume(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_id: Optional[pulumi.Input[str]] = None,
                 cascade: Optional[pulumi.Input[bool]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_type: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 kms_id: Optional[pulumi.Input[str]] = None,
                 multiattach: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a volume resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        volume = huaweicloud.evs.Volume("volume",
            availability_zone="cn-north-4a",
            description="my volume",
            size=20,
            tags={
                "foo": "bar",
                "key": "value",
            },
            volume_type="SAS")
        ```
        ### With KMS Encryption

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        volume = huaweicloud.evs.Volume("volume",
            description="my volume",
            volume_type="SAS",
            size=20,
            kms_id=var["kms_id"],
            availability_zone="cn-north-4a",
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```

        ## Import

        Volumes can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Evs/volume:Volume volume_1 14a80bc7-c12c-4fe0-a38a-cb77eeac9bd6
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include**cascade**, **period_unit**, **period** and **auto_renew**. It is generally recommended running terraform plan after importing an disk. You can then decide if changes should be applied to the disk, or the resource definition should be updated to align with the disk. Also you can ignore changes as below. resource "huaweicloud_evs_volume" "volume_1" {

         ...

         lifecycle {

         ignore_changes = [

         cascade,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**.
               Changing this creates a new disk.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone for the disk. Changing this creates
               a new disk.
        :param pulumi.Input[str] backup_id: Specifies the backup ID from which to create the disk. Changing this
               creates a new disk.
        :param pulumi.Input[bool] cascade: Specifies the delete mode of snapshot. The default value is false. All snapshot
               associated with the disk will also be deleted when the parameter is set to true.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the disk.
               The valid values are as follows:
               + **prePaid**: the yearly/monthly billing mode.
               + **postPaid**: the pay-per-use billing mode.
               Changing this creates a new disk.
        :param pulumi.Input[str] description: Specifies the disk description. The value can contain a maximum of 255 bytes.
        :param pulumi.Input[str] device_type: Specifies the device type of disk to create. Valid options are VBD and
               SCSI. Defaults to VBD. Changing this creates a new disk.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the disk. Changing this
               creates a new disk.
        :param pulumi.Input[str] image_id: Specifies the image ID from which to create the disk. Changing this creates
               a new disk.
        :param pulumi.Input[str] kms_id: Specifies the Encryption KMS ID to create the disk. Changing this creates a
               new disk.
        :param pulumi.Input[bool] multiattach: Specifies whether the disk is shareable. The default value is false.
               Changing this creates a new disk.
        :param pulumi.Input[str] name: Specifies the disk name. The value can contain a maximum of 255 bytes.
        :param pulumi.Input[int] period: Specifies the charging period of the disk.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the valid value is 1.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this creates a new disk.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the disk.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this creates a new disk.
        :param pulumi.Input[str] region: Specifies the region in which to create the disk. If omitted, the
               provider-level region will be used. Changing this creates a new disk.
        :param pulumi.Input[int] size: Specifies the disk size, in GB. The valid value is range from:
               + System disk: 1 GB to 1024 GB
               + Data disk: 10 GB to 32768 GB
        :param pulumi.Input[str] snapshot_id: Specifies the snapshot ID from which to create the disk. Changing this
               creates a new disk.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the disk.
        :param pulumi.Input[str] volume_type: Specifies the disk type. Currently, the value can be SAS, SSD, GPSSD or
               ESSD.
               + SAS: specifies the high I/O disk type.
               + SSD: specifies the ultra-high I/O disk type.
               + GPSSD: specifies the general purpose SSD disk type.
               + ESSD: Extreme SSD type.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a volume resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        volume = huaweicloud.evs.Volume("volume",
            availability_zone="cn-north-4a",
            description="my volume",
            size=20,
            tags={
                "foo": "bar",
                "key": "value",
            },
            volume_type="SAS")
        ```
        ### With KMS Encryption

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        volume = huaweicloud.evs.Volume("volume",
            description="my volume",
            volume_type="SAS",
            size=20,
            kms_id=var["kms_id"],
            availability_zone="cn-north-4a",
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```

        ## Import

        Volumes can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Evs/volume:Volume volume_1 14a80bc7-c12c-4fe0-a38a-cb77eeac9bd6
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include**cascade**, **period_unit**, **period** and **auto_renew**. It is generally recommended running terraform plan after importing an disk. You can then decide if changes should be applied to the disk, or the resource definition should be updated to align with the disk. Also you can ignore changes as below. resource "huaweicloud_evs_volume" "volume_1" {

         ...

         lifecycle {

         ignore_changes = [

         cascade,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param VolumeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_id: Optional[pulumi.Input[str]] = None,
                 cascade: Optional[pulumi.Input[bool]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_type: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 kms_id: Optional[pulumi.Input[str]] = None,
                 multiattach: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeArgs.__new__(VolumeArgs)

            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            if availability_zone is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone'")
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["backup_id"] = backup_id
            __props__.__dict__["cascade"] = cascade
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["description"] = description
            __props__.__dict__["device_type"] = device_type
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["kms_id"] = kms_id
            __props__.__dict__["multiattach"] = multiattach
            __props__.__dict__["name"] = name
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["region"] = region
            __props__.__dict__["size"] = size
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["tags"] = tags
            if volume_type is None and not opts.urn:
                raise TypeError("Missing required property 'volume_type'")
            __props__.__dict__["volume_type"] = volume_type
            __props__.__dict__["attachments"] = None
            __props__.__dict__["wwn"] = None
        super(Volume, __self__).__init__(
            'huaweicloud:Evs/volume:Volume',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attachments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VolumeAttachmentArgs']]]]] = None,
            auto_pay: Optional[pulumi.Input[str]] = None,
            auto_renew: Optional[pulumi.Input[str]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            backup_id: Optional[pulumi.Input[str]] = None,
            cascade: Optional[pulumi.Input[bool]] = None,
            charging_mode: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            device_type: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            kms_id: Optional[pulumi.Input[str]] = None,
            multiattach: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            size: Optional[pulumi.Input[int]] = None,
            snapshot_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            volume_type: Optional[pulumi.Input[str]] = None,
            wwn: Optional[pulumi.Input[str]] = None) -> 'Volume':
        """
        Get an existing Volume resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VolumeAttachmentArgs']]]] attachments: If a disk is attached to an instance, this attribute will display the Attachment ID, Instance ID, and
               the Device as the Instance sees it.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**.
               Changing this creates a new disk.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone for the disk. Changing this creates
               a new disk.
        :param pulumi.Input[str] backup_id: Specifies the backup ID from which to create the disk. Changing this
               creates a new disk.
        :param pulumi.Input[bool] cascade: Specifies the delete mode of snapshot. The default value is false. All snapshot
               associated with the disk will also be deleted when the parameter is set to true.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the disk.
               The valid values are as follows:
               + **prePaid**: the yearly/monthly billing mode.
               + **postPaid**: the pay-per-use billing mode.
               Changing this creates a new disk.
        :param pulumi.Input[str] description: Specifies the disk description. The value can contain a maximum of 255 bytes.
        :param pulumi.Input[str] device_type: Specifies the device type of disk to create. Valid options are VBD and
               SCSI. Defaults to VBD. Changing this creates a new disk.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the disk. Changing this
               creates a new disk.
        :param pulumi.Input[str] image_id: Specifies the image ID from which to create the disk. Changing this creates
               a new disk.
        :param pulumi.Input[str] kms_id: Specifies the Encryption KMS ID to create the disk. Changing this creates a
               new disk.
        :param pulumi.Input[bool] multiattach: Specifies whether the disk is shareable. The default value is false.
               Changing this creates a new disk.
        :param pulumi.Input[str] name: Specifies the disk name. The value can contain a maximum of 255 bytes.
        :param pulumi.Input[int] period: Specifies the charging period of the disk.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the valid value is 1.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this creates a new disk.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the disk.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this creates a new disk.
        :param pulumi.Input[str] region: Specifies the region in which to create the disk. If omitted, the
               provider-level region will be used. Changing this creates a new disk.
        :param pulumi.Input[int] size: Specifies the disk size, in GB. The valid value is range from:
               + System disk: 1 GB to 1024 GB
               + Data disk: 10 GB to 32768 GB
        :param pulumi.Input[str] snapshot_id: Specifies the snapshot ID from which to create the disk. Changing this
               creates a new disk.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the disk.
        :param pulumi.Input[str] volume_type: Specifies the disk type. Currently, the value can be SAS, SSD, GPSSD or
               ESSD.
               + SAS: specifies the high I/O disk type.
               + SSD: specifies the ultra-high I/O disk type.
               + GPSSD: specifies the general purpose SSD disk type.
               + ESSD: Extreme SSD type.
        :param pulumi.Input[str] wwn: The unique identifier used for mounting the EVS disk.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeState.__new__(_VolumeState)

        __props__.__dict__["attachments"] = attachments
        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["backup_id"] = backup_id
        __props__.__dict__["cascade"] = cascade
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["description"] = description
        __props__.__dict__["device_type"] = device_type
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["kms_id"] = kms_id
        __props__.__dict__["multiattach"] = multiattach
        __props__.__dict__["name"] = name
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["region"] = region
        __props__.__dict__["size"] = size
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["volume_type"] = volume_type
        __props__.__dict__["wwn"] = wwn
        return Volume(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def attachments(self) -> pulumi.Output[Sequence['outputs.VolumeAttachment']]:
        """
        If a disk is attached to an instance, this attribute will display the Attachment ID, Instance ID, and
        the Device as the Instance sees it.
        """
        return pulumi.get(self, "attachments")

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "auto_pay")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are **true** and **false**.
        Changing this creates a new disk.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        Specifies the availability zone for the disk. Changing this creates
        a new disk.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the backup ID from which to create the disk. Changing this
        creates a new disk.
        """
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter
    def cascade(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies the delete mode of snapshot. The default value is false. All snapshot
        associated with the disk will also be deleted when the parameter is set to true.
        """
        return pulumi.get(self, "cascade")

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[str]:
        """
        Specifies the charging mode of the disk.
        The valid values are as follows:
        + **prePaid**: the yearly/monthly billing mode.
        + **postPaid**: the pay-per-use billing mode.
        Changing this creates a new disk.
        """
        return pulumi.get(self, "charging_mode")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the disk description. The value can contain a maximum of 255 bytes.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the device type of disk to create. Valid options are VBD and
        SCSI. Defaults to VBD. Changing this creates a new disk.
        """
        return pulumi.get(self, "device_type")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Specifies the enterprise project id of the disk. Changing this
        creates a new disk.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the image ID from which to create the disk. Changing this creates
        a new disk.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="kmsId")
    def kms_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the Encryption KMS ID to create the disk. Changing this creates a
        new disk.
        """
        return pulumi.get(self, "kms_id")

    @property
    @pulumi.getter
    def multiattach(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the disk is shareable. The default value is false.
        Changing this creates a new disk.
        """
        return pulumi.get(self, "multiattach")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the disk name. The value can contain a maximum of 255 bytes.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the charging period of the disk.
        If `period_unit` is set to **month**, the value ranges from 1 to 9.
        If `period_unit` is set to **year**, the valid value is 1.
        This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this creates a new disk.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the charging period unit of the disk.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this creates a new disk.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the disk. If omitted, the
        provider-level region will be used. Changing this creates a new disk.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[int]:
        """
        Specifies the disk size, in GB. The valid value is range from:
        + System disk: 1 GB to 1024 GB
        + Data disk: 10 GB to 32768 GB
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the snapshot ID from which to create the disk. Changing this
        creates a new disk.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the key/value pairs to associate with the disk.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Output[str]:
        """
        Specifies the disk type. Currently, the value can be SAS, SSD, GPSSD or
        ESSD.
        + SAS: specifies the high I/O disk type.
        + SSD: specifies the ultra-high I/O disk type.
        + GPSSD: specifies the general purpose SSD disk type.
        + ESSD: Extreme SSD type.
        """
        return pulumi.get(self, "volume_type")

    @property
    @pulumi.getter
    def wwn(self) -> pulumi.Output[str]:
        """
        The unique identifier used for mounting the EVS disk.
        """
        return pulumi.get(self, "wwn")

